#ifndef __MENUSYSTEM_H
#define __MENUSYSTEM_H

#include <XBApp.h>
#include <XbResource.h>
#include <XBFont.h>
#include <string>
#include <vector>

#include "xPad.h"

#define MENU_MARGIN_SIZE            4
#define MENU_IMAGE_SIZE             16
#define MENU_SHADOW                 0x11000000


typedef struct tagfRECT { 
    FLOAT    left;    // This is the top-left corner's x-coordinate.
    FLOAT    top;     // The top-left corner's y-coordinate.
    FLOAT    right;   // The bottom-right corner's x-coordinate.
    FLOAT    bottom;  // The bottom-right corner's y-coordinate.
} fRECT;

class CXxPad;

using namespace std;

  // Create our storage for all the menu items...
  //typedef void (*function_ptr)(void);


  struct MENUSUBITEM
  {
    int parent;             // Parent Id/Index
    wstring name;           // The Wide Name/Caption
    int itemId;             // The itemID number (must be unique)
    bool enabled;           // If the item is enabled or not
    bool checked;           // If the item is checked or not
  };




class CXMenuSystem
{

public:
  CXMenuSystem(CXxPad *_parent, DWORD _outlinecolour, DWORD _innercolour, DWORD _fontcolour);
  HRESULT Initialize();
  HRESULT Render();
  HRESULT Cleanup();
  HRESULT FrameMove();
  int GetLastItemId();

  // Menu Management functions
  void AddMenuItem(string name);
  void AddSubMenuItem(MENUSUBITEM subItem);

  // Render Display functions
  void RenderMainMenuItems();
  void RenderSubMenuItems(DWORD color);

  FLOAT GetMaxWidthOfSubItems(int parent_id);
  FLOAT GetTotalHeightOfSubItems(int parent_id);
  int GetSubItemCountForParent(int parent_id);
  MENUSUBITEM* GetSubItemFromId(int itemId);

  int curMainMenu;
  int curMenuLine;

  void ResetMenu();

private:
  //LPDIRECT3DTEXTURE8  m_pMainWindow;
  CXxPad *parent;
	DWORD outlinecolour;
	DWORD innercolor;
	DWORD fontcolour;

  int lastItemId;
  LPDIRECT3DTEXTURE8      m_check;

  fRECT     lastMenuRect;
  DWORD     lastAlphaValue;     


  typedef vector<string> mainItems; 
  typedef vector<MENUSUBITEM> subItems; 
  mainItems menuMainItems;
  subItems menuSubItems;
  void DrawDropShadow(fRECT srcRect);

  void MoveCursorUp(int count = 1);
  bool movingUp;
  bool BeginCursorUpRepeat();

  void MoveCursorDown(int count = 1);
  bool movingDown;
  bool BeginCursorDownRepeat();

  void MoveCursorLeft(int count = 1);
  bool movingLeft;
  bool BeginCursorLeftRepeat();

  void MoveCursorRight(int count = 1);
  bool movingRight;
  bool BeginCursorRightRepeat();

};

#endif  //__MENUSYSTEM_H