#ifndef __KEYPADWINDOW_H
#define __KEYPADWINDOW_H

#include <XBApp.h>
#include <XbResource.h>
#include <XBFont.h>
#include <string>

#include "xPad.h"

class CXxPad;

using namespace std;

class CXKeyPadWindow
{
  struct FILELISTING
  {
    char strPath[MAX_PATH];
    bool isDirectory; 
  };

public:
  CXKeyPadWindow(CXxPad *_parent, FLOAT _top, FLOAT _left, DWORD _outlinecolour, DWORD _innercolour, DWORD _fontcolour);
  HRESULT Initialize();
  HRESULT Render(FLOAT kpX, FLOAT kpY);
  HRESULT Cleanup();
  HRESULT FrameMove();
  char curChar;
  
	enum CntrlMode
	{
		CONTROL_LEFTSTICK,
		CONTROL_DPAD,
    CONTROL_KEYBOARD
	};

	CntrlMode controlMode;

private:
  //LPDIRECT3DTEXTURE8  m_pMainWindow;
  CXxPad *parent;
	FLOAT top;
	FLOAT left;
	DWORD outlinecolour;
	DWORD innercolor;
	DWORD fontcolour;
	enum KpMode
	{
		MODE_LOWER,
		MODE_UPPER,
		MODE_CHARS
	};

	KpMode keyPadMode;

  void DrawBox(float x, float y, int g1, int g2);
  void Draw(double x, double y);
  void RefreshCurChar(int charx, int chary);

  string lowercase;
  string uppercase;
  string specchars;

  double lastKPx;
  double lastKPy;

};

#endif  //__KEYPADWINDOW_H