size_t xbox_mfwrite( const void *buffer, size_t len1, size_t len2, void *st ) ;
size_t xbox_mfread( const void *buffer, size_t len1, size_t len2, void *st ) ;

FILE *statefile = NULL ;
void *statep = NULL ;
int statemode = 0 ;

void banks_save_state() ;
void cpu_save_state() ;
void cpuhand_save_state() ;
void init_save_state() ;
void keyboard_save_state() ;
void mouse_save_state() ;
void paddle_save_state() ;
void pitfall_save_state() ;
void riot_save_state() ;
void soundq_save_state() ;
void starpath_save_state() ;
void tialine_save_state() ;
void tiasnd_save_state() ;
void tiatab_save_state() ;
void trace_save_state() ;

void banks_load_state() ;
void cpu_load_state() ;
void cpuhand_load_state() ;
void init_load_state() ;
void keyboard_load_state() ;
void mouse_load_state() ;
void paddle_load_state() ;
void pitfall_load_state() ;
void riot_load_state() ;
void soundq_load_state() ;
void starpath_load_state() ;
void tialine_load_state() ;
void tiasnd_load_state() ;
void tiatab_load_state() ;
void trace_load_state() ;

unsigned char tval ;
unsigned int lval ;

void save_cvars()
{
	if ( statemode == 0 )
	{
		if ( ScreenBuffer == RealScreenBuffer1 )
		{
			tval = 0 ;
		}
		else if ( ScreenBuffer == RealScreenBuffer2 )
		{
			tval = 1 ;
		}
		else if ( ScreenBuffer == RealScreenBuffer3 )
		{
			tval = 2 ;
		}
		else 
		{
			tval = 3 ;
		}

		fwrite( &tval, 1, sizeof(unsigned char), statefile ) ;

		if ( ScreenBufferPrev == RealScreenBuffer1 )
		{
			tval = 0 ;
		}
		else if ( ScreenBufferPrev == RealScreenBuffer2 )
		{
			tval = 1 ;
		}
		else if ( ScreenBufferPrev == RealScreenBuffer3 )
		{
			tval = 2 ;
		}
		else 
		{
			tval = 3 ;
		}

		fwrite( &tval, 1, sizeof(unsigned char), statefile ) ;

		
		fwrite( msg, 1, 1000, statefile ) ;
		fwrite( CartRom, 1, 0x1000f, statefile ) ;
		fwrite( RiotRam, 1, 128, statefile ) ;
		fwrite( PCXPalette, 1, 384, statefile ) ;
		fwrite( KeyTable, 1, 128, statefile ) ;
		fwrite( SoundQ, 1, 65537, statefile ) ;
		fwrite( RealScreenBuffer1, 1, 65000, statefile ) ;
		fwrite( RealScreenBuffer2, 1, 65000, statefile ) ;
		fwrite( RealScreenBuffer3, 1, 65000, statefile ) ;
		fwrite( RealScreenBuffer4, 1, 65000, statefile ) ;
		fwrite( srv_colortab, 128, sizeof(dd), statefile ) ;

		lval = sizeof(srv_average) ;
		fwrite( srv_average, 1, sizeof(srv_average), statefile ) ;

	//dd srv_average[128][128];


		fwrite( &MessageCode, 1, sizeof(char), statefile);
		fwrite( &SampleByte, 1, sizeof(char), statefile);
		fwrite( &FileOpened, 1, sizeof(int), statefile);
		fwrite( &kv_FilePointer, 1, sizeof(int), statefile);
		fwrite( &kv_SharedData, 1, sizeof(int), statefile);
		fwrite( &kv_Beep, 1, sizeof(int), statefile);
		fwrite( &Ticks, 1, sizeof(int), statefile);
		fwrite( &Flips, 1, sizeof(int), statefile);
		fwrite( &FirstFlipTime, 1, sizeof(int), statefile);
		fwrite( &ThisFlipTime, 1, sizeof(int), statefile);
		fwrite( &LastFlipTime, 1, sizeof(int), statefile);
		fwrite( &LastFlips, 1, sizeof(int), statefile);
		fwrite( &ThisFlips, 1, sizeof(int), statefile);
		fwrite( &CurrentFPS, 1, sizeof(int), statefile);
		fwrite( &odd, 1, sizeof(int), statefile);
		fwrite( &bufsize, 1, sizeof(int), statefile);
		fwrite( &srv_micky_x, 1, sizeof(int), statefile);
		fwrite( &srv_micky_y, 1, sizeof(int), statefile);
		fwrite( &srv_mouse_x, 1, sizeof(int), statefile);
		fwrite( &srv_mouse_y, 1, sizeof(int), statefile);
		fwrite( &srv_crap_x, 1, sizeof(int), statefile);
		fwrite( &srv_crap_y, 1, sizeof(int), statefile);
		fwrite( &kv_SongCounter, 1, sizeof(unsigned long int), statefile);
		fwrite( &xbox_last_x, 1, sizeof(float), statefile);
		fwrite( &xbox_last_y, 1, sizeof(float), statefile);
		fwrite( &xbox_curr_x, 1, sizeof(float), statefile);
		fwrite( &xbox_curr_y, 1, sizeof(float), statefile);
		fwrite( &CartSize, 1, sizeof(dd), statefile);
		fwrite( &Checksum, 1, sizeof(dd), statefile);
		fwrite( &XChecksum, 1, sizeof(dd), statefile);
		fwrite( &LinesInFrame, 1, sizeof(dd), statefile);
		fwrite( &PrevLinesInFrame, 1, sizeof(dd), statefile);
		fwrite( &VBlankOff, 1, sizeof(dd), statefile);
		fwrite( &VBlankOn, 1, sizeof(dd), statefile);
		fwrite( &MaxLines, 1, sizeof(dd), statefile);
		fwrite( &BailoutLine, 1, sizeof(dd), statefile);
		fwrite( &SC_StartAddress, 1, sizeof(dd), statefile);
		fwrite( &crc, 1, sizeof(dd), statefile);
		fwrite( &SQ_Max, 1, sizeof(dd), statefile);
		fwrite( &CFirst, 1, sizeof(dd), statefile);
		fwrite( &NoRetrace, 1, sizeof(dd), statefile);
		fwrite( &OriginalNoRetrace, 1, sizeof(dd), statefile);
		fwrite( &BSType, 1, sizeof(dd), statefile);
		fwrite( &cpu_MAR, 1, sizeof(dd), statefile);
		fwrite( &FrameExit, 1, sizeof(dd), statefile);
		fwrite( &cpu_pc, 1, sizeof(dd), statefile);
		fwrite( &PaddleGame, 1, sizeof(dd), statefile);
		fwrite( &LGadjust, 1, sizeof(dd), statefile);
		fwrite( &UserCFirst, 1, sizeof(dd), statefile);
		fwrite( &DefaultCFirst, 1, sizeof(dd), statefile);
		fwrite( &P0_Pos, 1, sizeof(dd), statefile);
		fwrite( &P1_Pos, 1, sizeof(dd), statefile);
		fwrite( &M0_Pos, 1, sizeof(dd), statefile);
		fwrite( &M1_Pos, 1, sizeof(dd), statefile);
		fwrite( &BL_Pos, 1, sizeof(dd), statefile);
		fwrite( &frame, 1, sizeof(dd), statefile);
		fwrite( &line, 1, sizeof(dd), statefile);
		fwrite( &kv_TapeBusy, 1, sizeof(dd), statefile);
		fwrite( &srv_pitch, 1, sizeof(dd), statefile);
		fwrite( &Vert, 1, sizeof(dd), statefile);
		fwrite( &Horiz, 1, sizeof(dd), statefile);
		fwrite( &Real_Horiz, 1, sizeof(dd), statefile);
		fwrite( &width, 1, sizeof(dd), statefile);
		fwrite( &height, 1, sizeof(dd), statefile);
		fwrite( &Real_width, 1, sizeof(dd), statefile);
		fwrite( &srv_bpp, 1, sizeof(dd), statefile);
		fwrite( &srv_bypp, 1, sizeof(dd), statefile);
		fwrite( &SC_ControlByte, 1, sizeof(db), statefile);
		fwrite( &ShowFPS, 1, sizeof(db), statefile);
		fwrite( &VideoMode, 1, sizeof(db), statefile);
		fwrite( &InWindow, 1, sizeof(db), statefile);
		fwrite( &TrueColor, 1, sizeof(db), statefile);
		fwrite( &quiet, 1, sizeof(db), statefile);
		fwrite( &IOPortA, 1, sizeof(db), statefile);
		fwrite( &IOPortB, 1, sizeof(db), statefile);
		fwrite( &DoChecksum, 1, sizeof(db), statefile);
		fwrite( &dsp, 1, sizeof(db), statefile);
		fwrite( &Joystick, 1, sizeof(db), statefile);
		fwrite( &PaletteNumber, 1, sizeof(db), statefile);
		fwrite( &UserPaletteNumber, 1, sizeof(db), statefile);
		fwrite( &KeyBase, 1, sizeof(db), statefile);
		fwrite( &TraceCount, 1, sizeof(db), statefile);
		fwrite( &TraceEnabled, 1, sizeof(db), statefile);
		fwrite( &OldTraceCount, 1, sizeof(db), statefile);
		fwrite( &KeyPad, 1, sizeof(db), statefile);
		fwrite( &Driving, 1, sizeof(db), statefile);
		fwrite( &MouseBase, 1, sizeof(db), statefile);
		fwrite( &SimColourLoss, 1, sizeof(db), statefile);
		fwrite( &Lightgun, 1, sizeof(db), statefile);
		fwrite( &ShowLineCount, 1, sizeof(db), statefile);
		fwrite( &Mindlink, 1, sizeof(db), statefile);
		fwrite( &AllowAll4, 1, sizeof(db), statefile);
		fwrite( &Effect, 1, sizeof(db), statefile);
		fwrite( &Phosphor, 1, sizeof(db), statefile);
		fwrite( &KidVid, 1, sizeof(db), statefile);
		fwrite( &KidVidTape, 1, sizeof(db), statefile);
		fwrite( &DisableCompareCopy, 1, sizeof(db), statefile);
		fwrite( &DoInterlace, 1, sizeof(db), statefile);
		fwrite( &MouseRude, 1, sizeof(db), statefile);
		fwrite( &KoolAide, 1, sizeof(db), statefile);
		fwrite( &RSBoxing, 1, sizeof(db), statefile);
		fwrite( &MPdirection, 1, sizeof(db), statefile);
		fwrite( &MinVol, 1, sizeof(db), statefile);
		fwrite( &LG_WrapLine, 1, sizeof(db), statefile);
		fwrite( &RROM, 1, sizeof(db), statefile);
		fwrite( &RROM1, 1, sizeof(db), statefile);
		fwrite( &RROM2, 1, sizeof(db), statefile);
		fwrite( &cpu_Rbyte, 1, sizeof(db), statefile);
		fwrite( &cpu_a, 1, sizeof(db), statefile);
		fwrite( &cpu_carry, 1, sizeof(db), statefile);
		fwrite( &cpu_x, 1, sizeof(db), statefile);
		fwrite( &cpu_y, 1, sizeof(db), statefile);
		fwrite( &cpu_sp, 1, sizeof(db), statefile);
		fwrite( &cpu_ZTest, 1, sizeof(db), statefile);
		fwrite( &cpu_NTest, 1, sizeof(db), statefile);
		fwrite( &cpu_D, 1, sizeof(db), statefile);
		fwrite( &cpu_V, 1, sizeof(db), statefile);
		fwrite( &cpu_I, 1, sizeof(db), statefile);
		fwrite( &cpu_B, 1, sizeof(db), statefile);
		fwrite( &cycle, 1, sizeof(db), statefile);
		fwrite( &screen_buffer_count, 1, sizeof(db), statefile);
		fwrite( &srv_done, 1, sizeof(db), statefile);
		fwrite( &srv_mouse_button, 1, sizeof(db), statefile);
		fwrite( &srv_crap_button, 1, sizeof(db), statefile);
	}
	else
	{
#define statefile statep

		if ( ScreenBuffer == RealScreenBuffer1 )
		{
			tval = 0 ;
		}
		else if ( ScreenBuffer == RealScreenBuffer2 )
		{
			tval = 1 ;
		}
		else if ( ScreenBuffer == RealScreenBuffer3 )
		{
			tval = 2 ;
		}
		else 
		{
			tval = 3 ;
		}

		xbox_mfwrite( &tval, 1, sizeof(unsigned char), statefile ) ;

		if ( ScreenBufferPrev == RealScreenBuffer1 )
		{
			tval = 0 ;
		}
		else if ( ScreenBufferPrev == RealScreenBuffer2 )
		{
			tval = 1 ;
		}
		else if ( ScreenBufferPrev == RealScreenBuffer3 )
		{
			tval = 2 ;
		}
		else 
		{
			tval = 3 ;
		}

		xbox_mfwrite( &tval, 1, sizeof(unsigned char), statefile ) ;

		
		xbox_mfwrite( msg, 1, 1000, statefile ) ;
		xbox_mfwrite( CartRom, 1, 0x1000f, statefile ) ;
		xbox_mfwrite( RiotRam, 1, 128, statefile ) ;
		xbox_mfwrite( PCXPalette, 1, 384, statefile ) ;
		xbox_mfwrite( KeyTable, 1, 128, statefile ) ;
		xbox_mfwrite( SoundQ, 1, 65537, statefile ) ;
		xbox_mfwrite( RealScreenBuffer1, 1, 65000, statefile ) ;
		xbox_mfwrite( RealScreenBuffer2, 1, 65000, statefile ) ;
		xbox_mfwrite( RealScreenBuffer3, 1, 65000, statefile ) ;
		xbox_mfwrite( RealScreenBuffer4, 1, 65000, statefile ) ;
		xbox_mfwrite( srv_colortab, 128, sizeof(dd), statefile ) ;

		lval = sizeof(srv_average) ;
		xbox_mfwrite( srv_average, 1, sizeof(srv_average), statefile ) ;

	//dd srv_average[128][128];


		xbox_mfwrite( &MessageCode, 1, sizeof(char), statefile);
		xbox_mfwrite( &SampleByte, 1, sizeof(char), statefile);
		xbox_mfwrite( &FileOpened, 1, sizeof(int), statefile);
		xbox_mfwrite( &kv_FilePointer, 1, sizeof(int), statefile);
		xbox_mfwrite( &kv_SharedData, 1, sizeof(int), statefile);
		xbox_mfwrite( &kv_Beep, 1, sizeof(int), statefile);
		xbox_mfwrite( &Ticks, 1, sizeof(int), statefile);
		xbox_mfwrite( &Flips, 1, sizeof(int), statefile);
		xbox_mfwrite( &FirstFlipTime, 1, sizeof(int), statefile);
		xbox_mfwrite( &ThisFlipTime, 1, sizeof(int), statefile);
		xbox_mfwrite( &LastFlipTime, 1, sizeof(int), statefile);
		xbox_mfwrite( &LastFlips, 1, sizeof(int), statefile);
		xbox_mfwrite( &ThisFlips, 1, sizeof(int), statefile);
		xbox_mfwrite( &CurrentFPS, 1, sizeof(int), statefile);
		xbox_mfwrite( &odd, 1, sizeof(int), statefile);
		xbox_mfwrite( &bufsize, 1, sizeof(int), statefile);
		xbox_mfwrite( &srv_micky_x, 1, sizeof(int), statefile);
		xbox_mfwrite( &srv_micky_y, 1, sizeof(int), statefile);
		xbox_mfwrite( &srv_mouse_x, 1, sizeof(int), statefile);
		xbox_mfwrite( &srv_mouse_y, 1, sizeof(int), statefile);
		xbox_mfwrite( &srv_crap_x, 1, sizeof(int), statefile);
		xbox_mfwrite( &srv_crap_y, 1, sizeof(int), statefile);
		xbox_mfwrite( &kv_SongCounter, 1, sizeof(unsigned long int), statefile);
		xbox_mfwrite( &xbox_last_x, 1, sizeof(float), statefile);
		xbox_mfwrite( &xbox_last_y, 1, sizeof(float), statefile);
		xbox_mfwrite( &xbox_curr_x, 1, sizeof(float), statefile);
		xbox_mfwrite( &xbox_curr_y, 1, sizeof(float), statefile);
		xbox_mfwrite( &CartSize, 1, sizeof(dd), statefile);
		xbox_mfwrite( &Checksum, 1, sizeof(dd), statefile);
		xbox_mfwrite( &XChecksum, 1, sizeof(dd), statefile);
		xbox_mfwrite( &LinesInFrame, 1, sizeof(dd), statefile);
		xbox_mfwrite( &PrevLinesInFrame, 1, sizeof(dd), statefile);
		xbox_mfwrite( &VBlankOff, 1, sizeof(dd), statefile);
		xbox_mfwrite( &VBlankOn, 1, sizeof(dd), statefile);
		xbox_mfwrite( &MaxLines, 1, sizeof(dd), statefile);
		xbox_mfwrite( &BailoutLine, 1, sizeof(dd), statefile);
		xbox_mfwrite( &SC_StartAddress, 1, sizeof(dd), statefile);
		xbox_mfwrite( &crc, 1, sizeof(dd), statefile);
		xbox_mfwrite( &SQ_Max, 1, sizeof(dd), statefile);
		xbox_mfwrite( &CFirst, 1, sizeof(dd), statefile);
		xbox_mfwrite( &NoRetrace, 1, sizeof(dd), statefile);
		xbox_mfwrite( &OriginalNoRetrace, 1, sizeof(dd), statefile);
		xbox_mfwrite( &BSType, 1, sizeof(dd), statefile);
		xbox_mfwrite( &cpu_MAR, 1, sizeof(dd), statefile);
		xbox_mfwrite( &FrameExit, 1, sizeof(dd), statefile);
		xbox_mfwrite( &cpu_pc, 1, sizeof(dd), statefile);
		xbox_mfwrite( &PaddleGame, 1, sizeof(dd), statefile);
		xbox_mfwrite( &LGadjust, 1, sizeof(dd), statefile);
		xbox_mfwrite( &UserCFirst, 1, sizeof(dd), statefile);
		xbox_mfwrite( &DefaultCFirst, 1, sizeof(dd), statefile);
		xbox_mfwrite( &P0_Pos, 1, sizeof(dd), statefile);
		xbox_mfwrite( &P1_Pos, 1, sizeof(dd), statefile);
		xbox_mfwrite( &M0_Pos, 1, sizeof(dd), statefile);
		xbox_mfwrite( &M1_Pos, 1, sizeof(dd), statefile);
		xbox_mfwrite( &BL_Pos, 1, sizeof(dd), statefile);
		xbox_mfwrite( &frame, 1, sizeof(dd), statefile);
		xbox_mfwrite( &line, 1, sizeof(dd), statefile);
		xbox_mfwrite( &kv_TapeBusy, 1, sizeof(dd), statefile);
		xbox_mfwrite( &srv_pitch, 1, sizeof(dd), statefile);
		xbox_mfwrite( &Vert, 1, sizeof(dd), statefile);
		xbox_mfwrite( &Horiz, 1, sizeof(dd), statefile);
		xbox_mfwrite( &Real_Horiz, 1, sizeof(dd), statefile);
		xbox_mfwrite( &width, 1, sizeof(dd), statefile);
		xbox_mfwrite( &height, 1, sizeof(dd), statefile);
		xbox_mfwrite( &Real_width, 1, sizeof(dd), statefile);
		xbox_mfwrite( &srv_bpp, 1, sizeof(dd), statefile);
		xbox_mfwrite( &srv_bypp, 1, sizeof(dd), statefile);
		xbox_mfwrite( &SC_ControlByte, 1, sizeof(db), statefile);
		xbox_mfwrite( &ShowFPS, 1, sizeof(db), statefile);
		xbox_mfwrite( &VideoMode, 1, sizeof(db), statefile);
		xbox_mfwrite( &InWindow, 1, sizeof(db), statefile);
		xbox_mfwrite( &TrueColor, 1, sizeof(db), statefile);
		xbox_mfwrite( &quiet, 1, sizeof(db), statefile);
		xbox_mfwrite( &IOPortA, 1, sizeof(db), statefile);
		xbox_mfwrite( &IOPortB, 1, sizeof(db), statefile);
		xbox_mfwrite( &DoChecksum, 1, sizeof(db), statefile);
		xbox_mfwrite( &dsp, 1, sizeof(db), statefile);
		xbox_mfwrite( &Joystick, 1, sizeof(db), statefile);
		xbox_mfwrite( &PaletteNumber, 1, sizeof(db), statefile);
		xbox_mfwrite( &UserPaletteNumber, 1, sizeof(db), statefile);
		xbox_mfwrite( &KeyBase, 1, sizeof(db), statefile);
		xbox_mfwrite( &TraceCount, 1, sizeof(db), statefile);
		xbox_mfwrite( &TraceEnabled, 1, sizeof(db), statefile);
		xbox_mfwrite( &OldTraceCount, 1, sizeof(db), statefile);
		xbox_mfwrite( &KeyPad, 1, sizeof(db), statefile);
		xbox_mfwrite( &Driving, 1, sizeof(db), statefile);
		xbox_mfwrite( &MouseBase, 1, sizeof(db), statefile);
		xbox_mfwrite( &SimColourLoss, 1, sizeof(db), statefile);
		xbox_mfwrite( &Lightgun, 1, sizeof(db), statefile);
		xbox_mfwrite( &ShowLineCount, 1, sizeof(db), statefile);
		xbox_mfwrite( &Mindlink, 1, sizeof(db), statefile);
		xbox_mfwrite( &AllowAll4, 1, sizeof(db), statefile);
		xbox_mfwrite( &Effect, 1, sizeof(db), statefile);
		xbox_mfwrite( &Phosphor, 1, sizeof(db), statefile);
		xbox_mfwrite( &KidVid, 1, sizeof(db), statefile);
		xbox_mfwrite( &KidVidTape, 1, sizeof(db), statefile);
		xbox_mfwrite( &DisableCompareCopy, 1, sizeof(db), statefile);
		xbox_mfwrite( &DoInterlace, 1, sizeof(db), statefile);
		xbox_mfwrite( &MouseRude, 1, sizeof(db), statefile);
		xbox_mfwrite( &KoolAide, 1, sizeof(db), statefile);
		xbox_mfwrite( &RSBoxing, 1, sizeof(db), statefile);
		xbox_mfwrite( &MPdirection, 1, sizeof(db), statefile);
		xbox_mfwrite( &MinVol, 1, sizeof(db), statefile);
		xbox_mfwrite( &LG_WrapLine, 1, sizeof(db), statefile);
		xbox_mfwrite( &RROM, 1, sizeof(db), statefile);
		xbox_mfwrite( &RROM1, 1, sizeof(db), statefile);
		xbox_mfwrite( &RROM2, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_Rbyte, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_a, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_carry, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_x, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_y, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_sp, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_ZTest, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_NTest, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_D, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_V, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_I, 1, sizeof(db), statefile);
		xbox_mfwrite( &cpu_B, 1, sizeof(db), statefile);
		xbox_mfwrite( &cycle, 1, sizeof(db), statefile);
		xbox_mfwrite( &screen_buffer_count, 1, sizeof(db), statefile);
		xbox_mfwrite( &srv_done, 1, sizeof(db), statefile);
		xbox_mfwrite( &srv_mouse_button, 1, sizeof(db), statefile);
		xbox_mfwrite( &srv_crap_button, 1, sizeof(db), statefile);
#undef statefile

	}

}

void load_cvars()
{
	if ( statemode == 0 )
	{
		fread( &tval, 1, sizeof(unsigned char), statefile ) ;

		switch( tval )
		{
			case 0: ScreenBuffer = RealScreenBuffer1 ; break ;
			case 1: ScreenBuffer = RealScreenBuffer2 ; break ;
			case 2: ScreenBuffer = RealScreenBuffer3 ; break ;
			default : ScreenBuffer = RealScreenBuffer4 ; break ;
		}

		fread( &tval, 1, sizeof(unsigned char), statefile ) ;

		switch( tval )
		{
			case 0: ScreenBufferPrev = RealScreenBuffer1 ; break ;
			case 1: ScreenBufferPrev = RealScreenBuffer2 ; break ;
			case 2: ScreenBufferPrev = RealScreenBuffer3 ; break ;
			default : ScreenBufferPrev = RealScreenBuffer4 ; break ;
		}

		fread( msg, 1, 1000, statefile ) ;
		fread( CartRom, 1, 0x1000f, statefile ) ;
		fread( RiotRam, 1, 128, statefile ) ;
		fread( PCXPalette, 1, 384, statefile ) ;
		fread( KeyTable, 1, 128, statefile ) ;
		fread( SoundQ, 1, 65537, statefile ) ;
		fread( RealScreenBuffer1, 1, 65000, statefile ) ;
		fread( RealScreenBuffer2, 1, 65000, statefile ) ;
		fread( RealScreenBuffer3, 1, 65000, statefile ) ;
		fread( RealScreenBuffer4, 1, 65000, statefile ) ;
		fread( srv_colortab, 128, sizeof(dd), statefile ) ;

		lval = sizeof(srv_average) ;
		fread( srv_average, 1, sizeof(srv_average), statefile ) ;


		fread( &MessageCode, 1, sizeof(char), statefile);
		fread( &SampleByte, 1, sizeof(char), statefile);
		fread( &FileOpened, 1, sizeof(int), statefile);
		fread( &kv_FilePointer, 1, sizeof(int), statefile);
		fread( &kv_SharedData, 1, sizeof(int), statefile);
		fread( &kv_Beep, 1, sizeof(int), statefile);
		fread( &Ticks, 1, sizeof(int), statefile);
		fread( &Flips, 1, sizeof(int), statefile);
		fread( &FirstFlipTime, 1, sizeof(int), statefile);
		fread( &ThisFlipTime, 1, sizeof(int), statefile);
		fread( &LastFlipTime, 1, sizeof(int), statefile);
		fread( &LastFlips, 1, sizeof(int), statefile);
		fread( &ThisFlips, 1, sizeof(int), statefile);
		fread( &CurrentFPS, 1, sizeof(int), statefile);
		fread( &odd, 1, sizeof(int), statefile);
		fread( &bufsize, 1, sizeof(int), statefile);
		fread( &srv_micky_x, 1, sizeof(int), statefile);
		fread( &srv_micky_y, 1, sizeof(int), statefile);
		fread( &srv_mouse_x, 1, sizeof(int), statefile);
		fread( &srv_mouse_y, 1, sizeof(int), statefile);
		fread( &srv_crap_x, 1, sizeof(int), statefile);
		fread( &srv_crap_y, 1, sizeof(int), statefile);
		fread( &kv_SongCounter, 1, sizeof(unsigned long int), statefile);
		fread( &xbox_last_x, 1, sizeof(float), statefile);
		fread( &xbox_last_y, 1, sizeof(float), statefile);
		fread( &xbox_curr_x, 1, sizeof(float), statefile);
		fread( &xbox_curr_y, 1, sizeof(float), statefile);
		fread( &CartSize, 1, sizeof(dd), statefile);
		fread( &Checksum, 1, sizeof(dd), statefile);
		fread( &XChecksum, 1, sizeof(dd), statefile);
		fread( &LinesInFrame, 1, sizeof(dd), statefile);
		fread( &PrevLinesInFrame, 1, sizeof(dd), statefile);
		fread( &VBlankOff, 1, sizeof(dd), statefile);
		fread( &VBlankOn, 1, sizeof(dd), statefile);
		fread( &MaxLines, 1, sizeof(dd), statefile);
		fread( &BailoutLine, 1, sizeof(dd), statefile);
		fread( &SC_StartAddress, 1, sizeof(dd), statefile);
		fread( &crc, 1, sizeof(dd), statefile);
		fread( &SQ_Max, 1, sizeof(dd), statefile);
		fread( &CFirst, 1, sizeof(dd), statefile);
		fread( &NoRetrace, 1, sizeof(dd), statefile);
		fread( &OriginalNoRetrace, 1, sizeof(dd), statefile);
		fread( &BSType, 1, sizeof(dd), statefile);
		fread( &cpu_MAR, 1, sizeof(dd), statefile);
		fread( &FrameExit, 1, sizeof(dd), statefile);
		fread( &cpu_pc, 1, sizeof(dd), statefile);
		fread( &PaddleGame, 1, sizeof(dd), statefile);
		fread( &LGadjust, 1, sizeof(dd), statefile);
		fread( &UserCFirst, 1, sizeof(dd), statefile);
		fread( &DefaultCFirst, 1, sizeof(dd), statefile);
		fread( &P0_Pos, 1, sizeof(dd), statefile);
		fread( &P1_Pos, 1, sizeof(dd), statefile);
		fread( &M0_Pos, 1, sizeof(dd), statefile);
		fread( &M1_Pos, 1, sizeof(dd), statefile);
		fread( &BL_Pos, 1, sizeof(dd), statefile);
		fread( &frame, 1, sizeof(dd), statefile);
		fread( &line, 1, sizeof(dd), statefile);
		fread( &kv_TapeBusy, 1, sizeof(dd), statefile);
		fread( &srv_pitch, 1, sizeof(dd), statefile);
		fread( &Vert, 1, sizeof(dd), statefile);
		fread( &Horiz, 1, sizeof(dd), statefile);
		fread( &Real_Horiz, 1, sizeof(dd), statefile);
		fread( &width, 1, sizeof(dd), statefile);
		fread( &height, 1, sizeof(dd), statefile);
		fread( &Real_width, 1, sizeof(dd), statefile);
		fread( &srv_bpp, 1, sizeof(dd), statefile);
		fread( &srv_bypp, 1, sizeof(dd), statefile);
		fread( &SC_ControlByte, 1, sizeof(db), statefile);
		fread( &ShowFPS, 1, sizeof(db), statefile);
		fread( &VideoMode, 1, sizeof(db), statefile);
		fread( &InWindow, 1, sizeof(db), statefile);
		fread( &TrueColor, 1, sizeof(db), statefile);
		fread( &quiet, 1, sizeof(db), statefile);
		fread( &IOPortA, 1, sizeof(db), statefile);
		fread( &IOPortB, 1, sizeof(db), statefile);
		fread( &DoChecksum, 1, sizeof(db), statefile);
		fread( &dsp, 1, sizeof(db), statefile);
		fread( &Joystick, 1, sizeof(db), statefile);
		fread( &PaletteNumber, 1, sizeof(db), statefile);
		fread( &UserPaletteNumber, 1, sizeof(db), statefile);
		fread( &KeyBase, 1, sizeof(db), statefile);
		fread( &TraceCount, 1, sizeof(db), statefile);
		fread( &TraceEnabled, 1, sizeof(db), statefile);
		fread( &OldTraceCount, 1, sizeof(db), statefile);
		fread( &KeyPad, 1, sizeof(db), statefile);
		fread( &Driving, 1, sizeof(db), statefile);
		fread( &MouseBase, 1, sizeof(db), statefile);
		fread( &SimColourLoss, 1, sizeof(db), statefile);
		fread( &Lightgun, 1, sizeof(db), statefile);
		fread( &ShowLineCount, 1, sizeof(db), statefile);
		fread( &Mindlink, 1, sizeof(db), statefile);
		fread( &AllowAll4, 1, sizeof(db), statefile);
		fread( &Effect, 1, sizeof(db), statefile);
		fread( &Phosphor, 1, sizeof(db), statefile);
		fread( &KidVid, 1, sizeof(db), statefile);
		fread( &KidVidTape, 1, sizeof(db), statefile);
		fread( &DisableCompareCopy, 1, sizeof(db), statefile);
		fread( &DoInterlace, 1, sizeof(db), statefile);
		fread( &MouseRude, 1, sizeof(db), statefile);
		fread( &KoolAide, 1, sizeof(db), statefile);
		fread( &RSBoxing, 1, sizeof(db), statefile);
		fread( &MPdirection, 1, sizeof(db), statefile);
		fread( &MinVol, 1, sizeof(db), statefile);
		fread( &LG_WrapLine, 1, sizeof(db), statefile);
		fread( &RROM, 1, sizeof(db), statefile);
		fread( &RROM1, 1, sizeof(db), statefile);
		fread( &RROM2, 1, sizeof(db), statefile);
		fread( &cpu_Rbyte, 1, sizeof(db), statefile);
		fread( &cpu_a, 1, sizeof(db), statefile);
		fread( &cpu_carry, 1, sizeof(db), statefile);
		fread( &cpu_x, 1, sizeof(db), statefile);
		fread( &cpu_y, 1, sizeof(db), statefile);
		fread( &cpu_sp, 1, sizeof(db), statefile);
		fread( &cpu_ZTest, 1, sizeof(db), statefile);
		fread( &cpu_NTest, 1, sizeof(db), statefile);
		fread( &cpu_D, 1, sizeof(db), statefile);
		fread( &cpu_V, 1, sizeof(db), statefile);
		fread( &cpu_I, 1, sizeof(db), statefile);
		fread( &cpu_B, 1, sizeof(db), statefile);
		fread( &cycle, 1, sizeof(db), statefile);
		fread( &screen_buffer_count, 1, sizeof(db), statefile);
		fread( &srv_done, 1, sizeof(db), statefile);
		fread( &srv_mouse_button, 1, sizeof(db), statefile);
		fread( &srv_crap_button, 1, sizeof(db), statefile);
	}
	else
	{
#define statefile statep
#define fread xbox_mfread
		fread( &tval, 1, sizeof(unsigned char), statefile ) ;

		switch( tval )
		{
			case 0: ScreenBuffer = RealScreenBuffer1 ; break ;
			case 1: ScreenBuffer = RealScreenBuffer2 ; break ;
			case 2: ScreenBuffer = RealScreenBuffer3 ; break ;
			default : ScreenBuffer = RealScreenBuffer4 ; break ;
		}

		fread( &tval, 1, sizeof(unsigned char), statefile ) ;

		switch( tval )
		{
			case 0: ScreenBufferPrev = RealScreenBuffer1 ; break ;
			case 1: ScreenBufferPrev = RealScreenBuffer2 ; break ;
			case 2: ScreenBufferPrev = RealScreenBuffer3 ; break ;
			default : ScreenBufferPrev = RealScreenBuffer4 ; break ;
		}

		fread( msg, 1, 1000, statefile ) ;
		fread( CartRom, 1, 0x1000f, statefile ) ;
		fread( RiotRam, 1, 128, statefile ) ;
		fread( PCXPalette, 1, 384, statefile ) ;
		fread( KeyTable, 1, 128, statefile ) ;
		fread( SoundQ, 1, 65537, statefile ) ;
		fread( RealScreenBuffer1, 1, 65000, statefile ) ;
		fread( RealScreenBuffer2, 1, 65000, statefile ) ;
		fread( RealScreenBuffer3, 1, 65000, statefile ) ;
		fread( RealScreenBuffer4, 1, 65000, statefile ) ;
		fread( srv_colortab, 128, sizeof(dd), statefile ) ;

		lval = sizeof(srv_average) ;
		fread( srv_average, 1, sizeof(srv_average), statefile ) ;


		fread( &MessageCode, 1, sizeof(char), statefile);
		fread( &SampleByte, 1, sizeof(char), statefile);
		fread( &FileOpened, 1, sizeof(int), statefile);
		fread( &kv_FilePointer, 1, sizeof(int), statefile);
		fread( &kv_SharedData, 1, sizeof(int), statefile);
		fread( &kv_Beep, 1, sizeof(int), statefile);
		fread( &Ticks, 1, sizeof(int), statefile);
		fread( &Flips, 1, sizeof(int), statefile);
		fread( &FirstFlipTime, 1, sizeof(int), statefile);
		fread( &ThisFlipTime, 1, sizeof(int), statefile);
		fread( &LastFlipTime, 1, sizeof(int), statefile);
		fread( &LastFlips, 1, sizeof(int), statefile);
		fread( &ThisFlips, 1, sizeof(int), statefile);
		fread( &CurrentFPS, 1, sizeof(int), statefile);
		fread( &odd, 1, sizeof(int), statefile);
		fread( &bufsize, 1, sizeof(int), statefile);
		fread( &srv_micky_x, 1, sizeof(int), statefile);
		fread( &srv_micky_y, 1, sizeof(int), statefile);
		fread( &srv_mouse_x, 1, sizeof(int), statefile);
		fread( &srv_mouse_y, 1, sizeof(int), statefile);
		fread( &srv_crap_x, 1, sizeof(int), statefile);
		fread( &srv_crap_y, 1, sizeof(int), statefile);
		fread( &kv_SongCounter, 1, sizeof(unsigned long int), statefile);
		fread( &xbox_last_x, 1, sizeof(float), statefile);
		fread( &xbox_last_y, 1, sizeof(float), statefile);
		fread( &xbox_curr_x, 1, sizeof(float), statefile);
		fread( &xbox_curr_y, 1, sizeof(float), statefile);
		fread( &CartSize, 1, sizeof(dd), statefile);
		fread( &Checksum, 1, sizeof(dd), statefile);
		fread( &XChecksum, 1, sizeof(dd), statefile);
		fread( &LinesInFrame, 1, sizeof(dd), statefile);
		fread( &PrevLinesInFrame, 1, sizeof(dd), statefile);
		fread( &VBlankOff, 1, sizeof(dd), statefile);
		fread( &VBlankOn, 1, sizeof(dd), statefile);
		fread( &MaxLines, 1, sizeof(dd), statefile);
		fread( &BailoutLine, 1, sizeof(dd), statefile);
		fread( &SC_StartAddress, 1, sizeof(dd), statefile);
		fread( &crc, 1, sizeof(dd), statefile);
		fread( &SQ_Max, 1, sizeof(dd), statefile);
		fread( &CFirst, 1, sizeof(dd), statefile);
		fread( &NoRetrace, 1, sizeof(dd), statefile);
		fread( &OriginalNoRetrace, 1, sizeof(dd), statefile);
		fread( &BSType, 1, sizeof(dd), statefile);
		fread( &cpu_MAR, 1, sizeof(dd), statefile);
		fread( &FrameExit, 1, sizeof(dd), statefile);
		fread( &cpu_pc, 1, sizeof(dd), statefile);
		fread( &PaddleGame, 1, sizeof(dd), statefile);
		fread( &LGadjust, 1, sizeof(dd), statefile);
		fread( &UserCFirst, 1, sizeof(dd), statefile);
		fread( &DefaultCFirst, 1, sizeof(dd), statefile);
		fread( &P0_Pos, 1, sizeof(dd), statefile);
		fread( &P1_Pos, 1, sizeof(dd), statefile);
		fread( &M0_Pos, 1, sizeof(dd), statefile);
		fread( &M1_Pos, 1, sizeof(dd), statefile);
		fread( &BL_Pos, 1, sizeof(dd), statefile);
		fread( &frame, 1, sizeof(dd), statefile);
		fread( &line, 1, sizeof(dd), statefile);
		fread( &kv_TapeBusy, 1, sizeof(dd), statefile);
		fread( &srv_pitch, 1, sizeof(dd), statefile);
		fread( &Vert, 1, sizeof(dd), statefile);
		fread( &Horiz, 1, sizeof(dd), statefile);
		fread( &Real_Horiz, 1, sizeof(dd), statefile);
		fread( &width, 1, sizeof(dd), statefile);
		fread( &height, 1, sizeof(dd), statefile);
		fread( &Real_width, 1, sizeof(dd), statefile);
		fread( &srv_bpp, 1, sizeof(dd), statefile);
		fread( &srv_bypp, 1, sizeof(dd), statefile);
		fread( &SC_ControlByte, 1, sizeof(db), statefile);
		fread( &ShowFPS, 1, sizeof(db), statefile);
		fread( &VideoMode, 1, sizeof(db), statefile);
		fread( &InWindow, 1, sizeof(db), statefile);
		fread( &TrueColor, 1, sizeof(db), statefile);
		fread( &quiet, 1, sizeof(db), statefile);
		fread( &IOPortA, 1, sizeof(db), statefile);
		fread( &IOPortB, 1, sizeof(db), statefile);
		fread( &DoChecksum, 1, sizeof(db), statefile);
		fread( &dsp, 1, sizeof(db), statefile);
		fread( &Joystick, 1, sizeof(db), statefile);
		fread( &PaletteNumber, 1, sizeof(db), statefile);
		fread( &UserPaletteNumber, 1, sizeof(db), statefile);
		fread( &KeyBase, 1, sizeof(db), statefile);
		fread( &TraceCount, 1, sizeof(db), statefile);
		fread( &TraceEnabled, 1, sizeof(db), statefile);
		fread( &OldTraceCount, 1, sizeof(db), statefile);
		fread( &KeyPad, 1, sizeof(db), statefile);
		fread( &Driving, 1, sizeof(db), statefile);
		fread( &MouseBase, 1, sizeof(db), statefile);
		fread( &SimColourLoss, 1, sizeof(db), statefile);
		fread( &Lightgun, 1, sizeof(db), statefile);
		fread( &ShowLineCount, 1, sizeof(db), statefile);
		fread( &Mindlink, 1, sizeof(db), statefile);
		fread( &AllowAll4, 1, sizeof(db), statefile);
		fread( &Effect, 1, sizeof(db), statefile);
		fread( &Phosphor, 1, sizeof(db), statefile);
		fread( &KidVid, 1, sizeof(db), statefile);
		fread( &KidVidTape, 1, sizeof(db), statefile);
		fread( &DisableCompareCopy, 1, sizeof(db), statefile);
		fread( &DoInterlace, 1, sizeof(db), statefile);
		fread( &MouseRude, 1, sizeof(db), statefile);
		fread( &KoolAide, 1, sizeof(db), statefile);
		fread( &RSBoxing, 1, sizeof(db), statefile);
		fread( &MPdirection, 1, sizeof(db), statefile);
		fread( &MinVol, 1, sizeof(db), statefile);
		fread( &LG_WrapLine, 1, sizeof(db), statefile);
		fread( &RROM, 1, sizeof(db), statefile);
		fread( &RROM1, 1, sizeof(db), statefile);
		fread( &RROM2, 1, sizeof(db), statefile);
		fread( &cpu_Rbyte, 1, sizeof(db), statefile);
		fread( &cpu_a, 1, sizeof(db), statefile);
		fread( &cpu_carry, 1, sizeof(db), statefile);
		fread( &cpu_x, 1, sizeof(db), statefile);
		fread( &cpu_y, 1, sizeof(db), statefile);
		fread( &cpu_sp, 1, sizeof(db), statefile);
		fread( &cpu_ZTest, 1, sizeof(db), statefile);
		fread( &cpu_NTest, 1, sizeof(db), statefile);
		fread( &cpu_D, 1, sizeof(db), statefile);
		fread( &cpu_V, 1, sizeof(db), statefile);
		fread( &cpu_I, 1, sizeof(db), statefile);
		fread( &cpu_B, 1, sizeof(db), statefile);
		fread( &cycle, 1, sizeof(db), statefile);
		fread( &screen_buffer_count, 1, sizeof(db), statefile);
		fread( &srv_done, 1, sizeof(db), statefile);
		fread( &srv_mouse_button, 1, sizeof(db), statefile);
		fread( &srv_crap_button, 1, sizeof(db), statefile);
#undef fread
#undef statefile
	}

}


void SaveState( char *filename )
{
	statefile = fopen( filename, "wb" ) ;

	statemode = 0 ;

	if ( statefile )
	{
		save_cvars() ;
		banks_save_state() ;
		cpu_save_state() ;
		cpuhand_save_state() ;
		init_save_state() ;
		keyboard_save_state() ;
		mouse_save_state() ;
		paddle_save_state() ;
		pitfall_save_state() ;
		riot_save_state() ;
		soundq_save_state() ;
		starpath_save_state() ;
		tialine_save_state() ;
		tiasnd_save_state() ;
		tiatab_save_state() ;
		trace_save_state() ;
		
		fclose( statefile ) ;
	}

}

void LoadState( char *filename )
{

	statefile = fopen( filename, "rb" ) ;
	statemode = 0 ;

	if ( statefile )
	{
		load_cvars() ;
		banks_load_state() ;
		cpu_load_state() ;
		cpuhand_load_state() ;
		init_load_state() ;
		keyboard_load_state() ;
		mouse_load_state() ;
		paddle_load_state() ;
		pitfall_load_state() ;
		riot_load_state() ;
		soundq_load_state() ;
		starpath_load_state() ;
		tialine_load_state() ;
		tiasnd_load_state() ;
		tiatab_load_state() ;
		trace_load_state() ;

		fclose( statefile ) ;
	}

}

void SaveStateChunk()
{
	if ( statemode == 0 )
		fwrite( StateChunkPtr, 1, StateChunkSize, statefile ) ;
	else
		xbox_mfwrite( StateChunkPtr, 1, StateChunkSize, statep ) ;
}

void LoadStateChunk()
{
	if ( statemode == 0 )
		fread( StateChunkPtr, 1, StateChunkSize, statefile ) ;
	else
		xbox_mfread( StateChunkPtr, 1, StateChunkSize, statep ) ;
}

void xbox_savestatemem( void *sm )
{
	statep = sm ;
	statemode = 1 ;

		save_cvars() ;
		banks_save_state() ;
		cpu_save_state() ;
		cpuhand_save_state() ;
		init_save_state() ;
		keyboard_save_state() ;
		mouse_save_state() ;
		paddle_save_state() ;
		pitfall_save_state() ;
		riot_save_state() ;
		soundq_save_state() ;
		starpath_save_state() ;
		tialine_save_state() ;
		tiasnd_save_state() ;
		tiatab_save_state() ;
		trace_save_state() ;
}
void xbox_loadstatemem( void *sm )
{
	statep = sm ;
	statemode = 1 ;

		load_cvars() ;
		banks_load_state() ;
		cpu_load_state() ;
		cpuhand_load_state() ;
		init_load_state() ;
		keyboard_load_state() ;
		mouse_load_state() ;
		paddle_load_state() ;
		pitfall_load_state() ;
		riot_load_state() ;
		soundq_load_state() ;
		starpath_load_state() ;
		tialine_load_state() ;
		tiasnd_load_state() ;
		tiatab_load_state() ;
		trace_load_state() ;
}
