;*
;* init.asm -- initialize all data in z26 asm modules
;*
;* 09-02-02 -- 32-bit
;*

; z26 is Copyright 1997-2000 by John Saeger and is a derived work with many
; contributors.	 z26 is released subject to the terms and conditions of the 
; GNU General Public License Version 2 (GPL).  z26 comes with no warranty.
; Please see COPYING.TXT for details.

.data

public _cvar_Frame
_cvar_Frame dd [Frame]

public _cvar_TIA
_cvar_TIA dd TIA

StateChunkValue		dd	0		; a temp variable to store work 


IN_Start label byte			; <-- start clearing hera

;_KeyTable	db	128 dup (?)	; Key pressed table
;_RiotRam		db	128 dup (?)	; RIOT ram (must be initially zero)
TIA		db 	64 dup (?)	; TIA Registers (also should be zero)
_Ram		db	2048 dup (?)	; extra ram

Frame		dd	1 dup (?)	; Frame Counter
PrevFrame	dd	1 dup (?)	; Previous value frame counter

VBlanking	dd	1 dup (?)	; 0 if vblanking, -1 otherwise
VBlank		db	1 dup (?)	; VBlank flag
VSyncFlag	db	1 dup (?)	; VSync flag

ScanLine	dd	1 dup (?)	; current scan line
OurBailoutLine	dd	1 dup (?)	; initial bailout line
					; we fine tune it if exceeded

TopLine		dd	1 dup (?)	; top line of display
BottomLine	dd	1 dup (?)	; bottom line of display

OldCFirst	dd	1 dup (?)	; remember original CFirst
					; (for homing the display)

GamePaused	db	1 dup (?)	; game paused
WByte		db	1 dup (?)	; byte to write

DisplayPointer	dd	1 dup (?)	; pointer into display RAM

IN_End label byte			; <-- finish clearing here


.code

;*
;* routine to do rep stosb to data segment
;*

rep_stosb:
	cmp	ecx,0
	jz	rs_done

rs_loop:
	mov	[edi],al
	inc	edi
	dec	ecx
	jnz	rs_loop

rs_done:
	ret


;*
;* macro to clear memory
;*

clear_mem macro mem_start, mem_finish

	mov	edi,offset mem_start
	mov	ecx,offset mem_finish
	sub	ecx,edi			; # of bytes to clear
	xor	al,al
	call	rep_stosb		; clear memory

	endm

;*
;* initialize data
;*

save_chunk macro mem_start, mem_finish

	push	eax
	push	ebx
	mov	eax,offset mem_start
	mov	[_StateChunkPtr],eax
	mov	ebx,offset mem_finish
	sub	ebx,eax
	mov	[_StateChunkSize],ebx
	call	_SaveStateChunk
	pop	ebx
	pop	eax

	endm

load_chunk macro mem_start, mem_finish

	push	eax
	push	ebx
	mov	eax,offset mem_start
	mov	[_StateChunkPtr],eax
	mov	ebx,offset mem_finish
	sub	ebx,eax
	mov	[_StateChunkSize],ebx
	call	_LoadStateChunk
	pop	ebx
	pop	eax

	endm


save_chunk_dword macro mem_addr

	push	eax
	push	ebx
	mov	eax,offset mem_addr
	mov	[_StateChunkPtr],eax
	mov	[_StateChunkSize],4
	call	_SaveStateChunk
	pop	ebx
	pop	eax

	endm

load_chunk_dword macro mem_addr

	push	eax
	push	ebx
	mov	eax,offset mem_addr
	mov	[_StateChunkPtr],eax
	mov	[_StateChunkSize],4
	call	_LoadStateChunk
	pop	ebx
	pop	eax

	endm

save_chunk_ptr macro mem_addr, mem_base

	mov	eax, [mem_addr]
	sub	eax, [mem_base]
	mov	[StateChunkValue], eax

	save_chunk_dword StateChunkValue

	endm

save_chunk_ptr_offset macro mem_addr, mem_base

	mov	eax, [mem_addr]
	sub	eax, offset mem_base
	mov	[StateChunkValue], eax

	save_chunk_dword StateChunkValue

	endm

load_chunk_ptr macro mem_addr, mem_base

	load_chunk_dword StateChunkValue
	
	mov	eax, [StateChunkValue]
	add	eax, [mem_base]
	mov	[mem_addr], eax


	endm

load_chunk_ptr_offset macro mem_addr, mem_base

	load_chunk_dword StateChunkValue
	
	mov	eax, [StateChunkValue]
	add	eax, offset mem_base
	mov	[mem_addr], eax


	endm

PUBLIC _init_save_state

_init_save_state:
	save_chunk IN_Start, IN_End
	save_chunk_ptr DisplayPointer, _ScreenBuffer

	ret

PUBLIC _init_load_state

_init_load_state:
	load_chunk IN_Start, IN_End
	load_chunk_ptr DisplayPointer, _ScreenBuffer

	ret

InitData:
	clear_mem IN_Start, IN_End

	mov	[OurBailoutLine],1000
	mov	[ScanLine],1
	mov	[VBlanking],-1

;	mov	dword ptr [OldInt9],0
	mov	[CtrlSkipFlag],0

	mov	eax,[_ScreenBuffer]
	mov	[DisplayPointer],eax

	call	_InitCVars
	call	Init_CPU
	call	Init_CPUhand
	call	Init_TIA
	call	Init_Riot
	call	Init_P2
	call	Init_Starpath
	call	Init_Tiasnd
	call	Init_SoundQ

	call	RandomizeRIOTTimer

	ret

