/* creator.c: simple type for storing creator information
   Copyright (c) 2003 Philip Kendall

   $Id: creator.c,v 1.4 2003/10/09 21:37:31 pak21 Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

#include <config.h>

#include <stdio.h>
#include <string.h>

#include "internals.h"

struct libspectrum_creator {

  libspectrum_byte program[32];
  libspectrum_word major, minor;

  libspectrum_dword competition_code;

  libspectrum_byte *custom;
  size_t custom_length;

};

libspectrum_error
libspectrum_creator_alloc( libspectrum_creator **creator )
{
  *creator = malloc( sizeof( libspectrum_creator ) );
  if( !(*creator) ) {
    libspectrum_print_error( LIBSPECTRUM_ERROR_MEMORY,
			     "out of memory in libspectrum_creator_alloc" );
    return LIBSPECTRUM_ERROR_MEMORY;
  }

  (*creator)->custom = NULL;
  (*creator)->custom_length = 0;

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_creator_free( libspectrum_creator *creator )
{
  if( creator->custom ) free( creator->custom );
  free( creator );

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_error
libspectrum_creator_set_program( libspectrum_creator *creator,
				 const libspectrum_byte *program )
{
  memset( creator->program, 0, sizeof( creator->program ) );
  snprintf( creator->program, sizeof( creator->program ), "%s", program );
  return LIBSPECTRUM_ERROR_NONE;
}

const libspectrum_byte*
libspectrum_creator_program( libspectrum_creator *creator )
{
  return creator->program;
}

libspectrum_error libspectrum_creator_set_major( libspectrum_creator *creator,
						 libspectrum_word major )
{
  creator->major = major;
  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_word
libspectrum_creator_major( libspectrum_creator *creator )
{
  return creator->major;
}

libspectrum_error libspectrum_creator_set_minor( libspectrum_creator *creator,
						 libspectrum_word minor )
{
  creator->minor = minor;
  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_word
libspectrum_creator_minor( libspectrum_creator *creator )
{
  return creator->minor;
}

libspectrum_error
libspectrum_creator_set_competition_code( libspectrum_creator *creator,
					  libspectrum_dword competition_code )
{
  creator->competition_code = competition_code;
  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_dword
libspectrum_creator_competition_code( libspectrum_creator *creator )
{
  return creator->competition_code;
}

libspectrum_error
libspectrum_creator_set_custom( libspectrum_creator *creator,
				libspectrum_byte *data, size_t length )
{
  creator->custom = data;
  creator->custom_length = length;
  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_byte*
libspectrum_creator_custom( libspectrum_creator *creator )
{
  return creator->custom;
}

size_t
libspectrum_creator_custom_length( libspectrum_creator *creator )
{
  return creator->custom_length;
}
