/* options.c: options dialog boxes
   Copyright (c) 2001-2004 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/

/* This file is autogenerated from options.dat by options.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef USE_WIDGET

#include <stdio.h>

#include "display.h"
#include "fuse.h"
#include "options.h"
#include "periph.h"
#include "widget_internals.h"

static int widget_general_show_all( settings_info *show );

int widget_general_draw( void *data GCC_UNUSED )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 18 );
  error = widget_general_show_all( &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  widget_display_lines( 2, 2 + 18 );

  return 0;
}

static int widget_general_show_all( settings_info *show )
{
  int error;

  widget_print_title( 16, WIDGET_COLOUR_FOREGROUND, "General Options" );

  error = widget_options_print_entry( 0, "\012E\011mulation speed",
				      show->emulation_speed,
				      "%" );
  if( error ) return error;
  error = widget_options_print_entry( 1, "F\012r\011ame rate (1:n)",
				      show->frame_rate,
				      "frames" );
  if( error ) return error;
  error = widget_options_print_option( 2, "Issue \0122\011 Keyboard",
				       show->issue2 );
  if( error ) return error;

  error = widget_options_print_option( 3, "Use \012t\011ape traps",
				       show->tape_traps );
  if( error ) return error;

  error = widget_options_print_option( 4, "\012F\011astloading",
				       show->fastload );
  if( error ) return error;

  error = widget_options_print_option( 5, "\012D\011etect loaders",
				       show->detect_loader );
  if( error ) return error;

  error = widget_options_print_option( 6, "\012A\011uto-load media",
				       show->auto_load );
  if( error ) return error;

  error = widget_options_print_option( 7, "Use .s\012l\011t traps",
				       show->slt_traps );
  if( error ) return error;

  error = widget_options_print_option( 8, "Allow \012w\011rites to ROM",
				       show->writable_roms );
  if( error ) return error;

  error = widget_options_print_option( 9, "A\012u\011to-save settings",
				       show->autosave_settings );
  if( error ) return error;

  error = widget_options_print_entry( 10, "\012M\011DR cartridge len",
				      show->mdr_len,
				      "block" );
  if( error ) return error;
  error = widget_options_print_option( 11, "Raw RS-2\0123\0112",
				       show->raw_rs232 );
  if( error ) return error;

  error = widget_options_print_option( 12, "Raw Sinclair\012N\011ET",
				       show->raw_s_net );
  if( error ) return error;

  error = widget_options_print_option( 13, "Black and white T\012V\011",
				       show->bw_tv );
  if( error ) return error;

  error = widget_options_print_option( 14, "\012P\011AL-TV use TV2x effect",
				       show->pal_tv2x );
  if( error ) return error;

  error = widget_options_print_option( 15, "\012C\011onfirm actions",
				       show->confirm_actions );
  if( error ) return error;

  error = widget_options_print_option( 16, "Show status\012b\011ar",
				       show->statusbar );
  if( error ) return error;

  error = widget_options_print_option( 17, "Snap \012j\011oystick prompt",
				       show->joy_prompt );
  if( error ) return error;

  return 0;
}

void
widget_general_keyhandler( input_key key )
{
  int error;
  widget_text_t text_data;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 18 );
    widget_general_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_e:
    text_data.title = "Emulation speed";
    text_data.allow = WIDGET_INPUT_DIGIT;
    snprintf( text_data.text, 40, "%d",
	      widget_options_settings.emulation_speed );
    error = widget_do( WIDGET_TYPE_TEXT, &text_data ); if( error ) return;
    if( widget_text_text ) {
      widget_options_settings.emulation_speed = atoi( widget_text_text );
      error = widget_options_print_entry(
        0, "\012E\011mulation speed",
	widget_options_settings.emulation_speed, "%"
      );
    }
	    
    break;

  case INPUT_KEY_r:
    text_data.title = "Frame rate (1:n)";
    text_data.allow = WIDGET_INPUT_DIGIT;
    snprintf( text_data.text, 40, "%d",
	      widget_options_settings.frame_rate );
    error = widget_do( WIDGET_TYPE_TEXT, &text_data ); if( error ) return;
    if( widget_text_text ) {
      widget_options_settings.frame_rate = atoi( widget_text_text );
      error = widget_options_print_entry(
        1, "F\012r\011ame rate (1:n)",
	widget_options_settings.frame_rate, "frames"
      );
    }
	    
    break;

  case INPUT_KEY_2:
    widget_options_settings.issue2 = ! widget_options_settings.issue2;
    error = widget_options_print_value( 2, widget_options_settings.issue2 );
    if( error ) return;
    break;

  case INPUT_KEY_t:
    widget_options_settings.tape_traps = ! widget_options_settings.tape_traps;
    error = widget_options_print_value( 3, widget_options_settings.tape_traps );
    if( error ) return;
    break;

  case INPUT_KEY_f:
    widget_options_settings.fastload = ! widget_options_settings.fastload;
    error = widget_options_print_value( 4, widget_options_settings.fastload );
    if( error ) return;
    break;

  case INPUT_KEY_d:
    widget_options_settings.detect_loader = ! widget_options_settings.detect_loader;
    error = widget_options_print_value( 5, widget_options_settings.detect_loader );
    if( error ) return;
    break;

  case INPUT_KEY_a:
    widget_options_settings.auto_load = ! widget_options_settings.auto_load;
    error = widget_options_print_value( 6, widget_options_settings.auto_load );
    if( error ) return;
    break;

  case INPUT_KEY_l:
    widget_options_settings.slt_traps = ! widget_options_settings.slt_traps;
    error = widget_options_print_value( 7, widget_options_settings.slt_traps );
    if( error ) return;
    break;

  case INPUT_KEY_w:
    widget_options_settings.writable_roms = ! widget_options_settings.writable_roms;
    error = widget_options_print_value( 8, widget_options_settings.writable_roms );
    if( error ) return;
    break;

  case INPUT_KEY_u:
    widget_options_settings.autosave_settings = ! widget_options_settings.autosave_settings;
    error = widget_options_print_value( 9, widget_options_settings.autosave_settings );
    if( error ) return;
    break;

  case INPUT_KEY_m:
    text_data.title = "MDR cartridge len";
    text_data.allow = WIDGET_INPUT_DIGIT;
    snprintf( text_data.text, 40, "%d",
	      widget_options_settings.mdr_len );
    error = widget_do( WIDGET_TYPE_TEXT, &text_data ); if( error ) return;
    if( widget_text_text ) {
      widget_options_settings.mdr_len = atoi( widget_text_text );
      error = widget_options_print_entry(
        10, "\012M\011DR cartridge len",
	widget_options_settings.mdr_len, "block"
      );
    }
	    
    break;

  case INPUT_KEY_3:
    widget_options_settings.raw_rs232 = ! widget_options_settings.raw_rs232;
    error = widget_options_print_value( 11, widget_options_settings.raw_rs232 );
    if( error ) return;
    break;

  case INPUT_KEY_n:
    widget_options_settings.raw_s_net = ! widget_options_settings.raw_s_net;
    error = widget_options_print_value( 12, widget_options_settings.raw_s_net );
    if( error ) return;
    break;

  case INPUT_KEY_v:
    widget_options_settings.bw_tv = ! widget_options_settings.bw_tv;
    error = widget_options_print_value( 13, widget_options_settings.bw_tv );
    if( error ) return;
    break;

  case INPUT_KEY_p:
    widget_options_settings.pal_tv2x = ! widget_options_settings.pal_tv2x;
    error = widget_options_print_value( 14, widget_options_settings.pal_tv2x );
    if( error ) return;
    break;

  case INPUT_KEY_c:
    widget_options_settings.confirm_actions = ! widget_options_settings.confirm_actions;
    error = widget_options_print_value( 15, widget_options_settings.confirm_actions );
    if( error ) return;
    break;

  case INPUT_KEY_b:
    widget_options_settings.statusbar = ! widget_options_settings.statusbar;
    error = widget_options_print_value( 16, widget_options_settings.statusbar );
    if( error ) return;
    break;

  case INPUT_KEY_j:
    widget_options_settings.joy_prompt = ! widget_options_settings.joy_prompt;
    error = widget_options_print_value( 17, widget_options_settings.joy_prompt );
    if( error ) return;
    break;

  case INPUT_KEY_Return:
    display_refresh_all();
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}
static int widget_peripherals_show_all( settings_info *show );

int widget_peripherals_draw( void *data GCC_UNUSED )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 13 );
  error = widget_peripherals_show_all( &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  widget_display_lines( 2, 2 + 13 );

  return 0;
}

static int widget_peripherals_show_all( settings_info *show )
{
  int error;

  widget_print_title( 16, WIDGET_COLOUR_FOREGROUND, "Peripheral Options" );

  error = widget_options_print_option( 0, "\012K\011empston joystick",
				       show->joy_kempston );
  if( error ) return error;

  error = widget_options_print_option( 1, "Kempston \012m\011ouse",
				       show->kempston_mouse );
  if( error ) return error;

  error = widget_options_print_option( 2, "Inter\012f\011ace I",
				       show->interface1 );
  if( error ) return error;

  error = widget_options_print_option( 3, "\012I\011nterface II",
				       show->interface2 );
  if( error ) return error;

  error = widget_options_print_option( 4, "Emulate \012p\011rinters",
				       show->printer );
  if( error ) return error;

  error = widget_options_print_option( 5, "Simple \0128\011-bit IDE",
				       show->simpleide_active );
  if( error ) return error;

  error = widget_options_print_option( 6, "\012Z\011XATASP interface",
				       show->zxatasp_active );
  if( error ) return error;

  error = widget_options_print_option( 7, "ZXATASP \012u\011pload",
				       show->zxatasp_upload );
  if( error ) return error;

  error = widget_options_print_option( 8, "ZXATASP \012w\011rite protect",
				       show->zxatasp_wp );
  if( error ) return error;

  error = widget_options_print_option( 9, "ZX\012C\011F interface",
				       show->zxcf_active );
  if( error ) return error;

  error = widget_options_print_option( 10, "ZXCF up\012l\011oad",
				       show->zxcf_upload );
  if( error ) return error;

  error = widget_options_print_option( 11, "\012D\011ivIDE interface",
				       show->divide_enabled );
  if( error ) return error;

  error = widget_options_print_option( 12, "DivIDE w\012r\011ite protect",
				       show->divide_wp );
  if( error ) return error;

  return 0;
}

void
widget_peripherals_keyhandler( input_key key )
{
  int error;
  widget_text_t text_data;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 13 );
    widget_peripherals_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_k:
    widget_options_settings.joy_kempston = ! widget_options_settings.joy_kempston;
    error = widget_options_print_value( 0, widget_options_settings.joy_kempston );
    if( error ) return;
    break;

  case INPUT_KEY_m:
    widget_options_settings.kempston_mouse = ! widget_options_settings.kempston_mouse;
    error = widget_options_print_value( 1, widget_options_settings.kempston_mouse );
    if( error ) return;
    break;

  case INPUT_KEY_f:
    widget_options_settings.interface1 = ! widget_options_settings.interface1;
    error = widget_options_print_value( 2, widget_options_settings.interface1 );
    if( error ) return;
    break;

  case INPUT_KEY_i:
    widget_options_settings.interface2 = ! widget_options_settings.interface2;
    error = widget_options_print_value( 3, widget_options_settings.interface2 );
    if( error ) return;
    break;

  case INPUT_KEY_p:
    widget_options_settings.printer = ! widget_options_settings.printer;
    error = widget_options_print_value( 4, widget_options_settings.printer );
    if( error ) return;
    break;

  case INPUT_KEY_8:
    widget_options_settings.simpleide_active = ! widget_options_settings.simpleide_active;
    error = widget_options_print_value( 5, widget_options_settings.simpleide_active );
    if( error ) return;
    break;

  case INPUT_KEY_z:
    widget_options_settings.zxatasp_active = ! widget_options_settings.zxatasp_active;
    error = widget_options_print_value( 6, widget_options_settings.zxatasp_active );
    if( error ) return;
    break;

  case INPUT_KEY_u:
    widget_options_settings.zxatasp_upload = ! widget_options_settings.zxatasp_upload;
    error = widget_options_print_value( 7, widget_options_settings.zxatasp_upload );
    if( error ) return;
    break;

  case INPUT_KEY_w:
    widget_options_settings.zxatasp_wp = ! widget_options_settings.zxatasp_wp;
    error = widget_options_print_value( 8, widget_options_settings.zxatasp_wp );
    if( error ) return;
    break;

  case INPUT_KEY_c:
    widget_options_settings.zxcf_active = ! widget_options_settings.zxcf_active;
    error = widget_options_print_value( 9, widget_options_settings.zxcf_active );
    if( error ) return;
    break;

  case INPUT_KEY_l:
    widget_options_settings.zxcf_upload = ! widget_options_settings.zxcf_upload;
    error = widget_options_print_value( 10, widget_options_settings.zxcf_upload );
    if( error ) return;
    break;

  case INPUT_KEY_d:
    widget_options_settings.divide_enabled = ! widget_options_settings.divide_enabled;
    error = widget_options_print_value( 11, widget_options_settings.divide_enabled );
    if( error ) return;
    break;

  case INPUT_KEY_r:
    widget_options_settings.divide_wp = ! widget_options_settings.divide_wp;
    error = widget_options_print_value( 12, widget_options_settings.divide_wp );
    if( error ) return;
    break;

  case INPUT_KEY_Return:
    periph_update();
    display_refresh_all();
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}
static int widget_rzx_show_all( settings_info *show );

int widget_rzx_draw( void *data GCC_UNUSED )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 4 );
  error = widget_rzx_show_all( &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  widget_display_lines( 2, 2 + 4 );

  return 0;
}

static int widget_rzx_show_all( settings_info *show )
{
  int error;

  widget_print_title( 16, WIDGET_COLOUR_FOREGROUND, "RZX Options" );

  error = widget_options_print_option( 0, "\012C\011ompress RZX data",
				       show->rzx_compression );
  if( error ) return error;

  error = widget_options_print_option( 1, "C\012o\011mpetition mode",
				       show->competition_mode );
  if( error ) return error;

  error = widget_options_print_entry( 2, "Co\012m\011petition code",
				      show->competition_code,
				      "" );
  if( error ) return error;
  error = widget_options_print_option( 3, "Always \012e\011mbed snapshot",
				       show->embed_snapshot );
  if( error ) return error;

  return 0;
}

void
widget_rzx_keyhandler( input_key key )
{
  int error;
  widget_text_t text_data;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 4 );
    widget_rzx_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_c:
    widget_options_settings.rzx_compression = ! widget_options_settings.rzx_compression;
    error = widget_options_print_value( 0, widget_options_settings.rzx_compression );
    if( error ) return;
    break;

  case INPUT_KEY_o:
    widget_options_settings.competition_mode = ! widget_options_settings.competition_mode;
    error = widget_options_print_value( 1, widget_options_settings.competition_mode );
    if( error ) return;
    break;

  case INPUT_KEY_m:
    text_data.title = "Competition code";
    text_data.allow = WIDGET_INPUT_DIGIT;
    snprintf( text_data.text, 40, "%d",
	      widget_options_settings.competition_code );
    error = widget_do( WIDGET_TYPE_TEXT, &text_data ); if( error ) return;
    if( widget_text_text ) {
      widget_options_settings.competition_code = atoi( widget_text_text );
      error = widget_options_print_entry(
        2, "Co\012m\011petition code",
	widget_options_settings.competition_code, ""
      );
    }
	    
    break;

  case INPUT_KEY_e:
    widget_options_settings.embed_snapshot = ! widget_options_settings.embed_snapshot;
    error = widget_options_print_value( 3, widget_options_settings.embed_snapshot );
    if( error ) return;
    break;

  case INPUT_KEY_Return:
    display_refresh_all();
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}
static int widget_sound_show_all( settings_info *show );

int widget_sound_draw( void *data GCC_UNUSED )
{
  int error;
  
  /* Get a copy of the current settings */
  error = settings_copy( &widget_options_settings, &settings_current );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  /* Draw the dialog box */
  widget_dialog_with_border( 1, 2, 30, 2 + 5 );
  error = widget_sound_show_all( &widget_options_settings );
  if( error ) { settings_free( &widget_options_settings ); return error; }

  widget_display_lines( 2, 2 + 5 );

  return 0;
}

static int widget_sound_show_all( settings_info *show )
{
  int error;

  widget_print_title( 16, WIDGET_COLOUR_FOREGROUND, "Sound Options" );

  error = widget_options_print_option( 0, "\012S\011ound enabled",
				       show->sound );
  if( error ) return error;

  error = widget_options_print_option( 1, "\012L\011oading sound",
				       show->sound_load );
  if( error ) return error;

  error = widget_options_print_option( 2, "\012A\011Y stereo separation",
				       show->stereo_ay );
  if( error ) return error;

  error = widget_options_print_option( 3, "\012B\011eeper pseudo-stereo",
				       show->stereo_beeper );
  if( error ) return error;

  error = widget_options_print_option( 4, "\012F\011orce 8-bit",
				       show->sound_force_8bit );
  if( error ) return error;

  return 0;
}

void
widget_sound_keyhandler( input_key key )
{
  int error;
  widget_text_t text_data;

  text_data = text_data;	/* Keep gcc happy */

  switch( key ) {

#if 0
  case INPUT_KEY_Resize:	/* Fake keypress used on window resize */
    widget_dialog_with_border( 1, 2, 30, 2 + 5 );
    widget_sound_show_all( &widget_options_settings );
    break;
#endif
    
  case INPUT_KEY_Escape:
    widget_end_widget( WIDGET_FINISHED_CANCEL );
    break;

  case INPUT_KEY_s:
    widget_options_settings.sound = ! widget_options_settings.sound;
    error = widget_options_print_value( 0, widget_options_settings.sound );
    if( error ) return;
    break;

  case INPUT_KEY_l:
    widget_options_settings.sound_load = ! widget_options_settings.sound_load;
    error = widget_options_print_value( 1, widget_options_settings.sound_load );
    if( error ) return;
    break;

  case INPUT_KEY_a:
    widget_options_settings.stereo_ay = ! widget_options_settings.stereo_ay;
    error = widget_options_print_value( 2, widget_options_settings.stereo_ay );
    if( error ) return;
    break;

  case INPUT_KEY_b:
    widget_options_settings.stereo_beeper = ! widget_options_settings.stereo_beeper;
    error = widget_options_print_value( 3, widget_options_settings.stereo_beeper );
    if( error ) return;
    break;

  case INPUT_KEY_f:
    widget_options_settings.sound_force_8bit = ! widget_options_settings.sound_force_8bit;
    error = widget_options_print_value( 4, widget_options_settings.sound_force_8bit );
    if( error ) return;
    break;

  case INPUT_KEY_Return:
    display_refresh_all();
    widget_end_all( WIDGET_FINISHED_OK );
    break;

  default:	/* Keep gcc happy */
    break;

  }
}

#endif				/* #ifdef USE_WIDGET */
