/* menu_data.c: menu structure for Fuse
   Copyright (c) 2004 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/

/* This file is autogenerated from menu_data.c by ../menu_data.pl.
   Any changes made here will not be preserved. */

#include <config.h>

#include "menu.h"

#include "input.h"
#include "options.h"
#include "widget_internals.h"

static widget_menu_entry menu_file_recording[] = {
  { "Recording" },
  { "\012R\011ecord...", INPUT_KEY_r, NULL, menu_file_recording_record, 0 },
  { "Record \012f\011rom snapshot...", INPUT_KEY_f, NULL, menu_file_recording_recordfromsnapshot, 0 },
  { "\012I\011nsert snapshot", INPUT_KEY_i, NULL, menu_file_recording_insertsnapshot, 0 },
  { "Roll\012b\011ack", INPUT_KEY_b, NULL, menu_file_recording_rollback, 0 },
  { "Rollback \012t\011o...", INPUT_KEY_t, NULL, menu_file_recording_rollbackto, 0 },
  { "\012P\011lay...", INPUT_KEY_p, NULL, menu_file_recording_play, 0 },
  { "\012S\011top", INPUT_KEY_s, NULL, menu_file_recording_stop, 0 },
  { NULL }
};

static widget_menu_entry menu_file_aylogging[] = {
  { "AY Logging" },
  { "\012R\011ecord...", INPUT_KEY_r, NULL, menu_file_aylogging_record, 0 },
  { "\012S\011top", INPUT_KEY_s, NULL, menu_file_aylogging_stop, 0 },
  { NULL }
};

static widget_menu_entry menu_file_movies[] = {
  { "Movies" },
  { "Record Movie as \012S\011CR...", INPUT_KEY_s, NULL, menu_file_movies_recordmovieasscr, 0 },
  { "Record Movie as \012P\011NG...", INPUT_KEY_p, NULL, menu_file_movies_recordmovieaspng, 0 },
  { "S\012t\011op Movie Recording", INPUT_KEY_t, NULL, menu_file_movies_stopmovierecording, 0 },
  { NULL }
};

static widget_menu_entry menu_file[] = {
  { "File" },
  { "\012O\011pen...", INPUT_KEY_o, NULL, menu_file_open, 0 },
  { "\012S\011ave Snapshot...", INPUT_KEY_s, NULL, menu_file_savesnapshot, 0 },
  { "\012R\011ecording", INPUT_KEY_r, menu_file_recording, NULL, 0 },
  { "A\012Y\011 Logging", INPUT_KEY_y, menu_file_aylogging, NULL, 0 },
  { "O\012p\011en SCR Screenshot...", INPUT_KEY_p, NULL, menu_file_openscrscreenshot, 0 },
  { "S\012a\011ve Screen as SCR...", INPUT_KEY_a, NULL, menu_file_savescreenasscr, 0 },
  { "Save S\012c\011reen as PNG...", INPUT_KEY_c, NULL, menu_file_savescreenaspng, 0 },
  { "\012M\011ovies", INPUT_KEY_m, menu_file_movies, NULL, 0 },
  { "Loa\012d\011 binary data...", INPUT_KEY_d, NULL, menu_file_loadbinarydata, 0 },
  { "Save \012b\011inary data...", INPUT_KEY_b, NULL, menu_file_savebinarydata, 0 },
  { "E\012x\011it...", INPUT_KEY_x, NULL, menu_file_exit, 0 },
  { NULL }
};

static widget_menu_entry menu_options_joysticks[] = {
  { "Joysticks" },
  { "Joystick \0121\011...", INPUT_KEY_1, NULL, menu_options_joysticks_select, 1 },
  { "Joystick \0122\011...", INPUT_KEY_2, NULL, menu_options_joysticks_select, 2 },
  { "\012K\011eyboard...", INPUT_KEY_k, NULL, menu_options_joysticks_select, 3 },
  { NULL }
};

static widget_menu_entry menu_options_selectroms[] = {
  { "Select ROMs" },
  { "Spectrum 1\0126\011K...", INPUT_KEY_6, NULL, menu_options_selectroms_select, 1 },
  { "Spectrum \0124\0118K...", INPUT_KEY_4, NULL, menu_options_selectroms_select, 2 },
  { "Spectrum \0121\01128K...", INPUT_KEY_1, NULL, menu_options_selectroms_select, 3 },
  { "Spectrum +\0122\011...", INPUT_KEY_2, NULL, menu_options_selectroms_select, 4 },
  { "Spectrum +2\012A\011...", INPUT_KEY_a, NULL, menu_options_selectroms_select, 5 },
  { "Spectrum +\0123\011...", INPUT_KEY_3, NULL, menu_options_selectroms_select, 6 },
  { "Spectrum +3\012e\011...", INPUT_KEY_e, NULL, menu_options_selectroms_select, 11 },
  { "Timex \012T\011C2048...", INPUT_KEY_t, NULL, menu_options_selectroms_select, 7 },
  { "Timex TC206\0128\011...", INPUT_KEY_8, NULL, menu_options_selectroms_select, 8 },
  { "Timex TS2\0120\01168...", INPUT_KEY_NONE, NULL, menu_options_selectroms_select, 14 },
  { "\012P\011entagon 128K...", INPUT_KEY_p, NULL, menu_options_selectroms_select, 9 },
  { "S\012c\011orpion ZS 256...", INPUT_KEY_c, NULL, menu_options_selectroms_select, 10 },
  { "Spectrum \012S\011E...", INPUT_KEY_s, NULL, menu_options_selectroms_select, 12 },
  { "Interface \012I\011...", INPUT_KEY_i, NULL, menu_options_selectroms_select, 13 },
  { NULL }
};

static widget_menu_entry menu_options[] = {
  { "Options" },
  { "\012G\011eneral...", INPUT_KEY_g, NULL, menu_options_general, 0 },
  { "\012S\011ound...", INPUT_KEY_s, NULL, menu_options_sound, 0 },
  { "\012P\011eripherals...", INPUT_KEY_p, NULL, menu_options_peripherals, 0 },
  { "\012R\011ZX...", INPUT_KEY_r, NULL, menu_options_rzx, 0 },
  { "\012J\011oysticks", INPUT_KEY_j, menu_options_joysticks, NULL, 0 },
  { "S\012e\011lect ROMs", INPUT_KEY_e, menu_options_selectroms, NULL, 0 },
  { "\012F\011ilter...", INPUT_KEY_f, NULL, menu_options_filter, 0 },
  { "S\012a\011ve", INPUT_KEY_a, NULL, menu_options_save, 0 },
  { NULL }
};

static widget_menu_entry menu_machine_profiler[] = {
  { "Profiler" },
  { "\012S\011tart", INPUT_KEY_s, NULL, menu_machine_profiler_start, 0 },
  { "\012S\011top", INPUT_KEY_s, NULL, menu_machine_profiler_stop, 0 },
  { NULL }
};

static widget_menu_entry menu_machine[] = {
  { "Machine" },
  { "\012P\011ause...", INPUT_KEY_p, NULL, menu_machine_pause, 0 },
  { "\012R\011eset...", INPUT_KEY_r, NULL, menu_machine_reset, 0 },
  { "\012S\011elect...", INPUT_KEY_s, NULL, menu_machine_select, 0 },
  { "\012D\011ebugger...", INPUT_KEY_d, NULL, menu_machine_debugger, 0 },
  { "P\012o\011ke Finder...", INPUT_KEY_o, NULL, menu_machine_pokefinder, 0 },
  { "\012M\011emory Browser...", INPUT_KEY_m, NULL, menu_machine_memorybrowser, 0 },
  { "Pro\012f\011iler", INPUT_KEY_f, menu_machine_profiler, NULL, 0 },
  { "\012N\011MI", INPUT_KEY_n, NULL, menu_machine_nmi, 0 },
  { NULL }
};

static widget_menu_entry menu_media_tape[] = {
  { "Tape" },
  { "\012O\011pen...", INPUT_KEY_o, NULL, menu_media_tape_open, 0 },
  { "\012P\011lay", INPUT_KEY_p, NULL, menu_media_tape_play, 0 },
  { "\012B\011rowse...", INPUT_KEY_b, NULL, menu_media_tape_browse, 0 },
  { "\012R\011ewind", INPUT_KEY_r, NULL, menu_media_tape_rewind, 0 },
  { "\012C\011lear", INPUT_KEY_c, NULL, menu_media_tape_clear, 0 },
  { "\012W\011rite...", INPUT_KEY_w, NULL, menu_media_tape_write, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive1_writeprotect[] = {
  { "Write protect" },
  { "\012S\011et", INPUT_KEY_s, NULL, menu_media_mdr_writep, 0x11 },
  { "\012R\011emove", INPUT_KEY_r, NULL, menu_media_mdr_writep, 0x01 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive1[] = {
  { "Microdrive 1" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_mdr_new, 1 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_mdr_insert, 1 },
  { "\012S\011ync", INPUT_KEY_s, NULL, menu_media_mdr_sync, 1 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_mdr_eject, 1 },
  { "\012W\011rite protect", INPUT_KEY_w, menu_media_interfacei_microdrive1_writeprotect, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive2_writeprotect[] = {
  { "Write protect" },
  { "\012S\011et", INPUT_KEY_s, NULL, menu_media_mdr_writep, 0x12 },
  { "\012R\011emove", INPUT_KEY_r, NULL, menu_media_mdr_writep, 0x02 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive2[] = {
  { "Microdrive 2" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_mdr_new, 2 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_mdr_insert, 2 },
  { "\012S\011ync", INPUT_KEY_s, NULL, menu_media_mdr_sync, 2 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_mdr_eject, 2 },
  { "\012W\011rite protect", INPUT_KEY_w, menu_media_interfacei_microdrive2_writeprotect, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive3_writeprotect[] = {
  { "Write protect" },
  { "\012S\011et", INPUT_KEY_s, NULL, menu_media_mdr_writep, 0x13 },
  { "\012R\011emove", INPUT_KEY_r, NULL, menu_media_mdr_writep, 0x03 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive3[] = {
  { "Microdrive 3" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_mdr_new, 3 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_mdr_insert, 3 },
  { "\012S\011ync", INPUT_KEY_s, NULL, menu_media_mdr_sync, 3 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_mdr_eject, 3 },
  { "\012W\011rite protect", INPUT_KEY_w, menu_media_interfacei_microdrive3_writeprotect, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive4_writeprotect[] = {
  { "Write protect" },
  { "\012S\011et", INPUT_KEY_s, NULL, menu_media_mdr_writep, 0x14 },
  { "\012R\011emove", INPUT_KEY_r, NULL, menu_media_mdr_writep, 0x04 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive4[] = {
  { "Microdrive 4" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_mdr_new, 4 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_mdr_insert, 4 },
  { "\012S\011ync", INPUT_KEY_s, NULL, menu_media_mdr_sync, 4 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_mdr_eject, 4 },
  { "\012W\011rite protect", INPUT_KEY_w, menu_media_interfacei_microdrive4_writeprotect, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive5_writeprotect[] = {
  { "Write protect" },
  { "\012S\011et", INPUT_KEY_s, NULL, menu_media_mdr_writep, 0x15 },
  { "\012R\011emove", INPUT_KEY_r, NULL, menu_media_mdr_writep, 0x05 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive5[] = {
  { "Microdrive 5" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_mdr_new, 5 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_mdr_insert, 5 },
  { "\012S\011ync", INPUT_KEY_s, NULL, menu_media_mdr_sync, 5 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_mdr_eject, 5 },
  { "\012W\011rite protect", INPUT_KEY_w, menu_media_interfacei_microdrive5_writeprotect, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive6_writeprotect[] = {
  { "Write protect" },
  { "\012S\011et", INPUT_KEY_s, NULL, menu_media_mdr_writep, 0x16 },
  { "\012R\011emove", INPUT_KEY_r, NULL, menu_media_mdr_writep, 0x06 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive6[] = {
  { "Microdrive 6" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_mdr_new, 6 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_mdr_insert, 6 },
  { "\012S\011ync", INPUT_KEY_s, NULL, menu_media_mdr_sync, 6 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_mdr_eject, 6 },
  { "\012W\011rite protect", INPUT_KEY_w, menu_media_interfacei_microdrive6_writeprotect, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive7_writeprotect[] = {
  { "Write protect" },
  { "\012S\011et", INPUT_KEY_s, NULL, menu_media_mdr_writep, 0x17 },
  { "\012R\011emove", INPUT_KEY_r, NULL, menu_media_mdr_writep, 0x07 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive7[] = {
  { "Microdrive 7" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_mdr_new, 7 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_mdr_insert, 7 },
  { "\012S\011ync", INPUT_KEY_s, NULL, menu_media_mdr_sync, 7 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_mdr_eject, 7 },
  { "\012W\011rite protect", INPUT_KEY_w, menu_media_interfacei_microdrive7_writeprotect, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive8_writeprotect[] = {
  { "Write protect" },
  { "\012S\011et", INPUT_KEY_s, NULL, menu_media_mdr_writep, 0x18 },
  { "\012R\011emove", INPUT_KEY_r, NULL, menu_media_mdr_writep, 0x08 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_microdrive8[] = {
  { "Microdrive 8" },
  { "Insert \012N\011ew", INPUT_KEY_n, NULL, menu_media_mdr_new, 8 },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_mdr_insert, 8 },
  { "\012S\011ync", INPUT_KEY_s, NULL, menu_media_mdr_sync, 8 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_mdr_eject, 8 },
  { "\012W\011rite protect", INPUT_KEY_w, menu_media_interfacei_microdrive8_writeprotect, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_rs232[] = {
  { "RS232" },
  { "Plug \012R\011xD", INPUT_KEY_r, NULL, menu_media_if1_rs232, 0x01 },
  { "\012U\011nplug RxD", INPUT_KEY_u, NULL, menu_media_if1_rs232, 0x11 },
  { "Plug \012T\011xD", INPUT_KEY_t, NULL, menu_media_if1_rs232, 0x02 },
  { "Un\012p\011lug TxD", INPUT_KEY_p, NULL, menu_media_if1_rs232, 0x12 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei_sinclairnet[] = {
  { "Sinclair NET" },
  { "\012P\011lug in", INPUT_KEY_p, NULL, menu_media_if1_rs232, 0x03 },
  { "\012U\011nplug", INPUT_KEY_u, NULL, menu_media_if1_rs232, 0x13 },
  { NULL }
};

static widget_menu_entry menu_media_interfacei[] = {
  { "Interface I" },
  { "Microdrive \0121\011", INPUT_KEY_1, menu_media_interfacei_microdrive1, NULL, 0 },
  { "Microdrive \0122\011", INPUT_KEY_2, menu_media_interfacei_microdrive2, NULL, 0 },
  { "Microdrive \0123\011", INPUT_KEY_3, menu_media_interfacei_microdrive3, NULL, 0 },
  { "Microdrive \0124\011", INPUT_KEY_4, menu_media_interfacei_microdrive4, NULL, 0 },
  { "Microdrive \0125\011", INPUT_KEY_5, menu_media_interfacei_microdrive5, NULL, 0 },
  { "Microdrive \0126\011", INPUT_KEY_6, menu_media_interfacei_microdrive6, NULL, 0 },
  { "Microdrive \0127\011", INPUT_KEY_7, menu_media_interfacei_microdrive7, NULL, 0 },
  { "Microdrive \0128\011", INPUT_KEY_8, menu_media_interfacei_microdrive8, NULL, 0 },
  { "\012R\011S232", INPUT_KEY_r, menu_media_interfacei_rs232, NULL, 0 },
  { "\012S\011inclair NET", INPUT_KEY_s, menu_media_interfacei_sinclairnet, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3_drivea[] = {
  { "Drive A:" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_disk_insert, 1 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_disk_eject, 1 },
  { "Eject and \012w\011rite...", INPUT_KEY_w, NULL, menu_media_disk_eject, 17 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3_driveb[] = {
  { "Drive B:" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_disk_insert, 2 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_disk_eject, 2 },
  { "Eject and \012w\011rite...", INPUT_KEY_w, NULL, menu_media_disk_eject, 18 },
  { NULL }
};

static widget_menu_entry menu_media_disk_3[] = {
  { "+3" },
  { "Drive \012A\011:", INPUT_KEY_a, menu_media_disk_3_drivea, NULL, 0 },
  { "Drive \012B\011:", INPUT_KEY_b, menu_media_disk_3_driveb, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk_trdos_drivea[] = {
  { "Drive A:" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_disk_insert, 5 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_disk_eject, 5 },
  { "Eject and \012w\011rite...", INPUT_KEY_w, NULL, menu_media_disk_eject, 21 },
  { NULL }
};

static widget_menu_entry menu_media_disk_trdos_driveb[] = {
  { "Drive B:" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_disk_insert, 6 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_disk_eject, 6 },
  { "Eject and \012w\011rite...", INPUT_KEY_w, NULL, menu_media_disk_eject, 22 },
  { NULL }
};

static widget_menu_entry menu_media_disk_trdos[] = {
  { "TR-DOS" },
  { "Drive \012A\011:", INPUT_KEY_a, menu_media_disk_trdos_drivea, NULL, 0 },
  { "Drive \012B\011:", INPUT_KEY_b, menu_media_disk_trdos_driveb, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_disk[] = {
  { "Disk" },
  { "+\0123\011", INPUT_KEY_3, menu_media_disk_3, NULL, 0 },
  { "\012T\011R-DOS", INPUT_KEY_t, menu_media_disk_trdos, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge_timexdock[] = {
  { "Timex Dock" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_cartridge_timexdock_insert, 0 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_cartridge_timexdock_eject, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge_interfaceii[] = {
  { "Interface II" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_cartridge_interfaceii_insert, 0 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_cartridge_interfaceii_eject, 0 },
  { NULL }
};

static widget_menu_entry menu_media_cartridge[] = {
  { "Cartridge" },
  { "\012T\011imex Dock", INPUT_KEY_t, menu_media_cartridge_timexdock, NULL, 0 },
  { "\012I\011nterface II", INPUT_KEY_i, menu_media_cartridge_interfaceii, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit_master[] = {
  { "Master" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 1 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 1 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 1 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit_slave[] = {
  { "Slave" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 2 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 2 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 2 },
  { NULL }
};

static widget_menu_entry menu_media_ide_simple8bit[] = {
  { "Simple 8-bit" },
  { "\012M\011aster", INPUT_KEY_m, menu_media_ide_simple8bit_master, NULL, 0 },
  { "\012S\011lave", INPUT_KEY_s, menu_media_ide_simple8bit_slave, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp_master[] = {
  { "Master" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 3 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 3 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 3 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp_slave[] = {
  { "Slave" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 4 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 4 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 4 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxatasp[] = {
  { "ZXATASP" },
  { "\012M\011aster", INPUT_KEY_m, menu_media_ide_zxatasp_master, NULL, 0 },
  { "\012S\011lave", INPUT_KEY_s, menu_media_ide_zxatasp_slave, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide_zxcfcompactflash[] = {
  { "ZXCF CompactFlash" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 5 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 5 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 5 },
  { NULL }
};

static widget_menu_entry menu_media_ide_divide_master[] = {
  { "Master" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 6 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 6 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 6 },
  { NULL }
};

static widget_menu_entry menu_media_ide_divide_slave[] = {
  { "Slave" },
  { "\012I\011nsert...", INPUT_KEY_i, NULL, menu_media_ide_insert, 7 },
  { "\012C\011ommit", INPUT_KEY_c, NULL, menu_media_ide_commit, 7 },
  { "\012E\011ject", INPUT_KEY_e, NULL, menu_media_ide_eject, 7 },
  { NULL }
};

static widget_menu_entry menu_media_ide_divide[] = {
  { "DivIDE" },
  { "\012M\011aster", INPUT_KEY_m, menu_media_ide_divide_master, NULL, 0 },
  { "\012S\011lave", INPUT_KEY_s, menu_media_ide_divide_slave, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media_ide[] = {
  { "IDE" },
  { "Simple \0128\011-bit", INPUT_KEY_8, menu_media_ide_simple8bit, NULL, 0 },
  { "ZX\012A\011TASP", INPUT_KEY_a, menu_media_ide_zxatasp, NULL, 0 },
  { "ZX\012C\011F CompactFlash", INPUT_KEY_c, menu_media_ide_zxcfcompactflash, NULL, 0 },
  { "\012D\011ivIDE", INPUT_KEY_d, menu_media_ide_divide, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_media[] = {
  { "Media" },
  { "\012T\011ape", INPUT_KEY_t, menu_media_tape, NULL, 0 },
  { "\012I\011nterface I", INPUT_KEY_i, menu_media_interfacei, NULL, 0 },
  { "\012D\011isk", INPUT_KEY_d, menu_media_disk, NULL, 0 },
  { "\012C\011artridge", INPUT_KEY_c, menu_media_cartridge, NULL, 0 },
  { "ID\012E\011", INPUT_KEY_e, menu_media_ide, NULL, 0 },
  { NULL }
};

static widget_menu_entry menu_help[] = {
  { "Help" },
  { "\012K\011eyboard...", INPUT_KEY_k, NULL, menu_help_keyboard, 0 },
  { NULL }
};

widget_menu_entry widget_menu[] = {
  { "Main menu" },
  { "\012F\011ile", INPUT_KEY_f, menu_file, NULL, 0 },
  { "\012O\011ptions", INPUT_KEY_o, menu_options, NULL, 0 },
  { "\012M\011achine", INPUT_KEY_m, menu_machine, NULL, 0 },
  { "M\012e\011dia", INPUT_KEY_e, menu_media, NULL, 0 },
  { "\012H\011elp", INPUT_KEY_h, menu_help, NULL, 0 },
  { NULL }
};

