/* keysyms.c: UI keysym to Fuse input layer keysym mappings
   Copyright (c) 2000-2004 Philip Kendall, Matan Ziv-Av, Russell Marks,
                           Fredrick Meunier, Catalin Mihaila

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from keysyms.dat by keysyms.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef UI_X

#include "input.h"
#include "keyboard.h"

#include <X11/keysym.h>

keysyms_map_t keysyms_map[] = {

  { XK_Escape,      INPUT_KEY_Escape      },
  { XK_F1,          INPUT_KEY_F1          },
  { XK_F2,          INPUT_KEY_F2          },
  { XK_F3,          INPUT_KEY_F3          },
  { XK_F4,          INPUT_KEY_F4          },
  { XK_F5,          INPUT_KEY_F5          },
  { XK_F6,          INPUT_KEY_F6          },
  { XK_F7,          INPUT_KEY_F7          },
  { XK_F8,          INPUT_KEY_F8          },
  { XK_F9,          INPUT_KEY_F9          },
  { XK_F10,         INPUT_KEY_F10         },
  { XK_F11,         INPUT_KEY_F11         },
  { XK_F12,         INPUT_KEY_F12         },
  { XK_1,           INPUT_KEY_1           },
  { XK_2,           INPUT_KEY_2           },
  { XK_3,           INPUT_KEY_3           },
  { XK_4,           INPUT_KEY_4           },
  { XK_5,           INPUT_KEY_5           },
  { XK_6,           INPUT_KEY_6           },
  { XK_7,           INPUT_KEY_7           },
  { XK_8,           INPUT_KEY_8           },
  { XK_9,           INPUT_KEY_9           },
  { XK_0,           INPUT_KEY_0           },
  { XK_minus,       INPUT_KEY_minus       },
  { XK_equal,       INPUT_KEY_equal       },
  { XK_BackSpace,   INPUT_KEY_BackSpace   },
  { XK_Tab,         INPUT_KEY_Tab         },
  { XK_q,           INPUT_KEY_q           },
  { XK_w,           INPUT_KEY_w           },
  { XK_e,           INPUT_KEY_e           },
  { XK_r,           INPUT_KEY_r           },
  { XK_t,           INPUT_KEY_t           },
  { XK_y,           INPUT_KEY_y           },
  { XK_u,           INPUT_KEY_u           },
  { XK_i,           INPUT_KEY_i           },
  { XK_o,           INPUT_KEY_o           },
  { XK_p,           INPUT_KEY_p           },
  { XK_Caps_Lock,   INPUT_KEY_Caps_Lock   },
  { XK_a,           INPUT_KEY_a           },
  { XK_s,           INPUT_KEY_s           },
  { XK_d,           INPUT_KEY_d           },
  { XK_f,           INPUT_KEY_f           },
  { XK_g,           INPUT_KEY_g           },
  { XK_h,           INPUT_KEY_h           },
  { XK_j,           INPUT_KEY_j           },
  { XK_k,           INPUT_KEY_k           },
  { XK_l,           INPUT_KEY_l           },
  { XK_semicolon,   INPUT_KEY_semicolon   },
  { XK_apostrophe,  INPUT_KEY_apostrophe  },
  { XK_numbersign,  INPUT_KEY_numbersign  },
  { XK_Return,      INPUT_KEY_Return      },
  { XK_Shift_L,     INPUT_KEY_Shift_L     },
  { XK_z,           INPUT_KEY_z           },
  { XK_x,           INPUT_KEY_x           },
  { XK_c,           INPUT_KEY_c           },
  { XK_v,           INPUT_KEY_v           },
  { XK_b,           INPUT_KEY_b           },
  { XK_n,           INPUT_KEY_n           },
  { XK_m,           INPUT_KEY_m           },
  { XK_comma,       INPUT_KEY_comma       },
  { XK_period,      INPUT_KEY_period      },
  { XK_slash,       INPUT_KEY_slash       },
  { XK_Shift_R,     INPUT_KEY_Shift_R     },
  { XK_Control_L,   INPUT_KEY_Control_L   },
  { XK_Alt_L,       INPUT_KEY_Alt_L       },
  { XK_Meta_L,      INPUT_KEY_Meta_L      },
  { XK_Super_L,     INPUT_KEY_Super_L     },
  { XK_Hyper_L,     INPUT_KEY_Hyper_L     },
  { XK_space,       INPUT_KEY_space       },
  { XK_Hyper_R,     INPUT_KEY_Hyper_R     },
  { XK_Super_R,     INPUT_KEY_Super_R     },
  { XK_Meta_R,      INPUT_KEY_Meta_R      },
  { XK_Alt_R,       INPUT_KEY_Alt_R       },
  { XK_Control_R,   INPUT_KEY_Control_R   },
  { XK_Mode_switch, INPUT_KEY_Mode_switch },
  { XK_Left,        INPUT_KEY_Left        },
  { XK_Down,        INPUT_KEY_Down        },
  { XK_Up,          INPUT_KEY_Up          },
  { XK_Right,       INPUT_KEY_Right       },
  { XK_Page_Up,     INPUT_KEY_Page_Up     },
  { XK_Page_Down,   INPUT_KEY_Page_Down   },
  { XK_Home,        INPUT_KEY_Home        },
  { XK_End,         INPUT_KEY_End         },

  { 0, 0 }			/* End marker: DO NOT MOVE! */

};

#endif
