/* keysyms.c: UI keysym to Fuse input layer keysym mappings
   Copyright (c) 2000-2004 Philip Kendall, Matan Ziv-Av, Russell Marks,
                           Fredrick Meunier, Catalin Mihaila

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from keysyms.dat by keysyms.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef UI_SDL

#include "input.h"
#include "keyboard.h"

#include <SDL.h>

keysyms_map_t keysyms_map[] = {

  { SDLK_ESCAPE,    INPUT_KEY_Escape      },
  { SDLK_F1,        INPUT_KEY_F1          },
  { SDLK_F2,        INPUT_KEY_F2          },
  { SDLK_F3,        INPUT_KEY_F3          },
  { SDLK_F4,        INPUT_KEY_F4          },
  { SDLK_F5,        INPUT_KEY_F5          },
  { SDLK_F6,        INPUT_KEY_F6          },
  { SDLK_F7,        INPUT_KEY_F7          },
  { SDLK_F8,        INPUT_KEY_F8          },
  { SDLK_F9,        INPUT_KEY_F9          },
  { SDLK_F10,       INPUT_KEY_F10         },
  { SDLK_F11,       INPUT_KEY_F11         },
  { SDLK_F12,       INPUT_KEY_F12         },
  { SDLK_1,         INPUT_KEY_1           },
  { SDLK_2,         INPUT_KEY_2           },
  { SDLK_3,         INPUT_KEY_3           },
  { SDLK_4,         INPUT_KEY_4           },
  { SDLK_5,         INPUT_KEY_5           },
  { SDLK_6,         INPUT_KEY_6           },
  { SDLK_7,         INPUT_KEY_7           },
  { SDLK_8,         INPUT_KEY_8           },
  { SDLK_9,         INPUT_KEY_9           },
  { SDLK_0,         INPUT_KEY_0           },
  { SDLK_MINUS,     INPUT_KEY_minus       },
  { SDLK_EQUALS,    INPUT_KEY_equal       },
  { SDLK_BACKSPACE, INPUT_KEY_BackSpace   },
  { SDLK_TAB,       INPUT_KEY_Tab         },
  { SDLK_q,         INPUT_KEY_q           },
  { SDLK_w,         INPUT_KEY_w           },
  { SDLK_e,         INPUT_KEY_e           },
  { SDLK_r,         INPUT_KEY_r           },
  { SDLK_t,         INPUT_KEY_t           },
  { SDLK_y,         INPUT_KEY_y           },
  { SDLK_u,         INPUT_KEY_u           },
  { SDLK_i,         INPUT_KEY_i           },
  { SDLK_o,         INPUT_KEY_o           },
  { SDLK_p,         INPUT_KEY_p           },
  { SDLK_CAPSLOCK,  INPUT_KEY_Caps_Lock   },
  { SDLK_a,         INPUT_KEY_a           },
  { SDLK_s,         INPUT_KEY_s           },
  { SDLK_d,         INPUT_KEY_d           },
  { SDLK_f,         INPUT_KEY_f           },
  { SDLK_g,         INPUT_KEY_g           },
  { SDLK_h,         INPUT_KEY_h           },
  { SDLK_j,         INPUT_KEY_j           },
  { SDLK_k,         INPUT_KEY_k           },
  { SDLK_l,         INPUT_KEY_l           },
  { SDLK_SEMICOLON, INPUT_KEY_semicolon   },
  { SDLK_QUOTE,     INPUT_KEY_apostrophe  },
  { SDLK_HASH,      INPUT_KEY_numbersign  },
  { SDLK_RETURN,    INPUT_KEY_Return      },
  { SDLK_LSHIFT,    INPUT_KEY_Shift_L     },
  { SDLK_z,         INPUT_KEY_z           },
  { SDLK_x,         INPUT_KEY_x           },
  { SDLK_c,         INPUT_KEY_c           },
  { SDLK_v,         INPUT_KEY_v           },
  { SDLK_b,         INPUT_KEY_b           },
  { SDLK_n,         INPUT_KEY_n           },
  { SDLK_m,         INPUT_KEY_m           },
  { SDLK_COMMA,     INPUT_KEY_comma       },
  { SDLK_PERIOD,    INPUT_KEY_period      },
  { SDLK_SLASH,     INPUT_KEY_slash       },
  { SDLK_RSHIFT,    INPUT_KEY_Shift_R     },
  { SDLK_LCTRL,     INPUT_KEY_Control_L   },
  { SDLK_LALT,      INPUT_KEY_Alt_L       },
  { SDLK_LMETA,     INPUT_KEY_Meta_L      },
  { SDLK_LSUPER,    INPUT_KEY_Super_L     },
  { SDLK_SPACE,     INPUT_KEY_space       },
  { SDLK_RSUPER,    INPUT_KEY_Super_R     },
  { SDLK_RMETA,     INPUT_KEY_Meta_R      },
  { SDLK_RALT,      INPUT_KEY_Alt_R       },
  { SDLK_RCTRL,     INPUT_KEY_Control_R   },
  { SDLK_MENU,      INPUT_KEY_Mode_switch },
  { SDLK_LEFT,      INPUT_KEY_Left        },
  { SDLK_DOWN,      INPUT_KEY_Down        },
  { SDLK_UP,        INPUT_KEY_Up          },
  { SDLK_RIGHT,     INPUT_KEY_Right       },
  { SDLK_PAGEUP,    INPUT_KEY_Page_Up     },
  { SDLK_PAGEDOWN,  INPUT_KEY_Page_Down   },
  { SDLK_HOME,      INPUT_KEY_Home        },
  { SDLK_END,       INPUT_KEY_End         },

  { 0, 0 }			/* End marker: DO NOT MOVE! */

};

#endif
