if( /LIBSPECTRUM_SNAP_ACCESSORS/ ) {

  open( DATAFILE, "< snap_accessors.txt" ) or die "Couldn't open `snap_accessors.txt': $!";

  $_ = '';
  while( <DATAFILE> ) {

    next if /^\s*$/; next if /^\s*#/;

    my( $type, $name, $indexed ) = split;

    my $return_type;
    if( $type =~ /^(.*)\*/ ) {
	$return_type = "$1 WIN32_DLL *";
    } else {
	$return_type = "$type WIN32_DLL";
    }

    if( $indexed ) {

	print << "CODE";
$return_type libspectrum_snap_$name( libspectrum_snap *snap, int idx );
void WIN32_DLL libspectrum_snap_set_$name( libspectrum_snap *snap, int idx, $type $name );
CODE

    } else {

	print << "CODE";
$return_type libspectrum_snap_$name( libspectrum_snap *snap );
void WIN32_DLL libspectrum_snap_set_$name( libspectrum_snap *snap, $type $name );
CODE

    }
  }
}

if( /LIBSPECTRUM_TAPE_ACCESSORS/ ) {

    open( DATAFILE, "< tape_accessors.txt" )
	or die "Couldn't open `tape_accessors.txt': $!";

    $_ = '';
    while( <DATAFILE> ) {

	# Remove comments and blank lines
	s/#.*//;
	next if /^\s*$/;

	# Skip which block types each accessor applies to
	next if /^\s/;
	
	my( $type, $name, $indexed, undef ) = split;
	
	my $return_type;
	if( $type =~ /^(.*)\*/ ) {
	    $return_type = "$1 WIN32_DLL *";
	} else {
	    $return_type = "$type WIN32_DLL";
	}

	if( $indexed ) {

	  print << "CODE";
$return_type libspectrum_tape_block_$name( libspectrum_tape_block *block, size_t idx );
libspectrum_error WIN32_DLL libspectrum_tape_block_set_$name( libspectrum_tape_block *block, $type \*$name );
CODE

	} else {

	print << "CODE";
$return_type libspectrum_tape_block_$name( libspectrum_tape_block *block );
libspectrum_error WIN32_DLL libspectrum_tape_block_set_$name( libspectrum_tape_block *block, $type $name );
CODE
    
	}
    }

    close DATAFILE or die "Couldn't close `tape_accessors.txt': $!";
}
