/*
readstring samba/relax - re-init samba, relax and set up g_smbpassword

*/

#ifndef RELAXCASE
#error make sure relax accessing is case sensitive
#endif

#ifndef CHEAT5000
#error remove 5000
#endif



CXBoxSample *g_app ;
CDebugClient *g_debugClient = NULL;
HANDLE g_hSoundThread ;
DWORD g_dwSoundThreadId ;

#include "relax.h"

char g_szLocalAddress[200] ;
char g_szLocalSubnet[200] ;
char g_szLocalGateway[200] ;

char g_szTitleIP[33] ;
char m_defaultRomDir[500] ;
char m_defaultMusicDir[500] ;

unsigned int m_currKeyboardKey ;
CRelax m_relax ;
char m_rlxShare[1024] ;
char m_bKeyboardMode ;
int  m_bUsingRelax ;
int  m_bBgmInGame ;
int  m_bAutoLoadSaveState ;
int  m_bAutoLoaded ;
int  m_bInCaptureMode ;
int  m_captureSpeed ;
int  m_throttleSpeed ;
int  g_throttle=0 ;
int  m_bRecreated ;
int  m_doDebug = 0 ;
unsigned int m_performanceFreq[2] ;
unsigned int m_performanceCurr[2] ;
unsigned int m_performancePrev[2] ;
int m_xboxVidmode  ;
CPanel m_pnlKeyboard ;

typedef struct INISTRUCT_STRUCT
{
	char *section ;
	char *setting ;
	char *value ;
	int  sectionnum ;
} INISTRUCT ;

INISTRUCT *m_iniHolder = NULL ;

int m_iniSize = 0 ;

#ifdef LIGHTGUN
int m_lightgunTarget = 0 ;
int m_lightgunRumble = 0 ;
#endif

DWORD g_keystroke_queue[4][32] ;

#ifdef __cplusplus
extern "C" {
#endif

extern unsigned char KEYBOARD_PIC[] ;
extern unsigned char KEYBOARD_VKMAP[] ;
extern unsigned char KEYBOARD_ASCIISHIFTMAP[] ;
extern unsigned char KEYBOARD_ASCIIMAP[] ;

void writexbox( char *msg ) ;
char global_error_message[1024] ;
void xbox_print_memory();

#ifdef __cplusplus
}
#endif

#define IN_GAME						0
#define IN_GAME_PAUSED				1
#define MAIN_MENU					2
#define INIT_SYSTEM					3
#define INIT_SYSTEM_SHOW_SCREEN     4

#define NAMES_PER_PAGE 25

char *XBOX_FILTERS[] = {
	"Point Filtering",
	"Bilinear Filtering",
	"Trilinear Filtering",
	"Anisotropic Filtering"
} ;

#define NUM_XBOX_FILTERS 4

struct vidmodes
{
	char name[100] ;
	unsigned int width ;
	unsigned int height ;
	char progressive ;
	float multx ;
	float multy ;
} VIDEOMODES[] = 
{
	{ "Standard 480i", 640, 480, 0, 1.0f, 1.0f },
	{ "480p", 640, 480, 1, 1.0f, 1.0f },
	{ "720p", 1280, 720, 1, 2.0f, 1.5f },
	{ "1080i", 1920, 1080, 0, 3.0f, 2.25f },
} ;

#define NUM_VIDEOMODES 4


void hq3x(uint8 *srcPtr, uint32 srcPitch, uint8 *deltaPtr, uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode ) ;

void dummy_blitter(uint8 *srcPtr, uint32 srcPitch, uint8 *deltaPtr, uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode ) 
{
}


#ifdef __cplusplus
extern "C" {
#endif

void _4xSaI(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void _4xSaIScanline(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperEagle4x(uint8 *srcPtr, uint32 srcPitch,
		uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperEagleScanline4x(uint8 *srcPtr, uint32 srcPitch,
		uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Super4xSaI(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Super4xSaIScanline(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Scale4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperScale4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void SuperScaleScanline4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void Eagle4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);
void EagleScanline4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode);

void Simple4x(unsigned char *srcPtr, uint32 srcPitch, unsigned char * /* deltaPtr */,
              unsigned char *dstPtr, uint32 dstPitch, int width, int height, int scanlines) ;
void AdMame4x(unsigned char *srcPtr, uint32 srcPitch, unsigned char * /* deltaPtr */,
              unsigned char *dstPtr, uint32 dstPitch, int width, int height, int scanline) ;

void hq2x_16(unsigned char*, unsigned char*, DWORD, DWORD, DWORD, DWORD, DWORD);
unsigned int   LUT16to32[65536];
unsigned int   RGBtoYUV[65536];

#ifdef __cplusplus
}
#endif

void hq2x_16_stub(uint8 *srcPtr, uint32 srcPitch, uint8 *deltaPtr, uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode ) 
{
    hq2x_16( srcPtr, dstPtr, width, height, dstPitch, srcPitch - (width<<1), dstPitch - (width<<2));

}

void doCubeTrans1( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
void doCubeTrans2( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
void doCubeTrans3( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
void doCubeTrans4( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
void doCubeTrans5( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
void doCubeTrans6( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
void doCubeTrans7( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
void doCubeTrans8( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
void doFadeTrans( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;

void doRandomEffect( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{
	int which = rand()%8 ;

	switch ( which )
	{
		case 0 : doCubeTrans1( pnl1, pnl2, speed, effect ) ; break ; 
		case 1 : doCubeTrans3( pnl1, pnl2, speed, effect ) ; break ; 
		case 2 : doCubeTrans4( pnl1, pnl2, speed, effect ) ; break ; 
		case 3 : doCubeTrans5( pnl1, pnl2, speed, effect ) ; break ; 
		case 4 : doCubeTrans6( pnl1, pnl2, speed, effect ) ; break ; 
		case 5 : doCubeTrans7( pnl1, pnl2, speed, effect ) ; break ; 
		case 6 : doCubeTrans8( pnl1, pnl2, speed, effect ) ; break ; 
		case 7 : doFadeTrans( pnl1, pnl2, speed, effect ) ; break ; 
		default : break ; 
	}

}


struct transitions
{
	void (*transfunc)( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) ;
	char name[100] ;
} TRANSITION_EFFECTS[] = 
{
	{ doRandomEffect, "Random" },
	{ doFadeTrans,  "Simple Fade" },
	{ doCubeTrans1, "Cube-turn" },
	{ doCubeTrans3, "Shattered Squares" },
	{ doCubeTrans4, "Quad-Split" },
	{ doCubeTrans5, "Quad-Spinning Cubes" },
	{ doCubeTrans6, "Dual-Plane Flap" },
	{ doCubeTrans7, "Dual-Plane Open/Close" },
	{ doCubeTrans8, "Zoom In/Out" },
} ;


#define NUM_TRANSITION_EFFECTS 9



#ifdef SUPPORT_4X

struct blitters
{
	void (*blitfunc)(uint8 *srcPtr, uint32 srcPitch, uint8 *deltaPtr, uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode ) ;
	char name[100] ;
	float  multiplier ;
} SOFTWARE_FILTERS[] = 
{
	{ dummy_blitter, "None", 1 },
	{ _2xSaI, "2xSai", 2},
	{ _4xSaI, "4xSai", 4},
	{ Super2xSaI, "Super 2xSai", 2},
	{ Super4xSaI, "Super 4xSai", 4},
	{ Eagle, "Eagle2x", 2},
	{ Eagle4x, "Eagle4x", 4},
	{ SuperEagle, "Super Eagle 2x", 2},
	{ SuperEagle4x, "Super Eagle 4x", 4},
	{ SuperScale, "SuperScale 2x", 2},
	{ SuperScale4x, "SuperScale 4x", 4},
	{ AdMame2x, "AdvanceMame 2x", 2},
	{ AdMame4x, "AdvanceMame 4x", 4},
	{ Simple2x, "Simple 2x", 2},
	{ Simple4x, "Simple 4x", 4},
	{ _2xSaIScanline, "2xSai Scanline", 2},
	{ _4xSaIScanline, "4xSai Scanline", 4},
	{ Super2xSaIScanline, "Super 2xSai Scanline", 2},
	{ Super4xSaIScanline, "Super 4xSai Scanline", 4},
	{ EagleScanline, "Eagle2x Scanline", 2},
	{ EagleScanline4x, "Eagle4x Scanline", 4},
	{ SuperEagleScanline, "Super Eagle2x Scanline", 2},
	{ SuperEagleScanline4x, "Super Eagle4x Scanline", 4},
	{ SuperScaleScanline, "SuperScale 2x Scanline", 2},
	{ SuperScaleScanline4x, "SuperScale 4x Scanline", 4},
} ;

#define HQFILTERNUM 1

#define NUM_SOFTWARE_FILTERS 25

#else

struct blitters
{
	void (*blitfunc)(uint8 *srcPtr, uint32 srcPitch, uint8 *deltaPtr, uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode ) ;
	char name[100] ;
	float  multiplier ;
} SOFTWARE_FILTERS[] = 
{
	{ dummy_blitter, "None", 1 },
	{ hq2x_16_stub, "HQ2X", 2},
	{ _2xSaI, "2xSai", 2},
	{ Super2xSaI, "Super 2xSai", 2},
	{ Eagle, "Eagle2x", 2},
	{ SuperEagle, "Super Eagle 2x", 2},
	{ SuperScale, "SuperScale 2x", 2},
	{ AdMame2x, "AdvanceMame 2x", 2},
	{ Simple2x, "Simple 2x", 2},
	{ _2xSaIScanline, "2xSai Scanline", 2},
	{ Super2xSaIScanline, "Super 2xSai Scanline", 2},
	{ EagleScanline, "Eagle2x Scanline", 2},
	{ SuperEagleScanline, "Super Eagle2x Scanline", 2},
	{ SuperScaleScanline, "SuperScale 2x Scanline", 2},
} ;

#define HQFILTERNUM 1

#define NUM_SOFTWARE_FILTERS 14

#endif



SoundXBOX *g_sound ;
Mp3Player *g_mp3player = NULL ;
float     *g_apptime ;
UINT32    *g_numframes ;
DWORD     g_dwStartTime ;
DWORD     g_dwTimePaused ;

char *g_smbPassword ;
char *g_smbUsername ;


char m_smbNameServer[50] ;
char m_szUserSavePath[500] ;
DWORD m_netplaySkip ;
DWORD m_netplayCurr ;
int m_playingMusic ;

#ifdef LIGHTGUN
CLightgun m_lightgun ;
#endif

int m_seeFavoritesPath ;
unsigned char *m_szEmuRecorder ;
byte m_emuRecording, m_emuPlaying, m_emuRecordSlot ;
DWORD m_emuRecordPosition ;
DWORD m_emuPlayPosition ;
DWORD m_emuPlaySize ;

class MyCallback : public SmbAnswerCallback

{

protected:

	// Warning: don't use a fixed size buffer in a real application.

	// This is a security hazard.

	char buf[200];

public:

	char *getAnswer(int type, const char *optmessage) {

		switch (type) {

			case ANSWER_USER_NAME:

				if ( g_smbPassword )
					strcpy(buf, g_smbPassword);
				else
					buf[0] = 0 ;

				break;

			case ANSWER_USER_PASSWORD:


				if ( g_smbPassword )
					strcpy(buf, g_smbPassword );
				else
					buf[0] = 0 ;

				break;

			case ANSWER_SERVICE_PASSWORD:

				if ( g_smbPassword )
					strcpy(buf, g_smbPassword );
				else
					buf[0] = 0 ;

				break;

		}

		return buf;

	}

} cb;


DWORD WINAPI Mp3player_ThreadFunc( LPVOID lpParam ) 
{ 

	float FPS ;
	unsigned int perfCurr[2] ;
	unsigned int perfPrev[2] ;

	QueryPerformanceCounter((union _LARGE_INTEGER *) perfPrev);

	while ( 1 )
	{

		do
		{
			QueryPerformanceCounter((union _LARGE_INTEGER *) perfCurr);

			if (perfCurr[0] != perfPrev[0])
			{					
				FPS = (float) (m_performanceFreq[0])  / (float) (perfCurr[0] - perfPrev[0]);
				//sprintf( global_error_message, "fps=%.1f %.1f\r\n", FPS, desiredFPS);
				//m_msgDelay = 20 ;
			}
			else
			{
				FPS = 200.0f ;
				//sprintf( global_error_message, "fps=too much...\r\n");
				//m_msgDelay = 20 ;
			}
			Sleep(1) ;

			//view_fps = 0;
		} while ( FPS > 120 ) ;

		perfPrev[0] = perfCurr[0];

		if ( g_mp3player )
		{
			g_mp3player->processReal() ;

		}
		
	}

    return 0; 
}


#define KEYLSHIFT   0x010000
#define KEYRSHIFT   0x020000
#define KEYLCTRL    0x040000
#define KEYRCTRL    0x080000
#define KEYLALT     0x100000
#define KEYRALT     0x200000
#define KEYCAPS     0x400000
#define KEYPRESSING 0x800000

void CXBoxSample::renderScreenKeyboard( )
{
	int panelx, panely ;

	if ( !m_bKeyboardMode )
		return ;

	LPDIRECT3DTEXTURE8	colorSquareTexture;

	D3DXCreateTexture(m_pd3dDevice, 1, 1, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &colorSquareTexture);
	
	D3DSURFACE_DESC desc;
    colorSquareTexture->GetLevelDesc(0, &desc);


	RECT rectSource;
	D3DLOCKED_RECT d3dlr;


	if ( MenuSprite==NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);


	DWORD color = 0x800066CC ;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 0;
	rectSource.right  = 0 ;

	colorSquareTexture->LockRect(0, &d3dlr, &rectSource, 0);

	memcpy( d3dlr.pBits, &color, sizeof(color) ) ;

	colorSquareTexture->UnlockRect(0);

	panelx = ( 640 -516)/2 ;
	panely = (480-196)/2 ; 

	m_pnlKeyboard.Render( panelx*VIDEOMODES[m_xboxVidmode].multx, panely*VIDEOMODES[m_xboxVidmode].multy, 516*VIDEOMODES[m_xboxVidmode].multx, 196*VIDEOMODES[m_xboxVidmode].multy ) ;

	D3DXVECTOR2 vecScale( 1, 1 ) ;
	D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * ( (m_currKeyboardKey&0xFF) % 16 )))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * ( (m_currKeyboardKey&0xFF) / 16 ) ))*VIDEOMODES[m_xboxVidmode].multy ) ;
	D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 31*VIDEOMODES[m_xboxVidmode].multy;
	rectSource.right  = 31*VIDEOMODES[m_xboxVidmode].multx ;

	MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);

	color = 0x8000CC66 ;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 0;
	rectSource.right  = 0 ;

	colorSquareTexture->LockRect(0, &d3dlr, &rectSource, 0);

	memcpy( d3dlr.pBits, &color, sizeof(color) ) ;


	if ( m_currKeyboardKey & KEYLSHIFT )
	{
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 31*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 31*VIDEOMODES[m_xboxVidmode].multx ;

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 0 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 4 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 1 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 4 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

	}

	if ( m_currKeyboardKey & KEYRSHIFT )
	{
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 31*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 31*VIDEOMODES[m_xboxVidmode].multx ;

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 12 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 4 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 13 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 4 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

	}
	if ( m_currKeyboardKey & KEYLCTRL )
	{
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 31*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 31*VIDEOMODES[m_xboxVidmode].multx ;

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 0 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 5 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 1 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 5 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

	}



	if ( m_currKeyboardKey & KEYRCTRL )
	{
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 31*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 31*VIDEOMODES[m_xboxVidmode].multx ;

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 10 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 5 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 11 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 5 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

	}

	if ( m_currKeyboardKey & KEYLALT )
	{
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 31*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 31*VIDEOMODES[m_xboxVidmode].multx ;

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 2 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 5 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 3 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 5 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

	}



	if ( m_currKeyboardKey & KEYRALT )
	{
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 31*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 31*VIDEOMODES[m_xboxVidmode].multx ;

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 8 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 5 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 9 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 5 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}

	}

	if ( m_currKeyboardKey & KEYCAPS )
	{
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 31*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 31*VIDEOMODES[m_xboxVidmode].multx ;

		{
			D3DXVECTOR2 vecScale( 1, 1 ) ;
			D3DXVECTOR2 vecTranslate( (panelx + 2 + ( 32 * 0 ))*VIDEOMODES[m_xboxVidmode].multx, (panely + 2 + ( 32 * 3 ))*VIDEOMODES[m_xboxVidmode].multy ) ;
			D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);

			MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);
		}


	}



	colorSquareTexture->UnlockRect(0);


	colorSquareTexture->Release() ;
}



void InitLUTs(void)
{
  int i, j, k, r, g, b, Y, u, v;

  for (i=0; i<65536; i++)
    LUT16to32[i] = ((i & 0xF800) << 8) + ((i & 0x07E0) << 5) + ((i & 0x001F) << 3);

  for (i=0; i<32; i++)
  for (j=0; j<64; j++)
  for (k=0; k<32; k++)
  {
    r = i << 3;
    g = j << 2;
    b = k << 3;
    Y = (r + g + b) >> 2;
    u = 128 + ((r - b) >> 2);
    v = 128 + ((-r + 2*g -b)>>3);
    RGBtoYUV[ (i << 11) + (j << 5) + k ] = (Y<<16) + (u<<8) + v;
  }

}


void CXBoxSample::fillPresentationParams()
{
	IDirect3D8 *pD3D ;

    ZeroMemory( &m_d3dpp, sizeof(m_d3dpp) );
    //m_d3dpp.BackBufferWidth        = 1920;
    //m_d3dpp.BackBufferHeight       = 1080;
    //m_d3dpp.BackBufferWidth        = 1280;
    //m_d3dpp.BackBufferHeight       = 720;
    m_d3dpp.BackBufferWidth        = 640;
    m_d3dpp.BackBufferHeight       = 480;
    //m_d3dpp.BackBufferFormat       = D3DFMT_A8R8G8B8 ;
    m_d3dpp.BackBufferFormat       = D3DFMT_R5G6B5 ;
    m_d3dpp.BackBufferCount        = 1;
    m_d3dpp.EnableAutoDepthStencil	=	TRUE;
    m_d3dpp.AutoDepthStencilFormat	=	D3DFMT_D16;
    m_d3dpp.SwapEffect             = D3DSWAPEFFECT_DISCARD;
    m_d3dpp.MultiSampleType			=	D3DMULTISAMPLE_NONE;


	bool bProgressive=false;
/*
	
	DWORD XVideoStandard = XGetVideoStandard();
	DWORD XVidMode = XGetVideoFlags();
	if ( XVidMode & XC_VIDEO_FLAGS_HDTV_720p) bProgressive=true;
	if ( XVidMode & XC_VIDEO_FLAGS_HDTV_480p) bProgressive=true;

	if( NULL != ( pD3D = Direct3DCreate8(D3D_SDK_VERSION) ) )
	{
		DWORD XNumModes = pD3D->GetAdapterModeCount( D3DADAPTER_DEFAULT );

		for( DWORD i = 0; i < XNumModes; i++ )
		{
			sprintfx( "checking mode %u of %u\r\n", i, XNumModes ) ;

			D3DDISPLAYMODE Mode;
			if( FAILED( pD3D->EnumAdapterModes( D3DADAPTER_DEFAULT, i, &Mode ) ) )
				break;

			if (Mode.RefreshRate==60)
			{
				//mp_msg(0,0,"%ix%i\n", Mode.Width,Mode.Height);
			}


			sprintfx( "rrate=%u, width=%u, height=%u, flags=%u, format=%u\r\n", Mode.RefreshRate, Mode.Width, Mode.Height, Mode.Flags, Mode.Format ) ;

			//if (Mode.Width != 640)
				//continue;


			if( ((XVidMode & XC_VIDEO_FLAGS_WIDESCREEN) != 0) &&
			    ((Mode.Flags & D3DPRESENTFLAG_WIDESCREEN) == 0) )
				continue;

			if( ((XVidMode & XC_VIDEO_FLAGS_WIDESCREEN) == 0) &&
			    ((Mode.Flags & D3DPRESENTFLAG_WIDESCREEN) != 0) )
				continue;

			if( (XVidMode & XC_VIDEO_FLAGS_HDTV_720p) != 0)
			{
				if( (Mode.Flags & D3DPRESENTFLAG_PROGRESSIVE) == 0)
					continue;
				if (Mode.Height != 720)
					continue;
			}
			
			if( (XVidMode & XC_VIDEO_FLAGS_HDTV_480p) != 0)
			{
				if( (Mode.Flags & D3DPRESENTFLAG_PROGRESSIVE) == 0)
					continue;
				if( Mode.Height != 480 )
					continue;
			}

			if( (XVidMode & (XC_VIDEO_FLAGS_HDTV_720p|XC_VIDEO_FLAGS_HDTV_480p)) == 0 &&
				(Mode.Flags & D3DPRESENTFLAG_PROGRESSIVE) != 0) 
				continue;

			if( (XVidMode & XC_VIDEO_FLAGS_HDTV_1080i) != 0 )
			{
				if( (Mode.Flags & D3DPRESENTFLAG_INTERLACED) == 0)
					continue;
				if( Mode.Height != 1080 )
					continue;
			}
			else if( (Mode.Flags & D3DPRESENTFLAG_PROGRESSIVE) &&  !bProgressive)
				continue;
			else if( (Mode.Flags & D3DPRESENTFLAG_INTERLACED) &&  bProgressive)
				continue;

			if ( XVideoStandard==XC_VIDEO_STANDARD_PAL_I)
			{
				// pal, disable ntsc resolutions
				if (Mode.Width==640 && Mode.Height==480 && (Mode.Flags & D3DPRESENTFLAG_INTERLACED)) continue;
				if (Mode.Width==720 && Mode.Height==480 && (Mode.Flags & D3DPRESENTFLAG_INTERLACED)) continue;
			}
			else
			{
				// ntsc, disable pal resolutions
				if (Mode.Width=640 && Mode.Height==576 && (Mode.Flags & D3DPRESENTFLAG_INTERLACED)) continue;
				if (Mode.Width=720 && Mode.Height==576 && (Mode.Flags & D3DPRESENTFLAG_INTERLACED)) continue;
			}

			// As near as we can tell, this is the video mode that matches
			// what the dashboard set.
			if ( (m_d3dpp.BackBufferWidth	< Mode.Width || m_d3dpp.BackBufferHeight < Mode.Height) )
			{
				m_d3dpp.BackBufferWidth	= Mode.Width;
				m_d3dpp.BackBufferHeight = Mode.Height;
				m_d3dpp.BackBufferFormat = Mode.Format;
				//
			}
		}
		SAFE_RELEASE(pD3D);
	}
*/

	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)
			m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			m_d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}
	else
		m_d3dpp.FullScreen_RefreshRateInHz = 60 ;


	//m_d3dpp.FullScreen_RefreshRateInHz = 50 ;

	//m_d3dpp.Flags |= ((XGetVideoFlags() & XC_VIDEO_FLAGS_WIDESCREEN)) ? D3DPRESENTFLAG_WIDESCREEN : 0;
	//m_d3dpp.Flags |= bProgressive ? D3DPRESENTFLAG_PROGRESSIVE : D3DPRESENTFLAG_INTERLACED;
	//xbApp.m_d3dpp.FullScreen_RefreshRateInHz			 =50 ;
	//m_d3dpp.FullScreen_RefreshRateInHz			 =D3DPRESENT_RATE_DEFAULT ;
	//xbApp.m_d3dpp.BackBufferWidth									= (INT) g_graphicsContext.GetWidth();
	//xbApp.m_d3dpp.BackBufferHeight								= (INT) g_graphicsContext.GetHeight();
	//m_d3dpp.BackBufferFormat								= D3DFMT_A8R8G8B8 ;
	//m_d3dpp.Flags = D3DPRESENTFLAG_INTERLACED | D3DPRESENTFLAG_WIDESCREEN ;
	//m_d3dpp.Flags = D3DPRESENTFLAG_PROGRESSIVE | D3DPRESENTFLAG_WIDESCREEN ;
	//m_d3dpp.Flags = D3DPRESENTFLAG_WIDESCREEN ;
    //m_d3dpp.BackBufferWidth        = 1920;
    //m_d3dpp.BackBufferHeight       = 1080;
    m_d3dpp.BackBufferWidth        = 640;
    m_d3dpp.BackBufferHeight       = 480;
    //m_d3dpp.BackBufferFormat       = D3DFMT_A8R8G8B8 ;
    //m_d3dpp.BackBufferFormat       = (D3DFORMAT)17 ; //D3DFMT_LIN_R5G6B5 ;
	//m_d3dpp.BackBufferFormat        = D3DFMT_A8R8G8B8 ;
	m_d3dpp.BackBufferFormat        = D3DFMT_LIN_R5G6B5 ;
	//m_d3dpp.Flags = 48 ;
	m_d3dpp.Flags = 0 ;

//15:14:04 socket=003E27B8, rrate=60, width=1280, height=720, flags=80, format=30
//15:14:04 socket=003E27B8, rrate=60, width=1280, height=720, flags=80, format=17
//15:14:04 socket=003E27B8, rrate=60, width=1280, height=720, flags=80, format=28
//15:14:04 socket=003E27B8, rrate=60, width=1280, height=720, flags=80, format=18


//flags=48, format=30
//flags=48, format=17
//flags=48, format=28
//flags=48, format=18

    //m_d3dpp.BackBufferFormat       = D3DFMT_A8R8G8B8 ;
    //m_d3dpp.BackBufferFormat       = D3DFMT_R5G6B5 ;
	m_d3dpp.BackBufferCount									= 1;
	m_d3dpp.EnableAutoDepthStencil					= TRUE;
	m_d3dpp.SwapEffect                      = D3DSWAPEFFECT_DISCARD;
	m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;
	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;


	//m_d3dpp.Flags = D3DPRESENTFLAG_EMULATE_REFRESH_RATE ;
	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
	//m_d3dpp.FullScreen_RefreshRateInHz = 60 ;

}


//-----------------------------------------------------------------------------
// Name: main()
// Desc: Entry point to the program.
//-----------------------------------------------------------------------------
VOID __cdecl main()
{

	g_debugClient = NULL ;

	CXBoxSample xbApp;

	g_app = &xbApp ;



	xbApp.fillPresentationParams() ;


	memcpy( &xbApp.m_origPP, &xbApp.m_d3dpp, sizeof(xbApp.m_origPP) ) ;


    if( FAILED( xbApp.Create() ) )
	{
        return;
	}


	writexbox("finished create\r\n") ;

/*
	//check for pal60 mode
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags && XC_VIDEO_FLAGS_PAL_60Hz)
			xbApp.SetRefreshRate(60) ;
		else
			xbApp.SetRefreshRate(50) ;
	}
	else
		xbApp.SetRefreshRate(60) ;
*/

			//xbApp.SetRefreshRate(60) ;

/*	//check for pal60 mode
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags && XC_VIDEO_FLAGS_PAL_60Hz)
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}
	else
		xbApp.m_d3dpp.FullScreen_RefreshRateInHz = 60 ;
*/

    xbApp.Run();
}




BOOL CXBoxSample::SetRefreshRate(INT iRefreshRate)
{
	char xmsg[100] ;

	/*
	CHAR szDebug[64];
	wsprintf(szDebug,"SetRefreshRate: %d\n",iRefreshRate);
	OutputDebugString(szDebug);

	BOOL bIsUsingWidescreenSignal	= m_d3dpp.Flags & D3DPRESENTFLAG_WIDESCREEN;
	BOOL bIsUsingPAL							= XGetVideoStandard() & XC_VIDEO_STANDARD_PAL_I;
	BOOL bSupports60Hz						= ( (XGetVideoFlags() & XC_VIDEO_FLAGS_PAL_60Hz) || (!bIsUsingPAL) );

	
	if ( (!bIsUsingPAL) && (iRefreshRate==50) )
	{
		OutputDebugString("User display does not support 50hz\n");
		return FALSE;
	}

	if ( (!bSupports60Hz) && (iRefreshRate==60) )
	{
		OutputDebugString("User display does not support 60hz\n");
		return FALSE;
	}

	/* resolutions which support pal 60:
	/* 640x480, 720x480 
	/* 640x240, 720x240 

	bool bResolutionOK=false;
	if (m_d3dpp.BackBufferWidth ==640 && m_d3dpp.BackBufferHeight==480) bResolutionOK=true;
	if (m_d3dpp.BackBufferWidth ==720 && m_d3dpp.BackBufferHeight==480) bResolutionOK=true;
	if (m_d3dpp.BackBufferWidth ==640 && m_d3dpp.BackBufferHeight==240) bResolutionOK=true;
	if (m_d3dpp.BackBufferWidth ==720 && m_d3dpp.BackBufferHeight==240) bResolutionOK=true;
	if ( !bResolutionOK && bIsUsingPAL && (iRefreshRate==60) )
	{
		wsprintf(szDebug,	"Unable to use PAL60 at %dx%d resolution.\n",
							m_d3dpp.BackBufferWidth,
							m_d3dpp.BackBufferHeight);
		OutputDebugString(szDebug);
		return FALSE;
	}

	if ( (bIsUsingPAL && bIsUsingWidescreenSignal) && (iRefreshRate==60) )
	{
		OutputDebugString("Xbox hardware does not support PAL60 and widescreen signal.\n");
		OutputDebugString("Widescreen signal has been disabled.\n");
		m_d3dpp.Flags ^= D3DPRESENTFLAG_WIDESCREEN;
	}
	*/

	//if (m_d3dpp.FullScreen_RefreshRateInHz != iRefreshRate)
	//{
		m_d3dpp.FullScreen_RefreshRateInHz = iRefreshRate;
	DWORD res = 	m_pd3dDevice->Reset(&m_d3dpp);

	sprintf(xmsg, "res=%u, ok=%u\r\n", res, DS_OK ) ;
	writexbox(xmsg) ;

	//}

	return TRUE;
}


//-----------------------------------------------------------------------------
// Name: CXBoxSample (constructor)
// Desc: Constructor for CXBoxSample class
//-----------------------------------------------------------------------------
CXBoxSample::CXBoxSample() 
            :CXBApplication()
{
    m_bDrawHelp = FALSE;
	m_state = MAIN_MENU ;
	files = NULL ;
	global_error_message[0] = 0 ;
	g_sound = &m_sound ;
	g_mp3player = &m_mp3player ;
	g_apptime = &m_fAppTime ;
	g_numframes = &m_numFrames ;

	m_steps = 0 ;

}




int CXBoxSample::init_white_texture()
{
	// Release any previous texture
	if (WhiteTexture) 
	{ 
		WhiteTexture->Release();
		WhiteTexture = NULL;
	}
	
	// Create the texture
	D3DXCreateTexture(m_pd3dDevice, 1, 1, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &WhiteTexture);
	
	D3DSURFACE_DESC desc;
    WhiteTexture->GetLevelDesc(0, &desc);


	RECT rectSource;
	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 0;
	rectSource.right  = 0 ;

	D3DLOCKED_RECT d3dlr;
	WhiteTexture->LockRect(0, &d3dlr, &rectSource, 0);

	DWORD color ;

	color = 0xFFFFFFFF ;

	memcpy( d3dlr.pBits, &color, sizeof(color) ) ;

	// Unlock our texture
	WhiteTexture->UnlockRect(0);

	if ( MenuSprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);

	return 0;
}

BOOL InitializeNetwork();

//-----------------------------------------------------------------------------
// Name: Initialize
// Desc: Peforms initialization
//-----------------------------------------------------------------------------
HRESULT CXBoxSample::Initialize()
{

#ifdef DEBUG_KEYBOARD
	if ( Keyboard_Init( 25, 500, 50 ) )
	{
	    OUTPUT_DEBUG_STRING( "Inited keyboard success\n" );
	}
	else
	{
	    OUTPUT_DEBUG_STRING( "Inited keyboard failure\n" );
	}

	if ( Keyboard_Status() )
	{
	    OUTPUT_DEBUG_STRING( "Found keyboard\n" );
	}
	else
	{
	    OUTPUT_DEBUG_STRING( "Not Found keyboard\n" );
	}
#endif
#ifdef DEBUG_MOUSE
	XBInput_InitDebugMouse() ;
#endif

#ifdef USE_DEBUGCLIENT
	if ( m_debugClient.Init( "192.168.123.77", 7654, 1 ) == 0 )
	{
		//strcpy( global_error_message, "*debugclientinit" ) ;
		//return 0 ;
	}
#endif
	//m_logfile = fopen( "D:\\err.log", "wb" ) ;


	g_debugClient = &m_debugClient ;


    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_sound.dsound),  NULL ) ) )
        return E_FAIL;

    // Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &(m_mp3player.dsound),  NULL ) ) )
        return E_FAIL;

	if ( ( XCreateSaveGame( "U:\\", PLATFORM_SAV, OPEN_ALWAYS, 0, g_savePath, 500 ) ) != ERROR_SUCCESS )
	{
        //return E_FAIL;
	}

	m_sound.dsound_init() ;
	m_mp3player.dsound_init() ;

	m_sound.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;
	m_mp3player.m_fps = m_d3dpp.FullScreen_RefreshRateInHz ;


	m_state = INIT_SYSTEM ;

	return S_OK ;
}


void CXBoxSample::SetupPlaything( )
{
	int randsprite ;
	ControlType ctype ;

	//if (m_plaything.m_spritedefs.GetSize() < 5 )
		//return ;

	m_plaything.Initialize( m_pd3dDevice, &m_Font, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;

	m_plaything.m_sprites.RemoveAll() ;
	m_plaything.m_sprites.SetSize(100) ;
	for ( int i = 0 ; i < 100 ; i++ )
	{
		m_plaything.m_sprites[i].plaything = &m_plaything ;
		m_plaything.m_sprites[i].m_spritenum = i ;
		//m_plaything.m_sprites[i].m_bIsActive = 0 ;

	}
	
	//sprintfx( "checking for active sprites\r\n") ;
	for ( int i = 0 ; i < 20 ; i++ )
	{
		if ( ( m_ptConfig.sprites[i].sprite >= 0 ) && ( m_plaything.m_spritedefs.GetSize() > m_ptConfig.sprites[i].sprite ) )
		{
	//sprintfx( "found active normal sprite %u %d\r\n", i, m_ptConfig.sprites[i].sprite ) ;
			m_plaything.m_sprites[i].Setup( &(m_plaything.m_spritedefs[m_ptConfig.sprites[i].sprite]), 
				m_ptConfig.sprites[i].offsetX, m_ptConfig.sprites[i].offsetY, 
				m_ptConfig.sprites[i].motionX, m_ptConfig.sprites[i].motionY, 
				m_ptConfig.sprites[i].scale, m_ptConfig.sprites[i].framespeed, 
				100, STATIC, 0, 120,0,0, m_ptConfig.sprites[i].transparency, m_ptConfig.sprites[i].flipH, m_ptConfig.sprites[i].flipV,
				m_ptConfig.sprites[i].loopOnce, m_ptConfig.sprites[i].rotate,
				m_ptConfig.sprites[i].rect_t, m_ptConfig.sprites[i].rect_b,
				m_ptConfig.sprites[i].rect_l, m_ptConfig.sprites[i].rect_r) ;
			m_plaything.m_sprites[i].m_respawnTime = 0 ;
		}
	}
/*

	m_plaything.m_sprites[0].Setup( &(m_plaything.m_spritedefs[m_ptConfig.heroSprite]), 308, 224, 0, 0, m_ptConfig.heroSize, 15, m_ptConfig.heroSpeed, HUMAN, 0, 120,0,0 ) ;
	m_plaything.m_sprites[0].m_respawnTime = 0 ;

	for ( int i = 4 ; i < 4+m_ptConfig.numEnemies ; i++ )
	{
		if ( m_ptConfig.numChasers  > i-4 )
			ctype = COMPUTER_HOSTILE ;
		else
			ctype = COMPUTER_RANDOM ;

		if ( m_ptConfig.enemySprite < 0 )
		{
			randsprite = rand()%m_plaything.m_spritedefs.GetSize() ;
			if ( randsprite == PROJECTILE_DEF )
				randsprite-- ;
		}
		else
			randsprite = m_ptConfig.enemySprite ;

		m_plaything.m_sprites[i].Setup( &(m_plaything.m_spritedefs[randsprite]), 0, 0, 0, 0, m_ptConfig.enemySize, 15, m_ptConfig.enemySpeed, ctype, 0, m_ptConfig.enemyRespawn*30, m_ptConfig.enemyFireFreq*1, (m_ptConfig.enemySprite < 0) ) ;
	}


	for ( int i = 84 ; i < 100 ; i++ )
	{
		m_plaything.m_sprites[i].Setup( &(m_plaything.m_spritedefs[PROJECTILE_DEF]), 0, 0, 0, 0, 0.50f, 10, 99, STATIC, 0, 1,0,0 ) ;
		m_plaything.m_sprites[i].m_bIsActive = 0 ;
		m_plaything.m_sprites[i].m_respawnTime = 0 ;

	}
*/
	if ( ( m_ptConfig.effects[0].sprite >= 0 ) && ( m_ptConfig.effects[0].effect != STATIC ) && ( m_plaything.m_spritedefs.GetSize() > m_ptConfig.effects[0].sprite ) )
	{
	//sprintfx( "found active fx1\r\n" ) ;
		for ( int i = 24 ; i < 24+m_ptConfig.effects[0].numsprites ; i++ )
		{
			m_plaything.m_sprites[i].Setup( &(m_plaything.m_spritedefs[m_ptConfig.effects[0].sprite]), 0, 0, 0, 0, m_ptConfig.effects[0].scale, m_ptConfig.effects[0].framespeed, m_ptConfig.effects[0].speed, m_ptConfig.effects[0].effect, 0, 1,0,0, m_ptConfig.effects[0].transparency, m_ptConfig.effects[0].flipH, m_ptConfig.effects[0].flipV, 0, 0, 0, 480, 0, 640 ) ;
			m_plaything.m_sprites[i].m_respawnTime = 0 ;
			memcpy( &(m_plaything.m_sprites[i].m_effectVars), &(m_ptConfig.effects[0]), sizeof(m_ptConfig.effects[0]) ) ;
		}
	}
	if ( ( m_ptConfig.effects[1].sprite >= 0 ) && ( m_ptConfig.effects[1].effect != STATIC ) && ( m_plaything.m_spritedefs.GetSize() > m_ptConfig.effects[1].sprite ) )
	{
	//sprintfx( "found active fx2 \r\n" ) ;
		for ( int i = 44 ; i < 44+m_ptConfig.effects[1].numsprites ; i++ )
		{
			m_plaything.m_sprites[i].Setup( &(m_plaything.m_spritedefs[m_ptConfig.effects[1].sprite]), 0, 0, 0, 0, m_ptConfig.effects[1].scale, m_ptConfig.effects[1].framespeed, m_ptConfig.effects[1].speed, m_ptConfig.effects[1].effect, 0, 1,0,0, m_ptConfig.effects[1].transparency, m_ptConfig.effects[1].flipH, m_ptConfig.effects[1].flipV,0,0, 0, 480, 0, 640 ) ;
			m_plaything.m_sprites[i].m_respawnTime = 0 ;
			memcpy( &(m_plaything.m_sprites[i].m_effectVars), &(m_ptConfig.effects[1]), sizeof(m_ptConfig.effects[1]) ) ;
		}
	}
	if ( ( m_ptConfig.effects[2].sprite >= 0 ) && ( m_ptConfig.effects[2].effect != STATIC ) && ( m_plaything.m_spritedefs.GetSize() > m_ptConfig.effects[2].sprite ) )
	{
	//sprintfx( "found active fx3 \r\n" ) ;
		for ( int i = 64 ; i < 64+m_ptConfig.effects[2].numsprites ; i++ )
		{
			m_plaything.m_sprites[i].Setup( &(m_plaything.m_spritedefs[m_ptConfig.effects[2].sprite]), 0, 0, 0, 0, m_ptConfig.effects[2].scale, m_ptConfig.effects[2].framespeed, m_ptConfig.effects[2].speed, m_ptConfig.effects[2].effect, 0, 1,0,0, m_ptConfig.effects[2].transparency, m_ptConfig.effects[2].flipH, m_ptConfig.effects[2].flipV,0,0, 0, 480, 0, 640 ) ;
			m_plaything.m_sprites[i].m_respawnTime = 0 ;
			memcpy( &(m_plaything.m_sprites[i].m_effectVars), &(m_ptConfig.effects[2]), sizeof(m_ptConfig.effects[2]) ) ;
		}
	}

}


void CXBoxSample::doPlaythingClear( )
{
	int fResult ;
	char xmsg[100] ;
	int menuChoice = 0 ;
	int bdone ;
	WCHAR msg[200] ;
	float mx, my ;
	int shoot ;


	bdone = 0 ;


	if ( m_plaything.m_spritedefs.GetSize() <5 )
		return ;


	while ( !bdone )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_mp3player.process() ;

	
        XBInput_GetInput();

		if ( g_Gamepads[0].hDevice )
		{
			mx = g_Gamepads[0].fX1 ;
			my = g_Gamepads[0].fY1 ;
		}
		else
		{
			mx=my=0 ;
		}

		m_plaything.Render( mx,my,g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B]) ;

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
	        XBInput_GetInput();
			return  ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
	        XBInput_GetInput();
			return  ;
		}


	}
}
void CXBoxSample::doSavePlaything()
{
	FILE *inifile ;
	char tmpfilename[MAX_PATH] ;

	strcpy( tmpfilename, g_savePath ) ;
	strcat( tmpfilename, PLAYTHING_INI ) ;

	inifile = fopen( tmpfilename, "wb" ) ;

	if ( inifile != NULL )
	{
		fwrite( &m_ptConfig, sizeof(char), sizeof(m_ptConfig), inifile ) ;
		fclose( inifile ) ;
	}

}

void CXBoxSample::doLoadPlaything()
{
	FILE *inifile ;
	char tmpfilename[MAX_PATH] ;

	strcpy( tmpfilename, g_savePath ) ;
	strcat( tmpfilename, PLAYTHING_INI ) ;

	inifile = fopen( tmpfilename, "rb" ) ;

	if ( inifile != NULL )
	{
		fread( &m_ptConfig, sizeof(char), sizeof(m_ptConfig), inifile ) ;
		fclose( inifile ) ;
	}

}



void CXBoxSample::loadFavorites()
{
	char favfilename[MAX_PATH] ;
	FILE *favfile ;
	char *buf ;
	unsigned int filesize ;
	char *spos, *epos ;

	if ( m_filesFavorites )
	{
		free( m_filesFavorites ) ;
	}

	m_filesFavorites = NULL;
	m_numFavorites  = 0 ;

	sprintf( favfilename, "%s\\favorites.txt", g_savePath ) ;

	favfile = fopen( favfilename, "rb" ) ;

	if ( favfile )
	{
		fseek( favfile, 0, SEEK_END ) ;
		filesize = ftell( favfile ) ;
		fseek( favfile, 0, SEEK_SET ) ;

		if ( filesize )
		{
			buf = (char*)malloc( filesize+3 ) ;

			memset(buf,0,filesize+3) ;

			fread( buf, sizeof(char), filesize, favfile ) ;

			spos = buf ;
			epos = buf ;

			while ( *spos )
			{
				while ( *spos && ( ( *spos == '\r' ) || ( *spos == '\n' ) ) )
				{
					spos++ ;
				}

				epos = spos ;

				if ( *spos )
				{
					while ( *epos && ( ! ( ( *epos == '\r' ) || ( *epos == '\n' ) ) ) )
					{
						epos++ ;
					}

					*epos = 0 ;
					addFavorite( spos ) ;
					spos = epos+1 ;
				}
			}

			free(buf) ;
		}

		fclose(favfile) ;
	}


}
int getLine( char *pos, char *line, unsigned int linesize )
{
	unsigned int linepos ;
	int advance ;

	linepos = 0 ;
	advance = 0 ;


	memset( line, 0, linesize ) ;

	if ( !pos )
		return advance ;

	while ( *pos && ( isspace( *pos ) ) )
	{
		pos++ ;
		advance++ ;
	}

	if ( ! *pos )
		return advance;

	while ( *pos && ( *pos != '\r' ) && ( *pos != '\n' )  && ( linepos < ( linesize-2) ) )
	{
		line[linepos++] = *pos ;
		pos++ ;
		advance++ ;
	}

	line[linepos] = 0 ;

	while ( linepos && ( ( line[linepos-1] == ' ' ) || ( line[linepos-1]== '\t' ) ) )
	{
		line[linepos-1] = 0 ;
		linepos-- ;
	}

	return advance ;
}

void fillIniStruct( char *buf )
{
	char section[100] ;
	char setting[100] ;
	char value[500] ;
	char line[505] ;
	int section_pos ;
	int setting_pos ;
	int advance ;
	char *ptr ;
	int section_num ;
	char *secpos_b ;
	char *secpos_e ;
	int  linepos ;

	if ( m_iniHolder != NULL )
	{
		for ( int i = 0 ; i < m_iniSize ; i++ )
		{
			free( m_iniHolder[i].section ) ;
			free( m_iniHolder[i].setting ) ;
			free( m_iniHolder[i].value ) ;
		}

		free( m_iniHolder ) ;
		m_iniHolder = NULL ;
		m_iniSize = 0 ;
	}


	if ( buf == NULL )
		return ;

	section_num = 0 ;


	ptr = buf ;

	while ( advance = getLine( ptr, line, 500 ) )
	{
		ptr += advance ;

		if ( line[0] == '#' )
			continue ;

		if ( line[0] == '[' )
		{

			secpos_b = line ;

			section_pos = 0 ;
			setting_pos = 0 ;

			secpos_e = secpos_b+1 ;

			while ( *secpos_e && ( *secpos_e != ']' ) && ( section_pos < 99 ) )
			{
				if ( ! isspace( *secpos_e ) )
				{
					section[section_pos++] = *secpos_e ;
				}

				secpos_e++ ;
			}

			if ( *secpos_e != ']' ) 
			{
				section[0] = 0 ;
				section_pos = 0 ;
				continue ;
			}

			section[section_pos] = 0 ;
			strupr( section ) ;
			section_num++ ;

			continue ;
		}

		if ( secpos_e = strchr( line, '=' ) )
		{
			strncpy( setting, line, min( 99, secpos_e-line) ) ;
			setting[ min( 99, secpos_e - line) ] = 0 ;

			linepos = strlen( setting )  ;
			while ( linepos && ( ( setting[linepos-1] == ' ' ) || ( setting[linepos-1]== '\t' ) ) )
			{
				setting[linepos-1] = 0 ;
				linepos-- ;
			}

			strncpy( value, secpos_e+1, min( 499, strlen( secpos_e +1 ) ) ) ;
			value[ min( 499, strlen( secpos_e+1 ) ) ] = 0 ;

			linepos = strlen( value )  ;
			while ( linepos && ( ( value[linepos-1] == ' ' ) || ( value[linepos-1]== '\t' ) ) )
			{
				value[linepos-1] = 0 ;
				linepos-- ;
			}

			strupr( setting ) ;

			m_iniHolder = (INISTRUCT*)realloc( m_iniHolder, sizeof(INISTRUCT) * ( m_iniSize  + 1 ) ) ;

			m_iniHolder[m_iniSize].section = (char*)malloc( strlen(section)+1 ) ;
			m_iniHolder[m_iniSize].setting = (char*)malloc( strlen(setting)+1 ) ;
			m_iniHolder[m_iniSize].value = (char*)malloc( strlen(value)+1 ) ;
			m_iniHolder[m_iniSize].sectionnum = section_num ;

			strcpy(m_iniHolder[m_iniSize].section , section ) ;
			strcpy(m_iniHolder[m_iniSize].setting, setting ) ;
			strcpy(m_iniHolder[m_iniSize].value , value ) ;

			m_iniSize++ ;


		}

	}


}


void CXBoxSample::loadKeys( char *keyfile ) 
{
	FILE *kfile ;
	char *buf ;
	int filesize ;

	if ( kfile = fopen( keyfile, "rb" ) )
	{
		fseek( kfile, 0, SEEK_END ) ;
		filesize = ftell( kfile ) ;
		fseek( kfile, 0, SEEK_SET ) ;

		buf = (char*)malloc( filesize+2 ) ;
		memset(buf, 0, filesize+2 ) ;

		fread( buf, sizeof(char), filesize, kfile ) ;
		fclose( kfile ) ;

		fillIniStruct( buf );

		loadControllerSettings( buf ) ;

		free(buf) ;
		fillIniStruct( NULL );
	}
}


void CXBoxSample::saveKeys( char *keyfile ) 
{
	FILE *kfile ;

	if ( kfile = fopen( keyfile, "wb" ) )
	{
		saveControllerSettings( kfile ) ;
		
		fclose( kfile ) ;

	}
}

int CXBoxSample::receiveNetworkData( )
{
	int bytesread = 0 ;
	int result ; 
	DWORD recvTime = GetTickCount() ;

	//sprintfx( "recv cs=%u, bytesread=%u 1 \r\n", m_bNetplay, bytesread ) ;

	while ( bytesread < sizeof(DWORD)*4 )
	{
	//sprintfx( "recv cs=%u, bytesread=%u 2 \r\n", m_bNetplay, bytesread ) ;
		result = m_sockNetplay.Recv( ((char*)&m_networkEmuControllers)+bytesread, (sizeof(DWORD)*4 - bytesread) ) ;

		if ( ( result > 0 ) && ( result < 1000 ) )
			bytesread += result ;

		if ( GetTickCount() - recvTime > 30000 )
		{
			popupMsg( "Network connection lost.  Press B to return to main menu.", &m_pnlBackgroundOther ) ;
			return 1 ;
		}
	}

	//if ( m_bNetplay == 2 )
		//popupMsg( " srv finished recv loop", &m_pnlBackgroundOther ) ;
	//else
		//popupMsg( "clnt finished recv loop", &m_pnlBackgroundOther ) ;

	//sprintfx( "recv cs=%u, bytesread=%u 3 \r\n", m_bNetplay, bytesread ) ;
	bytesread = 0 ;

	while ( bytesread < sizeof(DWORD) )
	{
	//sprintfx( "recv cs=%u, bytesread=%u 4 \r\n", m_bNetplay, bytesread ) ;
		result = m_sockNetplay.Recv( ((char*)&m_networkStatus)+bytesread, (sizeof(DWORD) - bytesread) ) ;

		if ( ( result > 0 ) && ( result < 1000 ) )
			bytesread += result ;

		if ( GetTickCount() - recvTime > 30000 )
		{
			popupMsg( "Network connection lost.  Press B to return to main menu.", &m_pnlBackgroundOther ) ;
			return 1 ;
		}
	}

	return 0 ;
}

int CXBoxSample::pollNetworkControllers( )
{

	int ourStatus = 0 ;

	memcpy( &m_prevEmuControllers, &m_emuControllers, sizeof( DWORD) *4 ) ;


	for ( int i = 0; i < 4 ; i++ )
	{

		if ( ( m_mappings[i].options_menu ) && ( ( m_xboxControllers[i] & m_mappings[i].options_menu ) == m_mappings[i].options_menu ) )
			ourStatus = 1 ;
	}


	if ( m_bNetplay ==2 ) //server
	{
		m_sockNetplay.Send( &m_emuControllers, sizeof(DWORD)*4 ) ;
		m_sockNetplay.Send( &ourStatus, sizeof(DWORD) ) ;

		if ( receiveNetworkData() )
			return 1 ;

	}
	else  //client
	{
		m_sockNetplay.Send( &m_emuControllers, sizeof(DWORD)*4 ) ;
		m_sockNetplay.Send( &ourStatus, sizeof(DWORD) ) ;

		if ( receiveNetworkData() )
			return 1 ;

	}

	if ( m_networkStatus )
	{
		int bytesread = 0 ;
		char result = 0 ;

		m_networkStatus = 0 ;

		while ( bytesread != 1 )
		{
			popupMsg( "Netplayer Paused - Press B to exit", &m_pnlBackgroundOther, 1 ) ;

			if(g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_B])
			{
				return 1 ;
			}

			bytesread = m_sockNetplay.Recv( &result, 1 ) ;
		}

		m_sockNetplay.Send( &m_emuControllers, sizeof(DWORD)*4 ) ;
		m_sockNetplay.Send( &ourStatus, sizeof(DWORD) ) ;

		if ( receiveNetworkData() )
			return 1 ;

		if ( result )
			return 1 ;

	}

	return 0 ;
}

int CXBoxSample::pollXBoxControllers( )
{
	DWORD retval ;
	DWORD emuval ;
	DWORD keystroke_iter ;

	if ( g_app->m_state == MAIN_MENU )
		return 1 ;

	XBInput_GetInput();
	memset( g_keystroke_queue, 0, sizeof( DWORD) * 32 * 4 ) ;

	for ( int i = 0 ; i < 4 ; i++ )
	{
		retval = 0 ;


		if ( g_Gamepads[i].hDevice )
		{
			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_A] > m_mappings[i].analog_sensitivity )
			{
				retval |= XBOX_A ;
			}
			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_B] > m_mappings[i].analog_sensitivity )
			{
				retval |= XBOX_B ;
			}
			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_X] > m_mappings[i].analog_sensitivity )
			{
				retval |= XBOX_X ;
			}
			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_Y] > m_mappings[i].analog_sensitivity )
			{
				retval |= XBOX_Y ;
			}
			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_BLACK] > m_mappings[i].analog_sensitivity )
			{
				retval |= XBOX_BLACK ;
			}
			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_WHITE] > m_mappings[i].analog_sensitivity )
			{
				retval |= XBOX_WHITE ;
			}
			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			{
				retval |= XBOX_DPAD_UP ;
			}
			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
			{
				retval |= XBOX_DPAD_DOWN ;
			}
			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
			{
				retval |= XBOX_DPAD_LEFT ;
			}
			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
			{
				retval |= XBOX_DPAD_RIGHT ;
			}
			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_START )  
			{
				retval |= XBOX_START ;
			}
			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_BACK )  
			{
				retval |= XBOX_BACK ;
			}
			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_LEFT_THUMB )  
			{
				retval |= XBOX_LEFT_THUMB ;
			}
			if ( g_Gamepads[i].wButtons & XINPUT_GAMEPAD_RIGHT_THUMB )  
			{
				retval |= XBOX_RIGHT_THUMB ;
			}
			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] > m_mappings[i].analog_sensitivity )
			{
				retval |= XBOX_LEFT_TRIGGER ;
			}
			if ( g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] > m_mappings[i].analog_sensitivity )
			{
				retval |= XBOX_RIGHT_TRIGGER ;
			}
			if ( g_Gamepads[i].fX1 > 0.30f )
			{
				retval |= XBOX_LTHUMB_RIGHT ;
			}
			if ( g_Gamepads[i].fX1 < -0.30f )
			{
				retval |= XBOX_LTHUMB_LEFT ;
			}
			if ( g_Gamepads[i].fY1 > 0.30f )
			{
				retval |= XBOX_LTHUMB_UP ;
			}
			if ( g_Gamepads[i].fY1 < -0.30f )
			{
				retval |= XBOX_LTHUMB_DOWN ;
			}
			if ( g_Gamepads[i].fX2 > 0.30f )
			{
				retval |= XBOX_RTHUMB_RIGHT ;
			}
			if ( g_Gamepads[i].fX2 < -0.30f )
			{
				retval |= XBOX_RTHUMB_LEFT ;
			}
			if ( g_Gamepads[i].fY2 > 0.30f )
			{
				retval |= XBOX_RTHUMB_UP ;
			}
			if ( g_Gamepads[i].fY2 < -0.30f )
			{
				retval |= XBOX_RTHUMB_DOWN ;
			}
		}
		m_xboxControllers[i] = retval ;

		emuval = 0 ;
		keystroke_iter = 0 ;

		for ( int j = 0 ; j < 32 ; j++ )
		{
			if ( ( m_mappings[i].emu_buttons[j] ) && ( ( retval & m_mappings[i].emu_buttons[j] ) == m_mappings[i].emu_buttons[j] ) )
			{
				//if ( i==0 )
					//sprintfx( "%u retval %08.8X, button %08.8X\r\n", j, retval, m_mappings[i].emu_buttons[j] ) ;

				if ( m_mappings[i].emu_buttons_autofire[j] )
				{
					//sprintfx( "autofire on %u %u\r\n", i, j) ;
					if ( m_mappings[i].emu_buttons_autofire_last[j] )
					{
						m_mappings[i].emu_buttons_autofire_last[j]-- ;
						//sprintfx( "lastval match %u %u\r\n", i, j) ;
					}
					else
					{
						//sprintfx( "lastval no match %u %u\r\n", i, j) ;
						m_mappings[i].emu_buttons_autofire_last[j] = m_mappings[i].emu_buttons_autofire[j] ;

						if ( g_emuButtonDefinitions[ m_mappings[i].emu_buttons_definition[j] ].value & 0x80000000 ) 
						{
							g_keystroke_queue[i][keystroke_iter++] = g_emuButtonDefinitions[ m_mappings[i].emu_buttons_definition[j] ].value  ;
						}
						else
						{
							emuval |= g_emuButtonDefinitions[ m_mappings[i].emu_buttons_definition[j] ].value ;
						}
					}
				}
				else
				{
					if ( g_emuButtonDefinitions[ m_mappings[i].emu_buttons_definition[j] ].value & 0x80000000 ) 
					{
						g_keystroke_queue[i][keystroke_iter++] = g_emuButtonDefinitions[ m_mappings[i].emu_buttons_definition[j] ].value & ~0x80000000 ;
					}
					else
					{
						emuval |= g_emuButtonDefinitions[ m_mappings[i].emu_buttons_definition[j] ].value ;
					}
				}
			}
		}

		m_emuControllers[i] = emuval ;
		//sprintfx( "emucont %u val %08.8Xu\r\n", i, emuval ) ;

	}

	if ( m_bNetplay )
	{
		int ourStatus ;

		ourStatus = 0 ;

		for ( int i = 0; i < 4 ; i++ )
		{

			if ( ( m_mappings[i].options_menu ) && ( ( m_xboxControllers[i] & m_mappings[i].options_menu ) == m_mappings[i].options_menu ) )
				ourStatus = 1 ;
		}

		if ( ourStatus )
			m_netplayCurr = 0 ;

		if ( m_netplayCurr )
		{
			m_netplayCurr-- ;
		}
		else
		{
			m_netplayCurr = m_netplaySkip ;
			if ( pollNetworkControllers() )
				return 1 ;
		}
	}

	if ( m_bAutoLoadSaveState )
	{
		if( !m_bAutoLoaded )
		{
			loadMostRecentSaveState() ;
			m_bAutoLoaded = 61 ;
		}
/*
		if ( m_bAutoLoaded < 60 )
		{
			m_bAutoLoaded++ ;
		}
		else
		{
			if ( m_bAutoLoaded == 60 )
				loadMostRecentSaveState() ;
			m_bAutoLoaded = 61 ;
		}
		*/
	}

	return 0 ;
}

void CXBoxSample::loadMostRecentSaveState( )
{
	int largest = 0 ;
	DWORD rtime = 0 ;
	HANDLE currFile ;
	FILETIME wrtime ;

	if ( g_statefile && strlen( g_statefile ) )
	{
		for ( int i = 0 ; i < 10 ; i++ )
		{
			g_statefile[ strlen(g_statefile)-1 ] = '0' + i ;

			currFile = 	CreateFile( g_statefile, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL, NULL ) ;

			if ( currFile != INVALID_HANDLE_VALUE )
			{
				GetFileTime( currFile, NULL, NULL, &wrtime ) ;
				CloseHandle( currFile ) ;

				if ( rtime < wrtime.dwLowDateTime )
				{
					rtime = wrtime.dwLowDateTime ;
					largest = i ;
				}
			}
		}
	}
	
	m_stateNumber = largest ;

	xboxLoadState() ;
}


void CXBoxSample::updateCheats2( )
{
	unsigned char type ;
	int doNextCode ;
	int offset ;

	doNextCode = 1 ;

	for ( unsigned int i = 0 ; i < m_numCheats ; i++ )
	{
		if ( ! m_cheatCodes[i].enabled )
			continue ;

		//sprintfx( "cheat %u adr %X\r\n", i, m_cheatCodes[i].adr ) ;

		type = m_cheatCodes[i].type ;
		offset = 0 ;

		for ( int l = 0 ; l < NUM_MEMORY_LOCATIONS ; l++ )
		{
			if ( ( m_cheatCodes[i].adr >= offset ) && ( m_cheatCodes[i].adr < offset+m_memory_sizes[l] ) )
			{
				//sprintfx( "loc %u offs %X\r\n", l, offset ) ;
				m_consoleMemory = m_memory_locations[l] ;
				l = NUM_MEMORY_LOCATIONS+3 ;
			}
			else
			{
				offset += m_memory_sizes[l] ;
			}
		}

		if ( m_consoleMemory == NULL )
			continue ;

		switch ( type )
		{
			case 0x80 :
			{
				if ( ! doNextCode )
				{
					doNextCode = 1 ;
					continue ;
				}

				*((unsigned short*)(&m_consoleMemory[ m_cheatCodes[i].adr - offset ])) = ( m_cheatCodes[i].val & 0xFFFF ) ;

				doNextCode = 1 ;

				break ;
			}
			case 0x30 :
			{
				if ( ! doNextCode )
				{
					doNextCode = 1 ;
					continue ;
				}

				m_consoleMemory[ m_cheatCodes[i].adr- offset  ] = ( m_cheatCodes[i].val & 0xFF ) ;

				doNextCode = 1 ;

				break ;
			}
			case 0x10 :
			{
				if ( ! doNextCode )
				{
					doNextCode = 1 ;
					continue ;
				}

				*((unsigned short*)(&m_consoleMemory[ m_cheatCodes[i].adr - offset ])) += ( m_cheatCodes[i].val & 0xFFFF ) ;

				doNextCode = 1 ;

				break ;
			}
			case 0x11 :
			{
				if ( ! doNextCode )
				{
					doNextCode = 1 ;
					continue ;
				}

				*((unsigned short*)(&m_consoleMemory[ m_cheatCodes[i].adr - offset ])) -= ( m_cheatCodes[i].val & 0xFFFF ) ;

				doNextCode = 1 ;

				break ;
			}
			case 0x20 :
			{
				if ( ! doNextCode )
				{
					doNextCode = 1 ;
					continue ;
				}

				m_consoleMemory[ m_cheatCodes[i].adr - offset ] += ( m_cheatCodes[i].val & 0xFF ) ;

				doNextCode = 1 ;

				break ;
			}
			case 0x21 :
			{
				if ( ! doNextCode )
				{
					doNextCode = 1 ;
					continue ;
				}

				m_consoleMemory[ m_cheatCodes[i].adr - offset ] -= ( m_cheatCodes[i].val & 0xFF ) ;

				doNextCode = 1 ;

				break ;
			}
			case 0xD0 :
			{
				doNextCode = ( *((unsigned short*)(&m_consoleMemory[ m_cheatCodes[i].adr - offset ])) == ( m_cheatCodes[i].val & 0xFFFF ) ) ;
				break ;
			}
			case 0xD1 :
			{
				doNextCode = ( *((unsigned short*)(&m_consoleMemory[ m_cheatCodes[i].adr - offset ])) != ( m_cheatCodes[i].val & 0xFFFF ) ) ;
				break ;
			}
			case 0xD2 :
			{
				doNextCode = ( *((unsigned short*)(&m_consoleMemory[ m_cheatCodes[i].adr - offset ])) < ( m_cheatCodes[i].val & 0xFFFF ) ) ;
				break ;
			}
			case 0xD3 :
			{
				doNextCode = ( *((unsigned short*)(&m_consoleMemory[ m_cheatCodes[i].adr - offset ])) > ( m_cheatCodes[i].val & 0xFFFF ) ) ;
				break ;
			}
			case 0xE0 :
			{
				doNextCode = ( m_consoleMemory[ m_cheatCodes[i].adr - offset ] == ( m_cheatCodes[i].val & 0xFF ) ) ;
				break ;
			}
			case 0xE1 :
			{
				doNextCode = ( m_consoleMemory[ m_cheatCodes[i].adr - offset ] != ( m_cheatCodes[i].val & 0xFF ) ) ;
				break ;
			}
			case 0xE2 :
			{
				doNextCode = ( m_consoleMemory[ m_cheatCodes[i].adr - offset ] < ( m_cheatCodes[i].val & 0xFF ) ) ;
				break ;
			}
			case 0xE3 :
			{
				doNextCode = ( m_consoleMemory[ m_cheatCodes[i].adr - offset ] > ( m_cheatCodes[i].val & 0xFF ) ) ;
				break ;
			}
		}
	}
}

void CXBoxSample::ClearScreen() 
{
	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
						 0x00000000, 1.0f, 0L );
	//RenderGradientBackground( 0xFF000000, 0xFF000000 );
	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
}

void CXBoxSample::saveFavorites()
{
	char favfilename[MAX_PATH] ;
	FILE *favfile ;


	sprintf( favfilename, "%s\\favorites.txt", g_savePath ) ;

	if ( m_numFavorites == 0 )
	{
		DeleteFile( favfilename ) ;
		return ;
	}

	favfile = fopen( favfilename, "wb" ) ;

	if ( favfile )
	{
		for ( int i = 0 ; i < m_numFavorites ; i++ )
		{
			fprintf( favfile, "%s\r\n", m_filesFavorites[i].filename ) ;
		}

		fclose(favfile) ;
	}


}

void CXBoxSample::copyOldSaves()
{
	unsigned int selectedGame ;
	char szNewDir[MAX_PATH] ;
	char szOldDir[MAX_PATH] ;
	char *p, *s ;




	strcpy( szNewDir, m_szUserSavePath ) ;

	s = szNewDir+3 ;
	

	while ( p = strchr( s, '\\' ) )
	{
		*p = 0 ;
		CreateDirectory( szNewDir, NULL ) ;

		*p = '\\' ;

		p++ ;
		s = p ;
	}

	CreateDirectory( m_szUserSavePath, NULL ) ;

	sprintf( szOldDir, "%s\\*", g_savePath ) ;

	FindAvailRoms( szOldDir ) ;
	curr = 0 ;
	topIdx = 0 ;


	for ( int i = 0 ; i < numfiles ; i++ ) 
	{
		if ( ! files[i].isDir )
		{
			if ( stricmp( (char*)files[i].filename, "SaveMeta.xbx" ) )
			{
				sprintf( szNewDir, "%s\\%s", m_szUserSavePath, files[i].filename ) ;
				sprintf( szOldDir, "%s\\%s", g_savePath, files[i].filename ) ;

				MoveFileEx( szOldDir, szNewDir, MOVEFILE_COPY_ALLOWED ) ; 
			}
		}
	}

	strcpy( g_savePath, m_szUserSavePath ) ;


}

int recreate( D3DPRESENT_PARAMETERS *pparams )
{
	char tmpfilename[500] ;

	SAFE_RELEASE( g_app->Sprite ) ;
	SAFE_RELEASE( g_app->MenuSprite ) ;
	SAFE_RELEASE( g_app->m_plaything.m_gSprite) ;

				g_app->m_pd3dDevice->Release();

				//g_app->fillPresentationParams() ;

				if( FAILED( g_app->m_pD3D->CreateDevice( 0, D3DDEVTYPE_HAL, NULL, 
													   D3DCREATE_HARDWARE_VERTEXPROCESSING, 
													   pparams, &g_app->m_pd3dDevice ) ) )
				{
					return 0 ;
				}
				else
				{
					g_pd3dDevice = g_app->m_pd3dDevice ;

					g_app->m_pnlBackgroundMain.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlBackgroundSelect.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlBackgroundOther.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlSplashEmu.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlSplashGame.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlPopup.Recreate( g_app->m_pd3dDevice );
					g_app->m_pnlGameScreen.Recreate( g_app->m_pd3dDevice );
					m_pnlKeyboard.Recreate( g_app->m_pd3dDevice );

					sprintf( tmpfilename, "%s\\%s\\%s", g_app->m_szSkinDir, g_app->m_szSkin, g_app->m_skin.font ) ;
					g_app->m_Font.Initialize( g_app->m_pd3dDevice, tmpfilename, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;
					g_app->m_plaything.Initialize( g_app->m_pd3dDevice, &g_app->m_Font, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;
					m_bRecreated = 1 ;
					return 1 ;

				}
}

void CXBoxSample::getKeyboardString( char *buf, int bufsize ) 
{
	char *holder ;
	int origAlpha ;
	int accept = 1 ;

	if ( bufsize <= 0 )
		return ;

	memset( keyboard_keystate, 0, 256 ) ;

	holder = (char*)malloc(bufsize) ;
	memset( holder, 0, bufsize ) ;

	strcpy( holder, buf ) ;

	origAlpha = ( m_pnlKeyboard.m_colDiffuse >> 24 )&0xFF ;

	m_pnlKeyboard.SetAlpha( 0xFF );

	pmenuParams = &(m_skin.otherMenu) ;

	while ( Keyboard_GetVKInput() )
	{
		//clear keyboard
	}


	while ( 1 )
	{

		m_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 0.0f, 0L);

		pmenuParams->panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);

		m_plaything.Render( 0, 0, 0 ) ;


		m_bKeyboardMode = 1 ;
		renderScreenKeyboard() ;
		m_bKeyboardMode = 0 ;

		m_mp3player.process() ;

		swprintf( m_menuText[0], L"%S", holder ) ;

		m_Font.DrawText( (640-m_Font.GetWidth(m_menuText[0]) ) / 2, 350, pmenuParams->normalColor, m_menuText[0], pmenuParams->selectBarColor, 0, 0, 0, 0, 0) ;

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			m_currKeyboardKey &= 0xFF ;
			accept = 0 ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			if ( (m_currKeyboardKey&0xFF) == 0 )
			{
				XBInput_GetInput();
				m_currKeyboardKey &= 0xFF ;
				accept = 0 ;
				break ;
			}
			if ( ( (m_currKeyboardKey&0xFF) == 0x3C ) || ( (m_currKeyboardKey&0xFF) == 0x3D ) )
			{
				break ;
			}

			switch( m_currKeyboardKey&0xFF )
			{
				case 0x30 : 
				{
					if ( ! ( m_currKeyboardKey & KEYCAPS ) )
					{
						m_currKeyboardKey |= KEYCAPS ; 
					}
					else
					{
						m_currKeyboardKey &= ~KEYCAPS ; 
					}
					break ;
				}
				case 0x40 :
				case 0x41 : 
				{
					if ( ! ( m_currKeyboardKey & KEYLSHIFT ) )
					{
						m_currKeyboardKey |= KEYLSHIFT ; 
					}
					else
					{
						m_currKeyboardKey &= ~KEYLSHIFT ; 
					}
					break ;
				}
				case 0x4C :
				case 0x4D : 
				{
					if ( ! ( m_currKeyboardKey & KEYRSHIFT ) )
					{
						m_currKeyboardKey |= KEYRSHIFT ; 
					}
					else
					{
						m_currKeyboardKey &= ~KEYRSHIFT ; 
					}
					break ;
				}
				case 0x50 :
				case 0x51 : 
				{
					if ( ! ( m_currKeyboardKey & KEYLCTRL ) )
					{
						m_currKeyboardKey |= KEYLCTRL ; 
					}
					else
					{
						m_currKeyboardKey &= ~KEYLCTRL ; 
					}
					break ;
				}
				case 0x5A :
				case 0x5B : 
				{
					if ( ! ( m_currKeyboardKey & KEYRCTRL ) )
					{
						m_currKeyboardKey |= KEYRCTRL ; 
					}
					else
					{
						m_currKeyboardKey &= ~KEYRCTRL ; 
					}
					break ;
				}
				case 0x52 :
				case 0x53 : 
				{
					if ( ! ( m_currKeyboardKey & KEYLALT ) )
					{
						m_currKeyboardKey |= KEYLALT ; 
					}
					else
					{
						m_currKeyboardKey &= ~KEYLALT ; 
					}
					break ;
				}
				case 0x58 :
				case 0x59 : 
				{
					if ( ! ( m_currKeyboardKey & KEYRALT ) )
					{
						m_currKeyboardKey |= KEYRALT ; 
					}
					else
					{
						m_currKeyboardKey &= ~KEYRALT ; 
					}
					break ;
				}
				case 0x1D :
				case 0x1E :
				case 0x1F :
				{
					if ( strlen(holder) )
					{
						holder[strlen(holder)-1] = 0 ;
					}
					break ;
				}
				default : 
				{
					if ( strlen( holder ) < bufsize-1 )
					{
						if ( ( m_currKeyboardKey & KEYLSHIFT ) || ( m_currKeyboardKey & KEYRSHIFT ) || ( m_currKeyboardKey & KEYCAPS ) )
						{
							holder[strlen(holder)] = KEYBOARD_ASCIISHIFTMAP[m_currKeyboardKey&0xFF];
						}
						else
						{
							holder[strlen(holder)] = KEYBOARD_ASCIIMAP[m_currKeyboardKey&0xFF];
						}
					}
					break ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_START )
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_BACK )
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			if ( strlen(holder) )
			{
				holder[strlen(holder)-1] = 0 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;

			if ( ( m_currKeyboardKey%16 ) == 15 )
				m_currKeyboardKey -= 15 ;
			else
				m_currKeyboardKey++ ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( ( m_currKeyboardKey%16 ) == 0 )
				m_currKeyboardKey += 15 ;
			else
				m_currKeyboardKey-- ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( (m_currKeyboardKey&0xFF) < 16 )
				m_currKeyboardKey += (5*16) ;
			else
				m_currKeyboardKey -= 16 ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( (m_currKeyboardKey&0xFF) > (5*16)-1 )
				m_currKeyboardKey -= 5*16 ;
			else
				m_currKeyboardKey += 16 ;

		}



		if ( Keyboard_GetVKInput() )
		//while( ERROR_SUCCESS == XInputDebugGetKeystroke( &keystroke ) )
		{
			if ( g_keyboardStroke.Flags & XINPUT_DEBUG_KEYSTROKE_FLAG_KEYUP )
			{
				if ( keyboard_keystate[g_keyboardStroke.VirtualKey] == 1 )
				{
					keyboard_keystate[g_keyboardStroke.VirtualKey] = 0 ;
				}
			}
			else
			{
				if ( g_keyboardStroke.Flags & XINPUT_DEBUG_KEYSTROKE_FLAG_REPEAT )
				{
					if ( keyboard_keystate[g_keyboardStroke.VirtualKey] == 1 )
					{
						keyboard_keystate[g_keyboardStroke.VirtualKey] = 1 ;
					}
				}
				else
				{
					if ( !keyboard_keystate[g_keyboardStroke.VirtualKey] )
					{
						keyboard_keystate[g_keyboardStroke.VirtualKey] = 1 ;

						if ( g_keyboardStroke.VirtualKey == VK_ESCAPE )
						{
							m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
							XBInput_GetInput();
							m_currKeyboardKey &= 0xFF ;
							accept = 0 ;
							break;
						}
						if ( g_keyboardStroke.VirtualKey == VK_RETURN )
						{
							break ;
						}

						switch ( g_keyboardStroke.VirtualKey )
						{
							case VK_BACK :
							{
								if ( strlen(holder) )
								{
									holder[strlen(holder)-1] = 0 ;
								}
								break ;
							}
							case VK_TAB :
							{
								break ;
							}
							default :
							{
								if ( strlen( holder ) < bufsize-1 )
								{
									holder[strlen(holder)] = g_keyboardStroke.Ascii ;
								}
								break ;
							}
						}

					}
				}
			}

		}





	}

	m_pnlKeyboard.SetAlpha( origAlpha );

	if ( accept )
		strcpy( buf, holder ) ;

	free(holder) ;
}


HRESULT CXBoxSample::InitializeWithScreen()
{
	FILE *debugfile ;
	char initext[100] ;
	char szDevice[2000] ;
	char *fpos, *epos ;
	int numread ;
	char tmpfilename[MAX_PATH] ;



	XBInput_GetInput();
	XBInput_GetInput();
	if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] )
	{
		m_doDebug = 1 ;
	}
	

	
	m_bRecreated = 0 ;
	m_xboxVidmode = 0 ;

	sprintfx( "before loadtext - showmemory \r\n" ) ;

	xbox_print_memory() ;

	XMountUtilityDrive( TRUE )  ;

	m_io.Unmount("C:") ;
	m_io.Unmount("E:") ;
	m_io.Unmount("F:") ;
	m_io.Unmount("G:") ;
	m_io.Unmount("X:") ;
	m_io.Unmount("Y:") ;
	m_io.Unmount("Z:") ;
	m_io.Unmount("R:") ;
	m_io.Mount("C:", "Harddisk0\\Partition2");
	m_io.Mount("E:", "Harddisk0\\Partition1");
	m_io.Mount("F:", "Harddisk0\\Partition6");
	m_io.Mount("G:", "Harddisk0\\Partition7");
	m_io.Mount("X:", "Harddisk0\\Partition3");
	m_io.Mount("Y:", "Harddisk0\\Partition3");
	m_io.Mount("Z:", "Harddisk0\\Partition3");
	//m_io.Mount("Y:", "Harddisk0\\Partition4");
	//m_io.Mount("Z:", "Harddisk0\\Partition5");
	m_io.Mount("R:","Cdrom0");

	XFormatUtilityDrive() ;

	CreateDirectory( "E:\\SAVES", NULL ) ;

	//debugfile = fopen( "E:\\SAVES\\xportdebug.txt", "wb" ) ;

	//fprintf( debugfile, "Starting initialization\r\n") ;
	//fflush( debugfile ) ;


	//m_io.Remount("D:", "Harddisk0\\Partition1\\games");

	//m_io.GetDeviceFromSymlink( "D:", szDevice ) ;


	//m_io.Remount("S:",szDevice+8);  //S drive will always be the original D mapping


	xbox_print_memory() ;

	memset( &m_skin, 0, sizeof(m_skin) ) ;


	char szNewDir[MAX_PATH] ;
	char *s, *p ;

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;


	strcpy( szNewDir, DEFAULT_SAVE_PATH ) ;

	s = szNewDir+3 ;
	

	while ( p = strchr( s, '\\' ) )
	{
		*p = 0 ;
		CreateDirectory( szNewDir, NULL ) ;

		*p = '\\' ;

		p++ ;
		s = p ;
	}

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;

	CreateDirectory( DEFAULT_SAVE_PATH, NULL ) ;

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;

	xbox_print_memory() ;

	sprintfx( "inscre\r\n") ;











	DWORD tdiff = GetTickCount() ;

	doLoadIni( 0 ) ;

	tdiff = GetTickCount() - tdiff ;

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	xbox_print_memory() ;
	sprintfx( "inscre\r\n") ;

	tdiff = GetTickCount() ;

	doLoadSkin( m_szSkin, 0 ) ;

	tdiff = GetTickCount() - tdiff ;




	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	sprintfx( "inscre\r\n") ;
	xbox_print_memory() ;

	pmenuParams = &(m_skin.loadingMenu) ;

	//m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_POINT);
	//m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_POINT);
	//m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);


	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
						 0x00000000, 0.0f, 0L );
	//RenderGradientBackground( 0xFF000000, 0xFF000000 );



	m_pnlSplashEmu.Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy ) ;

	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


	memcpy( &m_ptConfig, &(m_skin.loadingMenu.ptConfig), sizeof(m_ptConfig) ) ;
	SetupPlaything() ;

	QueryPerformanceFrequency((union _LARGE_INTEGER *) m_performanceFreq);

	DWORD starttime = GetTickCount() ;

	while ( starttime + m_skin.loadingMenu.animationDelay > GetTickCount() )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_pnlSplashEmu.Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		m_plaything.Render( 0, 0, 0 ) ;
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}

	/*
	m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;
	m_pd3dDevice->Reset( &m_d3dpp ) ;
	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
						0x00000000, 1.0f, 0L );
	//RenderGradientBackground( 0xFF000000, 0xFF000000 );

	m_pnlSplashEmu.Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
	m_plaything.Render( 0, 0, 0 ) ;
	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
*/
	memcpy( &m_ptConfig, &(m_skin.mainMenu.ptConfig), sizeof(m_ptConfig) ) ;
	SetupPlaything() ;

	//SDL_Init( 0 ) ;
	sprintfx( "inscre\r\n") ;
	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;

	// 4 controllers - each needing DWORD 4 bytes * 60fps * 60 secs per min * 10 min
	m_szEmuRecorder = (unsigned char*)malloc( EMU_RECORDING_SIZE ) ; 
	m_emuRecording = 0 ;
	m_emuPlaying = 0 ;


	InitLUTs() ;

	XGetCustomLaunchData() ;
	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	sprintfx( "inscre\r\n") ;

	xbox_print_memory() ;

	InitializeNetwork() ;

    //HRESULT hr = XBNet_Init( XNET_STARTUP_BYPASS_SECURITY );

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	m_smb.setPasswordCallback(&cb);

	if ( m_smbNameServer[0] )
		m_smb.setNBNSAddress( m_smbNameServer ) ;

	sprintfx( "inscre\r\n") ;
	g_smbUsername = NULL ;
	g_smbPassword = NULL ;
	m_smbUtil.parse( m_smbShare, 0 ) ;

	g_smbPassword = m_smbUtil.password() ;
	g_smbUsername = m_smbUtil.user() ;

	if ( ! m_relax.Initialize( m_rlxShare ) )
	{
		sprintfx( "no init main relax\r\n") ;
	}

	if ( ! m_mp3player.m_relax.Initialize( m_rlxShare ) )
	{
		sprintfx( "no init mp3 relax\r\n") ;
	}

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;


	m_currKeyboardKey = 0 ;
	m_bKeyboardMode = 0 ;

	LPDIRECT3DTEXTURE8	kTexture;


	if (D3DXCreateTextureFromFileInMemoryEx(m_pd3dDevice, KEYBOARD_PIC, 8065,
		 516, 196, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &kTexture)==D3D_OK)
	{
		m_pnlKeyboard.m_pTexture = NULL ;
		if ( FAILED(m_pnlKeyboard.Create(m_pd3dDevice, kTexture, FALSE, 516, 196)) )
		{
			//popupMsg( "no create panel", &m_pnlBackgroundOther ) ;
		}
		else
		{
			m_pnlKeyboard.SetAlpha( 0x80 ) ;
		}
	}
	else
	{
		//popupMsg( "no load texture", &m_pnlBackgroundOther ) ;
	}


	m_mp3player.m_smb = &m_smb ;
	if ( m_smbShare[0] )
	{
		strcpy( m_mp3player.m_smbShare, m_smbShare ) ;
	}
	else
	{
		m_mp3player.m_smbShare[0] = 0 ;
	}


	//m_mp3player.loadFile( "d:\\gamebase\\music\\20CC\\13_Seconds_of_Massacre.sid",0,0,0,0) ;
	//while ( 1 )
	//m_mp3player.processReal() ;

    g_hSoundThread = CreateThread( 
        NULL,                        // (this parameter is ignored)
        0,                           // use default stack size  
        Mp3player_ThreadFunc,                  // thread function 
        NULL,                // argument to thread function 
        0,                           // use default creation flags 
        &g_dwSoundThreadId);                // returns the thread identifier 


	xbox_print_memory() ;
	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;

	sprintfx( "inscre\r\n") ;
	for ( int i = 0 ; i < 200 ; i++ )
	{
		m_menuText[i] = (WCHAR*)( malloc( MAX_PATH * sizeof(WCHAR) ) ) ;
	}

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	xbox_print_memory() ;

	sprintfx( "inscre\r\n") ;
	strcpy( m_szCurrentDir, m_defaultRomDir ) ;

	curr = 0 ;
	topIdx = 0 ;
	numfiles = 0 ;

	m_filesFavorites = NULL ;
	m_stateNumber = 0 ;
	m_playingMusic = 1 ;




	//m_namesPerPage =  m_skin.gameSelectMenu.linesPerPage ; // (25*14 ) / ( m_Font.GetFontHeight()-2) ;


	m_msgDelay = 0 ;
	wcscpy( m_strMessage, L" " ) ;
	
	g_pBlitBuff = NULL ;
	g_pDeltaBuff = NULL ;
	g_pAlignBuff = NULL ;
	WhiteTexture = NULL ;
	Texture = NULL ;
	Sprite = NULL ;


	MenuSprite = NULL ;


	m_cheatCodes = NULL ;
	m_numCheats = 0 ;

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	xbox_print_memory() ;
	init_white_texture();
	xbox_print_memory() ;

	g_saveprefix[0] = 0 ;


	sprintfx( "inscre\r\n") ;
	xbox_print_memory() ;
	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	//copyOldSaves() ;
	strcpy( g_savePath, m_szUserSavePath ) ;

	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	xbox_print_memory() ;
	sprintfx( "inscre\r\n") ;


	FindAvailRoms(PLATFORM_FILE_DIR) ;
	curr = 0 ;
	topIdx = 0 ;

	sprintfx( "inscre\r\n") ;
	xbox_print_memory() ;
	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	loadFavorites() ;
	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	xbox_print_memory() ;
	sprintfx( "inscre\r\n") ;

	m_memBuf1 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memBuf2 = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_memMatches = (byte*)malloc( CONSOLE_MEMORY_SIZE ) ;
	m_consoleMemory = (byte*)PLATFORM_MEMORY_POINTER ;

	xbox_print_memory() ;

	m_bNetplay = 0 ;

/*
	if ( m_sockNetplay.Init( ) == 0 )
	{
	}

	*/



	m_state = MAIN_MENU ;


	
	xbox_print_memory() ;
	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;
	
	InitializeEmuSpecific() ;
	//fprintf( debugfile, "Init\r\n") ;
	//fflush( debugfile ) ;

	//fclose(debugfile) ;
	xbox_print_memory() ;


	doMainMenu() ;

    return S_OK;
}

int CXBoxSample::selectNetplayServer()
{
	int menuChoice = 0 ;
	int textheight ;
	int textwidth ;
	int numservers = 0 ;


	pmenuParams = &(m_skin.popupMenu) ;

	swprintf( m_menuText[0], L"Netplay Servers" ) ;

	for ( int i = 0 ; i < 32 ; i++ )
	{
		if ( strlen( m_netplayServers[i].ip ) > 0 )
		{
			numservers++ ;
			swprintf( m_menuText[numservers], L"%S", m_netplayServers[i].ip ) ;
		}

	}

	if ( numservers == 0 )
	{
		popupMsg( "There are no servers in the list.", &m_pnlBackgroundOther ) ;
		return -1 ;
	}

	while ( 1 )
	{


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, numservers+1, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			return -1; 
		}
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			return menuChoice ;
		}

	}

	return menuChoice ;
}


void CXBoxSample::addNewNetplayServer( )
{
	char szNewDir[MAX_PATH] ;
	DWORD color ;
	FILE *outfile ;
	int numpad ;
	int pos ;
	int panelx, panely ;
	int whichServer = -1 ;
	CPanel panel ;
	LPDIRECT3DTEXTURE8	panelTexture ;
	int charspacing ;
	char ip[30] ;
	WCHAR msg[50] ;
	WCHAR *lines[100] = { L"L/R Trigger - Change Position", 
							L"A - Select Digit",
							L"Start - Save Server",
							L"B - Cancel" } ;
	int posx[4] ;


	for ( int i = 0 ; i < 32 ; i++ )
	{
		if ( strlen( m_netplayServers[i].ip ) == 0 )
		{
			whichServer = i ; 
			break ; 
		}
	}

	if ( whichServer == -1 )
	{
		popupMsg( "Cannot have more than 32 netplay servers.", &m_pnlBackgroundOther ) ;
		return ;
	}

	for ( int i = 0 ; i < 4 ; i++ )
	{
		posx[i] = ( (640)- ( m_Font.GetWidth( lines[i] )/VIDEOMODES[m_xboxVidmode].multx ) ) / 2 ;
	}


	numpad = 0 ;
	pos = 0 ;

	outfile = fopen( "Z:\\NUMPAD.PNG", "wb" ) ;
	if ( outfile == NULL )
		return ;

	fwrite( NUMPAD_PNG, sizeof(char), sizeof(NUMPAD_PNG), outfile ) ;
	fclose( outfile ) ;



	pmenuParams = &(m_skin.otherMenu) ;
	
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, "Z:\\NUMPAD.PNG",
		 NUMPAD_WIDTH, NUMPAD_HEIGHT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &panelTexture )==D3D_OK)
	{
		if ( FAILED(panel.Create(m_pd3dDevice, panelTexture , FALSE, NUMPAD_WIDTH, NUMPAD_HEIGHT)) )
		{
			panelTexture->Release() ;
			return  ;
		}
	}
	else
	{
		return  ;
	}
	
	charspacing = 0 ;

	for ( int i = 0 ; i < 10 ; i++ )
	{
		swprintf( msg, L"%c", '0' + i ) ;
		if ( m_Font.GetWidth( msg )/VIDEOMODES[m_xboxVidmode].multx > charspacing )
			charspacing = m_Font.GetWidth( msg )/VIDEOMODES[m_xboxVidmode].multx ;
	}
	for ( int i = 0 ; i < 6 ; i++ )
	{
		swprintf( msg, L"%c", 'A' + i ) ;
		if ( m_Font.GetWidth( msg )/VIDEOMODES[m_xboxVidmode].multx > charspacing )
			charspacing = m_Font.GetWidth( msg )/VIDEOMODES[m_xboxVidmode].multx ;
	}



	strcpy( ip, "000000000000" ) ;

	charspacing += 5;
	
	LPDIRECT3DTEXTURE8	colorSquareTexture;

	D3DXCreateTexture(m_pd3dDevice, 1, 1, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &colorSquareTexture);
	
	D3DSURFACE_DESC desc;
    colorSquareTexture->GetLevelDesc(0, &desc);


	RECT rectSource;
	D3DLOCKED_RECT d3dlr;


	if ( MenuSprite==NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);


	color = 0x800066CC ;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 0;
	rectSource.right  = 0 ;

	colorSquareTexture->LockRect(0, &d3dlr, &rectSource, 0);

	memcpy( d3dlr.pBits, &color, sizeof(color) ) ;

	colorSquareTexture->UnlockRect(0);

	panelx = ( 640 -NUMPAD_WIDTH)/2 ;
	panely = 82 ; 

	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		D3DXCOLOR d3color( 1.0, 1.0, 1.0, 0.5 ) ;
		pmenuParams->panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		//Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);

		panel.Render( panelx*VIDEOMODES[m_xboxVidmode].multx, panely*VIDEOMODES[m_xboxVidmode].multy, NUMPAD_WIDTH*VIDEOMODES[m_xboxVidmode].multx, NUMPAD_HEIGHT*VIDEOMODES[m_xboxVidmode].multy ) ;


		m_mp3player.process() ;


		D3DXVECTOR2 vecScale( 1, 1 ) ;
		D3DXVECTOR2 vecTranslate( (panelx + 4 + ( 53 * ( numpad % 4 )))*VIDEOMODES[m_xboxVidmode].multx, (panely + 4 + ( 53 * ( numpad / 4 ) ))*VIDEOMODES[m_xboxVidmode].multy ) ;
		D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 49*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 49*VIDEOMODES[m_xboxVidmode].multx ;

		MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);

		for ( int iter = 0 ; iter < 4 ; iter++ )
		{
			int i ; 
			for ( i = 0 ; i < 3 ; i++ )
			{
				swprintf( msg, L"%c", ip[iter*3+i] ) ;
				m_Font.DrawText( (( ( 640) -(charspacing*15))/2) + (iter*4 +i)*charspacing, (panely-pmenuParams->lineHeight)-10, 
					pos==(iter*3+i) ? pmenuParams->selectedColor : pmenuParams->normalColor, msg, pmenuParams->selectBarColor, pos==(iter*3+i), 0, 0, 0, 0) ;
			}
			if ( iter < 3 )
			{
				swprintf( msg, L"." ) ;
				m_Font.DrawText( (((640)-(charspacing*15))/2) + (iter*4 +i)*charspacing, (panely-pmenuParams->lineHeight)-10, 
					pmenuParams->normalColor, msg, pmenuParams->selectBarColor, 0, 0, 0, 0, 0) ;
			}
		}

		for ( int i = 0 ; i < 4 ; i++ )
		{
			m_Font.DrawText( posx[i], panely+NUMPAD_HEIGHT+10 + (pmenuParams->lineHeight*i), 
				pmenuParams->normalColor, lines[i], pmenuParams->selectBarColor, 0, 0, 0, 0, 0) ;
		}


		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			if ( numpad < 10 )
				ip[pos] = '0' + numpad ;

			pos = (pos+1)%12 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( ( numpad %4 ) == 3 )
				numpad -= 3 ;
			else
				numpad++ ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( ( numpad %4 ) == 0 )
				numpad += 3 ;
			else
				numpad-- ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( numpad < 4 )
				numpad += 12 ;
			else
				numpad -= 4 ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( numpad > 11 )
				numpad -= 12 ;
			else
				numpad += 4 ;

		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			pos = (pos+1)%12 ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			pos = (pos+(12-1))%12 ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_START )
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			int ip1, ip2, ip3, ip4 ;
			char sip1[4] ;
			char sip2[4] ;
			char sip3[4] ;
			char sip4[4] ;

			sip1[0] = ip[0] ;
			sip1[1] = ip[1] ;
			sip1[2] = ip[2] ;
			sip1[3] = 0 ; 
			sip2[0] = ip[3] ;
			sip2[1] = ip[4] ;
			sip2[2] = ip[5] ;
			sip2[3] = 0 ; 
			sip3[0] = ip[6] ;
			sip3[1] = ip[7] ;
			sip3[2] = ip[8] ;
			sip3[3] = 0 ; 
			sip4[0] = ip[9] ;
			sip4[1] = ip[10] ;
			sip4[2] = ip[11] ;
			sip4[3] = 0 ; 

			ip1 = atoi( sip1 ) ;
			ip2 = atoi( sip2 ) ;
			ip3 = atoi( sip3 ) ;
			ip4 = atoi( sip4 ) ;

			sprintf( m_netplayServers[whichServer].ip, "%u.%u.%u.%u", ip1, ip2, ip3, ip4 ) ;

			break ;
		}
	}

	panelTexture->Release() ;
	colorSquareTexture->Release() ;

}

int CXBoxSample::setupNetplay()
{
	int menuChoice = 0 ;
	int textheight ;
	int textwidth ;
	int whichServer = 0 ;


	pmenuParams = &(m_skin.popupMenu) ;

	while ( 1 )
	{

		swprintf( m_menuText[0], L"I will be..." ) ;
		swprintf( m_menuText[1], L"Client" ) ;
		swprintf( m_menuText[2], L"Server" ) ;

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 3, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			return 1; 
		}
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			break ;
		}

	}

	m_bNetplay = 1 ;

	if ( menuChoice == 0 ) //Client
	{
		while ( 1 )
		{

			swprintf( m_menuText[0], L"Netplay Client" ) ;
			swprintf( m_menuText[1], L"Select Server From List" ) ;
			swprintf( m_menuText[2], L"Add Server To List" ) ;

			menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 3, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
				XBInput_GetInput();
				return 1; 
			}
			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
			{
				m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
				XBInput_GetInput();

				if ( menuChoice == 0 )
				{
					whichServer = selectNetplayServer() ;

					if ( whichServer >= 0 )
					{
						break ;
					}
				}
				else
				{
					addNewNetplayServer() ;
				}

			}

		}

		if ( m_sockNetplay.Connect( m_netplayServers[whichServer].ip, 8989, 0 ) == 0 )
		{
			popupMsg( "Could not establish connection - aborting.", &m_pnlBackgroundOther ) ;
			return 1 ;
		}

		receiveNetworkData() ;

		m_netplaySkip = m_networkStatus ;
		m_netplayCurr = 0 ;

	}
	else //Server
	{
		m_netplaySkip = 0 ;

		m_netplaySkip = getValuePopup( "Select Netplay Skip Value", m_netplaySkip, 0, 255, &m_pnlBackgroundOther ) ;
		m_netplayCurr = 0 ;

		m_bNetplay=2 ; //m_bNetplay==2 means server

		m_sockListener.Open( CXBSocket::Type_TCP );

		CXBSockAddr directAddr( INADDR_ANY, 8989 );

		INT iResult = m_sockListener.Bind( directAddr.GetPtr() );

		if ( iResult == SOCKET_ERROR )
		{
			return 1;
		}

		iResult = m_sockListener.Listen( 1 ) ;

		if ( iResult == SOCKET_ERROR )
		{
			return 1;
		}

		DWORD dwNonBlocking = 1 ;
		SOCKET connection ;
		iResult = m_sockListener.IoCtlSocket( FIONBIO, &dwNonBlocking );

		while ( ( connection = m_sockListener.Accept( NULL ) ) == INVALID_SOCKET )
		{
			popupMsg( "Listening for incoming connections...", &m_pnlBackgroundOther, 1 ) ;

	        XBInput_GetInput();
			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				return 1 ;
			}
		}

		m_sockNetplay.m_debugClientSock.m_Socket = connection ;

		m_sockNetplay.Send( &m_emuControllers, sizeof(DWORD)*4 ) ;
		m_sockNetplay.Send( &m_netplaySkip, sizeof(DWORD) ) ;

	}

	return 0 ;
}



char* GetIniString( char *inibuf, char *dest, int destlen, char *section, char *setting, char *default_val ) 
{
	char bsection[100] ;
	char bsetting[100] ;
	char *pos, *npos, *rpos ;
	char line[300] ;
	int found ;
	int val ;
	int advance ;
	char *retval ;
	int sectionnum = 0 ;

	int sectionStart = 0 ;

	if ( m_iniSize == 0 )
	{
		strcpy( dest, default_val ) ;
		return NULL ;
	}

	strcpy( bsection, section ) ;
	strupr( bsection ) ;
	strcpy( bsetting, setting ) ;
	strupr( bsetting ) ;

	sectionnum = m_iniHolder[0].sectionnum ;

	while ( strcmp( bsection, m_iniHolder[sectionStart].section ) )
	{
		sectionnum = m_iniHolder[sectionStart].sectionnum ;

		while ( ( sectionStart < m_iniSize ) && ( sectionnum == m_iniHolder[sectionStart].sectionnum ) )
		{
			sectionStart++ ;
		}

		
		if ( sectionStart >= m_iniSize )
		{
			strcpy( dest, default_val ) ;
			return NULL ;
		}
	}

	sectionnum = m_iniHolder[sectionStart].sectionnum ;

	if ( sectionStart >= m_iniSize ) 
	{
		strcpy( dest, default_val ) ;
		return NULL ;
	}

	while ( strcmp( bsetting, m_iniHolder[sectionStart].setting ) )
	{
		sectionStart++ ;

		if ( ( sectionStart >= m_iniSize ) || ( m_iniHolder[sectionStart].sectionnum != sectionnum ) )
		{
			strcpy( dest, default_val ) ;
			return NULL ;
		}
	}

	npos = dest ;
	rpos = m_iniHolder[sectionStart].value ;

	while ( *rpos && ( npos-dest < destlen-2 ) )
	{
		*npos = *rpos ;
		npos++ ;
		rpos++ ;
	}

	*npos = 0 ;

	return  NULL ;
}


char* GetIniStringbackup( char *inibuf, char *dest, int destlen, char *section, char *setting, char *default_val ) 
{
	char bsection[100] ;
	char bsetting[100] ;
	char *pos, *npos, *rpos ;
	char line[300] ;
	int found ;
	int val ;
	int advance ;
	char *retval ;

	if ( inibuf == NULL )
	{
		strcpy( dest, default_val ) ;
		return NULL ;
	}

	found = 0 ;

	sprintf( bsection, "[%s]", section ) ;
	sprintf( bsetting, "%s=", setting ) ;

	strupr(bsection) ;
	strupr(bsetting) ;


	pos = strstr( inibuf, bsection ) ;

	if ( pos == NULL )
	{
		strcpy( dest, default_val ) ;
		return NULL ;
	}

	pos += strlen( bsection ) ;

	do
	{
		advance = getLine( pos, line,300 ) ;

		//sprintfx( "line=%s\r\n", line ) ;

		if ( line[0] == '[' )
			break ;

		if ( line[0] == '#' )
		{
			pos += advance ;
			continue ;
		}

		if ( rpos = strstr( line, bsetting ) ) 
		{
			rpos += strlen(bsetting) ;
			found = 1 ;
		}
		else
		{
			pos += advance ;
		}

	} while ( ( line[0] ) && ( !found ) );

	if ( ! found )
	{
		strcpy( dest, default_val ) ;
		return NULL ;
	}

	retval = pos + (advance - strlen(line) ) + strlen(bsetting) ;

	npos = dest ;


	while ( *rpos && ( npos-dest < destlen-2 ) )
	{
		*npos = *rpos ;
		npos++ ;
		rpos++ ;
	}

	*npos = 0 ;

	return  retval ;
}

unsigned int hextoint( char *hex ) 
{
	int base ;
	unsigned int val ;

	base = 1 ;
	strupr(hex) ;
	val = 0 ;

	for ( int i = strlen(hex)-1 ; i >= 0 ; i-- )
	{
		switch( hex[i] )
		{
			case 'A' :
			case 'B' :
			case 'C' :
			case 'D' :
			case 'E' :
			case 'F' : val += ( base * ( 10 + ( hex[i] - 'A' ) ) ); break ;
			case '0' :
			case '1' :
			case '2' :
			case '3' :
			case '4' :
			case '5' :
			case '6' :
			case '7' :
			case '8' :
			case '9' : val += ( base * ( hex[i] - '0' ) ) ; break ;
			default : break ;
		}

		base <<= 4 ;
	}

	return val ;
}

int GetIniInt( char *inibuf, char *section, char *setting, int default_val ) 
{
	char bsection[100] ;
	char bsetting[100] ;
	char *pos, *npos, *rpos ;
	char line[300] ;
	int found ;
	int val ;
	unsigned int advance ;


	GetIniString( inibuf, bsetting, 100, section, setting, "X" ) ;

	if ( bsetting[0] == 'X' )
		return default_val ;

	if ( ( strlen(bsetting) > 2 ) && ( bsetting[0] == '0' ) && ( ( bsetting[1] == 'X' ) || ( bsetting[1] == 'x' ) )  )
	{
		val = hextoint( bsetting+2 ) ;
	}
	else
	{
		val = atoi( bsetting ) ;
	}

	return val ;
	
}

int GetIniIntBackup( char *inibuf, char *section, char *setting, int default_val ) 
{
	char bsection[100] ;
	char bsetting[100] ;
	char *pos, *npos, *rpos ;
	char line[300] ;
	int found ;
	int val ;
	unsigned int advance ;

	if ( inibuf == NULL )
	{
		return default_val ;
	}

	found = 0 ;

	sprintf( bsection, "[%s]", section ) ;
	sprintf( bsetting, "%s=", setting ) ;

	strupr(bsection) ;
	strupr(bsetting) ;


	pos = strstr( inibuf, bsection ) ;


	if ( pos == NULL )
	{
		return default_val ;
	}

	pos += strlen( bsection ) ;

	do
	{
		advance = getLine( pos, line,300 ) ;


		if ( line[0] == '[' )
			break ;

		if ( line[0] == '#' )
		{
			pos += advance ;
			continue ;
		}

		if ( npos = strstr( line, bsetting ) ) 
		{
			npos += strlen(bsetting) ;
			found = 1 ;
		}
		else
		{
			pos += advance ;
		}

	} while ( ( line[0] ) && ( !found ) );

	if ( ! found )
	{
		return default_val ;
	}

	if ( ( strlen(npos) > 2 ) && ( npos[0] == '0' ) && ( npos[1] == 'X' ) )
	{
		val = hextoint( npos+2 ) ;
	}
	else
	{
		val = atoi( npos ) ;
	}

	return val ;
	
}


void CXBoxSample::loadSkinMenuSettings( char *szbuf, char *basesection, MENU_PARAMS *menu ) 
{
	char section[100] ;
	int tmpval ;


	sprintf( section, "%s_bkg", basesection ) ;

	GetIniString( szbuf, menu->bkg, 100, section, "bkg", "defaultbkg.png" ) ;
	menu->transparency = GetIniInt( szbuf, section, "transparency", 255 ) ;
	menu->borderWidth = GetIniInt( szbuf, section, "border_width", 25 ) ;
	menu->screenshotX = GetIniInt( szbuf, section, "SCREENSHOT_X", 410 ) ;
	menu->screenshotY = GetIniInt( szbuf, section, "SCREENSHOT_Y", 40 ) ;
	menu->screenshotW = GetIniInt( szbuf, section, "SCREENSHOT_W", 200 ) ;
	menu->screenshotH = GetIniInt( szbuf, section, "SCREENSHOT_H", 200 ) ;
	menu->screenshotTransparency = GetIniInt( szbuf, section, "SCREENSHOT_TRANSPARENCY", 255 ) ;
	menu->animationDelay = GetIniInt( szbuf, section, "ANIMATION_DELAY", 0 ) ;

	sprintf( section, "%s_text", basesection ) ;

	menu->halign = GetIniInt( szbuf, section, "horiz_align", 2 ) ;
	menu->valign = GetIniInt( szbuf, section, "vert_align", 2 ) ;
	menu->offsetx = GetIniInt( szbuf, section, "offsetx", 0 ) ;
	menu->offsety = GetIniInt( szbuf, section, "offsety", 0 ) ;
	menu->maxTextWidth = GetIniInt( szbuf, section, "max_text_width", 640 ) ;
	menu->normalColor = GetIniInt( szbuf, section, "normal_color", 0xFFFFFFFF ) ;
	menu->notedColor = GetIniInt( szbuf, section, "noted_color", 0xFF00FF00 ) ;
	menu->selectedColor = GetIniInt( szbuf, section, "selected_color", 0xFFFF00FF ) ;
	menu->selectedAndNotedColor = GetIniInt( szbuf, section, "selected_and_noted_color", 0xFFFF00FF ) ;
	menu->selectBarColor = GetIniInt( szbuf, section, "select_bar_color", 0xFFFFFFFF ) ;
	menu->maxNumLines = GetIniInt( szbuf, section, "lines_per_page", 16 ) ;
	menu->size = GetIniInt( szbuf, section, "fontsize", 24 ) ;
	menu->lineHeight = GetIniInt( szbuf, section, "line_height", 24 ) ;


	if ( menu->lineHeight > 400 )
		menu->lineHeight = 400 ;

	if ( menu->lineHeight <= 0  )
		menu->lineHeight = 1 ;

	if ( menu->maxNumLines > 50 )
		menu->maxNumLines = 50 ;

	if ( menu->maxNumLines <= 0 )
		menu->maxNumLines = 1 ;

	if ( menu->maxTextWidth < 0 )
		menu->maxTextWidth = 0 ;

	if ( menu->maxTextWidth > 640 )
		menu->maxTextWidth = 640 ;

	if ( menu->offsetx < -640 )
		menu->offsetx = -640 ;

	if ( menu->offsetx > 640 )
		menu->offsetx = 640 ;

	if (menu->offsety < -480 )
		menu->offsety = -480 ;

	if ( menu->offsety > 480 )
		menu->offsety = 480 ;

	for ( int i = 0 ; i < 20 ; i++ )
	{
		sprintf( section, "%s_sprite%u", basesection, i+1 ) ;

		menu->ptConfig.sprites[i].sprite = GetIniInt( szbuf, section, "spritenum", -1 ) ;
		menu->ptConfig.sprites[i].offsetX = GetIniInt( szbuf, section, "offsetx", 0 ) ;
		menu->ptConfig.sprites[i].offsetY = GetIniInt( szbuf, section, "offsety", 0 ) ;
		menu->ptConfig.sprites[i].framespeed= GetIniInt( szbuf, section, "framespeed", 20 ) ;
		menu->ptConfig.sprites[i].transparency= GetIniInt( szbuf, section, "transparency", 255 ) ;
		menu->ptConfig.sprites[i].scale = ((float)GetIniInt( szbuf, section, "size", 0 )) / 10.0f ;
		menu->ptConfig.sprites[i].flipH= GetIniInt( szbuf, section, "flip_horiz", 0 ) ;
		menu->ptConfig.sprites[i].flipV= GetIniInt( szbuf, section, "flip_vert", 0 ) ;
		menu->ptConfig.sprites[i].loopOnce = GetIniInt( szbuf, section, "loop_once", 0 ) ;
		menu->ptConfig.sprites[i].motionX = ((float)GetIniInt( szbuf, section, "motion_x", 0 )) / 1000.0f ;
		menu->ptConfig.sprites[i].motionY = ((float)GetIniInt( szbuf, section, "motion_y", 0 )) / 1000.0f ;
		menu->ptConfig.sprites[i].rotate = GetIniInt( szbuf, section, "rotate", 0 ) ;
		menu->ptConfig.sprites[i].rect_t = GetIniInt( szbuf, section, "rect_t", 0 ) ;
		menu->ptConfig.sprites[i].rect_b = GetIniInt( szbuf, section, "rect_b", 480 ) ;
		menu->ptConfig.sprites[i].rect_l = GetIniInt( szbuf, section, "rect_l", 0 ) ;
		menu->ptConfig.sprites[i].rect_r = GetIniInt( szbuf, section, "rect_r", 640 ) ;
	}

	for ( int i = 0 ; i < 3 ; i++ )
	{
		sprintf( section, "%s_effect%u", basesection, i+1 ) ;

		tmpval = GetIniInt( szbuf, section, "effect", STATIC ) ;

		switch ( tmpval )
		{
			case 0 : menu->ptConfig.effects[i].effect = STATIC ; break ;
			case 1 : menu->ptConfig.effects[i].effect = CIRCLE ; break ;
			case 2 : menu->ptConfig.effects[i].effect = SQUIGGLE ; break ;
			default : menu->ptConfig.effects[i].effect = STATIC ; break ;
		}

		GetIniInt( szbuf, section, "effect", STATIC ) ;

		menu->ptConfig.effects[i].offsetX = GetIniInt( szbuf, section, "offsetx", 0 ) ;
		menu->ptConfig.effects[i].offsetY = GetIniInt( szbuf, section, "offsety", 0 ) ;
		menu->ptConfig.effects[i].lengthX = ((float)GetIniInt( szbuf, section, "lengthx", 0 )) / 100.0f  ;
		menu->ptConfig.effects[i].lengthY = ((float)GetIniInt( szbuf, section, "lengthy", 0 ) ) / 100.0f  ;
		menu->ptConfig.effects[i].multX = ((float)GetIniInt( szbuf, section, "multiplierx", 100 ) ) / 100.0f  ;
		menu->ptConfig.effects[i].multY = ((float)GetIniInt( szbuf, section, "multipliery", 100 ) ) / 100.0f  ;
		menu->ptConfig.effects[i].multGen = ((float)GetIniInt( szbuf, section, "multiplier_general", 100 ) ) / 100.0f  ;
		menu->ptConfig.effects[i].framespeed= GetIniInt( szbuf, section, "framespeed", 20 ) ;
		menu->ptConfig.effects[i].numsprites= GetIniInt( szbuf, section, "numsprites", 0 ) ;
		menu->ptConfig.effects[i].sprite= GetIniInt( szbuf, section, "spritenum", -1 ) ;
		menu->ptConfig.effects[i].speed= ((float)GetIniInt( szbuf, section, "movespeed", 10000 ) ) / 100.0f  ;
		menu->ptConfig.effects[i].transparency= GetIniInt( szbuf, section, "transparency", 255 ) ;
		menu->ptConfig.effects[i].flipH= GetIniInt( szbuf, section, "flip_horiz", 0 ) ;
		menu->ptConfig.effects[i].flipV= GetIniInt( szbuf, section, "flip_vert", 0 ) ;
		menu->ptConfig.effects[i].scale = ((float)GetIniInt( szbuf, section, "size", 10 )) / 10.0f ;
	}


}

void CXBoxSample::saveSkinMenuSettings( FILE *outfile, char *basesection, MENU_PARAMS *menu ) 
{
	char section[100] ;
	int tmpval ;


	fprintf( outfile, "[%s_bkg]\r\n", basesection ) ;

	fprintf( outfile, "bkg=%s\r\n", menu->bkg ) ;
	fprintf( outfile, "transparency=%u\r\n", menu->transparency ) ;
	fprintf( outfile, "border_width=%u\r\n", menu->borderWidth ) ;
	fprintf( outfile, "screenshot_x=%d\r\n", menu->screenshotX ) ;
	fprintf( outfile, "screenshot_y=%d\r\n", menu->screenshotY ) ;
	fprintf( outfile, "screenshot_w=%d\r\n", menu->screenshotW ) ;
	fprintf( outfile, "screenshot_h=%d\r\n", menu->screenshotH ) ;
	fprintf( outfile, "screenshot_transparency=%d\r\n", menu->screenshotTransparency ) ;
	fprintf( outfile, "animation_delay=%d\r\n", menu->animationDelay ) ;
	fprintf( outfile, "\r\n" ) ;


	fprintf( outfile, "[%s_text]\r\n", basesection ) ;

	fprintf( outfile, "horiz_align=%u\r\n", menu->halign) ;
	fprintf( outfile, "vert_align=%u\r\n", menu->valign) ;
	fprintf( outfile, "offsetx=%u\r\n", menu->offsetx) ;
	fprintf( outfile, "offsety=%u\r\n", menu->offsety) ;
	fprintf( outfile, "max_text_width=%u\r\n", menu->maxTextWidth) ;
	fprintf( outfile, "normal_color=0x%08.8X\r\n", menu->normalColor) ;
	fprintf( outfile, "noted_color=0x%08.8X\r\n", menu->notedColor) ;
	fprintf( outfile, "selected_color=0x%08.8X\r\n", menu->selectedColor) ;
	fprintf( outfile, "selected__and_noted_color=0x%08.8X\r\n", menu->selectedAndNotedColor) ;
	fprintf( outfile, "select_bar_color=0x%08.8X\r\n", menu->selectBarColor) ;
	fprintf( outfile, "lines_per_page=%u\r\n", menu->maxNumLines) ;
	fprintf( outfile, "fontsize=%u\r\n", menu->size) ;
	fprintf( outfile, "line_height=%u\r\n", menu->lineHeight) ;
	fprintf( outfile, "\r\n" ) ;



	for ( int i = 0 ; i < 20 ; i++ )
	{
		fprintf( outfile, "[%s_sprite%u]\r\n", basesection, i+1 ) ;

		fprintf( outfile, "spritenum=%d\r\n", menu->ptConfig.sprites[i].sprite ) ;
		fprintf( outfile, "offsetx=%d\r\n", (int)( menu->ptConfig.sprites[i].offsetX +0) ) ; 
		fprintf( outfile, "offsety=%d\r\n", (int)( menu->ptConfig.sprites[i].offsetY +0) ) ; 
		fprintf( outfile, "framespeed=%u\r\n", menu->ptConfig.sprites[i].framespeed ) ; 
		fprintf( outfile, "flip_horiz=%u\r\n", menu->ptConfig.sprites[i].flipH) ; 
		fprintf( outfile, "flip_vert=%u\r\n", menu->ptConfig.sprites[i].flipV) ; 
		fprintf( outfile, "transparency=%u\r\n", menu->ptConfig.sprites[i].transparency ) ; 
		fprintf( outfile, "size=%3f\r\n", ( menu->ptConfig.sprites[i].scale*10.0f  ) ) ; 
		fprintf( outfile, "loop_once=%u\r\n", menu->ptConfig.sprites[i].loopOnce ) ; 
		fprintf( outfile, "motion_x=%u\r\n", (int)( menu->ptConfig.sprites[i].motionX*1000.0f +0 ) ) ; 
		fprintf( outfile, "motion_y=%u\r\n", (int)( menu->ptConfig.sprites[i].motionY*1000.0f +0 ) ) ; 
		fprintf( outfile, "rotate=%u\r\n", menu->ptConfig.sprites[i].rotate) ; 
		fprintf( outfile, "rect_t=%u\r\n", menu->ptConfig.sprites[i].rect_t) ; 
		fprintf( outfile, "rect_b=%u\r\n", menu->ptConfig.sprites[i].rect_b) ; 
		fprintf( outfile, "rect_l=%u\r\n", menu->ptConfig.sprites[i].rect_l) ; 
		fprintf( outfile, "rect_r=%u\r\n", menu->ptConfig.sprites[i].rect_r) ; 
		fprintf( outfile, "\r\n" ) ;

	}

	for ( int i = 0 ; i < 3 ; i++ )
	{
		fprintf( outfile, "[%s_effect%u]\r\n", basesection, i+1 ) ;

		switch ( menu->ptConfig.effects[i].effect )
		{
			case CIRCLE : fprintf( outfile, "effect=1\r\n" ) ; break ; 
			case SQUIGGLE : fprintf( outfile, "effect=2\r\n" ) ; break ; 
			default : fprintf( outfile, "effect=0\r\n" ) ; break ; 
		}

		fprintf( outfile, "offsetx=%u\r\n", (int)( menu->ptConfig.effects[i].offsetX +0 )) ; 
		fprintf( outfile, "offsety=%u\r\n", (int)( menu->ptConfig.effects[i].offsetY +0 )) ; 
		fprintf( outfile, "lengthx=%u\r\n", (int)( menu->ptConfig.effects[i].lengthX * 100.0f +0 )) ; 
		fprintf( outfile, "lengthy=%u\r\n", (int)( menu->ptConfig.effects[i].lengthY * 100.0f +0 )) ;
		fprintf( outfile, "multiplierx=%u\r\n", (int)( menu->ptConfig.effects[i].multX * 100.0f +0 )) ; 
		fprintf( outfile, "multipliery=%u\r\n", (int)( menu->ptConfig.effects[i].multY * 100.0f +0 )) ; 
		fprintf( outfile, "multiplier_general=%u\r\n", (int)( menu->ptConfig.effects[i].multGen * 100.0f +0 )) ; 
		fprintf( outfile, "framespeed=%u\r\n", menu->ptConfig.effects[i].framespeed ) ; 
		fprintf( outfile, "numsprites=%u\r\n", menu->ptConfig.effects[i].numsprites ); 
		fprintf( outfile, "spritenum=%d\r\n", menu->ptConfig.effects[i].sprite ) ; 
		fprintf( outfile, "movespeed=%u\r\n", (int)( menu->ptConfig.effects[i].speed * 100.0f +0 )) ; 
		fprintf( outfile, "transparency=%u\r\n", menu->ptConfig.effects[i].transparency ) ;
		fprintf( outfile, "size=%u\r\n", (int)( menu->ptConfig.effects[i].scale * 10.0f +0 )) ; 
		fprintf( outfile, "flip_horiz=%u\r\n", menu->ptConfig.effects[i].flipH) ; 
		fprintf( outfile, "flip_vert=%u\r\n", menu->ptConfig.effects[i].flipV) ; 
		fprintf( outfile, "\r\n" ) ;

	

	}


}

void CXBoxSample::doSaveSkin( ) 
{
	char skinpath[MAX_PATH] ;
	FILE *outfile ;
	char *szbuf ;
	int filesize ;

	szbuf = NULL ;


	sprintf( skinpath, "%s\\skin_settings.ini", DEFAULT_SAVE_PATH ) ;
	outfile = fopen( skinpath, "wb" ) ;


	if ( outfile == NULL )
		return ;

	strcpy( m_skin.loadEmuSplash, m_skin.loadingMenu.bkg ) ;

	fprintf( outfile, "[GENERAL]\r\n" ) ;
	fprintf( outfile, "load_emu_splash=%s\r\n", m_skin.loadEmuSplash ) ;
	fprintf( outfile, "load_game_splash=%s\r\n", m_skin.loadGameSplash ) ;
	fprintf( outfile, "menu_move_sound=%s\r\n", m_skin.menuMoveSound) ;
	fprintf( outfile, "menu_cancel_sound=%s\r\n", m_skin.menuCancelSound) ;
	fprintf( outfile, "menu_select_sound=%s\r\n", m_skin.menuSelectSound) ;
	fprintf( outfile, "menu_bkg_music=%s\r\n", m_skin.menuBkgMusic) ;
	fprintf( outfile, "font=%s\r\n", m_skin.font ) ;
	fprintf( outfile, "fade_speed=%u\r\n", m_skin.fade) ;
	fprintf( outfile, "transition_effect=%u\r\n", m_skin.transition) ;
	fprintf( outfile, "loopbgm=%u\r\n\r\n", m_skin.loopbgm) ;





	saveSkinMenuSettings( outfile, "MAIN_MENU", &(m_skin.mainMenu) ) ;
	saveSkinMenuSettings( outfile, "GAME_SELECT_MENU", &(m_skin.gameSelectMenu) ) ;
	saveSkinMenuSettings( outfile, "OTHER_MENU", &(m_skin.otherMenu) ) ;
	saveSkinMenuSettings( outfile, "POPUP_MENU", &(m_skin.popupMenu) ) ;
	saveSkinMenuSettings( outfile, "LOADING_MENU", &(m_skin.loadingMenu) ) ;

	fclose(outfile) ;

}


void CXBoxSample::doLoadSkin( char *skinname, int forceRoot ) 
{
	char skinpath[MAX_PATH] ;
	FILE *infile ;
	char *szbuf ;
	int filesize ;

	szbuf = NULL ;
	infile = NULL ;


	sprintfx( "loadskin\r\n") ;

	if ( ! forceRoot )
	{
		sprintf( skinpath, "%s\\skin_settings.ini", DEFAULT_SAVE_PATH ) ;
		infile = fopen( skinpath, "rb" ) ;

	}

	if ( infile == NULL )
	{

		sprintf( skinpath, "%s\\%s\\settings.ini", m_szSkinDir, skinname ) ;
		infile = fopen( skinpath, "rb" ) ;
	}



	if ( infile != NULL )
	{
		fseek( infile, 0, SEEK_END ) ;
		filesize = ftell(infile) ;
		fseek( infile, 0, SEEK_SET ) ;
		
		szbuf = (char*) malloc( filesize+2 ) ;
		

		memset( szbuf, 0, filesize+2 ) ;

		fread( szbuf, sizeof(char), filesize, infile ) ;

		fillIniStruct( szbuf ) ;

		//strupr(szbuf) ;
		fclose(infile) ;
	}
	else
	{
	}

	sprintfx( "loadskin\r\n") ;
	strcpy( m_szSkin, skinname ) ;

	sprintfx( "loadskin\r\n") ;

	GetIniString( szbuf, m_skin.loadEmuSplash, 100, "general", "load_emu_splash", "emusplash.png" ) ;
	GetIniString( szbuf, m_skin.loadGameSplash, 100, "general", "load_game_splash", "gamesplash.png" ) ;
	GetIniString( szbuf, m_skin.menuMoveSound, 100, "general", "menu_move_sound", "movesound.wav" ) ;
	GetIniString( szbuf, m_skin.menuCancelSound, 100, "general", "menu_cancel_sound", "cancelsound.wav" ) ;
	GetIniString( szbuf, m_skin.menuSelectSound, 100, "general", "menu_select_sound", "selectsound.wav" ) ;
	GetIniString( szbuf, m_skin.menuBkgMusic, 100, "general", "menu_bkg_music", "bkgmusic.mp3" ) ;
	GetIniString( szbuf, m_skin.font, 100, "general", "font", "default.ttf" ) ;
	m_skin.fade = GetIniInt( szbuf, "GENERAL", "fade_speed", 5 ) ;
	m_skin.transition = GetIniInt( szbuf, "GENERAL", "transition_effect", 0 ) ;
	m_skin.loopbgm = GetIniInt( szbuf, "GENERAL", "loop_bgm", 5 ) ;


	sprintfx( "loadskin\r\n") ;


	loadSkinMenuSettings( szbuf, "MAIN_MENU", &(m_skin.mainMenu) ) ;
	loadSkinMenuSettings( szbuf, "GAME_SELECT_MENU", &(m_skin.gameSelectMenu) ) ;
	loadSkinMenuSettings( szbuf, "OTHER_MENU", &(m_skin.otherMenu) ) ;
	loadSkinMenuSettings( szbuf, "POPUP_MENU", &(m_skin.popupMenu) ) ;
	loadSkinMenuSettings( szbuf, "LOADING_MENU", &(m_skin.loadingMenu) ) ;

	if ( strlen( m_skin.loadEmuSplash ) > 0 )
	{
		strcpy( m_skin.loadingMenu.bkg, m_skin.loadEmuSplash ) ;
	}

	sprintfx( "loadskin\r\n") ;

	sprintf( skinpath, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.mainMenu.bkg ) ;




	m_plaything.FreeSprites() ;
	m_sfxMenuCancel.Destroy() ;
	m_sfxMenuMove.Destroy() ;
	m_sfxMenuSelect.Destroy() ;

	if ( FAILED(m_pnlBackgroundMain.CreateMemory(m_pd3dDevice, skinpath, 640, 480)) )
	{
	}

	sprintfx( "loadskin\r\n") ;



	sprintf( skinpath, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.popupMenu.bkg ) ;


	if ( FAILED(m_pnlPopup.CreateMemory(m_pd3dDevice, skinpath, 350, 250 )) )
	{
	}

	/*
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, skinpath,
		 350, 250, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &m_pd3dBackgroundTexture)==D3D_OK)
	{
		if ( FAILED(m_pnlPopup.Create(m_pd3dDevice, m_pd3dBackgroundTexture, FALSE, 350, 250)) )
		{
		}
	}
	*/
	sprintfx( "loadskin\r\n") ;

	sprintf( skinpath, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.gameSelectMenu.bkg ) ;


	if ( FAILED(m_pnlBackgroundSelect.CreateMemory(m_pd3dDevice, skinpath, 640, 480)) )
	{
	}
/*
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, skinpath,
		 640, 480, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &m_pd3dBackgroundTexture)==D3D_OK)
	{
		if ( FAILED(m_pnlBackgroundSelect.Create(m_pd3dDevice, m_pd3dBackgroundTexture, FALSE, 640, 480)) )
		{
		}
	}
	*/
	sprintfx( "loadskin\r\n") ;

	sprintf( skinpath, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.otherMenu.bkg ) ;


	if ( FAILED(m_pnlBackgroundOther.CreateMemory(m_pd3dDevice, skinpath, 640, 480)) )
	{
	}
/*
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, skinpath,
		 640, 480, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &m_pd3dBackgroundTexture)==D3D_OK)
	{
		if ( FAILED(m_pnlBackgroundOther.Create(m_pd3dDevice, m_pd3dBackgroundTexture, FALSE, 640, 480)) )
		{
		}
	}
*/
	sprintfx( "loadskin\r\n") ;
	sprintf( skinpath, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.loadEmuSplash ) ;



	if ( FAILED(m_pnlSplashEmu.CreateMemory(m_pd3dDevice, skinpath, 640, 480)) )
	{
	}
/*
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, skinpath,
		 640, 480, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
		 //640, 480, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &m_pd3dBackgroundTexture)==D3D_OK)
	{
		if ( FAILED(m_pnlSplashEmu.Create(m_pd3dDevice, m_pd3dBackgroundTexture, FALSE, 640, 480)) )
		{
		}
	}
*/
	sprintfx( "loadskin\r\n") ;
	sprintf( skinpath, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.loadGameSplash ) ;


	if ( FAILED(m_pnlSplashGame.CreateMemory(m_pd3dDevice, skinpath, 640, 480)) )
	{
	}
/*
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, skinpath,
		 640, 480, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &m_pd3dBackgroundTexture)==D3D_OK)
	{
		if ( FAILED(m_pnlSplashGame.Create(m_pd3dDevice, m_pd3dBackgroundTexture, FALSE, 640, 480)) )
		{
		}
	}
*/
	sprintfx( "loadskin\r\n") ;

	m_skin.mainMenu.panel = &m_pnlBackgroundMain ;
	m_skin.gameSelectMenu.panel = &m_pnlBackgroundSelect;
	m_skin.otherMenu.panel = &m_pnlBackgroundOther;
	m_skin.popupMenu.panel = &m_pnlPopup;
	m_skin.loadingMenu.panel = &m_pnlSplashEmu;


	m_skin.mainMenu.panel->SetAlpha( m_skin.mainMenu.transparency )  ;
	m_skin.gameSelectMenu.panel->SetAlpha( m_skin.gameSelectMenu.transparency )  ;
	m_skin.popupMenu.panel->SetAlpha( m_skin.popupMenu.transparency )  ;
	m_skin.otherMenu.panel->SetAlpha( m_skin.otherMenu.transparency )  ;
	m_skin.loadingMenu.panel->SetAlpha( m_skin.loadingMenu.transparency )  ;




	char tmpfilename[MAX_PATH] ;
	sprintfx( "loadskin\r\n") ;

	sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.menuBkgMusic) ;

	if ( m_mp3player.loadFile( tmpfilename, m_skin.loopbgm, 0,9999999 ) )
	{
		//writexbox( "nonomp3\r\n") ;
	}
	else
	{
		//m_mp3player.insertSilence( 22050 ) ;
		m_mp3player.pause( FALSE ) ;
	}


	sprintfx( "loadskin\r\n") ;
	sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.menuCancelSound) ;

	m_sfxMenuCancel.Create( tmpfilename, 0 ) ;

	sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.menuMoveSound) ;

	m_sfxMenuMove.Create( tmpfilename, 0 ) ;

	sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.menuSelectSound) ;

	m_sfxMenuSelect.Create( tmpfilename, 0 ) ;

	sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.font ) ;



	m_Font.Initialize( m_pd3dDevice, tmpfilename, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;

	sprintf( tmpfilename, "%s\\%s\\SPRITES\\*", m_szSkinDir, m_szSkin) ;

	sprintfx( "loadskin\r\n") ;
	
	//m_plaything.FreeSprites() ;
	//sprintfx( "loadskin\r\n") ;
	m_plaything.Initialize( m_pd3dDevice, &m_Font, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;
	sprintfx( "loadskin\r\n") ;



	sprintfx( "about to load sprites\r\n") ;
	xbox_print_memory() ;

	m_plaything.LoadSprites( tmpfilename ) ;

	sprintfx( "after load sprites\r\n") ;
	xbox_print_memory() ;




	MENU_PARAMS *pparams ;

	pparams = &m_skin.mainMenu ;

	for ( int i = 0 ; i < 20 ; i++ )
	{
		if ( ( pparams->ptConfig.sprites[i].sprite < 0 ) || ( pparams->ptConfig.sprites[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.sprites[i].sprite = -1 ;
		}
	}
	for ( int i = 0 ; i < 3 ; i++ )
	{
		if ( ( pparams->ptConfig.effects[i].sprite < 0 ) || ( pparams->ptConfig.effects[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.effects[i].sprite = -1 ;
		}
	}

	pparams = &m_skin.otherMenu ;

	for ( int i = 0 ; i < 20 ; i++ )
	{
		if ( ( pparams->ptConfig.sprites[i].sprite < 0 ) || ( pparams->ptConfig.sprites[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.sprites[i].sprite = -1 ;
		}
	}
	for ( int i = 0 ; i < 3 ; i++ )
	{
		if ( ( pparams->ptConfig.effects[i].sprite < 0 ) || ( pparams->ptConfig.effects[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.effects[i].sprite = -1 ;
		}
	}

	pparams = &m_skin.gameSelectMenu ;

	for ( int i = 0 ; i < 20 ; i++ )
	{
		if ( ( pparams->ptConfig.sprites[i].sprite < 0 ) || ( pparams->ptConfig.sprites[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.sprites[i].sprite = -1 ;
		}
	}
	for ( int i = 0 ; i < 3 ; i++ )
	{
		if ( ( pparams->ptConfig.effects[i].sprite < 0 ) || ( pparams->ptConfig.effects[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.effects[i].sprite = -1 ;
		}
	}

	pparams = &m_skin.popupMenu ;

	for ( int i = 0 ; i < 20 ; i++ )
	{
		if ( ( pparams->ptConfig.sprites[i].sprite < 0 ) || ( pparams->ptConfig.sprites[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.sprites[i].sprite = -1 ;
		}
	}
	for ( int i = 0 ; i < 3 ; i++ )
	{
		if ( ( pparams->ptConfig.effects[i].sprite < 0 ) || ( pparams->ptConfig.effects[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.effects[i].sprite = -1 ;
		}
	}

	pparams = &m_skin.loadingMenu ;

	for ( int i = 0 ; i < 20 ; i++ )
	{
		if ( ( pparams->ptConfig.sprites[i].sprite < 0 ) || ( pparams->ptConfig.sprites[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.sprites[i].sprite = -1 ;
		}
	}
	for ( int i = 0 ; i < 3 ; i++ )
	{
		if ( ( pparams->ptConfig.effects[i].sprite < 0 ) || ( pparams->ptConfig.effects[i].sprite >= m_plaything.m_spritedefs.GetSize() ) )
		{
			pparams->ptConfig.effects[i].sprite = -1 ;
		}
	}

	sprintfx( "loadskin\r\n") ;
	memcpy( &m_ptConfig, &(m_skin.mainMenu.ptConfig), sizeof(m_ptConfig) ) ;
	SetupPlaything() ;
	sprintfx( "loadskin\r\n") ;

	if ( szbuf )
	{
		free(szbuf) ;
		fillIniStruct( NULL ) ;
	}

}




void CXBoxSample::doLoadIni( int forceRoot ) 
{
	char inifile[MAX_PATH] ;
	FILE *infile ;
	int filesize ;
	char *szbuf ;
	char *stringloc ;
	char *npos ;
	char holder[500] ;

	szbuf = NULL ;
	infile = NULL ;

	if ( ! forceRoot )
	{
		sprintf( inifile, "%s\\%s", DEFAULT_SAVE_PATH, PLATFORM_INI ) ;
		infile = fopen( inifile, "rb" ) ;

		if ( infile )
		{
			fseek( infile, 0, SEEK_END ) ;
			if ( ftell( infile ) < 200 )
			{
				fclose(infile) ;
				infile = NULL ;
			}

		}
	}

	if ( infile == NULL )
	{
		sprintf( inifile, "D:\\%s", PLATFORM_INI ) ;
		infile = fopen( inifile, "rb" ) ;

	}

	memset( m_smbShare, 0, 500 ) ;
	memset( m_rlxShare, 0, 500 ) ;
	memset( holder, 0, 500 ) ;
	memset( g_szLocalAddress, 0, 200 ) ;
	memset( g_szLocalSubnet, 0, 200 ) ;
	memset( g_szLocalGateway, 0, 200 ) ;

	if ( infile != NULL )
	{
		fseek( infile, 0, SEEK_END );
		filesize = ftell( infile ) ;
		fseek( infile, 0, SEEK_SET ) ;
		szbuf = (char*)malloc( filesize+2 ) ;
		memset( szbuf, 0, filesize+2 ) ;
		fread( szbuf, sizeof(char), filesize, infile) ;

		fillIniStruct( szbuf ) ;

		//strupr( szbuf ) ;


		stringloc = GetIniString( szbuf, m_smbShare, 500, "GENERAL", "SMBSHARE", "" ) ;

		/*
		if ( stringloc )
		{
			fseek( infile, stringloc-szbuf, SEEK_SET ) ;
			fread( m_smbShare, sizeof(char), strlen(holder), infile ) ;
			m_smbShare[strlen(holder)] = 0 ;
		}
		else
		{
			//sprintfx( "null loc\r\n") ;
			strcpy( m_smbShare, "" ) ;
		}*/

		stringloc = GetIniString( szbuf, m_rlxShare, 500, "GENERAL", "RLXSHARE", "" ) ;
/*
		if ( stringloc )
		{
			fseek( infile, stringloc-szbuf, SEEK_SET ) ;
			fread( m_rlxShare, sizeof(char), strlen(holder), infile ) ;
			m_rlxShare[strlen(holder)] = 0 ;
		}
		else
		{
			//sprintfx( "null loc\r\n") ;
			strcpy( m_rlxShare, holder ) ;
		}
		*/

		//sprintfx("diff %d old %s new %s\r\n", stringloc-szbuf, holder, m_smbShare ) ;
		fclose(infile) ;
	}

	GetIniString( szbuf, g_szLocalAddress, 200, "GENERAL", "LOCAL_IP", "" ) ;
	GetIniString( szbuf, g_szLocalSubnet, 200, "GENERAL", "SUBNET_MASK", "" ) ;
	GetIniString( szbuf, g_szLocalGateway, 200, "GENERAL", "GATEWAY_IP", "" ) ;


	m_nXOffset = GetIniInt( szbuf, "GENERAL", "TEXT_OFFSET_X", 0 ) ;
	m_nYOffset = GetIniInt( szbuf, "GENERAL", "TEXT_OFFSET_Y", 0 ) ;
	m_nScreenX = GetIniInt( szbuf, "GENERAL", "SCREENX", 0 ) ;
	m_nScreenY = GetIniInt( szbuf, "GENERAL", "SCREENY", 0 ) ;
	m_nScreenMaxX = GetIniInt( szbuf, "GENERAL", "SCREENMAXX", 640 ) ;
	m_nScreenMaxY  = GetIniInt( szbuf, "GENERAL", "SCREENMAXY", 480 ) ;
	m_scrollSpeed = GetIniInt( szbuf, "GENERAL", "scroll_speed", 10 ) ;
	m_defaultScreenshots = GetIniInt( szbuf, "GENERAL", "show_screenshots", 1 ) ;
	m_bBgmInGame = GetIniInt( szbuf, "GENERAL", "bgm_in_game", 1 ) ;
	m_bAutoLoadSaveState = GetIniInt( szbuf, "GENERAL", "auto_load_save_state", 1 ) ;
	m_captureSpeed = GetIniInt( szbuf, "GENERAL", "CAPTURE_SPEED", 4 ) ;
	m_throttleSpeed = GetIniInt( szbuf, "GENERAL", "THROTTLE_SPEED", 4 ) ;

	if ( m_doDebug == 0 )
		m_doDebug = GetIniInt( szbuf, "GENERAL", "DEBUG", 0 ) ;

	m_xboxHFilter = GetIniInt( szbuf, "GENERAL", "hardware_filter", 0 ) ;
	m_xboxSFilter = GetIniInt( szbuf, "GENERAL", "software_filter", 0 ) ;
	//m_xboxVidmode = GetIniInt( szbuf, "GENERAL", "video_mode", 0 ) ;

	if ( m_xboxSFilter >= NUM_SOFTWARE_FILTERS )
		m_xboxSFilter = 0 ;
	if ( m_xboxSFilter < 0  )
		m_xboxSFilter = 0 ;


	if ( m_xboxHFilter >= NUM_XBOX_FILTERS )
		m_xboxHFilter = 0 ;
	if ( m_xboxHFilter < 0  )
		m_xboxHFilter = 0 ;


	switch ( m_xboxHFilter )
	{
		case 0 :
		{
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_POINT);
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_POINT);
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);

			break ; 
		}
		case 1 :
		{
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);
			break ; 
		}
		case 2 :
		{
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR);
			break ;
		}
		case 3 :
		{
			float fBias = -4.0;
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_ANISOTROPIC);
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_ANISOTROPIC);
			//m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_ANISOTROPIC);
			m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAXANISOTROPY, 4);
			break ;
		}
		default : break ;
	}




	m_seeFavoritesPath = GetIniInt( szbuf, "GENERAL", "favorites_see_path",1 ) ;

	GetIniString( szbuf, m_szSkin, 50, "GENERAL", "SKIN", DEFAULT_SKIN ) ;
	GetIniString( szbuf, m_szSkinDir, MAX_PATH, "GENERAL", "SKIN_DIR", DEFAULT_SKIN_DIR ) ;

	GetIniString( szbuf, m_defaultMusicDir, MAX_PATH, "GENERAL", "MUSIC_DIR", DEFAULT_PARENT_DIR) ;
	if ( strcmp( m_defaultMusicDir, DEFAULT_PARENT_DIR ) )
	{
		if ( strlen( m_defaultMusicDir ) && ( m_defaultMusicDir[strlen(m_defaultMusicDir)-1] != '\\' ) )
		{
			strcat( m_defaultMusicDir, "\\" ) ;
		}
		strcat( m_defaultMusicDir, "*" ) ;
	}

	GetIniString( szbuf, m_defaultRomDir, MAX_PATH, "GENERAL", "ROM_DIR", DEFAULT_PARENT_DIR) ;

	if ( strcmp( m_defaultRomDir, DEFAULT_PARENT_DIR ) )
	{
		if ( strlen( m_defaultRomDir ) && ( m_defaultRomDir[strlen(m_defaultRomDir)-1] != '\\' ) )
		{
			strcat( m_defaultRomDir, "\\" ) ;
		}
		strcat( m_defaultRomDir, "*" ) ;
	}


	GetIniString( szbuf, m_smbNameServer, 50, "GENERAL", "SMB_NAMESERVER", "" ) ;
	GetIniString( szbuf, m_screenshotDir, MAX_PATH, "GENERAL", "SCREENSHOT_DIR", "E:\\SCREENSHOTS" ) ;
	GetIniString( szbuf, m_szUserSavePath, 500, "GENERAL", "SAVE_DIR", DEFAULT_SAVE_PATH ) ;
	//GetIniString( szbuf, m_smbShare, 500, "GENERAL", "SMBSHARE", "smb://Administrator@dvd/D$" ) ;


	char szNewDir[500] ;
	char *s, *p ;

	strcpy( szNewDir, m_screenshotDir ) ;

	s = szNewDir+3 ;
	

	while ( p = strchr( s, '\\' ) )
	{
		*p = 0 ;
		CreateDirectory( szNewDir, NULL ) ;

		*p = '\\' ;

		p++ ;
		s = p ;
	}

	CreateDirectory( m_screenshotDir, NULL ) ;

	sprintf( szNewDir, "%s\\%s", m_screenshotDir, PLATFORM_NAME ) ; 

	CreateDirectory( szNewDir, NULL ) ;

#ifdef GAMEBASE
	sprintf( szNewDir, "%s\\%s\\0", m_screenshotDir, PLATFORM_NAME ) ;
	CreateDirectory( szNewDir, NULL ) ;

	for ( char c = 'A' ; c <= 'Z' ; c++ )
	{
		sprintf( szNewDir, "%s\\%s\\%c", m_screenshotDir, PLATFORM_NAME, c ) ;
		CreateDirectory( szNewDir, NULL ) ;
	}
#endif

	char setting[30] ;

	for ( int i = 0 ; i < 32 ; i++ )
	{
		sprintf( setting, "NETPLAY_SERVER%u", i+1 ) ;
		GetIniString( szbuf, m_netplayServers[i].ip, 30, "GENERAL", setting, "" ) ;
	}

	loadControllerSettings( szbuf ) ;

	doLoadEmuSpecificIni( szbuf ) ;

	if ( szbuf )
	{
		free( szbuf ) ;
		fillIniStruct( NULL );
	}
}

void CXBoxSample::renderDualMenuText( int selectable, int selected, WCHAR **lines, int numlines, int isPopup, int colSpacing )
{
	WCHAR *line ;
	WCHAR *line2 ;
	int ofsx, ofsy, linewidth, curr ;
	int ofsx2, ofsy2, linewidth2 ;
	int maxwidth ;
	int restrict, startline, endline ;
	static DWORD rainbow = 0xFF808080;
	static int dir1 = 1 ;
	static int dir2 = 1 ;
	static int dir3 = 1 ;
	static DWORD rainbowTime = GetTickCount() ;
	int testval ;
	int maxlines ;

	ofsx = 0 ;
	ofsy = 0 ;
	linewidth = 0 ;
	ofsx2 = 0 ;
	ofsy2 = 0 ;
	linewidth2 = 0 ;
	restrict = 0 ;
	startline =0 ;
	endline = 0 ;

	if ( GetTickCount() - rainbowTime > 10 )
	{
		rainbowTime = GetTickCount() ;

		testval = rand() ;

		switch ( testval % 3 )
		{
			case 0 :
			{
				if ( ( ( dir1 > 0 ) && ( ( ( rainbow >> 16 ) & 0xFF ) == 0xF0 ) ) ||
					 ( ( dir1 < 0 ) && ( ( ( rainbow >> 16 ) & 0xFF ) == 0x00 ) ) )
				{
					dir1 = dir1*-1 ;
				}

				rainbow = ( ( ( ( rainbow >> 16 ) & 0xFF ) + (dir1*8) ) << 16 ) | ( rainbow & 0xFF00FFFF ) ;

				break ;
			}
			case 1 :
			{
				if ( ( ( dir2 > 0 ) && ( ( ( rainbow >> 8 ) & 0xFF ) == 0xF0 ) ) ||
					 ( ( dir2 < 0 ) && ( ( ( rainbow >> 8 ) & 0xFF ) == 0x00 ) ) )
				{
					dir2 = dir2*-1 ;
				}

				rainbow = ( ( ( ( rainbow >> 8 ) & 0xFF ) + (dir2*8) ) << 8 ) | ( rainbow & 0xFFFF00FF ) ;
				break ;
			}
			default :
			{
				if ( ( ( dir3 > 0 ) && ( ( ( rainbow >> 0 ) & 0xFF ) == 0xF0 ) ) ||
					 ( ( dir3 < 0 ) && ( ( ( rainbow >> 0 ) & 0xFF ) == 0x00 ) ) )
				{
					dir3 = dir3*-1 ;
				}

				rainbow = ( ( ( ( rainbow >> 0 ) & 0xFF ) + (dir3*8) ) << 0 ) | ( rainbow & 0xFFFFFF00 ) ;
				break ;
			}
		}
	}

	m_Font.Begin();

	curr = 0 ;
	maxwidth = 0 ;
	maxlines = pmenuParams->maxNumLines ;

	if ( ( numlines > maxlines ) && ( selectable ) && ( maxlines ) )
	{
		restrict = 1 ;
		if ( selected+2 > maxlines )
		{
			startline = (selected+3)-maxlines ;
			endline = (startline+maxlines)-2 ;
		}
		else
		{
			startline = 1 ;
			endline = maxlines-1 ;
		}
	}
	else
	{
		startline = 1 ;
		endline = numlines-1 ;
	}

	for ( int i = 1 ; i < numlines ; i++ )
	{
		linewidth = ((float)m_Font.GetWidth( lines[((i-1)*2)+2] ))/VIDEOMODES[m_xboxVidmode].multx ;
		linewidth += colSpacing ;
		if ( linewidth > maxwidth )
			maxwidth = linewidth ;
	}

	for ( int i = 0 ; i < numlines ; i++ )
	{
		m_mp3player.process() ;
		if ( i && restrict && ( ( i < startline ) || ( i > endline ) ) )
		{
			continue ;
		}

		if ( i )
		{
			line = lines[((i-1)*2)+1] ; 
			line2 = lines[((i-1)*2)+2] ; 
		}
		else
		{
			line = lines[0] ;
			line2 = lines[0] ;
		}

		if ( !line || !line2 ) 
		{
			break ;
		}

		switch ( pmenuParams->halign )
		{
			case 0 :   //left aligned
			{
				if ( i )
				{
					ofsx = m_nXOffset + pmenuParams->offsetx ;
					ofsx2 = m_nXOffset + pmenuParams->offsetx  + colSpacing ;
				}
				else
				{
					ofsx = m_nXOffset + pmenuParams->offsetx ;
				}

				break ;
			}
			case 1 :   //right aligned
			{
				if ( i )
				{
					ofsx = ( 640 - maxwidth ) + m_nXOffset + pmenuParams->offsetx ;
					ofsx2 = ofsx+colSpacing ;
					
				}
				else
				{
					linewidth = ((float)m_Font.GetWidth( line ))/VIDEOMODES[m_xboxVidmode].multx ;

					ofsx = ( 640 - linewidth ) + m_nXOffset + pmenuParams->offsetx ;
				}

				break ;
			}
			default :   //center aligned
			{
				if ( i )
				{
					ofsx = ( ( 640 - maxwidth ) /2 ) + m_nXOffset + pmenuParams->offsetx ;
					ofsx2 = ofsx+colSpacing ;
				}
				else
				{
					linewidth = ((float)m_Font.GetWidth( line ))/VIDEOMODES[m_xboxVidmode].multx ;

					ofsx = ( ( 640 - linewidth ) /2 ) + m_nXOffset + pmenuParams->offsetx ;
				}
				break ;
			}
		}

		switch ( pmenuParams->valign )
		{
			case 0 :   //top aligned
			{
				if ( i )
				{
					ofsy = m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
					ofsy2 = ofsy ;
				}
				else
				{
					ofsy = m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
				}

				break ;
			}
			case 1 :   //bottom aligned
			{
				if ( i )
				{
					ofsy = ( 480 - (pmenuParams->lineHeight* ( ( restrict ? maxlines : numlines ) - curr ) ) ) + m_nYOffset + pmenuParams->offsety ;
					ofsy2 = ofsy ;
				}
				else
				{
					ofsy = ( 480 - (pmenuParams->lineHeight* ( ( restrict ? maxlines : numlines ) - curr ) ) ) + m_nYOffset + pmenuParams->offsety ;
				}

				break ;
			}
			default :   //center aligned
			{
				if ( i )
				{
					if ( pmenuParams->lineHeight* ( restrict ? maxlines : numlines ) > 480 )
						ofsy = m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
					else
						ofsy = ( ( 480 - (pmenuParams->lineHeight* ( restrict ? maxlines : numlines ) ) ) /2 ) + m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
					ofsy2 = ofsy ;
				}
				else
				{
					if ( pmenuParams->lineHeight* ( restrict ? maxlines : numlines ) > 480 )
						ofsy = m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
					else
						ofsy = ( ( 480 - (pmenuParams->lineHeight* ( restrict ? maxlines : numlines ) ) ) /2 ) + m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
				}
				break ;
			}
		}

		if ( ofsx < 0 )
			ofsx = 0 ;

		if ( ofsy < 0 )
			ofsy = 0 ;

		if ( ofsx > 640 )
			ofsx = 640 ;

		if ( ofsy > 480 )
			ofsy = 480 ;

		if ( ofsx2 < 0 )
			ofsx2 = 0 ;

		if ( ofsy2 < 0 )
			ofsy2 = 0 ;

		if ( ofsx2 > 640 )
			ofsx2 = 640 ;

		if ( ofsy2 > 480 )
			ofsy2 = 480 ;

		if ( i )
		{
			if ( selectable && ( selected+1 == i ) )
			{
				m_plaything.m_sprites[18].m_posX = ofsx + pmenuParams->ptConfig.sprites[18].offsetX - m_plaything.m_sprites[18].m_trueWidth ;
				m_plaything.m_sprites[18].m_posY = ofsy + pmenuParams->ptConfig.sprites[18].offsetY ;
				m_plaything.m_sprites[19].m_posX = ofsx2 + pmenuParams->ptConfig.sprites[19].offsetX + m_Font.GetWidth( line2 )/VIDEOMODES[m_xboxVidmode].multx;
				m_plaything.m_sprites[19].m_posY = ofsy2 + pmenuParams->ptConfig.sprites[19].offsetY ;

				m_Font.DrawText( (float)ofsx, ofsy, pmenuParams->selectedColor, line, pmenuParams->selectBarColor, 1, 0, 0, 0, pmenuParams->size ) ;
				m_Font.DrawText( (float)ofsx2, ofsy2, pmenuParams->selectedColor, line2, pmenuParams->selectBarColor, 1, 0, 0, 0, pmenuParams->size ) ;
			}
			else
			{
				m_Font.DrawText( (float)ofsx, ofsy, pmenuParams->normalColor, line, pmenuParams->selectBarColor, 0, 0, 0, 0, pmenuParams->size ) ;
				m_Font.DrawText( (float)ofsx2, ofsy2, pmenuParams->normalColor, line2, pmenuParams->selectBarColor, 0, 0, 0, 0, pmenuParams->size ) ;
			}
				//m_Font.DrawText( (float)ofsx, ofsy, (selectable && ( selected+1==i)) ? pmenuParams->selectedColor : pmenuParams->normalColor, line, pmenuParams->selectBarColor, (selectable && ( selected+1==i)), 0, 0, 0, pmenuParams->size ) ;
				//m_Font.DrawText( (float)ofsx2, ofsy2, (selectable && ( selected+1==i)) ? pmenuParams->selectedColor : pmenuParams->normalColor, line2, pmenuParams->selectBarColor, (selectable && ( selected+1==i)), 0, 0, 0, pmenuParams->size ) ;
		}
		else
		{
			m_Font.DrawText( (float)ofsx, ofsy, (selectable && ( selected+1==i)) ? pmenuParams->selectedColor : rainbow, line, pmenuParams->selectBarColor, (selectable && ( selected+1==i)), 0, 0, 0, pmenuParams->size   ) ;
		}

		curr++ ;
	} 

	m_Font.End();

	//sprintfx( "numlines=%u\r\n", numlines ) ;

}

void CXBoxSample::renderMenuText( int selectable, int selected, WCHAR **lines, int numlines, int isPopup )
{
	WCHAR *line ;
	int ofsx, ofsy, linewidth, curr ;
	int startline, endline ;
	int restrict ;
	static DWORD rainbow = 0xFF808080;
	static int dir1 = 1 ;
	static int dir2 = 1 ;
	static int dir3 = 1 ;
	static int linepos =0 ;
	static int linedir = 1 ;
	static DWORD linetime =GetTickCount() ;
	static DWORD rainbowTime =GetTickCount() ;
	int testval ;
	int maxlines ;
	MENU_PARAMS *holder ;

	ofsx = 0 ;
	ofsy = 0 ;
	linewidth = 0 ;
	restrict = 0 ;

	holder = pmenuParams ;

	if ( isPopup )
		pmenuParams = &(m_skin.popupMenu) ;

	if ( linepos >= wcslen( lines[selected+1] ) )
	{
		linepos =0 ;
		linetime = GetTickCount() ;
	}

	if ( selectable )
	{
		if ( m_Font.GetWidth( lines[selected+1] ) > pmenuParams->maxTextWidth*VIDEOMODES[m_xboxVidmode].multx )
		{

			if ( GetTickCount() - linetime > 250 )
			{
				linepos += linedir ;
				linetime = GetTickCount() ;

				if ( linepos < 0 )
				{
					linepos = 0 ;
					linedir = 1 ;
				}
				else
				{
					if ( m_Font.GetWidth( lines[selected+1]+linepos ) <= pmenuParams->maxTextWidth*VIDEOMODES[m_xboxVidmode].multx )
					{

						linedir = -1 ;
					}
				}
			}
		}
		else
		{
			linepos = 0 ;
			linetime = GetTickCount() ;
		}
	}
	else
	{
		linepos = 0 ;
		linetime = GetTickCount() ;
	}

	if ( linepos >= wcslen( lines[selected+1] ) )
	{
		linepos =0 ;
		linetime = GetTickCount() ;
	}

	if ( GetTickCount() - rainbowTime > 10 )
	{
		rainbowTime = GetTickCount() ;
		testval = rand() ;

		switch ( testval % 3 )
		{
			case 0 :
			{
				if ( ( ( dir1 > 0 ) && ( ( ( rainbow >> 16 ) & 0xFF ) == 0xF0 ) ) ||
					 ( ( dir1 < 0 ) && ( ( ( rainbow >> 16 ) & 0xFF ) == 0x00 ) ) )
				{
					dir1 = dir1*-1 ;
				}

				rainbow = ( ( ( ( rainbow >> 16 ) & 0xFF ) + (dir1*8) ) << 16 ) | ( rainbow & 0xFF00FFFF ) ;

				break ;
			}
			case 1 :
			{
				if ( ( ( dir2 > 0 ) && ( ( ( rainbow >> 8 ) & 0xFF ) == 0xF0 ) ) ||
					 ( ( dir2 < 0 ) && ( ( ( rainbow >> 8 ) & 0xFF ) == 0x00 ) ) )
				{
					dir2 = dir2*-1 ;
				}

				rainbow = ( ( ( ( rainbow >> 8 ) & 0xFF ) + (dir2*8) ) << 8 ) | ( rainbow & 0xFFFF00FF ) ;
				break ;
			}
			default :
			{
				if ( ( ( dir3 > 0 ) && ( ( ( rainbow >> 0 ) & 0xFF ) == 0xF0 ) ) ||
					 ( ( dir3 < 0 ) && ( ( ( rainbow >> 0 ) & 0xFF ) == 0x00 ) ) )
				{
					dir3 = dir3*-1 ;
				}

				rainbow = ( ( ( ( rainbow >> 0 ) & 0xFF ) + (dir3*8) ) << 0 ) | ( rainbow & 0xFFFFFF00 ) ;
				break ;
			}
		}
	}

	m_Font.Begin();

	curr = 0 ;
	maxlines = pmenuParams->maxNumLines ;

	if ( ( numlines > maxlines ) && ( selectable ) && ( maxlines ) )
	{
		restrict = 1 ;
		if ( selected+2 > maxlines )
		{
			startline = (selected+3)-maxlines ;
			endline = (startline+maxlines)-2 ;
		}
		else
		{
			startline = 1 ;
			endline = maxlines-1 ;
		}
	}
	else
	{
		startline = 1 ;
		endline = numlines-1 ;
	}

	for ( int i = 0 ; i < numlines ; i++ )
	{
		m_mp3player.process() ;

		line = lines[i] ; 

		if ( !line ) 
		{
			break ;
		}

		if ( i && restrict && ( ( i < startline ) || ( i > endline ) ) )
		{
			continue ;
		}

		switch ( pmenuParams->halign )
		{
			case 0 :   //left aligned
			{
				ofsx = m_nXOffset + pmenuParams->offsetx ;
				if ( isPopup )
					ofsx += pmenuParams->borderWidth*2 ;
				break ;
			}
			case 1 :   //right aligned
			{
				linewidth = ((float)m_Font.GetWidth( line ))/VIDEOMODES[m_xboxVidmode].multx ;

				if ( linewidth > pmenuParams->maxTextWidth )
					linewidth = pmenuParams->maxTextWidth ;

				ofsx = ( 640 - linewidth ) + m_nXOffset + pmenuParams->offsetx ;
				if ( isPopup )
					ofsx -= pmenuParams->borderWidth*2 ;
				break ;
			}
			default :   //center aligned
			{
				linewidth = ((float)m_Font.GetWidth( line ))/VIDEOMODES[m_xboxVidmode].multx ;

				if ( linewidth > pmenuParams->maxTextWidth )
					linewidth = pmenuParams->maxTextWidth ;

				ofsx = ( ( 640 - linewidth ) /2 ) + m_nXOffset + pmenuParams->offsetx ;
				break ;
			}
		}

		switch ( pmenuParams->valign )
		{
			case 0 :   //top aligned
			{
				ofsy = m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
				if ( isPopup )
					ofsy += pmenuParams->borderWidth*2 ;
				break ;
			}
			case 1 :   //bottom aligned
			{
				ofsy = ( 480 - (pmenuParams->lineHeight* ( ( restrict ? maxlines : numlines ) - curr ) ) ) + m_nYOffset + pmenuParams->offsety ;
				if ( isPopup )
					ofsy -= pmenuParams->borderWidth*2 ;
				break ;
			}
			default :   //center aligned
			{
				if ( pmenuParams->lineHeight* ( restrict ? maxlines : numlines ) > 480 )
					ofsy = m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
				else
					ofsy = ( ( 480 - (pmenuParams->lineHeight* ( restrict ? maxlines : numlines ) ) ) /2 ) + m_nYOffset + pmenuParams->offsety + ( pmenuParams->lineHeight*curr);
				break ;
			}
		}

		if ( ofsx < 0 )
			ofsx = 0 ;

		if ( ofsy < 0 )
			ofsy = 0 ;

		if ( ofsx > 640 )
			ofsx = 640 ;

		if ( ofsy > 480 )
			ofsy = 480 ;

		if ( selectable && ( selected+1==i) )
		{
			m_plaything.m_sprites[18].m_posX = ofsx + pmenuParams->ptConfig.sprites[18].offsetX - m_plaything.m_sprites[18].m_trueWidth ;
			m_plaything.m_sprites[18].m_posY = ofsy + pmenuParams->ptConfig.sprites[18].offsetY ;
			m_plaything.m_sprites[19].m_posX = ofsx + pmenuParams->ptConfig.sprites[19].offsetX + min(m_Font.GetWidth( line + linepos )/VIDEOMODES[m_xboxVidmode].multx, pmenuParams->maxTextWidth );
			m_plaything.m_sprites[19].m_posY = ofsy + pmenuParams->ptConfig.sprites[19].offsetY ;

			

			m_Font.DrawText( (float)ofsx, ofsy, pmenuParams->selectedColor , line+( linepos  ), pmenuParams->selectBarColor, 1, 0, pmenuParams->maxTextWidth, pmenuParams->lineHeight, pmenuParams->size   ) ;
		}
		else
		{
			m_Font.DrawText( (float)ofsx, ofsy, ( i==0 ? rainbow : pmenuParams->normalColor ) , line, pmenuParams->selectBarColor, 0, 0, pmenuParams->maxTextWidth, pmenuParams->lineHeight, pmenuParams->size   ) ;
		}
		//m_Font.DrawText( (float)ofsx, ofsy, (selectable && ( selected+1==i)) ? pmenuParams->selectedColor : ( i==0 ? rainbow : pmenuParams->normalColor ) , line+( ( selectable && (i == selected+1)) ? linepos : 0 ), pmenuParams->selectBarColor, (selectable && ( selected+1==i)), 0, pmenuParams->maxTextWidth, pmenuParams->lineHeight, pmenuParams->size   ) ;

		curr++ ;
	} 

	m_Font.End();

	pmenuParams = holder ;

	//sprintfx( "numlines=%u\r\n", numlines ) ;

}
void CXBoxSample::renderPopupBkg( int numlines ) 
{
	int ofsx, ofsy ;
	int textheight, textwidth ;
	//CPanel tpanel ;

	textheight = 0 ;
	textwidth = 0 ;

	m_Font.SetFontHeight( pmenuParams->size ) ;


	for ( int i = 0 ; i < numlines ; i++ )
	{
		if ( m_Font.GetWidth( m_menuText[i] )/VIDEOMODES[m_xboxVidmode].multx > textwidth )
			textwidth = m_Font.GetWidth( m_menuText[i] )/VIDEOMODES[m_xboxVidmode].multx;
	}

	if ( textwidth > pmenuParams->maxTextWidth )
		textwidth = pmenuParams->maxTextWidth ;

	textheight = numlines*pmenuParams->lineHeight ;

	textwidth += pmenuParams->borderWidth * 4 ;
	textheight += pmenuParams->borderWidth * 4 ;

	switch ( pmenuParams->halign )
	{
		case 0 :   //left aligned
		{
			ofsx = m_nXOffset + pmenuParams->offsetx ;
			break ;
		}
		case 1 :   //right aligned
		{
			ofsx = ( 640 - textwidth ) + m_nXOffset + pmenuParams->offsetx ;
			break ;
		}
		default :   //center aligned
		{
			ofsx = ( ( 640 - textwidth ) /2 ) + m_nXOffset + pmenuParams->offsetx ;
			break ;
		}
	}

	switch ( pmenuParams->valign )
	{
		case 0 :   //top aligned
		{
			ofsy = m_nYOffset + pmenuParams->offsety ;
			break ;
		}
		case 1 :   //bottom aligned
		{
			ofsy = ( 480 - textheight ) + m_nYOffset + pmenuParams->offsety ;
			break ;
		}
		default :   //center aligned
		{
			ofsy = ( ( 480 - textheight ) /2 ) + m_nYOffset + pmenuParams->offsety ;
			break ;
		}
	}

	if ( ofsx < 0 )
		ofsx = 0 ;

	if ( ofsy < 0 )
		ofsy = 0 ;

	if ( ofsx > 640 )
		ofsx = 640 ;

	if ( ofsy > 480 )
		ofsy = 480 ;
/*
	//D3DXVECTOR2 vecScale( 1.0f,1.0f ) ;
	//D3DXVECTOR2 vecTranslate( 0,0 ) ;
	D3DXVECTOR2 vecScale( (float)textwidth/(float)m_pnlPopup.m_nWidth, (float)textheight/(float)m_pnlPopup.m_nHeight ) ;
	D3DXVECTOR2 vecTranslate( ofsx, ofsy ) ;
	D3DXCOLOR d3color(1.0, 1.0, 1.0, ((float)m_skin.popupMenu.transparency)/255.0f);
	//D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0 ) ; 

	RECT rectSource ;

	rectSource.top = 0;
	rectSource.left = 0;
	//rectSource.bottom = 50 ;
	//rectSource.right  = 50 ;
	rectSource.bottom = m_pnlPopup.m_nHeight - 1 ;
	rectSource.right  = m_pnlPopup.m_nWidth - 1 ;
	
	if ( MenuSprite==NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);
*/
	//MenuSprite->Draw(m_pnlPopup.m_pTexture, NULL, NULL, NULL, 0, NULL, 0xFFFFFFFF);
	//MenuSprite->Draw(m_pnlPopup.m_pTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);

	//tpanel.m_colDiffuse = 0x80FFFFFF ;
	//tpanel.CreateSized( m_pd3dDevice, m_pnlPopup.m_pTexture, ofsx, ofsy, textwidth, textheight ) ;
	//tpanel.SetAlpha( 0x20 ) ;
	//tpanel.Render() ;
	m_pnlPopup.Render( ofsx*VIDEOMODES[m_xboxVidmode].multx, ofsy*VIDEOMODES[m_xboxVidmode].multy, textwidth*VIDEOMODES[m_xboxVidmode].multx, textheight*VIDEOMODES[m_xboxVidmode].multy ) ;
}

int CXBoxSample::renderMenuTextWrapper( int selectable, int selected, WCHAR **lines, int numlines, int isPopup, CPanel *panel, int menuChoice, int dualColumn, int colSpacing )
{

	int oldchoice = menuChoice ;
	static int iTime =0 ;
	int maxlines ;
	D3DXCOLOR d3color( 1.0, 1.0, 1.0, 0.5 ) ;

	maxlines = pmenuParams->maxNumLines ;

	if ( !isPopup )
	{
		//m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							//0x00000000, 0.0f, 0L );
		m_pd3dDevice->Clear(0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET, 0L, 1.0f, 0L);
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		if ( m_state == IN_GAME_PAUSED )
		{
			//DWORD holdTrans = pmenuParams->panel->m_colDiffuse ;
			//pmenuParams->panel->SetAlpha( (holdTrans>>24) / 2 ) ;
			pmenuParams->panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy );
			m_pnlGameScreen.SetAlpha( 0x80) ;
			m_pnlGameScreen.Render(m_gameRectSource.left,m_gameRectSource.top,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
			//m_pnlGameScreen.Render(0,0,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
			m_pnlGameScreen.SetAlpha( 0xFF) ;
			//Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
			//pmenuParams->panel->SetAlpha( (holdTrans>>24)  ) ;
		}
		else
		{
			pmenuParams->panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		}
		m_plaything.Render( 0, 0, 0 ) ;
	}
	else
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );
		//m_pd3dDevice->SetTexture( 0, NULL );
		//m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_DISABLE );
		//m_pd3dDevice->SetRenderState( D3DRS_ZENABLE, FALSE ); 
		//m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE ); 
	    //m_pd3dDevice->Clear( 0, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL, 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0x800000FF, 0x000000FF );

		if ( m_state == IN_GAME_PAUSED )
		{
			//DWORD holdTrans = panel->m_colDiffuse ;
			//panel->SetAlpha( (holdTrans>>24) / 2 ) ;
			panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
			m_pnlGameScreen.SetAlpha( 0x80) ;
			m_pnlGameScreen.Render(m_gameRectSource.left,m_gameRectSource.top,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
			//m_pnlGameScreen.Render(0,0,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
			m_pnlGameScreen.SetAlpha( 0xFF) ;
			//Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
			//panel->SetAlpha( (holdTrans>>24)  ) ;
		}
		else
		{
			panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		}

		//m_plaything.Render( 0, 0, 0 ) ;

		renderPopupBkg( maxlines && ( numlines > maxlines ) ?  maxlines : numlines ) ;

	}

	m_mp3player.process() ;

	if ( dualColumn )
	{
		renderDualMenuText( selectable, selected, lines, numlines, isPopup, colSpacing) ;
	}
	else
	{
		renderMenuText( selectable, selected, lines, numlines, isPopup ) ;
	}

	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


    XBInput_GetInput();



	if ( selectable )
	{
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			menuChoice = (menuChoice+1)%(numlines-1) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( menuChoice == 0 )
				menuChoice = numlines-2;
			else
				menuChoice-- ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;
				menuChoice = (menuChoice+1)%(numlines-1) ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;
				if ( menuChoice == 0 )
					menuChoice = numlines-2;
				else
					menuChoice-- ;
			}
		}

		if ( oldchoice != menuChoice )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
		}
	}
	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_LEFT_THUMB )
	{
		musicControlMenu( panel) ;
	}

	return menuChoice ;
}

int CXBoxSample::yesNoMenu( char *msg, CPanel *panel )
{
	int menuChoice = 1 ;
	int textheight ;
	int textwidth ;


	pmenuParams = &(m_skin.popupMenu) ;

	while ( 1 )
	{

		swprintf( m_menuText[0], L"%S", msg ) ;
		swprintf( m_menuText[1], L"Yes" ) ;
		swprintf( m_menuText[2], L"No" ) ;

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 3, 1, panel, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			return -1 ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			return menuChoice ;
		}


	}

	return -1 ;
}


void CXBoxSample::musicControlMenu( CPanel *panel )
{
	int menuChoice = 0 ;
	int textheight ;
	int textwidth ;
	MENU_PARAMS *oldparams ;

	oldparams = pmenuParams ;

	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		swprintf( m_menuText[0], L"Music Control Menu" ) ;
		swprintf( m_menuText[1], L"Pause/Unpause Music" ) ;
		swprintf( m_menuText[2], L"Go To Next Song" ) ;
		swprintf( m_menuText[3], L"Go To Previous Song" ) ;
		swprintf( m_menuText[4], L"Select New Song" ) ;
		swprintf( m_menuText[5], L"Music Directory - %S", m_defaultMusicDir ) ;
		swprintf( m_menuText[6], L"RThumb Left/Right - Adjust Volume" ) ;

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 7, 1, panel, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			changeMenu( &m_skin.otherMenu, oldparams) ;
			return  ;
		}
		else if ( g_Gamepads[0].fX2 > 0.30f )
		{
			m_mp3player.adjust_volume( 5 ) ;
		}
		else if ( g_Gamepads[0].fX2 < -0.30f )
		{
			m_mp3player.adjust_volume( -5 ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			switch ( menuChoice )
			{
				case 0 : 
				{
					m_playingMusic = !m_playingMusic ;
					m_mp3player.pause( !m_playingMusic ) ; 
					break ;
				}
				case 1 : 
				{
					m_mp3player.next() ;
					break ;
				}
				case 2 : 
				{
					m_mp3player.prev() ;
					break ;
				}
				case 3 : 
				{
					DWORD selectedGame ;
					char filename[500] ;
					char olddir[500] ;
					int oldcurr, oldtop ;

					strcpy(olddir, m_szCurrentDir ) ;
					if ( strlen( olddir ) && ( olddir[strlen(olddir)-1] != '\\' ) )
					{
						strcat( olddir, "\\" ) ;
					}
					strcat( olddir, "*" ) ;


					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;

					oldcurr = curr ;
					oldtop = topIdx ;

					FindAvailRoms( m_defaultMusicDir ) ;
					curr = 0 ;
					topIdx = 0 ;
					if ( ( selectedGame = doSelectGame( menuChoice==0, 1 ) ) != 0xFFFFFFFF ) 
					{
						strcpy((char*)filename, m_szCurrentDir ) ;
						strcat( (char*)filename, (const char*)files[selectedGame].filename ) ;
						if ( m_mp3player.loadFile( filename, 1, 0,9999999 ) )
						{
							//writexbox( "nonomp3\r\n") ;
						}
						else
						{
							//m_mp3player.insertSilence( 22050 ) ;
							m_mp3player.pause( FALSE ) ;
						}
					}
					FindAvailRoms( olddir ) ;
					curr = oldcurr ;
					topIdx = oldtop;
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu  ) ;
					
					break ;
				}
				case 4 : 
				{
					DWORD selectedGame ;

					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					if ( ( selectedGame = doSelectGame( 0,1,1 ) ) != 0xFFFFFFFF ) 
					{
						strcpy( m_defaultMusicDir, m_szCurrentDir ) ;
						if ( strlen( m_defaultMusicDir ) && ( m_defaultMusicDir[strlen(m_defaultMusicDir)-1] != '\\' ) )
						{
							strcat( m_defaultMusicDir, "\\" ) ;
						}
						strcat( m_defaultMusicDir, "*" ) ;

						doSaveIni() ;

					}
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ;
				}
				default : break ;
			}
		}


	}

	changeMenu( &m_skin.otherMenu, oldparams) ;
}


void CXBoxSample::popupMsg( char *msg, CPanel *panel, int onetime )
{
	int menuChoice = 1 ;
	int textheight ;
	int textwidth ;


	pmenuParams = &(m_skin.popupMenu) ;

	while ( 1 )
	{

		swprintf( m_menuText[0], L"%S", msg ) ;
		swprintf( m_menuText[1], L"" ) ;

		if ( onetime )
			swprintf( m_menuText[1], L"Press B to Cancel" ) ;
		else
			swprintf( m_menuText[1], L"Press B" ) ;

		menuChoice = renderMenuTextWrapper( 0, menuChoice, m_menuText, 2, 1, panel, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			return ; 
		}

		if ( onetime )
			return ;
	}

}


void CXBoxSample::doSelectSkin()
{
}

void CXBoxSample::doMainMenu()
{


	int menuChoice = 0 ;
	int menuoffset = 0 ;

	doTransition( &m_pnlSplashEmu, &m_pnlBackgroundMain, m_skin.fade, m_skin.transition ) ;

	DWORD starttime = GetTickCount() ;

	while ( starttime + m_skin.mainMenu.animationDelay > GetTickCount() )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_mp3player.process() ;
		m_skin.mainMenu.panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy );
		m_plaything.Render( 0, 0, 0 ) ;
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	}

	while ( 1 )
	{
		pmenuParams = &(m_skin.mainMenu) ;

		if ( g_autoLaunchGame )
		{
			m_bAutoLoaded = 0 ;
			m_bInCaptureMode = 0 ;
			emuLaunch( 0, 0, 0 ) ;
			g_autoLaunchGame = 0 ;
			//changeMenu( &m_skin.otherMenu, &m_skin.mainMenu ) ;
		}

#ifdef LAUNCHABLE_MEDIA
		swprintf( m_menuText[3], L"Launch Inserted CD" ) ;
		menuoffset = 1 ;
#endif
#ifdef GAMEBASE
		swprintf( m_menuText[3], L"GameBase64" ) ;
		menuoffset = 1 ;
#endif


		swprintf( m_menuText[0], MAIN_MENU_STRING ) ;
		swprintf( m_menuText[1], L"Select Game From Favorites" ) ;
		swprintf( m_menuText[2], L"Select Game" ) ;
		swprintf( m_menuText[3+menuoffset], L"Configure Game" ) ;
		swprintf( m_menuText[4+menuoffset], L"Add a Favorite" ) ;
		swprintf( m_menuText[5+menuoffset], L"Remove a Favorite" ) ;
		swprintf( m_menuText[6+menuoffset], L"Select Skin" ) ;
		swprintf( m_menuText[7+menuoffset], L"Save Game Management" ) ;
		swprintf( m_menuText[8+menuoffset], L"Browse Screenshots" ) ;
		swprintf( m_menuText[9+menuoffset], L"Music Control Menu" ) ;
		swprintf( m_menuText[10+menuoffset], L"Configuration" ) ;
		swprintf( m_menuText[11+menuoffset], L"Return to Launcher" ) ;
		//swprintf( m_menuText[10], L"Help" ) ;

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 12+menuoffset, 0, &m_pnlBackgroundMain, menuChoice, 0, 0 ) ;
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			if ( ( menuChoice == 0 ) || ( menuChoice == 1 ) )
			{

					unsigned int selectedGame ;

					if ( ( menuChoice==0 ) && ( m_numFavorites == 0 ) )
					{
					}
					else
					{

						changeMenu( &m_skin.mainMenu, &m_skin.gameSelectMenu ) ;


						while ( ( selectedGame = doSelectGame( menuChoice==0, 1 ) ) != 0xFFFFFFFF ) 
						{
							m_bAutoLoaded = 0 ;
							m_bInCaptureMode = 0 ;
							emuLaunch( selectedGame, menuChoice==0, 0 ) ;
						}

						changeMenu( &m_skin.gameSelectMenu, &m_skin.mainMenu ) ;
					}

			}
#ifdef LAUNCHABLE_MEDIA
			else if ( menuChoice == 2 )
			{
					m_bAutoLoaded = 0 ;
					m_bInCaptureMode = 0 ;
					doCDGame() ;
					changeMenu( &m_skin.otherMenu, &m_skin.mainMenu ) ;
			}
#endif
#ifdef GAMEBASE
			else if ( menuChoice == 2 )
			{
					m_bAutoLoaded = 0 ;
					m_bInCaptureMode = 0 ;
					changeMenu( &m_skin.mainMenu, &m_skin.otherMenu ) ;
					doGamebase64() ;
					changeMenu( &m_skin.otherMenu, &m_skin.mainMenu ) ;
			}
#endif
			else if ( menuChoice == 2+menuoffset )
			{
					unsigned int selectedGame ;
#ifndef NO_CONFIGURATION

					changeMenu( &m_skin.mainMenu, &m_skin.gameSelectMenu ) ;


					while ( ( selectedGame = doSelectGame( menuChoice==0, 1 ) ) != 0xFFFFFFFF ) 
					{
						char *p;

						strcpy( g_saveprefix, g_savePath ) ;
						strcat( g_saveprefix, "\\" ) ;
						strcat( g_saveprefix, (const char*)files[selectedGame].filename ) ;
						p = strchr(g_saveprefix, '.');
						if (p) *p = 0;

						strcpy(g_settingsfile, g_saveprefix);
						strcat(g_settingsfile, ".stg");

						strcpy(g_keysfile, g_saveprefix);
						strcat(g_keysfile, ".key");

						//changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
						//doConfigureGame( g_settingsfile, g_keysfile ) ;
						//changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;

						m_bAutoLoaded = 0 ;
						m_bInCaptureMode = 0 ;
						m_state = IN_GAME ;
						emuLaunch( selectedGame, 0, 1 ) ;
					}

					changeMenu( &m_skin.gameSelectMenu, &m_skin.mainMenu ) ;
#endif
			}
			else if ( menuChoice == 3+menuoffset )
			{

					unsigned int selectedGame ;

					changeMenu( &m_skin.mainMenu, &m_skin.gameSelectMenu ) ;


					while ( ( selectedGame = doSelectGame( menuChoice==0, 1 ) ) != 0xFFFFFFFF ) 
					{
						char cd_filename[MAX_PATH] ;

						strcpy((char*)cd_filename, m_szCurrentDir ) ;
						strcat( (char*)cd_filename, (const char*)files[curr].filename ) ;

						addFavorite( cd_filename ) ;
						saveFavorites() ;

						popupMsg( "File Added To Your Favorites List", &m_pnlBackgroundSelect ) ;

					}

					changeMenu( &m_skin.gameSelectMenu, &m_skin.mainMenu ) ;

			}
			else if ( menuChoice == 4+menuoffset )
			{
					unsigned int selectedGame ;

					if ( m_numFavorites )
					{

						changeMenu( &m_skin.mainMenu, &m_skin.gameSelectMenu ) ;

						while ( m_numFavorites && ( ( selectedGame = doSelectGame( 1,1 ) ) != 0xFFFFFFFF )  )
						{
							if ( yesNoMenu( "Remove this favorite?", &m_pnlBackgroundSelect ) == 0 )
							{
								removeFavorite( selectedGame ) ;
								saveFavorites() ;
							}
						}

						pmenuParams = &(m_skin.mainMenu) ;
						changeMenu( &m_skin.gameSelectMenu, &m_skin.mainMenu ) ;
					}

			}
			else if ( menuChoice == 5+menuoffset )
			{
					unsigned int selectedGame ;
					char szNewDir[MAX_PATH] ;

					sprintf( szNewDir, "%s\\*", m_szSkinDir  ) ;

					FindAvailRoms( szNewDir ) ;
					curr = 0 ;
					topIdx = 0 ;

					changeMenu( &m_skin.mainMenu, &m_skin.gameSelectMenu ) ;

					while ( ( selectedGame = doSelectGame( 0,0 ) ) != 0xFFFFFFFF ) 
					{
						if  ( files[selectedGame].isDir ) 
						{
							if ( selectedGame && ( yesNoMenu( "Switch to this skin?", &m_pnlBackgroundSelect ) == 0 ) )
							{
								doLoadSkin( (char*)files[selectedGame].filename, 1  ) ;
								doSaveIni() ;
								doSaveSkin() ;
								break ;
							}
							else
							{
							}
						}
						else
							break ;

					}


					pmenuParams = &(m_skin.mainMenu) ;
					FindAvailRoms(PLATFORM_FILE_DIR) ;
					curr = 0 ;
					topIdx = 0 ;

					changeMenu( &m_skin.gameSelectMenu, &m_skin.mainMenu ) ;

			}
			else if ( menuChoice == 6+menuoffset )
			{
					unsigned int selectedGame ;
					char szNewDir[MAX_PATH] ;

					sprintf( szNewDir, "%s\\*", g_savePath ) ;

					FindAvailRoms( szNewDir ) ;
					curr = 0 ;
					topIdx = 0 ;

					changeMenu( &m_skin.mainMenu, &m_skin.gameSelectMenu ) ;

					while ( ( selectedGame = doSelectGame( 0,0 ) ) != 0xFFFFFFFF ) 
					{
						if  ( files[selectedGame].isDir )
							break ;

						if ( yesNoMenu( "Delete this save file?", &m_pnlBackgroundSelect ) == 0 )
						{
							sprintf( szNewDir, "%s\\%s", g_savePath, files[selectedGame].filename ) ;
							DeleteFile( szNewDir ) ;
							sprintf( szNewDir, "%s\\*", g_savePath ) ;
							FindAvailRoms( szNewDir ) ;
							curr = 0 ;
							topIdx = 0 ;
						}

					}


					pmenuParams = &(m_skin.mainMenu) ;
					FindAvailRoms(PLATFORM_FILE_DIR) ;
					curr = 0 ;
					topIdx = 0 ;

					changeMenu( &m_skin.gameSelectMenu, &m_skin.mainMenu ) ;

			}
			else if ( menuChoice == 7+menuoffset )
			{
					changeMenu( &m_skin.mainMenu, &m_skin.gameSelectMenu ) ;
					doBrowseScreenshots() ;
					changeMenu( &m_skin.otherMenu, &m_skin.mainMenu ) ;
			}
			else if ( menuChoice == 8+menuoffset )
			{
				musicControlMenu( &m_pnlBackgroundMain ) ;
					//m_playingMusic = !m_playingMusic ;
					//m_mp3player.pause( !m_playingMusic ) ; 
			}
			else if ( menuChoice == 9+menuoffset )
			{
					changeMenu( &m_skin.mainMenu, &m_skin.otherMenu ) ;
					doConfiguration( ) ; 
					changeMenu( &m_skin.otherMenu, &m_skin.mainMenu ) ;
			}
			else if ( menuChoice == 10+menuoffset )
			{
				

					if ( yesNoMenu( "Do You Really Want To Quit?", &m_pnlBackgroundMain ) == 0 )
					{
						//HalInitiateShutdown() ;
/*
						
						CUSTOM_LAUNCH_DATA ldata ;


						memset( &ldata, 0, sizeof(CUSTOM_LAUNCH_DATA) ) ;

						ldata.magic = CUSTOM_LAUNCH_MAGIC ;  //Must set this to our magic number for recognition!

						strcpy( ldata.szFilename, "e:\\devkit\\dosxbox\\games\\blockade.com" );

						//This is *only* the XBE filename.  Do not include a path in this value.
						strcpy( ldata.szLaunchXBEOnExit, "dashboard.xbe" ) ;

						//This is what D:\ shall be mapped to when we launch the return XBE.
						//In this case, D:\ will be mapped to E:\DASHBOARDS
						strcpy( ldata.szRemap_D_As, "\\Device\\Harddisk0\\Partition1\\DASHBOARDS" ) ;


						//The following will launch E:\GAMES\PCSXBOX.XBE ( if "E:" is mapped to "\\Device\\Harddisk0\\Partition1" )
						XLaunchNewImageWithParams( "dosxbox.XBE", "\\Device\\Harddisk0\\Partition1\\devkit\\dosxbox", &ldata ) ;
*/						
						//CUSTOM_LAUNCH_DATA ldata ;


						//memset( &ldata, 0, sizeof(CUSTOM_LAUNCH_DATA) ) ;
						//XLaunchNewImageWithParams( "hugonew.XBE", "\\Device\\Harddisk0\\Partition1\\GAMES", &ldata ) ;
						XReturnToLaunchingXBE() ; 
					}
			}
		}


	}

}


void CXBoxSample::doBrowseScreenshots( )
{
	unsigned int selectedGame ;
	char szNewDir[MAX_PATH] ;
	FILE *infile ;
	DWORD width, height ;
	unsigned char ch ;
	int isValid ;
	int filesize ;
	CPanel paneldummy ;

	popupMsg( "Press Y while viewing screenshot to delete it.", &m_pnlBackgroundSelect ) ;

	CreateDirectory( m_screenshotDir, NULL ) ;

	sprintf( szNewDir, "%s\\%s", m_screenshotDir, PLATFORM_NAME ) ;

	CreateDirectory( szNewDir, NULL ) ;

	sprintf( szNewDir, "%s\\%s\\*", m_screenshotDir, PLATFORM_NAME ) ;

	FindAvailRoms( szNewDir ) ;
	curr = 0 ;
	topIdx = 0 ;

	while ( ( selectedGame = doSelectGame( 0,1 ) ) != 0xFFFFFFFF ) 
	{
		if  ( ! files[selectedGame].isDir ) 
		{
			CPanel panel ;
			LPDIRECT3DTEXTURE8	panelTexture ;

			sprintf( szNewDir, "%s%s", m_szCurrentDir, files[selectedGame].filename ) ;

			
			infile = fopen( szNewDir, "rb" ) ;

			if ( infile == NULL )
				continue ;

			width = 0 ;
			height = 0 ;

			fseek( infile, 0, SEEK_END ) ;
			filesize = ftell( infile ) ;

			if ( filesize == 0 )
			{
				if ( yesNoMenu( "This is an invalid, 0-length file.  Delete it?", &m_pnlBackgroundSelect ) == 0 )
				{
					fclose( infile ) ;
					DeleteFile( szNewDir ) ;
					sprintf( szNewDir, "%s*", m_szCurrentDir ) ;
					FindAvailRoms( szNewDir ) ;
					curr = 0 ;
					topIdx = 0 ;
					continue ;
				}
			}

			fseek( infile, 16, SEEK_SET ) ;

			fread( &ch, 1, 1, infile ) ;
			width += ch << 24 ;
			fread( &ch, 1, 1, infile ) ;
			width += ch << 16 ;
			fread( &ch, 1, 1, infile ) ;
			width += ch << 8 ;
			fread( &ch, 1, 1, infile ) ;
			width += ch  ;

			fread( &ch, 1, 1, infile ) ;
			height += ch << 24 ;
			fread( &ch, 1, 1, infile ) ;
			height += ch << 16 ;
			fread( &ch, 1, 1, infile ) ;
			height += ch << 8 ;
			fread( &ch, 1, 1, infile ) ;
			height += ch  ;

			fclose( infile ) ;


			isValid = 0 ;

			if (D3DXCreateTextureFromFileEx(m_pd3dDevice, szNewDir,
				 //width, height, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
				 D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
				 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &panelTexture)==D3D_OK)
			{
				isValid = 1 ;
				//if ( FAILED(panel.Create(m_pd3dDevice, panelTexture, FALSE, 0,0 ) ) )
				if ( FAILED(panel.Create(m_pd3dDevice, panelTexture, FALSE, width, height ) ) )
				{
				}
			}
			else
			{
				if ( yesNoMenu( "Cannot display file - probably corrupt. Delete it?", &m_pnlBackgroundSelect ) == 0 )
				{
					DeleteFile( szNewDir ) ;
					sprintf( szNewDir, "%s*", m_szCurrentDir ) ;
					FindAvailRoms( szNewDir ) ;
					curr = 0 ;
					topIdx = 0 ;
					continue ;
				}
			}
			


			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
								 0x00000000, 1.0f, 0L );
			//RenderGradientBackground( 0xFF000000, 0xFF000000 );

			

			//panel.Render( m_nScreenX*VIDEOMODES[m_xboxVidmode].multx, m_nScreenY*VIDEOMODES[m_xboxVidmode].multy, m_nScreenMaxX*VIDEOMODES[m_xboxVidmode].multx, m_nScreenMaxY*VIDEOMODES[m_xboxVidmode].multy ) ;
			panel.Render(0,0,width-1,height-1,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;

			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
								 0x00000000, 1.0f, 0L );
			//RenderGradientBackground( 0xFF000000, 0xFF000000 );
			//panel.Render( m_nScreenX*VIDEOMODES[m_xboxVidmode].multx, m_nScreenY*VIDEOMODES[m_xboxVidmode].multy, m_nScreenMaxX*VIDEOMODES[m_xboxVidmode].multx, m_nScreenMaxY*VIDEOMODES[m_xboxVidmode].multy ) ;
			panel.Render(0,0,width,height,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			XBInput_GetInput();

			while ( ! (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B]) ) 
			{
				m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
									 0x00000000, 1.0f, 0L );
				//RenderGradientBackground( 0xFF000000, 0xFF000000 );
				//panel.Render( m_nScreenX*VIDEOMODES[m_xboxVidmode].multx, m_nScreenY*VIDEOMODES[m_xboxVidmode].multy, m_nScreenMaxX*VIDEOMODES[m_xboxVidmode].multx, m_nScreenMaxY*VIDEOMODES[m_xboxVidmode].multy ) ;
				panel.Render(0,0,width,height,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
				m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
				m_mp3player.process() ;
				XBInput_GetInput();
				if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y]) ) 
				{
					if ( yesNoMenu( "Delete this screenshot?", &panel ) == 0 )
					{
						DeleteFile( szNewDir ) ;
						sprintf( szNewDir, "%s*", m_szCurrentDir ) ;
						FindAvailRoms( szNewDir ) ;
						curr = 0 ;
						topIdx = 0 ;
						break ;
					}
				}
			}


			if ( isValid )
				panelTexture->Release() ;
		}

	}


	FindAvailRoms(PLATFORM_FILE_DIR) ;
	curr = 0 ;
	topIdx = 0 ;
}


void CXBoxSample::getNewRoot( char *szRoot )
{


	int menuChoice = 0 ;


	pmenuParams = &(m_skin.gameSelectMenu) ;

	while ( 1 )
	{


		swprintf( m_menuText[0], L"" ) ;
		swprintf( m_menuText[1], L"C:\\" ) ;
		swprintf( m_menuText[2], L"D:\\" ) ;
		swprintf( m_menuText[3], L"E:\\" ) ;
		swprintf( m_menuText[4], L"F:\\" ) ;
		swprintf( m_menuText[5], L"G:\\" ) ;
		swprintf( m_menuText[6], L"R:\\" ) ;
		swprintf( m_menuText[7], L"X:\\" ) ;
		swprintf( m_menuText[8], L"Y:\\" ) ;
		swprintf( m_menuText[9], L"Z:\\" ) ;
		swprintf( m_menuText[10], L"SMB:\\" ) ;
		swprintf( m_menuText[11], L"RLX:\\" ) ;

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 12, 0, &m_pnlBackgroundSelect, menuChoice, 0, 0 ) ;



		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : strcpy( szRoot, "C:\\" ) ; break ;
				case 1 : strcpy( szRoot, "D:\\" ) ; break ;
				case 2 : strcpy( szRoot, "E:\\" ) ; break ;
				case 3 : strcpy( szRoot, "F:\\" ) ; break ;
				case 4 : strcpy( szRoot, "G:\\" ) ; break ;
				case 5 : strcpy( szRoot, "R:\\" ) ; break ;
				case 6 : strcpy( szRoot, "X:\\" ) ; break ;
				case 7 : strcpy( szRoot, "Y:\\" ) ; break ;
				case 8 : strcpy( szRoot, "Z:\\" ) ; break ;
				case 9 : strcpy( szRoot, "SMB:\\" ) ; break ;
				case 10 : strcpy( szRoot, "RLX:\\" ) ; break ;
				default : break ;
			}
			break ;
		}


	}

}
void doCubeTrans5( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{
	int alpha ;
	int which = rand()%2 ;
	float xrot, yrot, dir ;
	float numincr ;
	float numframes ;
	float numiter ;
	float timeperframe ;
	int rerror = 0 ;


	timeperframe = (1.0f/(float)g_app->m_d3dpp.FullScreen_RefreshRateInHz)*1000.0f ;
	numframes = (float)speed*256.0f / timeperframe ;
	numiter = 361.0f ;
	numincr = numiter / numframes ;
	
	
	for ( float i = 0 ; i < 180 ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );

		alpha = 255.0f*( 180.0f - (float)i)/180.0f ;

		rerror += pnl1->RenderOnCube2(320,240,640,480, 320,240, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0xFF, (float)i*0, (float)i, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;

		rerror += pnl1->RenderOnCube2(0,0,320,240, 0,0, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0xFF, (float)i, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;

		rerror += pnl1->RenderOnCube2(320,0,640,240, 320,0, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0xFF, (float)i*2, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		rerror += pnl1->RenderOnCube2(0,240,320,480, 0,240, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0xFF, (float)i*0, (float)i*2, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;

		if ( rerror )
			break ;
	}
	for ( int i = 180 ; i < 361 ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );

		alpha = 255.0f*( (float)i - 180.0f )/180.0f ;

		rerror += pnl2->RenderOnCube2(320,240,640,480, 320,240, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0xFF, (float)i*0, (float)i, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		rerror += pnl2->RenderOnCube2(0,0,320,240, 0,0, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0xFF, (float)i, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		rerror += pnl2->RenderOnCube2(320,0,640,240, 320,0, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0xFF, (float)i*2, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		rerror += pnl2->RenderOnCube2(0,240,320,480, 0,240, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0xFF, (float)i*0, (float)i*2, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;

		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;

		if ( rerror )
			break ;
	}
}

void doCubeTrans1( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{

	int alpha ;
	int which = rand()%2 ;
	float xrot, yrot, dir ;
	float numincr ;
	float numframes ;
	float numiter ;
	float timeperframe ;
	int rerror = 0 ;


	switch ( which )
	{
		case 0 :
		{
			xrot = 0 ;
			yrot = 1.0f ;
			dir = 1.0f ;
			break ;
		}
		default :
		case 1 :
		{
			xrot = 0 ;
			yrot = 1.0f ;
			dir = -1.0f ;
			break ;
		}
	}

	timeperframe = (1.0f/(float)g_app->m_d3dpp.FullScreen_RefreshRateInHz)*1000.0f ;
	numframes = (float)speed*256.0f / timeperframe ;
	numiter = 91.0f ;
	numincr = numiter / numframes ;

	for ( float i = 0 ; i < numiter ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );

		rerror += pnl1->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*xrot*dir, (float)i*yrot*dir, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;

		rerror += pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
			0xFE, (float)i*xrot*dir, (float)i*yrot*dir, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;

		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;

		if ( rerror )
			break ;
	}
}

void doCubeTrans2( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{

	int alpha ;
	int which = rand()%2 ;
	float xrot, yrot, dir ;
	float numincr ;
	float numframes ;
	float numiter ;
	float timeperframe ;
	int rerror = 0 ;


	xrot = 0 ;
	yrot = 1.0f ;
	dir = 1.0f ;

	timeperframe = (1.0f/(float)g_app->m_d3dpp.FullScreen_RefreshRateInHz)*1000.0f ;
	numframes = (float)speed*256.0f / timeperframe ;
	numiter = 91.0f ;
	numincr = numiter / numframes ;
	alpha = 0xFF ;

	for ( float i = 0 ; i < 45 ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );


		rerror += pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;

		rerror += pnl1->RenderOnCube2(0,0,320,240, 0,0, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		rerror += pnl1->RenderOnCube2(0,240,320,480, 0,240*VIDEOMODES[m_xboxVidmode].multy, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;

		rerror += pnl1->RenderOnCube2(320,240,640,480, 320*VIDEOMODES[m_xboxVidmode].multx,240*VIDEOMODES[m_xboxVidmode].multy, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*xrot, (float)i*yrot, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		rerror += pnl1->RenderOnCube2(320,0,640,240, 320*VIDEOMODES[m_xboxVidmode].multx,0, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*xrot, (float)i*yrot, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;


		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;

		if ( rerror )
			break ;
	}
	for ( float i = 45 ; i < 90 ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );

		rerror += pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;

		rerror += pnl1->RenderOnCube2(0,0,320,240, 0,0, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		rerror += pnl1->RenderOnCube2(0,240,320,480, 0,240*VIDEOMODES[m_xboxVidmode].multy, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;


		rerror += pnl2->RenderOnCube2(0,0,320,240, 0,0, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0x09, ((float)i+270)*xrot, ((float)i+270)*yrot, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		rerror += pnl2->RenderOnCube2(0,240,320,480, 0,240*VIDEOMODES[m_xboxVidmode].multy, 320*VIDEOMODES[m_xboxVidmode].multx, 240*VIDEOMODES[m_xboxVidmode].multy, 
			0x09, ((float)i+270)*xrot, ((float)i+270)*yrot, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
		


		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;

		if ( rerror )
			break ;
	}
}
typedef struct STRUCT_CUBEPOS
{
	float x,y,mx,my,rx,ry,rz ;
	int alpha ;
} cubepos ;

void doCubeTrans3( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{

	int alpha ;
	int which = rand()%2 ;
	float xrot, yrot, dir ;
	float mx, my ;
	float numincr ;
	float numframes ;
	float numiter ;
	float timeperframe ;
	float squares ;
	cubepos *arrpos ;
	int rerror = 0 ;


	xrot = 0 ;
	yrot = 1.0f ;
	dir = 1.0f ;

	squares = 10 ;

	timeperframe = (1.0f/(float)g_app->m_d3dpp.FullScreen_RefreshRateInHz)*1000.0f ;
	numframes = (float)speed*256.0f / timeperframe ;
	numiter = 180.0f ;
	numincr = numiter / numframes ;
	alpha = 0xFF ;

	arrpos = new cubepos[squares*squares] ;

	for ( int y = 0 ; y < squares ; y++ )
	{
		for ( int x = 0 ; x < squares ; x++ )
		{
			int r ;

			arrpos[(y*((int)squares)) + x].x = ((640/squares)*x)*VIDEOMODES[m_xboxVidmode].multx ;
			arrpos[(y*((int)squares)) + x].y = ((480/squares)*y)*VIDEOMODES[m_xboxVidmode].multy ;

			r = rand() - 16384;
			arrpos[(y*((int)squares)) + x].mx = (float)r/3276.0f;

			r = rand() - 16384;
			arrpos[(y*((int)squares)) + x].my = fabs((float)r/3276.0f);

			if ( x < squares/2 )
			{
				arrpos[(y*((int)squares)) + x].mx = -fabs(arrpos[(y*((int)squares)) + x].mx) ;
			}
			else
			{
				arrpos[(y*((int)squares)) + x].mx = fabs(arrpos[(y*((int)squares)) + x].mx) ;
			}


			if ( y < squares/2 )
			{
				arrpos[(y*((int)squares)) + x].my = -fabs(arrpos[(y*((int)squares)) + x].my) ;
			}
			else
			{
				arrpos[(y*((int)squares)) + x].my = fabs(arrpos[(y*((int)squares)) + x].my) ;
			}

			//arrpos[(y*((int)squares)) + x].mx = 0 ;
			//arrpos[(y*((int)squares)) + x].my = 0 ;


			r = rand() - 16384;
			arrpos[(y*((int)squares)) + x].rx = (float)r/16384.0f;

			r = rand() - 16384;
			arrpos[(y*((int)squares)) + x].ry = (float)r/16384.0f;

			r = rand() - 16384;
			arrpos[(y*((int)squares)) + x].rz = (float)r/16384.0f;


			arrpos[(y*((int)squares)) + x].rx = 0 ;
			arrpos[(y*((int)squares)) + x].ry = 0;
			arrpos[(y*((int)squares)) + x].rz = 0 ;


		}
	}

	for ( float i = 0 ; i < numiter ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );

		alpha = 255.0f*(numiter-i)/numiter;

		rerror += pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;

		if ( rerror )
			break ;

		for ( int y = 0 ; y < squares ; y++ )
		{
			for ( int x = 0 ; x < squares ; x++ )
			{
				rerror += pnl1->RenderOnCube2((640/squares)*x,(480/squares)*y,(640/squares)*(x+1),(480/squares)*(y+1), 
					arrpos[(y*((int)squares)) + x].x,
					arrpos[(y*((int)squares)) + x].y,
					640*VIDEOMODES[m_xboxVidmode].multx/squares, 480*VIDEOMODES[m_xboxVidmode].multy/squares,
					0x01, (float)i*arrpos[(y*((int)squares)) + x].rx, (float)i*arrpos[(y*((int)squares)) + x].ry, (float)i*arrpos[(y*((int)squares)) + x].rz, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;

				arrpos[(y*((int)squares)) + x].x += arrpos[(y*((int)squares)) + x].mx;
				arrpos[(y*((int)squares)) + x].y += arrpos[(y*((int)squares)) + x].my;

				if ( rerror )
					break ;
			}
			if ( rerror )
				break ;
		}

		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;
	}

	delete [] arrpos ;
}


void doCubeTrans4( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{

	int alpha ;
	int which = rand()%2 ;
	float xrot, yrot, dir ;
	float mx, my ;
	float numincr ;
	float numframes ;
	float numiter ;
	float timeperframe ;
	float squares ;
	cubepos *arrpos ;
	int rerror = 0 ;


	xrot = 0 ;
	yrot = 1.0f ;
	dir = 1.0f ;

	squares = 2 ;

	timeperframe = (1.0f/(float)g_app->m_d3dpp.FullScreen_RefreshRateInHz)*1000.0f ;
	numframes = (float)speed*256.0f / timeperframe ;
	numiter = 120.0f ;
	numincr = numiter / numframes ;
	alpha = 0xFF ;

	arrpos = new cubepos[squares*squares] ;

	for ( int y = 0 ; y < squares ; y++ )
	{
		for ( int x = 0 ; x < squares ; x++ )
		{
			int r ;
			float fx ;
			float fy ;

			arrpos[(y*((int)squares)) + x].x = ((640/squares)*x)*VIDEOMODES[m_xboxVidmode].multx ;
			arrpos[(y*((int)squares)) + x].y = ((480/squares)*y)*VIDEOMODES[m_xboxVidmode].multy ;

			fx = 320.0f*VIDEOMODES[m_xboxVidmode].multx / (numiter/numincr) ;
			fy = 240.0f*VIDEOMODES[m_xboxVidmode].multy / (numiter/numincr) ;

			if ( x < squares/2 )
			{
				arrpos[(y*((int)squares)) + x].mx = -fx;
			}
			else
			{
				arrpos[(y*((int)squares)) + x].mx = fx ;
			}


			if ( y < squares/2 )
			{
				arrpos[(y*((int)squares)) + x].my = -fy;
			}
			else
			{
				arrpos[(y*((int)squares)) + x].my = fy ;
			}

			//arrpos[(y*((int)squares)) + x].mx = 0 ;
			//arrpos[(y*((int)squares)) + x].my = 0 ;


			r = rand() - 16384;
			arrpos[(y*((int)squares)) + x].rx = (float)r/16384.0f;

			r = rand() - 16384;
			arrpos[(y*((int)squares)) + x].ry = (float)r/16384.0f;

			r = rand() - 16384;
			arrpos[(y*((int)squares)) + x].rz = (float)r/16384.0f;


			arrpos[(y*((int)squares)) + x].rx = 0 ;
			arrpos[(y*((int)squares)) + x].ry = 0;
			arrpos[(y*((int)squares)) + x].rz = 0 ;


		}
	}

	alpha = 0xFF ;

	for ( float i = 0 ; i < numiter ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );


		rerror += pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
			0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;

		if ( rerror )
			break ;

		for ( int y = 0 ; y < squares ; y++ )
		{
			for ( int x = 0 ; x < squares ; x++ )
			{
				rerror += pnl1->RenderOnCube2((640/squares)*x,(480/squares)*y,(640/squares)*(x+1),(480/squares)*(y+1), 
					arrpos[(y*((int)squares)) + x].x,
					arrpos[(y*((int)squares)) + x].y,
					640*VIDEOMODES[m_xboxVidmode].multx /squares, 480*VIDEOMODES[m_xboxVidmode].multy/squares,
					0x01, (float)i*arrpos[(y*((int)squares)) + x].rx, (float)i*arrpos[(y*((int)squares)) + x].ry, (float)i*arrpos[(y*((int)squares)) + x].rz, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;

				arrpos[(y*((int)squares)) + x].x += arrpos[(y*((int)squares)) + x].mx;
				arrpos[(y*((int)squares)) + x].y += arrpos[(y*((int)squares)) + x].my;
				if ( rerror )
					break ;
			}
			if ( rerror )
				break ;
		}

		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;
	}

	delete [] arrpos ;
}

void doCubeTrans6( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{

	int alpha ;
	int which = rand()%2 ;
	float xrot, yrot, dir ;
	float mx, my ;
	float numincr ;
	float numframes ;
	float numiter ;
	float timeperframe ;
	float squares ;
	cubepos *arrpos ;
	int rerror = 0 ;


	xrot = 0 ;
	yrot = 1.0f ;
	dir = 1.0f ;

	squares = 4 ;

	timeperframe = (1.0f/(float)g_app->m_d3dpp.FullScreen_RefreshRateInHz)*1000.0f ;
	numframes = (float)speed*256.0f / timeperframe ;
	numiter = 120.0f ;
	numincr = numiter / numframes ;
	alpha = 0xFF ;

	arrpos = new cubepos[squares*squares] ;

	for ( int y = 0 ; y < squares ; y++ )
	{
		for ( int x = 0 ; x < squares ; x++ )
		{

			arrpos[(y*((int)squares)) + x].x = ((640/squares)*x)*VIDEOMODES[m_xboxVidmode].multx ;
			arrpos[(y*((int)squares)) + x].y = ((480/squares)*y)*VIDEOMODES[m_xboxVidmode].multy ;


			arrpos[(y*((int)squares)) + x].mx = 0 ;
			arrpos[(y*((int)squares)) + x].my = 0 ;


			arrpos[(y*((int)squares)) + x].rx = 0 ;

			if ( x < squares/2 )
			{
				arrpos[(y*((int)squares)) + x].ry = 1.0f;
			}
			else
			{
				arrpos[(y*((int)squares)) + x].ry = -1.0f;
			}

			arrpos[(y*((int)squares)) + x].rz = 0 ;

			arrpos[(y*((int)squares)) + x].alpha = 255+y ;

			
		}
	}

	alpha = 0xFF ;

	for ( float i = 0 ; i < numiter/2 ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );


		//pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
			//0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;

		for ( int y = 0 ; y < squares ; y++ )
		{
			for ( int x = 0 ; x < squares ; x++ )
			{
				rerror += pnl1->RenderOnCube2((640/squares)*x,(480/squares)*y,(640/squares)*(x+1),(480/squares)*(y+1), 
					arrpos[(y*((int)squares)) + x].x,
					arrpos[(y*((int)squares)) + x].y,
					640*VIDEOMODES[m_xboxVidmode].multx /squares, 480*VIDEOMODES[m_xboxVidmode].multy/squares,
					0x01, (float)i*arrpos[(y*((int)squares)) + x].rx, (float)i*arrpos[(y*((int)squares)) + x].ry, (float)i*arrpos[(y*((int)squares)) + x].rz, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 255 ) ;

				if ( rerror )
					break ;
			}
			if ( rerror )
				break ;
		}

		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;
		if ( rerror )
			break ;
	}

	for ( float i = numiter/2 ; i > 0 ; i-=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );


		//pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
			//0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;

		for ( int y = 0 ; y < squares ; y++ )
		{
			for ( int x = 0 ; x < squares ; x++ )
			{
				rerror += pnl2->RenderOnCube2((640/squares)*x,(480/squares)*y,(640/squares)*(x+1),(480/squares)*(y+1), 
					arrpos[(y*((int)squares)) + x].x,
					arrpos[(y*((int)squares)) + x].y,
					640*VIDEOMODES[m_xboxVidmode].multx /squares, 480*VIDEOMODES[m_xboxVidmode].multy/squares,
					0x01, (float)i*arrpos[(y*((int)squares)) + x].rx, (float)i*arrpos[(y*((int)squares)) + x].ry, (float)i*arrpos[(y*((int)squares)) + x].rz, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 255 ) ;

				if ( rerror )
					break ;
			}
			if ( rerror )
				break ;
		}

		if ( rerror )
			break ;

		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;
	}


	delete [] arrpos ;
}




void doCubeTrans7( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{

	int alpha ;
	int which = rand()%4 ;
	float xrot, yrot, dir ;
	float mx, my ;
	float numincr ;
	float numframes ;
	float numiter ;
	float timeperframe ;
	float squares ;
	cubepos *arrpos ;
	int rerror = 0 ;


	xrot = 0 ;
	yrot = 1.0f ;
	dir = 1.0f ;

	squares = 2 ;

	timeperframe = (1.0f/(float)g_app->m_d3dpp.FullScreen_RefreshRateInHz)*1000.0f ;
	numframes = (float)speed*256.0f / timeperframe ;
	numiter = 120.0f ;
	numincr = numiter / numframes ;
	alpha = 0xFF ;

	arrpos = new cubepos[squares*squares] ;

	for ( int y = 0 ; y < squares ; y++ )
	{
		for ( int x = 0 ; x < squares ; x++ )
		{
			int r ;
			float fx ;
			float fy ;

			arrpos[(y*((int)squares)) + x].x = ((640/squares)*x)*VIDEOMODES[m_xboxVidmode].multx ;
			arrpos[(y*((int)squares)) + x].y = ((480/squares)*y)*VIDEOMODES[m_xboxVidmode].multy ;



			fx = 320.0f*VIDEOMODES[m_xboxVidmode].multx / (numiter/numincr) ;
			fy = 240.0f*VIDEOMODES[m_xboxVidmode].multy / (numiter/numincr) ;

			switch ( which )
			{
				case 0 :
				{
					if ( x < squares/2 )
					{
						arrpos[(y*((int)squares)) + x].mx = -fx;
					}
					else
					{
						arrpos[(y*((int)squares)) + x].mx = fx ;
					}
					arrpos[(y*((int)squares)) + x].my = 0;
					break ;
				}
				case 1 :
				{
					if ( y < squares/2 )
					{
						arrpos[(y*((int)squares)) + x].my = -fy;
					}
					else
					{
						arrpos[(y*((int)squares)) + x].my = fy ;
					}
					arrpos[(y*((int)squares)) + x].mx = 0;
					break ;
				}
				case 2 :
				{
					if ( x < squares/2 )
					{
						arrpos[(y*((int)squares)) + x].x -= 320*VIDEOMODES[m_xboxVidmode].multx ;
						arrpos[(y*((int)squares)) + x].mx = fx;
					}
					else
					{
						arrpos[(y*((int)squares)) + x].x += 320*VIDEOMODES[m_xboxVidmode].multx ;
						arrpos[(y*((int)squares)) + x].mx = -fx ;
					}
					arrpos[(y*((int)squares)) + x].my = 0;
					break ;
				}
				case 3 :
				default:
				{
					if ( y < squares/2 )
					{
						arrpos[(y*((int)squares)) + x].y -= 240*VIDEOMODES[m_xboxVidmode].multy ;
						arrpos[(y*((int)squares)) + x].my = fy;
					}
					else
					{
						arrpos[(y*((int)squares)) + x].y += 240*VIDEOMODES[m_xboxVidmode].multy ;
						arrpos[(y*((int)squares)) + x].my = -fy ;
					}
					arrpos[(y*((int)squares)) + x].mx = 0;
					break ;
				}
			}


			arrpos[(y*((int)squares)) + x].rx = 0 ;
			arrpos[(y*((int)squares)) + x].ry = 0;
			arrpos[(y*((int)squares)) + x].rz = 0 ;


		}
	}

	alpha = 0xFF ;

	for ( float i = 0 ; i < numiter ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );


		if ( which < 2 )
		{
			rerror += pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
				0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;
		}
		else
		{
			rerror += pnl1->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
				0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;
		}

		if ( rerror )
			break ;

		for ( int y = 0 ; y < squares ; y++ )
		{
			for ( int x = 0 ; x < squares ; x++ )
			{

				if ( which < 2 )
				{
					rerror += pnl1->RenderOnCube2((640/squares)*x,(480/squares)*y,(640/squares)*(x+1),(480/squares)*(y+1), 
						arrpos[(y*((int)squares)) + x].x,
						arrpos[(y*((int)squares)) + x].y,
						640*VIDEOMODES[m_xboxVidmode].multx /squares, 480*VIDEOMODES[m_xboxVidmode].multy/squares,
						0x01, (float)i*arrpos[(y*((int)squares)) + x].rx, (float)i*arrpos[(y*((int)squares)) + x].ry, (float)i*arrpos[(y*((int)squares)) + x].rz, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
				}
				else
				{
					rerror += pnl2->RenderOnCube2((640/squares)*x,(480/squares)*y,(640/squares)*(x+1),(480/squares)*(y+1), 
						arrpos[(y*((int)squares)) + x].x,
						arrpos[(y*((int)squares)) + x].y,
						640*VIDEOMODES[m_xboxVidmode].multx /squares, 480*VIDEOMODES[m_xboxVidmode].multy/squares,
						0x01, (float)i*arrpos[(y*((int)squares)) + x].rx, (float)i*arrpos[(y*((int)squares)) + x].ry, (float)i*arrpos[(y*((int)squares)) + x].rz, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, alpha ) ;
				}

				arrpos[(y*((int)squares)) + x].x += arrpos[(y*((int)squares)) + x].mx;
				arrpos[(y*((int)squares)) + x].y += arrpos[(y*((int)squares)) + x].my;

				if ( rerror )
					break ;
			}
			if ( rerror )
				break ;
		}

		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;
	}

	delete [] arrpos ;
}

void doCubeTrans8( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{

	int alpha ;
	int which = rand()%2 ;
	float xrot, yrot, dir ;
	float mx, my ;
	float numincr ;
	float numframes ;
	float numiter ;
	float timeperframe ;
	float squares ;
	float xpos, ypos ;
	float xlen, ylen ;
	cubepos *arrpos ;
	int rerror = 0 ;


	xrot = 0 ;
	yrot = 1.0f ;
	dir = 1.0f ;

	squares = 10 ;

	timeperframe = (1.0f/(float)g_app->m_d3dpp.FullScreen_RefreshRateInHz)*1000.0f ;
	numframes = (float)speed*256.0f / timeperframe ;
	numiter = 200.0f ;
	numincr = numiter / numframes ;
	alpha = 0xFF ;

	for ( float i = 0 ; i < numiter ; i+=numincr )
	{
		g_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );


		if ( which == 0 )
		{
			xpos = 320.0f*VIDEOMODES[m_xboxVidmode].multx - (320.0f*VIDEOMODES[m_xboxVidmode].multx*i/numiter) ;
			ypos = 240.0f*VIDEOMODES[m_xboxVidmode].multy - (240.0f*VIDEOMODES[m_xboxVidmode].multy*i/numiter) ;
		}
		else
		{
			xpos = (320.0f*VIDEOMODES[m_xboxVidmode].multx*i/numiter) ;
			ypos = (240.0f*VIDEOMODES[m_xboxVidmode].multy*i/numiter) ;
		}

		xlen = ( 320.0f*VIDEOMODES[m_xboxVidmode].multx  - xpos ) *2.0f ;
		ylen = ( 240.0f*VIDEOMODES[m_xboxVidmode].multy  - ypos ) *2.0f ;

		if ( which == 0 )
		{
			rerror += pnl1->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
				0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;
			rerror += pnl2->RenderOnCube2(0,0,640,480, xpos, ypos, xlen, ylen, 
				0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;
		}
		else
		{
			rerror += pnl2->RenderOnCube2(0,0,640,480, 0,0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 
				0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;
			rerror += pnl1->RenderOnCube2(0,0,640,480, xpos, ypos, xlen, ylen, 
				0x01, (float)i*0, (float)i*0, (float)i*0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy, 0xFF ) ;
		}

		if ( rerror )
			break ;

		g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;
	}

}

void doFadeTrans( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{
	DWORD fadetime ;
	DWORD fadeendtime ;
	DWORD origTrans1 ;
	DWORD origTrans2 ;
	int currTrans1 ;
	int currTrans2 ;
	int numiters ;
	int timeslice ;
	static int which = 0 ;
	int rerror = 0 ;


	currTrans1 = origTrans1 = ((pnl1->m_colDiffuse>>24)&0xFF) ;
	origTrans2 = ((pnl2->m_colDiffuse>>24)&0xFF) ;
	currTrans2 = 0 ;


	numiters = max( origTrans1, origTrans2 ) ;

	if ( numiters == 0 )
		numiters = 1 ;

	timeslice = (speed*256)/numiters  ;


	for ( int i = 0 ; i < numiters-1 ; i++ )
	{
		fadetime = GetTickCount() ;
		g_app->m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );


		pnl1->SetAlpha( max( currTrans1, 0  ) ) ;
		pnl2->SetAlpha( min( origTrans2, currTrans2 ) ) ;
		rerror += pnl1->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;
		rerror += pnl2->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;
		g_app->m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		g_app->m_mp3player.process() ;

		if ( rerror )
			break ;

		currTrans1-- ;
		currTrans2++ ;

		fadeendtime = GetTickCount() ;

		if ( fadeendtime - fadetime > timeslice )
		{
			i += ( ( fadeendtime - fadetime ) - timeslice ) / timeslice ;
			currTrans1 -= ( ( fadeendtime - fadetime ) - timeslice ) / timeslice ;
			currTrans2 += ( ( fadeendtime - fadetime ) - timeslice ) / timeslice ;
		}
		else
		{
			while ( GetTickCount() - fadetime < timeslice )
			{
				g_app->m_mp3player.process() ;
			}
		}

	}


	pnl1->SetAlpha( origTrans1 ) ;
	pnl2->SetAlpha( origTrans2 ) ;

	g_app->m_skin.mainMenu.panel->SetAlpha( g_app->m_skin.mainMenu.transparency )  ;
	g_app->m_skin.gameSelectMenu.panel->SetAlpha( g_app->m_skin.gameSelectMenu.transparency )  ;
	g_app->m_skin.popupMenu.panel->SetAlpha( g_app->m_skin.popupMenu.transparency )  ;
	g_app->m_skin.otherMenu.panel->SetAlpha( g_app->m_skin.otherMenu.transparency )  ;
	g_app->m_skin.loadingMenu.panel->SetAlpha( g_app->m_skin.loadingMenu.transparency )  ;
}

void CXBoxSample::doTransition( CPanel *pnl1, CPanel *pnl2, int speed, int effect ) 
{


	sprintfx( "dotransstart\r\n") ;

	if ( speed==0 )
	{
		sprintfx("speed0\r\n") ;
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		sprintfx("speed0\r\n") ;

		pnl2->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;
		sprintfx("speed0\r\n") ;
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		sprintfx("speed0\r\n") ;

		if ( pnl1->m_pFileBuf != NULL )
		{
			if ( pnl1->m_pTexture )
			{
				pnl1->m_pTexture->Release() ;
				pnl1->m_pTexture = NULL ;
			}
		}

		return ;
	}

	TRANSITION_EFFECTS[m_skin.transition%NUM_TRANSITION_EFFECTS].transfunc( pnl1, pnl2, speed, effect ) ;


	m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
						0x00000000, 1.0f, 0L );
	//RenderGradientBackground( 0xFF000000, 0xFF000000 );


	pnl2->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;
	m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

	if ( pnl1->m_pFileBuf != NULL )
	{
		if ( pnl1->m_pTexture )
		{
			pnl1->m_pTexture->Release() ;
			pnl1->m_pTexture = NULL ;
		}
	}
	sprintfx( "dotransend\r\n") ;

}

int getDirItemNumber( char *prefix, int itemnum, char *dest )
{
	char dir[MAX_PATH] ;
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	int curr ;

	sprintf( dir, "%s\\*.png", prefix ) ;

	//sprintfx( "looking for %s \r\n", prefix ) ;

	hFind = FindFirstFile( dir, &oFindData);

	if (hFind == INVALID_HANDLE_VALUE)
	{
		sprintf( dest, "%s\\blah", prefix ) ;
		return itemnum;
	}
	
	curr = 1 ;

	if ( itemnum == 0 )
	{
		while ( 1 ) 
		{

			if ( ! FindNextFile(hFind, &oFindData) )
			{
				FindClose( hFind );
				sprintf( dest, "%s\\%s", prefix, oFindData.cFileName ) ;
				//sprintf( dest, "%s\\blah", prefix ) ;
				return curr;
			}

			curr++ ;

		} 
	}
	else
	{
		while ( curr < itemnum ) 
		{

			if ( ! FindNextFile(hFind, &oFindData) )
			{
				FindClose( hFind );
				sprintf( dest, "%s\\blah", prefix ) ;
				return itemnum;
			}

			curr++ ;

		} 
	}

	FindClose( hFind );

	sprintf( dest, "%s\\%s", prefix, oFindData.cFileName ) ;

	return itemnum ;

}
#ifdef GAMEBASE
int CXBoxSample::showScreenshot( int screenNum, int currSelection, int onlyFavorites, MENU_PARAMS *menu, int isGamebase ) 
#else
int CXBoxSample::showScreenshot( int screenNum, int currSelection, int onlyFavorites, MENU_PARAMS *menu ) 
#endif
{
	char szNewDir[MAX_PATH] ;
	char szPrefix[MAX_PATH] ;
	char filename[500] ;
	static char lastPath[MAX_PATH] = { 0 } ;
	char shortpath[100] ;
	char *p;
	FILE *infile ;
	unsigned char ch ;
	int width ;
	int height ;
	int filesize ;
	static CPanel newpanel ;
	LPDIRECT3DTEXTURE8	panelTexture ;

	panelTexture = NULL ;

	if ( m_bRecreated )
	{
		newpanel.m_pd3dDevice = m_pd3dDevice ;
	}

	if ( screenNum <= 0 )
	{
		if ( screenNum == 0 )
			return 0 ;
		else 
			screenNum = 0 ;
	}

#ifdef GAMEBASE
	if ( !isGamebase )
	{
		if ( onlyFavorites )
		{
			strcpy( (char*)filename, m_filesFavorites[currSelection].filename ) ;
		}
		else
		{
			strcpy((char*)filename, m_szCurrentDir ) ;
			strcat( (char*)filename, (const char*)files[currSelection].filename ) ;
		}

		if ( strlen( strrchr( filename, '\\' )+1 ) > 42 )
		{
			strncpy( shortpath, strrchr( filename, '\\' )+1, 42 ) ;
			shortpath[42] = 0 ;

			p = strrchr( filename, '.' ) ;

			if ( p )
			{
				strcpy( shortpath+( 41 - strlen(p) ), p ) ;
			}
		}
		else
		{
			strcpy( shortpath, strrchr( filename, '\\' )+1 ) ;
		}


		while( strchr( shortpath, ',' ) )
			*strchr( shortpath, ',' ) = '_' ;


		char letter ;

		if ( isalpha(shortpath[0]) )
			letter = shortpath[0] ;
		else
			letter = '0' ;

		if ( onlyFavorites )
		{

			sprintf( szPrefix, "%s\\%s\\%c\\%s", m_screenshotDir, PLATFORM_NAME, letter, shortpath ) ;


			p = strrchr( szPrefix, '.' ) ;

			if ( p )
				*p = 0 ;


			sprintf( szNewDir, "%s\\%04.4u.png", szPrefix, screenNum ) ;

		}
		else
		{
			sprintf( szPrefix, "%s\\%s\\%c\\%s", m_screenshotDir, PLATFORM_NAME, letter, shortpath ) ;

			p = strrchr( szPrefix, '.' ) ;

			if ( p )
				*p = 0 ;


			sprintf( szNewDir, "%s\\%04.4u.png", szPrefix, screenNum ) ;

		}
	}
	else
	{
		char letter ;

		sprintf( (char*)filename, "%s\\%s", m_gamebasePath, m_gameBaseEntries[currSelection].filename ) ;
		strcpy( shortpath, strrchr( filename, '\\' )+1 ) ;


		while( strchr( shortpath, ',' ) )
			*strchr( shortpath, ',' ) = '_' ;

		if ( isalpha( shortpath[0] ) )
			letter = shortpath[0] ;
		else
			letter = '0' ;

		sprintf( szPrefix, "%s\\%s\\%c\\%s", m_screenshotDir, PLATFORM_NAME, letter, shortpath ) ;


		p = strrchr( szPrefix, '.' ) ;

		if ( p )
			*p = 0 ;


		sprintf( szNewDir, "%s\\%04.4u.png", szPrefix, screenNum ) ;
	}
#else
		if ( onlyFavorites )
		{
			strcpy( (char*)filename, m_filesFavorites[currSelection].filename ) ;
		}
		else
		{
			strcpy((char*)filename, m_szCurrentDir ) ;
			strcat( (char*)filename, (const char*)files[currSelection].filename ) ;
		}

		if ( strlen( strrchr( filename, '\\' )+1 ) > 42 )
		{
			strncpy( shortpath, strrchr( filename, '\\' )+1, 42 ) ;
			shortpath[42] = 0 ;

			p = strrchr( filename, '.' ) ;

			if ( p )
			{
				strcpy( shortpath+( 41 - strlen(p) ), p ) ;
			}
		}
		else
		{
			strcpy( shortpath, strrchr( filename, '\\' )+1 ) ;
		}


		while( strchr( shortpath, ',' ) )
			*strchr( shortpath, ',' ) = '_' ;


		if ( onlyFavorites )
		{

			sprintf( szPrefix, "%s\\%s\\%s", m_screenshotDir, PLATFORM_NAME, shortpath ) ;


			p = strrchr( szPrefix, '.' ) ;

			if ( p )
				*p = 0 ;


			sprintf( szNewDir, "%s\\%04.4u.png", szPrefix, screenNum ) ;

		}
		else
		{
			sprintf( szPrefix, "%s\\%s\\%s", m_screenshotDir, PLATFORM_NAME, shortpath ) ;

			p = strrchr( szPrefix, '.' ) ;

			if ( p )
				*p = 0 ;


			sprintf( szNewDir, "%s\\%04.4u.png", szPrefix, screenNum ) ;

		}
#endif



	screenNum = getDirItemNumber( szPrefix, screenNum, szNewDir ) ;

	if ( stricmp( szNewDir, lastPath ) == 0 )
	{
		newpanel.Render( menu->screenshotX*VIDEOMODES[m_xboxVidmode].multx, menu->screenshotY*VIDEOMODES[m_xboxVidmode].multy, menu->screenshotW*VIDEOMODES[m_xboxVidmode].multx, menu->screenshotH*VIDEOMODES[m_xboxVidmode].multy ) ;
		return screenNum ;
	}

	strcpy( lastPath, szNewDir ) ;

	infile = fopen( szNewDir, "rb" ) ;

	if ( infile == NULL )
	{
		lastPath[0] = 0 ;
		return 0 ;
	}

	width = 0 ;
	height = 0 ;


	fseek( infile, 0, SEEK_END ) ;
	filesize = ftell( infile ) ;

	if ( filesize == 0 )
	{
		if ( yesNoMenu( "Invalid 0-length screenshot file.  Delete it?", &m_pnlBackgroundSelect ) == 0 )
		{
			fclose( infile ) ;
			DeleteFile( szNewDir ) ;
		}
		lastPath[0] = 0 ;
		return 0  ;
	}



	fseek( infile, 16, SEEK_SET ) ;

	fread( &ch, 1, 1, infile ) ;
	width += ch << 24 ;
	fread( &ch, 1, 1, infile ) ;
	width += ch << 16 ;
	fread( &ch, 1, 1, infile ) ;
	width += ch << 8 ;
	fread( &ch, 1, 1, infile ) ;
	width += ch  ;

	fread( &ch, 1, 1, infile ) ;
	height += ch << 24 ;
	fread( &ch, 1, 1, infile ) ;
	height += ch << 16 ;
	fread( &ch, 1, 1, infile ) ;
	height += ch << 8 ;
	fread( &ch, 1, 1, infile ) ;
	height += ch  ;

	fclose( infile ) ;

	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, szNewDir,
		 //width, height, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
		 D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &panelTexture)==D3D_OK)
	{
		if ( FAILED(newpanel.Create(m_pd3dDevice, panelTexture, FALSE, width, height ) ) )
		//if ( FAILED(newpanel.Create(m_pd3dDevice, panelTexture, FALSE, 0,0 ) ) )
		{
			lastPath[0] = 0 ;
			return 0 ;
		}
	}
	else
	{
		if ( yesNoMenu( "Cannot display screenshot - probably corrupt. Delete it?", &m_pnlBackgroundSelect ) == 0 )
		{
			DeleteFile( szNewDir ) ;
		}
		lastPath[0] = 0 ;
		return 0 ;
	}


	newpanel.Render( menu->screenshotX*VIDEOMODES[m_xboxVidmode].multx, menu->screenshotY*VIDEOMODES[m_xboxVidmode].multy, menu->screenshotW*VIDEOMODES[m_xboxVidmode].multx, menu->screenshotH*VIDEOMODES[m_xboxVidmode].multy ) ;

	return screenNum ;

}

unsigned int CXBoxSample::doSelectGame( int onlyFavorites, int canChangeDir, int getPath ) 
{
	int numonscreen ;
	int iTime  ;
	unsigned int retval ;
	unsigned int currSelection ;
	unsigned int oldselection ;
	unsigned int currTopIdx ;
	unsigned int totNumFiles ;
	int screenNum ;
	int didChangeScreen ;

	retval = 0xFFFFFFFF ;
	screenNum = m_defaultScreenshots ? 1 : 0 ;
	didChangeScreen = 0 ;


	iTime = 0 ;

	if ( onlyFavorites )
	{
		currSelection = 0 ;
		currTopIdx = 0 ;
		totNumFiles = m_numFavorites ;
	}
	else
	{
		currSelection = curr ;
		currTopIdx = topIdx ;
		totNumFiles = numfiles ;
	}

	if ( getPath )
	{
		popupMsg( "Change to the directory and press START", &m_pnlBackgroundSelect ) ;
	}

	oldselection = currSelection ;


	while ( 1 )
	{
		pmenuParams = &(m_skin.gameSelectMenu) ;

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		m_plaything.Render( 0,0,0 ) ;

		screenNum = showScreenshot( screenNum, currSelection, onlyFavorites, pmenuParams ) ;

		m_mp3player.process() ;




		numonscreen = 0 ;
		swprintf( m_menuText[0], L"LThumb Left/Right For Screenshots" ) ;

		for ( unsigned int idx = currTopIdx ; ( idx < totNumFiles ) && ( idx < currTopIdx+pmenuParams->maxNumLines) ; idx++ )
		{
			if ( onlyFavorites )
			{
				if ( m_seeFavoritesPath )
				{
					swprintf( m_menuText[idx-currTopIdx+1], L"%S", m_filesFavorites[idx].filename ) ;
				}
				else
				{
					if ( strrchr( m_filesFavorites[idx].filename, '\\' ) )
					{
						swprintf( m_menuText[idx-currTopIdx+1], L"%S", strrchr( m_filesFavorites[idx].filename, '\\' )+1 ) ;
					}
					else
					{
						swprintf( m_menuText[idx-currTopIdx+1], L"%S", m_filesFavorites[idx].filename ) ;
					}
				}
			}
			else
			{
				swprintf( m_menuText[idx-currTopIdx+1], L"%s", files[idx].name ) ;
			}
			numonscreen++ ;
		}
		
		
		renderMenuText( 1, currSelection-currTopIdx, m_menuText, numonscreen+1, 0 ) ;
		
		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
	        XBInput_GetInput();
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( currSelection == currTopIdx + (pmenuParams->maxNumLines-1) )
			{
				if ( currSelection+1 < totNumFiles  )
				{
					currTopIdx++ ;
					currSelection++ ;
				}
			}
			else
			{
				if ( currSelection+1 < totNumFiles )
					currSelection++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( currSelection == currTopIdx )
			{
				if ( currSelection > 0 )
				{
					currTopIdx-- ;
					currSelection-- ;
				}
			}
			else
			{
				if ( currSelection > 0 )
					currSelection-- ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			char c ;
			int lcv ;

			if ( onlyFavorites )
			{
				c = tolower( *(strrchr( m_filesFavorites[currSelection].filename, '\\')+1)) ;

				lcv = currSelection ;

				while ( ( lcv < totNumFiles ) && ( tolower(*(strrchr( m_filesFavorites[lcv].filename, '\\')+1)) <= c ) )
					lcv++ ;

				if ( lcv < totNumFiles )
				{
					currTopIdx = lcv ;
					currSelection = lcv ;
				}
				else
				{
					currTopIdx = totNumFiles - 1 ;
					currSelection = totNumFiles - 1 ;
				}

				
			}
			else
			{
				c = tolower(files[currSelection].filename[0]) ;

				lcv = currSelection ;

				while ( ( lcv < totNumFiles ) && ( tolower(files[lcv].filename[0]) <= c ) )
					lcv++ ;

				if ( lcv < totNumFiles )
				{
					currTopIdx = lcv ;
					currSelection = lcv ;
				}
				else
				{
					currTopIdx = totNumFiles - 1 ;
					currSelection = totNumFiles - 1 ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			char c ;
			int lcv ;

			if ( onlyFavorites )
			{
				c = tolower( *(strrchr( m_filesFavorites[currSelection].filename, '\\')+1)) ;

				lcv = currSelection ;

				while ( ( lcv >= 0 ) && ( tolower(*(strrchr( m_filesFavorites[lcv].filename, '\\')+1)) >= c ) )
					lcv-- ;

				if ( lcv >= 0  )
				{
					currTopIdx = lcv ;
					currSelection = lcv ;
				}
				else
				{
					currTopIdx = 0 ;
					currSelection =  0;
				}

				
			}
			else
			{
				c = tolower(files[currSelection].filename[0]) ;

				lcv = currSelection ;

				while ( ( lcv >= 0 ) && ( tolower(files[lcv].filename[0]) >= c ) )
					lcv-- ;

				if ( lcv >= 0 )
				{
					currTopIdx = lcv ;
					currSelection = lcv ;
				}
				else
				{
					currTopIdx = 0 ;
					currSelection = 0 ;
				}
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER];

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;
				if ( currSelection == currTopIdx + (pmenuParams->maxNumLines-1) )
				{
					if ( currSelection < totNumFiles - 1 )
					{
						currTopIdx++ ;
						currSelection++ ;
					}
				}
				else
				{
					if ( currSelection < totNumFiles-1 )
						currSelection++ ;
				}
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;
				if ( currSelection == currTopIdx )
				{
					if ( currSelection > 0 )
					{
						currTopIdx-- ;
						currSelection-- ;
					}
				}
				else
				{
					if ( currSelection > 0 )
						currSelection-- ;
				}
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			if ( onlyFavorites )
			{
				retval = currSelection ;
				break ;
			}
			else
			{
				if ( files[currSelection].isDir )
				{
					if ( canChangeDir )
					{
						numfiles = 0 ;

						char tmpdir[MAX_PATH] ;
						char *p ;

						if ( currSelection )
							sprintf( tmpdir, "%s%s\\*", m_szCurrentDir, (char*)files[currSelection].filename ) ;
						else
						{
							strcpy( tmpdir, m_szCurrentDir ) ;

							p = strrchr( tmpdir, '\\' ) ;
							if ( p )
								*p = 0 ;
							p = strrchr( tmpdir, '\\' ) ;
							if ( p )
								*p = 0 ;
							strcat( tmpdir, "\\" ) ;

							if ( strcmp( tmpdir, m_szCurrentDir ) == 0 )
							{
								getNewRoot( tmpdir )  ;
							}

							strcat( tmpdir, "*" ) ;
						}

						FindAvailRoms( tmpdir ) ;
						currSelection = 0 ;
						currTopIdx = 0 ;
						totNumFiles = numfiles ;
					}
					else
					{
						retval = currSelection ;
						break ;
					}
				}
				else
				{
					retval = currSelection ;
					break ;
				}
			}

		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			currSelection = 0 ;

			if ( (!onlyFavorites) && ( files[currSelection].isDir && canChangeDir ) )
			{
				if ( files[currSelection].isDir )
				{
					if ( canChangeDir )
					{
						numfiles = 0 ;

						char tmpdir[MAX_PATH] ;
						char *p ;

						if ( currSelection )
							sprintf( tmpdir, "%s%s\\*", m_szCurrentDir, (char*)files[currSelection].filename ) ;
						else
						{
							strcpy( tmpdir, m_szCurrentDir ) ;

							p = strrchr( tmpdir, '\\' ) ;
							if ( p )
								*p = 0 ;
							p = strrchr( tmpdir, '\\' ) ;
							if ( p )
								*p = 0 ;
							strcat( tmpdir, "\\" ) ;

							if ( strcmp( tmpdir, m_szCurrentDir ) == 0 )
							{
								getNewRoot( tmpdir )  ;
							}

							strcat( tmpdir, "*" ) ;
						}

						FindAvailRoms( tmpdir ) ;
						currSelection = 0 ;
						currTopIdx = 0 ;
						totNumFiles = numfiles ;
					}
					else
					{
						retval = currSelection ;
						break ;
					}
				}
				else
				{
					retval = currSelection ;
					break ;
				}
			}

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_LEFT_THUMB )
		{
			musicControlMenu( pmenuParams->panel) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_START )
		{
			if ( getPath )
			{
				retval = currSelection ;
				break ;
			}
		}

		if ( g_Gamepads[0].hDevice && ( g_Gamepads[0].fX1 > 0.30f ) ) 
		{
			if ( !didChangeScreen )
			{
				screenNum++ ;
				didChangeScreen = 1 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && ( g_Gamepads[0].fX1 < -0.30f ) ) 
		{
			if ( !didChangeScreen )
			{
				screenNum-- ;
				didChangeScreen = 1 ;
			}
		}
		else
		{
			didChangeScreen = 0 ;
		}

		if ( oldselection != currSelection )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			screenNum = m_defaultScreenshots ? 1  : 0;
		}

		oldselection = currSelection ;
	}


	if ( !onlyFavorites )
	{
		curr = currSelection ;
		topIdx = currTopIdx ;
	}

	return retval ;
}

int favCompare (const void * elem1, const void * elem2 )
{
	FAVORITE *fav1, *fav2 ;
	char *pos1, *pos2 ;

	fav1 = (FAVORITE*)elem1 ;
	fav2 = (FAVORITE*)elem2 ;

	pos1 = strrchr( fav1->filename, '\\' ) ;

	if ( pos1 == NULL )
		pos1 = fav1->filename ;
	else
		pos1++ ;

	pos2 = strrchr( fav2->filename, '\\' ) ;

	if ( pos2 == NULL )
		pos2 = fav2->filename ;
	else
		pos2++ ;

	return stricmp( pos1, pos2 ) ;
}


void vblankCallback(D3DVBLANKDATA *pData)
{/*
	if ( g_app->m_state == IN_GAME ) 
	{
		while ( ! g_app->m_bOKToDraw ) 
			;
		g_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
		g_app->m_pnlGameScreen.Render(0,0,g_app->m_gameRectSource.right,g_app->m_gameRectSource.bottom,g_app->m_nScreenX ,g_app->m_nScreenY, g_app->m_nScreenMaxX, g_app->m_nScreenMaxY) ;
		g_pd3dDevice->Present(NULL, NULL, NULL, NULL);

	}*/
}


void CXBoxSample::addFavorite( char *favorite )
{

	for ( int i = 0 ; i < m_numFavorites ; i++ )
	{
		if ( stricmp( favorite, m_filesFavorites[i].filename ) == 0 )
			return ;
	}

	m_filesFavorites = (FAVORITE*)realloc( m_filesFavorites, sizeof(FAVORITE) * ( m_numFavorites  + 1 ) ) ;
	strcpy( m_filesFavorites[m_numFavorites].filename, favorite ) ;
	m_numFavorites++ ;

	qsort( m_filesFavorites, m_numFavorites, sizeof(FAVORITE), favCompare ) ;

}

void CXBoxSample::removeFavorite( unsigned int selected )
{

	FAVORITE *tempbuf ;

	if ( selected >= m_numFavorites )
		return ;

	tempbuf = (FAVORITE*)malloc( sizeof(FAVORITE) * ( m_numFavorites - 1 ) ) ;

	memcpy( tempbuf, m_filesFavorites, sizeof(FAVORITE) * selected ) ;

	if ( selected < m_numFavorites-1 )
	{
		memcpy( &(tempbuf[selected]), &(m_filesFavorites[selected+1]), sizeof(FAVORITE) * ( (m_numFavorites - selected ) - 1) ) ;
	}

	free( m_filesFavorites ) ;

	m_filesFavorites = tempbuf ;
	m_numFavorites-- ;


}

void CXBoxSample::doSaveIni() 
{
	char inifile[MAX_PATH] ;
	FILE *infile ;
	int filesize ;
	char *szbuf ;

	szbuf = NULL ;

	sprintf( inifile, "%s\\%s", DEFAULT_SAVE_PATH, PLATFORM_INI ) ;
	infile = fopen( inifile, "wb" ) ;

	if ( !infile )
		return ;



	fprintf( infile, "[GENERAL]\r\n" ) ;
	fprintf( infile, "text_offset_x=%d\r\n", m_nXOffset ) ;
	fprintf( infile, "text_offset_y=%d\r\n", m_nYOffset ) ;
	fprintf( infile, "screenx=%u\r\n", m_nScreenX ) ;
	fprintf( infile, "screeny=%u\r\n", m_nScreenY ) ;
	fprintf( infile, "screenmaxx=%u\r\n", m_nScreenMaxX ) ;
	fprintf( infile, "screenmaxy=%u\r\n", m_nScreenMaxY ) ;
	fprintf( infile, "scroll_speed=%u\r\n", m_scrollSpeed ) ;
	fprintf( infile, "skin=%s\r\n", m_szSkin ) ;
	fprintf( infile, "skin_dir=%s\r\n", m_szSkinDir ) ;

	char *p = strrchr( m_defaultRomDir, '\\' ) ;

	if ( p )
	{
		*p = 0 ;
	}

	fprintf( infile, "rom_dir=%s\r\n", m_defaultRomDir ) ;

	if ( p )
	{
		*p = '\\' ;
	}


	p = strrchr( m_defaultMusicDir, '\\' ) ;

	if ( p )
	{
		*p = 0 ;
	}

	fprintf( infile, "music_dir=%s\r\n", m_defaultMusicDir ) ;

	if ( p )
	{
		*p = '\\' ;
	}


	fprintf( infile, "LOCAL_IP=%s\r\n", g_szLocalAddress) ;
	fprintf( infile, "SUBNET_MASK=%s\r\n", g_szLocalSubnet) ;
	fprintf( infile, "GATEWAY_IP=%s\r\n", g_szLocalGateway) ;

	fprintf( infile, "smbshare=%s\r\n", m_smbShare ) ;
	fprintf( infile, "smb_nameserver=%s\r\n", m_smbNameServer ) ;
	fprintf( infile, "rlxshare=%s\r\n", m_rlxShare ) ;
	fprintf( infile, "favorites_see_path=%u\r\n", m_seeFavoritesPath  ) ;
	fprintf( infile, "software_filter=%u\r\n", m_xboxSFilter  ) ;
	fprintf( infile, "hardware_filter=%u\r\n", m_xboxHFilter  ) ;
	//fprintf( infile, "video_mode=%u\r\n", m_xboxVidmode  ) ;
	fprintf( infile, "screenshot_dir=%s\r\n", m_screenshotDir ) ;
	fprintf( infile, "save_dir=%s\r\n", m_szUserSavePath ) ;
	fprintf( infile, "show_screenshots=%u\r\n", m_defaultScreenshots ) ;
	fprintf( infile, "bgm_in_game=%u\r\n", m_bBgmInGame ) ;
	fprintf( infile, "auto_load_save_state=%u\r\n", m_bAutoLoadSaveState ) ;
	fprintf( infile, "capture_speed=%u\r\n", m_captureSpeed ) ;
	fprintf( infile, "throttle_speed=%u\r\n", m_throttleSpeed ) ;

	for ( int i = 0 ; i < 32 ; i++ )
	{
		fprintf( infile, "netplay_server%u=%s\r\n", i+1, m_netplayServers[i].ip ) ;
	}
	
	
	fprintf( infile, "\r\n" ) ;


	saveControllerSettings( infile ) ;

	doSaveEmuSpecificIni( infile ) ;

	fclose( infile ) ;

}


void CXBoxSample::doSaveConfig()
{
	/*
	FILE *inifile ;
	char tmpfilename[MAX_PATH] ;

	strcpy( tmpfilename, g_savePath ) ;
	strcat( tmpfilename, PLATFORM_INI ) ;

	inifile = fopen( tmpfilename, "wb" ) ;

	if ( inifile != NULL )
	{
		fprintf( inifile, "%u %u %u %u %u %u  \r\n", m_nXOffset, m_nFontHeight, m_nScreenX, m_nScreenY, m_nScreenMaxX, m_nScreenMaxY ) ;
		fclose( inifile ) ;
	}
*/
}

void CXBoxSample::doNetplayOptions()
{
	int menuChoice = 0 ;
	int whichServer = 0 ;
	int changeNetwork = 0 ;



	while ( 1 )
	{

		swprintf( m_menuText[0], L"Netplay Options" );
		swprintf( m_menuText[1], L"Netplay is %S", m_bNetplay ? "ON" : "OFF" );
		swprintf( m_menuText[2], L"Add Netplay Server");
		swprintf( m_menuText[3], L"Remove Netplay Server");
		swprintf( m_menuText[4], L"Enter Samba Share Name");
		swprintf( m_menuText[5], L"Enter Samba Nameserver");
		swprintf( m_menuText[6], L"Enter Relax Share Name");
		swprintf( m_menuText[7], L"Enter XBox IP Address");
		swprintf( m_menuText[8], L"Enter Subnet Mask");
		swprintf( m_menuText[9], L"Enter Gateway IP Address");

		pmenuParams = &(m_skin.otherMenu) ;

		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 10, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : m_bNetplay = !m_bNetplay ; break ;
				case 1 : addNewNetplayServer() ; break ;
				case 2 : 
				{
					whichServer = selectNetplayServer() ;

					if ( whichServer >= 0 )
					{
						for ( int i = whichServer ; i < 31 ; i++ )
						{
							strcpy( m_netplayServers[i].ip, m_netplayServers[i+1].ip ) ;

						}
						m_netplayServers[31].ip[0] = 0 ;
					}

					break ;
				}
				case 3 :
				{
					getKeyboardString( m_smbShare, 500 ) ;


					g_smbUsername = NULL ;
					g_smbPassword = NULL ;
					m_smbUtil.parse( m_smbShare, 0 ) ;

					g_smbPassword = m_smbUtil.password() ;
					g_smbUsername = m_smbUtil.user() ;


					break ;
				}
				case 4 :
				{
					getKeyboardString( m_smbNameServer, 500 ) ;

					if ( m_smbNameServer[0] )
						m_smb.setNBNSAddress( m_smbNameServer ) ;

					break ;
				}
				case 5 :
				{
					getKeyboardString( m_rlxShare, 500 ) ;

					if ( ! m_relax.Initialize( m_rlxShare ) )
					{
						sprintfx( "no init main relax\r\n") ;
					}

					if ( ! m_mp3player.m_relax.Initialize( m_rlxShare ) )
					{
						sprintfx( "no init mp3 relax\r\n") ;
					}

					break ;
				}
				case 6 :
				{
					getKeyboardString( g_szLocalAddress, 200 ) ;
					changeNetwork = 1 ;
					break ;
				}
				case 7 :
				{
					getKeyboardString( g_szLocalSubnet, 200 ) ;
					changeNetwork = 1 ;
					break ;
				}
				case 8 :
				{
					getKeyboardString( g_szLocalGateway, 200 ) ;
					changeNetwork = 1 ;
					break ;
				}
				default : break ;
			}
		}


	}


	if ( changeNetwork )
		InitializeNetwork() ;
}

void CXBoxSample::doConfiguration()
{


	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Configuration" );
		swprintf( m_menuText[1], L"Move menu text up/down/left/right");
		swprintf( m_menuText[2], L"Set Game Screen Size/Position");
		swprintf( m_menuText[3], L"Menu Scroll Speed");
		swprintf( m_menuText[4], L"Configure Controllers");
		swprintf( m_menuText[5], L"Force Reload D:\\*.ini Settings");
		swprintf( m_menuText[6], L"Overwrite D:\\*.ini and D:\\emuskins\\<skin>\\settings.ini");
		swprintf( m_menuText[7], L"Configure Skin");
		swprintf( m_menuText[8], L"Network/Netplay Options");
		swprintf( m_menuText[9], L"Video Configuration");
		swprintf( m_menuText[10], L"Show Screenshots? %S", m_defaultScreenshots ? "Yes" : "No" );
		swprintf( m_menuText[11], L"Show Full Favorites Path? %S", m_seeFavoritesPath ? "Yes" : "No" );
		swprintf( m_menuText[12], L"Stop BGM Before Playing Game? %S", m_bBgmInGame ? "No" : "Yes" );
		swprintf( m_menuText[13], L"Auto-Load Most Recent Save State? %S", m_bAutoLoadSaveState ? "Yes" : "No" );
		swprintf( m_menuText[14], L"Auto-Screenshot Capture Delay %u", m_captureSpeed );
		swprintf( m_menuText[15], L"Throttle/Fast Forward Speed %u", m_throttleSpeed );
		swprintf( m_menuText[16], L"Change Default Directories");
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 17, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : doTextOffset() ; break ;
				case 1 : doScreenSize() ; break ;
				case 2 : m_scrollSpeed = getValuePopup( "Select New Scroll Speed", m_scrollSpeed, 1, 30, &m_pnlBackgroundOther ) ; break ;
				case 3 : doConfigureControllers() ; break ;
				case 4 : 
				{
					if ( m_state != IN_GAME_PAUSED )
					{
						if ( yesNoMenu( "Do you really want to overwrite current settings?", &m_pnlBackgroundOther ) == 0 )
						{
							doLoadIni( 1 ) ;
							doLoadSkin( m_szSkin, 0 ) ; 
							doSaveIni() ;
							doSaveSkin() ;
						}
					}
					break ; 
				}
				case 5 : 
				{
					if ( m_state != IN_GAME_PAUSED )
					{
						if ( yesNoMenu( "Do you really want to overwrite default settings on D:\\ ?", &m_pnlBackgroundOther ) == 0 )
						{
							doSaveIni() ;
							doSaveSkin() ;

							char szOld[MAX_PATH] ;
							char szNew[MAX_PATH] ;

							sprintf( szNew, "D:\\%s", PLATFORM_INI ) ;
							sprintf( szOld, "%s\\%s", DEFAULT_SAVE_PATH, PLATFORM_INI ) ;

							CopyFile( szOld, szNew, FALSE ) ;

							sprintf( szNew, "%s\\%s\\settings.ini", m_szSkinDir, m_szSkin ) ;
							sprintf( szOld, "%s\\skin_settings.ini", DEFAULT_SAVE_PATH, PLATFORM_INI ) ;

							CopyFile( szOld, szNew, FALSE ) ;

						}
					}
					break ; 
				}
				case 6 : 
				{
					if ( m_state != IN_GAME_PAUSED )
						doConfigureSkin() ; 
					break ; 
				}
				case 7 :
				{
					doNetplayOptions() ;
					break ; 
				}
				case 8 : doGraphicsFiltering() ; break ;
				case 9 : m_defaultScreenshots = !m_defaultScreenshots ; break ;
				case 10 : m_seeFavoritesPath = !m_seeFavoritesPath ; break ;
				case 11 : m_bBgmInGame = ! m_bBgmInGame ; break ;
				case 12 : m_bAutoLoadSaveState = ! m_bAutoLoadSaveState ; break ;
				case 13 : m_captureSpeed = getValuePopup( "Auto-Screenshot Capture Delay", m_captureSpeed, 1, 255, &m_pnlBackgroundOther ) ; break ;
				case 14 : m_throttleSpeed = getValuePopup( "Throttle/Fast Forward Speed", m_throttleSpeed, 1, 255, &m_pnlBackgroundOther ) ; break ;
				case 15 : 
				{
					doDefaultDirs() ;
					break ;
				}
				default : break ;
			}
		}


	}

	doSaveIni() ;

}


void CXBoxSample::doDefaultDirs()
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Change Default Directories" );
		swprintf( m_menuText[1], L"ROM Directory - %S", m_defaultRomDir);
		swprintf( m_menuText[2], L"Screenshot Directory - %S", m_screenshotDir);
		swprintf( m_menuText[3], L"Save Game Directory - %S", m_szUserSavePath);
		swprintf( m_menuText[4], L"Skin Directory - %S", m_szSkinDir);
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 5, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				{
					DWORD selectedGame ;

					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					if ( ( selectedGame = doSelectGame( 0,1,1 ) ) != 0xFFFFFFFF ) 
					{
						strcpy( m_defaultRomDir, m_szCurrentDir ) ;
						if ( strlen( m_defaultRomDir ) && ( m_defaultRomDir[strlen(m_defaultRomDir)-1] != '\\' ) )
						{
							strcat( m_defaultRomDir, "\\" ) ;
						}
						strcat( m_defaultRomDir, "*" ) ;

					}
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ;
				}
				case 1 : 
				{
					DWORD selectedGame ;

					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					if ( ( selectedGame = doSelectGame( 0,1,1 ) ) != 0xFFFFFFFF ) 
					{
						strcpy( m_screenshotDir, m_szCurrentDir ) ;
						while ( strlen( m_screenshotDir) && ( m_screenshotDir[strlen(m_screenshotDir)-1] == '\\' ) )
						{
							m_screenshotDir[strlen(m_screenshotDir)-1] = 0 ;
						}

						char szNewDir[500] ;
						char *s, *p ;

						sprintf( szNewDir, "%s\\%s", m_screenshotDir, PLATFORM_NAME ) ; 

						CreateDirectory( szNewDir, NULL ) ;

						#ifdef GAMEBASE
							sprintf( szNewDir, "%s\\%s\\0", m_screenshotDir, PLATFORM_NAME ) ;
							CreateDirectory( szNewDir, NULL ) ;

							for ( char c = 'A' ; c <= 'Z' ; c++ )
							{
								sprintf( szNewDir, "%s\\%s\\%c", m_screenshotDir, PLATFORM_NAME, c ) ;
								CreateDirectory( szNewDir, NULL ) ;
							}
						#endif
					}


					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ;
				}
				case 2 : 
				{
					DWORD selectedGame ;

					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					if ( ( selectedGame = doSelectGame( 0,1,1 ) ) != 0xFFFFFFFF ) 
					{
						strcpy( m_szUserSavePath, m_szCurrentDir ) ;
						while ( strlen( m_szUserSavePath) && ( m_szUserSavePath[strlen(m_szUserSavePath)-1] == '\\' ) )
						{
							m_szUserSavePath[strlen(m_szUserSavePath)-1] = 0 ;
						}
						strcpy( g_savePath, m_szUserSavePath ) ;
					}
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ;
				}
				case 3 : 
				{
					DWORD selectedGame ;

					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					if ( ( selectedGame = doSelectGame( 0,1,1 ) ) != 0xFFFFFFFF ) 
					{
						strcpy( m_szSkinDir, m_szCurrentDir ) ;
						while ( strlen( m_szSkinDir) && ( m_szSkinDir[strlen(m_szSkinDir)-1] == '\\' ) )
						{
							m_szSkinDir[strlen(m_szSkinDir)-1] = 0 ;
						}
					}
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ;
				}
				default : break ;
			}
		}


	}
}

void CXBoxSample::doEmulatorOptions()
{
}

void CXBoxSample::doSelectBackground( char *bkgfile, CPanel *ppanel )
{
	unsigned int selectedGame ;
	char szNewDir[MAX_PATH] ;

	sprintf( szNewDir, "%s\\%s\\*", m_szSkinDir, m_szSkin ) ;

	FindAvailRoms( szNewDir ) ;
	curr = 0 ;
	topIdx = 0 ;

	while ( ( selectedGame = doSelectGame( 0,0 ) ) != 0xFFFFFFFF ) 
	{
		if  ( ! files[selectedGame].isDir ) 
		{
			CPanel panel ;
			LPDIRECT3DTEXTURE8	panelTexture ;

			sprintf( szNewDir, "%s\\%s\\%s", m_szSkinDir, m_szSkin, files[selectedGame].filename ) ;

			if (D3DXCreateTextureFromFileEx(m_pd3dDevice, szNewDir,
				 ppanel->m_nWidth, ppanel->m_nHeight, 1, 0, D3DFMT_LIN_R5G6B5, D3DPOOL_MANAGED,
				 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
				 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &panelTexture)==D3D_OK)
			{
				if ( FAILED(panel.Create(m_pd3dDevice, panelTexture, FALSE, ppanel->m_nWidth, ppanel->m_nHeight)) )
				{
					SAFE_RELEASE( panelTexture ) ;
					return ;
				}
			}
			else
			{
				return ;
			}


			panel.Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;
			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
			panel.Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;
			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


			if ( yesNoMenu( "Use this background?", &panel ) == 0 ) 
			{
				strcpy( bkgfile, (char*)files[selectedGame].filename) ;

				if ( FAILED(ppanel->Create(m_pd3dDevice, panelTexture, FALSE, ppanel->m_nWidth, ppanel->m_nHeight)) )
				{
				}

				break ;
			}
			else
			{
				panelTexture->Release() ;
			}
		}

	}


	FindAvailRoms(PLATFORM_FILE_DIR) ;
	curr = 0 ;
	topIdx = 0 ;
}

void CXBoxSample::doSelectColor( DWORD *pColor, MENU_PARAMS *menuParams )
{
	char szNewDir[MAX_PATH] ;
	DWORD color ;
	float arrowx, arrowy ;
	int iarrowx, iarrowy ;
	unsigned char *pos ;
	DWORD mtime ;
	FILE *outfile ;
	DWORD oldColor ;

	oldColor = *pColor ;

	arrowx = arrowy = 0 ;

	outfile = fopen( "Z:\\COLORMAP.BMP", "wb" ) ;
	if ( outfile == NULL )
		return ;

	fwrite( COLORMAP, sizeof(char), sizeof(COLORMAP), outfile ) ;
	fclose( outfile ) ;

	outfile = fopen( "Z:\\ARROW.BMP", "wb" ) ;
	if ( outfile == NULL )
		return ;

	fwrite( ARROWPIC, sizeof(char), sizeof(ARROWPIC), outfile ) ;
	fclose( outfile ) ;

	CPanel panel ;
	LPDIRECT3DTEXTURE8	panelTexture ;


	
	
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, "Z:\\COLORMAP.BMP",
		 COLORMAP_WIDTH, COLORMAP_HEIGHT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &panelTexture )==D3D_OK)
	{
		if ( FAILED(panel.Create(m_pd3dDevice, panelTexture , FALSE, COLORMAP_WIDTH, COLORMAP_HEIGHT)) )
		{
			panelTexture->Release() ;
			return  ;
		}
	}
	else
	{
		return  ;
	}
	
	
	CPanel arrow ;
	LPDIRECT3DTEXTURE8	arrowTexture ;

	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, "Z:\\ARROW.BMP",
		 ARROW_WIDTH, ARROW_HEIGHT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &arrowTexture )==D3D_OK)
	{
		if ( FAILED(arrow.Create(m_pd3dDevice, arrowTexture , FALSE, ARROW_WIDTH, ARROW_HEIGHT)) )
		{
			panelTexture->Release() ;
			arrowTexture->Release() ;
			return  ;
		}
	}
	else
	{
		panelTexture->Release() ;
		return  ;
	}



	LPDIRECT3DTEXTURE8	colorSquareTexture;

	D3DXCreateTexture(m_pd3dDevice, 1, 1, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &colorSquareTexture);
	
	D3DSURFACE_DESC desc;
    colorSquareTexture->GetLevelDesc(0, &desc);


	RECT rectSource;

	if ( MenuSprite==NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);


	color = 0xFFFFFFFF ;

	mtime = GetTickCount() ;

	while ( 1 )
	{
		pmenuParams = menuParams ;

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;


		m_mp3player.process() ;


		iarrowx = arrowx ;
		iarrowy = arrowy ;

		rectSource.top = iarrowy;
		rectSource.left = iarrowx;
		rectSource.bottom = iarrowy;
		rectSource.right  = iarrowx ;

		D3DLOCKED_RECT d3dlr;
		panelTexture->LockRect(0, &d3dlr, &rectSource, 0);

		memcpy( pColor, d3dlr.pBits, sizeof(color) ) ;

		panelTexture->UnlockRect(0);




		//pos = ( COLORMAP + sizeof(COLORMAP) - 3 ) - ( ( ( iarrowy * COLORMAP_WIDTH) + iarrowx ) * 3 ) ;
		//color =  0xFF000000 | ( *pos << 16 ) | ( *(pos+1) << 8 ) | ( *(pos+2) ) ;

		//sprintfx( "%03u %03u colormap %08.8X, pos %08.8X, ofs %08.8X, color %08.8X\r\n", iarrowx, iarrowy, COLORMAP, pos, pos-COLORMAP, color ) ;


		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 0;
		rectSource.right  = 0 ;

		colorSquareTexture->LockRect(0, &d3dlr, &rectSource, 0);

		memcpy( d3dlr.pBits, pColor, sizeof(color) ) ;

		colorSquareTexture->UnlockRect(0);

		D3DXVECTOR2 vecScale( 1, 1 ) ;
		D3DXVECTOR2 vecTranslate( (float)(640-50)/2, ((480-COLORMAP_HEIGHT)/2) + COLORMAP_HEIGHT + 32 ) ;
		D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);

		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 50 - 1 ;
		rectSource.right  = 50 - 1;
		
		MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);

		m_Font.DrawText( 50, 48, menuParams->normalColor, L"NORMAL", menuParams->selectBarColor, 0, 0, 0, 0, 0) ;
		m_Font.DrawText( 50, 48+menuParams->lineHeight, menuParams->selectedColor, L"SELECTED", menuParams->selectBarColor, 1, 0, 0, 0, 0) ;
		m_Font.DrawText( 50, 48+(2*menuParams->lineHeight), menuParams->notedColor, L"NOTED", menuParams->selectBarColor, 0, 0, 0, 0, 0) ;
		m_Font.DrawText( 50, 48+(3*menuParams->lineHeight), menuParams->selectedAndNotedColor, L"NOTED AND SELECTED", menuParams->selectBarColor, 1, 0, 0, 0, 0) ;


		m_Font.DrawText( (640-( m_Font.GetWidth( L"Press X To Select Transparent Color" ) / VIDEOMODES[m_xboxVidmode].multx ))/2, 
			((480-COLORMAP_HEIGHT)/2) + COLORMAP_HEIGHT + (pmenuParams->lineHeight), 
			pmenuParams->normalColor, L"Press X To Select Transparent Color", pmenuParams->selectBarColor, 0, 0, 0, 0, 0) ;

		


		panel.Render( ((640-COLORMAP_WIDTH)/2)*VIDEOMODES[m_xboxVidmode].multx, ((480-COLORMAP_HEIGHT)/2)*VIDEOMODES[m_xboxVidmode].multy, COLORMAP_WIDTH*VIDEOMODES[m_xboxVidmode].multx, COLORMAP_HEIGHT*VIDEOMODES[m_xboxVidmode].multy ) ;
		arrow.Render( ((640-COLORMAP_WIDTH)/2 + arrowx)*VIDEOMODES[m_xboxVidmode].multx, ((480-COLORMAP_HEIGHT)/2+arrowy)*VIDEOMODES[m_xboxVidmode].multy, ARROW_WIDTH*VIDEOMODES[m_xboxVidmode].multx, ARROW_HEIGHT*VIDEOMODES[m_xboxVidmode].multy ) ;

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			*pColor = oldColor ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			break ;

		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			*pColor = 0x00000000 ;
			break ;

		}
		else if ( g_Gamepads[0].hDevice ) 
		{
			if ( GetTickCount() - mtime > 5 )
			{
				mtime = GetTickCount() ;
				arrowx += g_Gamepads[0].fX1 ;
				arrowy -= g_Gamepads[0].fY1 ;

				if ( arrowx < 0 )
					arrowx = 0 ;

				if ( arrowy < 0 )
					arrowy = 0 ;

				if ( arrowx > COLORMAP_WIDTH )
					arrowx = COLORMAP_WIDTH ;

				if ( arrowy > COLORMAP_HEIGHT )
					arrowy = COLORMAP_HEIGHT ;
			}

		}
	}

	panelTexture->Release() ;
	arrowTexture->Release() ;
	colorSquareTexture->Release() ;

}


void CXBoxSample::doEditCode2( int selected, int numpositions, int codetype )
{
	char szNewDir[MAX_PATH] ;
	DWORD color ;
	CHEAT_CODE editedCode ;
	FILE *outfile ;
	int numpad ;
	int pos ;
	int panelx, panely ;
	CPanel panel ;
	LPDIRECT3DTEXTURE8	panelTexture ;
	int charspacing ;
	char truncCode[30] ;
	WCHAR msg[50] ;
	WCHAR *lines[100] = { L"L/R Trigger - Change Position", 
							L"A - Select Digit",
							L"START - Save Code",
							L"B - Cancel" } ;
	int posx[4] ;



	if ( selected == -1 )
	{
		CHEAT_CODE code ;

		code.adr = 0 ;
		code.val = 0 ;
		code.enabled = 0 ;
		code.desc[0] = 0 ;
		code.type = 0x30 ;
		sprintf( code.code, "30%06.6X %04.4X", code.adr, code.val & 0xFFFF ) ;

		m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

		memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
		m_numCheats++ ;
		selected = m_numCheats-1 ;
	}

#ifdef GAME_GENIE
	if ( ( m_cheatCodes[selected].type & 0xF0 ) == 0x90 )
	{
		doEditGameGenie( selected ) ;
		return ;
	}
#endif


	for ( int i = 0 ; i < 4 ; i++ )
	{
		posx[i] = (640-( m_Font.GetWidth( lines[i] )/VIDEOMODES[m_xboxVidmode].multx )) / 2 ;
	}


	numpad = 0 ;
	pos = 0 ;

	outfile = fopen( "Z:\\NUMPAD.PNG", "wb" ) ;
	if ( outfile == NULL )
		return ;

	fwrite( NUMPAD_PNG, sizeof(char), sizeof(NUMPAD_PNG), outfile ) ;
	fclose( outfile ) ;



	pmenuParams = &(m_skin.otherMenu) ;
	
	if (D3DXCreateTextureFromFileEx(m_pd3dDevice, "Z:\\NUMPAD.PNG",
		 NUMPAD_WIDTH, NUMPAD_HEIGHT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 //D3DX_DEFAULT, D3DX_DEFAULT, 1, 0, D3DFMT_LIN_A8R8G8B8, D3DPOOL_MANAGED,
		 D3DX_FILTER_NONE , D3DX_FILTER_NONE, 0, NULL, NULL, &panelTexture )==D3D_OK)
	{
		if ( FAILED(panel.Create(m_pd3dDevice, panelTexture , FALSE, NUMPAD_WIDTH, NUMPAD_HEIGHT)) )
		{
			panelTexture->Release() ;
			return  ;
		}
	}
	else
	{
		return  ;
	}
	
	charspacing = 0 ;

	for ( int i = 0 ; i < 10 ; i++ )
	{
		swprintf( msg, L"%c", '0' + i ) ;
		if ( m_Font.GetWidth( msg )/VIDEOMODES[m_xboxVidmode].multx > charspacing )
			charspacing = m_Font.GetWidth( msg ) / VIDEOMODES[m_xboxVidmode].multx;
	}
	for ( int i = 0 ; i < 6 ; i++ )
	{
		swprintf( msg, L"%c", 'A' + i ) ;
		if ( m_Font.GetWidth( msg )/VIDEOMODES[m_xboxVidmode].multx > charspacing )
			charspacing = m_Font.GetWidth( msg )/VIDEOMODES[m_xboxVidmode].multx ;
	}






	truncCode[0] = 0 ;
	int cnt = 0 ;

	for ( int i = 0 ; ( cnt < numpositions ) && ( i<29) ; i++ )
	{
		if ( m_cheatCodes[selected].code[i] != ' ' ) 
		{
			truncCode[cnt] = m_cheatCodes[selected].code[i] ;
			cnt++ ;
		}
	}

	truncCode[cnt] = 0 ;

	charspacing += 5 ;
	
	LPDIRECT3DTEXTURE8	colorSquareTexture;

	D3DXCreateTexture(m_pd3dDevice, 1, 1, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &colorSquareTexture);
	
	D3DSURFACE_DESC desc;
    colorSquareTexture->GetLevelDesc(0, &desc);


	RECT rectSource;
	D3DLOCKED_RECT d3dlr;


	if ( MenuSprite==NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);


	color = 0x800066CC ;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = 0;
	rectSource.right  = 0 ;

	colorSquareTexture->LockRect(0, &d3dlr, &rectSource, 0);

	memcpy( d3dlr.pBits, &color, sizeof(color) ) ;

	colorSquareTexture->UnlockRect(0);

	panelx = (640-NUMPAD_WIDTH)/2 ;
	panely = 82 ; 

	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		D3DXCOLOR d3color( 1.0, 1.0, 1.0, 0.5 ) ;
		//DWORD holdTrans = pmenuParams->panel->m_colDiffuse ;
		//pmenuParams->panel->SetAlpha( (holdTrans>>24) / 2 ) ;
		pmenuParams->panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		m_pnlGameScreen.SetAlpha( 0x80) ;



		m_pnlGameScreen.Render(m_gameRectSource.left,m_gameRectSource.top,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
		//m_pnlGameScreen.Render(0,0,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
		m_pnlGameScreen.SetAlpha( 0xFF) ;
		//Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
		//pmenuParams->panel->SetAlpha( (holdTrans>>24)  ) ;



		panel.Render( panelx*VIDEOMODES[m_xboxVidmode].multx, panely*VIDEOMODES[m_xboxVidmode].multy, NUMPAD_WIDTH*VIDEOMODES[m_xboxVidmode].multx, NUMPAD_HEIGHT*VIDEOMODES[m_xboxVidmode].multy ) ;


		m_mp3player.process() ;


		D3DXVECTOR2 vecScale( 1, 1 ) ;
		D3DXVECTOR2 vecTranslate( (panelx + 4 + ( 53 * ( numpad % 4 )))*VIDEOMODES[m_xboxVidmode].multx, (panely + 4 + ( 53 * ( numpad / 4 ) ))*VIDEOMODES[m_xboxVidmode].multy ) ;
		D3DXCOLOR sd3color(1.0, 1.0, 1.0, 1.0);
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 49*VIDEOMODES[m_xboxVidmode].multy;
		rectSource.right  = 49*VIDEOMODES[m_xboxVidmode].multx ;

		MenuSprite->Draw(colorSquareTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, sd3color);

		for ( int i = 0 ; i < numpositions ; i++ )
		{
			swprintf( msg, L"%c", truncCode[i] ) ;
			m_Font.DrawText( ((640-(charspacing*numpositions))/2) + i*charspacing, (panely-pmenuParams->lineHeight)-10, 
				pos==i ? pmenuParams->selectedColor : pmenuParams->normalColor, msg, pmenuParams->selectBarColor, pos==i, 0, 0, 0, 0) ;
		}

		for ( int i = 0 ; i < 4 ; i++ )
		{
			m_Font.DrawText( posx[i], panely+NUMPAD_HEIGHT+10 + (pmenuParams->lineHeight*i), 
				pmenuParams->normalColor, lines[i], pmenuParams->selectBarColor, 0, 0, 0, 0, 0) ;
		}


		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			if ( numpad < 10 )
				truncCode[pos] = '0' + numpad ;
			else
				truncCode[pos] = 'A' + (numpad-10) ;


			pos = (pos+1)%numpositions ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( ( numpad %4 ) == 3 )
				numpad -= 3 ;
			else
				numpad++ ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( ( numpad %4 ) == 0 )
				numpad += 3 ;
			else
				numpad-- ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( numpad < 4 )
				numpad += 12 ;
			else
				numpad -= 4 ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			if ( numpad > 11 )
				numpad -= 12 ;
			else
				numpad += 4 ;

		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			pos = (pos+1)%numpositions ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			pos = (pos+(numpositions-1))%numpositions ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_START )
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			memcpy( &editedCode, &(m_cheatCodes[selected]), sizeof(CHEAT_CODE) ) ;

			if ( validateCode( truncCode, &editedCode, codetype ) )
			{
				memcpy( &(m_cheatCodes[selected]), &editedCode, sizeof(CHEAT_CODE) ) ;
				break ;
			}
			else
			{
				popupMsg( "The code you entered is invalid.", &m_pnlBackgroundOther ) ;
			}
		}
	}

	panelTexture->Release() ;
	colorSquareTexture->Release() ;

}


void CXBoxSample::doSelectSound( char *soundfile, CXBSound *psound )
{
	unsigned int selectedGame ;
	char szNewDir[MAX_PATH] ;

	sprintf( szNewDir, "%s\\%s\\*.wav", m_szSkinDir, m_szSkin ) ;

	FindAvailRoms( szNewDir ) ;
	curr = 0 ;
	topIdx = 0 ;

	while ( ( selectedGame = doSelectGame( 0,0 ) ) != 0xFFFFFFFF ) 
	{
		if  ( ! files[selectedGame].isDir ) 
		{
			CXBSound wavsound ;
			char tmpfilename[MAX_PATH] ;

			sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, files[selectedGame].filename) ;

			wavsound.Create( tmpfilename, 0 ) ;

			wavsound.Play( DSBPLAY_FROMSTART ) ;
			Sleep(250) ;
			wavsound.Play( DSBPLAY_FROMSTART ) ;
			Sleep(250) ;
			wavsound.Play( DSBPLAY_FROMSTART ) ;

			if ( yesNoMenu( "Use this sound?", &m_pnlBackgroundSelect ) == 0 ) 
			{
				psound->Destroy() ;
				psound->Create( tmpfilename, 0 ) ;
				strcpy( soundfile, (char*)files[selectedGame].filename) ;
				break ;
			}
		}

	}


	FindAvailRoms(PLATFORM_FILE_DIR) ;
	curr = 0 ;
	topIdx = 0 ;
}

void CXBoxSample::doSelectBGM( char *bgmfile )
{
	unsigned int selectedGame ;
	char szNewDir[MAX_PATH] ;

	sprintf( szNewDir, "%s\\%s\\*.mp3", m_szSkinDir, m_szSkin ) ;

	FindAvailRoms( szNewDir ) ;
	curr = 0 ;
	topIdx = 0 ;

	while ( ( selectedGame = doSelectGame( 0,0 ) ) != 0xFFFFFFFF ) 
	{
		if  ( ! files[selectedGame].isDir ) 
		{
			char tmpfilename[MAX_PATH] ;

			sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, files[selectedGame].filename) ;

			if ( m_mp3player.loadFile( tmpfilename, 1, 0,9999999 ) )
			{
				//writexbox( "nonomp3\r\n") ;
			}
			else
			{
				//m_mp3player.insertSilence( 22050 ) ;
				m_mp3player.pause( FALSE ) ;
			}

			if ( yesNoMenu( "Use this BGM?", &m_pnlBackgroundSelect ) == 0 ) 
			{
				strcpy( bgmfile, (char*)files[selectedGame].filename) ;
				break ;
			}
			else
			{
				sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.menuBkgMusic) ;
				if ( m_mp3player.loadFile( tmpfilename, m_skin.loopbgm, 0,9999999 ) )
				{
					//writexbox( "nonomp3\r\n") ;
				}
				else
				{
					//m_mp3player.insertSilence( 22050 ) ;
					m_mp3player.pause( FALSE ) ;
				}
			}

		}

	}


	FindAvailRoms(PLATFORM_FILE_DIR) ;
	curr = 0 ;
	topIdx = 0 ;
}

void CXBoxSample::doSelectFont( char *fontfile )
{
	unsigned int selectedGame ;
	char szNewDir[MAX_PATH] ;

	sprintf( szNewDir, "%s\\%s\\*.ttf", m_szSkinDir, m_szSkin ) ;

	FindAvailRoms( szNewDir ) ;
	curr = 0 ;
	topIdx = 0 ;

	while ( ( selectedGame = doSelectGame( 0,0 ) ) != 0xFFFFFFFF ) 
	{
		if  ( ! files[selectedGame].isDir ) 
		{
			char tmpfilename[MAX_PATH] ;

			sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, files[selectedGame].filename) ;

			m_Font.Initialize( m_pd3dDevice, tmpfilename, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;

			if ( yesNoMenu( "Use this Font?", &m_pnlBackgroundSelect ) == 0 ) 
			{
				strcpy( fontfile, (char*)files[selectedGame].filename) ;
				break ;
			}
			else
			{
				sprintf( tmpfilename, "%s\\%s\\%s", m_szSkinDir, m_szSkin, m_skin.font ) ;

				m_Font.Initialize( m_pd3dDevice, tmpfilename, VIDEOMODES[m_xboxVidmode].multx, VIDEOMODES[m_xboxVidmode].multy ) ;
			}

		}

	}


	FindAvailRoms(PLATFORM_FILE_DIR) ;
	curr = 0 ;
	topIdx = 0 ;
}

void CXBoxSample::doConfigureSkin()
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

	
		swprintf( m_menuText[0], L"Configure Skin" );
		swprintf( m_menuText[1], L"Splash Screen - Load Xbe");
		swprintf( m_menuText[2], L"Splash Screen - Load Game");
		swprintf( m_menuText[3], L"Move Menu Sound");
		swprintf( m_menuText[4], L"Select Menu Sound");
		swprintf( m_menuText[5], L"Cancel Menu Sound");
		swprintf( m_menuText[6], L"Background Music");
		swprintf( m_menuText[7], L"Loop Background Music? %S", m_skin.loopbgm ? "Yes" : "No" );
		swprintf( m_menuText[8], L"Font");
		swprintf( m_menuText[9], L"Transition Speed");
		swprintf( m_menuText[10], L"Transition Effect");
		swprintf( m_menuText[11], L"Main Menu Settings");
		swprintf( m_menuText[12], L"Game Select Menu Settings");
		swprintf( m_menuText[13], L"Popup Menu Settings");
		swprintf( m_menuText[14], L"All Other Menu Settings");
		swprintf( m_menuText[15], L"Loading Screen Menu Settings");
		swprintf( m_menuText[16], L"Show Available Memory");
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 17, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doSelectBackground( m_skin.loadEmuSplash, &m_pnlSplashEmu  ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 1 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doSelectBackground( m_skin.loadGameSplash, &m_pnlSplashGame  ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 2 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doSelectSound( m_skin.menuMoveSound, &m_sfxMenuMove ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 3 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doSelectSound( m_skin.menuSelectSound, &m_sfxMenuSelect ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 4 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doSelectSound( m_skin.menuCancelSound, &m_sfxMenuCancel ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 5 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doSelectBGM( m_skin.menuBkgMusic ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 6 : 
				{
					m_skin.loopbgm = ! m_skin.loopbgm ;
					break ; 
				}
				case 7 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doSelectFont( m_skin.font ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 8 : 
				{
					int holder ;
					int yesno ;

					while ( 1 )
					{
						holder = getValuePopup( "Change Transition Speed", m_skin.fade, 0, 255, &m_pnlBackgroundOther ) ; 

						doTransition( &m_pnlBackgroundOther, &m_pnlSplashGame, holder, m_skin.transition ) ;

						if ( (yesno = yesNoMenu( "Use this fade speed?", &m_pnlSplashGame ) ) == 0 ) 
						{
							m_skin.fade = holder ;
							break ;
						}
						else
						{
							if ( yesno != 1 )
								break ;
						}
					}
					break ;
				}
				case 9 : 
				{
					doSelectTransition(  ) ; 
					break ; 
				}
				case 10 :  
				{
					changeMenu( &m_skin.otherMenu, &m_skin.mainMenu ) ;
					doConfigureSkinMenu( &m_skin.mainMenu, "Configure Skin - Main Menu" ) ; 
					changeMenu( &m_skin.mainMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 11 :  
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doConfigureSkinMenu( &m_skin.gameSelectMenu, "Configure Skin - Selection Menu" ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 12 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.popupMenu ) ;
					doConfigureSkinMenu( &m_skin.popupMenu, "Configure Skin - Popup Menu" ) ; 
					changeMenu( &m_skin.popupMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 13 : 
				{
					doConfigureSkinMenu( &m_skin.otherMenu, "Configure Skin - All Other Menus" ) ; 
					break ; 
				}
				case 14 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.loadingMenu ) ;
					doConfigureSkinMenu( &m_skin.loadingMenu, "Configure Skin - Loading Menu" ) ; 
					changeMenu( &m_skin.loadingMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 15 : 
				{
					MEMORYSTATUS stat;

					GlobalMemoryStatus( &stat );
					char msg[100] ;

					sprintf( msg, "Available Memory : %u Bytes", stat.dwAvailPhys ) ;
					popupMsg( msg, &m_pnlBackgroundOther ) ;

					break ; 
				}
				default : break ;
			}
		}


	}

	doSaveSkin() ;
}

void CXBoxSample::changeMenu( MENU_PARAMS *menuparams1, MENU_PARAMS *menuparams2 ) 
{
	doTransition( menuparams1->panel, menuparams2->panel, m_skin.fade, m_skin.transition ) ;
	memcpy( &m_ptConfig, &(menuparams2->ptConfig), sizeof(m_ptConfig) ) ;
	SetupPlaything() ;

	if ( menuparams2->animationDelay )
	{
		DWORD starttime = GetTickCount() ;

		while ( starttime + menuparams2->animationDelay > GetTickCount() )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
								0x00000000, 1.0f, 0L );
			//RenderGradientBackground( 0xFF000000, 0xFF000000 );

			m_mp3player.process() ;
			menuparams2->panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
			m_plaything.Render( 0, 0, 0 ) ;
			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
		}
	}
}


void CXBoxSample::doMenuBackgroundSettings( MENU_PARAMS *menuparams )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = menuparams ;

	
		swprintf( m_menuText[0], L"Menu Background Settings" );
		swprintf( m_menuText[1], L"Select Background Image");
		swprintf( m_menuText[2], L"Background Transparency");
		swprintf( m_menuText[3], L"Border Width");
		swprintf( m_menuText[4], L"Screenshot Size/Position");
		swprintf( m_menuText[5], L"Screenshot Transparency");
		swprintf( m_menuText[6], L"Time to Delay For Animation");
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 7, 0, menuparams->panel, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				{
					changeMenu( &m_skin.otherMenu, &m_skin.gameSelectMenu ) ;
					doSelectBackground( menuparams->bkg, menuparams->panel  ) ; 
					changeMenu( &m_skin.gameSelectMenu, &m_skin.otherMenu ) ;
					break ; 
				}
				case 1 : 
				{
					menuparams->transparency = getValuePopup( "Change Background Transparency", menuparams->transparency, 0, 255, menuparams->panel ) ; 
					menuparams->panel->SetAlpha( menuparams->transparency) ;
					break ;
				}
				case 2 : 
				{
					menuparams->borderWidth = getValuePopup( "Change Border Width", menuparams->borderWidth, 0, 255, menuparams->panel ) ; 
					break ;
				}
				case 3 : 
				{
					doScreenshotSize( menuparams ) ; 
					break ;
				}
				case 4 : 
				{
					menuparams->screenshotTransparency = getValuePopup( "Change Screenshot Transparency", menuparams->screenshotTransparency, 0, 255, menuparams->panel ) ; 
					break ;
				}
				case 5 : 
				{
					menuparams->animationDelay = getValuePopup( "Time to Delay For Animation", menuparams->animationDelay, 0, 30000, menuparams->panel ) ; 
					break ;
				}
				default : break ;
			}
		}


	}
}

void CXBoxSample::doMenuSpriteSettings( MENU_PARAMS *menuparams )
{
	int menuChoice = 0 ;

	if ( m_plaything.m_spritedefs.GetSize() < 1 )
	{
		char msg[200] ;

		sprintf( msg, "No sprite dirs found in %s\\%s\\SPRITES", m_szSkinDir, m_szSkin ) ;
		popupMsg( msg, &m_pnlBackgroundOther ) ;
		return ;
	}


	while ( 1 )
	{

		pmenuParams = menuparams ;

	
		swprintf( m_menuText[0], L"Menu Sprite Settings" );
		swprintf( m_menuText[1], L"Configure Effect 1" );
		swprintf( m_menuText[2], L"Configure Effect 2" );
		swprintf( m_menuText[3], L"Configure Effect 3" );
		swprintf( m_menuText[4], L"Configure Left-Select Sprite" );
		swprintf( m_menuText[5], L"Configure Right-Select Sprite" );
		swprintf( m_menuText[6], L"Configure Sprite 1" );
		swprintf( m_menuText[7], L"Configure Sprite 2" );
		swprintf( m_menuText[8], L"Configure Sprite 3" );
		swprintf( m_menuText[9], L"Configure Sprite 4" );
		swprintf( m_menuText[10], L"Configure Sprite 5" );
		swprintf( m_menuText[11], L"Configure Sprite 6" );
		swprintf( m_menuText[12], L"Configure Sprite 7" );
		swprintf( m_menuText[13], L"Configure Sprite 8" );
		swprintf( m_menuText[14], L"Configure Sprite 9" );
		swprintf( m_menuText[15], L"Configure Sprite 10" );
		swprintf( m_menuText[16], L"Configure Sprite 11" );
		swprintf( m_menuText[17], L"Configure Sprite 12" );
		swprintf( m_menuText[18], L"Configure Sprite 13" );
		swprintf( m_menuText[19], L"Configure Sprite 14" );
		swprintf( m_menuText[20], L"Configure Sprite 15" );
		swprintf( m_menuText[21], L"Configure Sprite 16" );
		swprintf( m_menuText[22], L"Configure Sprite 17" );
		swprintf( m_menuText[23], L"Configure Sprite 18" );
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 22, 0, menuparams->panel, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			if ( menuChoice < 3 )
			{
				doConfigureEffects( menuparams, menuChoice ) ;
			}
			else if ( menuChoice < 5 )
			{
				doConfigureSprite( menuparams, menuChoice+15 ) ;
			}
			else
			{
				doConfigureSprite( menuparams, menuChoice-5 ) ;
			}
		}


	}
}


void CXBoxSample::doConfigureEffects( MENU_PARAMS *menuparams, int which )
{
	int fResult ;
	char xmsg[100] ;
	int menuChoice = 0 ;
	int bdone ;
	WCHAR msg[200] ;
	float mx, my ;
	int shoot ;
	DWORD mtime ;

	mtime = GetTickCount() ;


	bdone = 0 ;


	while ( 1 )
	{

		pmenuParams = menuparams ;

		swprintf( m_menuText[0], L"Configure Effect %u", which+1 );
		swprintf( m_menuText[1], L"Effect" );
		//swprintf( m_menuText[2], L"%S" );
		swprintf( m_menuText[3], L"Offset X" );
		swprintf( m_menuText[4], L"%3.2f", menuparams->ptConfig.effects[which].offsetX );
		swprintf( m_menuText[5], L"Offset Y" );
		swprintf( m_menuText[6], L"%3.2f", menuparams->ptConfig.effects[which].offsetY  );
		swprintf( m_menuText[7], L"Length X" );
		swprintf( m_menuText[8], L"%3.2f", menuparams->ptConfig.effects[which].lengthX );
		swprintf( m_menuText[9], L"Length Y" );
		swprintf( m_menuText[10], L"%3.2f", menuparams->ptConfig.effects[which].lengthY  );
		swprintf( m_menuText[11], L"Multiplier X" );
		swprintf( m_menuText[12], L"%2.2f", menuparams->ptConfig.effects[which].multX );
		swprintf( m_menuText[13], L"Multiplier Y" );
		swprintf( m_menuText[14], L"%2.2f", menuparams->ptConfig.effects[which].multY);
		swprintf( m_menuText[15], L"Multiplier General" );
		swprintf( m_menuText[16], L"%2.2f", menuparams->ptConfig.effects[which].multGen);
		swprintf( m_menuText[17], L"Speed" );
		swprintf( m_menuText[18], L"%3.1f", menuparams->ptConfig.effects[which].speed);
		swprintf( m_menuText[19], L"Number of Sprites" );
		swprintf( m_menuText[20], L"%u", menuparams->ptConfig.effects[which].numsprites);
		swprintf( m_menuText[21], L"Sprite Graphic" );
		swprintf( m_menuText[22], L"" ) ;
		swprintf( m_menuText[23], L"Size" );
		swprintf( m_menuText[24], L"%2.1f", menuparams->ptConfig.effects[which].scale);
		swprintf( m_menuText[25], L"Frame Speed" );
		swprintf( m_menuText[26], L"%u", menuparams->ptConfig.effects[which].framespeed);
		swprintf( m_menuText[27], L"Transparency" );
		swprintf( m_menuText[28], L"%u", menuparams->ptConfig.effects[which].transparency );
		swprintf( m_menuText[29], L"Flip Horizontally" );
		swprintf( m_menuText[30], L"%u", menuparams->ptConfig.effects[which].flipH );
		swprintf( m_menuText[31], L"Flip Vertically" );
		swprintf( m_menuText[32], L"%u", menuparams->ptConfig.effects[which].flipV);

		switch ( menuparams->ptConfig.effects[which].effect )
		{
			case SQUIGGLE : swprintf( m_menuText[2], L"Squiggle" ) ; break ; 
			case CIRCLE : swprintf( m_menuText[2], L"Circle" ) ; break ; 
			default : swprintf( m_menuText[2], L"Off" ) ; break ;
		}

		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 17, 0, menuparams->panel, menuChoice, 1, 300 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			//m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			switch ( menuChoice )
			{
				case 0 :
				{
					switch ( menuparams->ptConfig.effects[which].effect )
					{
						case SQUIGGLE : menuparams->ptConfig.effects[which].effect = CIRCLE ; break ;
						case CIRCLE   : menuparams->ptConfig.effects[which].effect = STATIC ; break ;
						case SQUARE   : menuparams->ptConfig.effects[which].effect = STATIC ; break ;
						case STATIC   : menuparams->ptConfig.effects[which].effect = SQUIGGLE ; break ;
					}
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 1:
				{
					menuparams->ptConfig.effects[which].offsetX += 1.0f ;
					if ( menuparams->ptConfig.effects[which].offsetX > 640.0f )
						menuparams->ptConfig.effects[which].offsetX -= 640.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 2:
				{
					menuparams->ptConfig.effects[which].offsetY += 1.0f ;
					if ( menuparams->ptConfig.effects[which].offsetY > 480.0f )
						menuparams->ptConfig.effects[which].offsetY -= 480.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 3 :
				{
					menuparams->ptConfig.effects[which].lengthX += 1.0f ;
					if ( menuparams->ptConfig.effects[which].lengthX > 640.0f )
						menuparams->ptConfig.effects[which].lengthX -= 640.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 4:
				{
					menuparams->ptConfig.effects[which].lengthY += 1.0f ;
					if ( menuparams->ptConfig.effects[which].lengthY > 480.0f )
						menuparams->ptConfig.effects[which].lengthY -= 480.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 5:
				{
					menuparams->ptConfig.effects[which].multX += 0.1f ;
					if ( menuparams->ptConfig.effects[which].multX > 64.0f )
						menuparams->ptConfig.effects[which].multX -= 63.9f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 6:
				{
					menuparams->ptConfig.effects[which].multY += 0.1f ;
					if ( menuparams->ptConfig.effects[which].multY > 64.0f )
						menuparams->ptConfig.effects[which].multY -= 63.9f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 7:
				{
					menuparams->ptConfig.effects[which].multGen += 0.1f ;
					if ( menuparams->ptConfig.effects[which].multGen > 64.0f )
						menuparams->ptConfig.effects[which].multGen -= 63.9f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 8:
				{
					menuparams->ptConfig.effects[which].speed += 1.0f ;
					if ( menuparams->ptConfig.effects[which].speed > 360.0f )
						menuparams->ptConfig.effects[which].speed -= 357.0f ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 9:
				{
					menuparams->ptConfig.effects[which].numsprites += 1 ;
					if ( menuparams->ptConfig.effects[which].numsprites > 20 )
						menuparams->ptConfig.effects[which].numsprites = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 10 :
				{
					menuparams->ptConfig.effects[which].sprite += 1 ; 
					if ( menuparams->ptConfig.effects[which].sprite >= m_plaything.m_spritedefs.GetSize() )
						menuparams->ptConfig.effects[which].sprite = -1 ; 

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 11:
				{
					menuparams->ptConfig.effects[which].scale += 0.1f ;
					if ( menuparams->ptConfig.effects[which].scale > 30 )
						menuparams->ptConfig.effects[which].scale = 0.3f ; ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 12:
				{
					menuparams->ptConfig.effects[which].framespeed += 1 ;
					if ( menuparams->ptConfig.effects[which].framespeed > 100 )
						menuparams->ptConfig.effects[which].framespeed = 1 ; ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 13:
				{
					menuparams->ptConfig.effects[which].transparency += 1 ;
					if ( menuparams->ptConfig.effects[which].transparency > 255 )
						menuparams->ptConfig.effects[which].transparency = 0 ; ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 14:
				{
					menuparams->ptConfig.effects[which].flipH = !menuparams->ptConfig.effects[which].flipH ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 15:
				{
					menuparams->ptConfig.effects[which].flipV = !menuparams->ptConfig.effects[which].flipV ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
		{
			switch ( menuChoice )
			{
				case 0 :
				{
					switch ( menuparams->ptConfig.effects[which].effect )
					{
						case SQUIGGLE : menuparams->ptConfig.effects[which].effect = STATIC ; break ;
						case CIRCLE   : menuparams->ptConfig.effects[which].effect = SQUIGGLE ; break ;
						case SQUARE   : menuparams->ptConfig.effects[which].effect = CIRCLE ; break ;
						case STATIC   : menuparams->ptConfig.effects[which].effect = CIRCLE ; break ;
					}
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 1:
				{
					menuparams->ptConfig.effects[which].offsetX -= 1.0f ;
					if ( menuparams->ptConfig.effects[which].offsetX < 0 )
						menuparams->ptConfig.effects[which].offsetX += 640.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 2:
				{
					menuparams->ptConfig.effects[which].offsetY -= 1.0f ;
					if ( menuparams->ptConfig.effects[which].offsetY < 0 )
						menuparams->ptConfig.effects[which].offsetY += 480.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 3 :
				{
					menuparams->ptConfig.effects[which].lengthX -= 1.0f ;
					if ( menuparams->ptConfig.effects[which].lengthX < 0 )
						menuparams->ptConfig.effects[which].lengthX += 640.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 4:
				{
					menuparams->ptConfig.effects[which].lengthY -= 1.0f ;
					if ( menuparams->ptConfig.effects[which].lengthY < 0 )
						menuparams->ptConfig.effects[which].lengthY += 480.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 5:
				{
					menuparams->ptConfig.effects[which].multX -= 0.1f ;
					if ( menuparams->ptConfig.effects[which].multX < 0.2f  )
						menuparams->ptConfig.effects[which].multX += 63.9f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 6:
				{
					menuparams->ptConfig.effects[which].multY -= 0.1f ;
					if ( menuparams->ptConfig.effects[which].multY < 0.2f )
						menuparams->ptConfig.effects[which].multY += 63.9f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 7:
				{
					menuparams->ptConfig.effects[which].multGen -= 0.1f ;
					if ( menuparams->ptConfig.effects[which].multGen < 0.2f )
						menuparams->ptConfig.effects[which].multGen += 63.9f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 8:
				{
					menuparams->ptConfig.effects[which].speed -= 1.0f ;
					if ( menuparams->ptConfig.effects[which].speed < 3.0f )
						menuparams->ptConfig.effects[which].speed += 357.0f ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 9:
				{
					if ( menuparams->ptConfig.effects[which].numsprites == 0 )
						menuparams->ptConfig.effects[which].numsprites = 20 ;
					else
						menuparams->ptConfig.effects[which].numsprites-- ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 10 :
				{
					menuparams->ptConfig.effects[which].sprite -= 1 ; 
					if ( menuparams->ptConfig.effects[which].sprite < -1 )
						menuparams->ptConfig.effects[which].sprite = m_plaything.m_spritedefs.GetSize() - 1  ; 


					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 11 :
				{
					menuparams->ptConfig.effects[which].scale -= 0.1f ;
					if ( menuparams->ptConfig.effects[which].scale < 0.3f )
						menuparams->ptConfig.effects[which].scale = 30.0f ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 12:
				{
					menuparams->ptConfig.effects[which].framespeed -= 1 ;
					if ( menuparams->ptConfig.effects[which].framespeed < 1  )
						menuparams->ptConfig.effects[which].framespeed = 100 ; ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 13:
				{
					menuparams->ptConfig.effects[which].transparency -= 1 ;
					if ( menuparams->ptConfig.effects[which].transparency < 0  )
						menuparams->ptConfig.effects[which].transparency = 255 ; ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 14:
				{
					menuparams->ptConfig.effects[which].flipH = !menuparams->ptConfig.effects[which].flipH ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 15:
				{
					menuparams->ptConfig.effects[which].flipV = !menuparams->ptConfig.effects[which].flipV ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].fX2 > 0 )
		{
			float fval ;

			if ( GetTickCount() - mtime > 5 )
			{
				mtime = GetTickCount() ;
				fval = g_Gamepads[0].fX2 / 10.0f;
				switch ( menuChoice )
				{
					case 1:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].offsetX += fval ;
						if ( menuparams->ptConfig.effects[which].offsetX > 640.0f )
							menuparams->ptConfig.effects[which].offsetX -= 640.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 2:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].offsetY += fval ;
						if ( menuparams->ptConfig.effects[which].offsetY > 480.0f )
							menuparams->ptConfig.effects[which].offsetY -= 480.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 3 :
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].lengthX += fval ;
						if ( menuparams->ptConfig.effects[which].lengthX > 640.0f )
							menuparams->ptConfig.effects[which].lengthX -= 640.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 4:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].lengthY += fval ;
						if ( menuparams->ptConfig.effects[which].lengthY > 480.0f )
							menuparams->ptConfig.effects[which].lengthY -= 480.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 5:
					{
						menuparams->ptConfig.effects[which].multX += fval ;
						if ( menuparams->ptConfig.effects[which].multX > 64.0f )
							menuparams->ptConfig.effects[which].multX -= 63.9f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 6:
					{
						menuparams->ptConfig.effects[which].multY += fval ;
						if ( menuparams->ptConfig.effects[which].multY > 64.0f )
							menuparams->ptConfig.effects[which].multY -= 63.9f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 7:
					{
						menuparams->ptConfig.effects[which].multGen += fval ;
						if ( menuparams->ptConfig.effects[which].multGen > 64.0f )
							menuparams->ptConfig.effects[which].multGen -= 63.9f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 8:
					{
						menuparams->ptConfig.effects[which].speed += fval ;
						if ( menuparams->ptConfig.effects[which].speed > 360.0f )
							menuparams->ptConfig.effects[which].speed -= 357.0f ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 12:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].framespeed += fval ;
						if ( menuparams->ptConfig.effects[which].framespeed > 100 )
							menuparams->ptConfig.effects[which].framespeed = 1  ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 13:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].transparency += fval ;
						if ( menuparams->ptConfig.effects[which].transparency > 255 )
							menuparams->ptConfig.effects[which].transparency = 0  ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].fX2 < 0 )
		{
			float fval ;

			if ( GetTickCount() - mtime > 5 )
			{
				mtime = GetTickCount() ;
				fval = g_Gamepads[0].fX2*-1.0f / 10.0f;

				switch ( menuChoice )
				{
					case 1:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].offsetX -= fval ;
						if ( menuparams->ptConfig.effects[which].offsetX < 0 )
							menuparams->ptConfig.effects[which].offsetX += 640.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 2:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].offsetY -= fval ;
						if ( menuparams->ptConfig.effects[which].offsetY < 0 )
							menuparams->ptConfig.effects[which].offsetY += 480.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 3 :
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].lengthX -= fval ;
						if ( menuparams->ptConfig.effects[which].lengthX < 0 )
							menuparams->ptConfig.effects[which].lengthX += 640.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 4:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].lengthY -= fval ;
						if ( menuparams->ptConfig.effects[which].lengthY < 0 )
							menuparams->ptConfig.effects[which].lengthY += 480.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 5:
					{
						menuparams->ptConfig.effects[which].multX -= fval ;
						if ( menuparams->ptConfig.effects[which].multX < 0.2f  )
							menuparams->ptConfig.effects[which].multX += 63.9f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 6:
					{
						menuparams->ptConfig.effects[which].multY -= fval ;
						if ( menuparams->ptConfig.effects[which].multY < 0.2f )
							menuparams->ptConfig.effects[which].multY += 63.9f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 7:
					{
						menuparams->ptConfig.effects[which].multGen -= fval ;
						if ( menuparams->ptConfig.effects[which].multGen < 0.2f )
							menuparams->ptConfig.effects[which].multGen += 63.9f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 8:
					{
						menuparams->ptConfig.effects[which].speed -= fval ;
						if ( menuparams->ptConfig.effects[which].speed < 3.0f )
							menuparams->ptConfig.effects[which].speed += 357.0f ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 12:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].framespeed -= fval ;
						if ( menuparams->ptConfig.effects[which].framespeed < 1 )
							menuparams->ptConfig.effects[which].framespeed = 100  ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 13:
					{
						fval *= 10.0f;
						menuparams->ptConfig.effects[which].transparency -= fval ;
						if ( menuparams->ptConfig.effects[which].transparency < 0 )
							menuparams->ptConfig.effects[which].transparency = 255  ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
				}
			}
		}
	}

}



void CXBoxSample::doGraphicsFiltering( )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Video Configuration" );
		swprintf( m_menuText[1], L"XBox Hardware Filtering" );
		swprintf( m_menuText[2], L"%S", XBOX_FILTERS[m_xboxHFilter] );
		swprintf( m_menuText[3], L"Software Filter" );
		swprintf( m_menuText[4], L"%S", SOFTWARE_FILTERS[m_xboxSFilter].name );
		swprintf( m_menuText[5], L"Video Mode" );
		swprintf( m_menuText[6], L"%S", VIDEOMODES[m_xboxVidmode].name );

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 4, 0, &m_pnlBackgroundOther, menuChoice, 1, 300 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			if ( menuChoice == 0 )
			{
				doChangeHWFilter() ;
			}
			else if ( menuChoice == 1 )
			{
				doChangeSWFilter() ;
			}
			else
			{
				doChangeVideoMode() ;
			}
		}

	}
}


void CXBoxSample::doChangeHWFilter( )
{
	int menuChoice = 0 ;



	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		swprintf( m_menuText[0], L"XBox Hardware Filters" ) ;

		for ( int i = 0 ; i < NUM_XBOX_FILTERS ; i++ )
		{
			swprintf( m_menuText[i+1], L"%S", XBOX_FILTERS[i] ) ;
		}


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, NUM_XBOX_FILTERS+1, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			m_xboxHFilter = menuChoice ;

			switch ( menuChoice )
			{
				case 0 :
				{
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_POINT);
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_POINT);
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);

					break ; 
				}
				case 1 :
				{
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);
					break ; 
				}
				case 2 :
				{
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR);
					break ;
				}
				case 3 :
				{
					float fBias = -4.0;
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_ANISOTROPIC);
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_ANISOTROPIC);
					//m_pd3dDevice->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_ANISOTROPIC);
					m_pd3dDevice->SetTextureStageState(0, D3DTSS_MAXANISOTROPY, 4);
					break ;
				}
				default : break ;
			}

			break ;
		}


	}

}

void CXBoxSample::doChangeSWFilter( )
{
	int menuChoice = m_xboxSFilter ;



	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		swprintf( m_menuText[0], L"Software Filters" ) ;

		for ( int i = 0 ; i < NUM_SOFTWARE_FILTERS ; i++ )
		{
			swprintf( m_menuText[i+1], L"%S", SOFTWARE_FILTERS[i].name ) ;
		}


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, NUM_SOFTWARE_FILTERS+1, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			m_xboxSFilter = menuChoice ;

			break ;

		}


	}

}

void CXBoxSample::doSelectTransition( )
{
	int menuChoice = m_skin.transition ;



	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		swprintf( m_menuText[0], L"Transition Effect" ) ;

		for ( int i = 0 ; i < NUM_TRANSITION_EFFECTS ; i++ )
		{
			swprintf( m_menuText[i+1], L"%S", TRANSITION_EFFECTS[i].name ) ;
		}


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, NUM_TRANSITION_EFFECTS+1, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			m_skin.transition = menuChoice ;

			break ;

		}


	}

}

void CXBoxSample::doChangeVideoMode( )
{
	int menuChoice = m_xboxVidmode ;



	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		swprintf( m_menuText[0], L"Video Modes" ) ;

		for ( int i = 0 ; i < NUM_VIDEOMODES ; i++ )
		{
			swprintf( m_menuText[i+1], L"%S", VIDEOMODES[i].name ) ;
		}


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, NUM_VIDEOMODES+1, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			DWORD isValid = 1 ;
			DWORD XVidMode = XGetVideoFlags();

			D3DPRESENT_PARAMETERS newpp ;

			memcpy( &newpp, &m_d3dpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;

			switch ( menuChoice )
			{
				case 1 : 
				{
					newpp.Flags = D3DPRESENTFLAG_PROGRESSIVE ;
					if ( ( XVidMode & XC_VIDEO_FLAGS_HDTV_480p ) == 0 )
					{
						popupMsg( "You have not selected 480p as a valid mode from your dashboard.  Aborting", &m_pnlBackgroundOther ) ;
						isValid = 0 ;
					}
					break ;
				}
				case 2 : 
				{
					newpp.Flags = D3DPRESENTFLAG_PROGRESSIVE | D3DPRESENTFLAG_WIDESCREEN ;
					if ( ( XVidMode & XC_VIDEO_FLAGS_HDTV_720p ) == 0 )
					{
						popupMsg( "You have not selected 720p as a valid mode from your dashboard.  Aborting", &m_pnlBackgroundOther ) ;
						isValid = 0 ;
					}
					break ;
				}
				case 3 : 
				{
					newpp.Flags = D3DPRESENTFLAG_WIDESCREEN | D3DPRESENTFLAG_INTERLACED ;
					if ( ( XVidMode & XC_VIDEO_FLAGS_HDTV_1080i ) == 0 )
					{
						popupMsg( "You have not selected 1080i as a valid mode from your dashboard.  Aborting", &m_pnlBackgroundOther ) ;
						isValid = 0 ;
					}
					break ;
				}
				default :
				{
					break ;
				}
			}

			if ( isValid )
			{
				newpp.BackBufferWidth        = VIDEOMODES[menuChoice].width;
				newpp.BackBufferHeight       = VIDEOMODES[menuChoice].height;

				memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;

				m_xboxVidmode = menuChoice ;
				recreate( &m_d3dpp ) ;
				memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;
				m_pd3dDevice->Reset(&newpp);
				memcpy( &m_d3dpp, &newpp, sizeof( D3DPRESENT_PARAMETERS ) ) ;

			}


			break ;

		}


	}

}


void freeTextures()
{
	if ( g_app->m_pnlBackgroundMain.m_pFileBuf != NULL )
	{
		if ( g_app->m_pnlBackgroundMain.m_pTexture != NULL )
		{
			g_app->m_pnlBackgroundMain.m_pTexture->Release() ;
			g_app->m_pnlBackgroundMain.m_pTexture = NULL ;
		}
	}
	if ( g_app->m_pnlBackgroundSelect.m_pFileBuf != NULL )
	{
		if ( g_app->m_pnlBackgroundSelect.m_pTexture != NULL )
		{
			g_app->m_pnlBackgroundSelect.m_pTexture->Release() ;
			g_app->m_pnlBackgroundSelect.m_pTexture = NULL ;
		}
	}
	if ( g_app->m_pnlBackgroundOther.m_pFileBuf != NULL )
	{
		if ( g_app->m_pnlBackgroundOther.m_pTexture != NULL )
		{
			g_app->m_pnlBackgroundOther.m_pTexture->Release() ;
			g_app->m_pnlBackgroundOther.m_pTexture = NULL ;
		}
	}
	if ( g_app->m_pnlSplashEmu.m_pFileBuf != NULL )
	{
		if ( g_app->m_pnlSplashEmu.m_pTexture != NULL )
		{
			g_app->m_pnlSplashEmu.m_pTexture->Release() ;
			g_app->m_pnlSplashEmu.m_pTexture = NULL ;
		}
	}
	if ( g_app->m_pnlSplashGame.m_pFileBuf != NULL )
	{
		if ( g_app->m_pnlSplashGame.m_pTexture != NULL )
		{
			g_app->m_pnlSplashGame.m_pTexture->Release() ;
			g_app->m_pnlSplashGame.m_pTexture = NULL ;
		}
	}
	if ( g_app->m_pnlPopup.m_pFileBuf != NULL )
	{
		if ( g_app->m_pnlPopup.m_pTexture != NULL )
		{
			g_app->m_pnlPopup.m_pTexture->Release() ;
			g_app->m_pnlPopup.m_pTexture = NULL ;
		}
	}

}

void CXBoxSample::doCheatMenu()
{

	int menuChoice = 0 ;
	int numitems ;

	freeTextures() ;

	memcpy( &m_ptConfig, &(m_skin.otherMenu.ptConfig), sizeof(m_ptConfig) ) ;
	SetupPlaything() ;

	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
	//m_pd3dDevice->Reset( &m_d3dpp ) ;

	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu);

	
		swprintf( m_menuText[0], L"In Game Options" );
		swprintf( m_menuText[1], L"Return To Game");
		swprintf( m_menuText[2], L"Exit Game");
		swprintf( m_menuText[3], L"Start Search For Cheat Code");
		swprintf( m_menuText[4], L"Continue Search For Cheat Code");
		swprintf( m_menuText[5], L"List Cheat Codes");
		swprintf( m_menuText[6], L"Configuration");
		swprintf( m_menuText[7], L"Save State %u", m_stateNumber+1);
		swprintf( m_menuText[8], L"Load State %u", m_stateNumber+1);
		swprintf( m_menuText[9], L"Change State %u", m_stateNumber+1);
		swprintf( m_menuText[10], L"Take Screenshot" );
		swprintf( m_menuText[11], L"Start/Stop Recording" );
		swprintf( m_menuText[12], L"Start/Stop Playback" );
		swprintf( m_menuText[13], L"Toggle Screenshot Capture Mode" );

		numitems = addEmuSpecificOptions( 14 ) ;

		swprintf( m_menuText[0], L"In Game Options - %u Options", numitems-1 );

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, numitems, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;

			while(g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_B])
				XBInput_GetInput();

			m_sound.pause( FALSE ) ;
#ifdef NEED_CDDA
			m_cdda.pause(FALSE) ;
#endif
			//m_mp3player.pause( FALSE ) ;
			m_state = IN_GAME ;

			if ( m_bNetplay )
			{
				char result =0 ; 
				m_sockNetplay.Send( &result, 1 ) ;
				m_sockNetplay.Send( &m_emuControllers, sizeof(DWORD)*4 ) ;
				m_sockNetplay.Send( &result, sizeof(DWORD) ) ;

				if ( receiveNetworkData() )
					return  ;
			}
			freeTextures() ;

			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 :
				{
					while(g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_A])
						XBInput_GetInput();

					m_sound.pause( FALSE ) ;
#ifdef NEED_CDDA
					m_cdda.pause(FALSE) ;
#endif
					//m_mp3player.pause( FALSE ) ;
					m_state = IN_GAME ;

					if ( m_bNetplay )
					{
						char result =0 ; 
						m_sockNetplay.Send( &result, 1 ) ;
						m_sockNetplay.Send( &m_emuControllers, sizeof(DWORD)*4 ) ;
						m_sockNetplay.Send( &result, sizeof(DWORD) ) ;

						if ( receiveNetworkData() )
							return  ;
					}

					freeTextures() ;
					break ;
				}
				case 1 :
				{
#ifdef NEED_CDDA
					m_cdda.cleanup() ;
#endif
					//m_mp3player.cleanup() ;
					//cleanupConsole() ;
					m_state = MAIN_MENU ;

					if ( m_bNetplay )
					{
						char result = 1 ; 
						m_sockNetplay.Send( &result, 1 ) ;
						m_sockNetplay.Send( &m_emuControllers, sizeof(DWORD)*4 ) ;
						m_sockNetplay.Send( &result, sizeof(DWORD) ) ;

						if ( receiveNetworkData() )
							return  ;
					}
					freeTextures() ;

					break ;
				}
				case 2 : doStartSearchMenu() ; break ; 
				case 3 : doContinueSearchMenu2() ; break ; 
				case 4 : doCodeListMenu2() ; cht_save() ; break ; 
				case 5 : 
				{
					doConfiguration() ; 
					saveGameSpecificSettings() ;
					break ; 
				}
				case 6 : xboxSaveState() ; popupMsg( global_error_message, &m_pnlBackgroundOther ) ; break ;
				case 7 : xboxLoadState() ; popupMsg( global_error_message, &m_pnlBackgroundOther ) ; break ;
				case 8 : xboxChangeState() ; break ;
				case 9 : xboxScreenshot() ; popupMsg( global_error_message, &m_pnlBackgroundOther ) ; break ;
				case 10 : 
				{
					if ( m_emuRecording )
					{
						xboxStopRecording() ; 
						if ( !m_emuRecording )
						{
							popupMsg( global_error_message, &m_pnlBackgroundOther ) ; 
						}
						else
						{
							popupMsg( "Could not stop recording", &m_pnlBackgroundOther ) ;
						}
					}
					else
					{
						xboxStartRecording() ; 
						if ( m_emuRecording )
						{
							popupMsg( global_error_message, &m_pnlBackgroundOther ) ; 
						}
						else
						{
							popupMsg( "Could not start recording", &m_pnlBackgroundOther ) ;
						}
					}
					break ;
				}
				case 11 : 
				{
					if ( m_emuPlaying )
					{
						xboxStopPlaying() ; 
						if ( !m_emuPlaying )
						{
							popupMsg( global_error_message, &m_pnlBackgroundOther ) ; 
						}
						else
						{
							popupMsg( "Could not stop playing", &m_pnlBackgroundOther ) ;
						}
					}
					else
					{
						xboxStartPlaying() ; 
						if ( m_emuPlaying )
						{
							popupMsg( global_error_message, &m_pnlBackgroundOther ) ; 
						}
						else
						{
							popupMsg( "Could not start playing", &m_pnlBackgroundOther ) ;
						}
					}
					break ;
				}
				case 12 : 
				{
					m_bInCaptureMode = !m_bInCaptureMode ;
					if ( m_bInCaptureMode )
					{
						popupMsg( "Screenshot Capture Mode On", &m_pnlBackgroundOther ) ; 
					}
					else
					{
						popupMsg( "Screenshot Capture Mode Off", &m_pnlBackgroundOther ) ; 
					}
					break ; 
				}
				default : 
				{
					performEmuSpecificOption( 13, menuChoice ) ;
					break ;
				}


			}

			if ( m_state != IN_GAME_PAUSED )
				break ;
		}



	}

	memcpy( &m_ptConfig, &(m_skin.gameSelectMenu.ptConfig), sizeof(m_ptConfig) ) ;
	SetupPlaything() ;

	//m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;
	//m_pd3dDevice->Reset( &m_d3dpp ) ;
}


void CXBoxSample::doCodeListMenu2()
{

	unsigned int selected  ;
	unsigned int cheatTopIdx ;
	int numitems ;
	WCHAR str[400];
	CHEAT_CODE *tempbuf ;
	int codesPerPage ;
	DWORD iTime = 0 ;

	codesPerPage =  m_skin.otherMenu.maxNumLines -3 ;

	if ( codesPerPage < 0 )
		codesPerPage = 1 ;


	selected = cheatTopIdx = 0 ;

#ifdef GAME_GENIE
	m_changedGenie = 0 ;
#endif 

	if ( m_numCheats == 0 )
	{

		while ( 1 )
		{
			pmenuParams = &(m_skin.otherMenu);



#ifdef GAME_GENIE
		
			swprintf( m_menuText[0], L"No Codes in List" );
			swprintf( m_menuText[1], L"Press A to Add a New RAM Code");
			swprintf( m_menuText[2], L"Press X to Add a New Game Genie Code");
			swprintf( m_menuText[3], L"Press B to Cancel");

			renderMenuTextWrapper( 0, 0, m_menuText, 4, 1, &m_pnlBackgroundOther, 0, 0, 0 ) ;
#else
			swprintf( m_menuText[0], L"No Codes in List" );
			swprintf( m_menuText[1], L"Press A to Add a New Code");
			swprintf( m_menuText[2], L"Press B to Cancel");

			renderMenuTextWrapper( 0, 0, m_menuText, 3, 1, &m_pnlBackgroundOther, 0, 0, 0 ) ;
#endif
			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
				XBInput_GetInput();

#ifdef GAME_GENIE
				if ( m_changedGenie )
				{
					popupMsg( "You must relaunch the game for the Game Genie changes to work.", &m_pnlBackgroundOther ) ;

				}
#endif 

				return ;
			}
			else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
			{
				m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

				CHEAT_CODE code ;

				code.adr = 0 ;
				code.val = 0 ;
				code.enabled = 0 ;
				code.desc[0] = 0 ;
				code.type = 0x30 ;
				sprintf( code.code, "30%06.6X %04.4X", code.adr, code.val & 0xFFFF ) ;

				m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

				memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
				m_numCheats++ ;

				break ; 

			}
#ifdef GAME_GENIE
			else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
			{
				m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

				if ( ! addGameGenieCode() )
					break ; 

			}
#endif
		}

	}
	while ( 1 )
	{
		pmenuParams = &(m_skin.otherMenu);

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		D3DXCOLOR d3color( 1.0, 1.0, 1.0, 0.5 ) ;
		//DWORD holdTrans = pmenuParams->panel->m_colDiffuse ;
		//pmenuParams->panel->SetAlpha( (holdTrans>>24) / 2 ) ;
		pmenuParams->panel->Render( 0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		m_pnlGameScreen.SetAlpha( 0x80) ;
		m_pnlGameScreen.Render(m_gameRectSource.left,m_gameRectSource.top,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
		//m_pnlGameScreen.Render(0,0,m_gameRectSource.right,m_gameRectSource.bottom,m_nScreenX ,m_nScreenY, m_nScreenMaxX, m_nScreenMaxY) ;
		m_pnlGameScreen.SetAlpha( 0xFF) ;
		//Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
		//pmenuParams->panel->SetAlpha( (holdTrans>>24)  ) ;

		m_mp3player.process() ;
		m_plaything.Render( 0,0,0 ) ;

		swprintf( m_menuText[0], L"Cheat Code List" );

		numitems = 1 ;

		for ( unsigned int idx = cheatTopIdx ; ( idx < m_numCheats ) && ( idx < cheatTopIdx+codesPerPage) ; idx++ )
		{
			numitems++ ;
			CHEAT_CODE *code = &(m_cheatCodes[idx]) ;

			swprintf( m_menuText[(idx-cheatTopIdx)+1], L"%S Adr:0x%04.4X val:%u %S", code->code, code->adr, code->val, code->enabled ? "ON" : "OFF" ) ;
			
			//if ( selected == idx )
				//m_Font.DrawText( (float)m_nXOffset+32, (float)(MLINE( 8+(idx-cheatTopIdx))), pmenuParams->selectedColor, str, pmenuParams->selectBarColor, 1  );
			//else
				//m_Font.DrawText( (float)m_nXOffset+32, (float)(MLINE( 8+(idx-cheatTopIdx))), pmenuParams->normalColor, str );
		}
		
		swprintf( m_menuText[numitems], L"");
		swprintf( m_menuText[numitems+1], L"%S", m_cheatCodes[selected].desc ) ;

		renderMenuText( 1, selected-cheatTopIdx, m_menuText, numitems+2, 0 ) ;

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
#ifdef GAME_GENIE
			if ( m_changedGenie )
			{
				popupMsg( "You must relaunch the game for the Game Genie changes to work.", &m_pnlBackgroundOther ) ;

			}
#endif 
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			doManageCheatCode( selected ) ;

			if ( selected >= (m_numCheats) )
				selected = m_numCheats - 1 ;

			if ( m_numCheats == 0 )
				break ;
		}

		if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			if ( cheatTopIdx + codesPerPage < m_numCheats )
			{
				cheatTopIdx += codesPerPage ;
				selected = cheatTopIdx ;
				m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT)
		{
			if ( cheatTopIdx >= codesPerPage )
			{
				cheatTopIdx -= codesPerPage ;
				selected = cheatTopIdx ;
				m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( selected == cheatTopIdx + (codesPerPage-1) )
			{
				if ( selected < m_numCheats - 1 )
				{
					cheatTopIdx++ ;
					selected++ ;
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
				}
			}
			else
			{
				if ( selected < m_numCheats-1 )
				{
					selected++ ;
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( selected == cheatTopIdx )
			{
				if ( selected > 0 )
				{
					cheatTopIdx-- ;
					selected-- ;
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
				}
			}
			else
			{
				if ( selected > 0 )
				{
					selected-- ;
					m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
				}
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;


				if ( selected == cheatTopIdx + (codesPerPage-1) )
				{
					if ( selected < m_numCheats - 1 )
					{
						cheatTopIdx++ ;
						selected++ ;
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					}
				}
				else
				{
					if ( selected < m_numCheats-1 )
					{
						selected++ ;
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					}
				}

			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] == 255 )
				iTime = (100*m_scrollSpeed)+1 ;
			else
				iTime += g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] ;

			if ( iTime > 100*m_scrollSpeed )
			{
				iTime -= 100*m_scrollSpeed ;


				if ( selected == cheatTopIdx )
				{
					if ( selected > 0 )
					{
						cheatTopIdx-- ;
						selected-- ;
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					}
				}
				else
				{
					if ( selected > 0 )
					{
						selected-- ;
						m_sfxMenuMove.Play( DSBPLAY_FROMSTART ) ;
					}
				}

			}
		}
	}
}


void CXBoxSample::doManageCheatCode( int selected )
{

	int value ;
	int menuChoice = 0 ;
	int numitems ;

	value = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu);

	
		swprintf( m_menuText[0], L"Manage Cheat Code %S", m_cheatCodes[selected].code  );
		swprintf( m_menuText[1], L"Enable/Disable Code");
		swprintf( m_menuText[2], L"Edit Code" );
		swprintf( m_menuText[3], L"Add New Code" );
		swprintf( m_menuText[4], L"Delete Code" );
		swprintf( m_menuText[5], L"Enter Description" );

#ifdef GAME_GENIE
		swprintf( m_menuText[6], L"Add New Game Genie Code" );

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 7, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
#else
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 6, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
#endif

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			if ( menuChoice == 0 )
			{
				if ( m_cheatCodes[selected].enabled )
					m_cheatCodes[selected].enabled = 0 ;
				else
					m_cheatCodes[selected].enabled = 1 ;
#ifdef GAME_GENIE
				if ( (m_cheatCodes[selected].type & 0xF0 ) == 0x90 )
					m_changedGenie = 1 ;
#endif

				updateEmuSpecificCheats() ;

			}
			else if ( menuChoice == 1 )
			{
				if ( m_cheatCodes[selected].type < 10 )
					doEditCode2( selected, CODE_LENGTHS[m_cheatCodes[selected].type], m_cheatCodes[selected].type ) ;
				else
					doEditCode2( selected, 12, 0 ) ;

				updateEmuSpecificCheats() ;
			}
			else if ( menuChoice == 2 )
			{
				doEditCode2( -1, 12, 0 ) ;
			}
			else if ( menuChoice == 3 )
			{
				CHEAT_CODE *tempbuf ;

#ifdef GAME_GENIE
				if ( (m_cheatCodes[selected].type & 0xF0 ) == 0x90 )
					m_changedGenie = 1 ;
#endif

				tempbuf = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) * ( m_numCheats - 1 ) ) ;

				memcpy( tempbuf, m_cheatCodes, sizeof(CHEAT_CODE) * selected ) ;

				if ( selected < m_numCheats-1 )
				{
					memcpy( &(tempbuf[selected]), &(m_cheatCodes[selected+1]), sizeof(CHEAT_CODE) * ( (m_numCheats - selected ) - 1) ) ;
				}

				free( m_cheatCodes ) ;

				m_cheatCodes = tempbuf ;
				m_numCheats-- ;

				updateEmuSpecificCheats() ;

			}
			else if ( menuChoice == 4 )
			{
				getKeyboardString( m_cheatCodes[selected].desc,100) ;
			}
#ifdef GAME_GENIE
			else if ( menuChoice == 5 )
			{
				if ( addGameGenieCode() )
					doEditCode2( m_numCheats-1, 12,0 ) ;
			}
#endif
			return ;
		}
	}
}

void CXBoxSample::doContinueSearchMenu2()
{

	int value ;
	int offset = 0 ;

	for ( int i = 0 ; i < NUM_MEMORY_LOCATIONS ; i++ )
	{
		if( m_memory_locations[i] )
			memcpy( m_memBuf2+offset, m_memory_locations[i], m_memory_sizes[i] ) ;
		else
			memset( m_memBuf2+offset, 0, m_memory_sizes[i] ) ;

		offset += m_memory_sizes[i] ;
	}

	value = 0 ;

	int menuChoice = 0 ;
	int numitems ;

	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu);

	
		swprintf( m_menuText[0], L"Current Number of Matches = %u", m_currentMemMatches  );
		swprintf( m_menuText[1], L"Search For an Exact Value");
		swprintf( m_menuText[2], L"Search For Values Less Than Before." );
		swprintf( m_menuText[3], L"Search For Values Greater Than before." );
		swprintf( m_menuText[4], L"Search For Values Equal to Before." );
		swprintf( m_menuText[5], L"Search For Values Not Equal to Before." );
		swprintf( m_menuText[6], L"Add the Found Codes to Your List" ) ;

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 7, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			if ( menuChoice == 2 )
			{
				m_currentMemMatches = 0 ;
				for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
				{
					if ( m_memMatches[i] )
						if ( m_memBuf1[i] < m_memBuf2[i] )
						{
							m_memMatches[i] = 1 ;
							m_currentMemMatches++ ;
						}
						else
							m_memMatches[i] = 0 ;
				}

				if ( m_currentMemMatches == 1 )
				{
					doAddFoundCodes2() ;
					break ;
				}
			}
			else if ( menuChoice == 0 )
			{
				value = -1 ;
				value = getValuePopup( "Search Value", value, 0, 255, &m_pnlBackgroundOther ) ; 

				if ( value != -1 )
				{
					m_currentMemMatches = 0 ;
					for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
					{
						if ( m_memMatches[i] )
							if ( m_memBuf2[i] == value )
							{
								m_memMatches[i] = 1 ;
								m_currentMemMatches++ ;
							}
							else
								m_memMatches[i] = 0 ;
					}
					if ( m_currentMemMatches == 1 )
					{
						doAddFoundCodes2() ;
						break ;
					}
				}
			}
			else if ( menuChoice == 1 )
			{
				m_currentMemMatches = 0 ;
				for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
				{
					if ( m_memMatches[i] )
						if ( m_memBuf1[i] > m_memBuf2[i] )
						{
							m_memMatches[i] = 1 ;
							m_currentMemMatches++ ;
						}
						else
							m_memMatches[i] = 0 ;
				}
				if ( m_currentMemMatches == 1 )
				{
					doAddFoundCodes2() ;
					break ;
				}
			}
			else if ( menuChoice == 3 )
			{
				m_currentMemMatches = 0 ;
				for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
				{
					if ( m_memMatches[i] )
						if ( m_memBuf1[i] == m_memBuf2[i] )
						{
							m_memMatches[i] = 1 ;
							m_currentMemMatches++ ;
						}
						else
							m_memMatches[i] = 0 ;
				}
				if ( m_currentMemMatches == 1 )
				{
					doAddFoundCodes2() ;
					break ;
				}
			}
			else if ( menuChoice == 4 )
			{
				m_currentMemMatches = 0 ;
				for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
				{
					if ( m_memMatches[i] )
						if ( m_memBuf1[i] != m_memBuf2[i] )
						{
							m_memMatches[i] = 1 ;
							m_currentMemMatches++ ;
						}
						else
							m_memMatches[i] = 0 ;
				}
				if ( m_currentMemMatches == 1 )
				{
					doAddFoundCodes2() ;
					break ;
				}
			}
			else if ( menuChoice == 5 )
			{
				if ( ( m_currentMemMatches > 0 ) && ( m_currentMemMatches < 11 ) )
				{
					doAddFoundCodes2() ;
					break ;
				}
				else
				{
					while ( 1 )
					{
						swprintf( m_menuText[0], L"Too Many Matches");
						swprintf( m_menuText[1], L"You can only add when you have narrowed");
						swprintf( m_menuText[2], L"the search to 10 or fewer matches." );

						renderMenuTextWrapper( 0, 0, m_menuText, 3, 1, &m_pnlBackgroundOther, 0, 0, 0 ) ;
						

						if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
						{
							m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
							XBInput_GetInput();
							break ;
						}
						else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
						{
							m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
							break ;
						}

					}
				}
			}
		}
	}
	memcpy( m_memBuf1, m_memBuf2, CONSOLE_MEMORY_SIZE ) ;
}


void CXBoxSample::doAddFoundCodes2()
{
	CHEAT_CODE code ;

	for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
	{
		if ( m_memMatches[i] )
		{
			code.adr = i ;
			code.val = m_memBuf1[i] ;
			code.enabled = 0 ;
			code.desc[0] = 0 ;
			code.type = 0x30 ;
			sprintf( code.code, "30%06.6X %04.4X", code.adr, code.val & 0xFFFF ) ;

			m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

			memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
			m_numCheats++ ;

		}
	}

	memset( m_memMatches, 0, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = 0 ;

	while ( 1 )
	{

		swprintf( m_menuText[0], L"Codes Added");
		swprintf( m_menuText[1], L"The search found 1 to 10 possible matches for your search.");
		swprintf( m_menuText[2], L"They have been added to your list." );

		renderMenuTextWrapper( 0, 0, m_menuText, 3, 1, &m_pnlBackgroundOther, 0, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
	}

	cht_save() ;
}

void CXBoxSample::loadControllerSettings( char *szbuf ) 
{
	char setting[30] ;

	for ( int i = 0 ; i < 4 ; i++ )
	{
		char section[20] ;

		sprintf( section, "DEFAULT_CONTROLLER%u", i+1 ) ;

		m_mappings[i].analog_sensitivity = GetIniInt( szbuf, section, "ANALOG_SENSITIVITY", 80 ) ;
		m_mappings[i].sfx_vol_up  = GetIniInt( szbuf, section, "SFX_VOL_UP", XBOX_RTHUMB_UP ) ;
		m_mappings[i].sfx_vol_down  = GetIniInt( szbuf, section, "SFX_VOL_DOWN", XBOX_RTHUMB_DOWN ) ;
		m_mappings[i].bgm_vol_up  = GetIniInt( szbuf, section, "BGM_VOL_UP", XBOX_RTHUMB_RIGHT ) ;
		m_mappings[i].bgm_vol_down  = GetIniInt( szbuf, section, "BGM_VOL_DOWN", XBOX_RTHUMB_LEFT ) ;
		m_mappings[i].throttle  = GetIniInt( szbuf, section, "THROTTLE", XBOX_RIGHT_TRIGGER ) ;
		m_mappings[i].save_state  = GetIniInt( szbuf, section, "SAVE_STATE", XBOX_LEFT_TRIGGER+XBOX_BLACK ) ;
		m_mappings[i].load_state  = GetIniInt( szbuf, section, "LOAD_STATE", XBOX_LEFT_TRIGGER+XBOX_WHITE ) ;
		m_mappings[i].change_save_slot  = GetIniInt( szbuf, section, "CHANGE_SAVE_SLOT", XBOX_LEFT_TRIGGER+XBOX_LTHUMB_LEFT ) ;
		m_mappings[i].screenshot  = GetIniInt( szbuf, section, "SCREENSHOT", XBOX_LEFT_TRIGGER+XBOX_BACK ) ;
		m_mappings[i].options_menu  = GetIniInt( szbuf, section, "OPTIONS_MENU", XBOX_RIGHT_THUMB ) ;
		m_mappings[i].change_gfx_filter = GetIniInt( szbuf, section, "CHANGE_GFX_FILTER", XBOX_LTHUMB_RIGHT+XBOX_RIGHT_TRIGGER ) ;
		m_mappings[i].toggle_bgm = GetIniInt( szbuf, section, "TOGGLE_BGM", 0 ) ;
		m_mappings[i].start_recording = GetIniInt( szbuf, section, "START_RECORDING", 0 ) ;
		m_mappings[i].stop_recording = GetIniInt( szbuf, section, "STOP_RECORDING", 0 ) ;
		m_mappings[i].start_playing = GetIniInt( szbuf, section, "START_PLAYING", 0 ) ;
		m_mappings[i].stop_playing = GetIniInt( szbuf, section, "STOP_PLAYING", 0 ) ;
		m_mappings[i].capture_mode = GetIniInt( szbuf, section, "CAPTURE_MODE", 0 ) ;
		m_mappings[i].virtual_keyboard = GetIniInt( szbuf, section, "VIRTUAL_KEYBOARD", XBOX_LEFT_THUMB ) ;

#ifdef LIGHTGUN
		m_lightgunTarget = GetIniInt( szbuf, section, "LIGHTGUN_TARGET", 1 ) ;
#endif


		m_mappings[i].emu_buttons[0]   = GetIniInt( szbuf, section, "EMU_BUTTON1",  DEFAULT_BUTTON1 ) ;
		m_mappings[i].emu_buttons[1]   = GetIniInt( szbuf, section, "EMU_BUTTON2",  DEFAULT_BUTTON2 ) ;
		m_mappings[i].emu_buttons[2]   = GetIniInt( szbuf, section, "EMU_BUTTON3",  DEFAULT_BUTTON3 ) ;
		m_mappings[i].emu_buttons[3]   = GetIniInt( szbuf, section, "EMU_BUTTON4",  DEFAULT_BUTTON4 ) ;
		m_mappings[i].emu_buttons[4]   = GetIniInt( szbuf, section, "EMU_BUTTON5",  DEFAULT_BUTTON5 ) ;
		m_mappings[i].emu_buttons[5]   = GetIniInt( szbuf, section, "EMU_BUTTON6",  DEFAULT_BUTTON6 ) ;
		m_mappings[i].emu_buttons[6]   = GetIniInt( szbuf, section, "EMU_BUTTON7",  DEFAULT_BUTTON7) ;
		m_mappings[i].emu_buttons[7]   = GetIniInt( szbuf, section, "EMU_BUTTON8",  DEFAULT_BUTTON8) ;
		m_mappings[i].emu_buttons[8]   = GetIniInt( szbuf, section, "EMU_BUTTON9",  DEFAULT_BUTTON9) ;
		m_mappings[i].emu_buttons[9]   = GetIniInt( szbuf, section, "EMU_BUTTON10", DEFAULT_BUTTON10) ;
		m_mappings[i].emu_buttons[10]  = GetIniInt( szbuf, section, "EMU_BUTTON11", DEFAULT_BUTTON11) ;
		m_mappings[i].emu_buttons[11]  = GetIniInt( szbuf, section, "EMU_BUTTON12", DEFAULT_BUTTON12) ;
		m_mappings[i].emu_buttons[12]  = GetIniInt( szbuf, section, "EMU_BUTTON13", DEFAULT_BUTTON13) ;
		m_mappings[i].emu_buttons[13]  = GetIniInt( szbuf, section, "EMU_BUTTON14", DEFAULT_BUTTON14) ;
		m_mappings[i].emu_buttons[14]  = GetIniInt( szbuf, section, "EMU_BUTTON15", DEFAULT_BUTTON15) ;
		m_mappings[i].emu_buttons[15]  = GetIniInt( szbuf, section, "EMU_BUTTON16", DEFAULT_BUTTON16) ;
		m_mappings[i].emu_buttons[16]  = GetIniInt( szbuf, section, "EMU_BUTTON17", DEFAULT_BUTTON17) ;
		m_mappings[i].emu_buttons[17]  = GetIniInt( szbuf, section, "EMU_BUTTON18", DEFAULT_BUTTON18) ;
		m_mappings[i].emu_buttons[18]  = GetIniInt( szbuf, section, "EMU_BUTTON19", DEFAULT_BUTTON19) ;
		m_mappings[i].emu_buttons[19]  = GetIniInt( szbuf, section, "EMU_BUTTON20", DEFAULT_BUTTON20) ;
		m_mappings[i].emu_buttons[20]  = GetIniInt( szbuf, section, "EMU_BUTTON21", DEFAULT_BUTTON21 ) ;
		m_mappings[i].emu_buttons[21]  = GetIniInt( szbuf, section, "EMU_BUTTON22", DEFAULT_BUTTON22 ) ;
		m_mappings[i].emu_buttons[22]  = GetIniInt( szbuf, section, "EMU_BUTTON23", DEFAULT_BUTTON23 ) ;
		m_mappings[i].emu_buttons[23]  = GetIniInt( szbuf, section, "EMU_BUTTON24", DEFAULT_BUTTON24 ) ;
		m_mappings[i].emu_buttons[24]  = GetIniInt( szbuf, section, "EMU_BUTTON25", DEFAULT_BUTTON25) ;
		m_mappings[i].emu_buttons[25]  = GetIniInt( szbuf, section, "EMU_BUTTON26", DEFAULT_BUTTON26) ;
		m_mappings[i].emu_buttons[26]  = GetIniInt( szbuf, section, "EMU_BUTTON27", DEFAULT_BUTTON27) ;
		m_mappings[i].emu_buttons[27]  = GetIniInt( szbuf, section, "EMU_BUTTON28", DEFAULT_BUTTON28) ;
		m_mappings[i].emu_buttons[28]  = GetIniInt( szbuf, section, "EMU_BUTTON29", DEFAULT_BUTTON29) ;
		m_mappings[i].emu_buttons[29]  = GetIniInt( szbuf, section, "EMU_BUTTON30", DEFAULT_BUTTON30) ;
		m_mappings[i].emu_buttons[30]  = GetIniInt( szbuf, section, "EMU_BUTTON31", DEFAULT_BUTTON31) ;
		m_mappings[i].emu_buttons[31]  = GetIniInt( szbuf, section, "EMU_BUTTON32", DEFAULT_BUTTON32) ;

		m_mappings[i].emu_buttons_autofire[0]    = GetIniInt( szbuf, section, "EMU_BUTTON1_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[1]    = GetIniInt( szbuf, section, "EMU_BUTTON2_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[2]    = GetIniInt( szbuf, section, "EMU_BUTTON3_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[3]    = GetIniInt( szbuf, section, "EMU_BUTTON4_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[4]    = GetIniInt( szbuf, section, "EMU_BUTTON5_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[5]    = GetIniInt( szbuf, section, "EMU_BUTTON6_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[6]    = GetIniInt( szbuf, section, "EMU_BUTTON7_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[7]    = GetIniInt( szbuf, section, "EMU_BUTTON8_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[8]    = GetIniInt( szbuf, section, "EMU_BUTTON9_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[9]    = GetIniInt( szbuf, section, "EMU_BUTTON10_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[10]   = GetIniInt( szbuf, section, "EMU_BUTTON11_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[11]   = GetIniInt( szbuf, section, "EMU_BUTTON12_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[12]   = GetIniInt( szbuf, section, "EMU_BUTTON13_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[13]   = GetIniInt( szbuf, section, "EMU_BUTTON14_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[14]   = GetIniInt( szbuf, section, "EMU_BUTTON15_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[15]   = GetIniInt( szbuf, section, "EMU_BUTTON16_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[16]   = GetIniInt( szbuf, section, "EMU_BUTTON17_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[17]   = GetIniInt( szbuf, section, "EMU_BUTTON18_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[18]   = GetIniInt( szbuf, section, "EMU_BUTTON19_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[19]   = GetIniInt( szbuf, section, "EMU_BUTTON20_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[20]   = GetIniInt( szbuf, section, "EMU_BUTTON21_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[21]   = GetIniInt( szbuf, section, "EMU_BUTTON22_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[22]   = GetIniInt( szbuf, section, "EMU_BUTTON23_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[23]   = GetIniInt( szbuf, section, "EMU_BUTTON24_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[24]   = GetIniInt( szbuf, section, "EMU_BUTTON25_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[25]   = GetIniInt( szbuf, section, "EMU_BUTTON26_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[26]   = GetIniInt( szbuf, section, "EMU_BUTTON27_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[27]   = GetIniInt( szbuf, section, "EMU_BUTTON28_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[28]   = GetIniInt( szbuf, section, "EMU_BUTTON29_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[29]   = GetIniInt( szbuf, section, "EMU_BUTTON30_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[30]   = GetIniInt( szbuf, section, "EMU_BUTTON31_AUTOFIRE",  0 ) ;
		m_mappings[i].emu_buttons_autofire[31]   = GetIniInt( szbuf, section, "EMU_BUTTON32_AUTOFIRE",  0 ) ;

		for ( int j = 0 ; j < 32 ; j++ )
		{
			m_mappings[i].emu_buttons_autofire_last[j] = 0 ; 
		}

		m_mappings[i].emu_buttons_definition[0]   = GetIniInt( szbuf, section, "EMU_BUTTON1_DEFINITION",  0 ) ;
		m_mappings[i].emu_buttons_definition[1]   = GetIniInt( szbuf, section, "EMU_BUTTON2_DEFINITION",  1 ) ;
		m_mappings[i].emu_buttons_definition[2]   = GetIniInt( szbuf, section, "EMU_BUTTON3_DEFINITION",  2 ) ;
		m_mappings[i].emu_buttons_definition[3]   = GetIniInt( szbuf, section, "EMU_BUTTON4_DEFINITION",  3 ) ;
		m_mappings[i].emu_buttons_definition[4]   = GetIniInt( szbuf, section, "EMU_BUTTON5_DEFINITION",  4 ) ;
		m_mappings[i].emu_buttons_definition[5]   = GetIniInt( szbuf, section, "EMU_BUTTON6_DEFINITION",  5 ) ;
		m_mappings[i].emu_buttons_definition[6]   = GetIniInt( szbuf, section, "EMU_BUTTON7_DEFINITION",  6 ) ;
		m_mappings[i].emu_buttons_definition[7]   = GetIniInt( szbuf, section, "EMU_BUTTON8_DEFINITION",  7 ) ;
		m_mappings[i].emu_buttons_definition[8]   = GetIniInt( szbuf, section, "EMU_BUTTON9_DEFINITION",  8 ) ;
		m_mappings[i].emu_buttons_definition[9]   = GetIniInt( szbuf, section, "EMU_BUTTON10_DEFINITION", 9 ) ;
		m_mappings[i].emu_buttons_definition[10]  = GetIniInt( szbuf, section, "EMU_BUTTON11_DEFINITION", 10 ) ;
		m_mappings[i].emu_buttons_definition[11]  = GetIniInt( szbuf, section, "EMU_BUTTON12_DEFINITION", 11 ) ;
		m_mappings[i].emu_buttons_definition[12]  = GetIniInt( szbuf, section, "EMU_BUTTON13_DEFINITION", 12 ) ;
		m_mappings[i].emu_buttons_definition[13]  = GetIniInt( szbuf, section, "EMU_BUTTON14_DEFINITION", 13 ) ;
		m_mappings[i].emu_buttons_definition[14]  = GetIniInt( szbuf, section, "EMU_BUTTON15_DEFINITION", 14 ) ;
		m_mappings[i].emu_buttons_definition[15]  = GetIniInt( szbuf, section, "EMU_BUTTON16_DEFINITION", 15 ) ;
		m_mappings[i].emu_buttons_definition[16]  = GetIniInt( szbuf, section, "EMU_BUTTON17_DEFINITION", 16 ) ;
		m_mappings[i].emu_buttons_definition[17]  = GetIniInt( szbuf, section, "EMU_BUTTON18_DEFINITION", 17 ) ;
		m_mappings[i].emu_buttons_definition[18]  = GetIniInt( szbuf, section, "EMU_BUTTON19_DEFINITION", 18 ) ;
		m_mappings[i].emu_buttons_definition[19]  = GetIniInt( szbuf, section, "EMU_BUTTON20_DEFINITION", 19 ) ;
		m_mappings[i].emu_buttons_definition[20]  = GetIniInt( szbuf, section, "EMU_BUTTON21_DEFINITION", 20 ) ;
		m_mappings[i].emu_buttons_definition[21]  = GetIniInt( szbuf, section, "EMU_BUTTON22_DEFINITION", 21 ) ;
		m_mappings[i].emu_buttons_definition[22]  = GetIniInt( szbuf, section, "EMU_BUTTON23_DEFINITION", 22 ) ;
		m_mappings[i].emu_buttons_definition[23]  = GetIniInt( szbuf, section, "EMU_BUTTON24_DEFINITION", 23 ) ;
		m_mappings[i].emu_buttons_definition[24]  = GetIniInt( szbuf, section, "EMU_BUTTON25_DEFINITION", 24 ) ;
		m_mappings[i].emu_buttons_definition[25]  = GetIniInt( szbuf, section, "EMU_BUTTON26_DEFINITION", 25 ) ;
		m_mappings[i].emu_buttons_definition[26]  = GetIniInt( szbuf, section, "EMU_BUTTON27_DEFINITION", 26 ) ;
		m_mappings[i].emu_buttons_definition[27]  = GetIniInt( szbuf, section, "EMU_BUTTON28_DEFINITION", 27 ) ;
		m_mappings[i].emu_buttons_definition[28]  = GetIniInt( szbuf, section, "EMU_BUTTON29_DEFINITION", 28 ) ;
		m_mappings[i].emu_buttons_definition[29]  = GetIniInt( szbuf, section, "EMU_BUTTON30_DEFINITION", 29 ) ;
		m_mappings[i].emu_buttons_definition[30]  = GetIniInt( szbuf, section, "EMU_BUTTON31_DEFINITION", 30 ) ;
		m_mappings[i].emu_buttons_definition[31]  = GetIniInt( szbuf, section, "EMU_BUTTON32_DEFINITION", 31 ) ;

		for ( int j = 0 ; j < 32 ; j++ )
		{
			if ( m_mappings[i].emu_buttons_definition[j] > NUM_EMU_BUTTONS-1 )
				m_mappings[i].emu_buttons_definition[j] = NUM_EMU_BUTTONS-1 ;
		}

		for ( int j = 0 ; j < 10 ; j++ )
		{
			sprintf( setting, "COMBO%u_MAPPING", j+1 ) ;

			m_mappings[i].combos[j].mapping  = GetIniInt( szbuf, section, setting, 0 ) ;

			sprintf( setting, "COMBO%u_ENDMOVE", j+1 ) ;

			m_mappings[i].combos[j].endmove  = GetIniInt( szbuf, section, setting, 0 ) ;

			sprintf( setting, "COMBO%u_DELAY", j+1 ) ;

			m_mappings[i].combos[j].delay  = GetIniInt( szbuf, section, setting, 0 ) ;

			m_mappings[i].combos[j].currmove = 0 ;
			m_mappings[i].combos[j].currdelay = 0 ;

			for ( int k = 0 ; k < 32 ; k++ )
			{
				sprintf( setting, "COMBO%u_MOVE%u", j+1, k+1 ) ;

				m_mappings[i].combos[j].moves[k]  = GetIniInt( szbuf, section, setting, 0 ) ;
			}
		}

	}
}

void CXBoxSample::saveControllerSettings( FILE *infile ) 
{
	for ( int i = 0 ; i < 4 ; i++ )
	{
		char section[20] ;

		fprintf( infile, "[DEFAULT_CONTROLLER%u]\r\n", i+1 ) ;

		fprintf( infile, "ANALOG_SENSITIVITY=%u\r\n", m_mappings[i].analog_sensitivity ) ;
		fprintf( infile, "SFX_VOL_UP=%u\r\n", m_mappings[i].sfx_vol_up) ;
		fprintf( infile, "SFX_VOL_DOWN=%u\r\n", m_mappings[i].sfx_vol_down) ;
		fprintf( infile, "BGM_VOL_UP=%u\r\n", m_mappings[i].bgm_vol_up) ;
		fprintf( infile, "BGM_VOL_DOWN=%u\r\n", m_mappings[i].bgm_vol_down) ;
		fprintf( infile, "THROTTLE=%u\r\n", m_mappings[i].throttle) ;
		fprintf( infile, "SAVE_STATE=%u\r\n", m_mappings[i].save_state) ;
		fprintf( infile, "LOAD_STATE=%u\r\n", m_mappings[i].load_state) ;
		fprintf( infile, "CHANGE_SAVE_SLOT=%u\r\n", m_mappings[i].change_save_slot) ;
		fprintf( infile, "SCREENSHOT=%u\r\n", m_mappings[i].screenshot) ;
		fprintf( infile, "OPTIONS_MENU=%u\r\n", m_mappings[i].options_menu) ;
		fprintf( infile, "CHANGE_GFX_FILTER=%u\r\n", m_mappings[i].change_gfx_filter ) ;
		fprintf( infile, "TOGGLE_BGM=%u\r\n", m_mappings[i].toggle_bgm ) ;
		fprintf( infile, "START_RECORDING=%u\r\n", m_mappings[i].start_recording ) ;
		fprintf( infile, "STOP_RECORDING=%u\r\n", m_mappings[i].stop_recording ) ;
		fprintf( infile, "START_PLAYING=%u\r\n", m_mappings[i].start_playing ) ;
		fprintf( infile, "STOP_PLAYING=%u\r\n", m_mappings[i].stop_playing ) ;
		fprintf( infile, "CAPTURE_MODE=%u\r\n", m_mappings[i].capture_mode ) ;
		fprintf( infile, "VIRTUAL_KEYBOARD=%u\r\n", m_mappings[i].virtual_keyboard ) ;

#ifdef LIGHTGUN
		fprintf( infile, "LIGHTGUN_TARGET=%u\r\n", m_lightgunTarget ) ;
#endif

		fprintf( infile, "\r\n" ) ;

		for ( int j = 0 ; j < 32 ; j++ )
		{
			fprintf( infile, "EMU_BUTTON%u=%u\r\n", j+1, m_mappings[i].emu_buttons[j] ) ;
		}

		fprintf( infile, "\r\n" ) ;

		for ( int j = 0 ; j < 32 ; j++ )
		{
			fprintf( infile, "EMU_BUTTON%u_DEFINITION=%u\r\n", j+1, m_mappings[i].emu_buttons_definition[j] ) ;
		}

		fprintf( infile, "\r\n" ) ;

		for ( int j = 0 ; j < 32 ; j++ )
		{
			fprintf( infile, "EMU_BUTTON%u_AUTOFIRE=%u\r\n", j+1, m_mappings[i].emu_buttons_autofire[j] ) ;
		}

		fprintf( infile, "\r\n" ) ;


		for ( int j = 0 ; j < 10 ; j++ )
		{
			fprintf( infile, "COMBO%u_MAPPING=%u\r\n", j+1, m_mappings[i].combos[j].mapping ) ;
			fprintf( infile, "COMBO%u_ENDMOVE=%u\r\n", j+1, m_mappings[i].combos[j].endmove) ;
			fprintf( infile, "COMBO%u_DELAY=%u\r\n", j+1, m_mappings[i].combos[j].delay) ;

			for ( int k = 0 ; k < 32 ; k++ )
			{
				fprintf( infile, "COMBO%u_MOVE%u=%u\r\n", j+1, k+1, m_mappings[i].combos[j].moves[k] ) ;
			}
			fprintf( infile, "\r\n" ) ;
		}

	}
}


void CXBoxSample::doConfigureSprite( MENU_PARAMS *menuparams, int which)
{
	int fResult ;
	char xmsg[100] ;
	int menuChoice = 0 ;
	int bdone ;
	WCHAR msg[200] ;
	float mx, my ;
	int shoot ;
	DWORD mtime ;

	mtime = GetTickCount() ;


	bdone = 0 ;


	while ( 1 )
	{

		pmenuParams = menuparams ;

		swprintf( m_menuText[0], L"Configure Sprite %u", which+1 );
		swprintf( m_menuText[1], L"Sprite Graphic" );
		swprintf( m_menuText[2], L"" );
		swprintf( m_menuText[3], L"Offset X" );
		swprintf( m_menuText[4], L"%3.2f", menuparams->ptConfig.sprites[which].offsetX );
		swprintf( m_menuText[5], L"Offset Y" );
		swprintf( m_menuText[6], L"%3.2f", menuparams->ptConfig.sprites[which].offsetY  );
		swprintf( m_menuText[7], L"Frame Speed" );
		swprintf( m_menuText[8], L"%u", menuparams->ptConfig.sprites[which].framespeed);
		swprintf( m_menuText[9], L"Transparency" );
		swprintf( m_menuText[10], L"%u", menuparams->ptConfig.sprites[which].transparency );
		swprintf( m_menuText[11], L"Scale" );
		swprintf( m_menuText[12], L"%2.1f", menuparams->ptConfig.sprites[which].scale  );
		swprintf( m_menuText[13], L"Flip Horizontally" );
		swprintf( m_menuText[14], L"%u", menuparams->ptConfig.sprites[which].flipH  );
		swprintf( m_menuText[15], L"Flip Vertically" );
		swprintf( m_menuText[16], L"%u", menuparams->ptConfig.sprites[which].flipV  );
		swprintf( m_menuText[17], L"Loop Animation?" );
		swprintf( m_menuText[18], L"%S", menuparams->ptConfig.sprites[which].loopOnce ? "No" : "Yes"  );
		swprintf( m_menuText[19], L"Motion X" );
		swprintf( m_menuText[20], L"%1.3f", menuparams->ptConfig.sprites[which].motionX );
		swprintf( m_menuText[21], L"Motion Y" );
		swprintf( m_menuText[22], L"%1.3f", menuparams->ptConfig.sprites[which].motionY  );
		swprintf( m_menuText[23], L"When Hit Wall Rotate" );
		swprintf( m_menuText[24], L"%u", menuparams->ptConfig.sprites[which].rotate  );
		swprintf( m_menuText[25], L"Top Boundary" );
		swprintf( m_menuText[26], L"%u", menuparams->ptConfig.sprites[which].rect_t  );
		swprintf( m_menuText[27], L"Bottom Boundary" );
		swprintf( m_menuText[28], L"%u", menuparams->ptConfig.sprites[which].rect_b  );
		swprintf( m_menuText[29], L"Left Boundary" );
		swprintf( m_menuText[30], L"%u", menuparams->ptConfig.sprites[which].rect_l  );
		swprintf( m_menuText[31], L"Right Boundary" );
		swprintf( m_menuText[32], L"%u", menuparams->ptConfig.sprites[which].rect_r  );


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 17, 0, menuparams->panel, menuChoice, 1, 300 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			//m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			switch ( menuChoice )
			{
				case 0 :
				{
					sprintfx( "change sprite %d %d\r\n", menuparams->ptConfig.sprites[which].sprite,m_plaything.m_spritedefs.GetSize() ) ;
					menuparams->ptConfig.sprites[which].sprite++ ;
					
					if ( menuparams->ptConfig.sprites[which].sprite >= m_plaything.m_spritedefs.GetSize() )
					{
						menuparams->ptConfig.sprites[which].sprite = -1 ;
					}

					sprintfx( "change sprite %d %d\r\n", menuparams->ptConfig.sprites[which].sprite,m_plaything.m_spritedefs.GetSize() ) ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 1:
				{
					menuparams->ptConfig.sprites[which].offsetX += 1.0f ;
					if ( menuparams->ptConfig.sprites[which].offsetX > 640.0f )
						menuparams->ptConfig.sprites[which].offsetX -= 690.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 2:
				{
					menuparams->ptConfig.sprites[which].offsetY += 1.0f ;
					if ( menuparams->ptConfig.sprites[which].offsetY > 480.0f )
						menuparams->ptConfig.sprites[which].offsetY -= 530.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 3:
				{
					menuparams->ptConfig.sprites[which].framespeed += 1.0f ;
					if ( menuparams->ptConfig.sprites[which].framespeed > 100.0f )
						menuparams->ptConfig.sprites[which].framespeed = 1.0f ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 4:
				{
					menuparams->ptConfig.sprites[which].transparency+= 1 ;
					if ( menuparams->ptConfig.sprites[which].transparency > 255 )
						menuparams->ptConfig.sprites[which].transparency = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 5:
				{
					menuparams->ptConfig.sprites[which].scale += 0.1f ;
					if ( menuparams->ptConfig.sprites[which].scale > 30 )
						menuparams->ptConfig.sprites[which].scale = 0.3f ; ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 6:
				{
					menuparams->ptConfig.sprites[which].flipH = !menuparams->ptConfig.sprites[which].flipH  ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 7:
				{
					menuparams->ptConfig.sprites[which].flipV = !menuparams->ptConfig.sprites[which].flipV  ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 8:
				{
					menuparams->ptConfig.sprites[which].loopOnce = !menuparams->ptConfig.sprites[which].loopOnce  ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 9:
				{
					menuparams->ptConfig.sprites[which].motionX += 0.001f ;
					if ( menuparams->ptConfig.sprites[which].motionX > 10 )
						menuparams->ptConfig.sprites[which].motionX = -10.0f ;

					if ( ( menuparams->ptConfig.sprites[which].motionX > -0.001 ) &&
						( menuparams->ptConfig.sprites[which].motionX < 0.001 ) )
						menuparams->ptConfig.sprites[which].motionX = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 10:
				{
					menuparams->ptConfig.sprites[which].motionY += 0.001f ;
					if ( menuparams->ptConfig.sprites[which].motionY > 10 )
						menuparams->ptConfig.sprites[which].motionY = -10.0f ;

					if ( ( menuparams->ptConfig.sprites[which].motionY > -0.001 ) &&
						( menuparams->ptConfig.sprites[which].motionY < 0.001 ) )
						menuparams->ptConfig.sprites[which].motionY = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 11:
				{
					menuparams->ptConfig.sprites[which].rotate += 1 ;
					if ( menuparams->ptConfig.sprites[which].rotate > 359 )
						menuparams->ptConfig.sprites[which].rotate = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 12:
				{
					menuparams->ptConfig.sprites[which].rect_t += 1.0f ;
					if ( menuparams->ptConfig.sprites[which].rect_t> 480 )
						menuparams->ptConfig.sprites[which].rect_t = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 13:
				{
					menuparams->ptConfig.sprites[which].rect_b += 1.0f ;
					if ( menuparams->ptConfig.sprites[which].rect_b> 480 )
						menuparams->ptConfig.sprites[which].rect_b = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 14:
				{
					menuparams->ptConfig.sprites[which].rect_l += 1.0f ;
					if ( menuparams->ptConfig.sprites[which].rect_l> 640 )
						menuparams->ptConfig.sprites[which].rect_l = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 15:
				{
					menuparams->ptConfig.sprites[which].rect_r += 1.0f ;
					if ( menuparams->ptConfig.sprites[which].rect_r> 640 )
						menuparams->ptConfig.sprites[which].rect_r = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
		{
			switch ( menuChoice )
			{
				case 0 :
				{
					menuparams->ptConfig.sprites[which].sprite-- ;
					
					if ( menuparams->ptConfig.sprites[which].sprite < -1 ) 
					{
						menuparams->ptConfig.sprites[which].sprite = m_plaything.m_spritedefs.GetSize()-1 ;
					}

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 1:
				{
					menuparams->ptConfig.sprites[which].offsetX -= 1.0f ;
					if ( menuparams->ptConfig.sprites[which].offsetX < -50.0f )
						menuparams->ptConfig.sprites[which].offsetX += 690.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 2:
				{
					menuparams->ptConfig.sprites[which].offsetY -= 1.0f ;
					if ( menuparams->ptConfig.sprites[which].offsetY < -50.0f )
						menuparams->ptConfig.sprites[which].offsetY += 530.0f ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 3:
				{
					menuparams->ptConfig.sprites[which].framespeed -= 1.0f ;
					if ( menuparams->ptConfig.sprites[which].framespeed < 1.0f )
						menuparams->ptConfig.sprites[which].framespeed += 99.0f ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 4:
				{
					if ( menuparams->ptConfig.sprites[which].transparency == 0 )
						menuparams->ptConfig.sprites[which].transparency = 255 ;
					else
						menuparams->ptConfig.sprites[which].transparency-- ;
					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 5 :
				{
					menuparams->ptConfig.sprites[which].scale -= 0.1f ;
					if ( menuparams->ptConfig.sprites[which].scale < 0.3f )
						menuparams->ptConfig.sprites[which].scale = 30.0f ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 6:
				{
					menuparams->ptConfig.sprites[which].flipH = !menuparams->ptConfig.sprites[which].flipH  ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 7:
				{
					menuparams->ptConfig.sprites[which].flipV = !menuparams->ptConfig.sprites[which].flipV  ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 8:
				{
					menuparams->ptConfig.sprites[which].loopOnce = !menuparams->ptConfig.sprites[which].loopOnce  ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 9:
				{
					menuparams->ptConfig.sprites[which].motionX -= 0.001f ;
					if ( menuparams->ptConfig.sprites[which].motionX < -10.0 )
						menuparams->ptConfig.sprites[which].motionX = 10.0 ;

					if ( ( menuparams->ptConfig.sprites[which].motionX > -0.001 ) &&
						( menuparams->ptConfig.sprites[which].motionX < 0.001 ) )
						menuparams->ptConfig.sprites[which].motionX = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 10:
				{
					menuparams->ptConfig.sprites[which].motionY -= 0.001f ;
					if ( menuparams->ptConfig.sprites[which].motionY < -10.0 )
						menuparams->ptConfig.sprites[which].motionY = 10.0f ;

					if ( ( menuparams->ptConfig.sprites[which].motionY > -0.001 ) &&
						( menuparams->ptConfig.sprites[which].motionY < 0.001 ) )
						menuparams->ptConfig.sprites[which].motionY = 0 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 11:
				{
					menuparams->ptConfig.sprites[which].rotate -= 1 ;
					if ( menuparams->ptConfig.sprites[which].rotate < 0  )
						menuparams->ptConfig.sprites[which].rotate = 359 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 12:
				{
					menuparams->ptConfig.sprites[which].rect_t -= 1.0f ;
					if ( menuparams->ptConfig.sprites[which].rect_t < 0  )
						menuparams->ptConfig.sprites[which].rect_t = 480 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 13:
				{
					menuparams->ptConfig.sprites[which].rect_b -= 1.0f ;
					if ( menuparams->ptConfig.sprites[which].rect_b < 0  )
						menuparams->ptConfig.sprites[which].rect_b = 480 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 14:
				{
					menuparams->ptConfig.sprites[which].rect_l -= 1.0f ;
					if ( menuparams->ptConfig.sprites[which].rect_l < 0 )
						menuparams->ptConfig.sprites[which].rect_l = 640 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
				case 15:
				{
					menuparams->ptConfig.sprites[which].rect_r -= 1.0f ;
					if ( menuparams->ptConfig.sprites[which].rect_r < 0 )
						menuparams->ptConfig.sprites[which].rect_r = 640 ;

					memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
					SetupPlaything() ;
					break ;
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].fX2 > 0 )
		{
			float fval ;

			if ( GetTickCount() - mtime > 5 )
			{
				mtime = GetTickCount() ;
				fval = g_Gamepads[0].fX2 / 10.0f;
				switch ( menuChoice )
				{
					case 1:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].offsetX += fval ;
						if ( menuparams->ptConfig.sprites[which].offsetX > 640.0f )
							menuparams->ptConfig.sprites[which].offsetX -= 690.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 2:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].offsetY += fval ;
						if ( menuparams->ptConfig.sprites[which].offsetY > 480.0f )
							menuparams->ptConfig.sprites[which].offsetY -= 530.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 3:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].framespeed += fval ;
						if ( menuparams->ptConfig.sprites[which].framespeed > 100 )
							menuparams->ptConfig.sprites[which].framespeed = 1 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 4:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].transparency += fval ;
						if ( menuparams->ptConfig.sprites[which].transparency > 255 )
							menuparams->ptConfig.sprites[which].transparency = 0 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 5:
					{
						menuparams->ptConfig.sprites[which].scale+= fval ;
						if ( menuparams->ptConfig.sprites[which].scale > 30.0f )
							menuparams->ptConfig.sprites[which].scale = 0.3f ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 9:
					{
						fval /= 100.0f ;
						menuparams->ptConfig.sprites[which].motionX += fval ;
						if ( menuparams->ptConfig.sprites[which].motionX > 10 )
							menuparams->ptConfig.sprites[which].motionX = -10.0f ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 10:
					{
						fval /= 100.0f ;
						menuparams->ptConfig.sprites[which].motionY += fval ;
						if ( menuparams->ptConfig.sprites[which].motionY > 10 )
							menuparams->ptConfig.sprites[which].motionY = -10.0f ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 11:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rotate += fval ;
						if ( menuparams->ptConfig.sprites[which].rotate > 359 )
							menuparams->ptConfig.sprites[which].rotate = 0 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 12:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rect_t += fval ;
						if ( menuparams->ptConfig.sprites[which].rect_t> 480 )
							menuparams->ptConfig.sprites[which].rect_t = 0 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 13:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rect_b += fval ;
						if ( menuparams->ptConfig.sprites[which].rect_b> 480 )
							menuparams->ptConfig.sprites[which].rect_b = 0 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 14:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rect_l += fval ;
						if ( menuparams->ptConfig.sprites[which].rect_l> 640 )
							menuparams->ptConfig.sprites[which].rect_l = 0 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 15:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rect_r += fval ;
						if ( menuparams->ptConfig.sprites[which].rect_r> 640 )
							menuparams->ptConfig.sprites[which].rect_r = 0 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
				}
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].fX2 < 0 )
		{
			float fval ;

			if ( GetTickCount() - mtime > 5 )
			{
				mtime = GetTickCount() ;
				fval = g_Gamepads[0].fX2*-1.0f / 10.0f;

				switch ( menuChoice )
				{
					case 1:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].offsetX -= fval ;
						if ( menuparams->ptConfig.sprites[which].offsetX < -50.0f )
							menuparams->ptConfig.sprites[which].offsetX += 690.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 2:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].offsetY -= fval ;
						if ( menuparams->ptConfig.sprites[which].offsetY < -50.0f )
							menuparams->ptConfig.sprites[which].offsetY += 530.0f ;
						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 3:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].framespeed -= fval ;
						if ( menuparams->ptConfig.sprites[which].framespeed < 1 )
							menuparams->ptConfig.sprites[which].framespeed = 100 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 4:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].transparency-= fval ;
						if ( menuparams->ptConfig.sprites[which].transparency < 0 )
							menuparams->ptConfig.sprites[which].transparency = 255 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 5:
					{
						menuparams->ptConfig.sprites[which].scale -= fval ;
						if ( menuparams->ptConfig.sprites[which].scale < 0.3f )
							menuparams->ptConfig.sprites[which].scale = 30.0f ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 9:
					{
						fval /= 100.0f ;
						menuparams->ptConfig.sprites[which].motionX -= fval ;
						if ( menuparams->ptConfig.sprites[which].motionX < -10.0 )
							menuparams->ptConfig.sprites[which].motionX = 10.0 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 10:
					{
						fval /= 100.0f ;
						menuparams->ptConfig.sprites[which].motionY -= fval ;
						if ( menuparams->ptConfig.sprites[which].motionY < -10.0 )
							menuparams->ptConfig.sprites[which].motionY = 10.0f ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 11:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rotate -= fval ;
						if ( menuparams->ptConfig.sprites[which].rotate < 0  )
							menuparams->ptConfig.sprites[which].rotate = 359 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 12:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rect_t -= fval ;
						if ( menuparams->ptConfig.sprites[which].rect_t < 0  )
							menuparams->ptConfig.sprites[which].rect_t = 480 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 13:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rect_b -= fval ;
						if ( menuparams->ptConfig.sprites[which].rect_b < 0  )
							menuparams->ptConfig.sprites[which].rect_b = 480 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 14:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rect_l -= fval ;
						if ( menuparams->ptConfig.sprites[which].rect_l < 0 )
							menuparams->ptConfig.sprites[which].rect_l = 640 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
					case 15:
					{
						fval *= 10.0f;
						menuparams->ptConfig.sprites[which].rect_r -= fval ;
						if ( menuparams->ptConfig.sprites[which].rect_r < 0 )
							menuparams->ptConfig.sprites[which].rect_r = 640 ;

						memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
						SetupPlaything() ;
						break ;
					}
				}
			}
		}
	}
}







void CXBoxSample::doMenuTextSettings( MENU_PARAMS *menuparams )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = menuparams ;

	
		swprintf( m_menuText[0], L"Menu Text Settings" );
		swprintf( m_menuText[1], L"Horizontal Alignment");
		swprintf( m_menuText[2], L"Vertical Alignment");
		swprintf( m_menuText[3], L"Offset X");
		swprintf( m_menuText[4], L"Offset Y");
		swprintf( m_menuText[5], L"Max Text Width");
		swprintf( m_menuText[6], L"Number Of Lines Per Page");
		swprintf( m_menuText[7], L"Font Size");
		swprintf( m_menuText[8], L"Line Height");
		swprintf( m_menuText[9], L"Normal Color");
		swprintf( m_menuText[10], L"Selected Color");
		swprintf( m_menuText[11], L"Noted Color");
		swprintf( m_menuText[12], L"Selected and Noted Color");
		swprintf( m_menuText[13], L"Select Bar Color");
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 14, 0, menuparams->panel, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				{
					menuparams->halign= getValuePopup( "Horizontal Alignment", menuparams->halign, 0, 2, menuparams->panel ) ; 
					break ;
				}
				case 1 : 
				{
					menuparams->valign= getValuePopup( "Vertical Alignment", menuparams->valign, 0, 2, menuparams->panel ) ; 
					break ;
				}
				case 2 : 
				{
					menuparams->offsetx= getValuePopup( "Offset X", menuparams->offsetx, -640, 640, menuparams->panel ) ; 
					break ;
				}
				case 3 : 
				{
					menuparams->offsety= getValuePopup( "Offset Y", menuparams->offsety, -480, 480, menuparams->panel ) ; 
					break ;
				}
				case 4 : 
				{
					menuparams->maxTextWidth= getValuePopup( "Max Text Width", menuparams->maxTextWidth, 0, 640, menuparams->panel ) ; 
					break ;
				}
				case 5 : 
				{
					menuparams->maxNumLines= getValuePopup( "Number of Lines Per Page", menuparams->maxNumLines, 1, 50, menuparams->panel ) ; 
					break ;
				}
				case 6 : 
				{
					menuparams->size= getValuePopup( "Font Size", menuparams->size, 5, 100, menuparams->panel ) ; 
					break ;
				}
				case 7 : 
				{
					menuparams->lineHeight = getValuePopup( "Line Height", menuparams->lineHeight, 5, 100, menuparams->panel ) ; 
					break ;
				}
				case 8 : 
				{
					doSelectColor( &menuparams->normalColor, menuparams ) ;
					break ;
				}
				case 9 : 
				{
					doSelectColor( &menuparams->selectedColor, menuparams ) ;
					break ;
				}
				case 10 : 
				{
					doSelectColor( &menuparams->notedColor, menuparams ) ;
					break ;
				}
				case 11 : 
				{
					doSelectColor( &menuparams->selectedAndNotedColor, menuparams ) ;
					break ;
				}
				case 12 : 
				{
					doSelectColor( &menuparams->selectBarColor, menuparams ) ;
					break ;
				}
				default : break ;
			}
		}


	}
}

void CXBoxSample::doConfigureSkinMenu( MENU_PARAMS *menuparams, char *title )
{
	int menuChoice = 0 ;

	memcpy( &m_ptConfig, &(menuparams->ptConfig), sizeof(m_ptConfig) ) ;
	SetupPlaything() ;

	while ( 1 )
	{

		pmenuParams = menuparams ;

	
		swprintf( m_menuText[0], L"%S", title );
		swprintf( m_menuText[1], L"Background Settings");
		swprintf( m_menuText[2], L"Text Settings");
		swprintf( m_menuText[3], L"Sprite Settings");
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 4, 0, menuparams->panel, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : doMenuBackgroundSettings( menuparams ) ; break ; 
				case 1 : doMenuTextSettings( menuparams ) ; break ; 
				case 2 : doMenuSpriteSettings( menuparams ) ; break ; 
				default : break ;
			}
		}


	}

	memcpy( &m_ptConfig, &(m_skin.otherMenu.ptConfig), sizeof(m_ptConfig) ) ;
	SetupPlaything() ;
}

void overwriteKeyfiles()
{
	char tmpkeyname[20] ;
	char dir[MAX_PATH] ;
	char destfile[500] ;
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	int curr ;

	strcpy( tmpkeyname, "Z:\\tmpkeys.key" ) ;

	g_app->saveKeys( tmpkeyname ) ;

	strcpy( dir, g_app->g_savePath ) ;
	strcat( dir, "\\*.key" ) ;

	hFind = FindFirstFile( dir, &oFindData);

	if (hFind == INVALID_HANDLE_VALUE)
	{
		return;
	}
	

	do
	{
		

		sprintf( destfile, "%s\\%s", g_app->g_savePath, oFindData.cFileName ) ;

		CopyFile( tmpkeyname, destfile, FALSE ) ;
	} while( FindNextFile(hFind, &oFindData) );


	FindClose( hFind );







}

void CXBoxSample::doConfigureControllers()
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Select Controller" );
		swprintf( m_menuText[1], L"Controller 1" );
		swprintf( m_menuText[2], L"Controller 2" );
		swprintf( m_menuText[3], L"Controller 3" );
		swprintf( m_menuText[4], L"Controller 4" );
		swprintf( m_menuText[5], L"Copy Configuration" );

#ifdef LIGHTGUN
		swprintf( m_menuText[6], L"Configure Light Gun" );
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 7, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
#else
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 6, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
#endif

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				case 1 : 
				case 2 : 
				case 3 : 
				{
					doConfigureController( menuChoice ) ;
					break ;
				}
				case 4 : 
				{
					int src = -1 ;
					int dst = -1 ;

					src = getValuePopup( "Copy Configuration From Controller #", src, 1, 4, &m_pnlBackgroundOther ) ; 

					if ( src > 0 )
					{
						dst = getValuePopup( "To Controller #", dst, 1, 4, &m_pnlBackgroundOther ) ; 

						if ( dst > 0 )
						{
							memcpy( &m_mappings[dst-1], &m_mappings[src-1], sizeof( MAPPINGS ) ) ;
						}
					}

					break ;
				}
#ifdef LIGHTGUN
				case 5 :
				{
					doConfigureLightgun() ;
					break ;
				}
#endif
				default : break ;
			}
		}


	}

	if ( m_state == MAIN_MENU )
	{
		menuChoice = 3 ;
		int textheight ;
		int textwidth ;
		int newChoice ;


		pmenuParams = &(m_skin.popupMenu) ;

		while ( 1 )
		{

			swprintf( m_menuText[0], L"Do you want to use these settings globally?" ) ;
			swprintf( m_menuText[1], L"Selecting Yes will overwrite all existing" ) ;
			swprintf( m_menuText[2], L"controller settings for all games." ) ;
			swprintf( m_menuText[3], L"Yes" ) ;
			swprintf( m_menuText[4], L"No" ) ;

			menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 5, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;

			if ( menuChoice != 3 )
				menuChoice = 2 ;


			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
				XBInput_GetInput();
				return  ;
			}
			else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
			{
				m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

				if ( menuChoice == 2 )
				{
					overwriteKeyfiles() ;
				}
				return  ;
			}


		}

	}
}

#ifdef LIGHTGUN


void CXBoxSample::doConfigureLightgun()
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Configure Light Gun" );
		swprintf( m_menuText[1], L"Calibrate Light Gun" );
		swprintf( m_menuText[2], L"Show Targeting Screen" );
		swprintf( m_menuText[3], L"In-Game Crosshairs - %S", m_lightgunTarget ? "Yes" : "No"  );
		//swprintf( m_menuText[3], L"Rumble Speed - %u", m_lightgunRumble );

		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 4, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : doCalibrateLightgun( TRUE ) ; break ;
				case 1 : doCalibrateLightgun( FALSE ) ; break ;
				case 2 : m_lightgunTarget = !m_lightgunTarget ; break ;
				//case 2 : m_lightgunRumble = getValuePopup( "Light Gun Rumble Speed", m_lightgunRumble, 1, 10, &m_pnlBackgroundOther ) ; break ;
				default : break ;
			}
		}


	}
}

void CXBoxSample::doCalibrateLightgun( bool changeValues )
{
	int menuChoice = 0 ;
	int doingCenter = 1 ;
	int foundgun ;
	DWORD holderColor = pmenuParams->normalColor ;
    SHORT centerX;
    SHORT centerY;
    SHORT ulX;
    SHORT ulY;
	SHORT minX, minY, maxX, maxY ;
	SHORT posX, posY ;
	int firsttime = 1 ;

	maxX = maxY = -32000 ;
	minX = minY = 32000 ;
	posX = 0 ;
	posY = 0 ;

	//m_lightgun.ResetCalibrationOffsets() ;



	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_mp3player.process() ;
		//m_plaything.Render( 0,0,0 ) ;

	    ColorBar( 0,0,640*VIDEOMODES[m_xboxVidmode].multx,480*VIDEOMODES[m_xboxVidmode].multy, 0xFF00FFFF) ;

		swprintf( m_menuText[0], L"" ) ;
		if ( changeValues )
			swprintf( m_menuText[1], L"Calibrate Lightgun" ) ;
		else
			swprintf( m_menuText[1], L"Targeting Screen" ) ;


		//renderMenuText( 0, 0, m_menuText, 2, 0 ) ;


        XBInput_GetInput();

		foundgun = 0 ;

		// Check all ports for a lightgun
		for( DWORD i=0; i<4; i++ )
		{
			if( g_Gamepads[i].hDevice && g_Gamepads[i].caps.SubType == XINPUT_DEVSUBTYPE_GC_LIGHTGUN )
			{
				// Copy the gamepad input to the lightgun structure.
				// Note: This is just for convenience so we can refer to a 
				// "lightgun" instead of a "gamepad".
				m_lightgun.CopyInput( &g_Gamepads[i], i );
				foundgun = 1 ;
				break ;

			}
		}

		if ( foundgun == 0 )
		{
			popupMsg( "No lightgun found!", &m_pnlBackgroundOther ) ;
			return ;
		}

		if ( firsttime )
		{
			if ( changeValues )
				m_lightgun.ResetCalibrationOffsets( ) ;
			sprintfx( "reset calibration\r\n") ;
			firsttime = 0 ;
		}

	    FLOAT fTargetX, fTargetY;

		if ( doingCenter )
		{
			swprintf( m_menuText[2], L"Aim at the Center Colored Target and Shoot" ) ;
	        m_lightgun.GetCalibrationTargetCoords( &fTargetX, &fTargetY, NULL, NULL );

	        //ColorBar( 640.0f *VIDEOMODES[m_xboxVidmode].multx/2 - 8, 480.0f *VIDEOMODES[m_xboxVidmode].multy/2 - 8, 16, 16, 0xffFFffFF);
	        ColorBar( fTargetX-8, fTargetY-8, 16, 16, 0xffFFffFF);
		}
		else
		{
			swprintf( m_menuText[2], L"Aim at the UpperLeft Color Target and Shoot" ) ;
	        m_lightgun.GetCalibrationTargetCoords( NULL, NULL, &fTargetX, &fTargetY);
	        ColorBar( fTargetX-8, fTargetY-8, 16, 16, 0xffFFffFF);
	        //ColorBar( 48, 48, 16, 16, 0xffFFffFF);
		}

		//m_lightgun.DisplayWhiteField() ;

		// Make sure the gun is properly calibrated. Note that this is called every
		// frame in case the state of the display changes
		m_lightgun.VerifyCalibrationState( FALSE );

		// Set the vibration motors
		//m_Lightgun.SetVibrationMotors( m_wLeftMotorSpeed, m_wRightMotorSpeed );


		BOOL bShotFired;
		BOOL bShotHitScreen;
		BOOL bShotMissedScreen;
		m_lightgun.Update( &bShotFired, &bShotHitScreen, &bShotMissedScreen );


		FLOAT fWidth = 640.0f *VIDEOMODES[m_xboxVidmode].multx;
		FLOAT fHeight = 480.0f *VIDEOMODES[m_xboxVidmode].multy;
		FLOAT fThumbLX = (fWidth/2) + (fWidth/2)*(m_lightgun.sThumbLX+0.5f)/32767.5f;
		FLOAT fThumbLY = (fHeight/2) - (fHeight/2)*(m_lightgun.sThumbLY+0.5f)/32767.5f;

	    //ColorBar( posX-10, posY-10, 20,20, 0xFF00FF00 );
		if ( !changeValues && ( m_lightgun.wButtons & XINPUT_LIGHTGUN_ONSCREEN  ) )
		{
			ColorBar( fThumbLX-1, fThumbLY-8, 2, 16, 0xffff0000);
			ColorBar( fThumbLX-8, fThumbLY-1, 16, 2, 0xffff0000);
		}

		//sprintfx( "x=%d, y=%d  MIN(%d,%d) MAX(%d,%d) POS(%d,%d)\r\n", m_lightgun.sThumbLX, m_lightgun.sThumbLY, minX, minY, maxX, maxY, posX, posY) ;

		pmenuParams->normalColor = 0xFFFFFFFF ;
		swprintf( m_menuText[3], L" " ) ;
		swprintf( m_menuText[4], L" " ) ;
		swprintf( m_menuText[5], L" " ) ;
		swprintf( m_menuText[6], L" " ) ;
		swprintf( m_menuText[7], L" " ) ;
		swprintf( m_menuText[8], L" " ) ;
		swprintf( m_menuText[9], L"x=%d, y=%d", m_lightgun.sThumbLX, m_lightgun.sThumbLY) ;
		swprintf( m_menuText[10], L"") ;
		renderMenuText( 0, 0, m_menuText, 11, 0 ) ;

		// Check if the lightgun is onscreen and the trigger was pulled
		if( bShotHitScreen )
		{
			// Calibrate the center point
			if( doingCenter )
			{
				centerX = m_lightgun.sThumbLX;
				centerY = m_lightgun.sThumbLY;

				//sprintfx( "HIT  x=%d, y=%d\r\n", m_lightgun.sThumbLX, m_lightgun.sThumbLY) ;

				// Set the new calibration offsets
				if ( changeValues )
					m_lightgun.SetCalibrationOffsets( centerX, 
												  centerY,
												  XINPUT_LIGHTGUN_CALIBRATION_UPPERLEFT_X,
												  XINPUT_LIGHTGUN_CALIBRATION_UPPERLEFT_Y );

				doingCenter = 0;
			}
			else // Calibrate the upperleft point
			{
				ulX = m_lightgun.sThumbLX;
				ulY = m_lightgun.sThumbLY;

				// Set the new calibration offsets and save them for future retrieval
				if ( changeValues )
					m_lightgun.SetCalibrationOffsets( centerX, 
												  centerY,
												  ulX,
												  ulY );

				//sprintfx( "HIT  x=%d, y=%d\r\n", m_lightgun.sThumbLX, m_lightgun.sThumbLY) ;
				pmenuParams->normalColor = holderColor ;
				return ;
			}
		}

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
		}


	}
	pmenuParams->normalColor = holderColor ;

}

#endif
/*
static uint32 mousex,mousey,mouseb;
void GetMouseData(uint32 *x, uint32 *y, uint32 *b)
{
 *x=mousex;
 *y=mousey;
 if(!fullscreen)
 {
  if(eoptions&EO_USERFORCE)
  {
   RECT t;
   GetClientRect(hAppWnd,&t);

   *x=*x*VNSWID/(t.right?t.right:1);
   *y=*y*totallines/(t.bottom?t.bottom:1);
  }
  else
  {
   *x/=winsizemul;
   *y/=winsizemul;
  }
  *x+=VNSCLIP;
 }

 *y+=srendline;
 *b=((mouseb==MK_LBUTTON)?1:0)|((mouseb==MK_RBUTTON)?2:0);
}
*/

void CXBoxSample::doConfigureController( int port )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Configure Controller %u", port+1 );
		swprintf( m_menuText[1], L"Change Emulator Definitions" );
		swprintf( m_menuText[2], L"Change Joypad Mappings" );
		swprintf( m_menuText[3], L"Change Autofire Config" );
		swprintf( m_menuText[4], L"Change Combo Config" );
		swprintf( m_menuText[5], L"Change Analog Sensitivity" );
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 6, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				{
					doEmulatorDefinitions( port ) ;
					break ;
				}
				case 1 : 
				{
					doJoypadMappings( port ) ;
					break ;
				}
				case 2 : 
				{
					doAutofireConfig( port ) ;
					break ;
				}
				case 3 : 
				{
					doComboConfig( port ) ;
					break ;
				}
				case 4 : 
				{
					m_mappings[port].analog_sensitivity = getValuePopup( "Change Analog Sensitivity", m_mappings[port].analog_sensitivity, 1, 255, &m_pnlBackgroundOther ) ; 
					break ;
				}
				default : break ;
			}
		}


	}
}

void CXBoxSample::doComboConfig( int port )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Combo Config %u", port+1 );

		for ( int i = 0 ; i < 10 ; i++ )
		{
			swprintf( m_menuText[i+1], L"Combo %u", i+1 );
		}
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 11, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			doChangeCombo( port, menuChoice ) ;
		}


	}
}

void CXBoxSample::checkGeneralEvents( )
{

	static int did_save_state[4] = { 0, 0, 0, 0} ;
	static int did_load_state[4] = { 0, 0, 0, 0} ;
	static int did_change_state[4] = { 0, 0, 0, 0} ;
	static int did_screenshot[4] = { 0, 0, 0, 0} ;
	static int did_change_gfx[4] = { 0, 0, 0, 0} ;
	static int did_toggle_bgm[4] = { 0, 0, 0, 0} ;
	static int did_capture_mode[4] = { 0, 0, 0, 0} ;
	static int doing_combo[4] = { 0, 0, 0, 0} ;
	static int capcalls = 0 ;

	int throttle ;
	int doScreenshot ;
	int keyiter ;

	throttle = 0 ;
	doScreenshot = 0 ;

	capcalls++ ;

	for ( int i = 0; i < 4 ; i++ )
	{

		keyiter = 0 ;
		for ( int ki = 0 ; ki < 32 ; ki++ )
		{
			if ( g_keystroke_queue[i][ki] )
				keyiter = ki+1 ;
			else
				break ;
		}

		for ( int j = 0 ; j < 10 ; j++ )
		{
			if ( ( m_mappings[i].combos[j].mapping ) && ( ( m_xboxControllers[i] & m_mappings[i].combos[j].mapping ) == m_mappings[i].combos[j].mapping ) )
			{
				if ( m_mappings[i].combos[j].currmove == 0 )
				{
					m_mappings[i].combos[j].currmove = 1 ;
					m_mappings[i].combos[j].currdelay = m_mappings[i].combos[j].delay ;
				}
			}
			if ( m_mappings[i].combos[j].currmove )
			{
				if ( m_mappings[i].combos[j].currdelay )
				{
					m_mappings[i].combos[j].currdelay-- ;
					m_emuControllers[i] = m_mappings[i].combos[j].moves[ m_mappings[i].combos[j].currmove - 1] ;

					if ( m_emuControllers[i] & 0x80000000 )
					{
						g_keystroke_queue[i][keyiter++] = m_emuControllers[i] ;
						m_emuControllers[i] = 0 ;
					}
				}
				else
				{
					m_mappings[i].combos[j].currmove++ ;
					if ( m_mappings[i].combos[j].currmove == m_mappings[i].combos[j].endmove + 1 )
					{
						m_mappings[i].combos[j].currmove = 0 ;
					}
					else
					{
						m_mappings[i].combos[j].currdelay = m_mappings[i].combos[j].delay ;
						m_emuControllers[i] = m_mappings[i].combos[j].moves[ m_mappings[i].combos[j].currmove - 1] ;
						if ( m_emuControllers[i] & 0x80000000 )
						{
							g_keystroke_queue[i][keyiter++] = m_emuControllers[i] ;
							m_emuControllers[i] = 0 ;
						}
					}
				}
			}
		}

		if ( ( m_mappings[i].options_menu ) && ( ( m_xboxControllers[i] & m_mappings[i].options_menu ) == m_mappings[i].options_menu ) )
		{
			xboxOptionsMenu() ;
		}

		if ( ( m_mappings[i].virtual_keyboard) && ( ( m_xboxControllers[i] & m_mappings[i].virtual_keyboard ) == m_mappings[i].virtual_keyboard) )
		{
			m_bKeyboardMode = 1 ;
		}

		if ( ( m_mappings[i].save_state ) && ( ( m_xboxControllers[i] & m_mappings[i].save_state ) == m_mappings[i].save_state ) )
		{
			if ( ! did_save_state[i] )
			{
				xboxSaveState() ;
			}
			did_save_state[i] = 1 ;
		}
		else
		{
			did_save_state[i] = 0 ;
		}

		if ( ( m_mappings[i].load_state ) && ( ( m_xboxControllers[i] & m_mappings[i].load_state ) == m_mappings[i].load_state ) )
		{
			if ( ! did_load_state[i] )
			{
				xboxLoadState() ;
			}
			did_load_state[i] = 1 ;
		}
		else
		{
			did_load_state[i] = 0 ;
		}

		if ( ( m_mappings[i].change_save_slot ) && ( ( m_xboxControllers[i] & m_mappings[i].change_save_slot ) == m_mappings[i].change_save_slot ) )
		{
			if ( ! did_change_state[i] )
			{
				xboxChangeState() ;
			}
			did_change_state[i] = 1 ;
		}
		else
		{
			did_change_state[i] = 0 ;
		}


		if ( ( ( m_mappings[i].screenshot ) && ( ( m_xboxControllers[i] & m_mappings[i].screenshot ) == m_mappings[i].screenshot ) ) )
		{
			if ( ( ! did_screenshot[i] ) )
			{
				doScreenshot = 1 ;
			}
			did_screenshot[i] = 1 ;
		}
		else
		{
			did_screenshot[i] = 0 ;
		}

		if ( m_bInCaptureMode )
		{
			if ( capcalls%m_captureSpeed == 0  ) 
			{
				doScreenshot = 1 ;
			}
		}


		if ( ( m_mappings[i].change_gfx_filter ) && ( ( m_xboxControllers[i] & m_mappings[i].change_gfx_filter ) == m_mappings[i].change_gfx_filter ) )
		{
			if ( ! did_change_gfx[i] )
			{
				xboxChangeFilter() ;
			}
			did_change_gfx[i] = 1 ;
		}
		else
		{
			did_change_gfx[i] = 0 ;
		}

		if ( ( m_mappings[i].toggle_bgm ) && ( ( m_xboxControllers[i] & m_mappings[i].toggle_bgm ) == m_mappings[i].toggle_bgm ) )
		{
			if ( ! did_toggle_bgm[i] )
			{
				musicControlMenu( &m_pnlBackgroundOther ) ;
				//m_playingMusic = !m_playingMusic ;
				//m_mp3player.pause( !m_playingMusic ) ; 
			}
			did_toggle_bgm[i] = 1 ;
		}
		else
		{
			did_toggle_bgm[i] = 0 ;
		}


		if ( ( m_mappings[i].capture_mode ) && ( ( m_xboxControllers[i] & m_mappings[i].capture_mode ) == m_mappings[i].capture_mode ) )
		{
			if ( ! did_capture_mode[i] )
			{
				m_bInCaptureMode = !m_bInCaptureMode ;
			}
			did_capture_mode[i] = 1 ;
		}
		else
		{
			did_capture_mode[i] = 0 ;
		}


		if ( ( m_mappings[i].start_recording ) && ( ( m_xboxControllers[i] & m_mappings[i].start_recording ) == m_mappings[i].start_recording ) )
		{
			xboxStartRecording() ;
		}
		if ( ( m_mappings[i].stop_recording ) && ( ( m_xboxControllers[i] & m_mappings[i].stop_recording ) == m_mappings[i].stop_recording ) )
		{
			xboxStopRecording() ;
		}
		if ( ( m_mappings[i].start_playing ) && ( ( m_xboxControllers[i] & m_mappings[i].start_playing ) == m_mappings[i].start_playing ) )
		{
			xboxStartPlaying() ;
		}
		if ( ( m_mappings[i].stop_playing ) && ( ( m_xboxControllers[i] & m_mappings[i].stop_playing ) == m_mappings[i].stop_playing ) )
		{
			xboxStopPlaying() ;
		}


		if ( ( m_mappings[i].sfx_vol_up ) && ( ( m_xboxControllers[i] & m_mappings[i].sfx_vol_up ) == m_mappings[i].sfx_vol_up ) )
		{
			m_sound.adjust_volume( 5 ) ;
		}
		if ( ( m_mappings[i].sfx_vol_down ) && ( ( m_xboxControllers[i] & m_mappings[i].sfx_vol_down ) == m_mappings[i].sfx_vol_down ) )
		{
			m_sound.adjust_volume( -5 ) ;
		}
		if ( ( m_mappings[i].bgm_vol_up ) && ( ( m_xboxControllers[i] & m_mappings[i].bgm_vol_up ) == m_mappings[i].bgm_vol_up ) )
		{
			m_mp3player.adjust_volume( 5 ) ;
		}
		if ( ( m_mappings[i].bgm_vol_down ) && ( ( m_xboxControllers[i] & m_mappings[i].bgm_vol_down ) == m_mappings[i].bgm_vol_down ) )
		{
			m_mp3player.adjust_volume( -5 ) ;
		}

		if ( ( m_mappings[i].throttle ) && ( ( m_xboxControllers[i] & m_mappings[i].throttle ) == m_mappings[i].throttle ) )
			throttle = m_throttleSpeed ;

	
	
	}

	if ( doScreenshot )
	{
		xboxScreenshot() ;
	}

	if ( m_emuRecording )
	{
		memcpy( m_szEmuRecorder + m_emuRecordPosition, &(m_emuControllers[0]), sizeof(DWORD) ) ;
		m_emuRecordPosition += sizeof(DWORD) ;
		memcpy( m_szEmuRecorder + m_emuRecordPosition, &(m_emuControllers[1]), sizeof(DWORD) ) ;
		m_emuRecordPosition += sizeof(DWORD) ;
		memcpy( m_szEmuRecorder + m_emuRecordPosition, &(m_emuControllers[2]), sizeof(DWORD) ) ;
		m_emuRecordPosition += sizeof(DWORD) ;
		memcpy( m_szEmuRecorder + m_emuRecordPosition, &(m_emuControllers[3]), sizeof(DWORD) ) ;
		m_emuRecordPosition += sizeof(DWORD) ;

		if ( m_emuRecordPosition + (4*sizeof(DWORD)) >= EMU_RECORDING_SIZE )
		{
			xboxStopRecording() ;
		}
	}
	else
	{
		if ( m_emuPlaying )
		{
			if ( m_emuPlayPosition < m_emuPlaySize )
			{
				memcpy( &(m_emuControllers[0]), m_szEmuRecorder + m_emuPlayPosition, sizeof(DWORD) ) ;
				m_emuPlayPosition += sizeof(DWORD) ;
				memcpy( &(m_emuControllers[1]), m_szEmuRecorder + m_emuPlayPosition, sizeof(DWORD) ) ;
				m_emuPlayPosition += sizeof(DWORD) ;
				memcpy( &(m_emuControllers[2]), m_szEmuRecorder + m_emuPlayPosition, sizeof(DWORD) ) ;
				m_emuPlayPosition += sizeof(DWORD) ;
				memcpy( &(m_emuControllers[3]), m_szEmuRecorder + m_emuPlayPosition, sizeof(DWORD) ) ;
				m_emuPlayPosition += sizeof(DWORD) ;
			}
			else
			{
				xboxStopPlaying() ;
			}
		}
	}

	xboxThrottle( throttle ) ;
}


void CXBoxSample::doChangeComboMoves( int port, int combo )
{
	int menuChoice = 0 ;
	int yesno ;
	WCHAR holder[100] ;
	int foundkey ;
	int whichj ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Combo Moves %u", combo+1 );

		for ( int i = 0 ; i < 32 ; i++ )
		{
			int isFirst = 1 ;

			if ( i >= m_mappings[port].combos[combo].endmove )
			{
				swprintf( m_menuText[i+1], L"<END>" );
				continue ;
			}

			swprintf( m_menuText[i+1], L"" );

			foundkey = 0 ;

			for ( int j = 0 ; j < NUM_EMU_BUTTONS ; j++ )
			{
				if ( g_emuButtonDefinitions[j].value & 0x80000000 )
				{
					if ( m_mappings[port].combos[combo].moves[i] == g_emuButtonDefinitions[j].value )
					{
						foundkey = g_emuButtonDefinitions[j].value ;
						whichj = j ;
					}
				}
			}

			if ( foundkey )
			{
				if ( isFirst )
				{
					isFirst = 0 ;
					swprintf( holder, L"%S", g_emuButtonDefinitions[whichj].name  ) ;
					wcscat( m_menuText[i+1], holder ) ;
				}
				else
				{
					wcscat( m_menuText[i+1], L"+" ) ;
					swprintf( holder, L"%S", g_emuButtonDefinitions[whichj].name  ) ;
					wcscat( m_menuText[i+1], holder ) ;
				}
			}
			else
			{
				for ( int j = 0 ; j < NUM_EMU_BUTTONS ; j++ )
				{
					if ( m_mappings[port].combos[combo].moves[i] & g_emuButtonDefinitions[j].value )
					{
						if ( isFirst )
						{
							isFirst = 0 ;
							swprintf( holder, L"%S", g_emuButtonDefinitions[j].name  ) ;
							wcscat( m_menuText[i+1], holder ) ;
						}
						else
						{
							wcscat( m_menuText[i+1], L"+" ) ;
							swprintf( holder, L"%S", g_emuButtonDefinitions[j].name  ) ;
							wcscat( m_menuText[i+1], holder ) ;
						}
					}
				}
			}

			if ( wcslen( m_menuText[i+1] ) == 0 )
			{
				swprintf( m_menuText[i+1], L"Nothing" );
			}
			
		}
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 33, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;

			if ( ( yesno = yesNoMenu( "Mark This As End?", &m_pnlBackgroundOther ) ) == 0 )
			{
				m_mappings[port].combos[combo].endmove = menuChoice ;
			}
			else if ( yesno == 1 )
			{
				m_mappings[port].combos[combo].moves[menuChoice] = getNewEmuMapping( port, combo, m_mappings[port].combos[combo].moves[menuChoice] ) ;
				if ( ( menuChoice < 31 ) && ( m_mappings[port].combos[combo].endmove <= menuChoice ) )
					m_mappings[port].combos[combo].endmove = menuChoice+1 ;
			}
			
		}


	}
}
char* getXboxButtonName( unsigned int value, unsigned int position )
{
	unsigned int hitnum ;

	hitnum = 0 ;

	for ( int i = 0 ; i < NUM_XBOX_BUTTONS ; i++ )
	{
		if ( g_xboxButtonDefinitions[i].value & value )
		{
			if ( hitnum == position )
				return g_xboxButtonDefinitions[i].name ;

			hitnum++ ;
		}
	}

	return g_xboxButtonDefinitions[NUM_XBOX_BUTTONS-1].name ;
}

void CXBoxSample::doChangeCombo( int port, int combo )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Change Combo %u", combo+1 );
		swprintf( m_menuText[1], L"Change Trigger - %S+%S" , getXboxButtonName( m_mappings[port].combos[combo].mapping,0 ), getXboxButtonName( m_mappings[port].combos[combo].mapping,1 ));
		swprintf( m_menuText[2], L"Change Moves" );
		swprintf( m_menuText[3], L"Change Delay - %u", m_mappings[port].combos[combo].delay );
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 4, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				{

					while(g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_A])
					{
						XBInput_GetInput();
					}

					m_mappings[port].combos[combo].mapping = getNewMapping( m_mappings[port].combos[combo].mapping ) ;
					break ;
				}
				case 1 : 
				{
					doChangeComboMoves( port, combo ) ;
					break ;
				}
				case 2 : 
				{
					m_mappings[port].combos[combo].delay = getValuePopup( "Enter New Delay", m_mappings[port].combos[combo].delay, 0, 255, &m_pnlBackgroundOther ) ;
					break ;
				}
				default : break ;
			}
		}


	}
}

void CXBoxSample::doJoypadMappings( int port )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Joypad Mappings %u", port+1 );
		swprintf( m_menuText[1], L"Change Game Mappings" );
		swprintf( m_menuText[2], L"Change UI Mappings" );
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 3, 0, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			switch ( menuChoice )
			{
				case 0 : 
				{
					doGameJoypadMappings( port ) ;
					break ;
				}
				case 1 : 
				{
					doUIJoypadMappings( port ) ;
					break ;
				}
				default : break ;
			}
		}


	}
}


void CXBoxSample::doGameJoypadMappings( int port )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Game Joypad Mappings Controller %u", port+1 );

		for ( int i = 0 ; i < 32 ; i++ )
		{
			//sprintfx("port %u, i %u, emudef %u, xboxval %u\r\n", port, i, m_mappings[port].emu_buttons_definition[i], m_mappings[port].emu_buttons[i] ) ;
			swprintf( m_menuText[(i*2)+1], L"Emu%u(%S)", i+1, g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[i]].name );
			swprintf( m_menuText[(i*2)+2], L"%S+%S", getXboxButtonName( m_mappings[port].emu_buttons[i],0 ), getXboxButtonName( m_mappings[port].emu_buttons[i],1 ) );
		}
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 33, 0, &m_pnlBackgroundOther, menuChoice, 1, 300 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			while (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_A])
			{
				XBInput_GetInput();
			}

			m_mappings[port].emu_buttons[menuChoice] = getNewMapping( m_mappings[port].emu_buttons[menuChoice] ) ;
			pmenuParams = &(m_skin.otherMenu) ;
		}


	}
}

void CXBoxSample::doAutofireConfig( int port )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Autofire Config Controller %u", port+1 );

		for ( int i = 0 ; i < 32 ; i++ )
		{
			swprintf( m_menuText[(i*2)+1], L"Emu%u(%S)", i+1, g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[i]].name );
			swprintf( m_menuText[(i*2)+2], L"%u", m_mappings[port].emu_buttons_autofire[i] ) ; 
		}
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 33, 0, &m_pnlBackgroundOther, menuChoice, 1, 300 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			while (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_A])
			{
				XBInput_GetInput();
			}

			m_mappings[port].emu_buttons_autofire[menuChoice]  = getValuePopup( "Autofire Delay", m_mappings[port].emu_buttons_autofire[menuChoice], 0, 255, &m_pnlBackgroundOther ) ; 
		}


	}
}

void CXBoxSample::doUIJoypadMappings( int port )
{
	int menuChoice = 0 ;


	while ( 1 )
	{

		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"UI Joypad Mappings Controller %u", port+1 );


		swprintf( m_menuText[1], L"Sfx Volume Up" );
		swprintf( m_menuText[2], L"%S+%S", getXboxButtonName( m_mappings[port].sfx_vol_up,0 ), getXboxButtonName( m_mappings[port].sfx_vol_up,1 ) );
		swprintf( m_menuText[3], L"Sfx Volume Down" );
		swprintf( m_menuText[4], L"%S+%S", getXboxButtonName( m_mappings[port].sfx_vol_down,0 ), getXboxButtonName( m_mappings[port].sfx_vol_down,1 ) );
		swprintf( m_menuText[5], L"Bgm Volume Up" );
		swprintf( m_menuText[6], L"%S+%S", getXboxButtonName( m_mappings[port].bgm_vol_up,0 ), getXboxButtonName( m_mappings[port].bgm_vol_up,1 ) );
		swprintf( m_menuText[7], L"Bgm Volume Down" );
		swprintf( m_menuText[8], L"%S+%S", getXboxButtonName( m_mappings[port].bgm_vol_down,0 ), getXboxButtonName( m_mappings[port].bgm_vol_down,1 ) );
		swprintf( m_menuText[9], L"Fast Forward\\Throttle" );
		swprintf( m_menuText[10], L"%S+%S", getXboxButtonName( m_mappings[port].throttle,0 ), getXboxButtonName( m_mappings[port].throttle,1 ) );
		swprintf( m_menuText[11], L"Save State" );
		swprintf( m_menuText[12], L"%S+%S", getXboxButtonName( m_mappings[port].save_state,0 ), getXboxButtonName( m_mappings[port].save_state,1 ) );
		swprintf( m_menuText[13], L"Load State" );
		swprintf( m_menuText[14], L"%S+%S", getXboxButtonName( m_mappings[port].load_state,0 ), getXboxButtonName( m_mappings[port].load_state,1 ) );
		swprintf( m_menuText[15], L"Change Save State Slot" );
		swprintf( m_menuText[16], L"%S+%S", getXboxButtonName( m_mappings[port].change_save_slot,0 ), getXboxButtonName( m_mappings[port].change_save_slot,1 ) );
		swprintf( m_menuText[17], L"Screenshot" );
		swprintf( m_menuText[18], L"%S+%S", getXboxButtonName( m_mappings[port].screenshot,0 ), getXboxButtonName( m_mappings[port].screenshot,1 ) );
		swprintf( m_menuText[19], L"Options Menu/Pause Emu" );
		swprintf( m_menuText[20], L"%S+%S", getXboxButtonName( m_mappings[port].options_menu,0 ), getXboxButtonName( m_mappings[port].options_menu,1 ) );
		swprintf( m_menuText[21], L"Change Gfx Filter" );
		swprintf( m_menuText[22], L"%S+%S", getXboxButtonName( m_mappings[port].change_gfx_filter,0 ), getXboxButtonName( m_mappings[port].change_gfx_filter,1 ) );
		swprintf( m_menuText[23], L"Music Control Menu" );
		swprintf( m_menuText[24], L"%S+%S", getXboxButtonName( m_mappings[port].toggle_bgm,0 ), getXboxButtonName( m_mappings[port].toggle_bgm,1 ) );
		swprintf( m_menuText[25], L"Start Recording" );
		swprintf( m_menuText[26], L"%S+%S", getXboxButtonName( m_mappings[port].start_recording,0 ), getXboxButtonName( m_mappings[port].start_recording,1 ) );
		swprintf( m_menuText[27], L"Stop Recording" );
		swprintf( m_menuText[28], L"%S+%S", getXboxButtonName( m_mappings[port].stop_recording,0 ), getXboxButtonName( m_mappings[port].stop_recording,1 ) );
		swprintf( m_menuText[29], L"Start Playback" );
		swprintf( m_menuText[30], L"%S+%S", getXboxButtonName( m_mappings[port].start_playing,0 ), getXboxButtonName( m_mappings[port].start_playing,1 ) );
		swprintf( m_menuText[31], L"Stop Playback" );
		swprintf( m_menuText[32], L"%S+%S", getXboxButtonName( m_mappings[port].stop_playing,0 ), getXboxButtonName( m_mappings[port].stop_playing,1 ) );
		swprintf( m_menuText[33], L"Auto-Screenshot Capture Mode" );
		swprintf( m_menuText[34], L"%S+%S", getXboxButtonName( m_mappings[port].capture_mode,0 ), getXboxButtonName( m_mappings[port].capture_mode,1 ) );
		swprintf( m_menuText[35], L"Virtual Keyboard" );
		swprintf( m_menuText[36], L"%S+%S", getXboxButtonName( m_mappings[port].virtual_keyboard,0 ), getXboxButtonName( m_mappings[port].virtual_keyboard,1 ) );

		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 19, 0, &m_pnlBackgroundOther, menuChoice, 1, 300 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			while (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_A])
			{
				XBInput_GetInput();
			}

			switch ( menuChoice )
			{
				case 0 :
				{
					m_mappings[port].sfx_vol_up = getNewMapping( m_mappings[port].sfx_vol_up ) ;
					break ;
				}
				case 1 :
				{
					m_mappings[port].sfx_vol_down = getNewMapping( m_mappings[port].sfx_vol_down ) ;
					break ;
				}
				case 2 :
				{
					m_mappings[port].bgm_vol_up = getNewMapping( m_mappings[port].bgm_vol_up ) ;
					break ;
				}
				case 3 :
				{
					m_mappings[port].bgm_vol_down = getNewMapping( m_mappings[port].bgm_vol_down ) ;
					break ;
				}
				case 4 :
				{
					m_mappings[port].throttle= getNewMapping( m_mappings[port].throttle) ;
					break ;
				}
				case 5 :
				{
					m_mappings[port].save_state= getNewMapping( m_mappings[port].save_state) ;
					break ;
				}
				case 6 :
				{
					m_mappings[port].load_state = getNewMapping( m_mappings[port].load_state ) ;
					break ;
				}
				case 7 :
				{
					m_mappings[port].change_save_slot = getNewMapping( m_mappings[port].change_save_slot ) ;
					break ;
				}
				case 8 :
				{
					m_mappings[port].screenshot = getNewMapping( m_mappings[port].screenshot ) ;
					break ;
				}
				case 9 :
				{
					m_mappings[port].options_menu = getNewMapping( m_mappings[port].options_menu ) ;
					break ;
				}
				case 10 :
				{
					m_mappings[port].change_gfx_filter = getNewMapping( m_mappings[port].change_gfx_filter) ;
					break ;
				}
				case 11 :
				{
					m_mappings[port].toggle_bgm = getNewMapping( m_mappings[port].toggle_bgm) ;
					break ;
				}
				case 12 :
				{
					m_mappings[port].start_recording = getNewMapping( m_mappings[port].start_recording) ;
					break ;
				}
				case 13 :
				{
					m_mappings[port].stop_recording= getNewMapping( m_mappings[port].stop_recording) ;
					break ;
				}
				case 14 :
				{
					m_mappings[port].start_playing= getNewMapping( m_mappings[port].start_playing) ;
					break ;
				}
				case 15 :
				{
					m_mappings[port].stop_playing = getNewMapping( m_mappings[port].stop_playing) ;
					break ;
				}
				case 16 :
				{
					m_mappings[port].capture_mode = getNewMapping( m_mappings[port].capture_mode) ;
					break ;
				}
				case 17 :
				{
					m_mappings[port].virtual_keyboard = getNewMapping( m_mappings[port].virtual_keyboard) ;
					break ;
				}


			}

		}


	}
}

unsigned int CXBoxSample::getNewDefinition( unsigned int oldMapping )
{
	DWORD dwTime  ;
	int menuChoice = 0 ;



	while ( 1 )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		swprintf( m_menuText[0], L"Redefine" ) ;

		for ( int i = 0 ; i < NUM_EMU_BUTTONS ; i++ )
		{
			swprintf( m_menuText[i+1], L"%S", g_emuButtonDefinitions[i].name ) ;
		}


		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, NUM_EMU_BUTTONS+1, 1, &m_pnlBackgroundOther, menuChoice, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			return menuChoice ;
		}


	}

	return oldMapping ;
}

int menuIntValue( int oldValue, int minval, int maxval ) 
{
	static DWORD iTime = GetTickCount() ;
	float timeslice ;

	if ( ( maxval - minval ) == 0 )
		timeslice = 0 ;
	else
		timeslice = 4000.0f/(float)(((float)maxval - (float)minval )) ;

	if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
	{
		if ( oldValue > minval )
			oldValue-- ;

	}
	else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
	{
		if ( oldValue < maxval )
			oldValue++ ;

	}
	else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
	{
		if ( GetTickCount() - iTime > timeslice )
		{
			iTime = GetTickCount() ;
			if ( oldValue < maxval )
				oldValue++ ;
		}
	}
	else if (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
	{
		if ( GetTickCount() - iTime > timeslice )
		{
			iTime = GetTickCount() ;

			if ( oldValue > minval )
				oldValue-- ;
		}
	}
	else
	{
		iTime = GetTickCount() ;
	}

	return oldValue ;
}

int CXBoxSample::getValuePopup( char *title, int oldValue, int minval, int maxval, CPanel *panel )
{

	int currValue ;

	currValue = oldValue ;

	if ( currValue < minval )
		currValue = minval ;
	if ( currValue > maxval )
		currValue = maxval ;

	while ( 1 )
	{

		pmenuParams = &(m_skin.popupMenu) ;

		swprintf( m_menuText[0], L"%S", title ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"%u", currValue ) ;


		renderMenuTextWrapper( 0, 0, m_menuText, 3, 1, panel, 0, 0, 0 ) ;


		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			return currValue ;
		}

		currValue = menuIntValue( currValue, minval, maxval ) ;

	}

	return oldValue ;
}

unsigned int CXBoxSample::getNewMapping( unsigned int oldMapping )
{
	DWORD dwTime  ;
	unsigned int retval ;
	unsigned int numPressed ;

	retval = 0 ;


	dwTime = GetTickCount() ;


	while ( GetTickCount() - dwTime < 3000  )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		m_mp3player.process() ;
		//m_plaything.Render( 0,0,0 ) ;



		swprintf( m_menuText[0], L"Remap" ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"Button 1 - %S", getXboxButtonName( retval, 0 ) ) ;
		swprintf( m_menuText[3], L"Button 2 - %S", getXboxButtonName( retval, 1 )  ) ;
		swprintf( m_menuText[4], L"" ) ;
		swprintf( m_menuText[5], L"%u Seconds Left", 3 - (( GetTickCount()-dwTime )/1000) ) ;

		renderPopupBkg( 6 ) ;
		renderMenuText( 0, 0, m_menuText, 6, 0 ) ;
		
		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );


        XBInput_GetInput();
		if(g_Gamepads[0].hDevice )
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_A] )
			{
				retval |= XBOX_A ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_B] )
			{
				retval |= XBOX_B ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_X] )
			{
				retval |= XBOX_X ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_Y] )
			{
				retval |= XBOX_Y ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_BLACK] )
			{
				retval |= XBOX_BLACK ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_WHITE] )
			{
				retval |= XBOX_WHITE ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			{
				retval |= XBOX_DPAD_UP ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
			{
				retval |= XBOX_DPAD_DOWN ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
			{
				retval |= XBOX_DPAD_LEFT ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
			{
				retval |= XBOX_DPAD_RIGHT ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  
			{
				retval |= XBOX_START ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  
			{
				retval |= XBOX_BACK ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_LEFT_THUMB )  
			{
				retval |= XBOX_LEFT_THUMB ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_RIGHT_THUMB )  
			{
				retval |= XBOX_RIGHT_THUMB ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] )
			{
				retval |= XBOX_LEFT_TRIGGER ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] )
			{
				retval |= XBOX_RIGHT_TRIGGER ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].fX1 > 0.30f )
			{
				retval |= XBOX_LTHUMB_RIGHT ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].fX1 < -0.30f )
			{
				retval |= XBOX_LTHUMB_LEFT ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].fY1 > 0.30f )
			{
				retval |= XBOX_LTHUMB_UP ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].fY1 < -0.30f )
			{
				retval |= XBOX_LTHUMB_DOWN ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].fX2 > 0.30f )
			{
				retval |= XBOX_RTHUMB_RIGHT ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].fX2 < -0.30f )
			{
				retval |= XBOX_RTHUMB_LEFT ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].fY2 > 0.30f )
			{
				retval |= XBOX_RTHUMB_UP ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}
			if ( g_Gamepads[0].fY2 < -0.30f )
			{
				retval |= XBOX_RTHUMB_DOWN ;
				if ( strcmp( "Nothing", getXboxButtonName( retval, 1 ) ) )
					break ;
			}

		}


	}

	return retval ;
}


unsigned int CXBoxSample::getNewEmuMapping( unsigned int port, unsigned int combo, unsigned int oldMapping )
{
	DWORD dwTime  ;
	unsigned int retval, oldval, emuval ;
	unsigned int numPressed ;
	int numbuttons ;
	DWORD keystroke ;
	int whichj ;

	retval = oldval = 0 ;


	dwTime = GetTickCount() ;


	while ( GetTickCount() - dwTime < 3000  )
	{
		pmenuParams = &(m_skin.popupMenu) ;

		m_mp3player.process() ;
		//m_plaything.Render( 0,0,0 ) ;



		swprintf( m_menuText[0], L"Hold Buttons" ) ;
		swprintf( m_menuText[1], L"" ) ;

		emuval = 0 ;
		numbuttons = 0 ; 
		keystroke = 0 ;

		for ( int j = 0 ; j < 32 ; j++ )
		{
			if ( ( m_mappings[port].emu_buttons[j] ) && ( ( retval & m_mappings[port].emu_buttons[j] ) == m_mappings[port].emu_buttons[j] ) )
			{
				if ( g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[j] ].value & 0x80000000 )
				{
					keystroke = g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[j] ].value ;
					whichj = j ;
				}
				else
				{
					//emuval |= g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[j] ].value ;
				}

			}
		}

		if ( keystroke )
		{
			emuval = keystroke ;
			numbuttons++ ;
			swprintf( m_menuText[numbuttons+1], L"%S", g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[whichj] ].name ) ;
		}
		else
		{
			for ( int j = 0 ; j < 32 ; j++ )
			{
				if ( ( m_mappings[port].emu_buttons[j] ) && ( ( retval & m_mappings[port].emu_buttons[j] ) == m_mappings[port].emu_buttons[j] ) )
				{
					emuval |= g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[j] ].value ;
					numbuttons++ ;
					swprintf( m_menuText[numbuttons+1], L"%S", g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[j] ].name ) ;
				}
			}
		}

		swprintf( m_menuText[numbuttons+2], L"" ) ;
		swprintf( m_menuText[numbuttons+3], L"%u MilliSeconds Left", 3000 - ( GetTickCount()-dwTime ) ) ;

		renderPopupBkg( numbuttons+4 ) ;
		renderMenuText( 0, 0, m_menuText, numbuttons+4, 0 ) ;
		
		
		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

		retval = 0 ;

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice )
		{
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_A] )
			{
				retval |= XBOX_A ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_B] )
			{
				retval |= XBOX_B ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_X] )
			{
				retval |= XBOX_X ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_Y] )
			{
				retval |= XBOX_Y ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_BLACK] )
			{
				retval |= XBOX_BLACK ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_WHITE] )
			{
				retval |= XBOX_WHITE ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			{
				retval |= XBOX_DPAD_UP ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
			{
				retval |= XBOX_DPAD_DOWN ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
			{
				retval |= XBOX_DPAD_LEFT ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
			{
				retval |= XBOX_DPAD_RIGHT ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START )  
			{
				retval |= XBOX_START ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK )  
			{
				retval |= XBOX_BACK ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_LEFT_THUMB )  
			{
				retval |= XBOX_LEFT_THUMB ;
			}
			if ( g_Gamepads[0].wButtons & XINPUT_GAMEPAD_RIGHT_THUMB )  
			{
				retval |= XBOX_RIGHT_THUMB ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] )
			{
				retval |= XBOX_LEFT_TRIGGER ;
			}
			if ( g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] )
			{
				retval |= XBOX_RIGHT_TRIGGER ;
			}
			if ( g_Gamepads[0].fX1 > 0.30f )
			{
				retval |= XBOX_LTHUMB_RIGHT ;
			}
			if ( g_Gamepads[0].fX1 < -0.30f )
			{
				retval |= XBOX_LTHUMB_LEFT ;
			}
			if ( g_Gamepads[0].fY1 > 0.30f )
			{
				retval |= XBOX_LTHUMB_UP ;
			}
			if ( g_Gamepads[0].fY1 < -0.30f )
			{
				retval |= XBOX_LTHUMB_DOWN ;
			}
			if ( g_Gamepads[0].fX2 > 0.30f )
			{
				retval |= XBOX_RTHUMB_RIGHT ;
			}
			if ( g_Gamepads[0].fX2 < -0.30f )
			{
				retval |= XBOX_RTHUMB_LEFT ;
			}
			if ( g_Gamepads[0].fY2 > 0.30f )
			{
				retval |= XBOX_RTHUMB_UP ;
			}
			if ( g_Gamepads[0].fY2 < -0.30f )
			{
				retval |= XBOX_RTHUMB_DOWN ;
			}

		}

		oldval = retval ; 

	}

	return emuval ;
}

void CXBoxSample::doEmulatorDefinitions( int port )
{
	int menuChoice = 0 ;


	while ( 1 )
	{
		pmenuParams = &(m_skin.otherMenu) ;

		swprintf( m_menuText[0], L"Emulator Definitions Controller %u", port+1 );

		for ( int i = 0 ; i < 32 ; i++ )
		{
			//sprintfx("port %u, i %u, emudef %u, xboxval %u\r\n", port, i, m_mappings[port].emu_buttons_definition[i], m_mappings[port].emu_buttons[i] ) ;
			swprintf( m_menuText[(i*2)+1], L"Emu Button %u", i+1 );
			swprintf( m_menuText[(i*2)+2], L"%S", g_emuButtonDefinitions[ m_mappings[port].emu_buttons_definition[i]].name  ) ;
		}
		
		menuChoice = renderMenuTextWrapper( 1, menuChoice, m_menuText, 33, 0, &m_pnlBackgroundOther, menuChoice, 1, 300 ) ;
		

		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_sfxMenuCancel.Play( DSBPLAY_FROMSTART ) ;
			XBInput_GetInput();
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			m_mappings[port].emu_buttons_definition[menuChoice] = getNewDefinition( m_mappings[port].emu_buttons_definition[menuChoice] ) ;
			pmenuParams = &(m_skin.otherMenu) ;
		}


	}
}

void CXBoxSample::doFontSize()
{
	WCHAR str[200];
	int value ;

	value = m_Font.GetFontHeight() ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );
		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);
		m_mp3player.process() ;

		swprintf( str, L"Use DPAD to adjust current value : %u", value ) ;

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, 16*2, pmenuParams->normalColor, L"Set Game List Font Size" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), pmenuParams->normalColor, str) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), pmenuParams->normalColor, L"Press A to accept" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), pmenuParams->normalColor, L"Press B to go back" );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( value )
				value-- ;

			m_Font.SetFontHeight( value ) ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( value < 50 )
				value++ ;

			m_Font.SetFontHeight( value ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( value )
				value-- ;

			m_Font.SetFontHeight( value ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( value < 50 )
				value++ ;

			m_Font.SetFontHeight( value ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_sfxMenuSelect.Play( DSBPLAY_FROMSTART ) ;
			
			m_nFontHeight = m_Font.GetFontHeight() ;
			m_namesPerPage =  (25*14 ) / ( m_nFontHeight-2) ;

			//doSaveConfig() ;

			break ;
		}


	}

}

void CXBoxSample::doScreenSize()
{
	WCHAR str[200];
	int x, y, maxx, maxy ;
	float fx, fy, fmaxx, fmaxy ;
	float origw, origh ;
	DWORD mtime ;
	//D3DXVECTOR2 vecScale, vecTranslate ;

	mtime = GetTickCount() ;

	pmenuParams = &(m_skin.otherMenu) ;

	x = m_nScreenX ;
	y = m_nScreenY ;
	maxx = m_nScreenMaxX;
	maxy = m_nScreenMaxY ;

	fx = (float)x ;
	fy = (float)y ;
	fmaxx = (float)maxx ;
	fmaxy = (float)maxy ;

	if ( m_state == IN_GAME_PAUSED )
	{
		origw = (float)m_nScreenMaxX/m_gameVecScale.x ;
		origh = (float)m_nScreenMaxY/m_gameVecScale.y ;
	}

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_mp3player.process() ;
		//m_plaything.Render( 0,0,0 ) ;

		x = (int)fx ;
		y = (int)fy ;
		maxx = (int)fmaxx ;
		maxy = (int)fmaxy ;

		if ( m_state == IN_GAME_PAUSED )
		{
			D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
			m_gameVecScale.x = (float)maxx / ((float)origw);
			m_gameVecScale.y = (float)maxy / ((float)origh);
			m_gameVecTranslate.x = x ;
			m_gameVecTranslate.y = y ;
			m_pnlGameScreen.SetAlpha( 0x80) ;
			m_pnlGameScreen.Render(m_gameRectSource.left,m_gameRectSource.top,m_gameRectSource.right,m_gameRectSource.bottom,x,y,maxx,maxy) ;
			m_pnlGameScreen.SetAlpha( 0xFF) ;
			//Sprite->Draw(Texture, &m_gameRectSource, &m_gameVecScale, NULL, 0, &m_gameVecTranslate, d3color);
		}
		else
			MenuBar( x, y, maxx, maxy ) ;


		swprintf( m_menuText[0], L"Set Game Screen Size - RThumb/LThumb" ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"Use RThumb and LThumb to adjust screen size/pos" );
		swprintf( m_menuText[3], L"Press A to accept" );
		swprintf( m_menuText[4], L"Press B to go back" );
		swprintf( m_menuText[5], L"" ) ;
		swprintf( m_menuText[6], L"X=%d Y=%d MAXX=%d MAXY=%d", x, y, maxx, maxy ) ;

		renderMenuText( 0, 0, m_menuText, 7, 0 ) ;


		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_nScreenX = x ;
			m_nScreenY = y ;
			m_nScreenMaxX = maxx ;
			m_nScreenMaxY = maxy ;
			//doSaveConfig() ;
			break ;
		}
		else
		{
			if ( g_Gamepads[0].hDevice )
			{
				if ( GetTickCount() - mtime > 5 )
				{
					mtime = GetTickCount() ;
					fx += (g_Gamepads[0].fX1) ;
					fy -= (g_Gamepads[0].fY1) ;
					fmaxx += (g_Gamepads[0].fX2) ;
					fmaxy -= (g_Gamepads[0].fY2) ;
				}
			}
		}
	}

}

void CXBoxSample::doScreenshotSize( MENU_PARAMS *menu )
{
	WCHAR str[200];
	int x, y, maxx, maxy ;
	float fx, fy, fmaxx, fmaxy ;
	float origw, origh ;
	DWORD mtime ;
	//D3DXVECTOR2 vecScale, vecTranslate ;

	mtime = GetTickCount() ;

	pmenuParams = &(m_skin.otherMenu) ;

	x = menu->screenshotX ;
	y = menu->screenshotY ;
	maxx = menu->screenshotW;
	maxy = menu->screenshotH ;

	fx = (float)x ;
	fy = (float)y ;
	fmaxx = (float)maxx ;
	fmaxy = (float)maxy ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		m_mp3player.process() ;
		m_skin.gameSelectMenu.panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;

		//m_plaything.Render( 0,0,0 ) ;

		x = (int)fx ;
		y = (int)fy ;
		maxx = (int)fmaxx ;
		maxy = (int)fmaxy ;

		MenuBar( x, y, maxx, maxy ) ;


		swprintf( m_menuText[0], L"Set Screenshot Size/Position - RThumb/LThumb" ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"Use RThumb and LThumb to adjust screen size/pos" );
		swprintf( m_menuText[3], L"Press A to accept" );
		swprintf( m_menuText[4], L"Press B to go back" );
		swprintf( m_menuText[5], L"" ) ;
		swprintf( m_menuText[6], L"X=%d Y=%d MAXX=%d MAXY=%d", x, y, maxx, maxy ) ;

		renderMenuText( 0, 0, m_menuText, 7, 0 ) ;


		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			menu->screenshotX = x ;
			menu->screenshotY = y ;
			menu->screenshotW = maxx ;
			menu->screenshotH = maxy ;
			break ;
		}
		else
		{
			if ( g_Gamepads[0].hDevice )
			{
				if ( GetTickCount() - mtime > 5 )
				{
					mtime = GetTickCount() ;
					fx += (g_Gamepads[0].fX1) ;
					fy -= (g_Gamepads[0].fY1) ;
					fmaxx += (g_Gamepads[0].fX2) ;
					fmaxy -= (g_Gamepads[0].fY2) ;
				}
			}
		}
	}

}


void CXBoxSample::doTextOffset()
{
	WCHAR str[200];
	int x, y ;
	int oldx, oldy ;
	float fx, fy ;
	DWORD mtime ;

	mtime = GetTickCount() ;

	oldx = m_nXOffset ;
	oldy = m_nYOffset ;

	pmenuParams = &(m_skin.otherMenu) ;

	x = m_nXOffset ;
	y = m_nYOffset ;

	fx = (float)x ;
	fy = (float)y ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );

		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy) ;

		m_mp3player.process() ;
		m_plaything.Render( 0,0,0 ) ;

		x = (int)fx ;
		y = (int)fy ;
		m_nXOffset = x ;
		m_nYOffset  = y ;

		swprintf( m_menuText[0], L"Set Menu Text Position" ) ;
		swprintf( m_menuText[1], L"" ) ;
		swprintf( m_menuText[2], L"Use LThumb to adjust text position" );
		swprintf( m_menuText[3], L"Press A to accept" );
		swprintf( m_menuText[4], L"Press B to go back" );
		swprintf( m_menuText[5], L"" ) ;
		swprintf( m_menuText[6], L"X=%d Y=%d", x, y ) ;

		renderMenuText( 0, 0, m_menuText, 7, 0 ) ;


		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			m_nXOffset = oldx ;
			m_nYOffset = oldy ;
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			//doSaveConfig() ;
			break ;
		}
		else
		{
			if ( g_Gamepads[0].hDevice )
			{
				if ( GetTickCount() - mtime > 5 )
				{
					mtime = GetTickCount() ;
					fx += g_Gamepads[0].fX1 ;
					fy -= g_Gamepads[0].fY1 ;
				}
			}
		}
	}

}

void CXBoxSample::doStartSearchMenu()
{

	int offset = 0 ;

	m_currentMemMatches = 0 ;

	for ( int i = 0 ; i < NUM_MEMORY_LOCATIONS ; i++ )
	{
		if( m_memory_locations[i] )
		{
			memcpy( m_memBuf1+offset, m_memory_locations[i], m_memory_sizes[i] ) ;
			memset( m_memMatches+offset, 1, m_memory_sizes[i] ) ;
			m_currentMemMatches += m_memory_sizes[i] ;
		}
		else
		{
			memset( m_memBuf1+offset, 0, m_memory_sizes[i] ) ;
			memset( m_memMatches+offset, 0, m_memory_sizes[i] ) ;
		}

		offset += m_memory_sizes[i] ;
	}

	popupMsg( "The search has begun.", &m_pnlBackgroundOther ) ;

}

void CXBoxSample::doEditCode( int which )
{
	CHEAT_CODE code ;
	int curr_pos ;

	if ( which < 0 )
	{
		strcpy( code.code, "01000000" ) ;
		code.enabled = 1 ;
		code.adr = 0x0000 ;
		code.val = 0 ;
	}
	else
	{
		memcpy( &code, &(m_cheatCodes[which]), sizeof(CHEAT_CODE) ) ;
	}


	curr_pos = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );
		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);

		m_Font.Begin();

		if ( which < 0 )
			m_Font.DrawText((float)m_nXOffset+  32, 16*2, pmenuParams->normalColor, L"Add New Cheat Code" );
		else
			m_Font.DrawText( (float)m_nXOffset+ 32, 16*2, pmenuParams->normalColor, L"Edit Cheat Code" );

		m_Font.DrawText( (float)m_nXOffset+ 32, MLINE(0), pmenuParams->normalColor, L"Press B to cancel." );
		m_Font.DrawText( (float)m_nXOffset+ 32, MLINE(1), pmenuParams->normalColor, L"Press A to save." );
		m_Font.DrawText( (float)m_nXOffset+ 32, MLINE(2), pmenuParams->normalColor, L"Use DPAD to select/change values." );

		WCHAR str[200];

		for ( int i = 0 ; i < 8 ; i++ )
		{
			swprintf( str, L"%c", (code.code)[i] ) ;
			if ( i == curr_pos+2 )
				m_Font.DrawText( (float)m_nXOffset+  50 + ( i * 16 ), MLINE(4), pmenuParams->notedColor, str ) ;
			else
				m_Font.DrawText( (float)m_nXOffset+  50 + ( i * 16 ), MLINE(4), pmenuParams->normalColor, str ) ;
		}

		swprintf( str, L"Address : %04.4X", code.adr ) ;
		m_Font.DrawText( (float)m_nXOffset+  50 , MLINE(6), pmenuParams->normalColor, str ) ;
		swprintf( str, L"Value : %u", code.val ) ;
		m_Font.DrawText( (float)m_nXOffset+  50 , MLINE(7), pmenuParams->normalColor, str ) ;
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
		{
			break ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_A ] ) 
		{
			if ( ( code.adr >= CONSOLE_MEMORY_SIZE ) )
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
										 0x00000000, 1.0f, 0L );
					//RenderGradientBackground( 0xFF000000, 0xFF000000 );
					pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);

					m_Font.Begin();
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), pmenuParams->normalColor, L"The Address must be between 0x0000 and 0x7FFF" );
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), pmenuParams->normalColor, L"Press B to try again." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
			else
			{
				if ( which < 0 )
				{
					m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;
					memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
					m_numCheats++ ;
				}
				else
				{
					memcpy( &(m_cheatCodes[which]), &code, sizeof(CHEAT_CODE) ) ;
				}
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0 )
						code.val = 0xF0 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val - 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x00 )
						code.val = 0x0F + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val - 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0 )
						code.adr = 0xF0 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr - 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0 )
						code.adr = 0x0F + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr - 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0 )
						code.adr = 0xF000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr - 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0 )
						code.adr = 0x0F00 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr - 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			switch ( curr_pos )
			{
				case 0 :
				{
					if ( ( ( code.val >> 4 ) &  0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0x0F ) ;
					else
						code.val = ( code.val + 0x10 ) & 0xFF ;
					break ;
				}
				case 1 :
				{
					if ( ( code.val & 0x0F ) == 0x0F )
						code.val = 0x00 + ( code.val & 0xF0 ) ;
					else
						code.val = ( code.val + 0x01 ) & 0xFF ;
					break ;
				}
				case 2 :
				{
					if ( ( ( code.adr >> 4 ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFF0F ) ;
					else
						code.adr = ( code.adr + 0x10 ) & 0xFFFF ;
					break ;
				}
				case 3 :
				{
					if ( ( ( code.adr ) &  0x0F ) == 0x0F )
						code.adr = 0x00 + ( code.adr & 0xFFF0 ) ;
					else
						code.adr = ( code.adr + 0x01 ) & 0xFFFF ;
					break ;
				}
				case 4 :
				{
					if ( ( ( code.adr >> 12 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0x0FFF ) ;
					else
						code.adr = ( code.adr + 0x1000 ) & 0xFFFF ;
					break ;
				}
				case 5 :
				{
					if ( ( ( code.adr >> 8 ) &  0x0F ) == 0x0F )
						code.adr = 0x0000 + ( code.adr & 0xF0FF ) ;
					else
						code.adr = ( code.adr + 0x100 ) & 0xFFFF ;
					break ;
				}
				default : break ;
			}
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( curr_pos == 0 )
				curr_pos = 5 ;
			else
				curr_pos-- ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( curr_pos == 5 )
				curr_pos = 0 ;
			else
				curr_pos++ ;
		}
	}


}

void CXBoxSample::doCodeListMenu()
{

	unsigned int selected  ;
	unsigned int cheatTopIdx ;
	WCHAR str[400];
	CHEAT_CODE *tempbuf ;

	selected = cheatTopIdx = 0 ;

	if ( m_numCheats == 0 )
	{
		while ( 1 )
		{
			m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
								 0x00000000, 1.0f, 0L );
			//RenderGradientBackground( 0xFF000000, 0xFF000000 );
			pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);

			m_Font.Begin();
			m_Font.DrawText( (float)m_nXOffset+  32, 16*2, pmenuParams->normalColor, L"Search Code List" );
			m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), pmenuParams->normalColor, L"Press B to go back to the Options menu." );
			m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), pmenuParams->normalColor, L"There are no cheat codes in the list." ) ;

			m_Font.End();

			m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

			XBInput_GetInput();
			if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
			{
				return ;
			}
		}
	}
	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );
		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, 16*2, pmenuParams->normalColor, L"Search Code List" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), pmenuParams->normalColor, L"Press B to go back to the Options menu." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), pmenuParams->normalColor, L"Press A to add a new code." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), pmenuParams->normalColor, L"Press X to edit the selected code." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), pmenuParams->normalColor, L"Press Y to enable/disable the selected code." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(4), pmenuParams->normalColor, L"Press BLACK to delete the selected code." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(5), pmenuParams->normalColor, L"Press UP/DOWN/LS/RS to select code." );

		float fWinX = 32, fWinY = 80;

		//MenuBar( m_nXOffset+(int)fWinX, MLINE(7+(selected-cheatTopIdx)) + 3, 530, m_nFontHeight+3 ) ;

		//MenuBar( m_nXOffset+32, 16*(11+(selected-cheatTopIdx)) + 3, 530, 19 ) ;

		for ( unsigned int idx = cheatTopIdx ; ( idx < m_numCheats ) && ( idx < cheatTopIdx+10) ; idx++ )
		{
			CHEAT_CODE *code = &(m_cheatCodes[idx]) ;

			swprintf( str, L"%S Adr:0x%04.4X val:%u %S", code->code, code->adr, code->val, code->enabled ? "ON" : "OFF" ) ;
			
			if ( selected == idx )
				m_Font.DrawText( (float)m_nXOffset+32, (float)( MLINE( 7+(idx-cheatTopIdx))), pmenuParams->selectedColor, str, pmenuParams->selectBarColor, 1 );
			else
				m_Font.DrawText( (float)m_nXOffset+32, (float)( MLINE( 7+(idx-cheatTopIdx))), pmenuParams->normalColor, str );
		}
		
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			doEditCode( -1 ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			doEditCode( selected ) ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			if ( m_cheatCodes[selected].enabled )
				m_cheatCodes[selected].enabled = 0 ;
			else
				m_cheatCodes[selected].enabled = 1 ;
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK]) 
		{
			tempbuf = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) * ( m_numCheats - 1 ) ) ;

			memcpy( tempbuf, m_cheatCodes, sizeof(CHEAT_CODE) * selected ) ;

			if ( selected < m_numCheats-1 )
			{
				memcpy( &(tempbuf[selected]), &(m_cheatCodes[selected+1]), sizeof(CHEAT_CODE) * ( (m_numCheats - selected ) - 1) ) ;
			}

			free( m_cheatCodes ) ;

			m_cheatCodes = tempbuf ;
			m_numCheats-- ;
			if ( m_numCheats == 0 )
				break ;

			if ( selected >= (m_numCheats) )
				selected = m_numCheats - 1 ;

		}
		if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
		{
			if ( cheatTopIdx + 10 < m_numCheats )
			{
				cheatTopIdx += 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT)
		{
			if ( cheatTopIdx >= 10 )
			{
				cheatTopIdx -= 10 ;
				selected = cheatTopIdx ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( selected == cheatTopIdx + (10-1) )
			{
				if ( selected < m_numCheats - 1 )
				{
					cheatTopIdx++ ;
					selected++ ;
				}
			}
			else
			{
				if ( selected < m_numCheats-1 )
					selected++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( selected == cheatTopIdx )
			{
				if ( selected > 0 )
				{
					cheatTopIdx-- ;
					selected-- ;
				}
			}
			else
			{
				if ( selected > 0 )
					selected-- ;
			}
		}

		
		
		
		
	}
}

void CXBoxSample::doAddFoundCodes()
{
	CHEAT_CODE code ;

	for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
	{
		if ( m_memMatches[i] )
		{
			code.adr = i ;
			code.val = m_memBuf1[i] ;
			code.enabled = 0 ;
			sprintf( code.code, "01%02.2X%02.2X%02.2X", code.val, code.adr & 0xFF, (code.adr >> 8 ) & 0xFF ) ;

			m_cheatCodes = (CHEAT_CODE*)realloc( m_cheatCodes, sizeof(CHEAT_CODE) * ( m_numCheats  + 1 ) ) ;

			memcpy( &(m_cheatCodes[m_numCheats]),&code, sizeof(CHEAT_CODE) ) ;
			m_numCheats++ ;

		}
	}

	memset( m_memMatches, 0, CONSOLE_MEMORY_SIZE ) ;
	m_currentMemMatches = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );
		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), pmenuParams->normalColor, L"The search found 1 to 4 possible matches for your search." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), pmenuParams->normalColor, L"They have been added to your list." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), pmenuParams->normalColor, L"Press B to go back to the Options menu." );
		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
	}
}

void CXBoxSample::doContinueSearchMenu()
{

	WCHAR str[200];
	int value ;

	memcpy( m_memBuf2, m_consoleMemory, CONSOLE_MEMORY_SIZE ) ;
	value = 0 ;

	while ( 1 )
	{
		m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
							 0x00000000, 1.0f, 0L );
		//RenderGradientBackground( 0xFF000000, 0xFF000000 );
		pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);

		m_Font.Begin();
		m_Font.DrawText( (float)m_nXOffset+  32, 16*2, pmenuParams->normalColor, L"Search Options" );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), pmenuParams->normalColor, L"Press B to go back to the Options menu." );

		swprintf( str, L"Press X to search for this value : %u", value );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), pmenuParams->normalColor, str );

		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(2), pmenuParams->normalColor, L"Press Y to search for values less than before." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), pmenuParams->normalColor, L"Press A to search for values greater than before." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(4), pmenuParams->normalColor, L"Press BLACK to search for values equal to before." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(5), pmenuParams->normalColor, L"Press WHITE to search for values not equal to before." );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(6), pmenuParams->normalColor, L"Press DPAD-UP to add 1 to the value" ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(7), pmenuParams->normalColor, L"Press DPAD-DOWN to subtract 1 from the value" ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(8), pmenuParams->normalColor, L"Press DPAD-RIGHT to add 10 to the value" ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(9), pmenuParams->normalColor, L"Press DPAD-LEFT to subtract 10 from the value" ) ;
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(10), pmenuParams->normalColor, L"Press LS+RS to add the found codes to your list" ) ;

		swprintf( str, L"Number of hits from last search : %u", m_currentMemMatches );
		m_Font.DrawText( (float)m_nXOffset+  32, MLINE(12), pmenuParams->normalColor, str );

		m_Font.End();

		m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

        XBInput_GetInput();
		if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_B])
		{
			break ;
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_A])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] < m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}

			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_X])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf2[i] == value )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_Y])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] > m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] == m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if(g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
		{
			m_currentMemMatches = 0 ;
			for ( int i = 0 ; i < CONSOLE_MEMORY_SIZE ; i++ )
			{
				if ( m_memMatches[i] )
					if ( m_memBuf1[i] != m_memBuf2[i] )
					{
						m_memMatches[i] = 1 ;
						m_currentMemMatches++ ;
					}
					else
						m_memMatches[i] = 0 ;
			}
			if ( m_currentMemMatches == 1 )
			{
				doAddFoundCodes() ;
				break ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			value = ( value - 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			value = ( value + 1 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			value = ( value - 10 ) & 0xFF ;
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			value = ( value + 10  ) & 0xFF ;
		}
		else if ( (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) && (g_Gamepads[0].hDevice && g_Gamepads[0].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) )
		{
			if ( ( m_currentMemMatches > 0 ) && ( m_currentMemMatches < 5 ) )
			{
				doAddFoundCodes() ;
				break ;
			}
			else
			{
				while ( 1 )
				{
					m_pd3dDevice->Clear( 0L, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL|D3DCLEAR_TARGET,
										 0x00000000, 1.0f, 0L );
					//RenderGradientBackground( 0xFF000000, 0xFF000000 );
					pmenuParams->panel->Render(0, 0, 640, 480, 0, 0, 640*VIDEOMODES[m_xboxVidmode].multx, 480*VIDEOMODES[m_xboxVidmode].multy);

					m_Font.Begin();
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(0), pmenuParams->normalColor, L"You can only add when you have narrowed " ) ;
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(1), pmenuParams->normalColor, L"it down to less than 5 matches." );
					m_Font.DrawText( (float)m_nXOffset+  32, MLINE(3), pmenuParams->normalColor, L"Press B to go back." );
					m_Font.End();

					m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

					XBInput_GetInput();
					if ( g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[ XINPUT_GAMEPAD_B ] ) 
					{
						break ;
					}
				}
			}
		}
	}
	memcpy( m_memBuf1, m_memBuf2, CONSOLE_MEMORY_SIZE ) ;
}






void CXBoxSample::MenuBar( int xpos, int ypos, int xlen, int ylen )
{
	static DWORD oldcolor = 0xFFFFFFFF ;
/*
	if ( oldcolor != pmenuParams->selectBarColor )
	{
		RECT rectSource;
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 0;
		rectSource.right  = 0 ;

		D3DLOCKED_RECT d3dlr;
		WhiteTexture->LockRect(0, &d3dlr, &rectSource, 0);

		memcpy( d3dlr.pBits, &(pmenuParams->selectBarColor), sizeof(pmenuParams->selectBarColor) ) ;

		// Unlock our texture
		WhiteTexture->UnlockRect(0);

		oldcolor = pmenuParams->selectBarColor ;
	}
*/
	D3DXVECTOR2 vecScale( 1, 1 ) ;
	D3DXVECTOR2 vecTranslate( (float)xpos, (float)ypos ) ;
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	RECT rectSource;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = ylen - 1 ;
	rectSource.right  = xlen - 1;
	
	if ( MenuSprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);

	MenuSprite->Draw(WhiteTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
}

void CXBoxSample::ColorBar( int xpos, int ypos, int xlen, int ylen, DWORD color )
{
	static DWORD oldcolor = 0xFFFFFFFF ;

	if ( oldcolor != color )
	{
		RECT rectSource;
		rectSource.top = 0;
		rectSource.left = 0;
		rectSource.bottom = 0;
		rectSource.right  = 0 ;

		D3DLOCKED_RECT d3dlr;
		WhiteTexture->LockRect(0, &d3dlr, &rectSource, 0);

		memcpy( d3dlr.pBits, &color, sizeof(color) ) ;

		// Unlock our texture
		WhiteTexture->UnlockRect(0);

		oldcolor = color ;
	}

	D3DXVECTOR2 vecScale( 1, 1 ) ;
	D3DXVECTOR2 vecTranslate( (float)xpos, (float)ypos ) ;
	D3DXCOLOR d3color(1.0, 1.0, 1.0, 1.0);
	RECT rectSource;

	rectSource.top = 0;
	rectSource.left = 0;
	rectSource.bottom = ylen - 1 ;
	rectSource.right  = xlen - 1;
	
	if ( MenuSprite == NULL )
		D3DXCreateSprite(m_pd3dDevice, &MenuSprite);

	MenuSprite->Draw(WhiteTexture, &rectSource, &vecScale, NULL, 0, &vecTranslate, d3color);
}




void CXBoxSample::QuickSort( int lo, int hi )
{
	int i = lo;
	int j = hi;
	char partitionStr[200];
	FILENAME tmpf;

	strcpy( partitionStr, (const char*)files[(i+j)/2].filename ) ;
	do
	{
		while ( stricmp( (const char*)files[i].filename, partitionStr ) < 0 ) i++ ;
		while ( stricmp( partitionStr, (const char*)files[j].filename ) < 0 ) j-- ;

		if (i <= j)
		{
			memcpy( &tmpf, &(files[i]), sizeof(tmpf) ) ;
			memcpy( &(files[i]), &(files[j]), sizeof(tmpf) ) ;
			memcpy( &(files[j]), &tmpf, sizeof(tmpf) ) ;
			i++;
			j--;
		}
	} while (i <= j);

	if (lo < j) QuickSort(lo, j);
	if (i < hi) QuickSort(i, hi);

	
}


void CXBoxSample::FindAvailRoms( char *dir)
{

	int isSMB ;
	int isRelax ;
	int dd ;
	SMBdirent *direntry;
	HANDLE hFind;	
	WIN32_FIND_DATAA oFindData;
	int  numfound ;
	char parentDir[MAX_PATH] ;
	char smbDir[1024] ;
	char *p, *start ;


	isSMB = ( strlen(dir)>4 ) && ( ( strncmp( dir, "SMB:\\", 5 ) == 0 ) || ( strncmp( dir, "smb:\\", 5 ) == 0 ) ) ;
	isRelax = ( strlen(dir)>4 ) && ( ( strncmp( dir, "RLX:\\", 5 ) == 0 ) || ( strncmp( dir, "rlx:\\", 5 ) == 0 ) ) ;
	

	if ( isSMB )
	{

		sprintf( smbDir, "%s%s", m_smbShare, dir+4 ) ;


		while ( p = strchr( smbDir, '\\' ) )
			*p = '/' ;


		p = strrchr( smbDir, '*' ) ;

		if ( p )
			*p = 0 ;

		//sprintfx( "smbdir=%s\r\n", smbDir ) ;


		dd = m_smb.opendir( smbDir );

		if ( dd )
		{
			//sprintfx("got dd\r\n") ;
			direntry = m_smb.readdir(dd) ;
		}
		else
		{
			//sprintfx("no got dd\r\n") ;
			direntry = NULL ;
		}

	}
	else if ( isRelax )
	{
	}
	else
	{
		// Search for all files in our rom directory
		hFind = FindFirstFile( dir, &oFindData);
	}




	//writexbox( dir ) ;

	if (files != NULL)
	{
		delete [] files;
		files = NULL;
	}

	files = new FILENAME[4096];

	numfiles = 0 ;


	strcpy( parentDir, dir ) ;

	//writexbox( "find1\r\n" ) ;

	p = strrchr( parentDir, '*' ) ;

	if ( p )
		*p = 0 ;

	strcpy( m_szCurrentDir, parentDir ) ;

	p = strrchr( parentDir, '\\' ) ;

	if ( p )
		*p = 0 ;


	p = strrchr( parentDir, '\\' ) ;

	if ( p )
		*p = 0 ;


	strcat( parentDir, "\\" ) ;

	//writexbox( "find1\r\n" ) ;

	//writexbox( m_szCurrentDir ) ;

	strcpy ( (char*)files[numfiles].filename, ".." ) ;
	files[numfiles].name[0] = 0 ;
	//strcpy( (char*)(files[numfiles].filename), parentDir ) ;
	//strcat( (char*)files[numfiles].filename, "*" ) ;
	//strlwr( (char*)( files[numfiles].filename )) ;
    swprintf( files[numfiles].name, L"<%S>", parentDir );
	files[numfiles].isDir = 1 ;

	//sprintfx( "name=%s, fname=%s\r\n", parentDir, files[numfiles].filename ) ;

	numfiles++ ;

	if ( isRelax )
	{
		HRESULT res ;
		res = m_relax.GetDirectory( m_szCurrentDir, files ) ;

		while ( strchr( m_szCurrentDir, '/' ) )
			*strchr( m_szCurrentDir, '/' ) = '\\' ;

		if ( res > 0  )
			numfiles = res ;

		QuickSort( 1, numfiles-1 ) ;

		return ;
	}


	// If we didn't find any just return
	if ( (hFind == INVALID_HANDLE_VALUE) && ( !isSMB ) )
	{
		return;
	}
	
	// If we didn't find any just return
	if ( !direntry && ( isSMB ) )
	{
		return;
	}

	do 
	{


		files[numfiles].name[0] = 0 ;
		files[numfiles].filename[0] = 0 ;

		if ( isSMB )
		{

				files[numfiles].isDir = ( ( direntry->st_mode & 0x4000 ) > 0 );


				strcpy( (char*)(files[numfiles].filename), direntry->d_name ) ;

				//sprintfx( "name=%s mode=%08.8X\r\n", direntry->d_name, direntry->st_mode ) ;
				//sprintfx( "  %u %u %d %d %d %u %u\r\n", direntry->st_dev, direntry->st_ino,
					//direntry->st_nlink, direntry->st_uid, direntry->st_gid, direntry->st_rdev,
					//direntry->st_size ) ;
/*
        _dev_t st_dev;
        _ino_t st_ino;
        short st_nlink;
        short st_uid;
        short st_gid;
        _dev_t st_rdev;
        _off_t st_size;
*/

		}
		else
		{
			strcpy( (char*)(files[numfiles].filename), oFindData.cFileName ) ;
			strlwr( (char*)( files[numfiles].filename )) ;
			files[numfiles].isDir = ( oFindData.dwFileAttributes  & FILE_ATTRIBUTE_DIRECTORY ) ;
		}


		if ( files[numfiles].isDir )
		{
			swprintf( files[numfiles].name, L"<%S>", files[numfiles].filename );
		}
		else
		{
			swprintf( files[numfiles].name, L"%S", files[numfiles].filename );
		}

		if ( isSMB && ( ( strcmp( direntry->d_name, "." ) == 0 ) || ( strcmp( direntry->d_name, ".." ) == 0 ) || ( direntry->d_name[0] == 0 ) ) )
		{
		}
		else
			numfiles++ ;

		if ( numfiles > 4095 )
		{
			numfiles-- ;
			break ;
		}

	} while ( ( ( !isSMB ) && (FindNextFile(hFind, &oFindData) ) ) || ( isSMB && ( direntry = m_smb.readdir(dd) ) ) );

	if ( isSMB )
	{
		int closeres =m_smb.closedir(dd);
	}
	else
	{
		FindClose( hFind );
	}

	numfound = numfiles ;

	QuickSort( 1, numfiles-1 ) ;
}



//*****************************************************************************************
BOOL IsEthernetConnected()
{
	if (!(XNetGetEthernetLinkStatus() & XNET_ETHERNET_LINK_ACTIVE))
		return FALSE;

	return TRUE;
}


//*****************************************************************************************
BOOL InitializeNetwork()
{
	g_szTitleIP[0] = 0;

	if (!IsEthernetConnected())
		return FALSE;

	// if local address is specified
	if ( (g_szLocalAddress[0]!=0) &&
		 (g_szLocalSubnet[0]!=0)  &&
		 (g_szLocalGateway[0]!=0)  )

	{
		// Thanks and credits to Team Evox for the description of the 
		// XNetConfigParams structure.

		TXNetConfigParams configParams;   

		OutputDebugString("Loading network configuration...\n");
		XNetLoadConfigParams( (LPBYTE) &configParams );
		OutputDebugString("Ready.\n");

		BOOL bXboxVersion2 = (configParams.V2_Tag == 0x58425632 );	// "XBV2"
		BOOL bDirty = FALSE;

		OutputDebugString("User local address: ");
		OutputDebugString(g_szLocalAddress);
		OutputDebugString("\n");
	
		if (bXboxVersion2)
		{
			if (configParams.V2_IP != inet_addr(g_szLocalAddress))
			{
				configParams.V2_IP = inet_addr(g_szLocalAddress);
				bDirty = TRUE;
			}
		}
		else
		{
			if (configParams.V1_IP != inet_addr(g_szLocalAddress))
			{
				configParams.V1_IP = inet_addr(g_szLocalAddress);
				bDirty = TRUE;
			}
		}

		OutputDebugString("User subnet mask: ");
		OutputDebugString(g_szLocalSubnet);
		OutputDebugString("\n");

		if (bXboxVersion2)
		{
			if (configParams.V2_Subnetmask != inet_addr(g_szLocalSubnet))
			{
				configParams.V2_Subnetmask = inet_addr(g_szLocalSubnet);
				bDirty = TRUE;
			}
		}
		else
		{
			if (configParams.V1_Subnetmask != inet_addr(g_szLocalSubnet))
			{
				configParams.V1_Subnetmask = inet_addr(g_szLocalSubnet);
				bDirty = TRUE;
			}
		}

		OutputDebugString("User gateway address: ");
		OutputDebugString(g_szLocalGateway);
		OutputDebugString("\n");

		if (bXboxVersion2)
		{
			if (configParams.V2_Defaultgateway != inet_addr(g_szLocalGateway))
			{
				configParams.V2_Defaultgateway = inet_addr(g_szLocalGateway);
				bDirty = TRUE;
			}
		}
		else
		{
			if (configParams.V1_Defaultgateway != inet_addr(g_szLocalGateway))
			{
				configParams.V1_Defaultgateway = inet_addr(g_szLocalGateway);
				bDirty = TRUE;
			}
		}

		if (configParams.Flag != (0x04|0x08) )
		{
			configParams.Flag = 0x04 | 0x08;
			bDirty = TRUE;
		}

		if (bDirty)
		{
			OutputDebugString("Updating network configuration...\n");
			XNetSaveConfigParams( (LPBYTE) &configParams );
			OutputDebugString("Ready.\n");
		}
	}

	XNetStartupParams xnsp;
	memset(&xnsp, 0, sizeof(xnsp));
	xnsp.cfgSizeOfStruct = sizeof(XNetStartupParams);

	// Bypass security so that we may connect to 'untrusted' hosts
	xnsp.cfgFlags = XNET_STARTUP_BYPASS_SECURITY;
  // create more memory for networking
  xnsp.cfgPrivatePoolSizeInPages = 64; // == 256kb, default = 12 (48kb)
  xnsp.cfgEnetReceiveQueueLength = 16; // == 32kb, default = 8 (16kb)
  xnsp.cfgIpFragMaxSimultaneous = 16; // default = 4
  xnsp.cfgIpFragMaxPacketDiv256 = 32; // == 8kb, default = 8 (2kb)
  xnsp.cfgSockMaxSockets = 64; // default = 64
  xnsp.cfgSockDefaultRecvBufsizeInK = 128; // default = 16
  xnsp.cfgSockDefaultSendBufsizeInK = 128; // default = 16
	INT err = XNetStartup(&xnsp);

	XNADDR xna;
	DWORD dwState;
	do
	{
		dwState = XNetGetTitleXnAddr(&xna);
		Sleep(500);
	} while (dwState==XNET_GET_XNADDR_PENDING);

	XNetInAddrToString(xna.ina,g_szTitleIP,32);

	WSADATA WsaData;
	err = WSAStartup( MAKEWORD(2,2), &WsaData );

	/*
	if (err == NO_ERROR)
	{
		gXBFileZilla = new CXBFileZilla("Q:\\");
		gXBFileZilla->Start();
	}
	*/

	return ( err == NO_ERROR );
}



// check for move cursor and move accordingly (with clamp etc)
void CXBoxSample::MoveCursor()
{
	char c ;
	int  lcv ;

		if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv < (int)numfiles ) && ( tolower(files[lcv].filename[0]) <= c ) )
				lcv++ ;

			if ( lcv < (int)numfiles )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if (g_Gamepads[0].hDevice && g_Gamepads[0].bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])
		{
			c = tolower(files[curr].filename[0]) ;

			lcv = curr ;

			while ( ( lcv >= 0 ) && ( tolower(files[lcv].filename[0]) >= c ) )
				lcv-- ;

			if ( lcv >= 0 )
			{
				topIdx = lcv ;
				curr = lcv ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT ) 
		{
			if ( topIdx >= (unsigned int)m_namesPerPage )
			{
				topIdx -= m_namesPerPage ;
				curr = topIdx ;
			}
			else
			{
				topIdx = 0 ;
				curr = 0 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT ) 
		{
			if ( topIdx + m_namesPerPage < numfiles )
			{
				topIdx += m_namesPerPage ;
				curr = topIdx ;
			}
			else
			{
				topIdx = numfiles - 1 ;
				curr = numfiles - 1 ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN ) 
		{
			if ( curr == topIdx + (m_namesPerPage-1) )
			{
				if ( curr < numfiles - 1 )
				{
					topIdx++ ;
					curr++ ;
				}
			}
			else
			{
				if ( curr < numfiles-1 )
					curr++ ;
			}
		}
		else if ( g_Gamepads[0].hDevice && g_Gamepads[0].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP ) 
		{
			if ( curr == topIdx )
			{
				if ( curr > 0 )
				{
					topIdx-- ;
					curr-- ;
				}
			}
			else
			{
				if ( curr > 0 )
					curr-- ;
			}
		}

		if ( ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) || ( m_DefaultGamepad.wButtons & XINPUT_GAMEPAD_DPAD_DOWN ) )
		{
			keyTime++ ;
		}
		else
		{
			keyTime = 0 ;
		}

		if ( keyTime > 20 )
		{
			if ( g_Gamepads[0].hDevice && g_Gamepads[0].wButtons & XINPUT_GAMEPAD_DPAD_UP ) 
			{
				if ( curr == topIdx )
				{
					if ( curr > 0 )
					{
						topIdx-- ;
						curr-- ;
					}
				}
				else
				{
					if ( curr > 0 )
						curr-- ;
				}
			}
			else
			{
				if ( curr == topIdx + (m_namesPerPage-1) )
				{
					if ( curr < numfiles - 1 )
					{
						topIdx++ ;
						curr++ ;
					}
				}
				else
				{
					if ( curr < numfiles-1 )
						curr++ ;
				}
			}
		}
}




void CXBoxSample::cht_load()
{
	FILE *f;
	int fsize ;
	int numread ;

	if (m_cheatCodes != NULL)
	{
		free(m_cheatCodes);
		m_cheatCodes = NULL;
	}
	

	f = fopen(g_chtfile, "rb");
	if (!f) return ;

	fseek( f, 0, SEEK_END ) ;
	fsize = ftell( f ) ;
	fseek( f, 0, SEEK_SET ) ;

	m_numCheats = fsize / sizeof(CHEAT_CODE) ;

	m_cheatCodes = (CHEAT_CODE*)malloc( sizeof(CHEAT_CODE) *  m_numCheats );


	numread = 0 ;
	fread(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
}

void CXBoxSample::cht_save()
{
	FILE *f;

	if ( m_numCheats == 0 )
	{
		DeleteFile( g_chtfile ) ;
		return ;
	}

	f = fopen(g_chtfile, "wb");
	if (!f) return ;

	fwrite(m_cheatCodes, sizeof(CHEAT_CODE), m_numCheats, f);

	fclose(f);
	
}

BOOL CXBoxSample::hasFiles( int idx )
{
	FILE				*infile ;
	char *p;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".srm");

	strcpy(g_bramfile, g_saveprefix);
	strcat(g_bramfile, ".brm");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( g_statefile, "%s.sta", g_saveprefix ) ;

	infile = fopen( g_sramfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_bramfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_chtfile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	infile = fopen( g_statefile, "rb" ) ;

	if ( infile )
	{
		fclose(infile) ;
		return TRUE ;
	}

	return FALSE ;

}
void CXBoxSample::updateCheats( )
{
	for ( unsigned int i = 0 ; i < m_numCheats ; i++ )
	{
		if ( m_cheatCodes[i].enabled )
			m_consoleMemory[ m_cheatCodes[i].adr ] = ( m_cheatCodes[i].val & 0xFF ) ;
	}
}

void CXBoxSample::deleteSaveFiles( int idx )
{
	char *p;


	strcpy( g_saveprefix, g_savePath ) ;
	strcat( g_saveprefix, "\\" ) ;
	strcat( g_saveprefix, (const char*)(files[idx].filename) ) ;
	//sprintf(saveprefix, "%s\\%s", savedir, (const char*)files[idx].filename);
	p = strchr(g_saveprefix, '.');
	if (p) *p = 0;

	strcpy(g_sramfile, g_saveprefix);
	strcat(g_sramfile, ".srm");

	strcpy(g_bramfile, g_saveprefix);
	strcat(g_bramfile, ".brm");

	strcpy(g_keysfile, g_saveprefix);
	strcat(g_keysfile, ".key");

	strcpy(g_chtfile, g_saveprefix);
	strcat(g_chtfile, ".cht");

	sprintf( g_statefile, "%s.sta", g_saveprefix ) ;

	DeleteFile( g_sramfile ) ;
	DeleteFile( g_keysfile ) ;
	DeleteFile( g_bramfile ) ;
	DeleteFile( g_chtfile ) ;
	DeleteFile( g_statefile ) ;

}
#ifdef __cplusplus
extern "C" {
#endif


void audio_callback()
{
	//g_sound->process( *g_apptime, *g_numframes ) ;

}

char* xbox_get_sramfile()
{
	return g_app->g_sramfile ;
}

char* xbox_get_statefile()
{
	return g_app->g_statefile ;
}

void xbox_pause_audio( int state ) 
{
	//g_mp3player->pause( state ) ;
	g_sound->pause( state ? true : false ) ;
}


void xbox_play_mp3( char *mp3filename, int repeat ) 
{
	if ( ! g_mp3player->loadFile( mp3filename, repeat, 0, 75*60*70 ) )
	{
		g_mp3player->insertSilence( 22050 ) ;
		g_mp3player->pause( 0 ) ;
	}

}


DWORD cpp_GetTickCount()
{
//	writexbox( "before tick") ;
	return GetTickCount() ;
//	writexbox( "after tick") ;
}

void cpp_Sleep( DWORD amt )
{

	Sleep(amt) ;
}


void writexbox( char *msg )
{
	static FILE *outfile = NULL ;
	//MEMORYSTATUS stat;

	//fwrite( msg, sizeof(char), strlen(msg), g_app->m_logfile ) ;
	//fflush( g_app->m_logfile ) ;
	//GlobalMemoryStatus( &stat );
	OUTPUT_DEBUG_STRING( msg ) ;
#ifdef USE_DEBUGCLIENT
	if ( g_debugClient )
		g_debugClient->SendSync( msg, strlen(msg) ) ;
#endif
	if ( m_doDebug )
	{
		if ( outfile == NULL )
		{
			outfile = fopen( "e:\\SAVES\\xportdebug.txt", "wb" ) ;
		}
		if ( outfile )
		{
			fprintf( outfile, "%s", msg ) ;
			fflush( outfile ) ;
		}
	}

	//if ( stat.dwAvailPhys < 5000000 )
		//g_debugClient->WaitKey() ;
}

void writexboxwait( char *msg )
{

	//fwrite( msg, sizeof(char), strlen(msg), g_app->m_logfile ) ;
	//fflush( g_app->m_logfile ) ;

	//g_debugClient->Send( msg, strlen(msg) ) ;
	//g_debugClient->WaitKey() ;
}

void xbox_print_memory()
{
					MEMORYSTATUS stat;

					GlobalMemoryStatus( &stat );
					sprintfx( "memory=%u\r\n", stat.dwAvailPhys ) ; 
}



void _4xSaI(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;

#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	_2xSaI( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	_2xSaI( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;

#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif

}
void _4xSaIScanline(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	_2xSaIScanline( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	_2xSaIScanline( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void SuperEagle4x(uint8 *srcPtr, uint32 srcPitch,
		uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	SuperEagle( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	SuperEagle( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void SuperEagleScanline4x(uint8 *srcPtr, uint32 srcPitch,
		uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	SuperEagleScanline( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	SuperEagleScanline( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void Super4xSaI(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	Super2xSaI( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	Super2xSaI( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void Super4xSaIScanline(uint8 *srcPtr, uint32 srcPitch,
		 uint8 *deltaPtr,
		 uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	Super2xSaIScanline( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	Super2xSaIScanline( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void Scale4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	Scale2x( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	Scale2x( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void SuperScale4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	SuperScale( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	SuperScale( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void SuperScaleScanline4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	SuperScaleScanline( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	SuperScaleScanline( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void Eagle4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	Eagle( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	Eagle( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void EagleScanline4x(uint8 *srcPtr, uint32 srcPitch,
	     uint8 *deltaPtr,
	     uint8 *dstPtr, uint32 dstPitch, int width, int height, int scanmode)
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	EagleScanline( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanmode ) ;
	EagleScanline( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanmode ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}

void Simple4x(unsigned char *srcPtr, uint32 srcPitch, unsigned char * /* deltaPtr */,
              unsigned char *dstPtr, uint32 dstPitch, int width, int height, int scanlines) 
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*480*2 ) ;
	Simple2x( srcPtr, srcPitch, NULL, newbuf, width*4, width, height, scanlines ) ;
	Simple2x( newbuf+width*4, width*4, NULL, dstPtr, dstPitch, width*2, height*2, scanlines ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}
void AdMame4x(unsigned char *srcPtr, uint32 srcPitch, unsigned char *deltaPtr ,
              unsigned char *dstPtr, uint32 dstPitch, int width, int height, int scanline) 
{
	unsigned char *newbuf ;
#ifdef USE4X_BLITBUF
	//newbuf = (unsigned char*)malloc( width * 2 * (height+2) * 2 * 2 ) ;
	newbuf = g_app->g_pBlitBuff ;
#else
	newbuf = (unsigned char*)malloc( (width+1)*2*height*2*2 ) ;
	if ( !newbuf )
		return ;
#endif

	//memset( g_app->g_pDeltaBuff, 0xFF, g_app->m_pitch*1200 ) ;
	AdMame2x( srcPtr, srcPitch, deltaPtr, newbuf, width*4, width, height, scanline ) ;
	AdMame2x( newbuf+width*4, width*4, deltaPtr, dstPtr, dstPitch, width*2, height*2, scanline ) ;
#ifndef USE4X_BLITBUF
	free(newbuf) ;
#endif
}

void xbox_set_refreshrate( int rate )
{
	int nativeRate ;
	D3DPRESENT_PARAMETERS holdpp ;


	sprintfx( "set refresh %u\r\n", rate ) ;

	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//get supported video flags
		DWORD videoFlags = XGetVideoFlags();
		
		//set pal60 if available.
		if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)
			nativeRate = 60 ;
		else
			nativeRate = 50 ;
	}
	else
		nativeRate = 60 ;

	if ( rate != g_app->m_d3dpp.FullScreen_RefreshRateInHz )
	{
		sprintfx( "rate is diff\r\n" ) ;
		g_app->m_d3dpp.FullScreen_RefreshRateInHz = rate ;

		if ( nativeRate != rate )
		{
			sprintfx( "set emu\r\n" ) ;
			g_app->m_d3dpp.Flags |= D3DPRESENTFLAG_EMULATE_REFRESH_RATE ;
		}
		else
		{
			sprintfx( "unset emu\r\n" ) ;
			g_app->m_d3dpp.Flags &= ~D3DPRESENTFLAG_EMULATE_REFRESH_RATE ;
		}
/*
		if ( g_app->m_d3dpp.BackBufferWidth == 1920 )
		{
			g_app->m_d3dpp.Flags &= ~D3DPRESENTFLAG_EMULATE_REFRESH_RATE ;
			g_app->m_d3dpp.FullScreen_RefreshRateInHz = nativeRate ;

		}
*/
		memcpy( &holdpp, &g_app->m_d3dpp, sizeof(D3DPRESENT_PARAMETERS) ) ;

		recreate( &g_app->m_d3dpp ) ;

		memcpy( &g_app->m_d3dpp, &holdpp, sizeof(D3DPRESENT_PARAMETERS) ) ;

		g_app->m_pd3dDevice->Reset(&g_app->m_d3dpp);

		memcpy( &g_app->m_d3dpp, &holdpp, sizeof(D3DPRESENT_PARAMETERS) ) ;
	}
}


int xbox_can_print()
{
	return g_debugClient ? 1 : 0 ;
}

int xbox_get_refresh_rate()
{
	return g_app->m_d3dpp.FullScreen_RefreshRateInHz ;
}


#ifdef __cplusplus
}
#endif



