/*

    This file is part of the smb++ library

    Copyright (C) 1999  Nicolas Brodu

    nicolas.brodu@free.fr



    This program is free software; you can redistribute it and/or modify

    it under the terms of the GNU General Public License as published by

    the Free Software Foundation; either version 2 of the License, or

    (at your option) any later version.



    This program is distributed in the hope that it will be useful,

    but WITHOUT ANY WARRANTY; without even the implied warranty of

    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

    GNU General Public License for more details.



    You should have received a copy of the GNU General Public License

    along with this program, see the file COPYING; if not, write

    to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge,

    MA 02139, USA.

*/



#ifndef __NAME_SERVICE_PACKET_H__

#define __NAME_SERVICE_PACKET_H__



#include "defines.h"

#ifndef USE_SAMBA

#include "NetBIOSPacket.h"



/*

RFC 1002 :



Packet structure :



                        1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3

    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |                                                               |

   + ------                                                ------- +

   |                            HEADER                             |

   + ------                                                ------- +

   |                                                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |                                                               |

   /                       QUESTION ENTRIES                        /

   |                                                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |                                                               |

   /                    ANSWER RESOURCE RECORDS                    /

   |                                                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |                                                               |

   /                  AUTHORITY RESOURCE RECORDS                   /

   |                                                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |                                                               |

   /                  ADDITIONAL RESOURCE RECORDS                  /

   |                                                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

*/



class ResourceRecord

{

/*RESOURCE RECORD



                        1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3

    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |                                                               |

   /                            RR_NAME                            /

   /                                                               /

   |                                                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |           RR_TYPE             |          RR_CLASS             |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |                              TTL                              |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |           RDLENGTH            |                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                               |

   /                                                               /

   /                             RDATA                             /

   |                                                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

*/

protected:

	char *rrName;	// NetBIOS format

	uint16 nameLength;

	uint16 rrType;

	uint16 rrClass;

	uint32 ttl;

	uint8 *data;

	uint16 dataLength;

public:

	ResourceRecord(const char *n, uint16 t, uint16 c, uint16 l, uint8* d, uint16 dl);

	uint8* build();

	uint16 getLength();

	~ResourceRecord();

};





class NameServicePacket : public NetBIOSPacket

{

protected:

/*HEADER :

                        1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3

    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |         NAME_TRN_ID           | OPCODE  |   NM_FLAGS  | RCODE |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |          QDCOUNT              |           ANCOUNT             |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |          NSCOUNT              |           ARCOUNT             |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

*/

	uint16 name_trn_id;

	uint32 opcode;

	uint32 nmFlags;

	uint32 rcode;

	uint16 qdcount;

	uint16 ancount;

	uint16 nscount;

	uint16 arcount;

/*QUESTION SECTION :

                        1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3

    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |                                                               |

   /                         QUESTION_NAME                         /

   /                                                               /

   |                                                               |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

   |         QUESTION_TYPE         |        QUESTION_CLASS         |

   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

*/

	char *questionName;        // NetBIOS Format

	uint16 questionNameLength;

	uint16 questionType;

	uint16 questionClass;



	ResourceRecord *answerRR;

	ResourceRecord *authorityRR;

	ResourceRecord *additionalRR;



public:

	NameServicePacket();

	~NameServicePacket();

	// Parent virtuals

	// Returns a pointer to a packet ready to be sent

	uint8* packet();

	// Get the real length of the packet in byte

	uint16 getLength();

	// Below : unused at this level, maybe subclasses will use it

	int8 getType() {return opcode;}

	uint16 getDataLength() {return 0;}

	uint8 *getData() {return 0;}

};



class NameQueryPacket : public NameServicePacket

{

/*protected:

	bool isGroup;*/

public:

	// Argument is a clear asciiz name

	NameQueryPacket(const char *name, uint8 broadcast=0, uint16 id=0, uint8 status=0, bool groupFlag=false);

	char *getQueryNBName();

	// argument is a mangled NetBIOS Name

//	void setQueryNBName(const char *n, bool groupFlag=false);

};



class NameConflictDemand : public NameServicePacket

{

public:

	// Argument is a clear asciiz name

	NameConflictDemand(const char *name, uint16 id=0);

};



#endif

#endif // __NAME_SERVICE_PACKET_H__

