/*				 -*- buffer-read-only: t -*- vi: set ro:
** 
** DO NOT EDIT THIS FILE   (prefs.c)
** 
** It has been AutoGen-ed  Saturday March 30, 2002 at 04:48:41 PM CET
** From the definitions    prefs.def
** and the template file   prefs
*/

/*
** Heroes is free software.
** 
** You may redistribute it and/or modify it under the terms of the
** GNU General Public License, as published by the Free Software
** Foundation; either version 2, or (at your option) any later version.
** 
** Heroes is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with Heroes.  See the file "COPYING".  If not,
** write to:  The Free Software Foundation, Inc.,
**            59 Temple Place - Suite 330,
**            Boston,  MA  02111-1307, USA.
*/


#include "system.h"
#include "prefs.h"
#include "debugmsg.h"
#include "rsc_files.h"
#include "getshline.h"
#include "keyvalues.h"
#include "errors.h"
#include "misc.h"

a_pref_set opt;
static char* ignored_lines = 0;
static int firstline;
static char* name = 0;

static char*
preferences_file (void)
{
  if (!name)
    name = get_non_null_rsc_file ("pref-file");
  return name;
}

void
reinit_preferences (void)
{
  opt.radar_map = true;
  opt.display_infos = true;
  opt.luminance = 6;
  opt.inertia = true;
  opt.music = true;
  opt.music_volume = 6;
  opt.sfx = true;
  opt.sfx_volume = 6;
  opt.ctrl_one = 1;
  opt.autopilot_one = true;
  opt.ctrl_two = 1;
  opt.autopilot_two = true;
  opt.speed = 0;
  opt.gamerounds = 4;
  opt.player_color[0] = 0;
  opt.player_color[1] = 1;
  opt.player_color[2] = 2;
  opt.player_color[3] = 3;
  opt.extras = 0;
  opt.player_keys[0][0] = HK_Up;
  opt.player_keys[0][1] = HK_Left;
  opt.player_keys[0][2] = HK_Down;
  opt.player_keys[0][3] = HK_Right;
  opt.player_keys[0][4] = HK_CtrlR;
  opt.player_keys[0][5] = HK_ShiftR;
  opt.player_keys[1][0] = HK_E;
  opt.player_keys[1][1] = HK_S;
  opt.player_keys[1][2] = HK_D;
  opt.player_keys[1][3] = HK_F;
  opt.player_keys[1][4] = HK_CtrlL;
  opt.player_keys[1][5] = HK_ShiftL;
}

void
free_preferences (void)
{
  dmsg (D_MISC, "free preferences");

  XFREE0 (name);
  XFREE0 (ignored_lines);
}

void
output_preferences (FILE* fs)
{
  fprintf (fs, "# Whether the radar must be drawn.\n");
  fprintf (fs, "heroes.screen.display_radar: %d\n", opt.radar_map);
  fprintf (fs, "# Whether game counters must be drawn.\n");
  fprintf (fs, "heroes.screen.display_infos: %d\n", opt.display_infos);
  fprintf (fs, "# Gamma setting.\n");
  fprintf (fs, "heroes.screen.gamma: %d\n", opt.luminance);
  fprintf (fs, "# Whether the camera moves with inertia.\n");
  fprintf (fs, "heroes.screen.inertia: %d\n", opt.inertia);
  fprintf (fs, "# Whether music is enabled.\n");
  fprintf (fs, "heroes.sound.music_enable: %d\n", opt.music);
  fprintf (fs, "# Music volume.\n");
  fprintf (fs, "heroes.sound.music_volume: %d\n", opt.music_volume);
  fprintf (fs, "# Whether sound effects are enabled.\n");
  fprintf (fs, "heroes.sound.sfx_enable: %d\n", opt.sfx);
  fprintf (fs, "# Sound effects volume.\n");
  fprintf (fs, "heroes.sound.sfx_volume: %d\n", opt.sfx_volume);
  fprintf (fs, "# Control type for player one (0=key, 1=joy).\n");
  fprintf (fs, "heroes.control.player1: %d\n", opt.ctrl_one);
  fprintf (fs, "# Whether player one wants autopilot.\n");
  fprintf (fs, "heroes.control.autopilot1: %d\n", opt.autopilot_one);
  fprintf (fs, "# Control type for player two (0=key, 1=joy).\n");
  fprintf (fs, "heroes.control.player2: %d\n", opt.ctrl_two);
  fprintf (fs, "# Whether player two wants autopilot.\n");
  fprintf (fs, "heroes.control.autopilot2: %d\n", opt.autopilot_two);
  fprintf (fs, "# Speed of the game.\n");
  fprintf (fs, "heroes.game.speed: %d\n", opt.speed);
  fprintf (fs, "# Index of the number of rounds (not the number itself).\n");
  fprintf (fs, "heroes.game.gamerounds: %d\n", opt.gamerounds);
  fprintf (fs, "# Color for players.\n");
  fprintf (fs, "heroes.game.player_colors: %d %d %d %d\n",
	       opt.player_color[0],
	       opt.player_color[1],
	       opt.player_color[2],
	       opt.player_color[3]);
  fprintf (fs, "# How extras levels are included.\n");
  fprintf (fs, "heroes.extras.mode: %d\n", opt.extras);
  fprintf (fs, "# Keycodes for player one.\n");
  fprintf (fs, "heroes.%s.player1_keys: %d %d %d %d %d %d\n", keys_pref_group (),
	       opt.player_keys[0][0],
	       opt.player_keys[0][1],
	       opt.player_keys[0][2],
	       opt.player_keys[0][3],
	       opt.player_keys[0][4],
	       opt.player_keys[0][5]);
  fprintf (fs, "# Keycodes for player two.\n");
  fprintf (fs, "heroes.%s.player2_keys: %d %d %d %d %d %d\n", keys_pref_group (),
	       opt.player_keys[1][0],
	       opt.player_keys[1][1],
	       opt.player_keys[1][2],
	       opt.player_keys[1][3],
	       opt.player_keys[1][4],
	       opt.player_keys[1][5]);

  if (ignored_lines)
    fprintf (fs, "# Currently ignored preferences.\n%s", ignored_lines);
}

bool
save_preferences (void)
{
  FILE* fs;

  dmsg (D_MISC, "save preferences to %s", preferences_file ());
  fs = fopen (preferences_file (), "wt");
  if (fs == 0) {
     wmsg ("cannot save preferences to %s", preferences_file ());
     dperror ("fopen");
     return true;
  }
  output_preferences (fs);
  fclose (fs);
  return false;
}

static unsigned long int
parse_unsigned (char *token, unsigned long int min, unsigned long int max)
{
  unsigned long int val = strtoul (token, 0, 10);
  if (val < min || val > max) {
    wmsg ("%s:%d: value %s is out of range (%lu-%lu)",
          preferences_file (), firstline, token, min, max);
    val = (val < min) ? min : max;
  }
  return val;
}

static bool
parse_bool (char *token, bool min, bool max)
{
  while (*token && ISSPACE(*token))
    ++token;

  if (ISDIGIT (*token))
    return parse_unsigned (token, min, max);

  /* FIXME: handle min and max.  */
  if (!strcasecmp (token, "true")) {
    return true;
  } else if (!strcasecmp (token, "false")) {
    return false;
  } else {
    emsg ("%s:%d: %s should be either false or true",
          preferences_file (), firstline, token);
    return false; /* Never reached.  */
  }
}

static void
append_ignored (const char* ign)
{
  if (ignored_lines)
    ignored_lines = strappend (ignored_lines, ign);
  else
    ignored_lines = strdup (ign);
}

bool
load_preferences (void)
{
  FILE* fs;
  int endline = 0;
  char* buf = 0;
  size_t bufsize = 0;

  firstline = 0;

  reinit_preferences ();

  dmsg (D_FILE, "reading option from %s", preferences_file ());
  fs = fopen (preferences_file (), "rb");

  if (fs == NULL) {
    /* Don't warn, the file doesn't exists the first time.  */
    dmsg (D_FILE, "cannot open preferences file %s", preferences_file ());
    dperror ("fopen");
    return true;
  }

  XFREE0 (ignored_lines);

  while (getshline_numbered
	 (&firstline, &endline, &buf, &bufsize, fs) != -1) {
    char* token;
    char* line = xstrdup (buf);

    token = strtok (buf, " \t.:");
    if (!strcasecmp ("heroes", token)) {
    token = strtok (0, " \t.:");
    if (!strcasecmp ("screen", token)) {
    token = strtok (0, " \t.:");
    if (!strcasecmp ("display_radar", token)) {
    token = strtok (0, "\n");
    opt.radar_map = parse_bool (token, false, true);
    } else 
    if (!strcasecmp ("display_infos", token)) {
    token = strtok (0, "\n");
    opt.display_infos = parse_bool (token, false, true);
    } else 
    if (!strcasecmp ("gamma", token)) {
    token = strtok (0, "\n");
    opt.luminance = parse_unsigned (token, 0, 12);
    } else 
    if (!strcasecmp ("inertia", token)) {
    token = strtok (0, "\n");
    opt.inertia = parse_bool (token, false, true);
    } else { append_ignored (line); }
    } else 
    if (!strcasecmp ("sound", token)) {
    token = strtok (0, " \t.:");
    if (!strcasecmp ("music_enable", token)) {
    token = strtok (0, "\n");
    opt.music = parse_bool (token, false, true);
    } else 
    if (!strcasecmp ("music_volume", token)) {
    token = strtok (0, "\n");
    opt.music_volume = parse_unsigned (token, 0, 12);
    } else 
    if (!strcasecmp ("sfx_enable", token)) {
    token = strtok (0, "\n");
    opt.sfx = parse_bool (token, false, true);
    } else 
    if (!strcasecmp ("sfx_volume", token)) {
    token = strtok (0, "\n");
    opt.sfx_volume = parse_unsigned (token, 0, 12);
    } else { append_ignored (line); }
    } else 
    if (!strcasecmp ("control", token)) {
    token = strtok (0, " \t.:");
    if (!strcasecmp ("player1", token)) {
    token = strtok (0, "\n");
    opt.ctrl_one = parse_unsigned (token, 0, 1);
    } else 
    if (!strcasecmp ("autopilot1", token)) {
    token = strtok (0, "\n");
    opt.autopilot_one = parse_bool (token, false, true);
    } else 
    if (!strcasecmp ("player2", token)) {
    token = strtok (0, "\n");
    opt.ctrl_two = parse_unsigned (token, 0, 1);
    } else 
    if (!strcasecmp ("autopilot2", token)) {
    token = strtok (0, "\n");
    opt.autopilot_two = parse_bool (token, false, true);
    } else { append_ignored (line); }
    } else 
    if (!strcasecmp ("game", token)) {
    token = strtok (0, " \t.:");
    if (!strcasecmp ("speed", token)) {
    token = strtok (0, "\n");
    opt.speed = parse_unsigned (token, 0, 2);
    } else 
    if (!strcasecmp ("gamerounds", token)) {
    token = strtok (0, "\n");
    opt.gamerounds = parse_unsigned (token, 0, 15);
    } else 
    if (!strcasecmp ("player_colors", token)) {
    token = strtok (0, " \t");
    opt.player_color[0] = parse_unsigned (token, 0, 4);
    token = strtok (0, " \t");
    opt.player_color[1] = parse_unsigned (token, 0, 4);
    token = strtok (0, " \t");
    opt.player_color[2] = parse_unsigned (token, 0, 4);
    token = strtok (0, " \t");
    opt.player_color[3] = parse_unsigned (token, 0, 4);
    } else { append_ignored (line); }
    } else 
    if (!strcasecmp ("extras", token)) {
    token = strtok (0, " \t.:");
    if (!strcasecmp ("mode", token)) {
    token = strtok (0, "\n");
    opt.extras = parse_unsigned (token, 0, 2);
    } else { append_ignored (line); }
    } else 
    if (!strcasecmp (keys_pref_group (), token)) {
    token = strtok (0, " \t.:");
    if (!strcasecmp ("player1_keys", token)) {
    token = strtok (0, " \t");
    opt.player_keys[0][0] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[0][1] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[0][2] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[0][3] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[0][4] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[0][5] = parse_unsigned (token, 0, HKEYCODE_MAX);
    } else 
    if (!strcasecmp ("player2_keys", token)) {
    token = strtok (0, " \t");
    opt.player_keys[1][0] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[1][1] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[1][2] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[1][3] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[1][4] = parse_unsigned (token, 0, HKEYCODE_MAX);
    token = strtok (0, " \t");
    opt.player_keys[1][5] = parse_unsigned (token, 0, HKEYCODE_MAX);
    } else { append_ignored (line); }
    } else { append_ignored (line); }
    } else { append_ignored (line); }
    free (line);
  }

  free (buf);
  fclose (fs);
  return false;
}

