/*
 * VisualBoyAdvanced - Nintendo Gameboy/GameboyAdvance (TM) emulator
 * Copyrigh(c) 1999-2002 Forgotten (vb@emuhq.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <time.h>


#define mapperMBC1                   mapperMBC12            
#define mapperMBC2                   mapperMBC22            
#define mapperMBC3                   mapperMBC32            
#define mapperMBC5                   mapperMBC52            
#define mapperMBC7                   mapperMBC72            
#define mapperHuC1                   mapperHuC12            
#define mapperHuC3                   mapperHuC32            
#define gbDataMBC1                   gbDataMBC12            
#define gbDataMBC2                   gbDataMBC22            
#define gbDataMBC3                   gbDataMBC32            
#define gbDataMBC5                   gbDataMBC52            
#define gbDataHuC1                   gbDataHuC12            
#define gbDataHuC3                   gbDataHuC32            
                                                           
#define mapperMBC1ROM                mapperMBC1ROM2         
#define mapperMBC1RAM                mapperMBC1RAM2         
#define mapperMBC2ROM                mapperMBC2ROM2         
#define mapperMBC2RAM                mapperMBC2RAM2         
#define mapperMBC3ROM                mapperMBC3ROM2         
#define mapperMBC3RAM                mapperMBC3RAM2         
#define mapperMBC3ReadRAM            mapperMBC3ReadRAM2     
#define mapperMBC5ROM                mapperMBC5ROM2         
#define mapperMBC5RAM                mapperMBC5RAM2         
#define mapperMBC7ROM                mapperMBC7ROM2         
#define mapperMBC7RAM                mapperMBC7RAM2         
#define mapperMBC7ReadRAM            mapperMBC7ReadRAM2     
#define mapperHuC1ROM                mapperHuC1ROM2         
#define mapperHuC1RAM                mapperHuC1RAM2         
#define mapperHuC3ROM                mapperHuC3ROM2         
#define mapperHuC3RAM                mapperHuC3RAM2         
#define mapperHuC3ReadRAM            mapperHuC3ReadRAM2     
                                                           
#define memoryUpdateMapMBC1          memoryUpdateMapMBC12   
#define memoryUpdateMapMBC2          memoryUpdateMapMBC22   
#define memoryUpdateMapMBC3          memoryUpdateMapMBC32   
#define memoryUpdateMapMBC5          memoryUpdateMapMBC52   
#define memoryUpdateMapMBC7          memoryUpdateMapMBC72   
#define memoryUpdateMapHuC1          memoryUpdateMapHuC12   
#define memoryUpdateMapHuC3          memoryUpdateMapHuC32   






struct mapperMBC1 {
  int mapperRAMEnable;
  int mapperROMBank;
  int mapperRAMBank;
  int mapperMemoryModel;
  int mapperROMHighAddress;
  int mapperRAMAddress;
};

struct mapperMBC2 {
  int mapperRAMEnable;
  int mapperROMBank;
};

struct mapperMBC3 {
  int mapperRAMEnable;
  int mapperROMBank;
  int mapperRAMBank;
  int mapperRAMAddress;
  int mapperClockLatch;
  int mapperClockRegister;
  int mapperSeconds;
  int mapperMinutes;
  int mapperHours;
  int mapperDays;
  int mapperControl;
  int mapperLSeconds;
  int mapperLMinutes;
  int mapperLHours;
  int mapperLDays;
  int mapperLControl;
  time_t mapperLastTime;
};

struct mapperMBC5 {
  int mapperRAMEnable;
  int mapperROMBank;
  int mapperRAMBank;
  int mapperROMHighAddress;
  int mapperRAMAddress;
  int isRumbleCartridge;
};

struct mapperMBC7 {
  int mapperRAMEnable;
  int mapperROMBank;
  int mapperRAMBank;
  int mapperRAMAddress;
  int cs;
  int sk;
  int state;
  int buffer;
  int idle;
  int count;
  int code;
  int address;
  int writeEnable;
  int value;
};

struct mapperHuC1 {
  int mapperRAMEnable;
  int mapperROMBank;
  int mapperRAMBank;
  int mapperMemoryModel;
  int mapperROMHighAddress;
  int mapperRAMAddress;
};

struct mapperHuC3 {
  int mapperRAMEnable;
  int mapperROMBank;
  int mapperRAMBank;
  int mapperRAMAddress;
  int mapperAddress;
  int mapperRAMFlag;
  int mapperRAMValue;
  int mapperRegister1;
  int mapperRegister2;
  int mapperRegister3;
  int mapperRegister4;
  int mapperRegister5;
  int mapperRegister6;
  int mapperRegister7;
  int mapperRegister8;
};

extern mapperMBC1 gbDataMBC1;
extern mapperMBC2 gbDataMBC2;
extern mapperMBC3 gbDataMBC3;
extern mapperMBC5 gbDataMBC5;
extern mapperHuC1 gbDataHuC1;
extern mapperHuC3 gbDataHuC3;

void mapperMBC1ROM(u16,u8);
void mapperMBC1RAM(u16,u8);
void mapperMBC2ROM(u16,u8);
void mapperMBC2RAM(u16,u8);
void mapperMBC3ROM(u16,u8);
void mapperMBC3RAM(u16,u8);
u8 mapperMBC3ReadRAM(u16);
void mapperMBC5ROM(u16,u8);
void mapperMBC5RAM(u16,u8);
void mapperMBC7ROM(u16,u8);
void mapperMBC7RAM(u16,u8);
u8 mapperMBC7ReadRAM(u16);
void mapperHuC1ROM(u16,u8);
void mapperHuC1RAM(u16,u8);
void mapperHuC3ROM(u16,u8);
void mapperHuC3RAM(u16,u8);
u8 mapperHuC3ReadRAM(u16);

//extern void (*mapper)(u16,u8);
//extern void (*mapperRAM)(u16,u8);
//extern u8 (*mapperReadRAM)(u16);

extern void memoryUpdateMapMBC1();
extern void memoryUpdateMapMBC2();
extern void memoryUpdateMapMBC3();
extern void memoryUpdateMapMBC5();
extern void memoryUpdateMapMBC7();
extern void memoryUpdateMapHuC1();
extern void memoryUpdateMapHuC3();





