/*
 * VisualBoyAdvanced - Nintendo Gameboy/GameboyAdvance (TM) emulator
 * Copyrigh(c) 1999-2002 Forgotten (vb@emuhq.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#define C_FLAG 0x10
#define H_FLAG 0x20
#define N_FLAG 0x40
#define Z_FLAG 0x80

typedef union {
  struct {
#ifdef WORDS_BIGENDIAN
    u8 B1, B0;
#else
    u8 B0,B1;
#endif
  } B;
  u16 W;
} gbRegister2;

extern bool gbLoadRom2(const char *);
extern void gbEmulate2(int);
extern bool gbIsGameboyRom2(const char *);
extern void gbSoundReset2();
extern void gbSoundSetQuality2(int);
extern void gbReset2();
extern void gbCleanUp2();
extern bool gbWriteBatteryFile2(const char *);
extern bool gbWriteBatteryFile2(const char *, bool);
extern bool gbReadBatteryFile2(const char *);
extern bool gbWriteSaveState2(const char *);
extern bool gbWriteMemSaveState2(char *, int);
extern bool gbReadSaveState2(const char *);
extern bool gbReadMemSaveState2(char *, int);
extern void gbSgbRenderBorder2();
extern bool gbWritePNGFile2(const char *);
extern bool gbWriteBMPFile2(const char *);
extern bool gbReadGSASnapshot2(const char *);
extern struct EmulatedSystem GBSystem2;

#define gbRegister gbRegister2


#define gbLoadRom              gbLoadRom2            
#define gbEmulate              gbEmulate2            
#define gbIsGameboyRom         gbIsGameboyRom2       
#define gbSoundReset           gbSoundReset2         
#define gbSoundSetQuality      gbSoundSetQuality2    
#define gbReset                gbReset2              
#define gbCleanUp              gbCleanUp2            
#define gbWriteBatteryFile     gbWriteBatteryFile2   
#define gbWriteBatteryFile     gbWriteBatteryFile2   
#define gbReadBatteryFile      gbReadBatteryFile2    
#define gbWriteSaveState       gbWriteSaveState2     
#define gbWriteMemSaveState    gbWriteMemSaveState2  
#define gbReadSaveState        gbReadSaveState2      
#define gbReadMemSaveState     gbReadMemSaveState2   
#define gbSgbRenderBorder      gbSgbRenderBorder2    
#define gbWritePNGFile         gbWritePNGFile2       
#define gbWriteBMPFile         gbWriteBMPFile2       
#define gbReadGSASnapshot      gbReadGSASnapshot2    
#define GBSystem               GBSystem2             
