/*
 * VisualBoyAdvanced - Nintendo Gameboy/GameboyAdvance (TM) emulator
 * Copyrigh(c) 1999-2002 Forgotten (vb@emuhq.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __VBA_GB_GBCHEATS_H
#define __VBA_GB_GBCHEATS_H

#include "../System.h"

struct gbXxCheat2 {
  char cheatDesc[100];
  char cheatCode[20];
};

struct gbCheat2 {
  char cheatCode[20];
  char cheatDesc[32];
  u16 address;
  int code;
  u8 compare;
  u8 value;
  bool enabled;
};

extern void gbCheatsSaveGame2(gzFile);
extern void gbCheatsReadGame2(gzFile, int);
extern void gbCheatsSaveCheatList2(const char *);
extern bool gbCheatsLoadCheatList2(const char *);
extern bool gbCheatReadGSCodeFile2(const char *);

extern void gbAddGsCheat2(const char *, const char*);
extern void gbAddGgCheat2(const char *, const char*);
extern void gbCheatRemove2(int);
extern void gbCheatRemoveAll2();
extern void gbCheatEnable2(int);
extern void gbCheatDisable2(int);
extern u8 gbCheatRead2(u16);

extern int gbCheatNumber2;
extern gbCheat2 gbCheatList2[100];
extern bool gbCheatMap2[0x10000];


#define gbXxCheat               gbXxCheat2               
                                                          
#define gbCheat                 gbCheat2                 
                                                          
#define gbCheatsSaveGame        gbCheatsSaveGame2        
#define gbCheatsReadGame        gbCheatsReadGame2        
#define gbCheatsSaveCheatList   gbCheatsSaveCheatList2   
#define gbCheatsLoadCheatList   gbCheatsLoadCheatList2   
#define gbCheatReadGSCodeFile   gbCheatReadGSCodeFile2   
                                                          
#define gbAddGsCheat            gbAddGsCheat2            
#define gbAddGgCheat            gbAddGgCheat2            
#define gbCheatRemove           gbCheatRemove2           
#define gbCheatRemoveAll        gbCheatRemoveAll2        
#define gbCheatEnable           gbCheatEnable2           
#define gbCheatDisable          gbCheatDisable2          
#define gbCheatRead             gbCheatRead2             
                                                          
#define gbCheatNumber           gbCheatNumber2           
#define gbCheatList             gbCheatList2             
#define gbCheatMap              gbCheatMap2              



#endif

