// OptionsPixelFilter.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "OptionsPixelFilter.h"
#include "IPixelFilter.h"


// COptionsPixelFilter-Dialogfeld

IMPLEMENT_DYNAMIC(COptionsPixelFilter, CPropertyPage)
COptionsPixelFilter::COptionsPixelFilter()
	: CPropertyPage(COptionsPixelFilter::IDD)
	, combo_magfilter_value(0)
	, combo_maglevel_value(0)
	, combo_ifb_value(0)
	, check_disablemmx(FALSE)
{
}

COptionsPixelFilter::~COptionsPixelFilter()
{
}

void COptionsPixelFilter::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MAGNIFICATIONFILTER, combo_magfilter);
	DDX_CBIndex(pDX, IDC_MAGNIFICATIONFILTER, combo_magfilter_value);
	DDX_CBIndex(pDX, IDC_MAGNIFICATIONLEVEL, combo_maglevel_value);
	DDX_CBIndex(pDX, IDC_INTERFRAMEBLENDING, combo_ifb_value);
	DDX_Check(pDX, IDC_DISABLEMMX, check_disablemmx);

	if (pDX->m_bSaveAndValidate)
		pixelFilter = (pixelFilterType)combo_magfilter.GetItemData(combo_magfilter_value);
	DDX_Control(pDX, IDC_MAGNIFICATIONLEVEL, combo_maglevel);
}


BEGIN_MESSAGE_MAP(COptionsPixelFilter, CPropertyPage)
	ON_CBN_SELCHANGE(IDC_MAGNIFICATIONLEVEL, OnCbnSelchangeMagnificationlevel)
END_MESSAGE_MAP()


// COptionsPixelFilter-Meldungshandler

void COptionsPixelFilter::OnCbnSelchangeMagnificationlevel()
{
	switch(combo_maglevel.GetCurSel())
	{
	case 0: // 1x
		combo_magfilter.EnableWindow(FALSE);
		combo_magfilter.ResetContent();
		break;
	case 1: // 2x
		combo_magfilter.EnableWindow(TRUE);
		combo_magfilter.ResetContent();
		combo_magfilter.SetItemData(combo_magfilter.AddString("Simple2x"), FILTER_SIMPLE2X);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Pixelate"), FILTER_PIXELATE);
		combo_magfilter.SetItemData(combo_magfilter.AddString("TV Mode"), FILTER_TVMODE);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Scanlines"), FILTER_SCANLINES);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Bilinear"), FILTER_BILINEAR);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Bilinear Plus"), FILTER_BILINEARPLUS);
		combo_magfilter.SetItemData(combo_magfilter.AddString("AdvanceMAME Scale2x"), FILTER_MAMESCALE2X);
		combo_magfilter.SetItemData(combo_magfilter.AddString("2xSaI"), FILTER_2XSAI);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Super 2xSaI"), FILTER_SUPER2XSAI);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Super Eagle"), FILTER_SUPEREAGLE);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Maxim Stepin's HQ2x"), FILTER_HQ2X);
		combo_magfilter.SetItemData(combo_magfilter.AddString("LQ2x [Based on HQ2x]"), FILTER_LQ2X);
		combo_magfilter.SetCurSel(0);
		break;
	case 2: // 3x
		combo_magfilter.EnableWindow(TRUE);
		combo_magfilter.ResetContent();
		combo_magfilter.SetItemData(combo_magfilter.AddString("Simple3x"), FILTER_SIMPLE3X);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Maxim Stepin's HQ3x"), FILTER_HQ3X);
		combo_magfilter.SetCurSel(0);
		break;
	case 3: // 4x
		combo_magfilter.EnableWindow(TRUE);
		combo_magfilter.ResetContent();
		combo_magfilter.SetItemData(combo_magfilter.AddString("Simple4x"), FILTER_SIMPLE4X);
		combo_magfilter.SetItemData(combo_magfilter.AddString("Maxim Stepin's HQ4x"), FILTER_HQ4X);
		combo_magfilter.SetCurSel(0);
		break;
	}
}

BOOL COptionsPixelFilter::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	
	// Select pixel filter
	switch (pixelFilter)
	{
	case FILTER_NONE:
		combo_maglevel_value = 0;
		UpdateData(FALSE);
		break;
	case FILTER_SIMPLE2X:
	case FILTER_PIXELATE:
	case FILTER_TVMODE:
	case FILTER_SCANLINES:
	case FILTER_BILINEAR:
	case FILTER_BILINEARPLUS:
	case FILTER_MAMESCALE2X:
	case FILTER_2XSAI:
	case FILTER_SUPER2XSAI:
	case FILTER_SUPEREAGLE:
	case FILTER_LQ2X:
	case FILTER_HQ2X:
		combo_maglevel_value = 1;
		UpdateData(FALSE);
		break;
	case FILTER_SIMPLE3X:
	case FILTER_HQ3X:
		combo_maglevel_value = 2;
		UpdateData(FALSE);
		break;
	case FILTER_SIMPLE4X:
	case FILTER_HQ4X:
		combo_maglevel_value = 3;
		UpdateData(FALSE);
		break;
	}
	OnCbnSelchangeMagnificationlevel();
	SelectItemData(&combo_magfilter, pixelFilter);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// AUSNAHME: OCX-Eigenschaftenseite muss FALSE zurckgeben.
}
// Searchs for a combo box entry's ItemData and selects it.
bool COptionsPixelFilter::SelectItemData(CComboBox* combo_box, DWORD_PTR ItemData)
{
	if (combo_box->GetCount() == 0) return false;

	for (int i = 0; i < (combo_box->GetCount()); i++)
	{
		if (combo_box->GetItemData(i) == (DWORD)ItemData)
		{
			combo_box->SetCurSel(i);
			return true;
		}
	}

	return false;
}
