#pragma once


enum pixelFilterType
{
	FILTER_NONE = -1,

	FILTER_FIRST = 0,
	FILTER_SIMPLE2X = 0,
	FILTER_PIXELATE = 1,
	FILTER_TVMODE = 2,
	FILTER_SCANLINES = 3,
	FILTER_BILINEAR = 4,
	FILTER_BILINEARPLUS = 5,
	FILTER_MAMESCALE2X = 6,
	FILTER_2XSAI = 7,
	FILTER_SUPER2XSAI = 8,
	FILTER_SUPEREAGLE = 9,
	FILTER_LQ2X = 10,
	FILTER_HQ2X = 11,
	FILTER_SIMPLE3X = 12,
	FILTER_HQ3X = 13,
	FILTER_SIMPLE4X = 14,
	FILTER_HQ4X = 15,
	FILTER_LAST = 15
};


class IPixelFilter
{
private:
	// Level of magnification
	unsigned int MagnificationLevel;

	// Width of the source image
	unsigned int SourceImageWidth;

	// Height of the source image
	unsigned int SourceImageHeight;

	// true, if SourceImageWidth and SourceImageHeight have been set
	bool ImageSizeInitialized;

	// Pitch of the source Image
	unsigned int SourceImagePitch;

	// Pitch of the destination Image
	unsigned int DestinationImagePitch;

	// true, if SourceImagePitch and DestinationImagePitch have been set
	bool ImagePitchInitialized;

public:
	IPixelFilter(void)
		: SourceImageWidth(0)
		, SourceImageHeight(0)
		, ImageSizeInitialized(false)
		, MagnificationLevel(0)
	{
		MagnificationLevel = 0; // Nothing will happen with the source image
		ImageSizeInitialized = false;
		ImagePitchInitialized= false;
	}

	virtual ~IPixelFilter(void)
	{
	}

	// Can be 0x, 1x, 2x, 3x, 4x
	// FILTER_NONE is 0
	// Image alternation filters are 1x
	// Magnification filters are 2x, 3x or 4x
	virtual int GetMagnificationLevel(void)
	{
		return MagnificationLevel; 
	}

	// Returns true if the filter is written in HLSL (DirectX9 High Level Shading Language)
	virtual bool IsPixelShader(void)
	{
		return false; // Function is a software filter
	}

	// Initialize color tables etc.
	virtual bool InitializeFilter(void)
	{
		return true; // No problems during initialization
	}

	// Set the size of the source image
	virtual void SetImageSize(unsigned int width, unsigned int height)
	{
		SourceImageWidth = width;
		SourceImageHeight = height;
		ImageSizeInitialized = true;
	}

	// Set the size in bytes of a scanline
	virtual void SetPitch(unsigned int sourcePitch, unsigned int destinationPitch)
	{
		SourceImagePitch = sourcePitch;
		DestinationImagePitch = destinationPitch;
		ImagePitchInitialized = true;
	}

	// Load SourceImage, apply filter, Save to DestinationImage   |   Software filters only
	virtual void FilterImage(unsigned char * SourceImage, unsigned char * DestinationImage);
};
