// OptionsAudio.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "VBA.h"
#include ".\optionsaudio.h"
#include "Util.h"


// COptionsAudio-Dialogfeld

IMPLEMENT_DYNAMIC(COptionsAudio, CPropertyPage)
COptionsAudio::COptionsAudio()
	: CPropertyPage(COptionsAudio::IDD)
	, combo_volume_value(0)
	, check_on_value(FALSE)
	, check_mute_value(FALSE)
	, check_echo_value(FALSE)
	, check_lowpass_value(FALSE)
	, check_reverse_value(FALSE)
	, list_audio_sample(0)
	, check_channel1(FALSE)
	, check_channel2(FALSE)
	, check_channel3(FALSE)
	, check_channel4(FALSE)
	, check_dsounda(FALSE)
	, check_dsoundb(FALSE)
{
}

COptionsAudio::~COptionsAudio()
{
}

void COptionsAudio::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_CBIndex(pDX, IDC_AUDIO_VOLUME, combo_volume_value);
	DDX_Control(pDX, IDC_AUDIO_MUTE, check_mute);
	DDX_Radio(pDX, IDC_AUDIO_ON, check_on_value);
	if (pDX->m_bSaveAndValidate == FALSE) // set control values
	{
		if (check_on_value == 0)
			OnBnClickedAudioOn();
		if (check_on_value == 1)
			OnBnClickedAudioOff();
	}
	DDX_Check(pDX, IDC_AUDIO_MUTE, check_mute_value);
	DDX_Check(pDX, IDC_AUDIO_ECHO, check_echo_value);
	DDX_Check(pDX, IDC_AUDIO_LOWPASS, check_lowpass_value);
	DDX_Check(pDX, IDC_AUDIO_REVERSE, check_reverse_value);
	DDX_CBIndex(pDX, IDC_AUDIO_SAMPLE, list_audio_sample);
	DDX_Check(pDX, IDC_AUDIO_CHANNEL1, check_channel1);
	DDX_Check(pDX, IDC_AUDIO_CHANNEL2, check_channel2);
	DDX_Check(pDX, IDC_AUDIO_CHANNEL3, check_channel3);
	DDX_Check(pDX, IDC_AUDIO_CHANNEL4, check_channel4);
	DDX_Check(pDX, IDC_AUDIO_DIRECTSOUNDA, check_dsounda);
	DDX_Check(pDX, IDC_AUDIO_DIRECTSOUNDB, check_dsoundb);
	DDX_Control(pDX, IDC_AUDIO_DIRECTSOUNDA, check_dsounda_control);
	DDX_Control(pDX, IDC_AUDIO_DIRECTSOUNDB, check_dsoundb_control);
}


BEGIN_MESSAGE_MAP(COptionsAudio, CPropertyPage)
	ON_BN_CLICKED(IDC_AUDIO_ON, OnBnClickedAudioOn)
	ON_BN_CLICKED(IDC_AUDIO_OFF, OnBnClickedAudioOff)
	ON_BN_CLICKED(IDC_AUDIO_MUTE, OnBnClickedAudioMute)
	ON_BN_CLICKED(IDC_AUDIO_CHANNEL1, OnBnClickedAudioChannel1)
	ON_BN_CLICKED(IDC_AUDIO_CHANNEL2, OnBnClickedAudioChannel2)
	ON_BN_CLICKED(IDC_AUDIO_CHANNEL3, OnBnClickedAudioChannel3)
	ON_BN_CLICKED(IDC_AUDIO_CHANNEL4, OnBnClickedAudioChannel4)
	ON_BN_CLICKED(IDC_AUDIO_DIRECTSOUNDA, OnBnClickedAudioDirectsounda)
	ON_BN_CLICKED(IDC_AUDIO_DIRECTSOUNDB, OnBnClickedAudioDirectsoundb)
END_MESSAGE_MAP()


// COptionsAudio-Meldungshandler

BOOL COptionsAudio::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	
	check_dsounda_control.EnableWindow((theApp.cartridgeType == IMAGE_GBA) ? TRUE : FALSE);
	check_dsoundb_control.EnableWindow((theApp.cartridgeType == IMAGE_GBA) ? TRUE : FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// AUSNAHME: OCX-Eigenschaftenseite muss FALSE zurckgeben.
}

void COptionsAudio::OnBnClickedAudioOn()
{
	check_mute.EnableWindow(TRUE);
}

void COptionsAudio::OnBnClickedAudioOff()
{
	check_mute.EnableWindow(FALSE);
}

void COptionsAudio::OnBnClickedAudioMute()
{
	if(check_mute.GetCheck() == BST_CHECKED)
	{
		UpdateData(TRUE);
		check_channel1 = BST_UNCHECKED;
		check_channel2 = BST_UNCHECKED;
		check_channel3 = BST_UNCHECKED;
		check_channel4 = BST_UNCHECKED;
		check_dsounda = BST_UNCHECKED;
		check_dsoundb = BST_UNCHECKED;
		UpdateData(FALSE);
	}
	else
	{
		UpdateData(TRUE);
		check_channel1 = BST_CHECKED;
		check_channel2 = BST_CHECKED;
		check_channel3 = BST_CHECKED;
		check_channel4 = BST_CHECKED;
		check_dsounda = BST_CHECKED;
		check_dsoundb = BST_CHECKED;
		UpdateData(FALSE);
	}
}

void COptionsAudio::OnBnClickedAudioChannel1()
{
	UpdateData(TRUE);
	if (check_channel1 | check_channel2 |
		check_channel3 | check_channel4 |
		check_dsounda  | check_dsoundb)
		check_mute_value = BST_UNCHECKED;
	else
		check_mute_value = BST_CHECKED;
	UpdateData(FALSE);
}

void COptionsAudio::OnBnClickedAudioChannel2()
{
	OnBnClickedAudioChannel1();
}

void COptionsAudio::OnBnClickedAudioChannel3()
{
	OnBnClickedAudioChannel1();
}

void COptionsAudio::OnBnClickedAudioChannel4()
{
	OnBnClickedAudioChannel1();
}

void COptionsAudio::OnBnClickedAudioDirectsounda()
{
	OnBnClickedAudioChannel1();
}

void COptionsAudio::OnBnClickedAudioDirectsoundb()
{
	OnBnClickedAudioChannel1();
}