// ---------------------------------------------------------------------------
//	OPN/A/B interface with ADPCM support
//	Copyright (C) cisc 1998, 2001.
// ---------------------------------------------------------------------------
//	$Id: opna.h,v 1.24 2001/04/15 02:46:10 cisc Exp $

#ifndef FM_OPNA_H
#define FM_OPNA_H

#include "fmgen.h"
#include "fmtimer.h"
#include "fmfilter.h"
#include "psg.h"

// ---------------------------------------------------------------------------
//	class OPN/OPNA
//	OPN/OPNA ɗǂ𐶐鉹jbg
//	
//	interface:
//	bool Init(uint clock, uint rate, bool interpolation, const char* path);
//		D̃NXgpOɂȂ炸ĂłƁD
//		OPNA ̏ꍇ͂̊֐ŃYTvǂݍ
//
//		clock:	OPN/OPNA/OPNB ̃NbNg(Hz)
//
//		rate:	 PCM ̕W{g(Hz)
//
//		inter.:	`⊮[h (OPNA ̂ݗL)
//				true ɂƁCFM ͉̍{̃[gōs悤
//				ȂDŏIIɐ PCM  rate Ŏw肳ꂽ[gɂȂ
//				悤`⊮
//				
//		path:	YTṽpX(OPNA ̂ݗL)
//				ȗ̓JgfBNgǂݍ
//				̖ɂ '\'  '/' Ȃǂ邱
//
//		Ԃl	ɐ true
//
//	bool LoadRhythmSample(const char* path)
//		(OPNA ONLY)
//		Rhythm TvǂݒD
//		path  Init  path ƓD
//		
//	bool SetRate(uint clock, uint rate, bool interpolation)
//		NbN PCM [gύX
//		 Init QƂ̂ƁD
//	
//	void Mix(FM_SAMPLETYPE* dest, int nsamples)
//		Stereo PCM f[^ nsamples C dest Ŏn܂z
//		(Z)
//		Edest ɂ sample*2 ̗̈悪Kv
//		Ei[` L, R, L, R... ƂȂD
//		E܂ŉZȂ̂ŁC炩ߔz[NAKv
//		EFM_SAMPLETYPE  short ^̏ꍇNbsOs.
//		E̊֐͉̃^C}[Ƃ͓ƗĂD
//		  Timer  Count  GetNextEvent ő삷KvD
//	
//	void Reset()
//		Zbg()
//
//	void SetReg(uint reg, uint data)
//		̃WX^ reg  data 
//	
//	uint GetReg(uint reg)
//		̃WX^ reg ̓eǂݏo
//		ǂݍނƂo郌WX^ PSG, ADPCM ̈ꕔCID(0xff) Ƃ
//	
//	uint ReadStatus()/ReadStatusEx()
//		̃Xe[^XWX^ǂݏo
//		ReadStatusEx ͊gXe[^XWX^̓ǂݏo(OPNA)
//		busy tO͏ 0
//	
//	bool Count(uint32 t)
//		̃^C}[ t [ʕb] i߂D
//		̓Ԃɕω(timer I[o[t[)
//		true Ԃ
//
//	uint32 GetNextEvent()
//		̃^C}[̂ǂ炩I[o[t[܂łɕKv
//		[ʕb]Ԃ
//		^C}[~Ăꍇ ULONG_MAX Ԃc Ǝv
//	
//	void SetVolumeFM(int db)/SetVolumePSG(int db) ...
//		ẻʂ{|ɒ߂DWl 0.
//		Pʂ͖ 1/2 dBCL͈͂̏ 20 (10dB)
//
namespace FM
{
	//	OPN Base -------------------------------------------------------
	class OPNBase : public Timer
	{
	public:
		OPNBase();
		
		bool	Init(uint c, uint r);
		virtual void Reset();
		
		void	SetVolumeFM(int db);
		int savecontext_opnbase( unsigned char *buf ) ;
		int loadcontext_opnbase( unsigned char *buf ) ;
		void	SetVolumePSG(int db);
		void	SetLPFCutoff(uint freq);
	
	protected:
		void	SetParameter(Channel4* ch, uint addr, uint data);
		void	SetPrescaler(uint p);
		void	RebuildTimeTable();
		
		int		fmvolume;
		
		uint	clock;				// OPN NbN
		uint	rate;				// FM [g
		uint	psgrate;			// FMGen  o̓[g
		uint	status;
		uint	lpfcutoff;			// FM  LPF cutoff
		Channel4* csmch;
		
		int32	mixdelta;
		int		mpratio;
		bool	interpolation;
		
		static  uint32 lfotable[8];
	
	private:
		void	TimerA();
		uint8	prescale;
		
	protected:
		PSG		psg;
		LPF		lpf;
	};


#define WRITEDATA( src, size ) \
	memcpy( ptr, src, size ) ;\
	ptr += size ;

inline int OPNBase::savecontext_opnbase( unsigned char *buf )
{
	unsigned char *ptr = buf ;


WRITEDATA( &fmvolume, sizeof(int));
WRITEDATA( &clock, sizeof(uint));
WRITEDATA( &rate, sizeof(uint));
WRITEDATA( &psgrate, sizeof(uint));
WRITEDATA( &status, sizeof(uint));
WRITEDATA( &lpfcutoff, sizeof(uint));
WRITEDATA( &mixdelta, sizeof(int32));
WRITEDATA( &mpratio, sizeof(int));
WRITEDATA( &interpolation, sizeof(bool));
WRITEDATA( lfotable, sizeof(uint32)*8);
WRITEDATA( &prescale, sizeof(uint8));


ptr += psg.savecontext_psg( ptr ) ;
ptr += lpf.savecontext_lpf( ptr ) ;
		

	return ptr-buf ;

}


#define READDATA( dst, size ) \
	memcpy( dst, ptr, size ) ;\
	ptr += size ;

inline int OPNBase::loadcontext_opnbase( unsigned char *buf )
{
	unsigned char *ptr = buf ;

READDATA( &fmvolume, sizeof(int));
READDATA( &clock, sizeof(uint));
READDATA( &rate, sizeof(uint));
READDATA( &psgrate, sizeof(uint));
READDATA( &status, sizeof(uint));
READDATA( &lpfcutoff, sizeof(uint));
READDATA( &mixdelta, sizeof(int32));
READDATA( &mpratio, sizeof(int));
READDATA( &interpolation, sizeof(bool));
READDATA( lfotable, sizeof(uint32)*8);
READDATA( &prescale, sizeof(uint8));


ptr += psg.loadcontext_psg( ptr ) ;
ptr += lpf.loadcontext_lpf( ptr ) ;

	return ptr-buf ;

}





	//	OPN2 Base ------------------------------------------------------
	class OPNABase : public OPNBase
	{
	public:
		OPNABase();
		~OPNABase();
		
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx();
		void	SetChannelMask(uint mask);
		int savecontext_opnabase( unsigned char *buf ) ;
		int loadcontext_opnabase( unsigned char *buf ) ;
	
	private:
		virtual void Intr(bool) {}
	
	protected:
		bool	Init(uint c, uint r, bool ipflag);
		bool	SetRate(uint c, uint r, bool ipflag);

		void	Reset();
		void 	SetReg(uint addr, uint data);
		void	SetADPCMBReg(uint reg, uint data);
		uint	GetReg(uint addr);	
	
	protected:
		void	FMMix(Sample* buffer, int nsamples);
		void 	Mix6(Sample* buffer, int nsamples, int activech);
		
		void	MixSubS(int activech, ISample**);
		void	MixSubSL(int activech, ISample**);

		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		void	UpdateStatus();
		void	LFO();

		void	DecodeADPCMB();
		void	ADPCMBMix(Sample* dest, uint count);

		void	WriteRAM(uint data);
		uint	ReadRAM();
		int		ReadRAMN();
		int		DecodeADPCMBSample(uint);
		
	// `ԗp[N
		int32	ml[4];
		int32	mr[4];
		
	// FM ֌W
		uint8	pan[6];
		uint8	fnum2[9];
		
		uint8	reg22;
		uint	reg29;		// OPNA only?
		
		uint	stmask;
		uint	statusnext;

		uint32	lfocount;
		uint32	lfodcount;
		
		uint	fnum[6];
		uint	fnum3[3];
		
	// ADPCM ֌W
		uint8*	adpcmbuf;		// ADPCM RAM
		uint	adpcmmask;		// AhXɑ΂rbg}XN
		uint	adpcmnotice;	// ADPCM ĐIɂrbg
		uint	startaddr;		// Start address
		uint	stopaddr;		// Stop address
		uint	memaddr;		// ĐAhX
		uint	limitaddr;		// Limit address/mask
		int		adpcmlevel;		// ADPCM 
		int		adpcmvolume;
		int		adpcmvol;
		uint	deltan;			// N
		int		adplc;			// gϊpϐ
		int		adpld;			// gϊpϐl
		uint	adplbase;		// adpld ̌
		int		adpcmx;			// ADPCM p x
		int		adpcmd;			// ADPCM p 
		int		adpcmout;		// ADPCM ̏o
		int		apout0;			// out(t-2)+out(t-1)
		int		apout1;			// out(t-1)+out(t)

		uint	adpcmreadbuf;	// ADPCM [hpobt@
		bool	adpcmplay;		// ADPCM Đ
		int8	granuality;		

		uint8	control1;		// ADPCM Rg[WX^P
		uint8	control2;		// ADPCM Rg[WX^Q
		uint8	adpcmreg[8];	// ADPCM WX^̈ꕔ

		Channel4 ch[6];

		static void	BuildLFOTable();
		static int amtable[FM_LFOENTS];
		static int pmtable[FM_LFOENTS];
	};


#define WRITEDATA( src, size ) \
	memcpy( ptr, src, size ) ;\
	ptr += size ;

inline int OPNABase::savecontext_opnabase( unsigned char *buf )
{
	int i ;
	unsigned char *ptr = buf ;

WRITEDATA( &reg22, sizeof(uint8));
WRITEDATA( &reg29, sizeof(uint));
WRITEDATA( &stmask, sizeof(uint));
WRITEDATA( &statusnext, sizeof(uint));
WRITEDATA( &lfocount, sizeof(uint32));
WRITEDATA( &lfodcount, sizeof(uint32));
WRITEDATA( &adpcmmask, sizeof(uint));
WRITEDATA( &adpcmnotice, sizeof(uint));
WRITEDATA( &startaddr, sizeof(uint));
WRITEDATA( &stopaddr, sizeof(uint));
WRITEDATA( &memaddr, sizeof(uint));
WRITEDATA( &limitaddr, sizeof(uint));
WRITEDATA( &adpcmlevel, sizeof(int));
WRITEDATA( &adpcmvolume, sizeof(int));
WRITEDATA( &adpcmvol, sizeof(int));
WRITEDATA( &deltan, sizeof(uint));
WRITEDATA( &adplc, sizeof(int));
WRITEDATA( &adpld, sizeof(int));
WRITEDATA( &adplbase, sizeof(uint));
WRITEDATA( &adpcmx, sizeof(int));
WRITEDATA( &adpcmd, sizeof(int));
WRITEDATA( &adpcmout, sizeof(int));
WRITEDATA( &apout0, sizeof(int));
WRITEDATA( &apout1, sizeof(int));
WRITEDATA( &adpcmreadbuf, sizeof(uint));
WRITEDATA( &adpcmplay, sizeof(bool));
WRITEDATA( &granuality, sizeof(int8));
WRITEDATA( &control1, sizeof(uint8));
WRITEDATA( &control2, sizeof(uint8));



WRITEDATA( adpcmreg, sizeof(uint8)*8);
WRITEDATA( ml, sizeof(int32)*4);
WRITEDATA( mr, sizeof(int32)*4);
WRITEDATA( pan, sizeof(uint8)*6);
WRITEDATA( fnum2, sizeof(uint8)*9);
WRITEDATA( fnum, sizeof(uint)*6);
WRITEDATA( fnum3, sizeof(uint)*3);
WRITEDATA( amtable, sizeof(int)*FM_LFOENTS);
WRITEDATA( pmtable, sizeof(int)*FM_LFOENTS);
		
for (i = 0 ; i < 6 ; i++ )
{
	ptr += ch[i].savecontext_channel4( ptr ) ;
}


	return ptr-buf ;

}


#define READDATA( dst, size ) \
	memcpy( dst, ptr, size ) ;\
	ptr += size ;

inline int OPNABase::loadcontext_opnabase( unsigned char *buf )
{
	int i ;
	unsigned char *ptr = buf ;

READDATA( &reg22, sizeof(uint8));
READDATA( &reg29, sizeof(uint));
READDATA( &stmask, sizeof(uint));
READDATA( &statusnext, sizeof(uint));
READDATA( &lfocount, sizeof(uint32));
READDATA( &lfodcount, sizeof(uint32));
READDATA( &adpcmmask, sizeof(uint));
READDATA( &adpcmnotice, sizeof(uint));
READDATA( &startaddr, sizeof(uint));
READDATA( &stopaddr, sizeof(uint));
READDATA( &memaddr, sizeof(uint));
READDATA( &limitaddr, sizeof(uint));
READDATA( &adpcmlevel, sizeof(int));
READDATA( &adpcmvolume, sizeof(int));
READDATA( &adpcmvol, sizeof(int));
READDATA( &deltan, sizeof(uint));
READDATA( &adplc, sizeof(int));
READDATA( &adpld, sizeof(int));
READDATA( &adplbase, sizeof(uint));
READDATA( &adpcmx, sizeof(int));
READDATA( &adpcmd, sizeof(int));
READDATA( &adpcmout, sizeof(int));
READDATA( &apout0, sizeof(int));
READDATA( &apout1, sizeof(int));
READDATA( &adpcmreadbuf, sizeof(uint));
READDATA( &adpcmplay, sizeof(bool));
READDATA( &granuality, sizeof(int8));
READDATA( &control1, sizeof(uint8));
READDATA( &control2, sizeof(uint8));



READDATA( adpcmreg, sizeof(uint8)*8);
READDATA( ml, sizeof(int32)*4);
READDATA( mr, sizeof(int32)*4);
READDATA( pan, sizeof(uint8)*6);
READDATA( fnum2, sizeof(uint8)*9);
READDATA( fnum, sizeof(uint)*6);
READDATA( fnum3, sizeof(uint)*3);
READDATA( amtable, sizeof(int)*FM_LFOENTS);
READDATA( pmtable, sizeof(int)*FM_LFOENTS);
		
for (i = 0 ; i < 6 ; i++ )
{
	ptr += ch[i].loadcontext_channel4( ptr ) ;
}


	return ptr-buf ;

}




	//	YM2203(OPN) ----------------------------------------------------
	class OPN : public OPNBase
	{
	public:
		OPN();
		virtual ~OPN() {}
		
		bool	Init(uint c, uint r, bool=false, const char* =0);
		bool	SetRate(uint c, uint r, bool);
		
		void	Reset();
		void 	Mix(Sample* buffer, int nsamples);
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx() { return 0xff; }
		
		void	SetChannelMask(uint mask);
		
	private:
		virtual void Intr(bool) {}
		
		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		
		uint	fnum[3];
		uint	fnum3[3];
		uint8	fnum2[6];
		
	// `ԗp[N
		int32	mb[4];
		
		Channel4 ch[3];
	};




	//	YM2608(OPNA) ---------------------------------------------------
	class OPNA : public OPNABase
	{
	public:
		OPNA();
		virtual ~OPNA();
		
		bool	Init(uint c, uint r, bool ipflag = false, const char* rhythmpath=0);
		bool	LoadRhythmSample(const char*);
	
		bool	SetRate(uint c, uint r, bool ipflag = false);
		void 	Mix(Sample* buffer, int nsamples);

		void	Reset();
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);

		void	SetVolumeADPCM(int db);
		void	SetVolumeRhythmTotal(int db);
		void	SetVolumeRhythm(int index, int db);

		uint8*	GetADPCMBuffer() { return adpcmbuf; }
		
	private:
		struct Rhythm
		{
			uint8	pan;		// ς
			int8	level;		// 傤
			int		volume;		// 傤Ă
			int16*	sample;		// Ղ
			uint	size;		// 
			uint	pos;		// 
			uint	step;		// ĂՂ
			uint	rate;		// Ղ̂[
		};
	
		void	RhythmMix(Sample* buffer, uint count);

	// Y֌W
		Rhythm	rhythm[6];
		int8	rhythmtl;		// YŜ̉
		int		rhythmtvol;		
		uint8	rhythmkey;		// ỸL[
	};

	//	YM2610/B(OPNB) ---------------------------------------------------
	class OPNB : public OPNABase
	{
	public:
		OPNB();
		virtual ~OPNB();
		
		bool	Init(uint c, uint r, bool ipflag = false,
					 uint8 *_adpcma = 0, int _adpcma_size = 0,
					 uint8 *_adpcmb = 0, int _adpcmb_size = 0);
	
		bool	SetRate(uint c, uint r, bool ipflag = false);
		void 	Mix(Sample* buffer, int nsamples);

		void	Reset();
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatusEx();

		void	SetVolumeADPCMATotal(int db);
		void	SetVolumeADPCMA(int index, int db);
		void	SetVolumeADPCMB(int db);

//		void	SetChannelMask(uint mask);
		
	private:
		struct ADPCMA
		{
			uint8	pan;		// ς
			int8	level;		// 傤
			int		volume;		// 傤Ă
			uint	pos;		// 
			uint	step;		// ĂՂ

			uint	start;		// Jn
			uint	stop;		// I
			uint	nibble;		//  4 bit
			int		adpcmx;		// ϊp
			int		adpcmd;		// ϊp
		};
	
		int		DecodeADPCMASample(uint);
		void	ADPCMAMix(Sample* buffer, uint count);
		static void InitADPCMATable();
		
	// ADPCMA ֌W
		uint8*	adpcmabuf;		// ADPCMA ROM
		int		adpcmasize;
		ADPCMA	adpcma[6];
		int8	adpcmatl;		// ADPCMA Ŝ̉
		int		adpcmatvol;		
		uint8	adpcmakey;		// ADPCMA ̃L[
		int		adpcmastep;
		uint8	adpcmareg[32];
 
		static int jedi_table[(48+1)*16];

		Channel4 ch[6];
	};

	//	YM2612/3438(OPN2) ----------------------------------------------------
	class OPN2 : public OPNBase
	{
	public:
		OPN2();
		virtual ~OPN2() {}
		
		bool	Init(uint c, uint r, bool=false, const char* =0);
		bool	SetRate(uint c, uint r, bool);
		
		void	Reset();
		void 	Mix(Sample* buffer, int nsamples);
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx() { return 0xff; }
		
		void	SetChannelMask(uint mask);
		
	private:
		virtual void Intr(bool) {}
		
		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		
		uint	fnum[3];
		uint	fnum3[3];
		uint8	fnum2[6];
		
	// `ԗp[N
		int32	mixc, mixc1;
		
		Channel4 ch[3];
	};


	//	YMF288 ---------------------------------------------------
	class Y288 : public OPNABase
	{
	public:
		Y288();
		virtual ~Y288();
		
		bool	Init(uint c, uint r, bool ipflag = false, const char* =0);
		bool	LoadRhythmSample(const char*);
	
		bool	SetRate(uint c, uint r, bool ipflag = false);
		void 	Mix(Sample* buffer, int nsamples);
		int savecontext_y288( unsigned char *buf ) ;
		int loadcontext_y288( unsigned char *buf ) ;

		void	SetVolumeRhythmTotal(int db);
		void	SetVolumeRhythm(int index, int db);

		void	Reset();
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);

	private:
		struct Rhythm
		{
			uint8	pan;		// ς
			int8	level;		// 傤
			int		volume;		// 傤Ă
			int16*	sample;		// Ղ
			uint	size;		// 
			uint	pos;		// 
			uint	step;		// ĂՂ
			uint	rate;		// Ղ̂[
		};
	
		void	RhythmMix(Sample* buffer, uint count);

	// Y֌W
		Rhythm	rhythm[6];
		int8	rhythmtl;		// YŜ̉
		int		rhythmtvol;		
		uint8	rhythmkey;		// ỸL[

		int	mode288;		// 288/2608[htO
	};



#define WRITEDATA( src, size ) \
	memcpy( ptr, src, size ) ;\
	ptr += size ;

inline int Y288::savecontext_y288( unsigned char *buf )
{
	unsigned char *ptr = buf ;

WRITEDATA( &rhythmtl, sizeof(int8));
WRITEDATA( &rhythmtvol, sizeof(int));
WRITEDATA( &rhythmkey, sizeof(uint8));
WRITEDATA( &mode288, sizeof(int));
WRITEDATA( rhythm, sizeof(Rhythm)*6 ) ;


	return ptr-buf ;

}


#define READDATA( dst, size ) \
	memcpy( dst, ptr, size ) ;\
	ptr += size ;

inline int Y288::loadcontext_y288( unsigned char *buf )
{
	unsigned char *ptr = buf ;

READDATA( &rhythmtl, sizeof(int8));
READDATA( &rhythmtvol, sizeof(int));
READDATA( &rhythmkey, sizeof(uint8));
READDATA( &mode288, sizeof(int));
READDATA( rhythm, sizeof(Rhythm)*6 ) ;


	return ptr-buf ;

}






}


// ---------------------------------------------------------------------------

inline void FM::OPNBase::RebuildTimeTable()
{
	int p = prescale;
	prescale = -1;
	SetPrescaler(p);
}

inline void FM::OPNBase::SetVolumePSG(int db)
{
	psg.SetVolume(db);
}

#endif // FM_OPNA_H
