// ---------------------------------------------------------------------------
//	OPM-like Sound Generator
//	Copyright (C) cisc 1998, 2001.
// ---------------------------------------------------------------------------
//	$Id: opm.h,v 1.7 2001/04/15 02:46:10 cisc Exp $

#ifndef FM_OPM_H
#define FM_OPM_H

#include "fmgen.h"
#include "fmtimer.h"
#include "fmfilter.h"
#include "psg.h"

// ---------------------------------------------------------------------------
//	class OPM
//	OPM ɗǂ(?)𐶐鉹jbg
//	
//	interface:
//	bool Init(uint clock, uint rate, bool interpolation);
//		D̃NXgpOɂȂ炸ĂłƁD
//
//		clock:	OPM ̃NbNg(Hz)
//
//		rate:	 PCM ̕W{g(Hz)
//
//		inter.:	`⊮[h
//				true ɂƁCFM ͉̍{̃[gōs悤
//				ȂDŏIIɐ PCM  rate Ŏw肳ꂽ[gɂȂ
//				悤`⊮
//				
//		Ԓl	ɐ true
//
//	bool SetRate(uint clock, uint rate, bool interpolation)
//		NbN PCM [gύX
//		 Init ƓlD
//	
//	void Mix(Sample* dest, int nsamples)
//		Stereo PCM f[^ nsamples C dest Ŏn܂z
//		(Z)
//		Edest ɂ sample*2 ̗̈悪Kv
//		Ei[` L, R, L, R... ƂȂD
//		E܂ŉZȂ̂ŁC炩ߔz[NAKv
//		EFM_SAMPLETYPE  short ^̏ꍇNbsOs.
//		E̊֐͉̃^C}[Ƃ͓ƗĂD
//		  Timer  Count  GetNextEvent ő삷KvD
//	
//	void Reset()
//		Zbg()
//
//	void SetReg(uint reg, uint data)
//		̃WX^ reg  data 
//	
//	uint ReadStatus()
//		̃Xe[^XWX^ǂݏo
//		busy tO͏ 0
//	
//	bool Count(uint32 t)
//		̃^C}[ t [10^(-6) b] i߂D
//		̓Ԃɕω(timer I[o[t[)
//		true Ԃ
//
//	uint32 GetNextEvent()
//		̃^C}[̂ǂ炩I[o[t[܂łɕKv
//		[ʕb]Ԃ
//		^C}[~Ăꍇ 0 ԂD
//	
//	void SetVolume(int db)
//		ẻʂ{|ɒ߂DWl 0.
//		Pʂ͖ 1/2 dBCL͈͂̏ 20 (10dB)
//
//	z֐:
//	virtual void Intr(bool irq)
//		IRQ o͂ɕωꍇĂ΂D
//		irq = true:  IRQ v
//		irq = false: IRQ v
//
namespace FM
{
	//	YM2151(OPM) ----------------------------------------------------
	class OPM : public Timer
	{
	public:
		OPM();
		~OPM() {}
		
		bool	Init(uint c, uint r, bool=false);
		bool	SetRate(uint c, uint r, bool);
		void	SetLPFCutoff(uint freq);
		void	Reset();
		
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		
		void 	Mix(Sample* buffer, int nsamples);
		
		void	SetVolume(int db);
		void	SetChannelMask(uint mask);
		int savecontext_opm( unsigned char *buf ) ;
		int loadcontext_opm( unsigned char *buf ) ;
		
	private:
		virtual void Intr(bool) {}
	
	private:
		void	SetStatus(uint bit);
		void	ResetStatus(uint bit);
		void	SetParameter(uint addr, uint data);
		void	TimerA();
		void	RebuildTimeTable();
		void	MixSub(int activech, ISample**);
		void	MixSubL(int activech, ISample**);
		void	LFO();
		uint	Noise();
		
		int32	ml[4];
		int32	mr[4];
		int32	mixdelta;
		int		mpratio;
		
		int		fmvolume;

		uint	clock;
		uint	rate;
		uint	pcmrate;
		uint	lpfcutoff;

		uint	pmd;
		uint	amd;
		uint	lfocount;
		uint	lfodcount;
		uint	lfowaveform;
		uint	rateratio;
		uint	noise;
		int32	noisecount;
		uint32	noisedelta;
		
		bool	interpolation;
		uint8	lfofreq;
		uint8	status;
		uint8	reg01;

		uint8	kc[8];
		uint8	kf[8];
		uint8	pan[8];

		Channel4 ch[8];
		LPF		lpf;

		static void	BuildLFOTable();
		static int amtable[4][FM_LFOENTS];
		static int pmtable[4][FM_LFOENTS];
	};



#define WRITEDATA( src, size ) \
	memcpy( ptr, src, size ) ;\
	ptr += size ;

inline int OPM::savecontext_opm( unsigned char *buf )
{
	unsigned char *ptr = buf ;



	WRITEDATA( &clock, sizeof(uint) ) ;
	WRITEDATA( &rate, sizeof(uint) ) ;
	WRITEDATA( &pcmrate, sizeof(uint) ) ;
	WRITEDATA( &lpfcutoff, sizeof(uint) ) ;
	WRITEDATA( &pmd, sizeof(uint) ) ;
	WRITEDATA( &amd, sizeof(uint) ) ;
	WRITEDATA( &lfocount, sizeof(uint) ) ;
	WRITEDATA( &lfodcount, sizeof(uint) ) ;
	WRITEDATA( &lfowaveform, sizeof(uint) ) ;
	WRITEDATA( &rateratio, sizeof(uint) ) ;
	WRITEDATA( &noise, sizeof(uint) ) ;


	WRITEDATA( &lfofreq, sizeof(uint8)) ;
	WRITEDATA( &status, sizeof(uint8)) ;
	WRITEDATA( &reg01, sizeof(uint8)) ;

	
	WRITEDATA( kc,sizeof(uint8)*8) ;
	WRITEDATA( kf,sizeof(uint8)*8) ;
	WRITEDATA( pan,sizeof(uint8)*8) ;

	WRITEDATA( ml,sizeof(int32)*4) ;
	WRITEDATA( mr,sizeof(int32)*4) ;


	WRITEDATA( &mpratio,sizeof(int)) ;
	WRITEDATA( &fmvolume,sizeof(int)) ;

	
	WRITEDATA( &mixdelta,sizeof(int32)) ;
	WRITEDATA( &noisecount,sizeof(int32)) ;

	WRITEDATA( &noisedelta,sizeof(uint32)) ;

	WRITEDATA( &interpolation,sizeof(bool)) ;

	WRITEDATA( amtable,sizeof(int)*4*FM_LFOENTS) ;
	WRITEDATA( pmtable,sizeof(int)*4*FM_LFOENTS) ;


	for ( int i = 0 ; i < 8 ; i++ )
	{
		ptr += ch[i].savecontext_channel4( ptr ) ;
	}

	ptr += lpf.savecontext_lpf( ptr ) ;

	ptr += savecontext_fmgen( ptr) ;

	return ptr-buf ;

}


#define READDATA( dst, size ) \
	memcpy( dst, ptr, size ) ;\
	ptr += size ;

inline int OPM::loadcontext_opm( unsigned char *buf )
{
	unsigned char *ptr = buf ;

	READDATA( &clock, sizeof(uint) ) ;
	READDATA( &rate, sizeof(uint) ) ;
	READDATA( &pcmrate, sizeof(uint) ) ;
	READDATA( &lpfcutoff, sizeof(uint) ) ;
	READDATA( &pmd, sizeof(uint) ) ;
	READDATA( &amd, sizeof(uint) ) ;
	READDATA( &lfocount, sizeof(uint) ) ;
	READDATA( &lfodcount, sizeof(uint) ) ;
	READDATA( &lfowaveform, sizeof(uint) ) ;
	READDATA( &rateratio, sizeof(uint) ) ;
	READDATA( &noise, sizeof(uint) ) ;


	READDATA( &lfofreq, sizeof(uint8)) ;
	READDATA( &status, sizeof(uint8)) ;
	READDATA( &reg01, sizeof(uint8)) ;

	
	READDATA( kc,sizeof(uint8)*8) ;
	READDATA( kf,sizeof(uint8)*8) ;
	READDATA( pan,sizeof(uint8)*8) ;

	READDATA( ml,sizeof(int32)*4) ;
	READDATA( mr,sizeof(int32)*4) ;


	READDATA( &mpratio,sizeof(int)) ;
	READDATA( &fmvolume,sizeof(int)) ;

	
	READDATA( &mixdelta,sizeof(int32)) ;
	READDATA( &noisecount,sizeof(int32)) ;

	READDATA( &noisedelta,sizeof(uint32)) ;

	READDATA( &interpolation,sizeof(bool)) ;

	READDATA( amtable,sizeof(int)*4*FM_LFOENTS) ;
	READDATA( pmtable,sizeof(int)*4*FM_LFOENTS) ;


	for ( int i = 0 ; i < 8 ; i++ )
	{
		ptr += ch[i].loadcontext_channel4( ptr ) ;
	}

	ptr += lpf.loadcontext_lpf( ptr ) ;

	ptr += loadcontext_fmgen( ptr) ;

	return ptr - buf ;
}





}

#endif // FM_OPM_H
