// ---------------------------------------------------------------------------
//	FM sound generator common timer module
//	Copyright (C) cisc 1998, 2000.
// ---------------------------------------------------------------------------
//	$Id: fmtimer.h,v 1.1 2000/09/08 13:45:56 cisc Exp $

#ifndef FM_TIMER_H
#define FM_TIMER_H

#include "types.h"
#include "memory.h"

// ---------------------------------------------------------------------------

namespace FM
{
	class Timer
	{
	public:
		void	Reset();
		bool	Count(int32 us);
		int32	GetNextEvent();
		int     savecontext_timer( unsigned char *buf ) ;
		int     loadcontext_timer( unsigned char *buf ) ;
	
	protected:
		virtual void SetStatus(uint bit) = 0;
		virtual void ResetStatus(uint bit) = 0;

		void	SetTimerBase(uint clock);
		void	SetTimerA(uint addr, uint data);
		void	SetTimerB(uint data);
		void	SetTimerControl(uint data);
		
		uint8	status;
		uint8	regtc;
	
	private:
		virtual void TimerA() {}
		uint8	regta[2];
		
		int32	timera, timera_count;
		int32	timerb, timerb_count;
		int32	timer_step;
	};

// ---------------------------------------------------------------------------
//	
//

#define WRITEDATA( src, size ) \
	memcpy( ptr, src, size ) ;\
	ptr += size ;

inline int Timer::savecontext_timer( unsigned char *buf )
{
	unsigned char *ptr = buf ;

	WRITEDATA( &status, sizeof(uint8) ) ;
	WRITEDATA( &regtc, sizeof(uint8) ) ;
	WRITEDATA( regta, 2*sizeof(uint8) ) ;
	WRITEDATA( &timera, sizeof(int32) ) ;
	WRITEDATA( &timera_count, sizeof(int32) ) ;
	WRITEDATA( &timerb, sizeof(int32) ) ;
	WRITEDATA( &timerb_count, sizeof(int32) ) ;
	WRITEDATA( &timer_step, sizeof(int32) ) ;

	return ptr-buf ;

}


#define READDATA( dst, size ) \
	memcpy( dst, ptr, size ) ;\
	ptr += size ;

inline int Timer::loadcontext_timer( unsigned char *buf )
{
	unsigned char *ptr = buf ;

	READDATA( &status, sizeof(uint8) ) ;
	READDATA( &regtc, sizeof(uint8) ) ;
	READDATA( regta, 2*sizeof(uint8) ) ;
	READDATA( &timera, sizeof(int32) ) ;
	READDATA( &timera_count, sizeof(int32) ) ;
	READDATA( &timerb, sizeof(int32) ) ;
	READDATA( &timerb_count, sizeof(int32) ) ;
	READDATA( &timer_step, sizeof(int32) ) ;

	return ptr-buf ;

}

inline void Timer::Reset()
{
	timera_count = 0;
	timerb_count = 0;
}

} // namespace FM

#endif // FM_TIMER_H
