//
// (c) yamama
// EX68 windrv
//

// Customize for Keropi by Kenjo

//#define WDDEBUG		// WinDrṽOp

#include "../win32/common.h"
#include "../win32/winx68k.h"
#include "../win32/prop.h"
#include "../win32/cdrom.h"
#include "m68000.h"
#include "memory.h"
#include "sram.h"
#include "tvram.h"
#include "gvram.h"
#include "windrv.h"
#include <direct.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <mbstring.h>
#include <winbase.h>
#include <time.h>

char filepath[MAX_PATH];
Win68Conf Config;
BYTE FrameRate;


typedef struct {
    char slotA[MAX_PATH];
    char slotB[MAX_PATH];
    char slotAZip[MAX_PATH];
    char slotBZip[MAX_PATH];
    int autostartA;
} DiskdriveProperties;

typedef struct {
    DiskdriveProperties diskdrive;
	int frameskip ;
	int speed ;
	int reverse_joy ;
	int OPM_VOL  ;
	int PCM_VOL  ;
	int MCR_VOL  ;
	char hdfile[MAX_PATH] ;
	char hdfilezip[MAX_PATH] ;
	int hdzip ;
	int mouse_sensitivity ;

} Properties;


extern Properties* pProperties ;

extern BYTE    KeyTable[512];
extern BYTE    KeyTableMaster[512];

static const __int64 SECS_BETWEEN_EPOCHS = 11644473600;
static const __int64 SECS_TO_100NS = 10000000; /* 10^7 */

	path_buff_s	path_tbl[MAX_PATH_TBL];	//FCBpathׂ̃e[u
	int	path_cur_prio;
	char	win_letter;
	int	num_win_drv;
	char	win_drvs[32];

	files_buff_s files_tbl[MAX_FILES_TBL];
	int files_next;		//pointer
	int files_num;
	int fatr;

	int	gr_files = 0;
	char	gr_buf[16][256];

void Error(const char* s)
{
}

 FILETIME FILEUnixTimeToFileTime( time_t sec, long nsec )
 {
     __int64 Result;
     FILETIME Ret;
 
     Result = ((__int64)sec + SECS_BETWEEN_EPOCHS) * SECS_TO_100NS +
         (nsec / 100);
 
     Ret.dwLowDateTime = (DWORD)Result;
     Ret.dwHighDateTime = (DWORD)(Result >> 32);
 
     //TRACE("Unix time = [%ld.%09ld] converts to Win32 FILETIME = [%#x:%#x]\n", 
           //sec, nsec, Ret.dwHighDateTime, Ret.dwLowDateTime);
 
     return Ret;
 }

BOOL DosDateTimeToFileTime(
                                  IN WORD wFatDate,
                                  IN WORD wFatTime,
                                  OUT LPFILETIME lpFileTime
                                   )
 {
 
     BOOL bRet = FALSE;
     struct tm  tmTime;
     time_t    tmUnix;
	 SYSTEMTIME systime ;
 
     //ENTRY("DosDateTimeToFileTime(wFatdate=%#hx,wFatTime=%#hx,lpFileTime=%p)\n",
           //wFatDate,wFatTime,lpFileTime);
     /*Breakdown wFatDate & wfatTime to fill the tm structure */
     /*wFatDate contains the Date data & wFatTime time data*/
     /*wFatDate 0-4 bits-Day of month(0-31)*/
     /*5-8 Month(1=Jan,2=Feb)*/
     /*9-15 Year offset from 1980*/
     /*wFtime 0-4 Second divided by 2*/
     /*5-10 Minute(0-59)*/
     /*11-15 Hour 0-23 on a 24 hour clock*/
 
     tmTime.tm_mday = (wFatDate & 0x1F);
     if ( tmTime.tm_mday < 1 || tmTime.tm_mday > 31 )
     {
         //ERROR( "Incorrect day format was passed in.\n" );
         //SetLastError( ERROR_INVALID_PARAMETER );
         goto done;
     }
     

     /*tm_mon is the no. of months from january*/
     tmTime.tm_mon = ((wFatDate >> 5) & 0x0F)-1;
     if ( tmTime.tm_mon < 0 || tmTime.tm_mon > 11 )
     {
         //ERROR( "Incorrect month format was passed in.\n" );
         //SetLastError( ERROR_INVALID_PARAMETER );
         goto done;
     }
 
     /*tm_year is the no. of years from 1900*/
     tmTime.tm_year = ((wFatDate >> 9) & 0x7F) + 80;
     if ( tmTime.tm_year < 0 || tmTime.tm_year > 207 )
     {
         //ERROR( "Incorrect year format was passed in. %d\n", tmTime.tm_year );
         //SetLastError( ERROR_INVALID_PARAMETER );
         goto done;
     }
 
     tmTime.tm_sec = ( (wFatTime & 0x1F)*2 );
     if ( tmTime.tm_sec < 0 || tmTime.tm_sec > 59 )
     {
         //ERROR( "Incorrect sec format was passed in.\n" );
         //SetLastError( ERROR_INVALID_PARAMETER );
         goto done;
     }
     
     tmTime.tm_min = ((wFatTime >> 5) & 0x3F);
     if ( tmTime.tm_min < 0 || tmTime.tm_min > 59 )
     {
         //ERROR( "Incorrect minute format was passed in.\n" );
         //SetLastError( ERROR_INVALID_PARAMETER );
         goto done;
     }
 
     tmTime.tm_hour = ((wFatTime >> 11) & 0x1F);
     if ( tmTime.tm_hour < 0 || tmTime.tm_hour > 23 )
     {
         //ERROR( "Incorrect hour format was passed in.\n" );
         //SetLastError( ERROR_INVALID_PARAMETER );
         goto done;
     }
     
     /* Have the system try to determine if DST is being observed. */
     tmTime.tm_isdst = 0;
     
 	 systime.wDay = tmTime.tm_mday ;
	 systime.wHour = tmTime.tm_hour ;
	 systime.wMinute = tmTime.tm_min ;
	 systime.wMonth = tmTime.tm_mon ;
	 systime.wSecond = tmTime.tm_sec ;
	 systime.wYear = tmTime.tm_year ;
	 systime.wMilliseconds = 0 ;

	 return SystemTimeToFileTime( &systime, lpFileTime ) ;

	 /*get the date time in seconds*/
     //tmUnix = timegm(&tmTime);
     
     /*check if the output buffer is valid*/
     //if( lpFileTime )
     //{
         //*lpFileTime = FILEUnixTimeToFileTime( tmUnix, 0 );
         //bRet = TRUE;
     //}
 
 done:
     //LOGEXIT("DosDateTimeToFileTime returns BOOl  %d \n",bRet);
     return bRet;
 
 }	
	
	
FileTimeToDosDateTime(
                     IN CONST FILETIME *lpFileTime,
                     OUT LPWORD lpFatDate,
             OUT LPWORD lpFatTime )
 {
     BOOL bRetVal = FALSE;
 
 
     /* Sanity checks. */
     if ( !lpFileTime || !lpFatDate || !lpFatTime )
     {
         //ERROR( "Incorrect parameters.\n" );
         //SetLastError( ERROR_INVALID_PARAMETER );
     }
     else
     {
         /* Do conversion. */
         SYSTEMTIME SysTime;
         if ( FileTimeToSystemTime( lpFileTime, &SysTime ) )
         {
             if ( SysTime.wYear >= 1980 && SysTime.wYear <= 2037 )
             {
                 *lpFatDate = 0;
                 *lpFatTime = 0;
 
                 *lpFatDate |= ( SysTime.wDay & 0x1F );
                 *lpFatDate |= ( ( SysTime.wMonth & 0xF ) << 5 );
                 *lpFatDate |= ( ( ( SysTime.wYear - 1980 ) & 0x7F ) << 9 );
 
                 if ( SysTime.wSecond % 2 == 0 )
                 {
                     *lpFatTime |= ( ( SysTime.wSecond / 2 )  & 0x1F );
                 }
                 else
                 {
                     *lpFatTime |= ( ( SysTime.wSecond / 2 + 1 )  & 0x1F );
                 }
 
                 *lpFatTime |= ( ( SysTime.wMinute & 0x3F ) << 5 );
                 *lpFatTime |= ( ( SysTime.wHour & 0x1F ) << 11 );
                 
                 bRetVal = TRUE;
             }
             else
             {
                 //ERROR( "The function can only repersent dates between 1/1/1980"
                        //" and 12/31/2037\n" );
                 //SetLastError( ERROR_INVALID_PARAMETER );
             }
         }
         else
         {
             //ERROR( "Unable to convert file time to system time.\n" );
             //SetLastError( ERROR_INVALID_PARAMETER );
             bRetVal = FALSE;
         }
     }
 
     //LOGEXIT( "returning BOOL %d\n", bRetVal );
     return bRetVal;
 }
	
	
	
	
	// -------------------------------------------------------
// e[u
// -------------------------------------------------------
void init_path_tbl(void)
{
	int i;
	for(i=0; i<MAX_PATH_TBL; i++)
	{
		path_tbl[i].plen=0;
		path_tbl[i].prio=0;
	}
	path_cur_prio=0;
}

void init_files_tbl(void)
{
	int i;
	for(i=0; i<MAX_FILES_TBL; i++)
	{
		files_tbl[i].key=-1;
		files_tbl[i].files_num=-1;
	}
	files_next=0;
}


// -------------------------------------------------------
// get_real
//   X68ւ̃|C^Win̈ʒuvZAobt@̎e߂
// -------------------------------------------------------
char* get_real(int adr)
{
	int pos;
	for (pos=0; pos<256; pos++)
		gr_buf[gr_files][pos] = Memory_ReadB(adr+pos);

	gr_files++;

	return (char*)(&gr_buf[gr_files-1][0]);
}


// -------------------------------------------------------
// gen_path(char *path, int drv, unsigned char *ppname)
//   hCu܂ރpX쐬
// -------------------------------------------------------
int gen_path(char *path, int drv, unsigned char *ppname)
{
	int i;

	path[0] = drv;
	path[1] = ':';
	for (i=XN_PATH; i<XN_FILENAME; i++)
	{
		char ch = ppname[i];
		if (ch == 9) ch = '\\';
		path[i] = ch;
		if (ch == 0)
		{
			if (path[i-1] == '\\')
				i--;
			break;
		}
	}
	path[i]=0;
	return i;
}


// -------------------------------------------------------
// addname(char *path, unsigned char *ppname)
//   pathɃt@CǉB
// -------------------------------------------------------
void addname(char *path, unsigned char *ppname)
{
	int i=0, j;

	for(j=XS_FILENAME; j<XS_EXT; j++)
	{
		if (ppname[j] == ' ')
			break;
		path[i++] = ppname[j];
	}

	if (Config.LongFileName!=0)
	{
		for(j=XS_FILENAME2; j<XS_ENDBFFER; j++)
		{
			if (ppname[j] == 0)
				break;
			path[i++] = ppname[j];
		}
	}
	path[i++]='.';
	for(j=XS_EXT; j<XS_FILENAME2; j++)
	{
		if (ppname[j] == 0)
			break;
		if (ppname[j] == ' ')
			break;
		path[i++] = ppname[j];
	}
	path[i]=0;
}


// -------------------------------------------------------
// get_space(int b_addr)
//   JghCu̗eʂ𓾂
//   ret: 󂫗eʁi0=errorj
// -------------------------------------------------------
int get_space(int b_addr)
{
	unsigned long lpSectorsPerCluster;
	unsigned long lpBytesPerSector;
	unsigned long lpFreeClusters;
	unsigned long lpClusters;
	unsigned long lpavailablebytes ;
	unsigned long lptotalbytes ;

	char path[16];

	sprintf(path, "%c:\\", win_letter);	//hCu
	if (GetDiskFreeSpaceEx(path, NULL, &lptotalbytes, &lpavailablebytes ) )
		//&lpSectorsPerCluster, 
		//&lpBytesPerSector, 
		//&lpFreeClusters, 
		//&lpClusters))
	{
		if (lpFreeClusters>0xffff) lpFreeClusters = 0xffff;	// [h͈͂𒴂ꍇ
		if (lpClusters>0xffff) lpClusters = 0xffff;
		Memory_WriteW(b_addr,   (WORD)lpFreeClusters);
		Memory_WriteW(b_addr+2, (WORD)lpClusters);
		Memory_WriteW(b_addr+4, (WORD)lpSectorsPerCluster);
		Memory_WriteW(b_addr+6, (WORD)lpBytesPerSector);
		return lpavailablebytes ;
		//return (lpFreeClusters)*(lpSectorsPerCluster)*(lpBytesPerSector);
	}
	return 0;
}


// -------------------------------------------------------
// get_volume(int file)
//   {[̎擾
//   file: o̓obt@
// -------------------------------------------------------
int get_volume(int file)
{
	char lpVolumeNameBuffer[MAX_PATH];	/* {[̖ÕAhX	*/
	DWORD nVolumeNameSize=12;		/* lpVolumeNameBuffer̒ */
	DWORD lpMaximumComponentLength; /* VXẽt@C̍ő咷̃AhX	*/
	DWORD lpFileSystemFlags;		/* t@C VXẽtÕAhX	*/
	char path[16];
	int i;

	sprintf(path,"%c:\\",win_letter);

#if 0
	if (GetVolumeInformation(path, 
			lpVolumeNameBuffer, 
			nVolumeNameSize,
			NULL, 
			&lpMaximumComponentLength, 
			&lpFileSystemFlags,
			NULL, 
			0))
	{
		for (i=0; i<(XF_ENDFILEBUF-XF_FILENAMEEXT); i++)
			Memory_WriteB(file+XF_FILENAMEEXT+i, lpVolumeNameBuffer[i]);
	} else {
		Memory_WriteB(file+XF_FILENAMEEXT, 0);
	}
	if (lpVolumeNameBuffer[0])
		return 0;
	return -1;
#else
	if (GetVolumeInformation(path,
			lpVolumeNameBuffer,
			nVolumeNameSize,
			NULL,
			&lpMaximumComponentLength,
			&lpFileSystemFlags,
			NULL,
			0))
	{
		for (i=0; i<(XF_ENDFILEBUF-XF_FILENAMEEXT); i++)
			Memory_WriteB(file+XF_FILENAMEEXT+i, lpVolumeNameBuffer[i]);
		return 0;	// 擾
	}
	return -2;		// 擾s
#endif
}


// -------------------------------------------------------
// gen_file_FCB(char *out, int fcb)
//   FCBt@C쐬
// -------------------------------------------------------
void gen_file_FCB(char *out, int fcb)
{
	unsigned char *pfcb = get_real(fcb);
	char ch;
	int i,j;

	j=0;
	for(i=XFCB_FILENAME; i<XFCB_FILEEXT; i++)
	{
		ch=pfcb[i];
		if (ch==0) break;
		if (ch==' ') break;
		out[j++]=ch;
	}
	if (Config.LongFileName!=0)
	{	//long file name
		for(i=XFCB_FILENAME2; i<XFCB_FILETIME; i++)
		{
			ch=pfcb[i];
			if (ch==0) break;
			if (ch==' ') break;
			out[j++]=ch;
		}
	}

	out[j++]='.';
	for(i=XFCB_FILEEXT; i<XFCB_FILEATR; i++)
	{
		ch=pfcb[i];
		if (ch==0) break;
		if (ch==' ') break;
		out[j++]=ch;
	}
	out[j]=0;
}


// -------------------------------------------------------
// replace_tail(char *temp,int num)
// -------------------------------------------------------
void replace_tail(char *temp,int num)
{
	int pos;

	if (strlen(temp)==0) return;
	if (temp[num-1] != '?') return;
	pos = strlen(temp)-1;
	while((pos>=0) && (temp[pos] == '?'))
		pos--;
	temp[++pos]='*';
	temp[++pos]=0;
}


// -------------------------------------------------------
// gen_file_name(char *out, int adr)
//   namests\path+8.3`Along file name֕ϊ
//   in: namestsobt@Aout o̓obt@
// -------------------------------------------------------
void gen_file_name(char *out, int adr)
{
	char temp[MAX_PATH], temp2[MAX_PATH];
	char in[XS_ENDBFFER];
	int i;

	for (i=0; i<XS_ENDBFFER; i++)
		in[i] = Memory_ReadB(adr+i);

	//pathRs[
	i=gen_path(out,win_letter,(unsigned char *)in);
	out[i++]='\\';
	out[i++]=0;
	//t@C
	memcpy(temp,&in[XS_FILENAME],8); temp[8]=0;
	for(i=0; i<8; i++)
		if (temp[i]==' ') temp[i]=0;
	if (strcmp(temp,"????????")==0)
	{
		strcat(out,"*");
	}
	else
	{
		strcpy(temp2,temp);
		// file name +
		memcpy(temp,&in[XS_FILENAME2],10); temp[10]=0;
		for(i=0; i<10; i++)
			if (temp[i]==' ') temp[i]=0;
		strcat(temp2,temp);
		replace_tail(temp2,18);
		strcat(out,temp2);
	}

	//gq
	memcpy(temp,&in[XS_EXT],3); temp[3]=0;
	for(i=0; i<3; i++)
		if (temp[i]==' ') temp[i]=0;
	replace_tail(temp,3);
	if (temp[0])
	{
		if (strcmp(temp,"???")==0)
		{
			strcat(out,".*");
		}
		else
		{
			strcat(out,".");
			strcat(out,temp);
		}
	}
}


// -------------------------------------------------------
// gen_file_name2(char *out, char* adr)
//   namests\path+8.3`Along file name֕ϊ
//   in: namestsobt@Aout o̓obt@
// -------------------------------------------------------
void gen_file_name2(char *out, char* in)
{
	char temp[MAX_PATH], temp2[MAX_PATH];
	int i;

	//pathRs[
	i = gen_path(out,win_letter,(unsigned char *)in);
	out[i++]='\\';
	out[i++]=0;
	//t@C
	memcpy(temp,&in[XS_FILENAME],8); temp[8]=0;
	for(i=0; i<8; i++)
		if (temp[i]==' ') temp[i]=0;
	if (strcmp(temp,"????????")==0)
	{
		strcat(out,"*");
	}
	else
	{
		strcpy(temp2,temp);
		// file name +
		memcpy(temp,&in[XS_FILENAME2],10); temp[10]=0;
		for(i=0; i<10; i++)
			if (temp[i]==' ') temp[i]=0;
		strcat(temp2,temp);
		replace_tail(temp2,18);
		strcat(out,temp2);
	}

	//gq
	memcpy(temp,&in[XS_EXT],3); temp[3]=0;
	for(i=0; i<3; i++)
		if (temp[i]==' ') temp[i]=0;
	replace_tail(temp,3);
	if (temp[0])
	{
		if (strcmp(temp,"???")==0)
		{
			strcat(out,".*");
		}
		else
		{
			strcat(out,".");
			strcat(out,temp);
		}
	}
}


// -------------------------------------------------------
// spr_name83(char *in,char *name,char *ext)
//   OƊgqɕ
//   ]̓Xy[Xɂ
//   in  name / ext
// -------------------------------------------------------
void spr_name83(char *in,char *name,char *ext)
{
	char ch;
	int i, j, pos;

	if (Config.LongFileName!=0)
	{	//long file name
		strcpy(name,"                  ");
		strcpy(ext,"   ");
		pos=-1;
		for (i=0; in[i]!=0; i++)
		{
			if (in[i]=='.') pos=i;
		}
		if (pos==-1)
		{	// no .
			memcpy(name, in, min(i,18));
		}
		else
		{	//
			memcpy(name, in, pos);
			if (i>pos)
				memcpy(ext, &in[pos+1], i-pos);
		}
	}
	else
	{	//8.3
		strcpy(name,"        ");
		strcpy(ext,"   ");
		i=0; j=0;
		while(1)
		{
			ch=in[i++];
			if (ch=='.')	//͊gq
				break;
			if (ch==0)
				return;
			name[j++]=ch;
		}
		if (in[i])
		{
			j=0;
			while(1)
			{
				ch=in[i++];
				if (ch==0)
					return;
				ext[j++]=ch;
			}
		}
	}
}


// -------------------------------------------------------
// mer_name83(char *out,char *name,char *ext)
//   83`ɍ
//   out  name.ext
// -------------------------------------------------------
void mer_name83(char *out,char *name,char *ext)
{
	char ch;
	int i,j;

	if (Config.LongFileName!=0)
	{	//long file name
		j=0;
		for(i=0; i<(8+10); i++)
		{
			ch=name[i];
			if (ch==0) break;
			if (ch==' ') break;
			out[j++]=ch;
		}
		out[j++]='.';
		for(i=0; i<3; i++)
		{
			ch=ext[i];
			if (ch==0) break;
			if (ch==' ') break;
			out[j++]=ch;
		}
		out[j]=0;
	}
	else
	{	//8.3 file name
		j=0;
		for(i=0; i<8; i++)
		{
			ch=name[i];
			if (ch==0) break;
			if (ch==' ') break;
			out[j++]=ch;
		}
		out[j++]='.';
		for(i=0; i<3; i++)
		{
			ch=ext[i];
			if (ch==0) break;
			if (ch==' ') break;
			out[j++]=ch;
		}
		out[j]=0;
	}
}

enum {
	HU_READONLY=1,
	HU_HIDDEN=2,
	HU_SYSTEM=4,
	HU_ARCHIVE=0x20
};


// -------------------------------------------------------
// conv_atr(int atr)
//   Windows̃t@CHumañt@Cɕϊ
//   atr : windows file attribute
//   return: Human file attribute
// -------------------------------------------------------
int conv_atr(int atr)
{
	int res=0;

//	if (atr&FILE_ATTRIBUTE_ARCHIVE)
//		res|=HU_ARCHIVE;
	if (atr&FILE_ATTRIBUTE_HIDDEN)
		res|=HU_HIDDEN;
	if (atr&FILE_ATTRIBUTE_READONLY)
		res|=HU_READONLY;
	if (atr&FILE_ATTRIBUTE_SYSTEM)
		res|=HU_SYSTEM;
	return res;
}


// -------------------------------------------------------
// xconv_atr(int atr)
//   Humañt@CWindows̃t@Cɕϊ
//   atr : Human file attribute
//   return: Windows file attribute
// -------------------------------------------------------
int xconv_atr(int atr)
{
	int res=0;

//	if (atr&HU_ARCHIVE)
		res|=FILE_ATTRIBUTE_ARCHIVE;   
	if (atr&HU_HIDDEN)
		res|=FILE_ATTRIBUTE_HIDDEN;
	if (atr&HU_READONLY)
		res|=FILE_ATTRIBUTE_READONLY;
	if (atr&HU_SYSTEM)
		res|=FILE_ATTRIBUTE_SYSTEM;
	return res;
}


// -------------------------------------------------------
// spacetounderbar(char *cFileName)
//   X68ł͎gȂXy[XA_[o[ɕϊB
// -------------------------------------------------------
void spacetounderbar(char *cFileName)
{
	int size=strlen(cFileName), i;
	for(i=0; i<size; i++)
	{
		if (cFileName[i]==0)
			return;
		else if (cFileName[i]==' ')
			cFileName[i]='_';
	}
}


// -------------------------------------------------------
// isx68filename(const char *name)
//   X68̈t@Cǂ`FbN
//   TRUE: OKAFALSE: Win Only
// -------------------------------------------------------
int isx68filename(const char *name)
{
	int i, pos, spos;

	pos=-1;
	spos=-1;
	for (i=0; name[i]!=0; i++)
	{
		if (name[i]=='.') pos=i;
		if (name[i]==' ') spos=i;
	}
	if (pos > 18)
		return FALSE;	//gqȑO18𒴂
	if (pos != -1)
	{
		if ((i-pos) > 4)
			return FALSE;	//gq4𒴂
	}
	else
	{
		if (i>18)
			return FALSE;	//gq̖t@C̒18ȏ
	}
	if (spos != -1)
		return FALSE;	//Xy[XĂ
	return TRUE;
}


// -------------------------------------------------------
// set_file_name(int file, WIN32_FIND_DATA lpffd)
//   Windows̃t@CX68̃t@CƂĎgȂlong file name
//   gȂȂmsdost@Cg
//   lpffd: Wiñt@CAfile: ʃobt@
// -------------------------------------------------------
void set_file_name(int file, WIN32_FIND_DATA lpffd)
{
	int i;
		//Ot@CΉ
	if (Config.LongFileName!=0)
	{
		if (!lpffd.cFileName[0])
		{
			for (i=0; i<12; i++)
				Memory_WriteB(file+XF_FILENAMEEXT+i, lpffd.cAlternateFileName[i]);
		}
		else 
		{
			if ((lpffd.cAlternateFileName[0]) && (!isx68filename(lpffd.cFileName)))
			{
				for (i=0; i<12; i++)
					Memory_WriteB(file+XF_FILENAMEEXT+i, lpffd.cAlternateFileName[i]);
				//strncpy((char*)&pfile[XF_FILENAMEEXT],lpffd.cAlternateFileName,12);
			} else {
				for (i=0; i<23; i++)
					Memory_WriteB(file+XF_FILENAMEEXT+i, lpffd.cFileName[i]);
				//strncpy((char*)&pfile[XF_FILENAMEEXT],lpffd.cFileName,23);
			}
		}
	}
	else
	{	//8.3
		if (lpffd.cAlternateFileName[0])
		{
			for (i=0; i<12; i++)
				Memory_WriteB(file+XF_FILENAMEEXT+i, lpffd.cAlternateFileName[i]);
			//strncpy((char*)&pfile[XF_FILENAMEEXT],lpffd.cAlternateFileName,12);
		} else {
			for (i=0; i<23; i++)
				Memory_WriteB(file+XF_FILENAMEEXT+i, lpffd.cFileName[i]);
			//strncpy((char*)&pfile[XF_FILENAMEEXT],lpffd.cFileName,23);
		}
	}
}


// -------------------------------------------------------
// visivle(char *f)
//   ̃t@Co
// -------------------------------------------------------
int visible(char* f)
{
	int i;

	for(i=0; f[i]!=0; i++)
	{
		if (f[i]&0x80)
		{
			i++; continue;	//QoCg͌oȂ
		}
		if ( (f[i]=='[') || (f[i]==']') || (f[i]=='=') || (f[i]=='+') )
			return FALSE;	//so false
	}
	return TRUE;
}


// -------------------------------------------------------
// get_files(int pfile)
//   t@C܂̓fBNgPׂ
//   pfile: ʂ̃obt@AhX
// -------------------------------------------------------
int get_files(char* name, int pfile, int atr)
{
	int number=-1;
	WORD lpwDOSDate,lpwDOSTime;
	FILETIME lpftLocal;

	WIN32_FIND_DATA lpffd;	/* Ԃ̃AhX	*/
	HANDLE file;

	int first=1;

	while(1)
	{
		if (first)	//ŏ
		{
			file = FindFirstFile(name, &lpffd);
			if (file==INVALID_HANDLE_VALUE)
			{
 				Memory_WriteB(pfile+1, 0);
				return -2;		//Ȃ
			}
			first=0;
		}
		else	//Qڈȍ~̌
		{
			if (!FindNextFile(file, &lpffd))
			{
 				Memory_WriteB(pfile+1, 0);
				FindClose(file);
				return -2;		//Ȃ
			}
		}

		if (lpffd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)	//fBNg
		{
			if (atr&0x10)	//fBNg
			{
				if (!visible(lpffd.cFileName))
					continue;
				number++;
				if (number != files_num)	//Ԃ`FbN
					continue;
				//t@C̕ϊ
 				Memory_WriteB(pfile+XF_ATRCHK, (BYTE)(0x10|conv_atr(lpffd.dwFileAttributes)));

				//Ot@CΉ
				set_file_name(pfile,lpffd);

				Memory_WriteD(pfile+26, 0);	//lpffd.nFileSizeHigh

				//^CX^vΉ
				FileTimeToLocalFileTime(&lpffd.ftLastWriteTime, &lpftLocal);
				if (FileTimeToDosDateTime(&lpftLocal, &lpwDOSDate, &lpwDOSTime))
				{
					Memory_WriteW(pfile+XF_LASTTIME, lpwDOSTime);
					Memory_WriteW(pfile+XF_LASTDATE, lpwDOSDate);
				}
				Memory_WriteD(pfile+2, 0xa1);
				Memory_WriteW(pfile+6, 0xf);
				Memory_WriteW(pfile+8, (WORD)(number*0x20));
				FindClose(file);
				return 0;	//0xfffffff2;
			}
		}
		else
		{
			if ((atr&0x20))	//t@C
			{
				if (!visible(lpffd.cFileName))
					continue;
				number++;
				if (number != files_num)	//Ԃ`FbN
					continue;
				//t@CΉ
 				Memory_WriteB(pfile+XF_ATRCHK, (BYTE)(0x20|conv_atr(lpffd.dwFileAttributes)));

				//Ot@CΉ
				set_file_name(pfile, lpffd);

				//t@CTCYΉ
				Memory_WriteD(pfile+XF_FILESIZE, lpffd.nFileSizeLow);

				//^CX^vΉ
				FileTimeToLocalFileTime(&lpffd.ftLastWriteTime, &lpftLocal);
				if (FileTimeToDosDateTime(&lpftLocal, &lpwDOSDate, &lpwDOSTime))
				{
					Memory_WriteW(pfile+XF_LASTTIME, lpwDOSTime);
					Memory_WriteW(pfile+XF_LASTDATE, lpwDOSDate);
				}
				Memory_WriteD(pfile+2, 0xa1);
				Memory_WriteW(pfile+6, 0xf);
				Memory_WriteW(pfile+8, (WORD)(number*0x20));
 				FindClose(file);
				return 0;	//0xfffffff2;
			}
		}
	}
}


// -------------------------------------------------------
// files(int atr, int name, int file)
//   t@C܂̓fBNǧi1ځj
//   atr: t@C̃Agr[gAname: t@Cւ̃|C^Afile: ʃobt@
// -------------------------------------------------------
int files(int atr, int name, int file)
{
	int ret, i;
	char pname[MAX_PATH];

	ZeroMemory(pname, MAX_PATH);
	files_tbl[files_next].key = file;
	files_num=files_tbl[files_next].files_num = 0;
	files_tbl[files_next].fatr = atr;
	for (i=0; i<256; i++)
		files_tbl[files_next].pname[i] = (BYTE)Memory_ReadB(name+i);
	files_next = (files_next+1)&(MAX_FILES_TBL-1);
	fatr=atr;


	if ((atr&0x38)==8)
	{	//{[x
		return get_volume(file);
	}
	else
	{
		gen_file_name(pname, name);	//namestspath+8.3`֕ϊ
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "FILES - %s\n", pname);
fclose(fp);
}
#endif
		ret=get_files(pname, file, atr);
		return ret;
	}
	return -1;
}


// -------------------------------------------------------
// get_files_idx(int file)
//   ̃t@C܂̓fBNǧ
//   file: ʃobt@
// -------------------------------------------------------
int get_files_idx(int file)
{
	int i, idx;
	for(i=0; i<MAX_FILES_TBL; i++)
	{
		idx = (files_next+MAX_FILES_TBL*2-i-1)&(MAX_FILES_TBL-1);
		if (files_tbl[idx].key == file)
		{
			return idx;
		}
	}
	return -1;
}


// -------------------------------------------------------
// nfiles(int file)
//   ̃t@C܂̓fBNǧ
//   file: ʃobt@
// -------------------------------------------------------
int nfiles(int file)
{
	int idx, ret;
	char pname[MAX_PATH];

	ZeroMemory(pname, MAX_PATH);
	idx = get_files_idx(file);
	if (idx < 0) return -2;

	gen_file_name2(pname, files_tbl[idx].pname);	//namestspath+8.3`֕ϊ

	files_tbl[idx].files_num++;
	files_num = files_tbl[idx].files_num;
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "NFILES - %s / Num:%d\n", pname, files_num);
fclose(fp);
}
#endif
	ret = get_files(pname, file, files_tbl[idx].fatr);

	return ret;
}


// -------------------------------------------------------
// chk_dir(int pname)
//   fBNg݂̑`FbN
//   ret=0: ݁Aret=-2: ȂorfBNgȊO
// -------------------------------------------------------
int chk_dir(int pname)
{
	unsigned char *ppname = get_real(pname);
	char path[MAX_PATH];
	WIN32_FIND_DATA lpffd;	/* Ԃ̃AhX	*/
	HANDLE file;
	int return_f;

	if (ppname[3] == 0)	return 0;	//[gfBNg͕K݂B

	(void)gen_path(path,win_letter,ppname);
	file = FindFirstFile(path, &lpffd);

	if (file == INVALID_HANDLE_VALUE)
	{
		return_f = -2;
	}
	else if (lpffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	{
		FindClose(file);
		return_f = 0;
	}
	else
	{
		FindClose(file);
		return_f = -2;
	}

	return return_f;
}


// -------------------------------------------------------
// make_dir(int pname)
//   fBNg쐬
// -------------------------------------------------------
int make_dir(int pname)
{
	unsigned char *ppname = get_real(pname);
	char path[MAX_PATH];
	int i;

	i=gen_path(path, win_letter, ppname);
	path[i++]='\\';
	addname(&path[i], ppname);
	return CreateDirectory(path, NULL);
}


// -------------------------------------------------------
// rm_dir(int pname)
//   fBNg폜
// -------------------------------------------------------
int rm_dir(int pname)
{
	unsigned char *ppname = get_real(pname);
	char path[MAX_PATH];
	int i;

	i=gen_path(path, win_letter, ppname);
	path[i++]='\\';
	addname(&path[i], ppname);
	return RemoveDirectory(path);
}


// -------------------------------------------------------
// file_atr(int atr_adr,int pname)
//   t@C̓ǂݏoA
// -------------------------------------------------------
int file_atr(int atr_adr, int pname)
{
	int atr = Memory_ReadB(atr_adr);	//-1Ȃ擾
	char lpszSearchFile[MAX_PATH];		// t@C̖ÕAhX
	HANDLE file;
	WIN32_FIND_DATA lpffd;			// Ԃ̃AhX

	gen_file_name(lpszSearchFile, pname);	//namestspath+8.3`֕ϊ
	file=FindFirstFile(lpszSearchFile, &lpffd);
	if (file==INVALID_HANDLE_VALUE)
		return -2;

	if (lpffd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
	{
		//fBNgȂ疳B
		FindClose(file);
		return -2;
	}

	FindClose(file);
	if ((atr&0xff)==0xff)	//₢킹
	{
		//ǂݎt@C̑attr_adrɐݒ肷B
		Memory_WriteB(atr_adr, (BYTE)conv_atr(lpffd.dwFileAttributes));
	}
	else
	{
		//atrt@Cɐݒ肷B
		SetFileAttributes(lpszSearchFile,	// address of filename
				xconv_atr(atr));	// address of attributes to set
	}
	return 0;
}


// -------------------------------------------------------
// chkdouble(char *pathfile)
//   \̏d\\\ɏC
// -------------------------------------------------------
void chkdouble(char *pathfile)
{
	char *wpt,*pt;
	wpt=pt=pathfile;
	while(*pt)
	{
		if ((*pt=='\\') && (*(pt+1)=='\\'))
			pt++;
		*wpt++=*pt++;
	}
	*wpt=0;
}



// -------------------------------------------------------
// chk_file(int pname, int fcb)
//   xopenB t@C݂̑`FbNH
// -------------------------------------------------------
int chk_file(int pname, int fcb)
{
	char lpszSearchFile[MAX_PATH];	/* t@C̖ÕAhX */
	int first=1;
	int number=-1;
	WORD lpwDOSDate,lpwDOSTime;
	FILETIME lpftLocal;

	WIN32_FIND_DATA lpffd;	/* Ԃ̃AhX	*/
	HANDLE file;
	char sname[10+10], sext[4];
	char *ppname = get_real(pname);

	int i,j,min;
	char name_buf[16+10];
	int sum=0;
	char ch, tmp;

	gen_file_name(lpszSearchFile, pname);	//namestspath+8.3`֕ϊ

//	strcpy(lpszSearchFile,"\\*.*");
	file=FindFirstFile(lpszSearchFile, &lpffd);
	if (file==INVALID_HANDLE_VALUE)
	{
		return -2;
	}
	if (lpffd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
	{
		FindClose(file);
		return -2;	//fBNgł
	}

	tmp = Memory_ReadB( fcb+14 );
	if ((tmp==1) || (tmp==2))
		if (lpffd.dwFileAttributes&
			(FILE_ATTRIBUTE_HIDDEN |
			 FILE_ATTRIBUTE_READONLY |
			 FILE_ATTRIBUTE_SYSTEM))
		{
			FindClose(file);
				 return -2; //݂͕sł
		}

	Memory_WriteD(fcb+6, 0);
	Memory_WriteB(fcb+XFCB_FILEATR, (BYTE)lpffd.dwFileAttributes);	//file attr
	Memory_WriteD(fcb+32, 0);

//vlongΉ
	if (Config.LongFileName!=0)
	{
		if ((lpffd.cAlternateFileName[0]) && (!isx68filename(lpffd.cFileName)))
			spr_name83(lpffd.cAlternateFileName,sname,sext);
		else
			spr_name83(lpffd.cFileName,sname,sext);
	}
	else
	{
		if (lpffd.cAlternateFileName[0])
			spr_name83(lpffd.cAlternateFileName,sname,sext);
		else
			spr_name83(lpffd.cFileName,sname,sext);
	}
	for (i=0; i<8; i++)  Memory_WriteB(fcb+XFCB_FILENAME+i, sname[i]);
	for (i=0; i<3; i++)  Memory_WriteB(fcb+XFCB_FILEEXT+i,  sext[i]);
	for (i=0; i<10; i++) Memory_WriteB(fcb+XFCB_FILENAME2+i,sname[i+8]);

	//t@CTCYΉ
	Memory_WriteD(fcb+XFCB_FILESIZE,lpffd.nFileSizeLow);

#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "CheckFile - %s / Size:%dbytes\n", lpffd.cFileName, lpffd.nFileSizeLow);
fclose(fp);
}
#endif

	//^CX^vΉ
	FileTimeToLocalFileTime(&lpffd.ftLastWriteTime, &lpftLocal);
	if (FileTimeToDosDateTime(&lpftLocal, &lpwDOSDate, &lpwDOSTime))
	{
		Memory_WriteW(fcb+XFCB_FILETIME, lpwDOSTime);
		Memory_WriteW(fcb+XFCB_FILEDATE, lpwDOSDate);
	}
	for(i=0; i<MAX_PATH_TBL; i++)
	{
		if (path_tbl[i].plen==0)	//󂫂T
			break;
	}
	if (i>=MAX_PATH_TBL)	//ȂƂ̃Jo
	{
		i=0;
		min=0x7fffffff;
		for(j=0; j<MAX_PATH_TBL; j++)
		{
			if (path_tbl[j].prio<min)
			{
				min=path_tbl[j].prio;
				i=j;
			}
		}
	}

//longΉ
	//t@CƊgq
	mer_name83(name_buf,sname,sext);

	//FCBƃt@C̑Ή\ɋL^
	path_tbl[i].plen=strlen((char*)&ppname[XS_PATH])+strlen(name_buf);
	path_tbl[i].drive=ppname[XS_DRV];
	memcpy(path_tbl[i].path_str,&ppname[XS_PATH],64);
	memcpy(path_tbl[i].filename,&ppname[XS_FILENAME],11);
	memcpy(path_tbl[i].filenameopt,&ppname[XS_FILENAME2],10);

	strcpy(path_tbl[i].winfile, lpszSearchFile);
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Open - %s\n", lpszSearchFile);
fclose(fp);
}
#endif
	for(j=0; j<64; j++)
	{
		if (path_tbl[i].path_str[j]==9)
			path_tbl[i].path_str[j]='\\';
	}
	path_tbl[i].prio=path_cur_prio++;

	j=0;
	sum = 0;
	while((ch=path_tbl[i].path_str[j++])!=0)
		sum=sum*7+ch;
	path_tbl[i].sum = sum;
	Memory_WriteD(fcb+XFCB_MAGIC, sum);
	Memory_WriteB(fcb+XFCB_MAGIC2, (BYTE)path_tbl[i].drive);
	FindClose(file);
	if (Memory_ReadB(fcb+0xe) == 1)		//open("...","w")̎̐؂l߂s
	{
		char pathfile[MAX_PATH];
		char filename[32];
		FILE *wfp;
	//vlong file nameΉ
	//t@CB
		gen_file_FCB(filename, fcb);
		if (strcmp(path_tbl[i].path_str,"\\")==0)
			sprintf(pathfile,"%c:\\%s",win_letter,filename);
		else
			sprintf(pathfile,"%c:%s\\%s",win_letter,path_tbl[i].path_str,filename);
		chkdouble(pathfile);
		wfp=fopen(pathfile,"w");
		if (wfp!=NULL)
			fclose(wfp);
	}
	return 0;
}


// -------------------------------------------------------
// get_path_idx(int fcb)
//   FCBt@C̋L^ǂB
// -------------------------------------------------------
int get_path_idx(int fcb)
{
	int i,j;
	char ch;
	int chks = Memory_ReadD(fcb+XFCB_MAGIC);
	int name_len;
	int name_len2;
	int ext_len;
	int sum=0;
	char* pfcb = get_real(fcb);

//vlong file nameΉ
	for( i=0; i<8; i++)
	{
		ch = pfcb[XFCB_FILENAME + i];
		if (ch == 0) break;
		if (ch == ' ') break;
	}
	name_len=i;	//̓t@C̒
	name_len2=0;
	if (Config.LongFileName!=0)
	{
		for( i=0; i<10; i++)
		{
			ch = pfcb[XFCB_FILENAME2 + i];
			if (ch == 0) break;
		if (ch == ' ') break;
		}
		name_len2=i;
	}

	for(i=0; i<3; i++)
	{
		ch=pfcb[XFCB_FILEEXT + i];
		if (ch==0) break;
		if (ch==' ') break;
	}
	ext_len=i;	//͊gq̒

//猟B
	for(i=0; i<MAX_PATH_TBL; i++)
	{
		//hCuԍr
		if (path_tbl[i].drive != pfcb[XFCB_MAGIC + 4]) continue;
//vlong file nameΉ
		//t@Cr
		if (strnicmp((char*)&pfcb[XFCB_FILENAME], path_tbl[i].filename, name_len) != 0) continue;
		if (strnicmp((char*)&pfcb[XFCB_FILEEXT], &path_tbl[i].filename[8], ext_len) != 0) continue;
		if (Config.LongFileName!=0)
		{
			if (strnicmp((char*)&pfcb[XFCB_FILENAME2], path_tbl[i].filenameopt, name_len2) != 0) continue;
		}
		j = 0;
		sum = 0;
		while((ch = path_tbl[i].path_str[j++]) != 0)
			sum = sum * 7 + ch;
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Index Matched. %s - Sum:%08X Chks:%08X\n", path_tbl[i].filename, sum, chks);
fclose(fp);
}
#endif
		if (sum == chks)	//vo
			return i;
	}
	return -1;
}


// -------------------------------------------------------
// file_time(int time_adr,int fcb)
//   t@C̃^CX^v̓ǂݏ
// -------------------------------------------------------
int file_time(int time_adr,int fcb)
{
	int idx, atr;
	char pathfile[MAX_PATH], filename[32];
	WIN32_FIND_DATA lpffd;		// WinԂt@C
	WORD lpwDOSDate,lpwDOSTime;
	FILETIME lpftLocal;
	HANDLE file, fp;
	DWORD ret = 0;

	atr=Memory_ReadD(time_adr);
	idx=get_path_idx(fcb);		// FCBt@C̋L^ǂ
	if (idx<0)
		return -1;		//t@CȂ

	//vlong file nameΉ
	//t@C
	gen_file_FCB(filename, fcb);
	if (strcmp(path_tbl[idx].path_str,"\\")==0)
		sprintf(pathfile,"%c:\\%s",win_letter,filename);
	else
		sprintf(pathfile,"%c:%s\\%s",win_letter,path_tbl[idx].path_str,filename);
	chkdouble(pathfile);

	file=FindFirstFile(pathfile, &lpffd);
	if (file==INVALID_HANDLE_VALUE)
	{
		return -2;
	}

	if (lpffd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)
	{
		FindClose(file);
		return -2;	//fBNgł
	}

	FindClose(file);

	if (atr==0) //t@C擾
	{
		if (!FileTimeToLocalFileTime(&lpffd.ftLastWriteTime, &lpftLocal))
			return -1;
		if (FileTimeToDosDateTime(&lpftLocal, &lpwDOSDate, &lpwDOSTime))
		{
			Memory_WriteW(fcb+XFCB_FILETIME,lpwDOSTime);	// ꉞFCB̓eXVĂ
			Memory_WriteW(fcb+XFCB_FILEDATE,lpwDOSDate);
			ret = (lpwDOSDate<<16)+lpwDOSTime;		// (a5+18)L <- Date/Time? (Kenjo)
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "GetDate/Time - $%04X/$%04X\n", lpwDOSTime, lpwDOSDate);
fclose(fp);
}
#endif
		}
	}
	else	//t@Cɓݒ肷B
	{
//		lpwDOSTime = Memory_ReadW(fcb+XFCB_FILETIME);
//		lpwDOSDate = Memory_ReadW(fcb+XFCB_FILEDATE);
		lpwDOSTime = Memory_ReadW(time_adr+2);		// H (Kenjo)
		lpwDOSDate = Memory_ReadW(time_adr);
		if (! DosDateTimeToFileTime(lpwDOSDate, lpwDOSTime, &lpftLocal))
			return -1;
		if (! LocalFileTimeToFileTime(&lpftLocal, &lpffd.ftLastWriteTime))
			return -1;
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "SetDate/Time - $%04X/$%04X\n", lpwDOSTime, lpwDOSDate);
fclose(fp);
}
#endif
		fp = CreateFile(pathfile, GENERIC_WRITE , FILE_SHARE_READ, 
					NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
		if (fp == INVALID_HANDLE_VALUE)
		{
			return -2;
		}
		if (fp == 0) return  -1;
		if (!SetFileTime(fp, &lpffd.ftLastWriteTime, &lpffd.ftLastWriteTime, &lpffd.ftLastWriteTime))
		{
			CloseHandle(fp);
			return -1;
		}
		CloseHandle(fp);
	}
	return ret;
}


//----------------------------------------------------------
// isopened(int name)
//   wt@CɃI[vĂ邩ǂ𒲂ׂ
//   ret: 0=JĂȂA1=JĂ
//----------------------------------------------------------
int isopened(int name)
{
	int i, ret = 0;
	char lpszSearchFile[MAX_PATH];	/* t@C̖ÕAhX */

	gen_file_name(lpszSearchFile, name);	//namestspath+8.3`֕ϊ
#ifdef WDDEBUG
{
char *pname = get_real(name);
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Open Check - %s\n", lpszSearchFile);
fclose(fp);
}
#endif
	for(i=0; i<MAX_PATH_TBL; i++)
	{
		if (path_tbl[i].plen==0)
			continue;
		if (strcmp(path_tbl[i].winfile, lpszSearchFile)==0)
		{
			ret = 1;
			break;
		}
	}
	return ret;
}



//----------------------------------------------------------
// xcreate(int name, int fcb, int xatr, int mode)
//   t@C쐬ăI[v
//----------------------------------------------------------
int xcreate(int name, int fcb, int xatr, int mode)
{
	unsigned char *ppname = get_real(name);		//t@C
	unsigned char *pfcb = get_real(fcb);
	char lpszSearchFile[MAX_PATH];	/* t@C̖ÕAhX */
	WIN32_FIND_DATA lpffd;	/* Ԃ̃AhX	*/
	HANDLE file;
	int oflag, res;
	WORD lpwDOSDate,lpwDOSTime;
	FILETIME lpftLocal;
	char sname[10+10],sext[4];
	int i, j, min, pos;
	char name_buf[16+10];
	int sum=0;
	char ch;

	if (isopened(name)) return -33;

	gen_file_name(lpszSearchFile, name);	//namestspath+8.3`֕ϊ

	oflag=_O_BINARY|_O_CREAT|_O_TRUNC;
//	if (!mode)
//		oflag|=_O_CREAT;
//	else
//		oflag|=_O_TRUNC;

	if (xatr&1)
		oflag|=_O_RDONLY;
	else
		oflag|=_O_RDWR;
//	string strfile(lpszSearchFile);
	pos=-1;
	for (i=0; lpszSearchFile[i]!=0; i++)
	{
		if (lpszSearchFile[i]=='\\') pos=i;
	}
	if (pos != -1)
		if (!isx68filename(&lpszSearchFile[pos+1]))
			return -1;

#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Create %s / Mode:%d XAtr:%d\n", &lpszSearchFile[pos+1], mode, xatr&1);
fclose(fp);
}
#endif
	res=_open(lpszSearchFile, oflag, _S_IREAD|_S_IWRITE);
	if (res>=0)
		_close(res);

	file=FindFirstFile(lpszSearchFile, &lpffd);

	Memory_WriteD(fcb+6, 0);
	Memory_WriteB(fcb+XFCB_FILEATR, (BYTE)xatr);	//file attr
	Memory_WriteD(fcb+32, 0);

	if (Config.LongFileName!=0)
	{
		if ((lpffd.cAlternateFileName[0]) && (!isx68filename(lpffd.cFileName)))
			spr_name83(lpffd.cAlternateFileName,sname,sext);
		else
			spr_name83(lpffd.cFileName,sname,sext);
	}
	else
	{
		if (lpffd.cAlternateFileName[0])
			spr_name83(lpffd.cAlternateFileName,sname,sext);
		else
			spr_name83(lpffd.cFileName,sname,sext);
	}
	for (i=0; i<8; i++) Memory_WriteB(fcb+XFCB_FILENAME+i, sname[i]);
	for (i=0; i<3; i++) Memory_WriteB(fcb+XFCB_FILEEXT+i, sext[i]);
	for (i=0; i<10; i++) Memory_WriteB(fcb+XFCB_FILENAME2+i, sname[i+8]);

	Memory_WriteD(fcb+XFCB_FILESIZE,lpffd.nFileSizeLow);

	FileTimeToLocalFileTime(&lpffd.ftLastWriteTime, &lpftLocal);
	if (FileTimeToDosDateTime(&lpftLocal, &lpwDOSDate, &lpwDOSTime))
	{
		Memory_WriteW(fcb+XFCB_FILETIME,lpwDOSTime);
		Memory_WriteW(fcb+XFCB_FILEDATE,lpwDOSDate);
	}

	for(i=0; i<MAX_PATH_TBL; i++)
	{
		if (path_tbl[i].plen==0)	//󂫂T
			break;
	}
	if (i>=MAX_PATH_TBL)	//ȂƂ̃Jo
	{
		i=0;
		min=0x7fffffff;
		for(j=0; j<MAX_PATH_TBL; j++)
		{
			if (path_tbl[j].prio<min)
			{
				min=path_tbl[j].prio;
				i=j;
			}
		}
	}

	mer_name83(name_buf, sname, sext);
	path_tbl[i].plen=strlen((char*)&ppname[XS_PATH])+strlen(name_buf);
	path_tbl[i].drive=ppname[1];
	memcpy(path_tbl[i].path_str, &ppname[XS_PATH],64);
	memcpy(path_tbl[i].filename, &ppname[XS_FILENAME],11);
	memcpy(path_tbl[i].filenameopt, &ppname[XS_FILENAME2],10);
	for(j=0; j<64; j++)
	{
		if (path_tbl[i].path_str[j]==9)
			path_tbl[i].path_str[j]='\\';
	}
	path_tbl[i].prio=path_cur_prio++;

	j=0;
	sum = 0;
	while((ch=path_tbl[i].path_str[j++])!=0)
		sum=sum*7+ch;
	path_tbl[i].sum=sum;
	Memory_WriteD(fcb+XFCB_MAGIC, sum);
	Memory_WriteB(fcb+XFCB_MAGIC2, (BYTE)path_tbl[i].drive);

	FindClose(file);
	if (res==-1)
		return -1;
	return 0;
}


//----------------------------------------------------------
// rm_file(int name)
//   t@C폜
//----------------------------------------------------------
int rm_file(int name)
{
	char lpszSearchFile[MAX_PATH];	/* t@C̖ÕAhX */
 	gen_file_name(lpszSearchFile, name);	//namestspath+8.3`֕ϊ
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Remove  %s\n", lpszSearchFile);
fclose(fp);
}
#endif
	return remove(lpszSearchFile);
}

//----------------------------------------------------------
// xopen(int name, int fcb)
//   t@CI[v
//----------------------------------------------------------
int xopen(int name, int fcb)
{
	if (isopened(name)) return -33;
	if ( chk_file(name, fcb)<0 )
	{	//error
		return -2;
	}
	return 0;
}


//----------------------------------------------------------
// re_name(int oldname,int newname)
//   l[
//----------------------------------------------------------
int re_name(int oldname,int newname)
{
	char lpszSearchFileold[MAX_PATH];	// t@C̖ÕAhX
	char lpszSearchFilenew[MAX_PATH];	// t@C̖ÕAhX

	gen_file_name(lpszSearchFileold, oldname);	//namestspath+8.3`֕ϊ
	gen_file_name(lpszSearchFilenew, newname);	//namestspath+8.3`֕ϊ
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Rename  %s -> %s\n", lpszSearchFileold, lpszSearchFilenew);
fclose(fp);
}
#endif
	return MoveFile(lpszSearchFileold, lpszSearchFilenew);
}


//----------------------------------------------------------
// xread(int buff, int size, int fcb)
//   I[ṽt@C̃N[Y
//----------------------------------------------------------
int xclose(int fcb)
{
	int idx = get_path_idx(fcb);	// FCBt@C̋L^ǂB

	if (idx<0) return -1;	//Ȃ̂łȂɂȂ
	path_tbl[idx].plen=0;	//J
	return 0;
}


//----------------------------------------------------------
// xread(int buff, int size, int fcb)
//   I[ṽt@C̃[h
//----------------------------------------------------------
int xread(int buff, int size, int fcb)
{
	char pathfile[MAX_PATH], filename[32], temp;
	FILE *fp;
	int len=0, addlen, i, offset, idx;

#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Read - Size:$%08X\n", size);
fclose(fp);
}
#endif
	if ((size<0) || (size>=0xfffffff))	//-1 is max size
	{
		idx=get_path_idx(fcb);	// FCBt@C̋L^ǂB
		if (idx<0)
			return -1;	//t@CȂB
		//t@CׂāB
		size = Memory_ReadD(fcb+XFCB_FILESIZE);
	}

//	if ( Memory_ReadD(buff) == 0 )
//		return -1;

	idx=get_path_idx(fcb);	// FCBt@C̋L^ǂB
	if (idx<0)
		return -1;	//t@CȂ

//vlong file nameΉ
	//t@C
	gen_file_FCB(filename, fcb);
	if (strcmp(path_tbl[idx].path_str,"\\")==0)
		sprintf(pathfile,"%c:\\%s",win_letter,filename);
	else
		sprintf(pathfile,"%c:%s\\%s",win_letter,path_tbl[idx].path_str,filename);
	chkdouble(pathfile);

	fp=fopen(pathfile,"rb");
	if (fp==NULL) return -1;

	//FCB̃t@C|C^o
	offset=Memory_ReadD(fcb+XFCB_FILEPTR);
	fseek(fp,offset,SEEK_SET);

	//t@Cf[^ǂݏo
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "ReadStart Size:%dbytes Offset:$%08X -> $%08X\n", size, offset, buff);
fclose(fp);
}
#endif
	for (i=0; i<size ; i++)
	{
		addlen = fread(&temp, 1, 1, fp);
		if (addlen)
		{
			len ++;
			Memory_WriteB(buff+i, temp);
		}
		else
			break;
	}
	fclose(fp);

	//FCB̃t@C|C^XV
	offset+=len;
	Memory_WriteD(fcb+XFCB_FILEPTR,offset);
	
	//ǂݏof[^̒ԂB
	return len;
}


//----------------------------------------------------------
// xwrite(int buff, int size, int fcb)
//   I[ṽt@C̃Cg
//----------------------------------------------------------
int chkcount=0;

int xwrite(int buff, int size, int fcb)
{
	int idx, fsize;
	char pathfile[MAX_PATH];
	char filename[32];
	char temp;
	FILE *fp;
	int offset, len=0, i;

//	if ( Memory_ReadD(buff) == 0 )
//		return -1;

	idx = get_path_idx(fcb);	// FCBt@C̋L^ǂB
	if (idx < 0)
		return -1;	//Yt@CȂ

//vlong file nameΉ
//t@CB
	gen_file_FCB(filename, fcb);
	if (strcmp(path_tbl[idx].path_str,"\\")==0)
		sprintf(pathfile, "%c:\\%s",win_letter,filename);
	else
		sprintf(pathfile, "%c:%s\\%s",win_letter,path_tbl[idx].path_str,filename);
	chkdouble(pathfile);

	fp=fopen(pathfile, "r+b");
	if (fp==NULL) return -1;

	offset = Memory_ReadD(fcb+XFCB_FILEPTR);
	fseek(fp, offset, SEEK_SET);

#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "WriteStart Size:%dbytes Offset:$%08X <- $%08X\n", size, offset, buff);
fclose(fp);
}
#endif
	for (i=0; i<size ; i++)
	{
		temp = Memory_ReadB(buff+i);
		len += fwrite(&temp, 1, 1, fp);
	}
	fclose(fp);

	offset += len;
	Memory_WriteD(fcb+XFCB_FILEPTR, offset);
	fsize=Memory_ReadD(fcb+XFCB_FILESIZE);
	if (fsize<offset)
		Memory_WriteD(fcb+XFCB_FILESIZE, offset);
	return len;
}


//----------------------------------------------------------
// xseek(int mode,int offset,int fcb)
//   I[ṽt@C̃V[N
//----------------------------------------------------------
int xseek(int mode,int offset,int fcb)
{
	unsigned char *pfcb = get_real(fcb);
	int idx = get_path_idx(fcb);	// FCBt@C̋L^ǂB
	int cur, max, prev;

	if (idx<0)
		return -1;	//Yt@CȂ

	cur = Memory_ReadD(fcb+XFCB_FILEPTR);
	max = Memory_ReadD(fcb+XFCB_FILESIZE);
	prev=cur;
	switch(mode)
	{
	case 0: //擪
		cur=offset;
		break;
	case 1: //݈ʒu
		cur+=offset;
		break;
	case 2: //납
		cur=max-abs(offset);
		break;
	}

	if (cur<0) return 0xffffffe7;
	else if (cur>max) 
		return 0xffffffe7;
	Memory_WriteD(fcb+XFCB_FILEPTR, cur);
	return cur;
}


//----------------------------------------------------------
// DPBԂij
//----------------------------------------------------------
int get_dpb(int dpb)
{
	return -1;
}


//----------------------------------------------------------
// R}h͂Ċe[`Ă
//----------------------------------------------------------
void WinDrv_Command()
{
	int cmd = regs.d[0]&0xff;		//D0ɋ@\ԍ
	int a5 = regs.a[5];			//A5ɃAhX
	int res,unit,limit;

	gr_files = 0;
	regs.d[0] = 0;
	unit = Memory_ReadB(a5+1);
	if (unit < num_win_drv)
		win_letter = win_drvs[unit];

#ifdef WDDEBUG
if (cmd!=0x57) {
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Command $%02X  A5:$%08X\n", cmd, a5);
fclose(fp);
}
#endif
	switch(cmd)
	{
		//init 
	case 0x40: case 0xc0:
		init_path_tbl();		//e[u
		res = num_win_drv;
		limit = ('Z'+1-'A') - Memory_ReadB( a5+22 ); //hCu^[Z
		if (res > limit)
			res = limit;
		Memory_WriteB( a5+13, (BYTE)res );
		break;

		//fBNg
	case 0x41: case 0xc1:
		res = chk_dir( Memory_ReadD(a5+14) );	//fBNgB
		Memory_WriteD( a5+18, res );	//result status
		break;

		//fBNg쐬
	case 0x42: case 0xc2:
		res = make_dir( Memory_ReadD(a5+14) ); //fBNg쐬ʂԂB
		Memory_WriteD( a5+18, res );	//result status
		break;

		//fBNg폜
	case 0x43: case 0xc3:
		res = rm_dir( Memory_ReadD(a5+14) );	//fBNg폜ʂԂB
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@CύX
	case 0x44: case 0xc4:
		res = re_name( Memory_ReadD(a5+14), Memory_ReadD(a5+18) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@C폜
	case 0x45: case 0xc5:
		res = rm_file( Memory_ReadD(a5+14) );	//result status
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@C
	case 0x46: case 0xc6:
		res = file_atr( a5+13, Memory_ReadD(a5+14) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//FILES
	case 0x47: case 0xc7:
		res = files( Memory_ReadB(a5+13), Memory_ReadD(a5+14), Memory_ReadD(a5+18) );
		//if (res<0)
			Memory_WriteD( a5+18, res );	//result status
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Return from Files - Result:$%08X\n", Memory_ReadD(a5+18));
fclose(fp);
}
#endif
		break;

		//NFILES
	case 0x48: case 0xc8:
		res = nfiles( Memory_ReadD(a5+18) );
		//if (res<0)
			Memory_WriteD( a5+18, res );	//result status
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Return from NFiles - Result:$%08X\n", Memory_ReadD(a5+18));
fclose(fp);
}
#endif
		break;

		//t@C쐬
	case 0x49: case 0xc9:
		res = xcreate( Memory_ReadD(a5+14), Memory_ReadD(a5+22),
			       Memory_ReadB(a5+13), Memory_ReadD(a5+18) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@CI[v
	case 0x4a: case 0xca:
#ifdef WDDEBUG
{
FILE *fp;
fp=fopen("_windrv.txt", "a");
fprintf(fp, "Open mode:$%02X\n", Memory_ReadD(a5+18));
fclose(fp);
}
#endif
		res = xopen( Memory_ReadD(a5+14), Memory_ReadD(a5+22) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@CN[Y
	case 0x4b: case 0xcb:
		res = xclose( Memory_ReadD(a5+22) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@Cǂݍ
	case 0x4c: case 0xcc:
		res = xread( Memory_ReadD(a5+14), Memory_ReadD(a5+18), Memory_ReadD(a5+22) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@C
	case 0x4d: case 0xcd:
		res = xwrite( Memory_ReadD(a5+14), Memory_ReadD(a5+18), Memory_ReadD(a5+22) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@CV[N
	case 0x4e: case 0xce:
		res = xseek( Memory_ReadB(a5+13), Memory_ReadD(a5+18), Memory_ReadD(a5+22) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//t@CXV
	case 0x4f: case 0xcf:
		res = file_time( a5+18, Memory_ReadD(a5+22) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//eʎ擾
	case 0x50: case 0xd0:
		res = get_space( Memory_ReadD(a5+14) );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//hCu
	case 0x51: case 0xd1:
		if (Memory_ReadB(a5+13)==0)
		{
			Memory_WriteB(a5+13, 0x42);	//
		}
		break;

		//DPB擾
	case 0x52: case 0xd2:
		res = get_dpb( Memory_ReadD(a5+14)-2 );
		Memory_WriteD( a5+18, res );	//result status
		break;

		//IOCTRL
	case 0x53: case 0xd3:
		break;

		//IOCTRLo
	case 0x54: case 0xd4:
		break;

		//IOCTRL
	case 0x55: case 0xd5:
		break;

		//A{[g
	case 0x56: case 0xd6:
		Memory_WriteD( a5+18, 0 );	//result status
		break;

		//fBA
	case 0x57: case 0xd7:
		Memory_WriteD( a5+18, 0 );	//result status
		break;

		//r
	case 0x58: case 0xd8:
		Memory_WriteD( a5+18, 0 );	//result status
		break;
	default:
		break;
	}
}


//------------------------------------------------------
// I/Oi$e9f000`$e9ffffj
//------------------------------------------------------
BYTE FASTCALL CDROM_Read(DWORD adr)
{
	return 0 ;
}
void FASTCALL CDROM_Write(DWORD adr, BYTE data)
{
}

BYTE FASTCALL WinDrv_Read(DWORD adr)
{
	if (adr>=0xe9f800)
		return CDROM_Read(adr);		//SCSI IOCS
	if (adr>=0xe9f000) return 'W';		//Windrv mFpID
	BusErrFlag = 1;				// $E9E000`E9EFFF͈̔͂̓RviLVNView2j
	return 0;
}

void FASTCALL WinDrv_Write(DWORD adr, BYTE data)
{
	if (adr>=0xe9f800)
		CDROM_Write(adr, data);
	else if (adr>=0xe9f000)
		WinDrv_Command();
	else
		BusErrFlag = 2;			// $E9E000`E9EFFF͈̔͂̓RviLVNView2j
}

void WinDrv_Init()
{
	char drvstr[128];
	int i,j;
	int reject=0;
	DWORD mask;

	win_drvs[0] = 'E' ;
	win_drvs[1] = 0 ;
	num_win_drv = 1 ;

#if 0
	strcpy(drvstr,"A:\\");
	mask = GetLogicalDrives();	//hCũp^[oB

	j=0;
	//AZ
	for(i=0; i<26; i++)
	{
		if (mask&(1<<i))
		{
			drvstr[0]='A'+i;
			if ((reject<2) &&
				(Config.WinDrvFD!=0) &&
				(GetDriveType(drvstr)==DRIVE_REMOVABLE))
			{
				reject++;	//ŏ̂Q̃[ghCuFDD
				continue;
			}
			reject=2;		//FDĎo͏I
			win_drvs[j++]='A'+i;	//Windows̃hCu^[o^B
		}
	}

	win_drvs[j]=0;
	num_win_drv=j;		//o^hCuݒ肷B
#endif
}


void InitConfig(void)
{

	int i, j ;

	FrameRate=pProperties->frameskip+1 ;
	filepath[0] = 0;

	Config.WinPosX = 0 ;
	Config.WinPosY = 0 ;
	Config.OPM_VOL = pProperties->OPM_VOL ; //12
	Config.PCM_VOL = pProperties->PCM_VOL ; //15 ;
	Config.MCR_VOL = pProperties->MCR_VOL ; //13 ;
	Config.SampleRate = 22050 ;
	Config.BufferSize = 50 ;

	Config.MouseSpeed = pProperties->mouse_sensitivity ;

	
	Config.WindowFDDStat = 1 ; 

	Config.FullScrFDDStat = 1; 

	Config.DSAlert = 1 ;
	Config.Sound_LPF = 1 ;
	Config.SoundROMEO = 0 ;
	Config.MIDI_SW = 1 ;
	Config.MIDI_Reset =  0; 
	Config.MIDI_Type =  1; 

	Config.JoySwap = pProperties->reverse_joy ;

	Config.JoyKey = 0 ;
	Config.JoyKeyReverse = 0 ;
	Config.JoyKeyJoy2 = 0 ;
	Config.SRAMWarning = 1 ;

	Config.LongFileName = 1 ;
	Config.WinDrvFD = 1 ;

	Config.WinStrech = 1 ;

	Config.DSMixing = 0 ;

	Config.XVIMode = pProperties->speed ;

	Config.CDROM_ASPI = 1 ;
	Config.CDROM_SCSIID = 6 ;
	Config.CDROM_ASPI_Drive = 0 ;
	Config.CDROM_IOCTRL_Drive = 16 ;
	Config.CDROM_Enable = 0 ;

	Config.SSTP_Enable = 0 ;
	Config.SSTP_Port = 11000 ;

	Config.ToneMap = 0 ;
	Config.ToneMapFile[0] = 0;

	Config.MIDIDelay = Config.BufferSize*5 ;
	Config.MIDIAutoDelay = 1 ;

	for (i=0; i<2; i++)
	{
		for (j=0; j<8; j++)
		{
			Config.JOY_BTN[i][j] = j ;
		}
	}

	for (i=0; i<16; i++)
	{
		strcpy( Config.HDImage[i], "" ) ;
	}

	memcpy(KeyTable, KeyTableMaster, sizeof(KeyTable));

}
