// ---------------------------------------------------------------------------------------
//  IOC.C - I/O Controller
// ---------------------------------------------------------------------------------------

#include "../win32/common.h"
#include "ioc.h"

	BYTE	IOC_IntStat = 0;
	BYTE	IOC_IntVect = 0;


// -----------------------------------------------------------------------
//   `
// -----------------------------------------------------------------------
void IOC_Init(void)
{
	IOC_IntStat = 0;
	IOC_IntVect = 0;
}


// -----------------------------------------------------------------------
//   [
// -----------------------------------------------------------------------
BYTE FASTCALL IOC_Read(DWORD adr)
{
	if (adr==0xe9c001)
		return IOC_IntStat;
	else
		return 0xff;
}


// -----------------------------------------------------------------------
//   炢
// -----------------------------------------------------------------------
void FASTCALL IOC_Write(DWORD adr, BYTE data)
{
	if (adr==0xe9c001)
	{
		IOC_IntStat &= 0xf0;
		IOC_IntStat |= data&0x0f;
	}
	if (adr==0xe9c003)
		IOC_IntVect = (data&0xfc);
}
