////////////////////////////////////////////////////////////////////////////////
// Memory
////////////////////////////////////////////////////////////////////////////////
// Notes: need to optimize cpu_writemem20
//
//
//
//
//
//////////////////////////////////////////////////////////////////////////////

#include <xtl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <io.h>
#include <fcntl.h>
#include <conio.h>
#include <time.h>
#include "log.h"
#include "rom.h"
#include "./nec/nec.h"
#include "iosw.h"
#include "gpu.h"
#include "audio.h"

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#define IO_ROM_BANK_BASE_SELECTOR	0xC0


uint8	*ws_rom;
uint8	*ws_staticRam;
uint8	*internalRam;
uint8	*externalEeprom;
uint8	*internalEeprom;

uint16	ws_rom_checksum;

uint32	sramAddressMask;
uint32	externalEepromAddressMask;
uint32	romAddressMask;
uint32	sramSize;
uint32	externalEepromSize;
uint32  romSize;
int		ws_sram_dirty = 0 ;

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void cpu_writemem20(DWORD addr,BYTE value)
{
	uint32	offset=addr&0xffff;
	uint32	bank=addr>>16;

	// 0 - RAM - 16 KB (WS) / 64 KB (WSC) internal RAM
	if (!bank)
	{
		ws_gpu_write_byte(offset,value);
		ws_audio_write_byte(offset,value);
	}
	else
	// 1 - SRAM (cart) 
	if (bank==1) {
		ws_staticRam[(offset|(ws_ioRam[IO_ROM_BANK_BASE_SELECTOR+1]<<16))&sramAddressMask]=value;
		ws_sram_dirty = 1 ;
	}

	// other banks are read-only
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
BYTE cpu_readmem20(DWORD addr)
{
	uint32	offset=addr&0xffff;
	uint32	bank=addr>>16;
	
	switch (bank)
	{
	case 0:		// 0 - RAM - 16 KB (WS) / 64 KB (WSC) internal RAM
//				if (ws_gpu_operatingInColor)
					return(internalRam[offset]);
//				else
//				if (offset<0x4000)
//					return(internalRam[offset]);
//				return(0xff);

	case 1:  	// 1 - SRAM (cart) 
				return ws_staticRam[(offset|(ws_ioRam[IO_ROM_BANK_BASE_SELECTOR+1]<<16))&sramAddressMask];
	case 2:
	case 3:		return ws_rom[offset+((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR+bank]&((romSize>>16)-1))<<16)];
	default: 
				int romBank=(256-(((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR]&0xf)<<4)|(bank&0xf)));
				return ws_rom[(unsigned)(offset+romSize-(romBank<<16))];
	}
	return(0xff);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif

void xbox_set_memory_ptr( unsigned char* ptr) ;

#ifdef __cplusplus
}
#endif


void ws_memory_init(uint8 *rom, uint32 wsRomSize)
{
	ws_romHeaderStruct	*ws_romHeader;
	
	ws_rom=rom;
	romSize=wsRomSize;
	ws_romHeader=ws_rom_getHeader(ws_rom,romSize);
	sramSize=ws_rom_sramSize(ws_rom,romSize);
	externalEepromSize=ws_rom_eepromSize(ws_rom,romSize);
	ws_rom_checksum=ws_romHeader->checksum;
	internalRam=(uint8*)malloc(0x10000);
	ws_staticRam=(uint8*)malloc(sramSize); 
	externalEeprom=(uint8*)malloc(externalEepromSize);//ws_rom_eepromSize(ws_rom,romSize));
	internalEeprom=(uint8*)malloc(INTERNAL_EEPRON_SIZE);
	sramAddressMask=sramSize-1;
	externalEepromAddressMask=externalEepromSize-1;
	romAddressMask=romSize-1;

	xbox_set_memory_ptr( internalRam ) ;

//	if (ws_romHeader->minimumSupportSystem==WS_SYSTEM_COLOR)
//		ws_gpu_operatingInColor=1;

}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_reset(void)
{
	memset(internalRam,0,0x10000);
//	memset(ws_staticRam,0,sramSize);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_done(void)
{
	free(ws_rom);
	free(ws_staticRam);
	free(internalRam);
	free(externalEeprom);
	free(internalEeprom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint8	*memory_getRom(void)
{
	return(ws_rom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint32	memory_getRomSize(void)
{
	return(romSize);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint16	memory_getRomCrc(void)
{
	return(ws_rom_checksum);
}

void ws_sram_loadd(char *path)
{
	FILE *f;
	size_t read;

	f = fopen(path, "r");
	if (NULL == f)
	{
		memset(ws_staticRam, 0, sramSize);
		return;
	}

	read = fread(ws_staticRam, 1, sramSize, f);
	fprintf(log_get(), "read 0x%x (of 0x%x?) bytes of save ram from %s\n", read, ws_rom_sramSize(ws_rom, romSize), path);
	fclose(f);
}

void ws_sram_savee(char *path)
{
	FILE *f;
	size_t wrote;

	f = fopen(path, "wb");
	if (NULL == f)
	{
		fprintf(log_get(), "error opening %s for writing save ram. (%s)\n", path, strerror(errno));
		return;
	}

	wrote = fwrite(ws_staticRam, 1, sramSize, f);
	fflush(f);
	fprintf(log_get(), "wrote 0x%x bytes of save ram to %s\n", wrote, path);
	fclose(f);
}

