////////////////////////////////////////////////////////////////////////////////
// Memory
////////////////////////////////////////////////////////////////////////////////
// Notes: need to optimize cpu_writemem20
//
//
//
//
//
//////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <io.h>
#include <fcntl.h>
#if 0
#include <conio.h>
#endif
#include <time.h>
//#include "log.h"
#include "rom.h"
#include "./nec/nec.h"
#include "io.h"
#include "gpu.h"
#include "audio.h"



////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#define IO_ROM_BANK_BASE_SELECTOR	0xC0


#if 0
uint8	*ws_rom;
uint8	*ws_staticRam;
uint8	*internalRam;
uint8	*externalEeprom;
#else
static	uint8	*ws_rom;

uint8	internalRam[0x10000];
uint8	ws_staticRam[0x10000];
uint8	externalEeprom[131072];
#endif

uint16	ws_rom_checksum;

uint32	sramAddressMask;
uint32	externalEepromAddressMask;
uint32	romAddressMask;
#if 0
uint32  romSize;
#else
static uint32 romSize;
#endif


////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void cpu_writemem20(DWORD addr,BYTE value)
{
    // uint32	offset=addr&0xffff;
    uint16 offset = (uint16)addr;
	uint32 bank=addr>>16;

	// 0 - RAM - 16 KB (WS) / 64 KB (WSC) internal RAM
	if (!bank) {
#if 1
        if(internalRam[addr]!=value) {
            internalRam[addr] = value;
            ws_gpu_write_byte(offset,value);
        }
#else
        ws_gpu_write_byte(offset,value);
//        ws_audio_write_byte(offset,value);
#endif
    }
    else {
        // 1 - SRAM (cart) 
        if (bank==1) {
            ws_staticRam[offset&sramAddressMask]=value;
        }
    }
	// other banks are read-only
}


#ifdef MEM_OPTIMIZE

extern BYTE     wsmem[16*1024*1024];

extern uint8    internalRam[0x10000];
extern uint8    ws_staticRam[0x10000];

uint8* pRomMap[16] = {
    internalRam, ws_staticRam,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0 };


// Update ROM Map Table
void cpu_update_map(DWORD port,BYTE value)
{
    int i;

    if(port==0xc2) {
        pRomMap[2] = &wsmem[ ((value&((romSize>>16)-1))<<16) ];
    }
    else if(port==0xc3) {
        pRomMap[3] = &wsmem[ ((value&((romSize>>16)-1))<<16) ];
    }
    else if(port==0xc0) {
        int romBank,bank;

        for(bank=4;bank<16;bank++) {
            romBank=(256-(((value&0xf)<<4)|(bank&0xf)));
            pRomMap[bank] = &wsmem[(unsigned)(romSize-(romBank<<16))];
        }
    }
}

//BYTE cpu_readmem20(DWORD addr)
//{
//    return * (pRomMap[(addr>>16)] + (unsigned short)addr);
//}

#else // MEM_OPTIMIZE

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
BYTE cpu_readmem20(DWORD addr)
{
	uint32	offset=addr&0xffff;
	uint32	bank=addr>>16;
#ifndef __cplusplus
	int romBank;
#endif
	
	switch (bank)
	{
	case 0:		// 0 - RAM - 16 KB (WS) / 64 KB (WSC) internal RAM
				if (ws_gpu_operatingInColor)
					return(internalRam[offset]);
				else
				if (offset<0x4000)
					return(internalRam[offset]);
				return(0xff);

	case 1:  	// 1 - SRAM (cart) 
				return ws_staticRam[offset&sramAddressMask];
	case 2:
	case 3:		return ws_rom[offset+((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR+bank]&((romSize>>16)-1))<<16)];
	default: 
#ifdef __cplusplus
				int romBank=(256-(((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR]&0xf)<<4)|(bank&0xf)));
#else
				romBank=(256-(((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR]&0xf)<<4)|(bank&0xf)));
#endif
				return ws_rom[(unsigned)(offset+romSize-(romBank<<16))];
	}
	return(0xff);
}
#endif//MEM_OPTIMIZE


////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_init(uint8 *rom, uint32 wsRomSize)
{
    ws_romHeaderStruct	*ws_romHeader;

#ifdef MEM_OPTIMIZE
    memset(pRomMap,0,sizeof(pRomMap));
    pRomMap[0] = internalRam;
    pRomMap[1] = ws_staticRam;
#endif//MEM_OPTIMIZE
    
	ws_rom=rom;
	romSize=wsRomSize;
	ws_romHeader=ws_rom_getHeader(ws_rom,romSize);
	ws_rom_checksum=ws_romHeader->checksum;
#if 0
	internalRam=(uint8*)malloc(0x10000);
	ws_staticRam=(uint8*)malloc(0x10000);
	externalEeprom=(uint8*)malloc(131072);//ws_rom_eepromSize(ws_rom,romSize));
#endif
	sramAddressMask=ws_rom_sramSize(ws_rom,romSize)-1;
	externalEepromAddressMask=ws_rom_eepromSize(ws_rom,romSize)-1;
	romAddressMask=romSize-1;

	if (ws_romHeader->minimumSupportSystem==WS_SYSTEM_COLOR)
		ws_gpu_operatingInColor=1;

}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_reset(void)
{
	memset(internalRam,0,0x10000);
	memset(ws_staticRam,0,0x10000);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_done(void)
{
#if 0
	free(ws_rom);
	free(ws_staticRam);
	free(internalRam);
	free(externalEeprom);
#endif
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint8	*memory_getRom(void)
{
	return(ws_rom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint32	memory_getRomSize(void)
{
	return(romSize);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
uint16	memory_getRomCrc(void)
{
	return(ws_rom_checksum);
}

