 /*
  * UAE - The Un*x Amiga Emulator
  *
  * WIN32 CDROM/HD low level access code (IOCTL)
  *
  * Copyright 2002 Toni Wilen
  *
  */

#include "sysconfig.h"
#include "sysdeps.h"

//#ifdef WINDDK

#include "config.h"
#include "uae.h"
#include "threaddep/thread.h"
#include "blkdev.h"
#include "scsidev.h"
#include "gui.h"

//#include <devioctl.h>
//#include <ntddcdrm.h>
//#include "undocumented.h"

#include "scsidefs.h"

struct dev_info_ioctl_iso {
    HANDLE h;
    uae_u8 *tempbuffer;
    char drvletter;
    char devname[30];
    int mediainserted;
    int type;
};

char g_cdfilename[MAX_PATH] ;
FILE *g_cdfile ;
unsigned char g_cdbuffer[2048*4] ;

static UINT errormode;

static void seterrormode (void)
{
    //errormode = SetErrorMode( SEM_FAILCRITICALERRORS | SEM_NOOPENFILEERRORBOX );
}
static void reseterrormode (void)
{
    //SetErrorMode (errormode);
}

#define MAXIMUM_NUMBER_TRACKS 100
#define MAXIMUM_CDROM_SIZE 804

typedef struct _TRACK_DATA {
    UCHAR               Reserved;
    UCHAR               Control : 4;
    UCHAR               Adr : 4;
    UCHAR               TrackNumber;
    UCHAR               Reserved1;
    UCHAR               Address[4];
} TRACK_DATA, *PTRACK_DATA;

typedef struct _CDROM_TOC {
    UCHAR               Length[2];
    UCHAR               FirstTrack;
    UCHAR               LastTrack;
    TRACK_DATA TrackData[MAXIMUM_NUMBER_TRACKS];
} CDROM_TOC, *PCDROM_TOC;

CDROM_TOC g_recentTOC;

static struct dev_info_ioctl_iso ciw32[MAX_TOTAL_DEVICES + 64 + 32];

static void close_device (int unitnum);
static int open_device (int unitnum);

static int win32_error (int unitnum, const char *format,...)
{
    LPVOID lpMsgBuf;
    va_list arglist;
    char buf[1000];
    DWORD err = GetLastError();

    if (err == 34) {
	write_log ("IOCTL: media change, re-opening device\n");
	close_device (unitnum);
	if (!open_device (unitnum))
	    write_log ("IOCTL: re-opening failed!\n");
	return -1;
    }
    va_start (arglist, format );
    vsprintf (buf, format, arglist);
    //FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM|FORMAT_MESSAGE_IGNORE_INSERTS,
	//NULL,err,MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
	//(LPTSTR) &lpMsgBuf,0,NULL);
    if (log_scsi)
	write_log ("IOCTL: unit=%d %s,%d: %s ", unitnum, buf, err, (char*)lpMsgBuf);
    va_end( arglist );
    return err;
}


/* pause/unpause CD audio */
static int ioctl_command_pause (int unitnum, int paused)
{
#if 0
    DWORD len;
    int command = paused ? IOCTL_CDROM_PAUSE_AUDIO : IOCTL_CDROM_RESUME_AUDIO;
    int cnt = 3;

    while (cnt-- > 0) {
        seterrormode ();
	if (!DeviceIoControl(ciw32[unitnum].h, command, NULL, 0, NULL, 0, &len, NULL)) {
	    reseterrormode ();
	    if (win32_error (unitnum, paused ? "IOCTL_CDROM_PAUSE_AUDIO" : "IOCTL_CDROM_RESUME_AUDIO") < 0)
		continue;
	    return 0;
	}
        reseterrormode ();
	break;
    }
#endif
    return 1;
}

/* stop CD audio */
static int ioctl_command_stop (int unitnum)
{
#if 0
    DWORD len;
    int cnt = 3;

    while (cnt-- > 0) {
        seterrormode ();
	if(!DeviceIoControl(ciw32[unitnum].h, IOCTL_CDROM_STOP_AUDIO, NULL, 0, NULL, 0, &len, NULL)) {
	    reseterrormode ();
	    if (win32_error (unitnum, "IOCTL_CDROM_STOP_AUDIO") < 0)
		continue;
	    return 0;
	}
	reseterrormode ();
	break;
    }
#endif
    return 1;
}

typedef struct _CDROM_PLAY_AUDIO_MSF {
  UCHAR  StartingM;
  UCHAR  StartingS;
  UCHAR  StartingF;
  UCHAR  EndingM;
  UCHAR  EndingS;
  UCHAR  EndingF;
} CDROM_PLAY_AUDIO_MSF, *PCDROM_PLAY_AUDIO_MSF;

/* play CD audio */
static int ioctl_command_play (int unitnum, uae_u32 start, uae_u32 end, int scan)
{
#if 0
    DWORD len;
    CDROM_PLAY_AUDIO_MSF pa;
    int cnt = 3;

    while (cnt-- > 0) {
	pa.StartingM = start >> 16;
	pa.StartingS = start >> 8;
	pa.StartingF = start >> 0;
	pa.EndingM = end >> 16;
	pa.EndingS = end >> 8;
	pa.EndingF = end >> 0;
	seterrormode ();
	if (!DeviceIoControl(ciw32[unitnum].h, IOCTL_CDROM_PLAY_AUDIO_MSF, &pa, sizeof(pa), NULL, 0, &len, NULL)) {
	    reseterrormode ();
	    if (win32_error (unitnum, "IOCTL_CDROM_PLAY_AUDIO_MSF %02.%02.%02-%02.%02.%02",
		pa.StartingM, pa.StartingS, pa.StartingF, pa.EndingM, pa.EndingS, pa.EndingF ) < 0) continue;
	    return 0;
	}
	reseterrormode ();
	break;
    }
#endif
    return 1;
}

/* read qcode */
static uae_u8 *ioctl_command_qcode (int unitnum)
{
#if 0
    SUB_Q_CHANNEL_DATA qcd;
    DWORD len;
    ULONG in = 1;
    uae_u8 *p = ciw32[unitnum].tempbuffer;
    int cnt = 3;

    memset (p, 0, 4 + 12);
    p[1] = 0x15;
    p[3] = 12;
    while (cnt-- > 0) {
	reseterrormode ();
	if(!DeviceIoControl(ciw32[unitnum].h, IOCTL_CDROM_READ_Q_CHANNEL, &in, sizeof(in), &qcd, sizeof (qcd), &len, NULL)) {
	    reseterrormode ();
	    if (win32_error (unitnum, "IOCTL_CDROM_READ_Q_CHANNEL") < 0)
		continue;
	    return 0;
	}
	break;
    }
    reseterrormode ();
    p[1] = qcd.CurrentPosition.Header.AudioStatus;
    p += 4;
    p[1] = (qcd.CurrentPosition.Control << 0) | (qcd.CurrentPosition.ADR << 4);
    p[2] = qcd.CurrentPosition.TrackNumber;
    p[3] = qcd.CurrentPosition.IndexNumber;
    p[5] = qcd.CurrentPosition.AbsoluteAddress[1];
    p[6] = qcd.CurrentPosition.AbsoluteAddress[2];
    p[7] = qcd.CurrentPosition.AbsoluteAddress[3];
    p[9] = qcd.CurrentPosition.TrackRelativeAddress[1];
    p[10] = qcd.CurrentPosition.TrackRelativeAddress[2];
    p[11] = qcd.CurrentPosition.TrackRelativeAddress[3];
    return ciw32[unitnum].tempbuffer;
#endif
	return 0 ;
}

static uae_u8 *ioctl_command_read (int unitnum, int sector)
{
	fseek( g_cdfile, 2048*sector, SEEK_SET ) ;
	fread( g_cdbuffer, 2048, 1, g_cdfile ) ;
	return g_cdbuffer ;

#if 0
    DWORD dtotal;
    int cnt = 3;

    while (cnt-- > 0) {
	gui_cd_led (1);
	seterrormode ();
	if (SetFilePointer (ciw32[unitnum].h, sector  * 2048, 0, FILE_BEGIN) == INVALID_SET_FILE_POINTER) {
	    reseterrormode ();
	    if (win32_error (unitnum, "SetFilePointer") < 0)
		continue;
	    return 0;
	}
        reseterrormode ();
	break;
    }
    cnt = 3;
    while (cnt-- > 0) {
	gui_cd_led (1);
	if (!ReadFile (ciw32[unitnum].h, ciw32[unitnum].tempbuffer, 2048, &dtotal, 0)) {
	    reseterrormode ();
	    if (win32_error (unitnum, "ReadFile") < 0)
		continue;
	    return 0;
	}
	reseterrormode ();
	gui_cd_led (1);
	break;
    }
    return ciw32[unitnum].tempbuffer;
#endif
}

static int ioctl_command_write (int unitnum, int sector, uae_u8 *data)
{
    return 0;
}
typedef enum _MEDIA_TYPE {
	Unknown,
	F5_1Pt2_512,
	F3_1Pt44_512,
	F3_2Pt88_512,
	F3_20Pt8_512,
	F3_720_512,
	F5_360_512,
	F5_320_512,
	F5_320_1024,
	F5_180_512,
	F5_160_512,
	RemovableMedia,
	FixedMedia
} MEDIA_TYPE;
typedef struct _DISK_GEOMETRY {
	LARGE_INTEGER Cylinders;
	MEDIA_TYPE MediaType;
	DWORD TracksPerCylinder;
	DWORD SectorsPerTrack;
	DWORD BytesPerSector;
} DISK_GEOMETRY;

static int fetch_geometry (int unitnum, struct device_info *di)
{
#if 0
    DISK_GEOMETRY geom;
    DWORD len;
    int cnt = 3;

    while (cnt-- > 0) {
        seterrormode ();
	if (!DeviceIoControl(ciw32[unitnum].h, IOCTL_CDROM_GET_DRIVE_GEOMETRY, NULL, 0, &geom, sizeof(geom), &len, NULL)) {
	    reseterrormode ();
	    if (win32_error (unitnum, "IOCTL_CDROM_GET_DRIVE_GEOMETRY") < 0)
		continue;
	    return 0;
	}
        reseterrormode ();
	break;
    }
    if (di) {
        di->cylinders = geom.Cylinders.LowPart;
	di->sectorspertrack = geom.SectorsPerTrack;
	di->trackspercylinder = geom.TracksPerCylinder;
	di->bytespersector = geom.BytesPerSector;
    }
#endif
    if (di) {
        di->cylinders = 332800 ;
	di->sectorspertrack = 1 ; 
	di->trackspercylinder = 1 ; 
	di->bytespersector = 2048 ; 
    }
    return 1;
}

#define SECTORS_PER_SECOND (75)
#define SECTORS_PER_MINUTE (75*60)
#define SECTORS_PER_HOUR   (75*60*60)

/* read toc */
static uae_u8 *ioctl_command_toc (int unitnum)
{
	int numsectors ;
    int i;
    uae_u8 *p = g_cdbuffer ;

	fseek( g_cdfile, 0, SEEK_END ) ;
	numsectors = ftell( g_cdfile ) / 2048 ;

	g_recentTOC.FirstTrack = 1 ;
	g_recentTOC.LastTrack = 1 ;
	g_recentTOC.TrackData[0].Reserved = 0 ;
	g_recentTOC.TrackData[0].Reserved1 = 0 ;
	g_recentTOC.TrackData[0].Control = 4 ;
	g_recentTOC.TrackData[0].Adr = 1 ;
	g_recentTOC.TrackData[0].TrackNumber = 1 ;
	g_recentTOC.TrackData[0].Address[0] = 0 ;
	g_recentTOC.TrackData[0].Address[1] = 0 ;
	g_recentTOC.TrackData[0].Address[2] = 2 ;
	g_recentTOC.TrackData[0].Address[3] = 0 ;

	g_recentTOC.TrackData[1].Reserved = 0 ;
	g_recentTOC.TrackData[1].Reserved1 = 0 ;
	g_recentTOC.TrackData[1].Control = 0 ;
	g_recentTOC.TrackData[1].Adr = 1 ;
	g_recentTOC.TrackData[1].TrackNumber = 170 ;
	g_recentTOC.TrackData[1].Address[0] = numsectors / SECTORS_PER_HOUR ;

	numsectors = ( numsectors % SECTORS_PER_HOUR ) ;

	g_recentTOC.TrackData[1].Address[1] = numsectors / SECTORS_PER_MINUTE  ;

	numsectors = ( numsectors % SECTORS_PER_MINUTE ) ;

	g_recentTOC.TrackData[1].Address[2] = numsectors / SECTORS_PER_SECOND  ;

	numsectors = ( numsectors % SECTORS_PER_SECOND ) ;

	g_recentTOC.TrackData[1].Address[3] = numsectors ;




#if 0
    DWORD len;
    int i;
    uae_u8 *p = ciw32[unitnum].tempbuffer;
    int cnt = 3;

    gui_cd_led (1);
    while (cnt-- > 0) {
        seterrormode ();
	if (!DeviceIoControl(ciw32[unitnum].h, IOCTL_CDROM_READ_TOC, NULL, 0, &toc, sizeof(toc), &len, NULL)) {
	    reseterrormode ();
	    if (!win32_error (unitnum, "IOCTL_CDROM_READ_TOC"))
		continue;
	    return 0;
	}
        reseterrormode ();
	break;
    }
#endif

    p[0] = ((g_recentTOC.LastTrack + 4) * 11) >> 8;
    p[1] = ((g_recentTOC.LastTrack + 4) * 11) & 0xff;
    p[2] = 1;
    p[3] = g_recentTOC.LastTrack;
    p += 4;
    memset (p, 0, 11);
    p[0] = 1;
    p[1] = (g_recentTOC.TrackData[0].Control << 0) | (g_recentTOC.TrackData[0].Adr << 4);
    p[3] = 0xa0;
    p[8] = 1;
    p += 11;
    memset (p, 0, 11);
    p[0] = 1;
    p[1] = 0x10;
    p[3] = 0xa1;
    p[8] = g_recentTOC.LastTrack;
    p += 11;
    memset (p, 0, 11);
    p[0] = 1;
    p[1] = 0x10;
    p[3] = 0xa2;
    p[8] = g_recentTOC.TrackData[g_recentTOC.LastTrack].Address[1];
    p[9] = g_recentTOC.TrackData[g_recentTOC.LastTrack].Address[2];
    p[10] = g_recentTOC.TrackData[g_recentTOC.LastTrack].Address[3];
    p += 11;
    for (i = 0; i < g_recentTOC.LastTrack; i++) {
	memset (p, 0, 11);
	p[0] = 1;
	p[1] = (g_recentTOC.TrackData[i].Control << 0) | (g_recentTOC.TrackData[i].Adr << 4);
	p[2] = 0;
	p[3] = i + 1;
	p[8] = g_recentTOC.TrackData[i].Address[1];
	p[9] = g_recentTOC.TrackData[i].Address[2];
	p[10] = g_recentTOC.TrackData[i].Address[3];
	p += 11;
    }
    gui_cd_led (1);
    return g_cdbuffer;
}

/* open device level access to cd rom drive */
static int sys_cddev_open_iso (int unitnum)
{
#if 0
    DWORD len;
    struct dev_info_ioctl_iso *ciw = &ciw32[unitnum];
    DWORD flags;

    /* buffer must be page aligned for device access */
    ciw->tempbuffer = VirtualAlloc (NULL, 4096, MEM_COMMIT, PAGE_READWRITE);
    if (!ciw->tempbuffer) {
	write_log ("IOCTL: failed to allocate buffer");
	return 1;
    }
    flags = GENERIC_READ;
    ciw->h = CreateFile(ciw->devname, flags, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if (ciw->h == INVALID_HANDLE_VALUE) {
	flags |= GENERIC_WRITE;
        ciw->h = CreateFile(ciw->devname, flags, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
        if (ciw->h == INVALID_HANDLE_VALUE) {
	    write_log ("IOCTL: failed to open device handle (%s)\n", ciw->devname);
	    goto error;
	}
    }
    DeviceIoControl(ciw->h, IOCTL_STORAGE_CHECK_VERIFY, NULL, 0, NULL, 0, &len, NULL);
    ciw->mediainserted = ioctl_command_toc (unitnum) ? 1 : 0;
    write_log ("IOCTL: device '%s' opened succesfully (unit number=%d,media=%d)\n", ciw->devname, unitnum, ciw->mediainserted);
    ioctl_command_stop (unitnum);
    return 0;
error:
    win32_error (unitnum, "CreateFile");
    VirtualFree (ciw->tempbuffer, 0, MEM_RELEASE);
    ciw->tempbuffer = NULL;
    CloseHandle (ciw->h);
    ciw->h = NULL;
    return -1;
#endif
	return 0 ;

}

static int unitcheck (int unitnum)
{
#if 0
    if (unitnum >= MAX_TOTAL_DEVICES) {
	if (unitnum < 'A' || unitnum > 'Z')
	    return 0;
	return 1;
    }
    if (ciw32[unitnum].drvletter == 0)
	return 0;
#endif
    return 1;
}

/* close device handle */
void sys_cddev_close_iso (int unitnum)
{
#if 0
    if (!unitcheck (unitnum))
	return;
    CloseHandle (ciw32[unitnum].h);
    ciw32[unitnum].h = NULL;
    VirtualFree (ciw32[unitnum].tempbuffer, 0, MEM_RELEASE);
    ciw32[unitnum].tempbuffer = NULL;
#endif
}

static int open_device (int unitnum)
{
#if 0
    if (!unitcheck (unitnum))
	return 0;
    if (sys_cddev_open_iso (unitnum) == 0)
	return 1;
    return 0;
#endif

	if ( unitnum > 0 )
		return 0 ;

	if ( g_cdfile )
		fclose( g_cdfile ) ;

	g_cdfile = fopen( g_cdfilename, "rb" ) ;

    ioctl_command_toc (unitnum) ;
    ioctl_command_stop (unitnum);

	return ( g_cdfile != 0 )  ;
}
static void close_device (int unitnum)
{
	if ( g_cdfile )
		fclose( g_cdfile ) ;

	g_cdfile = 0 ;
    //sys_cddev_close_iso (unitnum);
}

static void close_bus (void)
{
}

static int total_devices;

#define DRIVE_FIXED 3
#define DRIVE_REMOTE 4
#define DRIVE_CDROM 5

extern int did_critical ;
extern CRITICAL_SECTION g_cdreadCriticalSection; 

static int open_bus (int flags)
{
	if ( did_critical == 0 )
	{
		InitializeCriticalSection( &g_cdreadCriticalSection ) ;
		did_critical = 1 ;
	}

#if 0
    int dwDriveMask;
    int drive, i;
    char tmp[10];

    for (i = 0; i < MAX_TOTAL_DEVICES; i++)
		memset (&ciw32[i], 0, sizeof (struct dev_info_ioctl_iso));

    total_devices = 0;
    //dwDriveMask = GetLogicalDrives();
    //if (log_scsi)
	//write_log ("IOCTL: drive mask = %08.8X\n", dwDriveMask);
    //dwDriveMask >>= 2; // Skip A and B drives...
#if 0
    for( drive = 'C'; drive <= 'Z'; drive++) {
	if (dwDriveMask & 1) {
	    int dt;
	    sprintf( tmp, "%c:\\", drive );
	    dt = GetDriveType (tmp);
	    if (log_scsi)
		write_log ("IOCTL: drive %c type %d\n", drive, dt);
	    if (((flags & (1 << INQ_ROMD)) && dt == DRIVE_CDROM) || ((flags & (1 << INQ_DASD)) && dt == DRIVE_FIXED)) {
	        if (log_scsi)
		    write_log ("IOCTL: drive %c: = unit %d\n", drive, total_devices);
		ciw32[total_devices].drvletter = drive;
		ciw32[total_devices].type = dt;
		sprintf (ciw32[total_devices].devname,"\\\\.\\%c:", drive);
		total_devices++;
	    }
	}
	dwDriveMask >>= 1;
    }
#endif

	ciw32[total_devices].drvletter = 'R';
	ciw32[total_devices].type = DRIVE_CDROM;
	sprintf (ciw32[total_devices].devname,"\\\\.\\%c:", 'R');
	//strcpy (ciw32[total_devices].devname,"\\Device\\Cdrom0" ) ;

	total_devices++;

    return total_devices;
#endif
	return 1 ;
}

static struct device_info *info_device (int unitnum, struct device_info *di)
{
    //if (!unitcheck (unitnum))
	if ( unitnum > 0 )
	return 0;
    di->bus = unitnum;
    di->target = 0;
    di->lun = 0;
    di->media_inserted = 0;
    if (fetch_geometry (unitnum, di)) // || ioctl_command_toc (unitnum))
	di->media_inserted = 1;
    di->write_protected = 1;
    di->type = INQ_ROMD ;
    di->id = 'R' ;
    sprintf (di->label, "Drive %c:", 'R');
    return di;

	//return 0 ;
}

#if 0
void win32_ioctl_media_change (char driveletter, int insert)
{
    int i;

    for (i = 0; i < MAX_TOTAL_DEVICES; i++) {
	if (ciw32[i].drvletter == driveletter && ciw32[i].mediainserted != insert) {
	    write_log ("IOCTL: media change %c %d\n", driveletter, insert);
	    ciw32[i].mediainserted = insert;
	    scsi_do_disk_change (driveletter, insert);
	}
    }
}
#endif

struct device_functions devicefunc_win32_ioctl_iso = {
    open_bus, close_bus, open_device, close_device, info_device,
    0, 0, 0,
    ioctl_command_pause, ioctl_command_stop, ioctl_command_play, ioctl_command_qcode,
    ioctl_command_toc, ioctl_command_read, ioctl_command_write
};

//#endif
