/*
 * UAE - The Un*x Amiga Emulator
 *
 * Additional Win32 helper functions not calling any system routines
 *
 * (c) 1997 Mathias Ortmann
 * (c) 1999-2001 Brian King
 * (c) 2000-2001 Bernd Roesch
 * (c) 2002 Toni Wilen
 */

#include "config.h"
#include "sysconfig.h"

#include <assert.h>
#include <ctype.h>
#include <signal.h>
#include <xtl.h>
//#include <dinput.h>

#include "sysdeps.h"
#include "uae.h"
#include "gui.h"
#include "options.h"
#include "memory.h"
#include "custom.h"
#include "events.h"
#include "newcpu.h"
#include "keyboard.h"
#include "inputdevice.h"
#include "xwin.h"
#include "drawing.h"
#include "disk.h"
#include "keybuf.h"
#include "win32.h"
#include "debug.h"
#include "ar.h"
#include "ahidsound.h"
#include "savestate.h"
#include "sound.h"
#include "keyboard_api.h"

extern void screenshot(int);

//#define DBG_KEYBD 1
//#define DEBUG_KBD

#define VK_0 '0'
#define VK_1 '1'
#define VK_2 '2'
#define VK_3 '3'
#define VK_4 '4'
#define VK_5 '5'
#define VK_6 '6'
#define VK_7 '7'
#define VK_8 '8'
#define VK_9 '9'

#define VK_A 'A'
#define VK_B 'B'
#define VK_C 'C'
#define VK_D 'D'
#define VK_E 'E'
#define VK_F 'F'
#define VK_G 'G'
#define VK_H 'H'
#define VK_I 'I'
#define VK_J 'J'
#define VK_K 'K'
#define VK_L 'L'
#define VK_M 'M'
#define VK_N 'N'
#define VK_O 'O'
#define VK_P 'P'
#define VK_Q 'Q'
#define VK_R 'R'
#define VK_S 'S'
#define VK_T 'T'
#define VK_U 'U'
#define VK_V 'V'
#define VK_W 'W'
#define VK_X 'X'
#define VK_Y 'Y'
#define VK_Z 'Z'

static struct uae_input_device_kbr_default keytrans[] = {
    { VK_ESCAPE, INPUTEVENT_KEY_ESC },
//#if 0
    
    { VK_F1, INPUTEVENT_KEY_F1 },
    { VK_F2, INPUTEVENT_KEY_F2 },
    { VK_F3, INPUTEVENT_KEY_F3 },
    { VK_F4, INPUTEVENT_KEY_F4 },
    { VK_F5, INPUTEVENT_KEY_F5 },
    { VK_F6, INPUTEVENT_KEY_F6 },
    { VK_F7, INPUTEVENT_KEY_F7 },
    { VK_F8, INPUTEVENT_KEY_F8 },
    { VK_F9, INPUTEVENT_KEY_F9 },
    { VK_F10, INPUTEVENT_KEY_F10 },

    { VK_1, INPUTEVENT_KEY_1 },
    { VK_2, INPUTEVENT_KEY_2 },
    { VK_3, INPUTEVENT_KEY_3 },
    { VK_4, INPUTEVENT_KEY_4 },
    { VK_5, INPUTEVENT_KEY_5 },
    { VK_6, INPUTEVENT_KEY_6 },
    { VK_7, INPUTEVENT_KEY_7 },
    { VK_8, INPUTEVENT_KEY_8 },
    { VK_9, INPUTEVENT_KEY_9 },
    { VK_0, INPUTEVENT_KEY_0 },

    { VK_TAB, INPUTEVENT_KEY_TAB },

    { VK_A, INPUTEVENT_KEY_A },
    { VK_B, INPUTEVENT_KEY_B },
    { VK_C, INPUTEVENT_KEY_C },
    { VK_D, INPUTEVENT_KEY_D },
    { VK_E, INPUTEVENT_KEY_E },
    { VK_F, INPUTEVENT_KEY_F },
    { VK_G, INPUTEVENT_KEY_G },
    { VK_H, INPUTEVENT_KEY_H },
    { VK_I, INPUTEVENT_KEY_I },
    { VK_J, INPUTEVENT_KEY_J },
    { VK_K, INPUTEVENT_KEY_K },
    { VK_L, INPUTEVENT_KEY_L },
    { VK_M, INPUTEVENT_KEY_M },
    { VK_N, INPUTEVENT_KEY_N },
    { VK_O, INPUTEVENT_KEY_O },
    { VK_P, INPUTEVENT_KEY_P },
    { VK_Q, INPUTEVENT_KEY_Q },
    { VK_R, INPUTEVENT_KEY_R },
    { VK_S, INPUTEVENT_KEY_S },
    { VK_T, INPUTEVENT_KEY_T },
    { VK_U, INPUTEVENT_KEY_U },
    { VK_W, INPUTEVENT_KEY_W },
    { VK_V, INPUTEVENT_KEY_V },
    { VK_X, INPUTEVENT_KEY_X },
    { VK_Y, INPUTEVENT_KEY_Y },
    { VK_Z, INPUTEVENT_KEY_Z },

    { VK_CAPITAL, INPUTEVENT_KEY_CAPS_LOCK },

    { VK_NUMPAD1, INPUTEVENT_KEY_NP_1 },
    { VK_NUMPAD2, INPUTEVENT_KEY_NP_2 },
    { VK_NUMPAD3, INPUTEVENT_KEY_NP_3 },
    { VK_NUMPAD4, INPUTEVENT_KEY_NP_4 },
    { VK_NUMPAD5, INPUTEVENT_KEY_NP_5 },
    { VK_NUMPAD6, INPUTEVENT_KEY_NP_6 },
    { VK_NUMPAD7, INPUTEVENT_KEY_NP_7 },
    { VK_NUMPAD8, INPUTEVENT_KEY_NP_8 },
    { VK_NUMPAD9, INPUTEVENT_KEY_NP_9 },
    { VK_NUMPAD0, INPUTEVENT_KEY_NP_0 },
    { VK_DECIMAL, INPUTEVENT_KEY_NP_PERIOD },
    { VK_ADD, INPUTEVENT_KEY_NP_ADD },
    { VK_SUBTRACT, INPUTEVENT_KEY_NP_SUB },
    { VK_MULTIPLY, INPUTEVENT_KEY_NP_MUL },
    { VK_DIVIDE, INPUTEVENT_KEY_NP_DIV },
    { VK_SEPARATOR, INPUTEVENT_KEY_ENTER },

    { VK_OEM_MINUS, INPUTEVENT_KEY_SUB },
    { VK_OEM_PLUS, INPUTEVENT_KEY_EQUALS },
    { VK_BACK, INPUTEVENT_KEY_BACKSPACE },
    { VK_RETURN, INPUTEVENT_KEY_RETURN },
    { VK_SPACE, INPUTEVENT_KEY_SPACE },

    { VK_LSHIFT, INPUTEVENT_KEY_SHIFT_LEFT },
    { VK_LCONTROL, INPUTEVENT_KEY_CTRL },
    { VK_LWIN, INPUTEVENT_KEY_AMIGA_LEFT },
    { VK_LMENU, INPUTEVENT_KEY_ALT_LEFT },
    { VK_RMENU, INPUTEVENT_KEY_ALT_RIGHT },
    { VK_RWIN, INPUTEVENT_KEY_AMIGA_RIGHT },
    { VK_APPS, INPUTEVENT_KEY_AMIGA_RIGHT },
    { VK_RCONTROL, INPUTEVENT_KEY_CTRL_RIGHT },
    { VK_RSHIFT, INPUTEVENT_KEY_SHIFT_RIGHT },

    { VK_UP, INPUTEVENT_KEY_CURSOR_UP },
    { VK_DOWN, INPUTEVENT_KEY_CURSOR_DOWN },
    { VK_LEFT, INPUTEVENT_KEY_CURSOR_LEFT },
    { VK_RIGHT, INPUTEVENT_KEY_CURSOR_RIGHT },

    { VK_INSERT, INPUTEVENT_KEY_AMIGA_LEFT },
    { VK_DELETE, INPUTEVENT_KEY_DEL },
    { VK_HOME, INPUTEVENT_KEY_AMIGA_RIGHT },
    { VK_NEXT, INPUTEVENT_KEY_HELP },

    { VK_OEM_4, INPUTEVENT_KEY_LEFTBRACKET },
    { VK_OEM_7, INPUTEVENT_KEY_RIGHTBRACKET },
    { VK_OEM_1, INPUTEVENT_KEY_SEMICOLON },
    { VK_OEM_7, INPUTEVENT_KEY_SINGLEQUOTE },
    { VK_OEM_3, INPUTEVENT_KEY_BACKQUOTE },
    { VK_OEM_5, INPUTEVENT_KEY_BACKSLASH },
    { VK_OEM_COMMA, INPUTEVENT_KEY_COMMA },
    { VK_OEM_PERIOD, INPUTEVENT_KEY_PERIOD },
    { VK_OEM_2, INPUTEVENT_KEY_DIV },
    { VK_OEM_102, INPUTEVENT_KEY_30 },


    //{ VK_VOLUMEDOWN, INPUTEVENT_SPC_VOLUME_DOWN },
    //{ VK_VOLUMEUP, INPUTEVENT_SPC_VOLUME_UP },
//    { VK_MUTE, INPUTEVENT_SPC_VOLUME_MUTE },
//#endif
    { -1, 0 }
};

extern int ispressed (int key);

static int endpressed (void)
{
    return ispressed(VK_END);
}

static int shiftpressed (void)
{
    return ispressed (VK_LSHIFT) || ispressed (VK_RSHIFT);
}

static int altpressed (void)
{
    return ispressed (VK_LMENU) || ispressed (VK_RMENU);
}

static int ctrlpressed (void)
{
    return ispressed (VK_LCONTROL) || ispressed (VK_RCONTROL);
}

static int capslockstate;

int getcapslockstate (void)
{
    return capslockstate;
}
void setcapslockstate (int state)
{
    capslockstate = state;
}

extern byte keyboard_keystate[256] ;

int getcapslock (void)
{
    int newstate;

    BYTE keyState[256];
    //GetKeyboardState (keyState);
    newstate = keyboard_keystate[VK_CAPITAL] & 1;
    if (newstate != capslockstate)
        inputdevice_translatekeycode (0, VK_CAPITAL, newstate);
    capslockstate = newstate;
    return capslockstate;
}

#ifdef CD32
extern int cd32_enabled;

static int handlecd32 (int scancode, int state)
{
    int e = 0;
    if (!cd32_enabled)
	return 0;
    switch (scancode)
    {
	case VK_NUMPAD7:
	e = INPUTEVENT_JOY2_CD32_GREEN;
	break;
	case VK_NUMPAD9:
	e = INPUTEVENT_JOY2_CD32_YELLOW;
	break;
	case VK_NUMPAD1:
	e = INPUTEVENT_JOY2_CD32_RED;
	break;
	case VK_NUMPAD3:
	e = INPUTEVENT_JOY2_CD32_BLUE;
	break;
	case VK_DIVIDE:
	e = INPUTEVENT_JOY2_CD32_RWD;
	break;
	case VK_MULTIPLY:
	e = INPUTEVENT_JOY2_CD32_PLAY;
	break;
	case VK_SUBTRACT:
	e = INPUTEVENT_JOY2_CD32_FFW;
	break;
    }
    if (!e)
	return 0;
    handle_input_event (e, state, 1, 0);
    return 1;
}
#endif

void clearallkeys (void)
{
    inputdevice_updateconfig (&currprefs);
}

static int np[] = { VK_NUMPAD0, 0, VK_DECIMAL, 0, VK_NUMPAD1, 1, VK_NUMPAD2, 2,
    VK_NUMPAD3, 3, VK_NUMPAD4, 4, VK_NUMPAD5, 5, VK_NUMPAD6, 6, VK_NUMPAD7, 7,
    VK_NUMPAD8, 8, VK_NUMPAD9, 9, -1 };

void my_kbd_handler (int keyboard, int scancode, int newstate)
{
    int code = 0;

//    write_log( "keyboard = %d scancode = 0x%02.2x state = %d\n", keyboard, scancode, newstate ); 
    if (newstate) {
	switch (scancode)
	{
	    case VK_F12:
	    if (ctrlpressed ()) {
		code = AKS_TOGGLEFULLSCREEN;
	    } else if (shiftpressed () || endpressed ()) {
	        disablecapture ();
		code = AKS_ENTERDEBUGGER;
	    } else {
		code = AKS_ENTERGUI;
	    }
	    break;
	    case VK_F11:
	    if (currprefs.win32_ctrl_F11_is_quit) {
		if (ctrlpressed())
		    code = AKS_QUIT;
	    }
	    break;
	    case VK_F1:
	    case VK_F2:
	    case VK_F3:
	    case VK_F4:
	    if (endpressed ()) {
		if (shiftpressed ())
		    code = AKS_EFLOPPY0 + (scancode - VK_F1);
		else
		    code = AKS_FLOPPY0 + (scancode - VK_F1);
	    }
	    break;
	    case VK_F5:
	    if (endpressed ()) {
		if (shiftpressed ())
		    code = AKS_STATESAVEDIALOG;
		else
		    code = AKS_STATERESTOREDIALOG;
	    }
	    break;
	    case VK_NUMPAD0:
	    case VK_NUMPAD1:
	    case VK_NUMPAD2:
	    case VK_NUMPAD3:
	    case VK_NUMPAD4:
	    case VK_NUMPAD5:
	    case VK_NUMPAD6:
	    case VK_NUMPAD7:
	    case VK_NUMPAD8:
	    case VK_NUMPAD9:
	    case VK_DECIMAL:
	    if (endpressed ()) {
		int i = 0, v = -1;
		while (np[i] >= 0) {
		    v = np[i + 1];
		    if (np[i] == scancode)
			break;
		    i += 2;
		}
		if (v >= 0)
		    code = AKS_STATESAVEQUICK + v * 2 + ((shiftpressed () || ctrlpressed()) ? 0 : 1);
	    }
	    break;
	    //case VK_SYSRQ:
	    //screenshot (endpressed() ? 1 : 0);
	    //break;
	    case VK_PAUSE:
	    if (endpressed ())
		code = AKS_WARP;
	    else
		code = AKS_PAUSE;
	    break;
	    case VK_SCROLL:
	    code = AKS_INHIBITSCREEN;
	    break;
	    case VK_PRIOR:
#ifdef ACTION_REPLAY
	    code = AKS_FREEZEBUTTON;
#endif
	    break;
	    case VK_NEXT:
	    break;
	    case VK_SUBTRACT:
	    if (endpressed ())
		code = AKS_VOLDOWN;
	    break;
	    case VK_ADD:
	    if (endpressed ())
		code = AKS_VOLUP;
	    break;
	    case VK_MULTIPLY:
	    if (endpressed ())
		code = AKS_VOLMUTE;
	    break;
	    case VK_DIVIDE:
	    if (endpressed ())
		code = AKS_STATEREWIND;
	    break;
	}
    }
    if (code) {
	inputdevice_add_inputcode (code);
	return;
    }
    if (endpressed ())
	return;

    if (scancode == VK_CAPITAL) {
	if (!newstate)
	    return;
	capslockstate = capslockstate ? 0 : 1;
	newstate = capslockstate;
    }

    if (currprefs.input_selected_setting == 0) {
#ifdef CD32
        if (handlecd32 (scancode, newstate))
	    return;
#endif
    }
    inputdevice_translatekeycode (keyboard, scancode, newstate);
}

void keyboard_settrans (void)
{
    inputdevice_setkeytranslation (keytrans);
}

