;	WinSTon

;	DBCC Dn,<label>

;	XNZVC
;	-----

PUBLIC _dbcc
PUBLIC _dbcs
PUBLIC _dbeq
PUBLIC _dbf
PUBLIC _dbge
PUBLIC _dbgt
PUBLIC _dbhi
PUBLIC _dble
PUBLIC _dbls
PUBLIC _dblt
PUBLIC _dbmi
PUBLIC _dbne
PUBLIC _dbpl
PUBLIC _dbt
PUBLIC _dbvc
PUBLIC _dbvs

;-----------------------------------------------------------------------
;NOTE:- when branch is not taken(done_dbcc) we need to add 14,3,0 clock cycles
;and when branch is taken(dec_dbcc) add in 10,2,0. As these are rounded up to nearest
;4 we actually add in 16,3,0 and 12,2,0. The 12,2,0 is always added

;Branch not taken, add clock cycles different; careful of rounding to 4
done_dbcc PROC NEAR
	ADD_CYCLES	16-12								;Rounded up to 4
	add		esi,SIZE_WORD
	FRET
done_dbcc ENDP

;Branch taken, clock cycles already added in
dec_dbcc PROC NEAR
	;dec
	mov		edx,DECODE_1[ecx]						;Dn
	dec		WORD PTR[edx]
	cmp		WORD PTR[edx],-1
	je		done_dbcc

	mov		bx,[esi]								;Displacement
	SWAP_ENDIAN_WORD_BX
	movsx	ebx,bx									;sign extend
	add		esi,ebx
	FRET
dec_dbcc ENDP

;-----------------------------------------------------------------------
;DBCC Dn,<label>
_dbcc PROC NEAR
	;NOT C
	test	eax,EMU_C								;(SR&CARRY)==0
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dbcc ENDP

;-----------------------------------------------------------------------
;DBCS Dn,<label>
_dbcs PROC NEAR
	;NOT C
	test	eax,EMU_C								;(SR&CARRY)==0
	jne		done_dbcc

	;dec
	jmp		dec_dbcc
_dbcs ENDP

;-----------------------------------------------------------------------
;DBEQ Dn,<label>
_dbeq PROC NEAR
	;Z
	test	eax,EMU_Z								;SR&ZERO
	jne		done_dbcc

	;dec
	jmp		dec_dbcc
_dbeq ENDP

;-----------------------------------------------------------------------
;DBF Dn,<label>
_dbf PROC NEAR
	;FALSE
	jmp		dec_dbcc
_dbf ENDP

;-----------------------------------------------------------------------
;DBGE Dn,<label>
_dbge PROC NEAR
	; N.V + NOT N.NOT V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && (SR&OVERFLOW)
	cmp		ebx,EMU_N+EMU_V
	je		done_dbcc								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0)
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dbge ENDP

;-----------------------------------------------------------------------
;DBGT Dn,<label>
_dbgt PROC NEAR
	;N.V.NOT Z + NOT N.NOT V.NOT Z
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V+EMU_Z					;(SR&NEG) && (SR&OVERFLOW) && ((SR&ZERO)==0)
	cmp		ebx,EMU_N+EMU_V
	je		done_dbcc								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0) && ((SR&ZERO)==0)
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dbgt ENDP

;-----------------------------------------------------------------------
;DBHI Dn,<label>
_dbhi PROC NEAR
	;NOT C.NOT Z
	test	eax,EMU_C+EMU_Z							;((SR&CARRY)==0) && ((SR&ZERO)==0)
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dbhi ENDP

;-----------------------------------------------------------------------
;DBLE Dn,<label>
_dble PROC NEAR
	;Z + N.NOT V + NOT N.V
	test	eax,EMU_Z								;(SR&ZERO)
	jne		done_dbcc								;||
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		done_dbcc								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dble ENDP

;-----------------------------------------------------------------------
;DBLS Dn,<label>
_dbls PROC NEAR
	; C + Z
	test	eax,EMU_C								;(SR&CARRY)
	jne		done_dbcc								;||
	test	eax,EMU_Z								;(SR&ZERO)
	jne		done_dbcc

	;dec
	jmp		dec_dbcc
_dbls ENDP

;-----------------------------------------------------------------------
;DBLT Dn,<label>
_dblt PROC NEAR
	;N.NOT V + NOT N.V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		done_dbcc								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dblt ENDP

;-----------------------------------------------------------------------
;DBMI Dn,<label>
_dbmi PROC NEAR
	;N
	test	eax,EMU_N								;(SR&NEG)
	jne		done_dbcc

	;dec
	jmp		dec_dbcc
_dbmi ENDP

;-----------------------------------------------------------------------
;DBNE Dn,<label>
_dbne PROC NEAR
	;NOT Z
	test	eax,EMU_Z								;(SR&ZERO)==0
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dbne ENDP

;-----------------------------------------------------------------------
;DBPL Dn,<label>
_dbpl PROC NEAR
	;NOT N
	test	eax,EMU_N								;(SR&NEG)==0
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dbpl ENDP

;-----------------------------------------------------------------------
;DBT Dn,<label>
_dbt PROC NEAR
	;TRUE
	jmp		done_dbcc
_dbt ENDP

;-----------------------------------------------------------------------
;DBVC Dn,<label>
_dbvc PROC NEAR
	;NOT V
	test	eax,EMU_V								;(SR&OVERFLOW)==0
	je		done_dbcc

	;dec
	jmp		dec_dbcc
_dbvc ENDP

;-----------------------------------------------------------------------
;DBVS Dn,<label>
_dbvs PROC NEAR
	;V
	test	eax,EMU_V								;(SR&OVERFLOW)
	jne		done_dbcc

	;dec
	jmp		dec_dbcc
_dbvs ENDP
