/*
	WinSTon
*/

#define	MAX_KEYWORD		256
#define	MAX_KEYSTRING	MAX_FILENAME_LENGTH

// Tree view icons
enum {
	FAVOURITE_ICON_ROOT,
	FAVOURITE_ICON_FOLDER,
	FAVOURITE_ICON_DISC,
	FAVOURITE_ICON_CROSSED_DISC,
	FAVOURITE_ICON_GREY_DISC,
	FAVOURITE_ICON_GREY_CROSSED_DISC,
};

struct FAVOURITE_FOLDER_T;

// Favourite Disc Image
typedef struct FAVOURITE_DISC_T {
	char szTitle[MAX_STRING_LENGTH];					// Title of game/folder(see 'FavouriteType')
	char szDiscImages[4][MAX_FILENAME_LENGTH];			// Disc image A: and B:(blank if not used) + alternate name(possible blanks)
	char szTOSImage[MAX_FILENAME_LENGTH];				// TOS Image
	char szURLAddress[MAX_FILENAME_LENGTH];				// URL to download image
	BOOL bFails;										// TRUE if disc known not to run correctly
	BOOL bDiscExists;									// Set to TRUE if disc can be found on the drive
	BOOL bCheckIfDiscExists;							// Set to TRUE to update 'exist' icon
	BOOL bAlreadyChecked;								// Set to TRUE if disc already checked if 'exist'
	HTREEITEM hItem;

	FAVOURITE_FOLDER_T *pParentFolder;					// Folder disc belongs to

	FAVOURITE_DISC_T *pNextDisc;						// Next in list
	FAVOURITE_DISC_T *pPrevDisc;						// Previous in list(bottom bit set if to parent)
} FAVOURITE_DISC;


// Favourite Folder, which contains disc images
typedef struct FAVOURITE_FOLDER_T {
	char szFolder[MAX_STRING_LENGTH];					// Title of folder
	char szURLBaseAddress[MAX_FILENAME_LENGTH];			// String to add to start URLs in folder
	FAVOURITE_DISC *pDiscs;								// Disc images in this folder
	BOOL bCheckIfDiscExists;							// Set to TRUE to check folder for existing images
	HTREEITEM hItem;

	FAVOURITE_FOLDER_T *pParentFolder;					// Parent(NULL is root)

	FAVOURITE_FOLDER_T *pNextChildFolder;				// Child folder
	FAVOURITE_FOLDER_T *pPrevChildFolder;

	FAVOURITE_FOLDER_T *pNextFolder;					// Next in list
	FAVOURITE_FOLDER_T *pPrevFolder;					// Previous in list(bottom bit set if to parent)
} FAVOURITE_FOLDER;

// Favourites
typedef struct {
	FAVOURITE_FOLDER DiscImages;						// Folders, this is the 'top-level' - this CANNOT be deleted/edited etc...
	char szURLBaseAddress[MAX_FILENAME_LENGTH];			// String to add to start of all URLs(that don't start with 'http')
	BOOL bChanged;										// Has changed?
} FAVOURITES;

#define	MAKE_PARENT_POINTER(ptr)	((unsigned long)(ptr)|0x00000001)
#define	IS_PARENT_POINTER(ptr)		((unsigned long)(ptr)&0x00000001)
#define	MASK_PARENT_POINTER(ptr)	((unsigned long)(ptr)&0xfffffffe)
#define	SET_PARENT_POINTER(ptr)		(*((unsigned long *)MASK_PARENT_POINTER(ptr)))

extern FAVOURITES Favourites;

extern FAVOURITE_FOLDER *Favourites_AddFolder(FAVOURITE_FOLDER *pFolder);
extern FAVOURITE_FOLDER *Favourites_AddChildFolder(FAVOURITE_FOLDER *pFolder);
extern FAVOURITE_DISC *Favourites_AddDisc(FAVOURITE_FOLDER *pFolder);
extern FAVOURITE_DISC *Favourites_FindDiscByHandle(HTREEITEM hItem);
extern FAVOURITE_FOLDER *Favourites_FindFolderByHandle(HTREEITEM hItem);
extern FAVOURITE_FOLDER *Favourites_FindParentFolderByHandle(HTREEITEM hItem);
extern void Favourites_DeleteFolders(FAVOURITE_FOLDER *pFolder);
extern void Favourites_DeleteDisc(FAVOURITE_DISC *pDisc);
extern void Favourites_DeleteAllFolders(void);
extern void Favourites_Clean(void);
extern void Favourites_Load(void);
extern void Favourites_Load_ScanFolders(FAVOURITE_FOLDER *pFolder,FAVOURITE_DISC *pDisc,int Level);
extern void Favourites_Save(void);
extern void Favourites_Save_ScanFolders(FAVOURITE_FOLDER *pFolder,int Level);
