;	WinSTon

;	ANDI #<data>,Dn
;	ANDI #<data>,<ea>
;	ANDI #<data>,ccr
;	ANDI #<data>,sr

;	XNZVC
;	-**00

PUBLIC _andi_imm_dn_byte
PUBLIC _andi_imm_dn_word
PUBLIC _andi_imm_dn_long
PUBLIC _andi_imm_ea_byte
PUBLIC _andi_imm_ea_word
PUBLIC _andi_imm_ea_long
PUBLIC _andi_imm_ccr_byte
PUBLIC _andi_imm_sr_word

;-----------------------------------------------------------------------
;ANDI.B #<data>,Dn
_andi_imm_dn_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	and		[edx],bl								;Dest Dn
	SET_NZ
_andi_imm_dn_byte ENDP

;ANDI.W #<data>,Dn
_andi_imm_dn_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_BX
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	and		[edx],bx								;Dest Dn
	SET_NZ
_andi_imm_dn_word ENDP

;ANDI.L #<data>,Dn
_andi_imm_dn_long PROC NEAR
	mov		ebx,IMM_LONG[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_LONG							;Increase program counter
	SWAP_ENDIAN_LONG_EBX
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	and		[edx],ebx								;Dest Dn
	SET_NZ
_andi_imm_dn_long ENDP

;-----------------------------------------------------------------------
;ANDI.B #<data>,<ea>
_andi_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	and		bl,dl
	WRITE_BYTE_NZ
_andi_imm_ea_byte ENDP

;ANDI.W #<data>,<ea>
_andi_imm_ea_word PROC NEAR
	mov		dx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_DX
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	and		bx,dx
	WRITE_WORD_NZ
_andi_imm_ea_word ENDP

;ANDI.L #<data>,<ea>
_andi_imm_ea_long PROC NEAR
	mov		edx,IMM_LONG[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_LONG							;Increase program counter
	SWAP_ENDIAN_LONG_EDX
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	and		ebx,edx
	WRITE_LONG_NZ
_andi_imm_ea_long ENDP

;-----------------------------------------------------------------------
;ANDI.B #<data>,ccr
_andi_imm_ccr_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	shl		ebx,4									;Convert to emulation format
	and		eax,ebx									;And to CCR
	FRET
_andi_imm_ccr_byte ENDP

;-----------------------------------------------------------------------
;ANDI.W #<data>,sr
_andi_imm_sr_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_BX
	COMBINE_SR_TO_AX								;Get 'SR' into 'ax'
	and		eax,ebx									;And to SR
	call	asm_check_usersuper_swap				;Write 'eax' to SR, swap modes and return ccodes in 'eax'
	FRET
_andi_imm_sr_word ENDP
