// WinSTon - Windows ST emulation

// Include these here as ALWAYS needed for DLG_PARAMS structure
#include "..\includes\dialogconfigure.h"
#include "..\includes\dialogdiscimage.h"
#include "..\includes\favourites.h"
#include "..\includes\dialogfavourites.h"
#include "..\includes\dialogharddisc.h"
#include "..\includes\dialogjoysticks.h"
#include "..\includes\dialogkeyboard.h"
#include "..\includes\dialogmemory.h"
#include "..\includes\dialogprinter.h"
#include "..\includes\dialogrs232.h"
#include "..\includes\dialogscreen.h"
#include "..\includes\dialogsound.h"
#include "..\includes\dialogtosgem.h"

// State of system is stored in this structure
// On reset, variables are copied into system globals and used. These are also saved to registry
typedef struct {
	// Configure
	DLG_CONFIGURE Configure;
	DLG_SCREEN Screen;
	DLG_JOYSTICKS Joysticks;
	DLG_KEYBOARD Keyboard;
	DLG_SOUND Sound;
	DLG_MEMORY Memory;
	DLG_DISCIMAGE DiscImage;
	DLG_HARDDISC HardDisc;
	DLG_TOSGEM TOSGEM;
	DLG_RS232 RS232;
	DLG_PRINTER Printer;
	DLG_FAVOURITES Favourites;
} DLG_PARAMS;

enum {
	DIALOG_PAGE_CONFIGURE,
	DIALOG_PAGE_SCREEN,
	DIALOG_PAGE_JOYSTICKS,
	DIALOG_PAGE_KEYBOARD,
	DIALOG_PAGE_SOUND,
	DIALOG_PAGE_MEMORY,
	DIALOG_PAGE_DISCIMAGE,
	DIALOG_PAGE_HARDDISC,
	DIALOG_PAGE_TOSGEM,
	DIALOG_PAGE_RS232,
	DIALOG_PAGE_PRINTER,
	DIALOG_PAGE_FAVOURITES
};

// Structure for each page on property dialog
typedef struct {
	char *pTitle;
	int PageIDD;
//	DLGPROC pDlgProc;
} DLG_PAGES;

extern DLG_PARAMS ConfigureParams,DialogParams;
extern BOOL bOKDialog;
extern HWND FavouritehDlg;
extern HWND PropHWnd;
extern int nLastOpenPage;

extern void Dialog_DefaultConfigurationDetails(void);
extern void Dialog_CopyDetailsFromConfiguration(BOOL bReset);
extern BOOL Dialog_DoProperty(int StartingPage,BOOL bForceReset);
extern void Dialog_SetButton(HWND hDlg,int ButtonID,int Flag);
extern BOOL Dialog_ReadButton(HWND hDlg,int ButtonID);
extern void Dialog_EnableItem(HWND hDlg,int ButtonID,int State);
extern void Dialog_EnableItems(HWND hDlg,int *pButtonIDs,int State);
extern void Dialog_ShowItemRange(HWND hDlg,int LowButtonID,int HighButtonID,int Show);
extern void Dialog_SetText(HWND hDlg,int ButtonID,char *szString);
extern void Dialog_ReadText(HWND hDlg,int ButtonID,char *szString);
extern void Dialog_SetTrackBar(HWND hDlg, int nTrackBarID, int nMin, int nMax, int nSelected);
extern int Dialog_GetTrackBar(HWND hDlg, int nTrackBarID);
extern void Dialog_SetComboBoxItems(HWND hDlg, int ComboBoxID, char *pComboBoxStrings[], int nSelectedItem);
extern void Dialog_ComboBoxSelectString(HWND hDlg, int ComboBoxID, char *pszSelectedString);
extern int Dialog_GetSelectedComboBoxItem(HWND hDlg, int ComboBoxID);
extern void Dialog_SetListBoxItems(HWND hDlg, int ListBoxID, char *pListBoxStrings[], int nSelectedItem);
extern int Dialog_GetSelectedListBoxItem(HWND hDlg, int ListBoxID);
extern int Dialog_SetSpinList(HWND hDlg, int nEditBoxID, int nSpinID, char *pSpinStrings[], int nItems, int nSelectedItem);
extern int Dialog_GetSpinList(HWND hDlg, int nSpinID);
extern int Dialog_UpdateSpinList(HWND hDlg, int nEditBoxID, char *pSpinStrings[], int nNumSpinItems, int nNewSelectedItem);
extern void Dialog_SetRadioButtons(HWND hDlg,int StartButtonID,int EndButtonID,int nSelectedItem);
extern int Dialog_ReadRadioButtons(HWND hDlg,int StartButtonID,int EndButtonID);
extern void Dialog_AddListViewColumn(HWND hDlg, int ListViewID, int Order, char *pString, int Width);
