/*
	WinSTon

	Zip file handling

	This uses ZLib library available for free on the Internet and a couple of wrapper functions
	to scan for the first occurance of a file(by extension) in the ZIP image.
	The first file(.ST or .MSA) is uncompressed and copied into the emulator disc image buffer.
	NOTE We do not support saving of images back to the .ZIP format
*/

#include "..\includes\winston.h"
#include "..\includes\file.h"
#include "..\includes\msa.h"
#include "..\includes\zip.h"
#include "../zlib/zlib.h"
#include "../zlib/zip.h"

#pragma comment(lib,"zlib/zlib.lib")
#pragma comment(lib,"zlib/zip.lib")

//-----------------------------------------------------------------------
/*
	Scan .ZIP file for first .ST or .MSA file, return TRUE and set 'pszFileName' on match
*/
BOOL ZIP_ScanForImages(char *pszZipFileName,char *pszFileName)
{
	// Scan for extension, eg .ST or .MSA
	if (Zip_ScanExtension(pszZipFileName,".msa",pszFileName))
		return(TRUE);
	else if (Zip_ScanExtension(pszZipFileName,".st",pszFileName))
		return(TRUE);

	return(FALSE);
}

//-----------------------------------------------------------------------
/*
	Uncompress .ZIP file(with single .ST or .MSA image in it) into memory, return number of bytes loaded
*/
int ZIP_ReadDisc(char *pszZipFileName,unsigned char *pBuffer)
{
	char szFileName[MAX_FILENAME_LENGTH];
	unsigned char *pTempBuffer;
	unsigned int nBufferBytes;

	// Find filename of first disc image within .ZIP
	if (ZIP_ScanForImages(pszZipFileName,szFileName)) {
		// Load/Uncompress file from .ZIP
		if (Zip_LoadFile(pszZipFileName, szFileName, &pTempBuffer,&nBufferBytes)) {
			// Is an.ST or .MSA?
			if (File_FileNameIsST(szFileName)) {
				// Can just copy .ST data to disc buffer
				memcpy(pBuffer,pTempBuffer,nBufferBytes);
			}
			else if (File_FileNameIsMSA(szFileName)) {
				// Need to uncompress .MSA data to disc buffer
				nBufferBytes = MSA_UnCompress(pTempBuffer,pBuffer);
			}
			else	// Unknown
				nBufferBytes = 0;

			// And free original
			free(pTempBuffer);

			return(nBufferBytes);
		}
	}

	// Oops, something went wrong
	return 0;
}

//-----------------------------------------------------------------------
/*
	Save .ZIP file from memory buffer. Returns FALSE as this is not supported!
*/
BOOL ZIP_WriteDisc(char *pszZipFileName,unsigned char *pBuffer,int ImageSize)
{
	// We do not support saving back to a .ZIP image
	return(FALSE);
}
