/*
	WinSTon

	Debugger Registers
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\debugger.h"
#include "..\includes\debuggerregisters.h"
#include "..\includes\decode.h"
#include "..\includes\dialog.h"
#include "..\includes\disass.h"
#include "..\includes\stmemory.h"

#ifdef USE_DEBUGGER

//-----------------------------------------------------------------------
/*
	Init Debugger Registers
*/
void Debugger_Registers_Init(HWND hWnd)
{
	// Update registers
	Debugger_Registers_Update(hWnd);
}

//-----------------------------------------------------------------------
/*
	Update Debugger Registers
*/
void Debugger_Registers_Update(HWND hWnd)
{
	char szString[256];
	unsigned short int StatusRegister;
	int i;

	// Set text of registers D0..D7/A0..A7/SSP etc...
	for(i=REG_D0; i<=REG_A8; i++) {
		sprintf(szString,"%8.8X",Regs[i]);
		SendDlgItemMessage(hWnd,IDC_REGISTER_EDIT_D0+i,WM_SETTEXT,0,(LONG)szString);
		if (i>=REG_A0) {
			sprintf(szString,"%8.8X",STMemory_ReadLong(Regs[i]&0x00ffffff));
			SendDlgItemMessage(hWnd,IDC_REGISTER_STATIC_A0+(i-REG_A0),WM_SETTEXT,0,(LONG)szString);
		}
	}

	// Set program counter
	sprintf(szString,"%8.8X",PC);
	SendDlgItemMessage(hWnd,IDC_REGISTER_EDIT_PC,WM_SETTEXT,0,(LONG)szString);

	// Set status register
	StatusRegister = (SR&SR_MASK) | (((unsigned short int)EmuCCode>>4)&SR_CCODE_MASK);
	sprintf(szString,"%4.4X",StatusRegister);
	SendDlgItemMessage(hWnd,IDC_REGISTER_EDIT_SR,WM_SETTEXT,0,(LONG)szString);
	// Show XNZVC flags
	szString[0] = '\0';
	if (StatusRegister&SR_AUX)		strcat(szString,"X"); else	strcat(szString,"-");
	if (StatusRegister&SR_NEG)		strcat(szString,"N"); else	strcat(szString,"-");
	if (StatusRegister&SR_ZERO)		strcat(szString,"Z"); else	strcat(szString,"-");
	if (StatusRegister&SR_OVERFLOW)	strcat(szString,"V"); else	strcat(szString,"-");
	if (StatusRegister&SR_CARRY)	strcat(szString,"C"); else	strcat(szString,"-");
	SendDlgItemMessage(hWnd,IDC_REGISTER_STATIC_CCODE,WM_SETTEXT,0,(LONG)szString);
}

#endif	//USE_DEBUGGER
