/*
	WinSTon
*/

// Routines to create 'ecx' pixels - MUST be called in this order
#define LOW_BUILD_PIXELS_0 \
	__asm	and		ebx,0x0f0f0f0f \
	__asm	and		ecx,0x0f0f0f0f \
	__asm	mov		eax,ebx \
	__asm	shr		eax,12 \
	__asm	or		eax,ebx \
	__asm	mov		edx,ecx \
	__asm	shr		edx,12 \
	__asm	or		edx,ecx \
	__asm	mov		ebx,edx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ecx,Remap_2_Planes_Upper[ebx*4] \
	__asm	mov		ebx,eax \
	__asm	and		ebx,0x000000ff \
	__asm	add		ecx,Remap_2_Planes[ebx*4]

#define LOW_BUILD_PIXELS_1 \
	__asm	mov		ebx,edx \
	__asm	shr		ebx,8 \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ecx,Remap_2_Planes_Upper[ebx*4] \
	__asm	mov		ebx,eax \
	__asm	shr		ebx,8 \
	__asm	and		ebx,0x000000ff \
	__asm	add		ecx,Remap_2_Planes[ebx*4]

#define LOW_BUILD_PIXELS_2 \
	__asm	mov		ebx,[edi] \
	__asm	mov		ecx,4[edi] \
	__asm	and		ebx,0xf0f0f0f0 \
	__asm	and		ecx,0xf0f0f0f0 \
	__asm	shr		ebx,4 \
	__asm	mov		eax,ebx \
	__asm	shr		ebx,12 \
	__asm	or		eax,ebx \
	__asm	shr		ecx,4 \
	__asm	mov		edx,ecx \
	__asm	shr		ecx,12 \
	__asm	or		edx,ecx \
	__asm	mov		ebx,edx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ecx,Remap_2_Planes_Upper[ebx*4] \
	__asm	mov		ebx,eax \
	__asm	and		ebx,0x000000ff \
	__asm	add		ecx,Remap_2_Planes[ebx*4]

#define LOW_BUILD_PIXELS_3 \
	__asm	mov		ebx,edx \
	__asm	shr		ebx,8 \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ecx,Remap_2_Planes_Upper[ebx*4] \
	__asm	mov		ebx,eax \
	__asm	shr		ebx,8 \
	__asm	and		ebx,0x000000ff \
	__asm	add		ecx,Remap_2_Planes[ebx*4]


// Routines to create 'ecx' pixels - MUST be called in this order
#define MED_BUILD_PIXELS_0 \
	__asm	and		ebx,0x0f0f0f0f \
	__asm	mov		eax,ebx \
	__asm	shr		eax,12 \
	__asm	or		eax,ebx \
	__asm	mov		ebx,eax \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ecx,Remap_2_Planes[ebx*4]

#define MED_BUILD_PIXELS_1 \
	__asm	mov		ebx,eax \
	__asm	shr		ebx,8 \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ecx,Remap_2_Planes[ebx*4]

#define MED_BUILD_PIXELS_2 \
	__asm	mov		ebx,[edi] \
	__asm	and		ebx,0xf0f0f0f0 \
	__asm	shr		ebx,4 \
	__asm	mov		eax,ebx \
	__asm	shr		ebx,12 \
	__asm	or		eax,ebx \
	__asm	mov		ebx,eax \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ecx,Remap_2_Planes[ebx*4]

#define MED_BUILD_PIXELS_3 \
	__asm	mov		ebx,eax \
	__asm	shr		ebx,8 \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ecx,Remap_2_Planes[ebx*4]

// Routines to create 'ecx' pixels - MUST be called in this order
#define HIGH_BUILD_PIXELS_0 \
	__asm	mov		eax,ebx \
	__asm	and		eax,0x0000000f

#define HIGH_BUILD_PIXELS_1 \
	__asm	mov		eax,ebx \
	__asm	shr		eax,4 \
	__asm	and		eax,0x0000000f

#define HIGH_BUILD_PIXELS_2 \
	__asm	mov		eax,ebx \
	__asm	shr		eax,8 \
	__asm	and		eax,0x0000000f

#define HIGH_BUILD_PIXELS_3 \
	__asm	mov		eax,ebx \
	__asm	shr		eax,12 \
	__asm	and		eax,0x0000000f

// Plot Low Resolution(320xH) 8-Bit pixels
#define PLOT_LOW_320_8BIT(offset) \
	__asm	add		ecx,BASECOLOUR_LONG \
	__asm	mov		offset[esi],ecx

// Plot Low Resolution(320xH) 16-Bit pixels
#define PLOT_LOW_320_16BIT(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+2],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+6],bx

// Plot Low Resolution(640xH) 8-Bit pixels
#define PLOT_LOW_640_8BIT(offset)	\
	__asm	add		ecx,BASECOLOUR_LONG \
	__asm	mov		ebp,ecx \
	__asm	mov		ecx,ebp \
	__asm	mov		ebx,ebp \
	__asm	and		ecx,0x000000ff \
	__asm	and		ebx,0x0000ff00 \
	__asm	shl		ebx,8 \
	__asm	or		ecx,ebx \
	__asm	mov		ebx,ecx \
	__asm	shl		ebx,8 \
	__asm	or		ecx,ebx \
	__asm	mov		offset[esi],ecx \
	__asm	mov		ecx,ebp \
	__asm	mov		ebx,ebp \
	__asm	and		ecx,0xff000000 \
	__asm	and		ebx,0x00ff0000 \
	__asm	shr		ebx,8 \
	__asm	or		ecx,ebx \
	__asm	mov		ebx,ecx \
	__asm	shr		ebx,8 \
	__asm	or		ecx,ebx \
	__asm	mov		offset[esi+4],ecx

// Plot Low Resolution(640xH) 8-Bit pixels(Double on Y)
#define PLOT_LOW_640_8BIT_DOUBLE_Y(offset)	\
	__asm	add		ecx,BASECOLOUR_LONG \
	__asm	mov		ebp,ecx \
	__asm	mov		ecx,ebp \
	__asm	mov		ebx,ebp \
	__asm	and		ecx,0x000000ff \
	__asm	and		ebx,0x0000ff00 \
	__asm	shl		ebx,8 \
	__asm	or		ecx,ebx \
	__asm	mov		ebx,ecx \
	__asm	shl		ebx,8 \
	__asm	or		ecx,ebx \
	__asm	mov		offset[esi],ecx \
	__asm	mov		ebx,[PCScreenBytesPerLine] \
	__asm	mov		offset[esi+ebx],ecx \
	__asm	mov		ecx,ebp \
	__asm	mov		ebx,ebp \
	__asm	and		ecx,0xff000000 \
	__asm	and		ebx,0x00ff0000 \
	__asm	shr		ebx,8 \
	__asm	or		ecx,ebx \
	__asm	mov		ebx,ecx \
	__asm	shr		ebx,8 \
	__asm	or		ecx,ebx \
	__asm	mov		ebx,[PCScreenBytesPerLine] \
	__asm	mov		offset[esi+4],ecx \
	__asm	mov		offset[esi+4+ebx],ecx

// Plot Low Resolution(640xH) 16-Bit pixels
#define PLOT_LOW_640_16BIT(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+8],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+12],ebx

// Plot Low Resolution(640xH) 16-Bit pixels(Double on Y)
#define PLOT_LOW_640_16BIT_DOUBLE_Y(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],ebx \
	__asm	mov		offset[esi+ebp],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],ebx \
	__asm	mov		offset[esi+4+ebp],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+8],ebx \
	__asm	mov		offset[esi+8+ebp],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+12],ebx \
	__asm	mov		offset[esi+12+ebp],ebx

// Plot Medium Resolution(640xH) 8-Bit pixels
#define PLOT_MED_640_8BIT(offset) \
	__asm	add		ecx,BASECOLOUR_LONG \
	__asm	mov		offset[esi],ecx

// Plot Medium Resolution(640xH) 8-Bit pixels(Double on Y)
#define PLOT_MED_640_8BIT_DOUBLE_Y(offset) \
	__asm	add		ecx,BASECOLOUR_LONG \
	__asm	mov		offset[esi],ecx \
	__asm	mov		offset[esi+ebp],ecx

// Plot Medium Resolution(640xH) 16-Bit pixels
#define PLOT_MED_640_16BIT(offset) \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+2],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+6],bx

// Plot Medium Resolution(640xH) 16-Bit pixels(Double on Y)
#define PLOT_MED_640_16BIT_DOUBLE_Y(offset) \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],bx \
	__asm	mov		offset[esi+ebp],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+2],bx \
	__asm	mov		offset[esi+2+ebp],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],bx \
	__asm	mov		offset[esi+4+ebp],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+6],bx \
	__asm	mov		offset[esi+6+ebp],bx

// Plot High Resolution(640xH) 8-Bit pixels
#define PLOT_HIGH_640_8BIT(offset) \
	__asm	mov		eax,Remap_1_Plane[eax*4] \
	__asm	mov		offset[esi],eax

// Plot Spectrum512 Resolution(320xH) 16-Bit pixels
#define PLOT_SPEC512_LEFT_LOW_320_16BIT(offset)	\
	__asm	and		ecx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ecx*4] \
	__asm	mov		offset[esi],bx

// Plot Spectrum512 Resolution(320xH) 16-Bit pixels
#define PLOT_SPEC512_MID_320_16BIT(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+2],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+6],bx

// Plot Spectrum512 Resolution(320xH) 16-Bit pixels
#define PLOT_SPEC512_END_LOW_320_16BIT(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+2],bx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],bx

// Plot Spectrum512 Resolution(640xH) 16-Bit pixels
#define PLOT_SPEC512_LEFT_LOW_640_16BIT(offset)	\
	__asm	and		ecx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ecx*4] \
	__asm	mov		offset[esi],ebx

// Plot Spectrum512 Resolution(640xH) 16-Bit pixels
#define PLOT_SPEC512_MID_640_16BIT(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+8],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+12],ebx

// Plot Spectrum512 Resolution(640xH) 16-Bit pixels
#define PLOT_SPEC512_END_LOW_640_16BIT(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+8],ebx

// Plot Spectrum512 Resolution(640xH) 16-Bit pixels(Double on Y)
#define PLOT_SPEC512_LEFT_LOW_640_16BIT_DOUBLE_Y(offset)	\
	__asm	and		ecx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ecx*4] \
	__asm	mov		offset[esi],ebx \
	__asm	mov		offset[esi+ebp],ebx

// Plot Spectrum512 Resolution(640xH) 16-Bit pixels(Double on Y)
#define PLOT_SPEC512_MID_640_16BIT_DOUBLE_Y(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],ebx \
	__asm	mov		offset[esi+ebp],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],ebx \
	__asm	mov		offset[esi+4+ebp],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+8],ebx \
	__asm	mov		offset[esi+8+ebp],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+12],ebx \
	__asm	mov		offset[esi+12+ebp],ebx

// Plot Spectrum512 Resolution(640xH) 16-Bit pixels(Double on Y)
#define PLOT_SPEC512_END_LOW_640_16BIT_DOUBLE_Y(offset)	\
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi],ebx \
	__asm	mov		offset[esi+ebp],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+4],ebx \
	__asm	mov		offset[esi+4+ebp],ebx \
	__asm	mov		ebx,ecx \
	__asm	and		ebx,0x000000ff \
	__asm	shr		ecx,8 \
	__asm	mov		ebx,DWORD PTR STRGBPalette[ebx*4] \
	__asm	mov		offset[esi+8],ebx \
	__asm	mov		offset[esi+8+ebp],ebx

extern int ScrUpdateFlag;
extern BOOL bScrDoubleY;

extern void ConvertLowRes_320x16Bit(void);
extern void ConvertLowRes_640x16Bit(void);
extern void Line_ConvertLowRes_640x16Bit(void);
extern void ConvertMediumRes_640x16Bit(void);
extern void Line_ConvertMediumRes_640x16Bit(void);
extern void ConvertLowRes_320x8Bit(void);
extern void ConvertLowRes_640x8Bit(void);
extern void Line_ConvertLowRes_640x8Bit(void);
extern void ConvertMediumRes_640x8Bit(void);
extern void Line_ConvertMediumRes_640x8Bit(void);
extern void ConvertHighRes_640x8Bit(void);
extern void ConvertHighRes_640x1Bit(void);
extern void ConvertSpec512_320x16Bit(void);
extern void ConvertSpec512_640x16Bit(void);

extern void ConvertVDIRes_16Colour(void);
extern void ConvertVDIRes_4Colour(void);
extern void ConvertVDIRes_2Colour_1Bit(void);
extern void ConvertVDIRes_2Colour(void);
