/*
	WinSTon

	Memory Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\dialog.h"
#include "..\includes\file.h"
#include "..\includes\memorysnapshot.h"
#include "..\includes\misc.h"

// List of possible Memory configurations(MUST match MEMORY_SIZE_xxxx)
#define NUM_MEMORYSIZEITEMSTRINGS	4
static char *pszMemorySizeItemStrings[] = {
	"512 Kb",
	"1 Mb",
	"2 Mb",
	"4 Mb",
	NULL	//term
};

// Button IDs
static int MemoryCapture_DialogItems[] = {
	IDC_BUTTON_MEMORY_CAPTURE,
	IDC_BUTTON_MEMORY_RESTORE,
	0,	//term
};

//-----------------------------------------------------------------------
/*
	Set defaults for Memory
*/
void Dialog_Memory_SetDefaults(void)
{
	// Set defaults for Memory
	ConfigureParams.Memory.nMemorySize = MEMORY_SIZE_1Mb;
	strcpy(ConfigureParams.Memory.szMemoryCaptureFileName,"");
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_Memory_EnableItems(HWND hDlg)
{
	// Turn on all by default
	Dialog_EnableItems(hDlg,MemoryCapture_DialogItems,TRUE);
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_Memory_WritePopulate(HWND hDlg)
{
	// Set items
	Dialog_SetSpinList(hDlg,IDC_EDIT_MEMORYSIZE,IDC_SPIN_MEMORYSIZE,pszMemorySizeItemStrings,NUM_MEMORYSIZEITEMSTRINGS,DialogParams.Memory.nMemorySize);
	Dialog_SetText(hDlg,IDC_EDIT_MEMORY,DialogParams.Memory.szMemoryCaptureFileName);

	Dialog_Memory_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_Memory_ReadPopulate(HWND hDlg)
{
	// Read items
	DialogParams.Memory.nMemorySize = Dialog_GetSpinList(hDlg,IDC_SPIN_MEMORYSIZE);
	Dialog_ReadText(hDlg,IDC_EDIT_MEMORY,DialogParams.Memory.szMemoryCaptureFileName);
}

//-----------------------------------------------------------------------
/*
	Browse for sound capture image file (*.MEM)
*/
void Dialog_Memory_BrowseMemoryFile(HWND hDlg)
{
	// Browse for file and change edit box if OK
	if (File_OpenSelectDlg(hWnd,DialogParams.Memory.szMemoryCaptureFileName,FILEFILTER_MEMORYFILE,FALSE,FALSE))
		Dialog_SetText(hDlg,IDC_EDIT_MEMORY,DialogParams.Memory.szMemoryCaptureFileName);
}

//-----------------------------------------------------------------------
/*
	Memory Property page handler
*/
BOOL FAR PASCAL Dialog_Memory_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	NMUPDOWN *pUpDown;
	int Offset;

	switch(Message) {
		case WM_INITDIALOG:
			Dialog_Memory_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_MEMORY;
			return(TRUE);

		case WM_NOTIFY:
			switch(wParam) {
				case IDC_SPIN_MEMORYSIZE:
					pUpDown = (NMUPDOWN *)lParam;
					Offset = Misc_LimitInt(pUpDown->iPos + pUpDown->iDelta, 0,NUM_MEMORYSIZEITEMSTRINGS-1);
					Dialog_UpdateSpinList(hDlg,IDC_EDIT_MEMORYSIZE,pszMemorySizeItemStrings,NUM_MEMORYSIZEITEMSTRINGS,Offset);
					return(TRUE);
			}

			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_Memory_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\memory.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\memory.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_EDIT_MEMORY:
					if (HIWORD(wParam)==EN_CHANGE)
						Dialog_Memory_EnableItems(hDlg);
					return(TRUE);

				case IDC_BUTTON_MEMORY_CAPTURE:
					bSaveMemoryState = TRUE;
					// And choose 'OK' on property sheet
					PropSheet_PressButton(PropHWnd,PSBTN_OK);
					return(TRUE);
				case IDC_BUTTON_MEMORY_RESTORE:
					bRestoreMemoryState = TRUE;
					// And choose 'OK' on property sheet
					PropSheet_PressButton(PropHWnd,PSBTN_OK);
					return(TRUE);

				case IDC_BUTTON_MEMORY_BROWSE:
					Dialog_Memory_BrowseMemoryFile(hDlg);
					Dialog_Memory_EnableItems(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
