;	WinSTon

;	SCC Dn
;	SCC <ea>

;	XNZVC
;	-----

PUBLIC _scc_dn
PUBLIC _scc
PUBLIC _scs_dn
PUBLIC _scs
PUBLIC _seq_dn
PUBLIC _seq
PUBLIC _sf_dn
PUBLIC _sf
PUBLIC _sge_dn
PUBLIC _sge
PUBLIC _sgt_dn
PUBLIC _sgt
PUBLIC _shi_dn
PUBLIC _shi
PUBLIC _sle_dn
PUBLIC _sle
PUBLIC _sls_dn
PUBLIC _sls
PUBLIC _slt_dn
PUBLIC _slt
PUBLIC _smi_dn
PUBLIC _smi
PUBLIC _sne_dn
PUBLIC _sne
PUBLIC _spl_dn
PUBLIC _spl
PUBLIC _st_dn
PUBLIC _st
PUBLIC _svc_dn
PUBLIC _svc
PUBLIC _svs_dn
PUBLIC _svs

;-----------------------------------------------------------------------
scc_clear_ea PROC NEAR
	EFFADDR_READ									;Read <ea>
	xor		bl,bl									;Clear result
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
scc_clear_ea ENDP

scc_set_ea PROC NEAR
	EFFADDR_READ									;Read <ea>
	mov		bl,0ffh									;Set result
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
scc_set_ea ENDP

scc_clear_dn PROC NEAR
	mov		ebx,DECODE_1[ecx]						;DReg
	mov		BYTE PTR [ebx],00h						;Store condition
	FRET
scc_clear_dn ENDP

scc_set_dn PROC NEAR
	mov		ebx,DECODE_1[ecx]						;DReg
	mov		BYTE PTR [ebx],0ffh						;Store condition
	FRET
scc_set_dn ENDP

;-----------------------------------------------------------------------
;SCC Dn
_scc_dn PROC NEAR
	;NOT C
	test	eax,EMU_C								;(SR&CARRY)==0
	je		scc_set_dn

	jmp		scc_clear_dn
_scc_dn ENDP

;SCC <ea>
_scc PROC NEAR
	;NOT C
	test	eax,EMU_C								;(SR&CARRY)==0
	je		scc_set_ea

	jmp		scc_clear_ea
_scc ENDP

;-----------------------------------------------------------------------
;SCS Dn
_scs_dn PROC NEAR
	;NOT C
	test	eax,EMU_C								;(SR&CARRY)==0
	jne		scc_set_dn

	jmp		scc_clear_dn
_scs_dn ENDP

;SCS <ea>
_scs PROC NEAR
	;NOT C
	test	eax,EMU_C								;(SR&CARRY)==0
	jne		scc_set_ea

	jmp		scc_clear_ea
_scs ENDP

;-----------------------------------------------------------------------
;SEQ Dn
_seq_dn PROC NEAR
	;Z
	test	eax,EMU_Z								;SR&ZERO
	jne		scc_set_dn

	jmp		scc_clear_dn
_seq_dn ENDP

;SEQ <ea>
_seq PROC NEAR
	;Z
	test	eax,EMU_Z								;SR&ZERO
	jne		scc_set_ea

	jmp		scc_clear_ea
_seq ENDP

;-----------------------------------------------------------------------
;SF Dn
_sf_dn PROC NEAR
	jmp		scc_clear_dn
_sf_dn ENDP

;SF <ea>
_sf PROC NEAR
	jmp		scc_clear_ea
_sf ENDP

;-----------------------------------------------------------------------
;SGE Dn
_sge_dn PROC NEAR
	; N.V + NOT N.NOT V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && (SR&OVERFLOW)
	cmp		ebx,EMU_N+EMU_V
	je		scc_set_dn								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0)
	je		scc_set_dn

	jmp		scc_clear_dn
_sge_dn ENDP

;SGE <ea>
_sge PROC NEAR
	; N.V + NOT N.NOT V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && (SR&OVERFLOW)
	cmp		ebx,EMU_N+EMU_V
	je		scc_set_ea								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0)
	je		scc_set_ea

	jmp		scc_clear_ea
_sge ENDP

;-----------------------------------------------------------------------
;SGT Dn
_sgt_dn PROC NEAR
	;N.V.NOT Z + NOT N.NOT V.NOT Z
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V+EMU_Z					;(SR&NEG) && (SR&OVERFLOW) && ((SR&ZERO)==0)
	cmp		ebx,EMU_N+EMU_V
	je		scc_set_dn								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0) && ((SR&ZERO)==0)
	je		scc_set_dn

	jmp		scc_clear_dn
_sgt_dn ENDP

;SGT <ea>
_sgt PROC NEAR
	;N.V.NOT Z + NOT N.NOT V.NOT Z
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V+EMU_Z					;(SR&NEG) && (SR&OVERFLOW) && ((SR&ZERO)==0)
	cmp		ebx,EMU_N+EMU_V
	je		scc_set_ea								;||
	or		ebx,ebx									;((SR&NEG)==0) && ((SR&OVERFLOW)==0) && ((SR&ZERO)==0)
	je		scc_set_ea

	jmp		scc_clear_ea
_sgt ENDP

;-----------------------------------------------------------------------
;SHI Dn
_shi_dn PROC NEAR
	;NOT C.NOT Z
	test	eax,EMU_C+EMU_Z							;((SR&CARRY)==0) && ((SR&ZERO)==0)
	je		scc_set_dn

	jmp		scc_clear_dn
_shi_dn ENDP

;SHI <ea>
_shi PROC NEAR
	;NOT C.NOT Z
	test	eax,EMU_C+EMU_Z							;((SR&CARRY)==0) && ((SR&ZERO)==0)
	je		scc_set_ea

	jmp		scc_clear_ea
_shi ENDP

;-----------------------------------------------------------------------
;SLE Dn
_sle_dn PROC NEAR
	;Z + N.NOT V + NOT N.V
	test	eax,EMU_Z								;(SR&ZERO)
	jne		scc_set_dn								;||
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		scc_set_dn								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		scc_set_dn

	jmp		scc_clear_dn
_sle_dn ENDP

;SLE <ea>
_sle PROC NEAR
	;Z + N.NOT V + NOT N.V
	test	eax,EMU_Z								;(SR&ZERO)
	jne		scc_set_ea								;||
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		scc_set_ea								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		scc_set_ea

	jmp		scc_clear_ea
_sle ENDP

;-----------------------------------------------------------------------
;SLS Dn
_sls_dn PROC NEAR
	; C + Z
	test	eax,EMU_C								;(SR&CARRY)
	jne		scc_set_dn								;||
	test	eax,EMU_Z								;(SR&ZERO)
	jne		scc_set_dn

	jmp		scc_clear_dn
_sls_dn ENDP

;SLS <ea>
_sls PROC NEAR
	; C + Z
	test	eax,EMU_C								;(SR&CARRY)
	jne		scc_set_ea								;||
	test	eax,EMU_Z								;(SR&ZERO)
	jne		scc_set_ea

	jmp		scc_clear_ea
_sls ENDP

;-----------------------------------------------------------------------
;SLT Dn
_slt_dn PROC NEAR
	;N.NOT V + NOT N.V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		scc_set_dn								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		scc_set_dn

	jmp		scc_clear_dn
_slt_dn ENDP

;SLT <ea>
_slt PROC NEAR
	;N.NOT V + NOT N.V
	mov		ebx,eax
	and		ebx,EMU_N+EMU_V							;(SR&NEG) && ((SR&OVERFLOW)==0)
	cmp		ebx,EMU_N
	je		scc_set_ea								;||
	cmp		ebx,EMU_V								;((SR&NEG)==0) && (SR&OVERFLOW)
	je		scc_set_ea

	jmp		scc_clear_ea
_slt ENDP

;-----------------------------------------------------------------------
;SMI Dn
_smi_dn PROC NEAR
	;N
	test	eax,EMU_N								;(SR&NEG)
	jne		scc_set_dn

	jmp		scc_clear_dn
_smi_dn ENDP

;SMI <ea>
_smi PROC NEAR
	;N
	test	eax,EMU_N								;(SR&NEG)
	jne		scc_set_ea

	jmp		scc_clear_ea
_smi ENDP

;-----------------------------------------------------------------------
;SNE Dn
_sne_dn PROC NEAR
	;NOT Z
	test	eax,EMU_Z								;(SR&ZERO)==0
	je		scc_set_dn

	jmp		scc_clear_dn
_sne_dn ENDP

;SNE <ea>
_sne PROC NEAR
	;NOT Z
	test	eax,EMU_Z								;(SR&ZERO)==0
	je		scc_set_ea

	jmp		scc_clear_ea
_sne ENDP

;-----------------------------------------------------------------------
;SPL Dn
_spl_dn PROC NEAR
	;NOT N
	test	eax,EMU_N								;(SR&NEG)==0
	je		scc_set_dn

	jmp		scc_clear_dn
_spl_dn ENDP

;SPL <ea>
_spl PROC NEAR
	;NOT N
	test	eax,EMU_N								;(SR&NEG)==0
	je		scc_set_ea

	jmp		scc_clear_ea
_spl ENDP

;-----------------------------------------------------------------------
;ST Dn
_st_dn PROC NEAR
	jmp		scc_set_dn
_st_dn ENDP

;ST <ea>
_st PROC NEAR
	jmp		scc_set_ea
_st ENDP

;-----------------------------------------------------------------------
;SVC Dn
_svc_dn PROC NEAR
	;NOT V
	test	eax,EMU_V								;(SR&OVERFLOW)==0
	je		scc_set_dn

	jmp		scc_clear_dn
_svc_dn ENDP

;SVC <ea>
_svc PROC NEAR
	;NOT V
	test	eax,EMU_V								;(SR&OVERFLOW)==0
	je		scc_set_ea

	jmp		scc_clear_ea
_svc ENDP

;-----------------------------------------------------------------------
;SVS Dn
_svs_dn PROC NEAR
	;V
	test	eax,EMU_V								;(SR&OVERFLOW)
	jne		scc_set_dn

	jmp		scc_clear_dn
_svs_dn ENDP

;SVS <ea>
_svs PROC NEAR
	;V
	test	eax,EMU_V								;(SR&OVERFLOW)
	jne		scc_set_ea

	jmp		scc_clear_ea
_svs ENDP
