;	WinSTon

;	EORI #<data>,Dn
;	EORI #<data>,<ea>
;	EORI #<data>,ccr
;	EORI #<data>,sr

;	XNZVC
;	-**00

PUBLIC _eori_imm_dn_byte
PUBLIC _eori_imm_dn_word
PUBLIC _eori_imm_dn_long
PUBLIC _eori_imm_ea_byte
PUBLIC _eori_imm_ea_word
PUBLIC _eori_imm_ea_long
PUBLIC _eori_imm_ccr_byte
PUBLIC _eori_imm_sr_word

;-----------------------------------------------------------------------
;EORI.B #<data>,Dn
_eori_imm_dn_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	xor		[edx],bl								;Dest Dn
	SET_NZ
_eori_imm_dn_byte ENDP

;EORI.W #<data>,Dn
_eori_imm_dn_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_BX
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	xor		[edx],bx								;Dest Dn
	SET_NZ
_eori_imm_dn_word ENDP

;EORI.L #<data>,Dn
_eori_imm_dn_long PROC NEAR
	mov		ebx,IMM_LONG[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_LONG							;Increase program counter
	SWAP_ENDIAN_LONG_EBX
	mov		edx,DECODE_1[ecx]						;<ea>
	xor		al,al									;Clear NZVC(ignore X)
	xor		[edx],ebx								;Dest Dn
	SET_NZ
_eori_imm_dn_long ENDP

;-----------------------------------------------------------------------
;EORI.B #<data>,<ea>
_eori_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	xor		bl,dl
	WRITE_BYTE_NZ
_eori_imm_ea_byte ENDP

;EORI.W #<data>,<ea>
_eori_imm_ea_word PROC NEAR
	mov		dx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_DX
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	xor		bx,dx
	WRITE_WORD_NZ
_eori_imm_ea_word ENDP

;EORI.L #<data>,<ea>
_eori_imm_ea_long PROC NEAR
	mov		edx,IMM_LONG[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_LONG							;Increase program counter
	SWAP_ENDIAN_LONG_EDX
	EFFADDR_READ									;Read <ea>
	xor		al,al									;Clear NZVC(ignore X)
	xor		ebx,edx
	WRITE_LONG_NZ
_eori_imm_ea_long ENDP

;-----------------------------------------------------------------------
;EORI.B #<data>,ccr
_eori_imm_ccr_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	shl		ebx,4									;Convert to emulation format
	xor		eax,ebx									;Eor to CCR
	FRET
_eori_imm_ccr_byte ENDP

;-----------------------------------------------------------------------
;EORI.W #<data>,sr
_eori_imm_sr_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase program counter
	SWAP_ENDIAN_WORD_BX
	COMBINE_SR_TO_AX								;Get 'SR' into 'ax'
	xor		eax,ebx									;Eor to SR
	call	asm_check_usersuper_swap				;Write 'eax' to SR, swap modes and return ccodes in 'eax'
	FRET
_eori_imm_sr_word ENDP
