;	WinSTon

;	ADDX Dy,Dx
;	ADDX -(Ay),-(Ax)

;	XNZVC
;	*****

PUBLIC _addx_dn_dn_byte
PUBLIC _addx_dn_dn_word
PUBLIC _addx_dn_dn_long
PUBLIC _addx_an_an_byte
PUBLIC _addx_an_an_word
PUBLIC _addx_an_an_long

;-----------------------------------------------------------------------
;ADDX.B Dy,Dx
_addx_dn_dn_byte PROC NEAR
	mov		edx,DECODE_2[ecx]						;Dy
	mov		bl,BYTE PTR [edx]
	mov		edx,DECODE_1[ecx]						;Dx

	test	eax,EMU_X								;Clears carry
	je		clear_carry
	stc
clear_carry:
	adc		BYTE PTR [edx],bl						;Dx
	SET_NUZV_CX_SAME
_addx_dn_dn_byte ENDP

;ADDX.W Dy,Dx
_addx_dn_dn_word PROC NEAR
	mov		edx,DECODE_2[ecx]						;Dy
	mov		bx,WORD PTR [edx]
	mov		edx,DECODE_1[ecx]						;Dx

	test	eax,EMU_X								;Clears carry
	je		clear_carry
	stc
clear_carry:
	adc		WORD PTR [edx],bx						;Dx
	SET_NUZV_CX_SAME
_addx_dn_dn_word ENDP

;ADDX.L Dy,Dx
_addx_dn_dn_long PROC NEAR
	mov		edx,DECODE_2[ecx]						;Dy
	mov		ebx,DWORD PTR [edx]
	mov		edx,DECODE_1[ecx]						;Dx

	test	eax,EMU_X								;Clears carry
	je		clear_carry
	stc
clear_carry:
	adc		[edx],ebx								;Dx
	SET_NUZV_CX_SAME
_addx_dn_dn_long ENDP

;-----------------------------------------------------------------------
;ADDX.B -(Ay),-(Ax)
_addx_an_an_byte PROC NEAR
	mov		edx,DECODE_2[ecx]
	cmp		edx,OFFSET _Regs+(15*4)
	jl		no_ay_a7								;Is (a7) or (a8)?
	sub		DWORD PTR [edx],SIZE_BYTE				;Yes, add SIZE_WORD
no_ay_a7:
	sub		DWORD PTR [edx],SIZE_BYTE
	mov		ebp,[edx]
	MASK_24BIT_ADDR(ebp)							;as 24-bit address in PC memory
	mov		bl,BYTE PTR _STRam[ebp]					;-(Ay)

	mov		edx,DECODE_1[ecx]
	cmp		edx,OFFSET _Regs+(15*4)
	jl		no_ax_a7								;Is (a7) or (a8)?
	sub		DWORD PTR [edx],SIZE_BYTE				;Yes, add SIZE_WORD
no_ax_a7:
	sub		DWORD PTR [edx],SIZE_BYTE
	mov		ebp,[edx]
	MASK_24BIT_ADDR(ebp)							;as 24-bit address in PC memory
	mov		dl,BYTE PTR _STRam[ebp]					;-(Ax)
		
	test	eax,EMU_X								;Clears carry
	je		clear_carry
	stc
clear_carry:
	adc		dl,bl									;(Ay) + (Ax)
	mov		BYTE PTR _STRam[ebp],dl					;Store
	SET_NUZV_CX_SAME
_addx_an_an_byte ENDP

;ADDX.W -(Ay),-(Ax)
_addx_an_an_word PROC NEAR
	mov		edx,DECODE_2[ecx]
	sub		DWORD PTR [edx],SIZE_WORD
	mov		ebp,[edx]
	MASK_24BIT_ADDR(ebp)							;as 24-bit address in PC memory
	mov		bx,WORD PTR _STRam[ebp]					;-(Ay)
	SWAP_ENDIAN_WORD_BX

	mov		edx,DECODE_1[ecx]
	sub		DWORD PTR [edx],SIZE_WORD
	mov		ebp,[edx]
	MASK_24BIT_ADDR(ebp)							;as 24-bit address in PC memory
	mov		dx,WORD PTR _STRam[ebp]					;-(Ax)
	SWAP_ENDIAN_WORD_DX
		
	test	eax,EMU_X								;Clears carry
	je		clear_carry
	stc
clear_carry:
	adc		dx,bx									;(Ay) + (Ax)
	SWAP_ENDIAN_WORD_DX
	mov		WORD PTR _STRam[ebp],dx					;Store
	SET_NUZV_CX_SAME
_addx_an_an_word ENDP

;ADDX.L -(Ay),-(Ax)
_addx_an_an_long PROC NEAR
	mov		edx,DECODE_2[ecx]
	sub		DWORD PTR [edx],SIZE_LONG
	mov		ebp,[edx]
	MASK_24BIT_ADDR(ebp)							;as 24-bit address in PC memory
	mov		ebx,DWORD PTR _STRam[ebp]				;-(Ay)
	SWAP_ENDIAN_LONG_EBX

	mov		edx,DECODE_1[ecx]
	sub		DWORD PTR [edx],SIZE_LONG
	mov		ebp,[edx]
	MASK_24BIT_ADDR(ebp)							;as 24-bit address in PC memory
	mov		edx,DWORD PTR _STRam[ebp]				;-(Ax)
	SWAP_ENDIAN_LONG_EDX
		
	test	eax,EMU_X								;Clears carry
	je		clear_carry
	stc
clear_carry:
	adc		edx,ebx									;(Ay) + (Ax)
	SWAP_ENDIAN_LONG_EDX
	mov		DWORD PTR _STRam[ebp],edx				;Store
	SET_NUZV_CX_SAME
_addx_an_an_long ENDP
