/*
	WinSTon

	TOS/GEM Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\dialog.h"
#include "..\includes\dsurface.h"
#include "..\includes\file.h"
#include "..\includes\misc.h"

// List of possible GEM extended resolutions(MUST match GEMRES_xxxx)
//static char *pszGEMResolutionItemStrings[] = {
//	"640x480",
//	"800x600",
//	"1024x768",
//	NULL	//term
//};

// List of possible GEM extended colour depths(MUST match GEMCOLOUR_xx)
static char *pszGEMColourItemStrings[] = {
	"2",
	"4",
	"16",
	NULL	//term
};

#define NUM_COLOURITEMSTRINGS	3

static char *pszColourItemStrings[] = {
	"2",
	"4",
	"16",
	NULL	//term
};

// Button IDs
static int GEMResolution_DialogItems[] = {
	IDC_STATIC_GEMRESOLUTIONS,
	IDC_COMBO_GEMRESOLUTIONS,
	IDC_STATIC_GEMCOLOURS,
	IDC_EDIT_GEMCOLOUR,
	IDC_SPIN_GEMCOLOUR,
	0,	//term
};

// List of TOS images for combo box in dialog
char szComboTOSImages[MAX_TOSIMAGE_COMBO_IMAGES][MAX_FILENAME_LENGTH];

static char *pszTOSImagesItemStrings[] = {
	szComboTOSImages[0],
	szComboTOSImages[1],
	szComboTOSImages[2],
	szComboTOSImages[3],
	szComboTOSImages[4],
	szComboTOSImages[5],
	NULL	//term
};

//-----------------------------------------------------------------------
/*
	Set defaults for TOSGEM
*/
void Dialog_TOSGEM_SetDefaults(void)
{
	int i;

	// Set defaults for TOSGEM
	sprintf(ConfigureParams.TOSGEM.szTOSImageFileName,"%s\\TosImages",szWorkingDir);
	for(i=0; i<MAX_TOSIMAGE_COMBO_IMAGES; i++)
		strcpy(szComboTOSImages[i],"");
	strcpy(szComboTOSImages[0],ConfigureParams.TOSGEM.szTOSImageFileName);
	File_AddSlashToEndFileName(ConfigureParams.TOSGEM.szTOSImageFileName);
	ConfigureParams.TOSGEM.bUseTimeDate = FALSE;
	ConfigureParams.TOSGEM.bAccGEMGraphics = FALSE;
	ConfigureParams.TOSGEM.bUseExtGEMResolutions = FALSE;
	ConfigureParams.TOSGEM.nGEMResolution = GEMRES_640x480;
	ConfigureParams.TOSGEM.nGEMColours = GEMCOLOUR_16;
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_TOSGEM_EnableItems(HWND hDlg)
{
	// Turn on all by default
	Dialog_EnableItems(hDlg,GEMResolution_DialogItems,TRUE);

	// Is extended resolutions enabled? If not grey out
	if (!Dialog_ReadButton(hDlg,IDC_RADIO_EXTENDEDRES))
		Dialog_EnableItems(hDlg,GEMResolution_DialogItems,FALSE);
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_TOSGEM_WritePopulate(HWND hDlg)
{
	// Set items
	Dialog_SetComboBoxItems(hDlg,IDC_COMBO_TOSROM,pszTOSImagesItemStrings,0);
	Dialog_SetButton(hDlg,IDC_RADIO_TIMEDATE,DialogParams.TOSGEM.bUseTimeDate);
	Dialog_SetButton(hDlg,IDC_RADIO_ACCGRAPHICS,DialogParams.TOSGEM.bAccGEMGraphics);
	Dialog_SetButton(hDlg,IDC_RADIO_EXTENDEDRES,DialogParams.TOSGEM.bUseExtGEMResolutions);
//	Dialog_SetComboBoxItems(hDlg,IDC_COMBO_GEMRESOLUTIONS,pszGEMResolutionItemStrings,DialogParams.TOSGEM.nGEMResolution);
	Dialog_SetComboBoxItems(hDlg,IDC_COMBO_GEMRESOLUTIONS,pszAvailableVDIModeTextNames,DialogParams.TOSGEM.nGEMResolution);	
	DialogParams.TOSGEM.nGEMColours = Dialog_SetSpinList(hDlg,IDC_EDIT_GEMCOLOUR,IDC_SPIN_GEMCOLOUR,pszColourItemStrings,NUM_COLOURITEMSTRINGS,DialogParams.TOSGEM.nGEMColours);

	Dialog_TOSGEM_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Add TOS image to drop-down combo list
*/
void Dialog_TOSGEM_AddTOSFileName(char *pszFileName)
{
	int i,j;

	// Is already in list?
	for(i=0; i<MAX_TOSIMAGE_COMBO_IMAGES; i++) {
		if (!stricmp(szComboTOSImages[i],pszFileName)) {
			// Found in list, move to top
			for(j=i; j>0; j--)
				strcpy(szComboTOSImages[j],szComboTOSImages[j-1]);
			// Copy to top
			strcpy(szComboTOSImages[0],pszFileName);

			return;
		}
	}

	// Could not find in list, add to top

	// Move all down
	for(i=(MAX_TOSIMAGE_COMBO_IMAGES-1); i>0; i--)
		strcpy(szComboTOSImages[i],szComboTOSImages[i-1]);
	// Add entry
	strcpy(szComboTOSImages[0],pszFileName);
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_TOSGEM_ReadPopulate(HWND hDlg)
{
	// Read items
	Dialog_ReadText(hDlg,IDC_COMBO_TOSROM,DialogParams.TOSGEM.szTOSImageFileName);
	DialogParams.TOSGEM.bUseTimeDate = Dialog_ReadButton(hDlg,IDC_RADIO_TIMEDATE);
	DialogParams.TOSGEM.bAccGEMGraphics = Dialog_ReadButton(hDlg,IDC_RADIO_ACCGRAPHICS);
	DialogParams.TOSGEM.bUseExtGEMResolutions = Dialog_ReadButton(hDlg,IDC_RADIO_EXTENDEDRES);
	DialogParams.TOSGEM.nGEMResolution = Dialog_GetSelectedComboBoxItem(hDlg,IDC_COMBO_GEMRESOLUTIONS);
	DialogParams.TOSGEM.nGEMColours = Dialog_GetSpinList(hDlg,IDC_SPIN_GEMCOLOUR);

	// Check combo for TOS images, to see if 'DialogParams.TOSGEM.szTOSImageFileName' is already in
	Dialog_TOSGEM_AddTOSFileName(DialogParams.TOSGEM.szTOSImageFileName);
}

//-----------------------------------------------------------------------
/*
	Browse for TOS image file (*.*)
*/
void Dialog_TOSGEM_BrowseTOSImageFile(HWND hDlg)
{
	// Browse for file and change edit box if OK
	if (File_OpenSelectDlg(hWnd,DialogParams.TOSGEM.szTOSImageFileName,FILEFILTER_TOSROM,TRUE,FALSE))
		Dialog_SetText(hDlg,IDC_COMBO_TOSROM,DialogParams.TOSGEM.szTOSImageFileName);
}

//-----------------------------------------------------------------------
/*
	TOSGEM Property page handler
*/
BOOL FAR PASCAL Dialog_TOSGEM_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	NMUPDOWN *pUpDown;
	int Offset;

	switch(Message) {
		case WM_INITDIALOG:
			Dialog_TOSGEM_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_TOSGEM;
			return(TRUE);

		case WM_NOTIFY:
			switch(wParam) {
				case IDC_SPIN_GEMCOLOUR:
					pUpDown = (NMUPDOWN *)lParam;
					Offset = Misc_LimitInt(pUpDown->iPos + pUpDown->iDelta, 0,NUM_COLOURITEMSTRINGS-1);
					Dialog_UpdateSpinList(hDlg,IDC_EDIT_GEMCOLOUR,pszColourItemStrings,NUM_COLOURITEMSTRINGS,Offset);
					return(TRUE);
			}

			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_TOSGEM_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\tosgem.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\tosgem.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_RADIO_EXTENDEDRES:
					Dialog_TOSGEM_EnableItems(hDlg);
					return(TRUE);

				case IDC_BUTTON_TOSROM:
					Dialog_TOSGEM_BrowseTOSImageFile(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
