/*
	WinSTon

	RS232 Property Page
*/

#include "..\includes\winston.h"
#include "..\includes\dialog.h"
#include "..\includes\misc.h"

// List of possible COM Ports(MUST match COM_PORT_xxxx)
#define NUM_COMPORTITEMSTRINGS	4
static char *pszComPortItemStrings[] = {
	"COM 1",
	"COM 2",
	"COM 3",
	"COM 4",
	NULL	//term
};

// Button IDs
static int AllRS232_DialogItems[] = {
	IDC_STATIC_COMPORT,
	IDC_EDIT_COMPORT,
	IDC_SPIN_COMPORT,
	0,	//term
};

//-----------------------------------------------------------------------
/*
	Set defaults for RS232
*/
void Dialog_RS232_SetDefaults(void)
{
	// Set defaults for RS232
	ConfigureParams.RS232.bEnableRS232 = FALSE;
	ConfigureParams.RS232.nCOMPort = COM_PORT_1;
}

//-----------------------------------------------------------------------
/*
	Enable item according to options states
*/
void Dialog_RS232_EnableItems(HWND hDlg)
{
	// Turn on all by default
	Dialog_EnableItems(hDlg,AllRS232_DialogItems,TRUE);

	// Is RS232 enabled? If not grey out
	if (!Dialog_ReadButton(hDlg,IDC_RADIO_ENABLERS232))
		Dialog_EnableItems(hDlg,AllRS232_DialogItems,FALSE);
}

//-----------------------------------------------------------------------
/*
	Write settings into dialog page
*/
void Dialog_RS232_WritePopulate(HWND hDlg)
{
	// Set items
	Dialog_SetButton(hDlg,IDC_RADIO_ENABLERS232,DialogParams.RS232.bEnableRS232);
	Dialog_SetSpinList(hDlg,IDC_EDIT_COMPORT,IDC_SPIN_COMPORT,pszComPortItemStrings,NUM_COMPORTITEMSTRINGS,DialogParams.RS232.nCOMPort);

	Dialog_RS232_EnableItems(hDlg);

	bOKDialog = TRUE;
}

//-----------------------------------------------------------------------
/*
	Read settings back from dialog page
*/
void Dialog_RS232_ReadPopulate(HWND hDlg)
{
	// Read items
	DialogParams.RS232.bEnableRS232 = Dialog_ReadButton(hDlg,IDC_RADIO_ENABLERS232);
	DialogParams.RS232.nCOMPort = Dialog_GetSpinList(hDlg,IDC_SPIN_COMPORT);
}

//-----------------------------------------------------------------------
/*
	RS232 Property page handler
*/
BOOL FAR PASCAL Dialog_RS232_DlgProc(HWND hDlg, UINT Message, UINT wParam, LONG lParam)
{
	NMUPDOWN *pUpDown;
	int Offset;

	switch(Message) {
		case WM_INITDIALOG:
			Dialog_RS232_WritePopulate(hDlg);
			nLastOpenPage = DIALOG_PAGE_RS232;
			return(TRUE);

		case WM_NOTIFY:
			switch(wParam) {
				case IDC_SPIN_COMPORT:
					pUpDown = (NMUPDOWN *)lParam;
					Offset = Misc_LimitInt(pUpDown->iPos + pUpDown->iDelta, 0,NUM_COMPORTITEMSTRINGS-1);
					Dialog_UpdateSpinList(hDlg,IDC_EDIT_COMPORT,pszComPortItemStrings,NUM_COMPORTITEMSTRINGS,Offset);
					return(TRUE);
			}

			switch(((NMHDR *)lParam)->code) {
				case PSN_APPLY:
					Dialog_RS232_ReadPopulate(hDlg);
					return(TRUE);
				case PSN_HELP:
					WinSTon_GoWeb("help\\options\\rs232.html",FALSE);
					return(TRUE);
			}
			break;

		case WM_HELP:
			// Open help
			WinSTon_GoWeb("help\\options\\rs232.html",FALSE);
			return(TRUE);

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_RADIO_ENABLERS232:
					Dialog_RS232_EnableItems(hDlg);
					return(TRUE);
			}
			break;
	}

	return(FALSE);	// Not Processed!
}
