/*
	WinSTon

	Video Tab Control
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\debugger.h"
#include "..\includes\debuggertab.h"
#include "..\includes\decode.h"
#include "..\includes\dialog.h"
#include "..\includes\int.h"
#include "..\includes\stmemory.h"
#include "..\includes\video.h"

#ifdef USE_DEBUGGER

//-----------------------------------------------------------------------
/*
	Init Video Tab Control
*/
void Debugger_TabVideo_Init(HWND hWnd)
{

}

//-----------------------------------------------------------------------
/*
	Show Video Tab Control
*/
void Debugger_TabVideo_ShowPage(HWND hWnd,BOOL bShow)
{
	// NOTE : Control IDs must be consecutive in resource editor! Ie hand-edited
	Dialog_ShowItemRange(hWnd,IDC_TABVIDEO_EDIT_SYNC,IDC_TABVIDEO_TEXT_HBL,bShow ? SW_SHOW:SW_HIDE);
}

//-----------------------------------------------------------------------
/*
	Update Video Tab Control
*/
void Debugger_TabVideo_UpdateDisplay(HWND hWnd)
{
	char szString[256];

	// Show hardware video bytes
	sprintf(szString,"$%2.2X",VideoSyncByte);
	Dialog_SetText(hWnd,IDC_TABVIDEO_EDIT_SYNC,szString);
	sprintf(szString,"$%2.2X",VideoShifterByte);
	Dialog_SetText(hWnd,IDC_TABVIDEO_EDIT_SHIFTER,szString);

	// And video address(and VAP) and Cycles/HBL into display
	sprintf(szString,"$%8.8X",VideoBase&0xffffff);
	Dialog_SetText(hWnd,IDC_TABVIDEO_EDIT_VIDEOADDRESS,szString);
	sprintf(szString,"%d",Int_FindFrameCycles());
	Dialog_SetText(hWnd,IDC_TABVIDEO_EDIT_CYCLES,szString);
	Video_CalculateAddress();
	sprintf(szString,"$%8.8X",VideoAddress&0xffffff);
	Dialog_SetText(hWnd,IDC_TABVIDEO_EDIT_VAP,szString);
	sprintf(szString,"%d",nHBL);
	Dialog_SetText(hWnd,IDC_TABVIDEO_EDIT_HBL,szString);
}

#endif	//USE_DEBUGGER
