/*
	WinSTon

	Memory Tab Control
*/

#include "..\includes\winston.h"
#include "..\includes\debug.h"
#include "..\includes\debugger.h"
#include "..\includes\debuggertab.h"
#include "..\includes\decode.h"
#include "..\includes\dialog.h"
#include "..\includes\mfp.h"
#include "..\includes\stmemory.h"

#ifdef USE_DEBUGGER

//-----------------------------------------------------------------------
/*
	Init MFP Tab Control
*/
void Debugger_TabMFP_Init(HWND hWnd)
{

}

//-----------------------------------------------------------------------
/*
	Show MFP Tab Control
*/
void Debugger_TabMFP_ShowPage(HWND hWnd,BOOL bShow)
{
	// NOTE : Control IDs must be consecutive in resource editor! Ie hand-edited
	Dialog_ShowItemRange(hWnd,IDC_TABMFP_EDIT_GPIP,IDC_TABMFP_RADIO_MASKED_TIMERD,bShow ? SW_SHOW:SW_HIDE);
}

//-----------------------------------------------------------------------
/*
	Read MFP timers
*/
unsigned char Debugger_TabMFP_ReadTimerA(void)
{
	// Is timer on?
	if (MFP_TACR!=0x0) {
		if (MFP_TACR!=0x8)								// Event mode?
			MFP_ReadTimerA_Execute();
	}
	return(MFP_TA_MAINCOUNTER);
}

unsigned char Debugger_TabMFP_ReadTimerB(void)
{
	// Is timer on?
	if (MFP_TBCR!=0x0) {
		if (MFP_TBCR!=0x8)								// Event mode?
			MFP_ReadTimerB_Execute();
	}
	return(MFP_TB_MAINCOUNTER);
}

unsigned char Debugger_TabMFP_ReadTimerC(void)
{
	// Is timer on?
	if (MFP_TCDCR&0x70)
		MFP_ReadTimerC_Execute();
	return(MFP_TC_MAINCOUNTER);
}

unsigned char Debugger_TabMFP_ReadTimerD(void)
{
	// Is timer on?
	if (MFP_TCDCR&0x07)
		MFP_ReadTimerD_Execute();
	return(MFP_TD_MAINCOUNTER);
}

//-----------------------------------------------------------------------
/*
	Update MFP Tab Control
*/
void Debugger_TabMFP_UpdateDisplay(HWND hWnd)
{
	char szString[256];

	// Addresses
	sprintf(szString,"%2.2X",MFP_GPIP);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_GPIP,szString);
	sprintf(szString,"%2.2X",MFP_AER);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_AER,szString);
	sprintf(szString,"%2.2X",MFP_DDR);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_DDR,szString);

	sprintf(szString,"%2.2X",MFP_IERA);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_IERA,szString);
	sprintf(szString,"%2.2X",MFP_IERB);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_IERB,szString);
	sprintf(szString,"%2.2X",MFP_IPRA);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_IPRA,szString);
	sprintf(szString,"%2.2X",MFP_IPRB);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_IPRB,szString);

	sprintf(szString,"%2.2X",MFP_ISRA);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_ISRA,szString);
	sprintf(szString,"%2.2X",MFP_ISRB);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_ISRB,szString);
	sprintf(szString,"%2.2X",MFP_IMRA);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_IMRA,szString);
	sprintf(szString,"%2.2X",MFP_IMRB);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_IMRB,szString);

	sprintf(szString,"%2.2X",MFP_VR);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_VR,szString);
	sprintf(szString,"%2.2X",MFP_TACR);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_TACR,szString);
	sprintf(szString,"%2.2X",MFP_TBCR);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_TBCR,szString);
	sprintf(szString,"%2.2X",MFP_TCDCR);
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_TCDCR,szString);

	sprintf(szString,"%2.2X(%2.2X)",MFP_TADR,Debugger_TabMFP_ReadTimerA());
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_TADR,szString);
	sprintf(szString,"%2.2X(%2.2X)",MFP_TBDR,Debugger_TabMFP_ReadTimerB());
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_TBDR,szString);
	sprintf(szString,"%2.2X(%2.2X)",MFP_TCDR,Debugger_TabMFP_ReadTimerC());
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_TCDR,szString);
	sprintf(szString,"%2.2X(%2.2X)",MFP_TDDR,Debugger_TabMFP_ReadTimerD());
	Dialog_SetText(hWnd,IDC_TABMFP_EDIT_TDDR,szString);

	// Radio buttons
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_ENABLED_FDC,(MFP_IERB&MFP_FDCHDC_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_PENDING_FDC,(MFP_IPRB&MFP_FDCHDC_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_INSERVICE_FDC,(MFP_ISRB&MFP_FDCHDC_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_MASKED_FDC,(MFP_IMRB&MFP_FDCHDC_BIT) ? TRUE:FALSE);

	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_ENABLED_KEYBOARD,(MFP_IERB&MFP_KEYBOARD_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_PENDING_KEYBOARD,(MFP_IPRB&MFP_KEYBOARD_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_INSERVICE_KEYBOARD,(MFP_ISRB&MFP_KEYBOARD_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_MASKED_KEYBOARD,(MFP_IMRB&MFP_KEYBOARD_BIT) ? TRUE:FALSE);

	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_ENABLED_TIMERA,(MFP_IERA&MFP_TIMER_A_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_PENDING_TIMERA,(MFP_IPRA&MFP_TIMER_A_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_INSERVICE_TIMERA,(MFP_ISRA&MFP_TIMER_A_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_MASKED_TIMERA,(MFP_IMRA&MFP_TIMER_A_BIT) ? TRUE:FALSE);

	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_ENABLED_TIMERB,(MFP_IERA&MFP_TIMER_B_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_PENDING_TIMERB,(MFP_IPRA&MFP_TIMER_B_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_INSERVICE_TIMERB,(MFP_ISRA&MFP_TIMER_B_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_MASKED_TIMERB,(MFP_IMRA&MFP_TIMER_B_BIT) ? TRUE:FALSE);

	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_ENABLED_TIMERC,(MFP_IERB&MFP_TIMER_C_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_PENDING_TIMERC,(MFP_IPRB&MFP_TIMER_C_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_INSERVICE_TIMERC,(MFP_ISRB&MFP_TIMER_C_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_MASKED_TIMERC,(MFP_IMRB&MFP_TIMER_C_BIT) ? TRUE:FALSE);

	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_ENABLED_TIMERD,(MFP_IERB&MFP_TIMER_D_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_PENDING_TIMERD,(MFP_IPRB&MFP_TIMER_D_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_INSERVICE_TIMERD,(MFP_ISRB&MFP_TIMER_D_BIT) ? TRUE:FALSE);
	Dialog_SetButton(hWnd,IDC_TABMFP_RADIO_MASKED_TIMERD,(MFP_IMRB&MFP_TIMER_D_BIT) ? TRUE:FALSE);
}

#endif	//USE_DEBUGGER
