;	WinSTon

;	MOVE <ea>,Dn
;	MOVE <ea>,(An)
;	MOVE <ea>,(An)+
;	MOVE <ea>,-(An)
;	MOVE <ea>,(d16,An)
;	MOVE <ea>,(d8,An,Xn)
;	MOVE <ea>,(xxx).W
;	MOVE <ea>,(xxx).L
;	MOVE USP,An
;	MOVE An,USP
;	MOVE CCR,Dn
;	MOVE CCR,<ea>
;	MOVE <ea>,CCR
;	MOVE SR,Dn
;	MOVE SR,<ea>
;	MOVE <ea>,SR

;	XNZVC
;	-**00

PUBLIC _move_ea_000_byte
PUBLIC _move_ea_000_word
PUBLIC _move_ea_000_long
PUBLIC _move_ea_010_byte
PUBLIC _move_ea_010_word
PUBLIC _move_ea_010_long
PUBLIC _move_ea_011_byte
PUBLIC _move_ea_011_byte_A7
PUBLIC _move_ea_011_word
PUBLIC _move_ea_011_long
PUBLIC _move_ea_100_byte
PUBLIC _move_ea_100_byte_A7
PUBLIC _move_ea_100_word
PUBLIC _move_ea_100_long
PUBLIC _move_ea_101_byte
PUBLIC _move_ea_101_word
PUBLIC _move_ea_101_long
PUBLIC _move_ea_110_byte
PUBLIC _move_ea_110_word
PUBLIC _move_ea_110_long
PUBLIC _move_ea_111_000_byte
PUBLIC _move_ea_111_000_word
PUBLIC _move_ea_111_000_long
PUBLIC _move_ea_111_001_byte
PUBLIC _move_ea_111_001_word
PUBLIC _move_ea_111_001_long
PUBLIC _move_usp_an_long
PUBLIC _move_an_usp_long
PUBLIC _move_ea_ccr_word
PUBLIC _move_sr_dn_word
PUBLIC _move_sr_ea_word
PUBLIC _move_ea_sr_word

;-----------------------------------------------------------------------
;
;Write Dn, pass 'ebx' as value(cannot be corrupted)
;
effaddr_write_000_byte MACRO
	mov		edx,DECODE_2[ecx]						;DReg
	mov		[edx],bl								;Dest Dn
	ENDM
effaddr_write_000_word MACRO
	mov		edx,DECODE_2[ecx]						;DReg
	mov		[edx],bx								;Dest Dn
	ENDM
effaddr_write_000_long MACRO
	mov		edx,DECODE_2[ecx]						;DReg
	mov		[edx],ebx								;Dest Dn
	ENDM

;-----------------------------------------------------------------------
;
;Write (An), pass 'ebx' as value(cannot be corrupted)
;
effaddr_write_010_byte MACRO
	mov		edx,DECODE_2[ecx]						;(An)
	mov		ebp,[edx]								;Look up contents
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_010_word MACRO
	mov		edx,DECODE_2[ecx]						;(An)
	mov		ebp,[edx]								;Look up contents
	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_010_long MACRO
	mov		edx,DECODE_2[ecx]						;(An)
	mov		ebp,[edx]								;Look up contents
	INTERCEPT_CHECK_ADDR_WRITELONG					;Write 'ebx' to 'ebp', corrupts 'ecx'
	ENDM

;-----------------------------------------------------------------------
;
;Write (An)+, pass 'ebx' as value(cannot be corrupted)
;
effaddr_write_011_byte MACRO
	mov		edx,DECODE_2[ecx]						;(An)+
	mov		ebp,[edx]								;Look up contents
	add		DWORD PTR [edx],SIZE_BYTE
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_011_byte_A7 MACRO
	mov		edx,DECODE_2[ecx]						;(An)+
	mov		ebp,[edx]								;Look up contents
	add		DWORD PTR [edx],SIZE_WORD				;Increment by WORD for A7
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_011_word MACRO
	mov		edx,DECODE_2[ecx]						;(An)+
	mov		ebp,[edx]								;Look up contents
	add		DWORD PTR [edx],SIZE_WORD
	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_011_long MACRO
	mov		edx,DECODE_2[ecx]						;(An)+
	mov		ebp,[edx]								;Look up contents
	add		DWORD PTR [edx],SIZE_LONG
	INTERCEPT_CHECK_ADDR_WRITELONG					;Write 'ebx' to 'ebp', corrupts 'ecx'
	ENDM

;-----------------------------------------------------------------------
;
;Write -(An), pass 'ebx' as value(cannot be corrupted)
;
effaddr_write_100_byte MACRO
	mov		edx,DECODE_2[ecx]						;-(An)
	sub		DWORD PTR [edx],SIZE_BYTE
	mov		ebp,[edx]								;Look up contents
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_100_byte_A7 MACRO
	mov		edx,DECODE_2[ecx]						;-(An)
	sub		DWORD PTR [edx],SIZE_WORD				;Decrement by WORD for A7
	mov		ebp,[edx]								;Look up contents
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_100_word MACRO
	mov		edx,DECODE_2[ecx]						;-(An)
	sub		DWORD PTR [edx],SIZE_WORD
	mov		ebp,[edx]								;Look up contents
	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_100_long MACRO
	mov		edx,DECODE_2[ecx]						;-(An)
	sub		DWORD PTR [edx],SIZE_LONG
	mov		ebp,[edx]								;Look up contents
	INTERCEPT_CHECK_ADDR_WRITELONG					;Write 'ebx' to 'ebp', corrupts 'ecx'
	ENDM

;-----------------------------------------------------------------------
;
;Write (d16,An), pass 'ebx' as value(cannot be corrupted)
;
effaddr_write_101_byte MACRO
	mov		dx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_DX
	movsx	edx,dx									;d16 - signed offset
	mov		ebp,DECODE_2[ecx]						;An
	mov		ebp,[ebp]								;Look up contents
	add		ebp,edx									;Add offset
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_101_word MACRO
	mov		dx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_DX
	movsx	edx,dx									;d16 - signed offset
	mov		ebp,DECODE_2[ecx]						;An
	mov		ebp,[ebp]								;Look up contents
	add		ebp,edx									;Add offset
	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_101_long MACRO
	mov		dx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_DX
	movsx	edx,dx									;d16 - signed offset
	mov		ebp,DECODE_2[ecx]						;An
	mov		ebp,[ebp]								;Look up contents
	add		ebp,edx									;Add offset
	INTERCEPT_CHECK_ADDR_WRITELONG					;Write 'ebx' to 'ebp', corrupts 'ecx'
	ENDM

;-----------------------------------------------------------------------
;
;Write (d8,An,Xn), pass 'ebx' as value(cannot be corrupted)
;
effaddr_write_110_byte MACRO
	movsx	edx,WORD PTR IMM_WORD[esi]				;Immediate, RRRRw000dddddddd(d's in high byte, sign extented)
	mov		ebp,edx									;Copy immediate
	shr		ebp,2
	and		ebp,03ch								;Offset register(*4)
	test	edx,00008h								;Bit 11, 0-.W or 1-.L (NOTE - endian wrong way!)
	je		word_offset
	mov		ebp,_Regs[ebp]							;Xn.L
	jmp		got_offset
word_offset:
	movsx	ebp,WORD PTR _Regs[ebp]					;Xn.W signed extended
got_offset:

	mov		edx,DECODE_2[ecx]						;An
	add		ebp,[edx]								;Look up contents

	movsx	edx,WORD PTR IMM_WORD[esi]				;Immediate, RRRRw000dddddddd(d's in high byte, sign extented)
	add		esi,SIZE_WORD                           ;Increase Program Counter
	sar		edx,8									;8-bit displacement signed offset
	add		ebp,edx
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_110_word MACRO
	movsx	edx,WORD PTR IMM_WORD[esi]				;Immediate, RRRRw000dddddddd(d's in high byte, sign extented)
	mov		ebp,edx									;Copy immediate
	shr		ebp,2
	and		ebp,03ch								;Offset register(*4)
	test	edx,00008h								;Bit 11, 0-.W or 1-.L (NOTE - endian wrong way!)
	je		word_offset
	mov		ebp,_Regs[ebp]							;Xn.L
	jmp		got_offset
word_offset:
	movsx	ebp,WORD PTR _Regs[ebp]					;Xn.W signed extended
got_offset:

	mov		edx,DECODE_2[ecx]						;An
	add		ebp,[edx]								;Look up contents

	movsx	edx,WORD PTR IMM_WORD[esi]				;Immediate, RRRRw000dddddddd(d's in high byte, sign extented)
	add		esi,SIZE_WORD                           ;Increase Program Counter
	sar		edx,8									;8-bit displacement signed offset
	add		ebp,edx
	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_110_long MACRO
	movsx	edx,WORD PTR IMM_WORD[esi]				;Immediate, RRRRw000dddddddd(d's in high byte, sign extented)
	mov		ebp,edx									;Copy immediate
	shr		ebp,2
	and		ebp,03ch								;Offset register(*4)
	test	edx,00008h								;Bit 11, 0-.W or 1-.L (NOTE - endian wrong way!)
	je		word_offset
	mov		ebp,_Regs[ebp]							;Xn.L
	jmp		got_offset
word_offset:
	movsx	ebp,WORD PTR _Regs[ebp]					;Xn.W signed extended
got_offset:

	mov		edx,DECODE_2[ecx]						;An
	add		ebp,[edx]								;Look up contents

	movsx	edx,WORD PTR IMM_WORD[esi]				;Immediate, RRRRw000dddddddd(d's in high byte, sign extented)
	add		esi,SIZE_WORD                           ;Increase Program Counter
	sar		edx,8									;8-bit displacement signed offset
	add		ebp,edx
	INTERCEPT_CHECK_ADDR_WRITELONG					;Write 'ebx' to 'ebp', corrupts 'ecx'
	ENDM

;-----------------------------------------------------------------------
;
;Write (xxx).W, pass 'ebx' as value(cannot be corrupted)
;
effaddr_write_111_000_byte MACRO
	mov		dx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD				            ;Inc Program Counter
	SWAP_ENDIAN_WORD_DX
	movsx	ebp,dx								    ;d16 - signed offset

	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_111_000_word MACRO
	mov		dx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD				            ;Inc Program Counter
	SWAP_ENDIAN_WORD_DX
	movsx	ebp,dx								    ;d16 - signed offset

	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_111_000_long MACRO
	mov		dx,IMM_WORD[esi]						;Read immediate
	add		esi,SIZE_WORD				            ;Inc Program Counter
	SWAP_ENDIAN_WORD_DX
	movsx	ebp,dx								    ;d16 - signed offset

	INTERCEPT_CHECK_ADDR_WRITELONG					;Write 'ebx' to 'ebp', corrupts 'ecx'
	ENDM

;-----------------------------------------------------------------------
;
;Write (xxx).L, pass 'ebx' as value(cannot be corrupted)
;
effaddr_write_111_001_byte MACRO
	mov		ebp,IMM_LONG[esi]						;Read immediate
	add		esi,SIZE_LONG				            ;Inc Program Counter
	bswap	ebp										;Swap endian on address register

	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_111_001_word MACRO
	mov		ebp,IMM_LONG[esi]						;Read immediate
	add		esi,SIZE_LONG				            ;Inc Program Counter
	bswap	ebp										;Swap endian on address register

	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	ENDM

effaddr_write_111_001_long MACRO
	mov		ebp,IMM_LONG[esi]						;Read immediate
	add		esi,SIZE_LONG				            ;Inc Program Counter
	bswap	ebp										;Swap endian on address register

	INTERCEPT_CHECK_ADDR_WRITELONG					;Write 'ebx' to 'ebp', corrupts 'ecx'
	ENDM




;-----------------------------------------------------------------------
;MOVE.B <ea>,Dn
_move_ea_000_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_000_byte							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_000_byte ENDP

;MOVE.W <ea>,Dn
_move_ea_000_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_000_word							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,bx									;Set condition codes
	SET_NZ
_move_ea_000_word ENDP

;MOVE.L <ea>,Dn
_move_ea_000_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_000_long							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,ebx									;Set condition codes
	SET_NZ
_move_ea_000_long ENDP

;-----------------------------------------------------------------------
;MOVE.B <ea>,(An)
_move_ea_010_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_010_byte							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_010_byte ENDP

;MOVE.W <ea>,(An)
_move_ea_010_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_010_word							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,bx									;Set condition codes
	SET_NZ
_move_ea_010_word ENDP

;MOVE.L <ea>,(An)
_move_ea_010_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_010_long							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,ebx									;Set condition codes
	SET_NZ
_move_ea_010_long ENDP

;-----------------------------------------------------------------------
;MOVE.B <ea>,(An)+
_move_ea_011_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_011_byte							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_011_byte ENDP

;MOVE.B <ea>,(A7)+
_move_ea_011_byte_A7 PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_011_byte_A7						;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_011_byte_A7 ENDP

;MOVE.W <ea>,(An)+
_move_ea_011_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_011_word							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,bx									;Set condition codes
	SET_NZ
_move_ea_011_word ENDP

;MOVE.L <ea>,(An)+
_move_ea_011_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_011_long							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,ebx									;Set condition codes
	SET_NZ
_move_ea_011_long ENDP

;-----------------------------------------------------------------------
;MOVE.B <ea>,-(An)
_move_ea_100_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_100_byte							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_100_byte ENDP

;MOVE.B <ea>,-(A7)
_move_ea_100_byte_A7 PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_100_byte_A7						;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_100_byte_A7 ENDP

;MOVE.W <ea>,-(An)
_move_ea_100_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_100_word							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,bx									;Set condition codes
	SET_NZ
_move_ea_100_word ENDP

;MOVE.L <ea>,-(An)
_move_ea_100_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_100_long							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,ebx									;Set condition codes
	SET_NZ
_move_ea_100_long ENDP

;-----------------------------------------------------------------------
;MOVE.B <ea>,(d16,An)
_move_ea_101_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_101_byte							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_101_byte ENDP

;MOVE.W <ea>,(d16,An)
_move_ea_101_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_101_word							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,bx									;Set condition codes
	SET_NZ
_move_ea_101_word ENDP

;MOVE.L <ea>,(d16,An)
_move_ea_101_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_101_long							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,ebx									;Set condition codes
	SET_NZ
_move_ea_101_long ENDP

;-----------------------------------------------------------------------
;MOVE.B <ea>,(d8,An,Xn)
_move_ea_110_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_110_byte							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_110_byte ENDP

;MOVE.W <ea>,(d8,An,Xn)
_move_ea_110_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_110_word							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,bx									;Set condition codes
	SET_NZ
_move_ea_110_word ENDP

;MOVE.L <ea>,(d8,An,Xn)
_move_ea_110_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_110_long							;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,ebx									;Set condition codes
	SET_NZ
_move_ea_110_long ENDP

;-----------------------------------------------------------------------
;MOVE.B <ea>,(xxx).W
_move_ea_111_000_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_111_000_byte						;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_111_000_byte ENDP

;MOVE.W <ea>,(xxx).W
_move_ea_111_000_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_111_000_word						;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,bx									;Set condition codes
	SET_NZ
_move_ea_111_000_word ENDP

;MOVE.L <ea>,(xxx).W
_move_ea_111_000_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_111_000_long						;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,ebx									;Set condition codes
	SET_NZ
_move_ea_111_000_long ENDP

;-----------------------------------------------------------------------
;MOVE.B <ea>,(xxx).L
_move_ea_111_001_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_111_001_byte						;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bl,bl									;Set condition codes
	SET_NZ
_move_ea_111_001_byte ENDP

;MOVE.W <ea>,(xxx).L
_move_ea_111_001_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_111_001_word						;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		bx,bx									;Set condition codes
	SET_NZ
_move_ea_111_001_word ENDP

;MOVE.L <ea>,(xxx).L
_move_ea_111_001_long PROC NEAR
	EFFADDR_READ									;Read <ea>
	effaddr_write_111_001_long						;Store
	xor		al,al									;Clear NZVC(ignore X)
	or		ebx,ebx									;Set condition codes
	SET_NZ
_move_ea_111_001_long ENDP

;-----------------------------------------------------------------------
;MOVE.L USP,An
_move_usp_an_long PROC NEAR
	mov		ebx,[_Reg_UserSP]						;USP (Reg_A7 or Reg_A8)
	mov		ebx,[ebx]
	mov		edx,DECODE_1[ecx]
	mov		[edx],ebx								;Store to An
	FRET
_move_usp_an_long ENDP

;MOVE.L An,USP
_move_an_usp_long PROC NEAR
	mov		ebx,DECODE_1[ecx]
	mov		ebx,[ebx]								;An
	mov		edx,[_Reg_UserSP]
	mov		[edx],ebx								;Store to USP (Reg_A7 or Reg_A8)
	FRET
_move_an_usp_long ENDP

;-----------------------------------------------------------------------
;MOVE.W <ea>,CCR
_move_ea_ccr_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	mov		eax,ebx
	shl		eax,4									;Put ccodes back into emulation format
	FRET
_move_ea_ccr_word ENDP

;-----------------------------------------------------------------------
;MOVE.W SR,Dn
_move_sr_dn_word PROC NEAR
	COMBINE_SR_TO_AX								;Get 'SR' into 'ax', corrupts 'ecx'
	mov		edx,DECODE_1[ecx]
	mov		[edx],ax								;Store to Dn
	shl		eax,4									;Put ccodes back into emulation format
	FRET
_move_sr_dn_word ENDP

;MOVE.W SR,<ea>
_move_sr_ea_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	COMBINE_SR_TO_AX								;Get 'SR' into 'ax', corrupts 'ecx'
	mov		ebx,eax									;Copy for write back
	shl		eax,4									;Put ccodes back into emulation format
	INTERCEPT_CHECK_ADDR_WRITEWORD					;Write 'bx' to 'ebp', corrupts 'ecx'
	FRET
_move_sr_ea_word ENDP

;-----------------------------------------------------------------------
;MOVE.W <ea>,SR
_move_ea_sr_word PROC NEAR
	EFFADDR_READ									;Read <ea>
	mov		eax,ebx									;Store to SR
	call	asm_check_usersuper_swap				;Write 'eax' to SR, swap modes and return ccodes in 'eax'
	FRET
_move_ea_sr_word ENDP
