;	WinSTon

;	CMPI #<data>,Dn
;	CMPI #<data>,<ea>

;	XNZVC
;	-****

PUBLIC _cmpi_imm_dn_byte
PUBLIC _cmpi_imm_dn_word
PUBLIC _cmpi_imm_dn_long
PUBLIC _cmpi_imm_ea_byte
PUBLIC _cmpi_imm_ea_word
PUBLIC _cmpi_imm_ea_long

;-----------------------------------------------------------------------
;CMPI.B #<data>,Dn
_cmpi_imm_dn_byte PROC NEAR
	mov		bl,IMM_BYTE[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase Program Counter
	mov		edx,DECODE_1[ecx]						;<ea>
	cmp		[edx],bl								;Compare, set condition codes
	SET_NZVC
_cmpi_imm_dn_byte ENDP

;CMPI.W #<data>,Dn
_cmpi_imm_dn_word PROC NEAR
	mov		bx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_BX
	mov		edx,DECODE_1[ecx]						;<ea>
	cmp		[edx],bx								;Compare, set condition codes
	SET_NZVC
_cmpi_imm_dn_word ENDP

;CMPI.L #<data>,Dn
_cmpi_imm_dn_long PROC NEAR
	mov		ebx,IMM_LONG[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_LONG							;Increase Program Counter
	SWAP_ENDIAN_LONG_EBX
	mov		edx,DECODE_1[ecx]						;<ea>
	cmp		[edx],ebx								;Compare, set condition codes
	SET_NZVC
_cmpi_imm_dn_long ENDP

;-----------------------------------------------------------------------
;CMPI.B #<data>,<ea>
_cmpi_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase Program Counter
	EFFADDR_READ									;Read <ea>
	cmp		bl,dl									;Compare, set condition codes
	SET_NZVC
_cmpi_imm_ea_byte ENDP

;CMPI.W #<data>,<ea>
_cmpi_imm_ea_word PROC NEAR
	mov		dx,IMM_WORD[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_WORD							;Increase Program Counter
	SWAP_ENDIAN_WORD_DX
	EFFADDR_READ									;Read <ea>
	cmp		bx,dx									;Compare, set condition codes
	SET_NZVC
_cmpi_imm_ea_word ENDP

;CMPI.L #<data>,<ea>
_cmpi_imm_ea_long PROC NEAR
	mov		edx,IMM_LONG[esi]						;Immediate data (wrong endian)
	add		esi,SIZE_LONG							;Increase Program Counter
	SWAP_ENDIAN_LONG_EDX
	EFFADDR_READ									;Read <ea>
	cmp		ebx,edx									;Compare, set condition codes
	SET_NZVC
_cmpi_imm_ea_long ENDP
