;	WinSTon

;	BTST Dn,Dn
;	BTST Dn,<ea>
;	BTST #<data>,Dn
;	BTST #<data>,<ea>

;	XNZVC
;	--*--

PUBLIC _btst_dn_dn_long
PUBLIC _btst_dn_ea_byte
PUBLIC _btst_imm_dn_long
PUBLIC _btst_imm_ea_byte

;-----------------------------------------------------------------------
;BTST.L Dn,Dn
_btst_dn_dn_long PROC NEAR
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		edx,DECODE_2[ecx]						;DReg
	mov		ebx,[edx]
	and		ebx,31									;Modulo 32

	mov		edx,DECODE_1[ecx]						;<ea>
	bt		[edx],ebx								;Test(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	FRET
_btst_dn_dn_long ENDP

;-----------------------------------------------------------------------
;BTST.B Dn,<ea>
_btst_dn_ea_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		edx,DECODE_2[ecx]						;DReg
	mov		edx,[edx]
	and		edx,07h									;Modulo 8

	bt		ebx,edx									;Test(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_btst_dn_ea_byte ENDP

;-----------------------------------------------------------------------
;BTST.L #<data>,Dn
_btst_imm_dn_long PROC NEAR
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	and		ebx,31									;Modulo 32

	mov		edx,DECODE_1[ecx]						;<ea>
	bt		[edx],ebx								;Test(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	FRET
_btst_imm_dn_long ENDP

;-----------------------------------------------------------------------
;BTST.B #<data>,<ea>
_btst_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter

	EFFADDR_READ									;Read <ea>
	and		eax,EMU_CLEAR_Z							;Set default condition code
	and		edx,07h									;Modulo 8

	bt		ebx,edx									;Test(into carry)
	jc		clear
	or		al,EMU_Z
clear:;
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_btst_imm_ea_byte ENDP
