;	WinSTon

;	BCLR Dn,Dn
;	BCLR Dn,<ea>
;	BCLR #<data>,Dn
;	BCLR #<data>,<ea>

;	XNZVC
;	--*--

PUBLIC _bclr_dn_dn_long
PUBLIC _bclr_dn_ea_byte
PUBLIC _bclr_imm_dn_long
PUBLIC _bclr_imm_ea_byte

;-----------------------------------------------------------------------
;BCLR.L Dn,Dn
_bclr_dn_dn_long PROC NEAR
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		edx,DECODE_2[ecx]						;DReg
	mov		ebx,[edx]
	and		ebx,31									;Modulo 32

	mov		edx,DECODE_1[ecx]						;DReg
	btr		[edx],ebx								;Test(into carry) and clear
	jc		clear
	or		al,EMU_Z
clear:;
	FRET
_bclr_dn_dn_long ENDP

;-----------------------------------------------------------------------
;BCLR.B Dn,<ea>
_bclr_dn_ea_byte PROC NEAR
	EFFADDR_READ									;Read <ea>
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		edx,DECODE_2[ecx]						;DReg
	mov		edx,[edx]
	and		edx,7									;Modulo 8

	btr		ebx,edx									;Test(into carry) and clear
	jc		clear
	or		al,EMU_Z
clear:;
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_bclr_dn_ea_byte ENDP

;-----------------------------------------------------------------------
;BCLR.L #<data>,Dn
_bclr_imm_dn_long PROC NEAR
	and		eax,EMU_CLEAR_Z							;Set default condition code
	mov		bl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter
	and		ebx,31									;Modulo 32

	mov		edx,DECODE_1[ecx]						;DReg
	btr		[edx],ebx								;Test(into carry) and clear
	jc		clear
	or		al,EMU_Z
clear:;
	FRET
_bclr_imm_dn_long ENDP

;-----------------------------------------------------------------------
;BCLR.B #<data>,<ea>
_bclr_imm_ea_byte PROC NEAR
	mov		dl,IMM_BYTE[esi]						;Immediate data
	add		esi,SIZE_WORD							;Increase program counter

	EFFADDR_READ									;Read <ea>
	and		eax,EMU_CLEAR_Z							;Set default condition code
	and		edx,7									;Modulo 8

	btr		ebx,edx									;Test(into carry) and clear
	jc		clear
	or		al,EMU_Z
clear:;
	INTERCEPT_CHECK_ADDR_WRITEBYTE					;Write 'bl' to 'ebp', corrupts 'ecx'
	FRET
_bclr_imm_ea_byte ENDP
