#include <string.h>
#include "vb_types.h"
#include "vb_vbt.h"
#include "vb_cheat.h"
#include "vb_debug.h"

#define CHEAT_LIST_SIZE 2048
#define NUM_CHEATS 64
#define NUM_TITLES 64
#define NUM_CHEAT_LINES 16

BYTE* old_ram;
BYTE* ram_list;

VB_CHEAT vb_cheats[2][NUM_CHEATS];
char vb_cht_titles[NUM_TITLES][32];
WORD mem_list[2][CHEAT_LIST_SIZE];

unsigned char cheat_list_ready = 0;
unsigned char cheat_old_ram_ready = 0;
short cheat_number_games = 0;
short cheat_number_cheats[2];
unsigned char cheat_ram_mod;

void cheat_copy_struct(int src, int dest)
{
	int i;
	int j;

	for(i=0;i<NUM_CHEATS;i++)
	{
		strcpy(vb_cheats[dest][i].title, vb_cheats[src][i].title);

		vb_cheats[dest][i].enabled = vb_cheats[src][i].enabled;
		vb_cheats[dest][i].lines = vb_cheats[src][i].lines;

		for(j=0;j<NUM_CHEAT_LINES;j++)
		{
			vb_cheats[dest][i].type[j] = vb_cheats[src][i].type[j];
			vb_cheats[dest][i].address[j] = vb_cheats[src][i].address[j];
			vb_cheats[dest][i].argument[j] = vb_cheats[src][i].argument[j];
			vb_cheats[dest][i].old_ram[j] = vb_cheats[src][i].old_ram[j];

		}
	}
}

void cheat_unpatch_rom(void)
{
	int i;
	int j;

	for(i=0;i<NUM_CHEATS;i++)
	{
		if(vb_cheats[1][i].enabled)
		{
			for(j=0;j<vb_cheats[1][i].lines;j++)
			{
				if(vb_cheats[1][i].type[j]==2)
					V810_ROM1.pmemory[vb_cheats[1][i].address[j]] = (BYTE)(vb_cheats[1][i].old_ram[j]);
				else if(vb_cheats[1][i].type[j]==3)
					V810_ROM1.pmemory[vb_cheats[1][i].address[j]] = (HWORD)(vb_cheats[1][i].old_ram[j]);
			}
		}

	}

}

int cheat_patch_ram(void)
{
	int i;
	int j;

	//Let's see if it is even necessary
	if(cheat_ram_mod)
	{
		for(i=0;i<NUM_CHEATS;i++)
		{
			if(vb_cheats[1][i].enabled)
			{

				for(j=0;j<vb_cheats[1][i].lines;j++)
				{
					if(vb_cheats[1][i].type[j]==0)
					{
						mem_wbyte(vb_cheats[1][i].address[j]+0x05000000, (BYTE)vb_cheats[1][i].argument[j]);
					}

					else if(vb_cheats[1][i].type[j]==1)
					{
						mem_whword(vb_cheats[1][i].address[j]+0x05000000, (HWORD)vb_cheats[1][i].argument[j]);
					}

				}
			}

		}
	}
	return 0 ;
}

void cheat_patch_rom(void)
{
	int i;
	int j;

	cheat_ram_mod = 0;
	for(i=0;i<NUM_CHEATS;i++)
	{
		if(vb_cheats[1][i].enabled)
		{

			for(j=0;j<vb_cheats[1][i].lines;j++)
			{
				//dbg_writef("Cheat line %d: type %d address %08X\n", j, vb_cheats[1][i].type[j], vb_cheats[1][i].address[j]);
				if(vb_cheats[1][i].type[j]==2)
				{

					//Save the old value
					vb_cheats[1][i].old_ram[j] = mem_rbyte(vb_cheats[1][i].address[j]+0x07000000);

					//Write in the new ROM value (mem_wbyte does not do this, maybe I should add that
					//functionality?)
					V810_ROM1.pmemory[vb_cheats[1][i].address[j]] = (BYTE)(vb_cheats[1][i].argument[j]);
				}

				else if(vb_cheats[1][i].type[j]==3)
				{

					vb_cheats[1][i].old_ram[j] = mem_rhword(vb_cheats[1][i].address[j]+0x07000000);
					V810_ROM1.pmemory[vb_cheats[1][i].address[j]] = (BYTE)(vb_cheats[1][i].argument[j]>>8);
					V810_ROM1.pmemory[vb_cheats[1][i].address[j]+1] = (BYTE)(vb_cheats[1][i].argument[j]&0xFF);
				}

				else if(vb_cheats[1][i].type[j]<2)
					cheat_ram_mod = 1;
			}
		}

	}

}
void cheat_clear_temp(void)
{
	int i;
	int j;

	for(i=0;i<NUM_CHEATS;i++)
	{
		vb_cheats[0][i].title[0] = '\0';
		vb_cheats[0][i].enabled = 0;
		vb_cheats[0][i].lines = 0;

		for(j=0;j<NUM_CHEAT_LINES;j++)
		{
			vb_cheats[0][i].type[j] = 0;
			vb_cheats[0][i].address[j] = 0;
			vb_cheats[0][i].argument[j] = 0;
			vb_cheats[0][i].old_ram[j] = 0;
		}
	}
}

int cheat_load_db(void)
{
		FILE *fp;
		char line_string[81];

		cheat_number_games = 0;

		fp = fopen("cheats.db", "r");

		if(!fp)
			return -1;

		while(1)
		{
		      fgets(line_string, 70, fp);

		      if(feof(fp)) { break; }


		      if(line_string[0]=='}')
		      {
			      cheat_number_games++;
			      if (cheat_number_games >= NUM_TITLES) cheat_number_games = (NUM_TITLES-1);

		      }

		      else {
			      if(!strnicmp(line_string, "Title: ", 7))
			      {
				      strcpy(vb_cht_titles[cheat_number_games], (char*)(line_string+7) );

				      //Chop off newline character
				      vb_cht_titles[cheat_number_games][strlen(vb_cht_titles[cheat_number_games])-1] = '\0';
			      }
		      }
		}  //end while

		fclose(fp);
		return 0 ;
}

int cheat_load_game(int num, unsigned short a)
{
		FILE *fp;
		char line_string[81];
		int i = 0;

		int cheat_line;
		char temp_string[81];
		int ncheat;

		ncheat = -1;

		fp = fopen("cheats.db", "r");


		if(!fp)
			return -1;

		while(1)
		{
		      fgets(line_string, 70, fp);

		      if( feof(fp) ) { break; }

		      if((!strnicmp(line_string, "CT: ", 4))&&(i==num) )
		      {
			      ncheat++;
			      if (ncheat >= NUM_CHEATS) ncheat = (NUM_CHEATS-1); //quick hack!

			      cheat_line = 0;
			      strcpy(vb_cheats[a][ ncheat ].title, (char*)(line_string+4) );

			      //Chop off newline
			      vb_cheats[a][ncheat].title[ strlen( vb_cheats[a][ ncheat ].title ) - 1 ] = '\0';
		      }

		      else if((!strnicmp(line_string, "CC: ", 4))&&(i==num) )
		      {
			      //Get type
			      vb_cheats[a][ ncheat ].type[cheat_line] = line_string[4] - 48;


			      //Get address
			      strcpy(temp_string, (char*)(line_string+6));
			      temp_string[8] = '\0';
			      vb_cheats[a][ ncheat].address[cheat_line] = strtoul(temp_string, (char**)NULL, 16);

			      //Get argument
			      strcpy(temp_string, (char*)(line_string+14));
			      temp_string[4] = '\0';
			      vb_cheats[a][ ncheat ].argument[cheat_line] = strtoul(temp_string, (char**)NULL, 16);

			      cheat_line++;
			      if (cheat_line >= NUM_CHEAT_LINES) cheat_line = (NUM_CHEAT_LINES-1); //quick hack!

			      vb_cheats[a][ ncheat].lines = cheat_line;
		      }

		      if(line_string[0]=='}')
			      i++;

		}

		cheat_number_cheats[a] = ncheat + 1;

		fclose(fp);
		return 0 ;
}

void cheat_init_list(void)
{
        int i;

        ram_list = calloc(65536/8, 1); //Only need 1 bit to tell state

	for(i=0;i<65536/8;i++)
	{
		ram_list[i] = 0xFF;
	}

	cheat_list_ready = 1;
}

void cheat_init_old_ram(void)
{
	old_ram = calloc(65536, 1);
	cheat_old_ram_ready = 1;
}



void cheat_save_old_ram()
{
	unsigned int i;

	if(cheat_old_ram_ready)
	{
		for(i=0;i<65536;i++)
		{
			old_ram[i] = mem_rbyte(i+0x05000000);
		}
	}
}

void cheat_reset_list()
{
	cheat_clear_temp();

	if(cheat_list_ready)
		free(ram_list);
	if(cheat_old_ram_ready)
		free(old_ram);

	cheat_list_ready = 0;
	cheat_old_ram_ready = 0;
}

int cheat_number_hits()
{
	int i;
	int k=0;

	if(cheat_list_ready==0)
	{
		return 0;
	}

	for(i=0;i<65536;i++)
	{
		if( (ram_list[i/8]>>(i%8)) & 1)
			k++;
	}

	return k;
}

void cheat_search_exact(int value)
{
	int i;

	if(!cheat_list_ready)
		cheat_init_list();

	for(i=0;i<65536;i++)
	{
		if(mem_rbyte(0x05000000+i)!=value)
			ram_list[(i/8)] = ram_list[(i/8)] & ( 0xFF ^ ( 1<<(i%8) ) );
	}
}

void cheat_search_comp(int command)
{
	unsigned int i;
	int check;

	if(!cheat_list_ready)
	cheat_init_list();

	for(i=0;i<65536;i++)   //Loop through the VB RAM
	{
		check = 0;

		switch(command)    //Check if the specific command is met
		{
			case CHT_EQL:
			if(mem_rbyte(i+0x05000000)==old_ram[i]) //0x0500000 ????
			check = 1;
			break;

			case CHT_GRT:
			if(mem_rbyte(i+0x05000000)>old_ram[i])
			check = 1;
			break;

			case CHT_GRE:
			if(mem_rbyte(i+0x05000000)>=old_ram[i])
			check = 1;
			break;

			case CHT_LST:
			if(mem_rbyte(i+0x05000000)<old_ram[i])
			check = 1;
			break;

			case CHT_LSE:
			if(mem_rbyte(i+0x05000000)<=old_ram[i])
			check = 1;
			break;

			case CHT_NOT:
			if(mem_rbyte(i+0x05000000)!=old_ram[i])
			check = 1;
			break;
		}

		//Only do something if two values do NOT match
		if(check==0)
		ram_list[(i/8)] = ram_list[(i/8)] & ( 0xFF ^ ( 1<<(i%8) ) );
	}
	//cheat_save_old_ram();
}

int cheat_get_value(int address)
{
	int ret;
	ret = mem_rbyte((address&0xFFFF)+0x05000000);
	return ret;
}

int cheat_get_old_value(int address)
{
	if(cheat_old_ram_ready==1)
		return old_ram[address&0xFFFF];
	else
		return -1;
}

int cheat_get_hit(int number)
{
	int i;
	int k=-1;

	for(i=0;i<65536;i++)
	{
		if( (ram_list[i/8]>>(i%8)) & 1)
		{
			k++;
			if(k==number)
				return i;
		}
	}

	return 0xFFFF;
}

int cheat_search_byte(BYTE arg, int list)
{
        WORD i;
        BYTE val;
        int lp=0;

        for(i=V810_VB_RAM.lowaddr;i<=V810_VB_RAM.highaddr;i++)
        {
           val = mem_rbyte(i);

           if(arg==val)
           {
              mem_list[list][lp] = i;
              lp++;
           }
        }

        mem_list[list][lp+1] = 0;

        return lp;
}

int cheat_search_hword(HWORD arg, int list)
{
        WORD i;
        HWORD val;
        int lp=0;

        for(i=V810_VB_RAM.lowaddr;i<=V810_VB_RAM.highaddr;i++)
        {
           val = mem_rhword(i);

           if(arg==val)
           {
              mem_list[list][lp] = i;
              lp++;
           }
        }

        mem_list[list][lp+1] = 0;

        return lp;
}

void cheat_write_list(int list)
{
        int i=0;
        while(mem_list[list][i])
        {
          i++;
        }
}

int cheat_merge_lists(void)
{
        int i=0;
        int j=0;
        int k=0;
        int j_min=0;

        while(mem_list[0][i])
        {
           while(mem_list[1][j]&&(mem_list[1][j]<=mem_list[0][i]))
           {
              if(mem_list[0][i]==mem_list[1][j])
              {
                 mem_list[0][k] = mem_list[0][i];
                 j_min=j;
                 k++;
                 break;
              }
              j++;
           }
           i++;
           j=j_min;
           if(i==CHEAT_LIST_SIZE) { break; }
        }

        cheat_erase_list(1);

        mem_list[0][k+1] = 0;

        return k;
}

void cheat_erase_list(int list)
{
        int i;

        for(i=0;i<=CHEAT_LIST_SIZE;i++)
        {
           mem_list[list][i] = 0;
        }
}
