//////////////////////////////////////////////////////////
// Main CPU Debug routines

#ifdef MSS
    #include <mss.h>
#endif

//what do we realy need?
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
//Used for getch(), and kbhit(), remove me?
//#include <conio.h>
//#include <pc.h>

#include "vb_types.h"
#include "v810_ins.h"
#include "v810_opt.h"
#include "v810_cpu.h"
#include "v810cpuD.h"
#include "vb_vbt.h"
#include "vb_vbtD.h"


////////////////////////////////////////////////////////////
// Globals
//global linked list
dasmS* dasmHead = NULL;

//Add an element into our linked list
void v810_addDasm(WORD tPC) {
	dasmS* tPtr = dasmHead;
	dasmS* tData;

	//Special case, header
	if(tPtr == NULL) {
		//Fill in data...
		tData = malloc(sizeof(dasmS));
		tData->PC = tPC;
		tData->nextElement = NULL;

		dasmHead = tData;
		dasmHead->nextElement = NULL;
		return;
	//Special Case, header node...
	} else if(dasmHead->PC >= tPC) {
		// Dont insert if there the same...
		if(dasmHead->PC != tPC) {
			//Fill in data...
			tData = malloc(sizeof(dasmS));
			tData->PC = tPC;
			tData->nextElement = dasmHead;
			dasmHead = tData;
		}
	} else {
		// Iterate up to our node...
		while((tPtr->nextElement != NULL)&&(tPtr->nextElement->PC < tPC)) {
			tPtr = tPtr->nextElement;
		}
		// Only add if not in already
		if((tPtr->PC != tPC)&&(tPtr->nextElement->PC != tPC)) {
			//Fill in data...
			tData = malloc(sizeof(dasmS));
			tData->PC = tPC;
			tData->nextElement = tPtr->nextElement;
			tPtr->nextElement = tData;
		}
	}
}

//write out our linked list to a file
void v810_writeDasm() {
	dasmS* tPtr = dasmHead;

	while(tPtr != NULL) {
		v810_dis(tPtr->PC,1,ferr);
		tPtr = tPtr->nextElement;
	}
}

//clear our linked list of data
void v810_clearDasm() {
	dasmS* tPtr = dasmHead;

	while(dasmHead != NULL) {
		tPtr = dasmHead;
		dasmHead = dasmHead->nextElement;
		free(tPtr);
	}
}

/*
int main(void) {
	dasmS* temp = malloc(sizeof(dasmS));
	temp->offset = 10;
	temp->str    = "abc\0";
	temp->jump   = 20;
	temp->nextElement = NULL;
	addElement(temp);

	writeBuff();
	clearBuff();

	return 0;

}
*/


long v810_dis(long tPC, int num, FILE* fout) {
    int lowB, highB, lowB2, highB2;             // up to 4 bytes for instruction (either 16 or 32 bits)
    int opcode, arg1, arg2, arg3;
    int i = 0;

    //if (tPC == -1) // | tPC < V810_ROM1.lowaddr
    //      tPC = PC;
    for(i = 0; i< num; i++) {
        lowB   = mem_rbyte(tPC);
        highB  = mem_rbyte(tPC+1);
        lowB2  = mem_rbyte(tPC+2);
        highB2 = mem_rbyte(tPC+3);

        opcode = highB >> 2;
        if((highB & 0xE0) == 0x80)        // Special opcode format for
            opcode = (highB >> 1);            // type III instructions.

        if((opcode > 0x4F) | (opcode < 0)) {
            //Error Invalid opcode!
            fprintf(fout,"\n%08X\t\t0x%02X 0x%02X       ;Invalid Opcode", tPC, lowB, highB);
            tPC += 2;
        }

        switch(optable[opcode].addr_mode) {
        case AM_I:      // Do the same either way =)
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            if (opcode == JMP) fprintf(fout,"\n%08X\t%s\t[r%02d]           ", tPC, optable[opcode].opname, arg2);
            else fprintf(fout,"\n%08X\t%s\tr%02d,r%02d         ", tPC, optable[opcode].opname, arg2, arg1);
            tPC += 2;   // 16 bit instruction
            break;
        case AM_II:
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            if(opcode == LDSR) fprintf(fout,"\n%08X\t%s\tr%02d,sr%02d        ", tPC, optable[opcode].opname, arg1, arg2);
            else if(opcode == STSR) fprintf(fout,"\n%08X\t%s\tsr%02d,r%02d        ", tPC, optable[opcode].opname, arg2, arg1);
            else if((opcode == EI) || (opcode == DI)) fprintf(fout,"\n%08X\t%s\t                ", tPC, optable[opcode].opname, arg2, arg1);
            else fprintf(fout,"\n%08X\t%s\t0x%02X,r%02d        ", tPC, optable[opcode].opname, sign_5(arg2)&0xFF, arg1);
            tPC += 2;   // 16 bit instruction
            break;
        case AM_III:
            arg1 = ((highB & 0x1) << 8) + (lowB & 0xFE);
            fprintf(fout,"\n%08X\t%s\t%08X        ", tPC, optable[opcode].opname, tPC+sign_9(arg1));
            tPC += 2;   // 16 bit instruction
            break;
        case AM_IV:
            arg1 = ((highB & 0x3) << 24) + (lowB << 16) + (highB2 << 8) + lowB2;
            fprintf(fout,"\n%08X\t%s\t%08X        ", tPC, optable[opcode].opname, tPC+sign_26(arg1));
            tPC += 4;   // 32 bit instruction
            break;
        case AM_V:
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            arg3 = (highB2 << 8) + lowB2;
            fprintf(fout,"\n%08X\t%s\t0x%04X,r%02d,r%02d  ", tPC, optable[opcode].opname, arg3, arg2, arg1 );
            tPC += 4;   // 32 bit instruction
            break;
        case AM_VIa:    // Mode6 form1
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            arg3 = (highB2 << 8) + lowB2;
            fprintf(fout,"\n%08X\t%s\t0x%04X[r%02d],r%02d ", tPC, optable[opcode].opname, arg3, arg2, arg1);
            tPC += 4;   // 32 bit instruction
            break;
        case AM_VIb:    // Mode6 form2
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            arg3 = (highB2 << 8) + lowB2;  //  whats the order??? 2,3,1 or 1,3,2
            fprintf(fout,"\n%08X\t%s\tr%02d,0x%04X[r%02d] ", tPC, optable[opcode].opname, arg1, arg3, arg2);
            tPC += 4;   // 32 bit instruction
            break;
        case AM_VII:    // Unhandled
            fprintf(fout,"\n%08X\t0x%02X 0x%02X 0x%02X 0x%02X     ", tPC, lowB, highB, lowB2, highB2);
            tPC +=4;        // 32 bit instruction
            break;
        case AM_VIII:   // Unhandled
            fprintf(fout,"\n%08X\t0x%02X 0x%02X 0x%02X 0x%02X     ", tPC, lowB, highB, lowB2, highB2);
            tPC += 4;   // 32 bit instruction
            break;
        case AM_IX:
            arg1 = (lowB & 0x1); // Mode ID, Ignore for now
            fprintf(fout,"\n%08X\t%s\t                ", tPC, optable[opcode].opname);
            tPC += 2;   // 16 bit instruction
            break;
        case AM_BSTR:   // Bit String Subopcodes
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            if(arg2 > 15) fprintf(fout,"\n%08X\tBError%X\t                ", tPC, arg2);
            else fprintf(fout,"\n%08X\t%s\t                ", PC, bssuboptable[arg2].opname);
            tPC += 2;   // 16 bit instruction
            break;
        case AM_FPP:    // Floating Point Subcode
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            arg3 = (highB2 >> 2);
            if(arg3 > 15) fprintf(fout,"\n%08X\tFError%X\t                ", tPC, arg3);
            else fprintf(fout,"\n%08X\t%s\tr%02d,r%02d         ", PC, fpsuboptable[arg3].opname, arg1, arg2);
            tPC += 4;   // 32 bit instruction
            break;
        case AM_UDEF:   // Invalid opcode.
        default:        // Invalid opcode.
            fprintf(fout,"\n%08X\t\t0x%02X 0x%02X       ;Invalid Opcode", tPC, lowB, highB);
            tPC += 2;
        }
    }
    return(tPC);
}

/*long v810_dis(long tPC, int num, FILE* fout) {
    int      lowB, highB, lowB2, highB2;             // up to 4 bytes for instruction (either 16 or 32 bits)
    int      opcode, arg1, arg2, arg3;
    int i = 0;

    //if (tPC == -1) // | tPC < V810_ROM1.lowaddr
    //      tPC = PC;
    for(i = 0; i< num; i++) {
        lowB   = mem_rbyte(tPC);
        highB  = mem_rbyte(tPC+1);
        lowB2  = mem_rbyte(tPC+2);
        highB2 = mem_rbyte(tPC+3);

        opcode = highB >> 2;
        if((highB & 0xE0) == 0x80)        // Special opcode format for
            opcode = (highB >> 1);            // type III instructions.

        if((opcode > 0x4F) | (opcode < 0)) {
            //Error Invalid opcode!
            fprintf(fout,"\n0x%08lx\t\t0x%2x 0x%2x  ;Invalid Opcode", tPC, lowB, highB);
            tPC += 2;
        }

        switch(optable[opcode].addr_mode) {
        case AM_I:       // Do the same Ither way =)
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            if (opcode == JMP) {
                fprintf(fout,"\n0x%08lx\t%s\t\t[$%d]", tPC, optable[opcode].opname, arg2);
            } else {
                fprintf(fout,"\n0x%08lx\t%s\t\t$%d, $%d", tPC, optable[opcode].opname, arg2, arg1);
            }
            tPC += 2;   // 16 bit instruction
            break;
        case AM_II:
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
		if(opcode == LDSR) {
	            fprintf(fout,"\n0x%08lx\t%s\t\t $%d, $s%d", tPC, optable[opcode].opname, arg1, arg2);
		} else if(opcode == STSR) {
	            fprintf(fout,"\n0x%08lx\t%s\t\t $s%d, $%d", tPC, optable[opcode].opname, arg2, arg1);
		} else {
      	      fprintf(fout,"\n0x%08lx\t%s\t\t%ld, $%d", tPC, optable[opcode].opname, sign_5(arg2), arg1);
		}
            tPC += 2;   // 16 bit instruction
            break;
        case AM_III:
            arg1 = ((highB & 0x1) << 8) + (lowB & 0xFE);
            fprintf(fout,"\n0x%08lx\t%s\t\t%ld", tPC, optable[opcode].opname, sign_9(arg1));
            tPC += 2;   // 16 bit instruction
            break;
        case AM_IV:
            arg1 = ((highB & 0x3) << 24) + (lowB << 16) + (highB2 << 8) + lowB2;
            fprintf(fout,"\n0x%08lx\t%s\t\t%ld", tPC, optable[opcode].opname, sign_26(arg1));
            tPC += 4;                                               // 32 bit instruction
            break;
        case AM_V:
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            arg3 = (highB2 << 8) + lowB2;
            fprintf(fout,"\n0x%08lx\t%s\t\t0x%x, $%d, $%d", tPC, optable[opcode].opname, arg3, arg2, arg1 );
            tPC += 4;   // 32 bit instruction
            break;
        case AM_VIa:  // Mode6 form1
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            arg3 = (highB2 << 8) + lowB2;
            fprintf(fout,"\n0x%08lx\t%s\t\t%ld[$%d], $%d", tPC, optable[opcode].opname, sign_16(arg3), arg2, arg1);
            tPC += 4;   // 32 bit instruction
            break;
        case AM_VIb:  // Mode6 form2
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            arg3 = (highB2 << 8) + lowB2;                              //  whats the order??? 2,3,1 or 1,3,2
            fprintf(fout,"\n0x%08lx\t%s\t\t$%d, %ld[$%d]", tPC, optable[opcode].opname, arg1, sign_16(arg3), arg2);
            tPC += 4;   // 32 bit instruction
            break;
        case AM_VII:   // Unhandled
            fprintf(fout,"\n0x%08lx\t\t0x%2x 0x%2x 0x%2x 0x%2x", tPC, lowB, highB, lowB2, highB2);
            tPC +=4;        // 32 bit instruction
            break;
        case AM_VIII:  // Unhandled
            fprintf(fout,"\n0x%08lx\t\t0x%2x 0x%2x 0x%2x 0x%2x", tPC, lowB, highB, lowB2, highB2);
            tPC += 4;   // 32 bit instruction
            break;
        case AM_IX:
            arg1 = (lowB & 0x1); // Mode ID, Ignore for now
            fprintf(fout,"\n0x%08lx\t%s", tPC, optable[opcode].opname);
            tPC += 2;   // 16 bit instruction
            break;
        case AM_BSTR:  // Bit String Subopcodes
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            if(arg2 > 16) {
                fprintf(fout,"\n0x%08lx\tBError", tPC);
            } else {
                fprintf(fout,"\n0x%08lx\t%s, $%d", PC, bssuboptable[arg2].opname,arg1);
            }
            tPC += 2;   // 16 bit instruction
            break;
        case AM_FPP:   // Floating Point Subcode
            arg1 = (lowB >> 5) + ((highB & 0x3) << 3);
            arg2 = (lowB & 0x1F);
            arg3 = (highB2 >> 2);
            if(arg3 > 16) {
                fprintf(fout,"\n0x%08lx\tFError", tPC);
            } else {
                fprintf(fout,"\n0x%08lx\t%s  $%d, $%d", PC, fpsuboptable[arg3].opname, arg1, arg2);
            }
            tPC += 4;   // 32 bit instruction
            break;
        case AM_UDEF:  // Invalid opcode.
            default:           // Invalid opcode.
            fprintf(fout,"\n0x%08lx\t\t0x%2x 0x%2x  ;Invalid Opcode", tPC, lowB, highB);
            tPC += 2;
        }
    }
    return(tPC);
}*/

void v810_preg() {
    int i = 0;
    //int j = 0;
    for(i = 0; i < 32; i+=4) {
        //for(j = 0; j < 4; j++) {
        printf("\n$%02d %08lx, $%02d %08lx, $%02d %08lx, $%02d %08lx",i, P_REG[i],i+1,P_REG[i+1],i+2,P_REG[i+2],i+3,P_REG[i+3]);
    }
    printf("\n$PSW %08lx",S_REG[PSW]);
}

void v810_dump(long tPC, int num) {
    BYTE t1, t2, t3, t4;
    int i = 0;
    int j = 0;

    //if (tPC == -1) // | tPC < V810_ROM1.lowaddr
    //      tPC = PC;

    for(i = 0; i< num; i++) {
        printf("\n%08lx",tPC);
        for (j = 0; j < 16; j+=8) {
            t1 = mem_rhword(tPC+j);
            t2 = mem_rhword(tPC+j+2);
            t3 = mem_rhword(tPC+j+4);
            t4 = mem_rhword(tPC+j+6);
            printf("  %04x %04x %04x %04x", t1, t2, t3, t4);
        }
        tPC +=16;
    }
}
