#include <allegro.h>
#include <stdio.h>
#include "vb_gui.h"
#include "vb_set.h"
#include "v810_cpu.h" //Needed for V810_MEMORYFETCH & V810_REGFETCH structs
#include "vb_vbt.h" //Needed for RAM addresses
#include "vb_types.h" //Needed for HWORD declaration
#include "vb_dsp.h"
#include "vb_dspD.h"
#include "rom_db.h"
#include "vb_cheat.h"
#include "port.h"
#include "vb_debug.h"

#define ctrl(x)      (x - 'a' + 1)

#define APPNAME		"Red Dragon v0.38"

#define SAVESTATE_VER	0x00000001


/* Variable Definitions */
int guiop;
int cheat_results=0;
char rompath[384];
char BMPpath[384];
char sspath[384];
char e_modefail[] = "Error settings graphics mode!";
char e_file[] = "Error creating options file!";
char b_ok[] = "Ok!";
char b_cancel[] = "Cancel";
char cht_sterm[] = "000";
char dbg_watchS[] = "00000000";
char dbg_watchE[] = "00000000";
char dbg_writeS[] = "00000000";
char dbg_writeE[] = "00000000";
char memed_addr[] = "05000000";
char *strings[2048][11];
char cht_lbox[32];
char *keynames[];
char m_about2[] = "Written by frostgiant (frostgiant@yifan.net) and Parasyte";
char m_about3[] = "Heavily Based on Reality Boy by David Tucker";
char w_title[] = APPNAME;
FILE *stateFile;
short gui_cheat_old_game = -1;
unsigned char want_kill = 0;


MENU main_menu[];

MENU file_menu[];
MENU options_menu[];
MENU emulation_menu[];
MENU debug_menu[];
MENU debug_view_menu[];
MENU emulation_cheat_menu[];
MENU help_menu[];

DIALOG cheat_browse_dialog[];
DIALOG cheat_search_dialog[];
DIALOG cheat_search_exact_dialog[];
DIALOG cheat_search_comp_dialog[];
DIALOG cheat_view_dialog[];
DIALOG watchpoint_dialog[];
DIALOG main_dialog[];
DIALOG input_dialog[];
DIALOG options_dialog[];
DIALOG writebin_dialog[];
//DIALOG memory_edit_dialog[];


/* Function Prototypes */
int file_loadrom(void);
int file_closerom(void);
int file_exit(void);

int options_video(void);
int options_input(void);
int options_emulation(void);
int options_saveoptions(void);

int emulation_resume(void);
int emulation_reset(void);
int emulation_sstate(void);
int emulation_lstate(void);

int debug_showinfo(void);
int debug_dumpinfo(void);
int debug_view_memory(void);
int debug_view_chars(void);
int debug_view_bgmaps(void);
int debug_view_worlds(void);
int debug_view_obj(void);
int debug_saveram(void);
int debug_cheat_search(void);
int debug_cheat_search_exact(void);
int debug_cheat_search_comp(void);
int debug_cheat_view(void);
int debug_watchpoints(void);
int debug_trace(void);

int help_about(void);

char* cheat_listbox(int index, int *list_size);
char* listbox_palette(int index, int *list_size);
char* listbox_dspmode(int index, int *list_size);
int chop_filename(char fname[]);
void GUI_SetColors();
int StartGUI(int romload);
void setMenu(int a, int b, int c);
void writeValue(int Fvalue);
int writeHWORD(HWORD data, FILE *fout);
HWORD readHWORD(FILE *fin);
void doOptions(void);
void doKeys(void);
void change_color(int index, int r, int g, int b);

//custom dialog controls
int d_pushbutton_proc(int msg, DIALOG *d, int c);


/* The About Box info changes with OS */

#ifdef ALLEGRO_WINDOWS
        char m_about1[] = APPNAME" for Windows";
#endif
#ifdef ALLEGRO_DOS
        char m_about1[] = APPNAME" for DOS";
#endif
#ifdef ALLEGRO_LINUX
        char m_about1[] = APPNAME" for Linux";
#endif

char* listbox_cheat_titles(int index, int *list_size)
{

    if(index<0)
    {
	    *list_size = cheat_number_games;
	    return NULL;
    }

    if (cheat_browse_dialog[5].d1 != gui_cheat_old_game)
    {
	    cheat_browse_dialog[6].flags = D_DIRTY;	//Cheats list needs to be redrawn
	    cheat_browse_dialog[6].d1 = 0;		//Set to first element on list, in case old one was bigger
    }

    return vb_cht_titles[index];
}

char* listbox_cheat_cheats(int index, int *list_size)
{
   int curgame = cheat_browse_dialog[5].d1;

    static char temps[64];

   if (curgame != gui_cheat_old_game) {
	   //clear old cheats
	   cheat_unpatch_rom();
	   cheat_clear_temp();
	   cheat_copy_struct(0,1);

	   //load new cheats
	   cheat_load_game(curgame, 0);
	   gui_cheat_old_game = curgame;
   }

   if(index<0)
   {
	   *list_size = cheat_number_cheats[0];
	   return NULL;
   }

   else
   {
	    if(vb_cheats[0][index].enabled)
		    sprintf(temps, "* %s", vb_cheats[0][index].title);
	    else
		    sprintf(temps, "  %s", vb_cheats[0][index].title);

	    return temps;
   }
}

char* listbox_cheat(int index, int *list_size)
{
    int i;
    if(cheat_list_ready==0)
	    *list_size = 0;

    if(index<0) {
       *list_size = cheat_number_hits();
       if(cheat_number_hits()>100)
	       *list_size = 100;

       return NULL;
    }

    else
    {
       i = cheat_get_hit(index);

       if(cheat_old_ram_ready)
	       sprintf(cht_lbox, "%08X  %02X  %02X", i+0x05000000, cheat_get_value(i), cheat_get_old_value(i) );
       else
	       sprintf(cht_lbox, "%08X  %02X  ??",  i+0x05000000, cheat_get_value(i) );

       return cht_lbox;
    }
}

char* listbox_palette(int index, int *list_size)
{
	static char *s_palette[] =
	{
		"Normal", "Red", "Red & Blue", "Red & Green", "Red, Blue, & Green"
	};

	if(index<0) {
		*list_size=5;
		return NULL;
	}

	else
		return s_palette[index];
}

char* listbox_dspmode(int index, int *list_size)
{
	static char *s_dspmode[] =
	{
		"Normal", "3D Glasses", "Interlaced", "Side by Side", "CyberScope"
	};

	if(index<0) {
		*list_size=5;
		return NULL;
	}

	else
		return s_dspmode[index];
}

int d_killcheck_proc(int msg, DIALOG *d, int c)
{
	int ret = D_O_K;

	if(want_kill)
	{
		ret = D_EXIT;
		guiop = AKILL | GUIEXIT;
	}

	return ret;
}


int file_loadrom(void) {
	int ret;

	ret = file_select_ex("Load ROM:", rompath, "vb;zip", 384, OLD_FILESEL_WIDTH, OLD_FILESEL_HEIGHT);
	if (ret) {
		if (debuglog) debug_trace(); //disable trace logging if enabled
		tVBOpt.ROM_NAME = rompath;
		setMenu(1,1,1);
		guiop = AKILL | VBRESET;
		cheat_reset_list();
	}

	return D_EXIT;
}

int file_closerom(void) {
	if (debuglog) debug_trace(); //disable trace logging if enabled
	save_sram();
	cheat_reset_list();
	setMenu(0,0,0);
	//broadcast_dialog_message(MSG_DRAW, 0);
	return D_EXIT; //redraw!
}

int file_exit(void) {
	guiop = AKILL | GUIEXIT;
	return D_EXIT;
}

int options_video(void)
{
   int c, w, h, depth;
   int ret, mode_failure;

   c = tVBOpt.SCR_MODE;
   w = tVBOpt.SCR_X;
   h = tVBOpt.SCR_Y;
   depth = 24;

   ret = gfx_mode_select_ex(&c, &w, &h, &depth);

   //Did they click "OK"?
   if (ret) {
//	   set_color_depth(depth);
	   mode_failure = set_gfx_mode(c, w, h, 0, 0);
	   GUI_SetColors();

	   tVBOpt.SCR_MODE = c;
	   tVBOpt.SCR_X = w;
	   tVBOpt.SCR_Y = h;

	   if (mode_failure) {
		   alert(e_modefail, NULL, NULL, b_ok, NULL, 1, (int)NULL);
		   printf("%s\n", e_modefail);
	   }
	   return D_EXIT;
   }
}


int options_input(void) {
    doKeys();
}

int options_emulation(void) {
    doOptions();
}

int options_saveoptions(void) {

    int i=0;
    int j;

    optionsFile = fopen(optionfilename, "w");
    if(optionsFile != 0) {

      fprintf(optionsFile, "platform=");
      writeValue(platform);
      fprintf(optionsFile, "frmskip=");
      writeValue(tVBOpt.FRMSKIP);
      fprintf(optionsFile, "dspmode=");
      writeValue(tVBOpt.DSPMODE);
      fprintf(optionsFile, "dspswap=");
      writeValue(tVBOpt.DSPSWAP);
      fprintf(optionsFile, "dsp2x=");
      writeValue(tVBOpt.DSP2X);
      fprintf(optionsFile, "palmode=");
      writeValue(tVBOpt.PALMODE);
      fprintf(optionsFile, "scrx=");
      writeValue(tVBOpt.SCR_X);
      fprintf(optionsFile, "scry=");
      writeValue(tVBOpt.SCR_Y);
      fprintf(optionsFile, "sound=");
      writeValue(tVBOpt.SOUND);

      if(rompath[0]) {
         j = chop_filename(rompath);
         fprintf(optionsFile, "Srompath=");
         for(i=0;i<=j;i++) {
            fprintf(optionsFile, "%c", rompath[i]);
         }
         fprintf(optionsFile, "\n");

      }


      //Complex screenmode code ;-)
      fprintf(optionsFile, "scrmode=");

      i=0;
      j=1;
      while(j)
      {
         if(i==drivercount) {
            writeValue(0);
            j=0;
         }

         if(tVBOpt.SCR_MODE == VBgfx_driver[i])
         {
            writeValue(i);
            j=0;
         }

         i++;
      }

      fprintf(optionsFile, "lu=");
      writeValue(vbkey[0]);
      fprintf(optionsFile, "ld=");
      writeValue(vbkey[1]);
      fprintf(optionsFile, "ll=");
      writeValue(vbkey[2]);
      fprintf(optionsFile, "lr=");
      writeValue(vbkey[3]);
      fprintf(optionsFile, "ru=");
      writeValue(vbkey[4]);
      fprintf(optionsFile, "rd=");
      writeValue(vbkey[5]);
      fprintf(optionsFile, "rl=");
      writeValue(vbkey[6]);
      fprintf(optionsFile, "rr=");
      writeValue(vbkey[7]);

      fprintf(optionsFile, "ba=");
      writeValue(vbkey[8]);
      fprintf(optionsFile, "bb=");
      writeValue(vbkey[9]);
      fprintf(optionsFile, "st=");
      writeValue(vbkey[10]);
      fprintf(optionsFile, "sl=");
      writeValue(vbkey[11]);
      fprintf(optionsFile, "tl=");
      writeValue(vbkey[12]);
      fprintf(optionsFile, "tr=");
      writeValue(vbkey[13]);
      fprintf(optionsFile, "bl=");
      writeValue(vbkey[14]);


      fclose(optionsFile);
    }
    else {
	    printf("%s\n", e_file);
	    alert(e_file, NULL, NULL, b_ok, NULL, 1, (int)NULL);
    }
}


int chop_filename(char fname[]) {
   int i=0;
   int j=0;
   int ext=0;

   //Find string length in i
   while(fname[i]!='\0')
   {
        i++;
   }

   //Go backwards through string, looking for '.' then '/' or '\'
   for(j=i;j>=0;j--) {
      if(fname[j]=='.')  ext = 1;
      if( (ext==1)&&( (fname[j]=='\\')||(fname[j]=='/') ) )
      {
         return j;
      }
   }
   return 0;
}

int emulation_resume(void) {
	guiop = AKILL;
	cheat_save_old_ram();
	setMenu(1,1,1);

	return D_EXIT;
}

int emulation_reset(void) {
    guiop = AKILL | VBRESET;
    cheat_save_old_ram();
    return D_EXIT;
}

int emulation_sstate(void) {
	int i;
	int highbyte;
	int lowbyte;
	int ret;

	ret = file_select_ex("Save State:", sspath, "rds", 384, OLD_FILESEL_WIDTH, OLD_FILESEL_HEIGHT);

	if(ret) {
		stateFile = fopen(sspath, "wb");

		if(stateFile==NULL) {
			alert("Error creating file!", "Check that you have permission to write", NULL, b_ok, NULL, 1, (int)NULL);
			return 0;
		}

		//Write header
		putw(0x53534452, stateFile); //"RDSS"
		putw(SAVESTATE_VER, stateFile); //version number
		putw(tVBOpt.CRC32, stateFile); //CRC32

		//Write registers
		for (i = 0; i < 32; i++) putw(P_REG[i], stateFile);
		for (i = 0; i < 32; i++) putw(S_REG[i], stateFile);
		putw(PC, stateFile);

		//Write the VIP registers first (could be done better!)
/*
		writeHWORD(vipcreg_rhword(0x0005F800), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F802), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F820), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F822), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F824), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F826), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F828), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F82A), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F82E), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F830), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F840), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F842), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F844), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F848), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F84A), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F84C), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F84E), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F860), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F864), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F866), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F868), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F86A), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F86C), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F86E), stateFile);
		writeHWORD(vipcreg_rhword(0x0005F870), stateFile);
*/
		writeHWORD(tVIPREG.INTPND, stateFile);
		writeHWORD(tVIPREG.INTENB, stateFile);
		writeHWORD(tVIPREG.INTCLR, stateFile);
		writeHWORD(tVIPREG.DPSTTS, stateFile);
		writeHWORD(tVIPREG.DPCTRL, stateFile);
		writeHWORD(tVIPREG.BRTA, stateFile);
		writeHWORD(tVIPREG.BRTB, stateFile);
		writeHWORD(tVIPREG.BRTC, stateFile);
		writeHWORD(tVIPREG.REST, stateFile);
		writeHWORD(tVIPREG.FRMCYC, stateFile);
		writeHWORD(tVIPREG.CTA, stateFile);
		writeHWORD(tVIPREG.XPSTTS, stateFile);
		writeHWORD(tVIPREG.XPCTRL, stateFile);
		writeHWORD(tVIPREG.SPT[0], stateFile);
		writeHWORD(tVIPREG.SPT[1], stateFile);
		writeHWORD(tVIPREG.SPT[2], stateFile);
		writeHWORD(tVIPREG.SPT[3], stateFile);
		writeHWORD(tVIPREG.GPLT[0], stateFile);
		writeHWORD(tVIPREG.GPLT[1], stateFile);
		writeHWORD(tVIPREG.GPLT[2], stateFile);
		writeHWORD(tVIPREG.GPLT[3], stateFile);
		writeHWORD(tVIPREG.JPLT[0], stateFile);
		writeHWORD(tVIPREG.JPLT[1], stateFile);
		writeHWORD(tVIPREG.JPLT[2], stateFile);
		writeHWORD(tVIPREG.JPLT[3], stateFile);
		writeHWORD(tVIPREG.BKCOL, stateFile);
		writeHWORD(tVIPREG.tFrame, stateFile); //not publicly visible

		//Write hardware control registers
		for(i=0x02000000;i<=0x02000028;i=i+4) {
			fputc(hcreg_rbyte(i), stateFile);
		}
		writeHWORD(tHReg.tTHW, stateFile);   //not publicly visible
		writeHWORD(tHReg.tCount, stateFile); //not publicly visible
		putw(tHReg.tTRC, stateFile);         //not publicly visible

		//Next we write all the RAM contents
		for(i=V810_DISPLAY_RAM.lowaddr;i<=V810_DISPLAY_RAM.highaddr;i++) {
			fputc((char)mem_rbyte(i), stateFile);
		}
		for(i=V810_SOUND_RAM.lowaddr;i<=V810_SOUND_RAM.highaddr;i++) {
			fputc((char)mem_rbyte(i), stateFile);
		}
		for(i=V810_VB_RAM.lowaddr;i<=V810_VB_RAM.highaddr;i++) {
			fputc((char)mem_rbyte(i), stateFile);
		}
		for(i=V810_GAME_RAM.lowaddr;i<=V810_GAME_RAM.highaddr;i+=2) {
			fputc((char)mem_rbyte(i), stateFile);
		}
		fclose(stateFile);
    }
}

int emulation_lstate(void) {
	int i;
	int ret;
	int id,ver,crc;
	char str1[32],str2[32];

	ret = file_select_ex("Load State:", sspath, "rds", 384, OLD_FILESEL_WIDTH, OLD_FILESEL_HEIGHT);

	if(ret) {
		stateFile = fopen(sspath, "rb");

		if(stateFile==NULL) {
			alert("Error reading file!", "Check that it still exists", NULL, b_ok, NULL, 1, (int)NULL);
			return 0;
		}

		//fix for cheat searching!
		cheat_save_old_ram();

		//Load header
		id = getw(stateFile);
		ver = getw(stateFile);
		if ((id != 0x53534452) || (ver != SAVESTATE_VER)) {
			sprintf(str1, "ID:      %c%c%c%c",(id>>24),((id>>16)&0xFF),((id>>8)&0xFF),(id&0xFF));
			sprintf(str2, "Version: %04x",ver);
			if (alert("Invalid header. Load anyway?", str1, str2, b_ok, b_cancel, KEY_ENTER, KEY_ESC) == 2) return 0;
		}
		crc = getw(stateFile);
		if (crc != tVBOpt.CRC32) {
			sprintf(str1, "Loaded crc32:   %08X",crc);
			sprintf(str2, "Expected crc32: %08X",tVBOpt.CRC32);
			if (alert("Invalid CRC32. Load anyway?", str1, str2, b_ok, b_cancel, KEY_ENTER, KEY_ESC) == 2) return 0;
		}

		//Load registers
		for (i = 0; i < 32; i++) P_REG[i] = getw(stateFile);
		for (i = 0; i < 32; i++) S_REG[i] = getw(stateFile);
		PC = getw(stateFile);

		//Load VIP registers
/*
		vipcreg_whword(0x0005F800, readHWORD(stateFile));
		vipcreg_whword(0x0005F802, readHWORD(stateFile));
		vipcreg_whword(0x0005F820, readHWORD(stateFile));
		vipcreg_whword(0x0005F822, readHWORD(stateFile));
		vipcreg_whword(0x0005F824, readHWORD(stateFile));
		vipcreg_whword(0x0005F826, readHWORD(stateFile));
		vipcreg_whword(0x0005F828, readHWORD(stateFile));
		vipcreg_whword(0x0005F82A, readHWORD(stateFile));
		vipcreg_whword(0x0005F82E, readHWORD(stateFile));
		vipcreg_whword(0x0005F830, readHWORD(stateFile));
		vipcreg_whword(0x0005F840, readHWORD(stateFile));
		vipcreg_whword(0x0005F842, readHWORD(stateFile));
		vipcreg_whword(0x0005F844, readHWORD(stateFile));
		vipcreg_whword(0x0005F848, readHWORD(stateFile));
		vipcreg_whword(0x0005F84A, readHWORD(stateFile));
		vipcreg_whword(0x0005F84C, readHWORD(stateFile));
		vipcreg_whword(0x0005F84E, readHWORD(stateFile));
		vipcreg_whword(0x0005F860, readHWORD(stateFile));
		vipcreg_whword(0x0005F864, readHWORD(stateFile));
		vipcreg_whword(0x0005F866, readHWORD(stateFile));
		vipcreg_whword(0x0005F868, readHWORD(stateFile));
		vipcreg_whword(0x0005F86A, readHWORD(stateFile));
		vipcreg_whword(0x0005F86C, readHWORD(stateFile));
		vipcreg_whword(0x0005F86E, readHWORD(stateFile));
		vipcreg_whword(0x0005F870, readHWORD(stateFile));
*/
		tVIPREG.INTPND = readHWORD(stateFile);
		tVIPREG.INTENB = readHWORD(stateFile);
		tVIPREG.INTCLR = readHWORD(stateFile);
		tVIPREG.DPSTTS = readHWORD(stateFile);
		tVIPREG.DPCTRL = readHWORD(stateFile);
		tVIPREG.BRTA = readHWORD(stateFile);
		tVIPREG.BRTB = readHWORD(stateFile);
		tVIPREG.BRTC = readHWORD(stateFile);
		tVIPREG.REST = readHWORD(stateFile);
		tVIPREG.FRMCYC = readHWORD(stateFile);
		tVIPREG.CTA = readHWORD(stateFile);
		tVIPREG.XPSTTS = readHWORD(stateFile);
		tVIPREG.XPCTRL = readHWORD(stateFile);
		tVIPREG.SPT[0] = readHWORD(stateFile);
		tVIPREG.SPT[1] = readHWORD(stateFile);
		tVIPREG.SPT[2] = readHWORD(stateFile);
		tVIPREG.SPT[3] = readHWORD(stateFile);
		tVIPREG.GPLT[0] = readHWORD(stateFile);
		tVIPREG.GPLT[1] = readHWORD(stateFile);
		tVIPREG.GPLT[2] = readHWORD(stateFile);
		tVIPREG.GPLT[3] = readHWORD(stateFile);
		tVIPREG.JPLT[0] = readHWORD(stateFile);
		tVIPREG.JPLT[1] = readHWORD(stateFile);
		tVIPREG.JPLT[2] = readHWORD(stateFile);
		tVIPREG.JPLT[3] = readHWORD(stateFile);
		tVIPREG.BKCOL = readHWORD(stateFile);
		tVIPREG.tFrame = readHWORD(stateFile); //not publicly visible

		//Load hardware control registers
		for(i=0x02000000;i<=0x02000028;i=i+4) {
			hcreg_wbyte(i, fgetc(stateFile));
		}
		tHReg.tTHW = readHWORD(stateFile);   //not publicly visible
		tHReg.tCount = readHWORD(stateFile); //not publicly visible
		tHReg.tTRC = getw(stateFile);        //not publicly visible

		//Load the RAM
		for(i=V810_DISPLAY_RAM.lowaddr;i<=V810_DISPLAY_RAM.highaddr;i++) {
			mem_wbyte(i, fgetc(stateFile));
		}
		for(i=V810_SOUND_RAM.lowaddr;i<=V810_SOUND_RAM.highaddr;i++) {
			mem_wbyte(i, fgetc(stateFile));
		}
		for(i=V810_VB_RAM.lowaddr;i<=V810_VB_RAM.highaddr;i++) {
			mem_wbyte(i, fgetc(stateFile));
		}
		for(i=V810_GAME_RAM.lowaddr;i<=V810_GAME_RAM.highaddr;i+=2) {
			mem_wbyte(i, fgetc(stateFile));
		}

		fclose(stateFile);

        guiop = AKILL;
        return D_EXIT;
    }
}

int debug_showinfo(void) {
    char romstring1[64];
    char romstring2[64];
    char romstring3[64];
    char romtitle[21];
    char s_mfg[32];
    int mfg;
    int version;
    char id[4];
    int i;

    for(i=0;i<20;i++) {
       romtitle[i] = ((char)mem_rbyte(0x07FFFDE0+i))&0xFF;
       //Get rid of any weird characers that might make the emu crash
       if( ((int)romtitle[i]<32) || ((int)romtitle[i]>126) ) { romtitle[i] = (char)32; }
       romtitle[20]= '\0';
    }

    mfg = (mem_rbyte(0x07FFFDF9)<<8) + mem_rbyte(0x07FFFDFA);

    strcpy(s_mfg, "Unknown");

    switch(mfg) {
          case 0x3031:
             strcpy(s_mfg, "Nintendo");
             break;

          case 0x3042:
             strcpy(s_mfg, "Coconuts Japan");
             break;

          case 0x3138:
             strcpy(s_mfg, "Hudson Soft");
             break;

          case 0x3238:
             strcpy(s_mfg, "Kemco");
             break;

          case 0x3637:
             strcpy(s_mfg, "Ocean");
             break;

          case 0x3842:
             strcpy(s_mfg, "Bullet Proof Software");
             break;

          case 0x3846:
             strcpy(s_mfg, "I'Max");
             break;

          case 0x3939:
             strcpy(s_mfg, "Pack in Video");
             break;

          case 0x4148:
             strcpy(s_mfg, "J-Wing");
             break;

          case 0x4232:
             strcpy(s_mfg, "Bandai");
             break;

          case 0x4330:
             strcpy(s_mfg, "Taito");
             break;

          case 0x4537:
             strcpy(s_mfg, "Athena");
             break;

          case 0x4542:
             strcpy(s_mfg, "Atlus");
             break;

    }

    for(i=0;i<4;i++) { id[i] = mem_rbyte(0x07FFFDFB+i); }
    version = mem_rbyte(0x07FFFDFF);

    sprintf(romstring1, "Title: %s", romtitle);
    sprintf(romstring2, "Manufacturer: 0x%04X (%s)", mfg, s_mfg);
    sprintf(romstring3, "Game ID: %c%c%c%c Version: 0x%02X", id[0], id[1], id[2], id[3], version);
    alert(romstring1, romstring2, romstring3, b_ok, NULL, 1, (int)NULL);

}


int debug_dumpinfo(void)
{
    char string1[64];
    char string2[64];
    char string3[64];
    int romnum = db_find(tVBOpt.CRC32);

    sprintf(string1, "CRC32: %08X", tVBOpt.CRC32);
    sprintf(string2, "Title: %s", rom_db[romnum].title);
    sprintf(string3, "Dump Status: %s", rom_db[romnum].status);

    alert(string1, string2, string3, b_ok, NULL, 1, (int)NULL);
}

int debug_view_memory(void) { V810_DSP_Ram(); }
int debug_view_chars(void)  { V810_DSP_Chr(); }
int debug_view_bgmaps(void) { V810_DSP_BGMap(); }
int debug_view_worlds(void) { V810_DSP_World(); }
int debug_view_obj(void)    { V810_DSP_Obj(); }

int debug_saveram(void)
{
     long i;
/*     printf("Display Low: 0x%x High: 0x%x", V810_DISPLAY_RAM.lowaddr,
         V810_DISPLAY_RAM.highaddr);
     printf("Sound Low: 0x%x High: 0x%x", V810_SOUND_RAM.lowaddr,
         V810_SOUND_RAM.highaddr);
     printf("VB Low: 0x%x High: 0x%x", V810_VB_RAM.lowaddr,
         V810_VB_RAM.highaddr);
     printf("Game Low: 0x%x High: 0x%x", V810_GAME_RAM.lowaddr,
         V810_GAME_RAM.highaddr);*/


        for(i=V810_DISPLAY_RAM.lowaddr;i<=V810_DISPLAY_RAM.highaddr;i=i+4) {
                //mem_rbyte(0x07FFFDFF);
                //mem_wbyte(i, fgetc(stateFile));
                /*
                if(i<=0xF) { printf("0x0000 000%x\n", i); }
                else if(i<=0xFF) { printf("0x000000%x\n", i); }
                else if(i<=0xFFF) { printf("0x00000%x\n", i); }
                else if(i<=0xFFFF) { printf("0x0000%x\n", i); }
                else if(i<=0xFFFFF) { printf("0x000%x\n", i); }
                else if(i<=0xFFFFFF) { printf("0x00%x\n", i); }
                else if(i<=0xFFFFFFF) { printf("0x0%x\n", i); }
                else if(i<=0xFFFFFFFF) { printf("0x%x\n", i); }
                */
                printf("0x%08x\n", i);
       }
/*        for(i=V810_SOUND_RAM.lowaddr;i<=V810_SOUND_RAM.highaddr;i++) {
		mem_wbyte(i, fgetc(stateFile));
	}
	for(i=V810_VB_RAM.lowaddr;i<=V810_VB_RAM.highaddr;i++) {
		mem_wbyte(i, fgetc(stateFile));
	}
	for(i=V810_GAME_RAM.lowaddr;i<=V810_GAME_RAM.highaddr;i++) {
		mem_wbyte(i, fgetc(stateFile));
        }         */
}

int debug_cheat_browse(void)
{
	cheat_load_db();

	while(1)
	{
		do_dialog(cheat_browse_dialog, -1);

		if(cheat_browse_dialog[4].flags&D_GOTFOCUS)
		{
			vb_cheats[0][cheat_browse_dialog[6].d1].enabled ^= 1;
		}

		else
		{
			break;
		}
	}

	if(cheat_browse_dialog[2].flags&D_GOTFOCUS)
	{
		cheat_unpatch_rom();
		cheat_copy_struct(0, 1);
		//cheat_show_struct(1,0);
		cheat_patch_rom();
	}

	//Clean up our leftover window image by telling other dialogs to redraw
	broadcast_dialog_message(MSG_DRAW, 0);
}

int debug_cheat_search_exact(void)
{
        WORD search_val = 0;
	char string1[64];

	do_dialog(cheat_search_exact_dialog, -1);

	if(cheat_search_exact_dialog[8].flags&D_GOTFOCUS) //Clicked Search Now
	{
		if(cheat_search_exact_dialog[3].flags&D_SELECTED)	//base 10
			search_val = strtoul(cht_sterm, (char**)NULL, 10);
		else if(cheat_search_exact_dialog[4].flags&D_SELECTED)	//base 16
			search_val = strtoul(cht_sterm, (char**)NULL, 16);

		cheat_search_exact(search_val);

		sprintf(string1, "%d results found (VB ram from %08X to %08X)", cheat_number_hits(), V810_VB_RAM.lowaddr, V810_VB_RAM.highaddr);
		alert(string1, "Continue searching to refine results.", NULL,  b_ok, NULL, 1, (int)NULL);
	}

	else if(cheat_search_exact_dialog[7].flags&D_GOTFOCUS) //Clicked Reset List
		cheat_reset_list();

	//Clean up our leftover window image by telling other dialogs to redraw
	broadcast_dialog_message(MSG_DRAW, 0);

}

int debug_cheat_search_comp(void)
{
	char string1[64];

	if (!cheat_old_ram_ready) {
		cheat_init_old_ram();
		cheat_save_old_ram();
		alert("Old RAM Saved.", "Resume play and return", "to search again.", b_ok, NULL, 1, (int)NULL);
	}
	else {
		do_dialog(cheat_search_comp_dialog, -1);

		if (cheat_search_comp_dialog[9].flags&D_GOTFOCUS) //Clicked Reset List
			cheat_reset_list();
		else if (cheat_search_comp_dialog[10].flags&D_GOTFOCUS) //Clicked Search Now
		{
			if(cheat_search_comp_dialog[3].flags&D_SELECTED)
				cheat_search_comp(CHT_EQL);

			else if(cheat_search_comp_dialog[4].flags&D_SELECTED)
				cheat_search_comp(CHT_GRT);

			else if(cheat_search_comp_dialog[5].flags&D_SELECTED)
				cheat_search_comp(CHT_GRE);

			else if(cheat_search_comp_dialog[6].flags&D_SELECTED)
				cheat_search_comp(CHT_NOT);

			else if(cheat_search_comp_dialog[7].flags&D_SELECTED)
				cheat_search_comp(CHT_LST);

			else if(cheat_search_comp_dialog[8].flags&D_SELECTED)
				cheat_search_comp(CHT_LSE);

			sprintf(string1, "%d results found.", cheat_number_hits());
			alert(string1, "Resume play and return", "to refine results.",  b_ok, NULL, 1, (int)NULL);
		}
	}

	broadcast_dialog_message(MSG_DRAW, 0);
}

int debug_cheat_search(void)
{
        char string1[64];
        char string2[64];
        char string3[64];

        WORD search_val=0;
        int results=0;

        do_dialog(cheat_search_dialog, -1);

        if(cheat_search_dialog[11].flags & D_GOTFOCUS) { //Clicked Search Now
            if(cheat_search_dialog[7].flags) //base 10
                search_val = strtoul(cht_sterm, (char**)NULL, 10);
            if(cheat_search_dialog[8].flags) //base 16
                search_val = strtoul(cht_sterm, (char**)NULL, 16);

            if(mem_list[0][0]) {   //Already have a search
                  cheat_search_byte(search_val, 1);
                  results = cheat_merge_lists();
            }

            else {
                  results = cheat_search_byte(search_val, 0);
            }

            sprintf(string1, "%d results found", results);
            sprintf(string2, "Search again to continue");
            sprintf(string3, "refining the results.");
            alert(string1, string2, string3, b_ok, NULL, 1, (int)NULL);
            cheat_results = results;
        }

        else if(cheat_search_dialog[12].flags & D_GOTFOCUS) {  //Clicked Reset List
            cheat_erase_list(0);
            cheat_erase_list(1);
        }

	//Clean up our leftover window image by telling other dialogs to redraw
	broadcast_dialog_message(MSG_DRAW, 0);

}

int debug_cheat_view(void)
{
        do_dialog(cheat_view_dialog, -1);

	//Clean up our leftover window image by telling other dialogs to redraw
	broadcast_dialog_message(MSG_DRAW, 0);
}

int debug_watchpoints(void)
{
	if (dbg_watchpt_en) watchpoint_dialog[4].flags = D_SELECTED;
	else watchpoint_dialog[4].flags = 0;

	sprintf(dbg_watchS, "%08X", dbg_wp_start);
	sprintf(dbg_watchE, "%08X", dbg_wp_end);

	do_dialog(watchpoint_dialog, -1);

	if (watchpoint_dialog[2].flags & D_GOTFOCUS) { //clicked OK
		//4th element is checkbox
		if (watchpoint_dialog[4].flags & D_SELECTED) dbg_watchpt_en = 1;
		else dbg_watchpt_en = 0;
		dbg_wp_start = strtoul(dbg_watchS, (char**)NULL, 16);
		dbg_wp_end   = strtoul(dbg_watchE, (char**)NULL, 16);
	}

	//Clean up our leftover window image by telling other dialogs to redraw
	broadcast_dialog_message(MSG_DRAW, 0);
}


int debug_write_info(void) {
	V810_PRNBUFF();
}

int debug_write_affine(void) {
	VB_PRN_AFFIN();
}

int debug_writebin(void)
{
	FILE *fpbin;
	WORD i;
	WORD start;
	WORD end;
	WORD tmp;

	do_dialog(writebin_dialog, -1);

	if(writebin_dialog[2].flags & D_GOTFOCUS) { //clicked OK
		start = strtoul(dbg_writeS, (char**)NULL, 16);
		end   = strtoul(dbg_writeE, (char**)NULL, 16);

		fpbin = fopen("vb.bin", "wb");

		if (writebin_dialog[9].flags & D_SELECTED) { //8-bit
			for (i=start;i<=end;i++) fputc(mem_rbyte(i)&0xFF,fpbin);
		}
		else if (writebin_dialog[10].flags & D_SELECTED) { //16-bit
			for (i=start;i<=end;i+=2) {
				tmp = mem_rhword(i);
				fputc((tmp>>8)&0xFF,fpbin);
				fputc(tmp&0xFF,fpbin);
			}
		}
		else if (writebin_dialog[11].flags & D_SELECTED) { //32-bit
			for (i=start;i<=end;i+=4) {
				tmp = mem_rword(i);
				fputc((tmp>>24)&0xFF,fpbin);
				fputc((tmp>>16)&0xFF,fpbin);
				fputc((tmp>>8)&0xFF,fpbin);
				fputc(tmp&0xFF,fpbin);
			}
		}

		fclose(fpbin);
	}

	//Clean up our leftover window image by telling other dialogs to redraw
	broadcast_dialog_message(MSG_DRAW, 0);
}
/*
int debug_memedit() {
	do_dialog(memory_edit_dialog, -1);

	broadcast_dialog_message(MSG_DRAW, 0);
}
*/
int debug_trace(void) {
	if (debuglog) {
		dbg_close_trace();
		debug_menu[0].flags = 0;
		debuglog=0;
#ifndef DBGLOGALL
		free(xlog);
#endif //DBGLOGALL
	}
	else {
		debug_menu[0].flags = D_SELECTED;
		debuglog=1;
#ifndef DBGLOGALL
		xlog = (unsigned char*)malloc(0x00100000);
		if (xlog == NULL) exit(1);
		memset(xlog,0,0x00100000);
#endif //DBGLOGALL
	}
}

int help_about(void) {
  alert(m_about1, m_about2, m_about3, b_ok, NULL, 1, (int)NULL);
}



void change_color(int index, int r, int g, int b)
{
   RGB col;

   col.r = r;
   col.g = g;
   col.b = b;

   vsync();

   set_color(index, &col);
}

void GUI_SetColors() {
/*
	//complete dialog list
	DIALOG main_dialog
	DIALOG input_dialog
	DIALOG options_dialog
	DIALOG watchpoint_dialog
	DIALOG writebin_dialog
	DIALOG cheat_view_dialog
	DIALOG cheat_browse_dialog
	DIALOG cheat_search_dialog
	DIALOG cheat_search_exact_dialog
	DIALOG cheat_search_comp_dialog
	DIALOG memory_edit_dialog
*/

	//restore original palette
	set_palette(default_palette);

	gui_mg_color = 253;
	gui_bg_color = 254;
	gui_fg_color = 255;
	change_color(252, 63,63,63);
	change_color(253, 32,32,32);
	change_color(254, 50,50,50);
	change_color(255, 0,0,0);
	set_dialog_color(main_dialog, 255,253);
	set_dialog_color(input_dialog, 255,254);
	set_dialog_color(options_dialog, 255,254);
	set_dialog_color(watchpoint_dialog, 255,254);
	set_dialog_color(writebin_dialog, 255,254);
	set_dialog_color(cheat_view_dialog, 255,254);
	set_dialog_color(cheat_browse_dialog, 255,254);
	set_dialog_color(cheat_search_dialog, 255,254);
	set_dialog_color(cheat_search_exact_dialog, 255,254);
	set_dialog_color(cheat_search_comp_dialog, 255,254);
//	set_dialog_color(memory_edit_dialog, 255,254);

	broadcast_dialog_message(MSG_DRAW, 0);
}

int StartGUI(int romload)
{
   guiop = GUISTATUS;

/*   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();
   set_gfx_mode(tVBOpt.SCR_MODE, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0);

   set_window_title(w_title);*/

   gui_mouse_focus = FALSE;

   GUI_SetColors();

   if(romload) { setMenu(1,1,1); }
   else { setMenu(0,0,0); }

   while(1) {
    if(guiop&GUISTATUS) { do_dialog(main_dialog, -1); }
    else { break; }
   }

   //if(guiop&AKILL) { allegro_exit(); }
   if(guiop&GUIEXIT) { return 1; }
   if(guiop&GUISTATUS) { return 2; }
   if(guiop&VBRESET) { return 2; }
   else { return 0; }
}

void setMenu(int a, int b, int c) {
    if(a==0) { file_menu[1].flags = D_DISABLED; }
    if(a==1) { file_menu[1].flags = 0; }

    if(b==0) { main_menu[2].flags = D_DISABLED; }
    if(b==1) { main_menu[2].flags = 0; }

    if(c==0) { main_menu[3].flags = D_DISABLED; }
    if(c==1) { main_menu[3].flags = 0; }
}

void writeValue(int Fvalue) {
   if(Fvalue==0) { fprintf(optionsFile, "0000\n"); }
   if((Fvalue>0) && (Fvalue<10)) { fprintf(optionsFile, "000%d\n", Fvalue); }
   if((Fvalue>=10) && (Fvalue<100)) { fprintf(optionsFile, "00%d\n", Fvalue); }
   if((Fvalue>=100) && (Fvalue<1000)) { fprintf(optionsFile, "0%d\n", Fvalue); }
   if(Fvalue>=1000) { fprintf(optionsFile, "%d\n", Fvalue); }
}

int writeHWORD(HWORD data, FILE *fout) {
	fputc((char)((data & 0xFF00)>>8), fout);
	fputc((char)(data & 0x00FF), fout);
	return 0;
}

HWORD readHWORD(FILE *fin) {
	HWORD returnval;

	returnval = fgetc(fin)<<8;
	returnval = returnval + fgetc(fin);

	return returnval;
}

void doOptions(void) {
	options_dialog[5].d2 = tVBOpt.FRMSKIP;
	options_dialog[7].d1 = tVBOpt.DSPMODE;
	options_dialog[12].d1 = tVBOpt.PALMODE;

	options_dialog[13].flags = (tVBOpt.DSPSWAP * D_SELECTED);

	options_dialog[14].flags = (tVBOpt.DSP2X * D_SELECTED);

	if (tVBOpt.SOUND) {
		options_dialog[9].flags = D_SELECTED;
		options_dialog[10].flags = 0;
	}
	else {
		options_dialog[9].flags = 0;
		options_dialog[10].flags = D_SELECTED;
	}

	do_dialog(options_dialog, -1);


	//Did they click OK?
	if (options_dialog[2].flags&D_GOTFOCUS) {
		tVBOpt.FRMSKIP = options_dialog[5].d2;
		tVBOpt.DSPMODE = options_dialog[7].d1;
		tVBOpt.PALMODE = options_dialog[12].d1;

		if (options_dialog[9].flags&D_SELECTED) {
			tVBOpt.SOUND = 1;
			if(vb_snd_init())		//Init sound, will not be done unless necessary
				alert("Non-fatal Error:", "Sound init failed!", "Sound will not be available", "Ok", NULL, 1, (int)NULL);
		}
		else {
			tVBOpt.SOUND = 0;
			vb_snd_remove();		//Uninstall sound
		}

		if (options_dialog[13].flags & D_SELECTED) tVBOpt.DSPSWAP = 1;
		else tVBOpt.DSPSWAP = 0;

		if (options_dialog[14].flags & D_SELECTED) tVBOpt.DSP2X = 1;
		else tVBOpt.DSP2X = 0;
	}

	//Clean up our leftover window image by telling other dialogs to redraw
	broadcast_dialog_message(MSG_DRAW, 0);
}

void doKeys(void) {
     int i=0,j=0,k=0,loop=1;
     int tempkey[15];

     //Copy vbkey to tempkey
     for(i=0;i<15;i++) { tempkey[i] = vbkey[i]; }

     while(loop) {
        //Set window caption text to appropriate key
        for(i=0;i<15;i++) { input_dialog[i*2+5].dp = keynames[tempkey[i]]; }

        do_dialog(input_dialog, -1);

        //Check if any buttons were pressed
        for(i=0;i<15;i++) {
           if(input_dialog[i*2+5].flags==5) {
              j=0;
              while(!j) {
                 //See if any keys were pressed
                 for(k=1;k<115;k++) {
                    if(key[k]) {
                       while(key[k]) { } //Wait for release
                       tempkey[i] = k;
                       j = 1;
                       k = 115;
                    }
                  }
               }
            }
        }

        //Did they click CANCEL?
        if(input_dialog[3].flags==5) { loop = 0; }

	//Did they click OK?
        if(input_dialog[2].flags==5) {
          //Copy tempkey to vbkey
          for(i=0;i<15;i++) { vbkey[i] = tempkey[i]; }
          loop = 0;
	}

    }
        //Clean up our leftover window image by telling other dialogs to redraw
	broadcast_dialog_message(MSG_DRAW, 0);
}


//custom dialog controls
int d_pushbutton_proc(int msg, DIALOG *d, int c) {
	switch (msg) {
		case MSG_CLICK:
			if ((d->flags & D_HIDDEN) || (d->flags & D_DISABLED)) return D_O_K;

			d->flags |= D_SELECTED;
			scare_mouse();
			d_button_proc(MSG_DRAW,d,c);
			unscare_mouse();

			while (gui_mouse_b()) broadcast_dialog_message(MSG_IDLE, 0); //wait for mouse button up

			d->flags &= ~D_SELECTED;
			scare_mouse();
			d_button_proc(MSG_DRAW,d,c);
			unscare_mouse();
			break;

		default:
			return d_button_proc(msg,d,c);
	}
	return D_O_K;
}



char *keynames[] = {
   "   ", " A ", " B ", " C ", " D ", " E ", " F ", " G ", " H ", " I ",
   " J ", " K ", " L ", " M ", " N ", " O ", " P ", " Q ", " R ", " S ",
   " T ", " U ", " V ", " W ", " X ", " Y ", " Z ", " 0 ", " 1 ", " 2 ",
   " 3 ", " 4 ", " 5 ", " 6 ", " 7 ", " 8 ", " 9 ", "0PD", "1PD", "2PD",
   "3PD", "4PD", "5PD", "6PD", "7PD", "8PD", "9PD", "F1 ", "F2 ", "F3 ",
   "F4 ", "F5 ", "F6 ", "F7 ", "F8 ", "F9 ", "F10", "F11", "F12", "ESC",
   " ~ ", " - ", " = ", "BKS", "TAB", " { ", " } ", "ENT", " : ", " \" ",
   " \\ ", " \\ ", " , ", " . ", " / ", "SPC", "INS", "DEL", "HOM", "END",
   "PGU", "PGD", "LFT", "RHT", "UP ", "DWN", "SPD", " * ", "-PD", "+PD",
   "DLP", "EPD", "PRT", "PAU", "ABN", "YEN", "KAN", "CON", "NCO", " @ ",
   "CRC", ":2 ", "KJI", "LSH", "RSH", "LCT", "RCT", "ALT", "ALG",
   "LWN", "RWN", "MNU", "SCR", "NUM", "CAP"
};


DIALOG cheat_search_exact_dialog[] =
{
 { d_shadow_box_proc, 5, 20, 305, 100,  255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,      150, 25, 0,    0, 255, 0, 0, 0, 0, 0, "Cheat Search (Exact Value)" },

 { d_text_proc,       10,  45,  0,   0, 255, 0, 0, 0, 0, 0, "Base:" },
 { d_radio_proc,      60,  46,  8,   6, 255, 0, 0, D_SELECTED, 1, 0, "10 (Dec)" },
 { d_radio_proc,      160, 46,  8,   6, 255, 0, 0, 0, 1, 0, "16 (Hex)" },

 { d_text_proc,       10,  65,  0,   0, 255, 0, 0, 0, 0, 0, "Search:" },
 { d_edit_proc,       80,  65, 60,   8, 255, 0, 0, 0, 5, 0, cht_sterm },

 { d_button_proc,     10,  85, 95,  15, 255, 0, 0, D_EXIT, 0, 0, "Reset List" },
 { d_button_proc,     110,  85, 95,  15, 255, 0, 0, D_EXIT, 0, 0, "Search Now" },
 { d_button_proc,     210,  85, 95,  15, 255, 0, 0, D_EXIT, 0, 0, "Cancel" },

 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }
};

DIALOG cheat_search_comp_dialog[] =
{
 { d_shadow_box_proc, 5, 20, 305, 110,  255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,      150, 25, 0,    0, 255, 0, 0, 0, 0, 0, "Cheat Search (Comparative)" },

 { d_text_proc,       10,  45,  0,   0, 255, 0, 0, 0, 0, 0, "New value is _____ than old value" },

 { d_radio_proc,      50,  65,  8,   6, 255, 0, 0, D_SELECTED, 1, 0, "=" },
 { d_radio_proc,     100,  65,  8,   6, 255, 0, 0, 0, 1, 0, ">" },
 { d_radio_proc,     150,  65,  8,   6, 255, 0, 0, 0, 1, 0, ">=" },
 { d_radio_proc,      50,  85,  8,   6, 255, 0, 0, 0, 1, 0, "!=" },
 { d_radio_proc,     100,  85,  8,   6, 255, 0, 0, 0, 1, 0, "<" },
 { d_radio_proc,     150,  85,  8,   6, 255, 0, 0, 0, 1, 0, "<=" },

 { d_button_proc,      10,  105, 95,  15, 255, 0, 0, D_EXIT, 0, 0, "Reset List" },
 { d_button_proc,     110,  105, 95,  15, 255, 0, 0, D_EXIT, 0, 0, "Search Now" },
 { d_button_proc,     210,  105, 95,  15, 255, 0, 0, D_EXIT, 0, 0, "Cancel" },

 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }
};


DIALOG cheat_search_dialog[] =
{
 { d_shadow_box_proc, 5, 20, 305, 160,  255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,      150, 25, 0,    0, 255, 0, 0, 0, 0, 0, "Cheat Search (Exact)" },

 { d_button_proc,    120,  150, 60, 15, 255, 0, 0, D_EXIT, 0, 0, b_ok },

 { d_text_proc,       10,  45,  0,   0, 255, 0, 0, 0, 0, 0, "Size:" },
 { d_radio_proc,      60,  46,  8,   6, 255, 0, 0, D_SELECTED, 0, 0, "8-bit" },
 { d_radio_proc,      160, 46,  8,   6, 255, 0, 0, 0, 0, 0, "16-bit" },

 { d_text_proc,       10,  65,  0,   0, 255, 0, 0, 0, 0, 0, "Base:" },
 { d_radio_proc,      60,  66,  8,   6, 255, 0, 0, D_SELECTED, 1, 0, "10 (Dec)" },
 { d_radio_proc,      160, 66,  8,   6, 255, 0, 0, 0, 1, 0, "16 (Hex)" },

 { d_text_proc,       10,  85,  0,   0, 255, 0, 0, 0, 0, 0, "Search:" },
 { d_edit_proc,       80,  85, 60,   8, 255, 0, 0, 0, 5, 0, cht_sterm },

//11
 { d_button_proc,     30, 105, 95,  15, 255, 0, 0, D_EXIT, 0, 0, "Search Now" },
 { d_button_proc,    170, 105, 95,  15, 255, 0, 0, D_EXIT, 0, 0, "Reset List" },

 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }
};

DIALOG watchpoint_dialog[] =
{
 { d_shadow_box_proc, 5, 20, 305, 160,  255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,      150, 25, 0,    0, 255, 0, 0, 0, 0, 0, "Watch Points" },

 { d_button_proc,     90,  150, 50, 15, 255, 0, 0, D_EXIT, 0, 0, b_ok },
 { d_button_proc,     160, 150, 75, 15, 255, 0, 0, D_EXIT, 0, 0, b_cancel },

 { d_check_proc,      10,  65,100,   8, 255, 0, 0, 0, 0, 0, "Enable" },
 { d_text_proc,       10,  85,  0,   0, 255, 0, 0, 0, 0, 0, "Start:" },
 { d_edit_proc,       80,  85, 80,   8, 255, 0, 0, 0, 8, 0, dbg_watchS },

 { d_text_proc,       10, 105,  0,   0, 255, 0, 0, 0, 0, 0, "End:" },
 { d_edit_proc,       80, 105, 80,   8, 255, 0, 0, 0, 8, 0, dbg_watchE },

 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }

};

DIALOG writebin_dialog[] =
{
 { d_shadow_box_proc, 5, 20, 305, 160,  255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,      150, 25, 0,    0, 255, 0, 0, 0, 0, 0, "Write to vb.bin" },

 { d_button_proc,     90,  150, 50, 15, 255, 0, 0, D_EXIT, 0, 0, b_ok },
 { d_button_proc,     160, 150, 75, 15, 255, 0, 0, D_EXIT, 0, 0, b_cancel },

 { d_text_proc,       10,  70,  0,   0, 255, 0, 0, 0, 0, 0, "Start:" },
 { d_edit_proc,       80,  70, 80,   8, 255, 0, 0, 0, 8, 0, dbg_writeS },

 { d_text_proc,       10, 80,  0,   0, 255, 0, 0, 0, 0, 0, "End:" },
 { d_edit_proc,       80, 80, 80,   8, 255, 0, 0, 0, 8, 0, dbg_writeE },

 { d_text_proc,       10, 100,  0,   0, 255, 0, 0, 0, 0, 0, "Data Size:" },
 { d_radio_proc,      20, 110,  8,   6, 255, 0, 0, D_SELECTED, 1, 0, "8-bit" }, /* 9 */
 { d_radio_proc,      100,110,  8,   6, 255, 0, 0, 0, 1, 0, "16-bit" },
 { d_radio_proc,      180,110,  8,   6, 255, 0, 0, 0, 1, 0, "32-bit" },

 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }

};


MENU main_menu[] =
{
   { "&File", NULL, file_menu, 0, NULL },
   { "&Options", NULL, options_menu, 0, NULL },
   { "&Emulation", NULL, emulation_menu, D_DISABLED, NULL },
   { "&Debug", NULL, debug_menu, D_DISABLED, NULL },
   { "&Help", NULL, help_menu, 0, NULL },
   { NULL,    NULL, NULL,      0, NULL }
};

MENU file_menu[] =
{
   { "&Load ROM",      file_loadrom,  NULL, 0,          NULL },
   { "&Close ROM",     file_closerom, NULL, D_DISABLED, NULL },
   { "",               NULL,          NULL, 0,          NULL },
   { "E&xit\tCtrl-X",  file_exit,     NULL, 0,          NULL },
   { NULL,             NULL,          NULL, 0,          NULL }
};

MENU options_menu[] =
{
   { "&Video", options_video, NULL, 0, NULL },
   { "&Input", options_input, NULL, 0, NULL },
   { "&Emulation", options_emulation, NULL, 0, NULL },
   { "", NULL, NULL, 0, NULL },
   { "&Save Options", options_saveoptions, NULL, 0, NULL },
   { NULL,     NULL,       NULL,  0, NULL }
};

MENU emulation_menu[] =
{
   { "&Resume Emulation", emulation_resume, NULL, 0, NULL },
   { "Rese&t System", emulation_reset, NULL, 0, NULL },
   { "", NULL, NULL, 0, NULL },
   { "&Cheats", NULL, emulation_cheat_menu, 0, NULL },
   { "", NULL, NULL, 0, NULL },
   { "&Save State", emulation_sstate, NULL, 0, NULL },
   { "Loa&d State", emulation_lstate, NULL, 0, NULL },
   { NULL, NULL, NULL, 0, NULL }
};


MENU debug_menu[] =
{
   { "&Trace Logging", debug_trace, NULL, 0, NULL },
   { "S&how ROM Info", debug_showinfo, NULL, 0, NULL },
   { "Show Dump Info", debug_dumpinfo, NULL, 0, NULL },
   { "&View", NULL, debug_view_menu, 0, NULL },
//   { "&Memory Viewer", debug_memedit, NULL, 0, NULL },
//   { "&Cheats", NULL, debug_cheat_menu, 0, NULL },
   { "Watch Points", debug_watchpoints, NULL, 0, NULL },
   { "Write Binary File", debug_writebin, NULL, 0, NULL },
   { "Write World\\VIP Info", debug_write_info, NULL, 0, NULL },
   { "Write Affine Info", debug_write_affine, NULL, 0, NULL },
//   { "&Write RAM to File", debug_saveram, NULL, 0, NULL },
   { NULL, NULL, NULL, 0, NULL }
};

MENU debug_view_menu[] =
{
   { "&Memory", debug_view_memory, NULL, 0, NULL },
   { "&Chars", debug_view_chars, NULL, 0, NULL },
   { "&BGMaps", debug_view_bgmaps, NULL, 0, NULL },
   { "&Worlds", debug_view_worlds, NULL, 0, NULL },
   { "&OBJs", debug_view_obj, NULL, 0, NULL },
   { NULL, NULL, NULL, 0, NULL }
};

MENU emulation_cheat_menu[] =
{
   { "Browse Cheats", debug_cheat_browse, NULL, 0, NULL },
//   { "Search (Old)", debug_cheat_search, NULL, 0, NULL },
   { "Search (Exact)", debug_cheat_search_exact, NULL, 0, NULL },
   { "Search (Comparative)", debug_cheat_search_comp, NULL, 0, NULL },
   { "View Results", debug_cheat_view, NULL, 0, NULL },

   { NULL, NULL, NULL, 0, NULL }
};

MENU help_menu[] =
{
   { "&About", help_about, NULL, 0, NULL },
   { NULL, NULL, NULL, 0, NULL }
};




DIALOG main_dialog[] =
{
   { d_clear_proc,    0,    0,    640,  480,  0,    0,    0,         0,      0,   0,   NULL },
   { d_menu_proc,     0,    0,    0,    0,    0,    0,    0,         0,      0,   0,   main_menu },
   { d_keyboard_proc, 0,    0,    0,    0,    0,    0,    ctrl('x'), 0,      0,   0,   file_exit },
   { d_killcheck_proc,0,    0,    0,    0,    0,    0,    0,         0,      0,   0,   NULL },
   { NULL,            0,    0,    0,    0,    0,    0,    0,         0,      0,   0,   NULL }
};

DIALOG input_dialog[] =
{
 { d_shadow_box_proc, 5, 20, 305, 180,  255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,      150, 25, 0,    0, 255, 0, 0, 0, 0, 0, "Input Keys" },

 { d_button_proc,     90,  170, 50, 15, 255, 0, 0, D_EXIT, 0, 0, b_ok },
 { d_button_proc,     160, 170, 75, 15, 255, 0, 0, D_EXIT, 0, 0, b_cancel },

 { d_text_proc,       10, 45,   0,   0, 255, 0, 0, 0, 0, 0, "L Up:" },
 { d_button_proc,     85, 45,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       10, 55,   0,   0, 255, 0, 0, 0, 0, 0, "L Down:" },
 { d_button_proc,     85, 55,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       10, 65,   0,   0, 255, 0, 0, 0, 0, 0, "L Left:" },
 { d_button_proc,     85, 65,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       10, 75,   0,   0, 255, 0, 0, 0, 0, 0, "L Right:" },
 { d_button_proc,     85, 75,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },

 { d_text_proc,       10, 95,   0,   0, 255, 0, 0, 0, 0, 0, "R Up:" },
 { d_button_proc,     85, 95,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       10, 105,   0,   0, 255, 0, 0, 0, 0, 0, "R Down:" },
 { d_button_proc,     85, 105,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       10, 115,   0,   0, 255, 0, 0, 0, 0, 0, "R Left:" },
 { d_button_proc,     85, 115,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       10, 125,   0,   0, 255, 0, 0, 0, 0, 0, "R Right:" },
 { d_button_proc,     85, 125,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },

 { d_text_proc,       150, 45,   0,   0, 255, 0, 0, 0, 0, 0, "Button A:" },
 { d_button_proc,     245, 45,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       150, 55,   0,   0, 255, 0, 0, 0, 0, 0, "Button B:" },
 { d_button_proc,     245, 55,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       150, 65,   0,   0, 255, 0, 0, 0, 0, 0, "Start:" },
 { d_button_proc,     245, 65,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       150, 75,   0,   0, 255, 0, 0, 0, 0, 0, "Select:" },
 { d_button_proc,     245, 75,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },

 { d_text_proc,       150, 95,   0,   0, 255, 0, 0, 0, 0, 0, "L Trigger:" },
 { d_button_proc,     245, 95,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },
 { d_text_proc,       150, 105,   0,   0, 255, 0, 0, 0, 0, 0, "R Trigger:" },
 { d_button_proc,     245, 105,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },

 { d_text_proc,       10, 145,   0,   0, 255, 0, 0, 0, 0, 0, "Low Battery:" },
 { d_button_proc,     150, 145,   30,  10, 255, 0, 0, D_EXIT, 0, 0, "   " },

 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }
};



DIALOG cheat_view_dialog[] =
{
 { d_shadow_box_proc, 5, 20, 235, 165,  255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,      120, 25, 0,    0, 255, 0, 0, 0, 0, 0, "View Results" },
 { d_text_proc,        40, 45, 0,    0, 255, 0, 0, 0, 0, 0, "Address   NEW OLD" },

 { d_button_proc,    87,  160,  60, 15, 255, 0, 0, D_EXIT, 0, 0, b_ok },
 { d_list_proc,      30,   55, 175,100, 255, 0, 0, 0,      0, 0, listbox_cheat },

 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }
};

DIALOG cheat_browse_dialog[] =
{
 { d_shadow_box_proc, 5,   20, 400,  160,  255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,      200, 25,   0,    0,  255, 0, 0, 0, 0, 0, "Browse Cheats" },

 { d_button_proc,     90,  150, 50, 15, 255, 0, 0, D_EXIT, 0, 0, b_ok },
 { d_button_proc,     160, 150, 75, 15, 255, 0, 0, D_EXIT, 0, 0, b_cancel },
 { d_button_proc,     270, 130, 75, 15, 255, 0, 0, D_EXIT, 0, 0, "Toggle" },

 { d_list_proc,	       15,  45,200,100, 255, 0, 0, 0,      0, 0, listbox_cheat_titles },
 { d_list_proc,	      220,  45,175, 80, 255, 0, 0, 0,      0, 0, listbox_cheat_cheats },


 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }
};

DIALOG options_dialog[] =
{
 { d_shadow_box_proc,5,   20,305,280, 255, 0, 0, 0, 0, 0, NULL },
 { d_ctext_proc,     150, 25,  0,  0, 255, 0, 0, 0, 0, 0, "Emulation Options" },

 { d_button_proc,    90, 270, 50, 15, 255, 0, 0, D_EXIT, 0, 0, b_ok },
 { d_button_proc,    160,270, 75, 15, 255, 0, 0, D_EXIT, 0, 0, b_cancel },

 { d_text_proc,       10, 45,  0,  0, 255, 0, 0, 0, 0, 0, "Frameskip:" },
 { d_slider_proc,    100, 45,100,  8, 255, 0, 0, 0, 9, 0, NULL, NULL },

 { d_text_proc,	      10, 65,  0,  0, 255, 0, 0, 0, 0, 0, "Display Mode:" },
 { d_list_proc,	      20, 75,200, 50, 255, 0, 0, 0, 0, 0, listbox_dspmode, NULL, NULL },

 { d_text_proc,	      10,135,  0,  0, 255, 0, 0, 0, 0, 0, "Sound:" },
 { d_radio_proc,      70,135,  8,  6, 255, 0, 0, 0, 0, 0, "On" },
 { d_radio_proc,     105,135,  8,  6, 255, 0, 0, 0, 0, 0, "Off"  },

 { d_text_proc,       10,155,  0,  0, 255, 0, 0, 0, 0, 0, "Palette:" },
 { d_list_proc,	      20,165,200, 50, 255, 0, 0, 0, 0, 0, listbox_palette, NULL, NULL },

 { d_check_proc,      10,225, 70,  8, 255, 0, 0, 0, 0, 0, "Swap 3D" },

 { d_check_proc,      10,245,160,  8, 255, 0, 0, 0, 0, 0, "Double Screen Size" },

 { NULL,	      0, 0, 0, 0,       255, 0, 0, 0, 0, 0, NULL }
};
/*
DIALOG memory_edit_dialog[] = {
	{ d_shadow_box_proc,   5, 20,305,250, 255, 0, 0, 0, 0, 0, NULL },
	{ d_ctext_proc,      150, 25,  0,  0, 255, 0, 0, 0, 0, 0, "Memory Viewer" },

	{ d_button_proc,      90,245, 50, 15, 255, 0, 0, D_EXIT, 0, 0, b_ok },
	{ d_button_proc,     160,245, 75, 15, 255, 0, 0, D_EXIT, 0, 0, b_cancel },

	{ d_text_proc,        10, 48,  0,  0, 255, 0, 0, 0, 0, 0, "Address:" },
	{ d_edit_proc,        90, 48, 80,  8, 255, 0, 0, 0, 8, 0, memed_addr },

	{ d_pushbutton_proc, 170, 45, 40, 15, 255, 0, 0, 0, 0, 0, "Go" },

	{ NULL,                0,  0,  0,  0, 255, 0, 0, 0, 0, 0, NULL }
};
*/
